#!/bin/sh
# 
# The LinknLook start & stop script
# Copyright (C) 2010-2011 DMSXI, Alpha Networks Inc. All Rights Reserced.
# Version: 1.01
# 

die() {
	echo $@
	exit 1
}

showUsage() {
	die "$0 {start|stop|restart} [prefix]"
}

pidof() {
  local lnldaemon=$1
  ps -e | grep "$lnldaemon" | grep -v 'grep' > /dev/null 2>&1 && ps -e | grep "$lnldaemon" | grep -v 'grep' | sed 's/admin.*//' | sed 's/^[ \t]*//;s/[ \t]*$//' | sed q
}

start() {
	local lnldaemon="$directory$1"

	echo -n "Startting $lnldaemon..."
	pid=$(pidof $lnldaemon) && { echo " $lnldaemon is already running." && return 1; }
  [ -x "$lnldaemon" ] || { echo " $lnldaemon is not a valid application" && return 1; }
  
	$lnldaemon > /dev/null 2> /dev/null &
	echo " ok."
}

stop() {
	local lnldaemon=$1
	echo -n "Stopping $lnldaemon..."
	pid=$(pidof $lnldaemon) || { echo " $lnldaemon is not running." && return 1; }
	kill $pid
	i=0
	for var in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20
	do
		sleep 1
		pid=$(pidof $lnldaemon) || { echo " ok." && return 0; }
		echo -n "."
	done
	killall -9 $lnldaemon && sleep 1 && pid=$(pidof $lnldaemon) && { echo " ng." && return 1; } || echo " force to kill ok."
}

status() {
	echo -n "transpeer"
	pid=$(pidof transpeer) && echo " is running." || echo " is stop."

	echo -n "godev"
	pid=$(pidof godev) && echo " is running." || echo " is stop."
}

action=$1
prefix=$2
end=$3

[ "$end" = "" ] && [ "$action" != "" ] || showUsage
[ "$prefix" = "" ] || [ -d "$prefix" ] || die "$prefix is not a valid directory"

directory=$prefix/lnl/

case $action in
	start)
		export LD_LIBRARY_PATH=$directory
		start godev
		start transpeer
	;;
	stop)
		stop transpeer
		stop godev
	;;
	reload)
		reload
	;;
	configure)
		configure
	;;
	restart)
		stop transpeer
		stop godev
		export LD_LIBRARY_PATH=$directory
		start godev
		start transpeer
	;;
	status)
		status
	;;
	*)
		showUsage
	;;
esac

exit 0
