/* vi: set sw=4 ts=4: */
/*
 * (C) Copyright 2008
 * David Hsieh, Alpha Networks, Inc. <david_hsieh@alphanetworks.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/* HTTP image loading support. */

#include <common.h>
#include <command.h>
#include <net.h>

#ifdef HTTPSVR_SUPPORT

int do_httpsvr(cmd_tbl_t * cmdtp, int flag, int argc, char * argv[])
{
	char * s;
	int size;

	debug("%s: argc = %d\n",__func__,argc);
	for (size=0; size<argc; size++) { debug("%s: %d:[%s]\n",__func__,size,argv[size]); }

	/* pre-set load_addr */
	if ((s = getenv("loadaddr")) != NULL)
		load_addr = simple_strtoul(s, NULL, 16);
	
	switch (argc)
	{
	case 1:
		break;
	case 2:
		/* only one arg - load address. */
		load_addr = simple_strtoul(argv[1], NULL, 16);
		break;
	default:
		printf("Usage:\n%s\n", cmdtp->usage);
		return 1;
	}

	printf("%s: loadaddr = 0x%08x\n",__func__,load_addr);
	/* Now go into the packet reading loop. */
	if ((size = NetLoop(HTTP)) < 0) {
		return 1;
	}
	/* */
	return 0;
}

U_BOOT_CMD(
	httpsvr, 3, 1, do_httpsvr,
	"httpsvr\t- Start HTTP server to load image\n",
	"[loadAddress]\n"
);

#endif
