/*******************************************************************************
#	 	luvcview: Sdl video Usb Video Class grabber.                               #
#This package work with the Logitech UVC based webcams with the mjpeg feature. #
#All the decoding is in user space with the embedded jpeg decoder              #
#.                                                                             #
# 		Copyright (C) 2005 2006 Laurent Pinchart &&  Michel Xhaard               #
#                                                                              #
# This program is free software; you can redistribute it and/or modify         #
# it under the terms of the GNU General Public License as published by         #
# the Free Software Foundation; either version 2 of the License, or            #
# (at your option) any later version.                                          #
#                                                                              #
# This program is distributed in the hope that it will be useful,              #
# but WITHOUT ANY WARRANTY; without even the implied warranty of               #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                #
# GNU General Public License for more details.                                 #
#                                                                              #
# You should have received a copy of the GNU General Public License            #
# along with this program; if not, write to the Free Software                  #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    #
#                                                                              #
*******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/select.h>
#include <linux/videodev.h>

#include "uvcvideo.h"
#include "ralink_gpio.h"
#include "frame.h"


#define	NB_BUFFER	4
#define DHT_SIZE	432



struct vdIn {
	int				fd;
	char				*videodevice;
	int				SensorID;
	struct v4l2_capability		cap;
	struct v4l2_format		fmt;
	struct v4l2_buffer		buf;
	struct v4l2_requestbuffers	rb;
	void				*mem[NB_BUFFER];
	unsigned char 			*framebuffer;
	int				isstreaming;
	int				grabmethod;
	int				width;
	int				height;
	int				fps;
	int				formatIn;
	int				framesizeIn;
	int				signalquit;
	int				framecount;
	unsigned long			MotionLastActiveTime;
	// uvc controls query
	struct v4l2_queryctrl		QueryBrightness;
	struct v4l2_queryctrl		QueryContrast;
	struct v4l2_queryctrl		QuerySaturation;
	struct v4l2_queryctrl		QueryQuality;
	// configuration data from flash
	int				CfgResolution;
	int				CfgCompressionRate;
	int				CfgFrameRate;
	int				CfgBrightness;
	int				CfgContrast;
	int				CfgSharpness;
	int				CfgSaturation;
	int				CfgLightFrequency;
	int				CfgMirror;
	int				CfgAntiFlickerEnable;
	int				CfgViewMode;
	int				CfgMotionEnable;
	int				CfgMotionBlockSet;
	int				CfgMotionSensitivity;
	//
	int				ChangeFlag;
};

#define IMAGE_RESOLUTION_QCIF	0
#define IMAGE_RESOLUTION_CIF	1
#define IMAGE_RESOLUTION_VGA	2
#define IMAGE_RESOLUTION_USER	0x100

#define IMAGE_COMPRESSION_RATE_VERY_LOW		0
#define IMAGE_COMPRESSION_RATE_LOW		1
#define IMAGE_COMPRESSION_RATE_MEDIUM		2
#define IMAGE_COMPRESSION_RATE_HIGH		3
#define IMAGE_COMPRESSION_RATE_VERY_HIGH	4

#define COMPRESSION_UP          0
#define COMPRESSION_DOWN        1
#define COMPRESSION_CHIP_MAX	2
#define COMPRESSION_CHIP_MIN	3
#define COMPRESSION_DEFAULT_MAX 4
#define COMPRESSION_DEFAULT_MIN 5
#define COMPRESSION_USER	6

#define	IMAGE_FLAG_MIRROR_H	0x01
#define	IMAGE_FLAG_MIRROR_V	0x02
#define IMAGE_FLAG_MONOCHROME	0x04

#define IMAGE_USER_RESOLUTION		0x0001
#define IMAGE_USER_COMPRESSION		0x0002
#define IMAGE_USER_FRAME_RATE		0x0004
#define IMAGE_USER_BRIGHTNESS		0x0008
#define IMAGE_USER_CONTRAST		0x0010
#define IMAGE_USER_HUE			0x0020
#define IMAGE_USER_LIGHT_FREQUENCY	0x0040
#define IMAGE_USER_SHARPNESS		0x0080
#define IMAGE_USER_IMAGE_FLAG		0x0100

#define IMAGE_CHANGE_FLAG_ANTI_FLICKER		0x01

int InitVideoIn(struct vdIn *Video, int SysInfoFD, char *Device, int Format, int Grabmethod);
int enum_controls(int vd);
int save_controls(int vd);
int load_controls(int vd);
	     
int uvcGrab(struct vdIn *vd);
int close_v4l2(struct vdIn *vd);

int v4l2GetControl(struct vdIn *vd, int control);
int v4l2SetControl(struct vdIn *vd, int control, int value);
int v4l2UpControl(struct vdIn *vd, int control);
int v4l2DownControl(struct vdIn *vd, int control);
int v4l2ToggleControl(struct vdIn *vd, int control);
int v4l2ResetControl(struct vdIn *vd, int control);
int v4l2ResetPanTilt(struct vdIn *vd,int pantilt);
int v4L2UpDownPan(struct vdIn *vd, short inc);
int v4L2UpDownTilt(struct vdIn *vd,short inc);
int v4L2UpDownPanTilt(struct vdIn *vd, short inc_p, short inc_t);
int v4l2SetLightFrequencyFilter(struct vdIn *vd,int flt);
int enum_frame_intervals(int dev, __u32 pixfmt, __u32 width, __u32 height);
int enum_frame_sizes(int dev, __u32 pixfmt);
int enum_frame_formats(int dev);

__s32 V4L2Read(struct vdIn *Video, __u32 V4L2id);
int V4L2Write(struct vdIn *Video, __u32 V4L2id, __s32 Value);
void SetVideoParameter(struct vdIn *Video,int SysInfoFD);
void SetImageParameter(struct vdIn *Video);

#define TEST_AEC_AGC_DISABLE	0	/* close julie:schedule.c ftp config event check */
