/*
 * MISC_XML
 */
#include <string.h>
#include <stdarg.h>
#include <netinet/in.h>
#include "upnp_types.h"
#include "http_pas.h"
#include "fmt_cvt.h"
#include "xml_dump.h"
#include "xml_enti.h"
#include "xml_tree.h"
#include "xml_ext.h"
#include "xml_mem.h"
#include "xml_dbg.h"
#include "misc_xml.h"
#include "dbgtrace.h"

char far XML_SPACE[2]=" ";
char far XML_DCOLON[3]="::";
char far XML_SCOLON[2]=":";
char far XML_SEMICOLON[2]=";";
//char far XML_CRLF[3]="\r\n";
char far XML_SLASH[2]="/";
char far XML_LAB[2]="<";
char far XML_RAB[2]=">";
char far XML_TEXT_XML[9]="text/xml";
char far XML_ASTERISK[2]="*";
char far XML_EQU[2]="=";
char far XML_ZERO[2]="0";
char far XML_LPB[2]="(";
char far XML_RPB[2]=")";
char far XML_DASH[2]="-";


int AddXmlElement(char *Element, char *value, char *str, int Encode)
{
    char EncodedValue[128];

    if (1 == Encode) {
        memset(EncodedValue, 0, sizeof(EncodedValue));
        UNITxmlEncodeEntities_R(value, EncodedValue, sizeof(EncodedValue)); 
    } else {
        strcpy(EncodedValue, value);
    }
    strcat(str, XML_LAB);
    strcat(str, Element);
    strcat(str, XML_RAB);
    strcat(str, EncodedValue);
    strcat(str, XML_LAB);
    strcat(str, XML_SLASH);
    strcat(str, Element);
    strcat(str, XML_RAB);
    return 0;
}

int GetXMLNodeValue(xmlNodePtr node, char *buf)
{
    char *content;
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UTL, UTL_DBG_MASK_MISC_XML,
                  "%s\r\n", "GetXMLNodeValue");

    if (node == NULL || buf == NULL) {
        return FAIL;
    }
    content = (char *)xmlNodeGetContent(node);
    if (content)
    {
        strcpy(buf, content); 
        xmlMemFree(content);
        content = NULL;
        status = PASS;
    } else {
        buf[0] = '\0';
        status = FAIL;
    }
    return status;
}

int GetXMLSpecificNode(xmlDocPtr doc, xmlNodePtr node, void **para1, void *para2)
{
    char *buf = (char *)para2;
    *para1 = NULL;

    if (!strcmp((char *)node->name, buf)) 
    {
        *para1 = (void *)node;
        return 1;
    }
    else
        return 0;
}

int TraverseChilds(xmlDocPtr doc, xmlNodePtr node, node_handler_t fctn, void **para1, void *para2, int all)
{
        return TraverseXMLTree(doc, node->childs, fctn, para1, para2, all);   
}

int TraverseXMLTree(xmlDocPtr doc, xmlNodePtr node, node_handler_t fctn, void **para1, void *para2, int all)
{
    int ret = 0;
    int found = 0;

    while (node)
    {
        ret=fctn(doc, node, para1, para2);
        if (ret == 1) {
            found = 1;
            if (all == 0) return found;
        }

        ret=TraverseChilds(doc, node, fctn, para1, para2, all);
        if (ret == 1) {
            found = 1;
            if (all == 0) return found;
        }
        node=node->next;
    }
    return found;
}

void UNITxmlEncodeEntities_R(const char *input, char *output, int len) 
{
    const char *cur = input;
    char *out;

    if (input == NULL || output == NULL) {
        return;
    }
    out = output; 
    while (*cur != '\0') {
        /*WHY 7? "&quot;" + '\0'*/
        if (out - output >= (len - 7)) {
            *out = 0;
            return;
        }
	/*
	 * By default one have to encode at least '<', '>', '"' and '&' !
	 */
	if (*cur == '<') {
	    *out++ = '&';
	    *out++ = 'l';
	    *out++ = 't';
	    *out++ = ';';
	} else if (*cur == '>') {
	    *out++ = '&';
	    *out++ = 'g';
	    *out++ = 't';
	    *out++ = ';';
	} else if (*cur == '&') {
	    *out++ = '&';
	    *out++ = 'a';
	    *out++ = 'm';
	    *out++ = 'p';
	    *out++ = ';';
	} else if (*cur == '"') {
	    *out++ = '&';
	    *out++ = 'q';
	    *out++ = 'u';
	    *out++ = 'o';
	    *out++ = 't';
	    *out++ = ';';
	} else if (*cur == '\'') {
	    *out++ = '&';
	    *out++ = 'a';
	    *out++ = 'p';
	    *out++ = 'o';
	    *out++ = 's';
	    *out++ = ';';
	//} else if (((*cur >= 0x20) && (*cur < 0x80)) ||
	} else if (((*cur >= 0x20) && (*cur < 0x7F)) ||
	    (*cur == '\n') || (*cur == '\r') || (*cur == '\t')) {
	    /*
	     * default case, just copy !
	     */
	    *out++ = *cur;
	} 
	cur++;
    }
    *out++ = 0;
    return;
}
