/*
 * FMT CONVERTER
 */
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "upnp_types.h"
#include <netinet/in.h>
#include "http_pas.h"
#include "xml_dump.h"
#include "xml_enti.h"
#include "xml_tree.h"
#include "xml_ext.h"
#include "xml_mem.h"
#include "dbgtrace.h"

unsigned long addr_ipatol(char *str, int checkip)
{
   unsigned long l;
   unsigned int  val;
   int   i;

   l = 0;
   for (i = 0; i < 4; i++)
   {
      l <<= 8;
      if (*str != '\0')
      {
         val = 0;
         while (*str != '\0' && *str != '.')
         {
            /*  error input  */
            if (*str > '9' || *str < '0')
               return 0;

            val *= 10;
            val += *str - '0';
            str++;
         }
         /*  error input  */
         if (val > 255)
            return 0;
         if (checkip == 1)
         {
            // xx.xx.xx.0 and xx.xx.xx.255
            if (i == 3 && (val == 255 || val == 0))
               return 0;
            // 127.xx.xx.xx and 0.xx.xx.xx
            if (i == 0 && (val == 127 || val == 0))
               return 0;
         }
         l |= val;
         if (*str == '\0')
            break;
         else
            str++;
      }
   }
   /*  error input  */
   if (i != 3)
      return 0;

   if (checkip && l >= 0xe0000000)
      return 0;
   if (l == 0xffffffff)
      return 0;
   return ntohl(l);
}

void addr_ipltoa(char * buff, unsigned long in)
{
   char *p;
   char *buf = buff;
   char tmp[4];
   int  len, i;

   p = (char *) &in;

   for (i = 0; i < 4; i++)
   {
       //NWitoa((*p & 255), (unsigned char *)tmp, 10);
       sprintf(tmp, "%d", (*p & 255));
       //NWitoa((*p & 255), &tmp, 10);
       len = strlen(tmp);
       memcpy(buf, tmp, len);
       buf += len;
       *buf ++ = '.';
       p++;
   }
   len = (int)(16-((--buf) - buff));
   for (i = 0; i < len; i++)
       *buf++ = '\0';

   return;
}

char * addr_strcpy(char * buf, char * source)
{
   unsigned int buflen = 20;

   if (strlen(source) < buflen)
      strcpy(buf,source);
   else
   {
      memcpy(buf,source,buflen-1);
      buf[buflen-1] = (char) NULL;
   }
   return(buf);
}

int addr_ipstrcpy(char *buf, unsigned long ip)
{
   char temp[20];

   memset(temp,0,20);
   addr_ipltoa(temp,ip);
   addr_strcpy(buf,temp);

   return(strlen(buf));
}

void HttpHeaderToUpper(char *header, int len)
{
    int i;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UTL, UTL_DBG_MASK_FMT_CVT,
                  "%s\r\n", "HttpHeaderToUpper");
    for ( i = 0; i < len; i++ )
    {
        header[i] = toupper( header[i] );
    }
}

int HexToBin(char *pBuf, int Len, char *out, int out_len)
{
    char *pTmpBuf;
    int i;
    char Byte;
    int odd;
    char data_unit[3];
    int ret = 1;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UTL, UTL_DBG_MASK_FMT_CVT,
                  "%s\r\n", "HexToBin");
    if ((Len / 2)+1 > out_len) {
        ret = 0;
        goto Exit;
    }
    pTmpBuf = (char *)out;
    if(1 == Len % 2) {
        odd = TRUE;
    } else {
        odd = FALSE;
    }
    if (TRUE == odd) {
        Byte = (char)strtoul(pBuf, NULL, 16);
        *pTmpBuf = Byte;
        //memset(pTmpBuf, Byte, 1);
        pBuf++;
        pTmpBuf++;
    }
    for (i = 0; i < Len/2; i++) {
        strncpy(data_unit, pBuf, 2);
        pBuf += 2;
        Byte = (char)strtoul(data_unit, NULL, 16);
        *pTmpBuf = Byte;
        //memset(pTmpBuf, Byte, 1);
        pTmpBuf++;
    }
Exit:
    return ret;
}

int BinToHex(char *pBuf, int Len, char *out)
{
    char TmpBuf[160];
    char *pTmpBuf;
    int i, j;
    int HByte, LByte;
    char Byte;
    //char Digit[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    char Digit[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    if(Len >= 80)
	Len = 80;
    if(Len <= 0)
	return 0;

    pTmpBuf = (char *)TmpBuf;
    i = 0;
    j = 0;
    while(i < Len)
    {
	Byte = pBuf[i];
	HByte = (int)((Byte & 0xf0) >> 4);
	LByte = (int)(Byte & 0x0f);
	pTmpBuf[j] = Digit[HByte];
	pTmpBuf[j+1] = Digit[LByte];

	i++;
	j += 2;
    }
    pTmpBuf[j] = 0;
    strcpy(out, pTmpBuf);
    return 0;
}
