#ifndef _DEBUG_
#define _DEBUG_

#define PASS    0 
#define FAIL    -1 


#define DBG_SERIAL     1
#define DBG_LAN        0


#define  DBG_LEVEL_DISABLE                       0               /*disable debug feature*/
#define  DBG_LEVEL_DEATH                         1               /*system is going to die*/
#define  DBG_LEVEL_CRITICAL                      2               /*system is unable to perform its functionality*/
#define  DBG_LEVEL_ERROR                         4               /*handled errors*/
#define  DBG_LEVEL_WARNING                       6               /*warning about abnormal situation*/
#define  DBG_LEVEL_TEST                          8               /*for temp test*/
#define  DBG_LEVEL_TRACE_FLOW                    10              /*trace showing the processing flow, could be routine entries*/
#define  DBG_LEVEL_TRACE_ENTRY                   11              /*trace for regular routine entries*/
#define  DBG_LEVEL_TRACE_INFO                    12              /*informational trace in regular routines*/
#define  DBG_LEVEL_VERBOSE                       24              /*say whatever you like, level 1*/
#define  DBG_LEVEL_DUMPING                       32              /*dumping everything*/

#define PROJ_DBG_MASK_UDEV              0x00000001
#define PROJ_DBG_MASK_UCP               0x00000002
#define PROJ_DBG_MASK_WCN               0x00000004
#define PROJ_DBG_MASK_XML               0x00000008
#define PROJ_DBG_MASK_HNAP              0x00000010
#define PROJ_DBG_MASK_UTL               0x00000020
#define PROJ_DBG_MASK_MEM               0x00000040

#define UCP_DBG_MASK_MAIN               0x00000001
#define UCP_DBG_MASK_UTL                0x00000002
#define UCP_DBG_MASK_CON                0x00000004
#define UCP_DBG_MASK_SRCH               0x00000008
#define UCP_DBG_MASK_OPENP              0x00000010
#define UCP_DBG_MASK_WANIP              0x00000020

#define HNAP_DBG_MASK_DEV               0x00000001
#define HNAP_DBG_MASK_CON               0x00000002
#define HNAP_DBG_MASK_API               0x00000004
#define HNAP_DBG_MASK_AU                0x00000008
#define HNAP_DBG_MASK_NCL               0x00000010
#define HNAP_DBG_MASK_UTL               0x00000020

#define MEM_DBG_MASK_TBL_MEM            0x10000000
#define MEM_DBG_MASK_STACK_MEM          0x20000000
#define MEM_DBG_MASK_AL_MEM_ERR         0x40000000
#define MEM_DBG_MASK_AL_MEM_C           0x80000000

#define UTL_DBG_MASK_SENDRECV           0x01000000
#define UTL_DBG_MASK_MISC_XML           0x02000000
#define UTL_DBG_MASK_FMT_CVT            0x04000000
#define UTL_DBG_MASK_BASE64             0x08000000

#define UDEV_DBG_MASK_EVENT             0x00000001
#define UDEV_DBG_MASK_INIT              0x00000002
#define UDEV_DBG_MASK_SERVER            0x00000004
#define UDEV_DBG_MASK_UTIL              0x00000008
#define UDEV_DBG_MASK_DISPATCH          0x00000010
#define UDEV_DBG_MASK_CONTROL           0x00000020
#define UDEV_DBG_MASK_DESCRIP           0x00000040
#define UDEV_DBG_MASK_IMG               0x00000080
#define UDEV_DBG_MASK_NULL              0x00000100
#define UDEV_DBG_MASK_MLISTEN		0x00000200

#define DBG_MASK_ALL                    0xFFFFFFFF

//typedef unsigned long ULONG;
typedef int(*dbg_test_t)(int count, void **paras);
int DEBUG_TestCode(unsigned long level, unsigned long proj, unsigned long file, dbg_test_t fctn, int count, ...);
int DEBUG_trace(ULONG level, ULONG proj, ULONG file, const char *format, ...);
void DEBUG_assert(char *format, ...);
#define upnpassert(p) ((p) ? (void)0 :(void) DEBUG_assert( \
                    "Assertion failed: %s, file %s, line %d", \
                    #p, __FILE__, __LINE__ ) )
#endif /*_DEBUG_*/
