/*
 * DBGTRACE.C 
 */
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include "upnp_types.h"
#include "dbgtrace.h"
#include "semaphore_api.h"

#define DBGTRACE_ENABLE 1 

extern int ucpdbg_sem_id;
extern int SerialDisplayBuf(char *pBuf, int Len);

#define DBG_MEM_SIZE        8192 

#define  DBG_IS_TRACEABLE(level, proj, mask)    ( (level <= DebugLevel) \
                                                && (((ProjMask) & (proj)) != 0) \
                                                && (((FileMask) & (file)) != 0) )

static ULONG   DebugLevel              = //DBG_LEVEL_DUMPING
                                      //DBG_LEVEL_TRACE_INFO
                                      //DBG_LEVEL_TRACE_FLOW
                                      DBG_LEVEL_CRITICAL
                                      ;
static ULONG   ProjMask                = //PROJ_DBG_MASK_MEM
                                      PROJ_DBG_MASK_UCP
                                       //PROJ_DBG_MASK_UDEV
                                      //PROJ_DBG_MASK_HNAP
                                      //| PROJ_DBG_MASK_UTL
                                      ;
static ULONG   FileMask               = MEM_DBG_MASK_AL_MEM_C
                                      | UCP_DBG_MASK_MAIN
                                      | UCP_DBG_MASK_SRCH
                                      //| UCP_DBG_MASK_OPENP
                                      //| UCP_DBG_MASK_WANIP
                                      //| UCP_DBG_MASK_CON
                                      //| UCP_DBG_MASK_UTL
                                      //| HNAP_DBG_MASK_DEV
                                      //| HNAP_DBG_MASK_CON
                                      //| HNAP_DBG_MASK_API
                                      //| HNAP_DBG_MASK_AU
                                      //| HNAP_DBG_MASK_NCL
                                      //| HNAP_DBG_MASK_UTL
                                      //| UTL_DBG_MASK_SENDRECV
                                      | UDEV_DBG_MASK_INIT
                                      | UDEV_DBG_MASK_DISPATCH
                                      | UDEV_DBG_MASK_MLISTEN
                                      //| UDEV_DBG_MASK_CONTROL
                                      //| UDEV_DBG_MASK_DESCRIP
                                      //| UDEV_DBG_MASK_EVENT
                                      //| UDEV_DBG_MASK_NULL
                                      //| UDEV_DBG_MASK_UTIL
                                      //| UDEV_DBG_MASK_HTTP_RD
                                      //| UDEV_DBG_MASK_IMG
                                      //| UDEV_DBG_MASK_SERVER
                                      | MEM_DBG_MASK_TBL_MEM
                                      | MEM_DBG_MASK_AL_MEM_ERR
                                      //| DBG_MASK_TEST
                                      ;

#if DBGTRACE_ENABLE
static char far dbg_mem[DBG_MEM_SIZE];

int DEBUG_TestCode(unsigned long level, unsigned long proj, unsigned long file, dbg_test_t fctn, int count, ...)
{
    int ret;
    int i;
    va_list ap;
    /*The max number of paramaters.
     *We can get the number by count, but we do not want to allocate
     *memory dynamiclly. So we set default to 10.
     */
    void *str[10];

    ret = 0;
    if (DBG_IS_TRACEABLE(level, proj, file) == TRUE) {
        va_start(ap, count);
        for (i = 0; i < count; i++) {
            str[i] = va_arg(ap, void *);
        }
        ret = fctn(count, str);
        va_end(ap);
    }
    return ret;
}

int DEBUG_trace(ULONG level, ULONG proj, ULONG file, const char *format, ...)
{
	int retval=0;
	va_list ap;
	char *out;

	if (DBG_IS_TRACEABLE(level, proj, file) == TRUE) {
		if (!semaphore_p(ucpdbg_sem_id)) exit(EXIT_FAILURE);
		out=dbg_mem;
		if (NULL != out) {
			memset(out, 0, sizeof(dbg_mem));
			va_start(ap, format);
			/*Paradigm has no vsnprintf()*/
			retval=vsprintf(out, format, ap);
			va_end(ap);
			if (retval > 0) {
#if DBG_SERIAL
				//SerialDisplayBuf(out, retval);
				printf("%s\n", out);
				fflush(NULL);
#elif DBG_LAN
				LanPrint(out, retval);
#endif
			}
		}
		if (!semaphore_v(ucpdbg_sem_id)) exit(EXIT_FAILURE);
	}
	return retval;
}

void DEBUG_assert(char *format, ...)
{
	int retval=0;
	va_list ap;
	char *out;

	if (!semaphore_p(ucpdbg_sem_id)) exit(EXIT_FAILURE);
	out=dbg_mem;
	if (NULL != out) {
		memset(out, 0, sizeof(dbg_mem));
		va_start(ap, format);
		/*We have no vsnprintf()*/
		retval=vsprintf(out, format, ap);
		va_end(ap);
		if (retval > 0) {
#if DBG_SERIAL
			//SerialDisplayBuf(out, retval);
			printf("%s\n", out);
			fflush(NULL);
#elif DBG_LAN
			LanPrint(out, retval);
#endif
		}
	}
	if (!semaphore_v(ucpdbg_sem_id)) exit(EXIT_FAILURE);
	abort();
}
#else
int DEBUG_TestCode(unsigned long level, unsigned long proj, unsigned long file, dbg_test_t fctn, int count, ...)
{
    return 0;
}

int DEBUG_trace(ULONG level, ULONG proj, ULONG file, const char *format, ...)
{
    return 0;
}
void DEBUG_assert(char *format, ...)
{
    return;
}
#endif

/* vim:set sw=4 sts=4 sta si expandtab: */
