#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <pthread.h>
#include "upnp_types.h"
#include "fmt_cvt.h"
#include "upnp.h"
#include "upnp_utl.h"
#include "ad.h"
#include "mlisten.h"
#include "event.h"
#include "dispatch.h"
#include "descrip.h"
#include "control.h"
#include "upnp_dev.h"
#include "upnp_wra.h"
#include "xml_mem.h"
#include "semaphore_api.h"
#include "dbgtrace.h"
#include "ralink_gpio.h"
#include "readsysinfo.h"
#include "nvram.h"
//#include "ucp.h"

extern int SerialDisplayBuf(char *pBuf, int Len);
extern int SerialDisplayHex(char *pBuf, int Len);

int RadiusAuthClient(char *username, char *password, unsigned long port);
static int VerifySecondPort(void);

unsigned short port_number = 80;

char far IGD[]="urn:schemas-upnp-org:device:InternetGatewayDevice:1\r\n";
char far PPP_CONN[]="urn:schemas-upnp-org:service:WANPPPConnection:1";
char far IP_CONN[]="urn:schemas-upnp-org:service:WANIPConnection:1";

char far MULTI_HOST[29]="HOST: 239.255.255.250:1900\r\n";
char far SERVER[30]="SERVER: Cellvision UPnP/1.0\r\n";
char far HTTP200[18]="HTTP/1.1 200 OK\r\n";
char far NOTIFY[20]="NOTIFY * HTTP/1.1\r\n";
char far SEARCH[22]="M-SEARCH * HTTP/1.1\r\n";
char far AGENT[53]="Mozilla/4.0 (compatible; UPnP/1.0; Windows NT/5.1)\r\n";

char far BYEBYE_NONTS[12]="ssdp:byebye";
char far BYEBYE[19]="NTS: ssdp:byebye\r\n";
char far ALIVE[18]="NTS: ssdp:alive\r\n";
char far ALL[11]="ssdp:all\r\n";
char far DISCOVER[16]="ssdp:discover\r\n";

char far UPNP_OS_VER[11]="Cellvision";
char far UPNP_VER[9]="UPnP/1.0";
char far UPNP_HTTP_VER[9]="HTTP/1.1";
char far UPNP_HTTP_VER_10[9]="HTTP/1.0";
char far UPNP_OK[3]="OK";

char far M_NOTIFY[7]="NOTIFY";
char far M_GET[4]="GET";
char far M_POST[5]="POST";

char far H_SERVER[7]="SERVER";
char far H_HOST[5]="HOST";
char far H_SID[4]="SID";
char far H_SEQ[4]="SEQ";
char far H_EXT[4]="EXT";
char far H_CALLBACK[9]="CALLBACK";
char far H_TIMEOUT[8]="TIMEOUT";
char far H_NT[3]="NT";
char far H_NTS[4]="NTS";
char far H_ST[3]="ST";
char far H_USN[4]="USN";
char far H_CACHE[14]="CACHE-CONTROL";
char far H_LOCATION[9]="LOCATION";
char far H_CONN[11]="CONNECTION";
char far H_CONTENT_TYPE[13]="CONTENT-TYPE";
char far H_CONTENT_LEN[15]="CONTENT-LENGTH";
char far H_MAN[4]="MAN";
char far H_MX[3]="MX";
char far H_ACCEPT[7]="ACCEPT";
char far H_USER_AGENT[11]="USER-AGENT";
char far H_SOAPACTION[11]="SOAPACTION";

char far UPNP_UPNP[5]="upnp";
char far UPNP_EVENT[11]="upnp:event";
char far UPNP_PROPCHANGE[16]="upnp:propchange";
char far UPNP_ROOT[16]="upnp:rootdevice";
char far UPNP_TEXT_XML[9]="text/xml";
char far UPNP_APP_XML[16]="application/xml";
char far UPNP_CHARSET[8]="charset";
char far UPNP_UTF_8[8]="\"utf-8\"";
char far UPNP_CLOSE[6]="CLOSE";
char far UPNP_KEEP_ALIVE[11]="KEEP-ALIVE";

char far UPNP_ASTERISK[2]="*";
char far UPNP_SPACE[2]=" ";
char far UPNP_DCOLON[3]="::";
char far UPNP_SCOLON[2]=":";
char far UPNP_SEMICOLON[2]=";";
char far UPNP_EQU[2]="=";
char far UPNP_ZERO[2]="0";
char far UPNP_CRLF[3]="\r\n";
char far UPNP_SLASH[2]="/";
char far UPNP_LAB[2]="<";
char far UPNP_RAB[2]=">";
char far UPNP_LPB[2]="(";
char far UPNP_RPB[2]=")";
char far UPNP_COMMA[2]=",";
char far UPNP_HASH[2]="#";
char far UPNP_QUOTE_DBL[2]="\"";
char far UPNP_DASH[2]="-";

char far UPNP_SEC[8]="Second-";
char far UPNP_MAX_AGE[8]="max-age"; 
char far UPNP_UUID[5]="uuid";

char far UPNP_NS_ANY[2]="e";
char far UPNP_NS_U[2]="u";
char far UPNP_PROPERTY[11]="e:property";
char far UPNP_PROPSET[14]="e:propertyset";
char far UPNP_NS_EVENT[41]="xmlns:e=\"urn:schemas-upnp-org:event-1-0\"";
char far UPNP_NS[6]="xmlns";
char far UPNP_1[2]="1";
char far UPNP_0[2]="0";


char far UPNP_SCHEMAS_CTRL[]="urn:schemas-upnp-org:control-1-0";
char far UPNP_SCHEMAS_EVENT[]="urn:schemas-upnp-org:event-1-0";
char far UPNP_QUERY[19]="QueryStateVariable";
char far UPNP_VARNAME[8]="varName";


char far XML_DECL[22]="<?xml version=\"1.0\"?>";
char far XML_ENCODING[9]="encoding";

char far UPNP_SOAP_S[133]=
                "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\""
                " s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">"
                "<s:Body>";
char far UPNP_SOAP_E[23]="</s:Body>"
            "</s:Envelope>";

char far UPNP_Q_SST_S[82]="<u:QueryStateVariableResponse xmlns:u=\"urn:schemas-upnp-org:control-1-0\">"
                    "<return>";

char far UPNP_Q_SST_E[41]="</return>"
                "</u:QueryStateVariableResponse>";

char far UPNP_HTTP_SCHEME[5]="http";
char far UPNP_DISPATCH_PORT[5]="8000";


#if 0
struct FGProcessStructure UPnPFGProcessNode;
struct FGProcessStructure UCPFGProcessNode;
#endif

char far UPnPRecvBuf[UPNP_RECV_BUF_SIZE];
char far UPnPSendBuf[UPNP_SEND_BUF_SIZE];

int upnp_close()
{
    return 0;
}

int UPnPFGProcessInit(void)
{
    int returnStatus = UPNP_SUCCESS;

    /*UPNP INIT*/   
    if (UPnPDispatcherInit())
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }

    if (UPnPDevInit())
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }
    if (UPnPAdInit())
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }
    if (UPnPMultiListenInit())
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }
    UPnPSetIP(UpnpIP);
    //UPnPDev();
Exit:
    if (returnStatus!=UPNP_SUCCESS)
    {
        //UnRegisterForgroundProcess((struct FGProcessStructure *)used);
    }
    return returnStatus;
}

int UPnPFGProcess()
{
    //UPnPDev();
    //UPnPAd();
    //UPnPMultiListen2();
    //UPnPDispatcher();
    //UPnPEvent();
    return 0;
}

#if 1
int UDEVGetDeviceInfo(void)
{
    upnp_read_sysinfo(sizeof(UpnpIP), (char *)&UpnpIP, UPNP_IP);
    //printf("UpnpIP = %x\n", UpnpIP);
    VerifySecondPort();
    return 0;
}

#else
int UDEVGetDeviceInfo(void)
{
    struct ifreq   buffer[32];
    struct ifconf  intfc;
    struct ifreq  *pIntfc;
    int            i, fd, num_intfc;

    intfc.ifc_len = sizeof(buffer);
    intfc.ifc_buf = (char*) buffer;

    if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
    {
        perror("socket() failed");
        return 1;
    }

    if (ioctl(fd, SIOCGIFCONF, &intfc) < 0)
    {
        perror("ioctl SIOCGIFCONF failed");
        return 1;
    }

    pIntfc    = intfc.ifc_req;
    num_intfc = intfc.ifc_len / sizeof(struct ifreq);

    for (i = 0; i < num_intfc; i++)
    {
        struct ifreq *item = &(pIntfc[i]);
#if 0
        printf("Interface # %d -> %s: IP %s, %x\n",
                i, item->ifr_name,
                inet_ntoa(((struct sockaddr_in *)&item->ifr_addr)->sin_addr), 
                (((struct sockaddr_in *)&item->ifr_addr)->sin_addr).s_addr);
#endif
        if (0x0100007f != (unsigned int)((((struct sockaddr_in *)&item->ifr_addr)->sin_addr).s_addr)) {
            UpnpIP = (unsigned int)((((struct sockaddr_in *)&item->ifr_addr)->sin_addr).s_addr);
        }
    }
    return 0;
#if 0
    //unsigned long store;
    char tmp[20];
    struct hostent *hp;
    struct in_addr a;
    char **addrs;
    char *myIP;

    //const char *hostname = nvram_bufget(RT2860_NVRAM, "HostName");
    char hostname[64];
    gethostname(hostname,sizeof hostname);

    printf("hostname = %s\n", hostname);
    hp = gethostbyname(hostname);

    if (hp) {
        addrs = hp->h_addr_list;
        while (*addrs)
        {
            printf("test 2\n");
            bcopy(*addrs++, (char *) &a, sizeof(a));
            printf("address: %s\n", inet_ntoa(a));
            fflush(NULL);
        }
    }

    // get self IP address
    myIP = inet_ntoa(*((struct in_addr *)hp->h_addr));
    printf("myIP = %s\n", myIP);


    UpnpIP = a.s_addr;
    addrs = hp->h_addr_list;
    bcopy(*addrs++, (char *) &a, sizeof(a));
    memset(tmp, 0, 20);
    strcpy(tmp, inet_ntoa(a));
    return 0;
#endif
}
#endif


static int VerifySecondPort(void)
{
    char *SecondHTTPPort = nvram_bufget(RT2860_NVRAM, "SecondHTTPPort");

    if (SecondHTTPPort) {
        port_number = atoi(SecondHTTPPort);
    } else {
        port_number = 80;
    }

    nvram_close(RT2860_NVRAM);

    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_INIT,
                  "port_number = %d\r\n", port_number);
    return 0;
}

int main()
{
    struct itimerval delay;
    int ret;
    struct sigaction act;
    //struct sigaction ad_bye;

    int res;
    pthread_t a_thread;
    pthread_t b_thread;
    void *thread_result;
    char UPnPEnable[8];


    ALInitializeMemAllocMonitor();
    xmlMemInit();
    semaphore_init();
    UDEVGetDeviceInfo();
    UPnPFGProcessInit();

    memset(UPnPEnable, 0, sizeof UPnPEnable);
    strcpy(UPnPEnable, nvram_bufget(RT2860_NVRAM, "UPnPEnable"));
    nvram_close(RT2860_NVRAM);
#if 0 
    ad_bye.sa_handler = UPnPAdBye;
    sigemptyset(&ad_bye.sa_mask);
    ad_bye.sa_flags = 0;
    sigaction(SIGUSR1, &ad_bye, 0);
#endif
 
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_INIT,
                  "%s, UPnPEnable = %s\r\n", __FUNCTION__, UPnPEnable);
    
    if (!strcmp(UPnPEnable, "0")) {
        UPnPAdBye(99999);
    } else {
        UPnPAd(99999);
        UPnPAd(99999);
        act.sa_handler = UPnPAd;
        sigemptyset(&act.sa_mask);
        act.sa_flags = 0;
        sigaction(SIGALRM, &act, 0);
        delay.it_value.tv_sec = 1;
        delay.it_value.tv_usec = 0;
        delay.it_interval.tv_sec = RESEND_AD_DURATION;
        delay.it_interval.tv_usec = 0;
        ret = setitimer (ITIMER_REAL, &delay, NULL);
        if (ret) {
            perror ("setitimer");
            return -1;
        }

        signal(SIGPIPE, SIG_IGN);
        res = pthread_create(&a_thread, NULL, UPnPMultiListen2, NULL);
        if (res != 0) {
            perror("Thread creation failed");
            exit(EXIT_FAILURE);
        }

        res = pthread_create(&b_thread, NULL, UPnPDispatcher, NULL);
        if (res != 0) {
            perror("Thread creation failed");
            exit(EXIT_FAILURE);
        }

        //printf("Waiting for thread to finish...\n");
        res = pthread_join(a_thread, &thread_result);
        if (res != 0) {
            perror("Thread join failed");
            exit(EXIT_FAILURE);
        }

        res = pthread_join(b_thread, &thread_result);
        if (res != 0) {
            perror("Thread join failed");
            exit(EXIT_FAILURE);
        }
    }
    return 0;
}
/* vim:set sw=4 sts=4 sta si expandtab: */
