//#include "C:\Paradigm\Source\Rtl\RtlInc\_farfunc.h"
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sched.h>
#include <errno.h>
#include "upnp_types.h"
#include "fmt_cvt.h"
#include "upnp.h"
#include "dispatch.h"
#include "http_pas.h"
#include "upnp_wra.h"
#include "upnp_utl.h"

extern int SerialDisplayBuf(char *pBuf, int Len);
extern int SerialDisplayHex(char *pBuf, int Len);
extern int LanPrint(char * buf,  int len);
extern int check_conn(int fd);

char TCPReadLine[UPNP_HTTP_LINE_LEN];
char TCPReadBuf[UPNP_READ_BUF];

//typedef int(*handler_t)(PUPNP_DEVICE, void *, void *);
int TraverseDevices(PUPNP_DEVICE Device, handler_t fctn, void *para1, void *para2);

#if 0
int UPnPDumpSerial(int val, char *buf)
{
    char tmp[32];
    //NWitoa(val, tmp, 10);
    sprintf(tmp, "%d", val);
    strcat((char *)tmp, buf);
    SerialDisplayBuf((char *)tmp, strlen((char *)tmp));

    return 0;
}

int UPnPDumpLan(int val, char *buf)
{
    unsigned char tmp[32];
    NWitoa(val, tmp, 10);
    strcat((char *)tmp, buf);
    //LanPrint((char *)tmp, strlen((char *)tmp));

    return 0;
}
#endif

int parse_url(http_header *list, CALLBACK_ADDR *Callback)
{
    char *buf=list->value.buff;
    char *tmp;
    int returnStatus=UPNP_SUCCESS;
    int i;
    int copy_len;

    tmp=strstr(buf, "http://");
    if (tmp !=NULL)
    {
        tmp=tmp+7;
        for (i=0; tmp[i]!=':' && (tmp-buf+1+i)<=list->value.size ; i++);

        if (i>15) copy_len=15;
        else copy_len=i;

        strncpy(Callback->IP, tmp, copy_len);
        Callback->IP[copy_len]='\0';

        tmp=tmp+i+1;
        for (i=0; tmp[i]>='0' && tmp[i]<='9' && (tmp-buf+1+i)<=list->value.size ; i++);

        if (i>5) copy_len=5;
        else copy_len=i;

        strncpy(Callback->Port, tmp, copy_len);
        Callback->Port[copy_len]='\0';

        //tmp=tmp+i+1;
        tmp=tmp+i;
        for (i=0; tmp[i]!='>' && (tmp-buf+1+i)<=list->value.size ; i++);

        if (i>63) copy_len=63;
        else copy_len=i;

        strncpy(Callback->Path, tmp, copy_len);
        Callback->Path[copy_len]='\0';
    }
    else
        returnStatus=UPNP_FAILURE;

    return returnStatus;
}

int parse_xml_xURL(char *buf, CALLBACK_ADDR *Callback)
{
    int status;
    char *tmp;
    int i;
    int copy_len;

    tmp=strstr(buf, "http://");
    if (NULL == tmp) {
        status = UPNP_FAILURE;
        tmp = buf;
    } else {
        tmp=tmp+7;
        for (i=0; tmp[i]!=':' && tmp[i]!='/' && tmp[i]!='\0'; i++)
            ;
        if (i>15) copy_len=15;
        else copy_len=i;
        strncpy(Callback->IP, tmp, copy_len);
        Callback->IP[copy_len]='\0';

        if (tmp[i]==':') {
            tmp=tmp+i+1;
            for (i=0; tmp[i]>='0' && tmp[i]<='9'; i++)
                ;
            if (i>5) copy_len=5;
            else copy_len=i;
            strncpy(Callback->Port, tmp, copy_len);
            Callback->Port[copy_len]='\0';
        } else if (tmp[i]=='/') {
            tmp=tmp+i;
        }
        status = UPNP_SUCCESS;
    }
    for (i=0; tmp[i]!='\0'; i++)
        ;
    if (i>63) copy_len=63;
    else copy_len=i;
    strncpy(Callback->Path, tmp, copy_len);
    Callback->Path[copy_len]='\0';
    return status;
}

int parse_callback_value(char *buf, CALLBACK_ADDR *Callback)
{
    char *tmp;
    int i;
    int returnStatus=UPNP_SUCCESS;
    int copy_len;

    tmp=strstr(buf, "http://");
    if (tmp!=NULL)
    {
        tmp=tmp+7;
        for (i=0; tmp[i]!=':'; i++);

        if (i>15) copy_len=15;
        else copy_len=i;

        strncpy(Callback->IP, tmp, copy_len);
        Callback->IP[copy_len]='\0';

        tmp=tmp+i+1;
        for (i=0; tmp[i]>='0' && tmp[i]<='9'; i++);
        //for (i=0; tmp[i]!='/'; i++);
        
        if (i>5) copy_len=5;
        else copy_len=i;

        strncpy(Callback->Port, tmp, copy_len);
        Callback->Port[copy_len]='\0';

        //tmp=tmp+i+1;
        tmp=tmp+i;
        for (i=0; tmp[i]!='>' && tmp[i]!='\0'; i++);

        if (i>63) copy_len=63;
        else copy_len=i;

        strncpy(Callback->Path, tmp, copy_len);
        Callback->Path[copy_len]='\0';
    }
    else
        returnStatus=UPNP_FAILURE;

    return returnStatus;
}

#if 0
int UPnPSendTo(int fd, void * buff, int len, unsigned flags,
       struct sockaddr *addr, int addr_len)
{
    int out=0;
    while(1)
    {
        out=sendto(fd, buff, len, flags, (struct sockaddr *)addr, addr_len);
        if (out==len) 
            return 0;
        else if (out==-22)
            return out;
        else
            POSEThreadYield();
    }
}
#endif

int UPnPSend(int fd, char *buf)
{
    char *tmp=buf;
    nint16 buf_len=strlen(buf);
    nint16 out;

    while(1)
    {
        out=send(fd, tmp, buf_len, 0);
 
        if ( (nint16)out == buf_len )
        {
            return 1;
        }
        else if ( out > 0 )
        {
            tmp=tmp+out;
            buf_len=buf_len-out;
            sched_yield();
            //POSEThreadYield();
        } else if (-1 == out) {
            if (errno == EINTR) {
                perror("UPnPSend send error 1");
                break;
            } else {
                perror("UPnPSend send error 2");
                break;
            }
        }
    }
    return 0;
}

int GetChar(int fd, char *tmpbuf, int *offset, int *len, char *c)
{
    if (*offset >= *len)
    {
        do
        {
            sched_yield();
            //POSEThreadYield();
            memset(tmpbuf, 0, UPNP_READ_BUF);
            //*len = recv(fd, tmpbuf, UPNP_READ_BUF, 0);
            *len = recv(fd, tmpbuf, UPNP_READ_BUF-3, 0);
            if (*len==-22)
            {
                //SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayBuf("rcl", 3);
                //SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayHex((char *)&fd, 2);
                //SerialDisplayBuf(UPNP_CRLF, 2);
                return *len;
            }
        }while (*len<=0);
        *offset=0;
    }

    *c=tmpbuf[*offset];
    (*offset)++;
    return 1;
}

#if 0 
int ReadBodyUnknownLen(int fd, char *buf, char *tmpbuf)
{
    int len=0;  
    int ret=0;
    int len2=0;

    while(len==0)
    {
        //POSEThreadYield();
        memset(tmpbuf, 0, UPNP_READ_BUF);
        len = recv(fd, tmpbuf, UPNP_READ_BUF-1, 0);
        if (len >0)
        {
            //SerialDisplayBuf(tmpbuf, strlen(tmpbuf));
            len2=strlen(tmpbuf);
            //SerialDisplayBuf(UPNP_CRLF, 2);
            //SerialDisplayHex((char *)&len2, 2);
            //SerialDisplayBuf(UPNP_CRLF, 2);
            //SerialDisplayBuf("TG", 3);
            //SerialDisplayHex((char *)&len, 2);
            //SerialDisplayBuf(UPNP_CRLF, 2);
            strcat(buf, tmpbuf);
            len=0;
        }
        else if (len==-5)
        {
            //SerialDisplayBuf("Y", 2);
            //SerialDisplayHex((char *)&len, 2);
            //SerialDisplayBuf(UPNP_CRLF, 2);
            ret = check_conn(fd);
            if (ret == -1 ) return 0;
        }
        else if (len<0)
        {
            //SerialDisplayBuf("Z", 2);
            //SerialDisplayHex((char *)&len, 2);
            //SerialDisplayBuf(UPNP_CRLF, 2);
            return 0; 
        }
        else
        {
            //SerialDisplayBuf("W", 2);
            //SerialDisplayHex((char *)&len, 2);
            //SerialDisplayBuf(UPNP_CRLF, 2);
            ret = check_conn(fd);
            if (ret == -1 ) return 0;
        }
    }
    return 0;
}
#endif

int ReadBody(int fd, char *tmpbuf, int *offset, int *len, char *body, 
                int body_len)
{
    int dataLeft;
    int copyLen;
    int what;

    if(body_len<=0) return 0;

    if (*offset >= *len)
    {
        do
        {
            memset(tmpbuf, 0, UPNP_READ_BUF);
            sched_yield();
            //POSEThreadYield();
            *len = recv(fd, tmpbuf, UPNP_READ_BUF-3, 0);
            if (*len==-5)
            {
                //SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayBuf("t-5", 3);
                //SerialDisplayBuf(UPNP_CRLF, 2);
                return *len;
            }
            if (*len==-22) 
            {
                //SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayBuf(tmpbuf, strlen(tmpbuf));
                //SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayBuf("t-22", 4);
                //SerialDisplayBuf(UPNP_CRLF, 2);
                return *len;
            }
            if (*len>0)
            {
                what=strlen(tmpbuf);
                ////SerialDisplayBuf(UPNP_CRLF, 2);
                ////SerialDisplayBuf(tmpbuf, strlen(tmpbuf));
                ////SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayBuf("t>0", 3);
                //SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayHex((char *)len, 2);
                //SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayHex((char *)&what, 2);
                //SerialDisplayBuf(UPNP_CRLF, 2);
            }
            if (*len==0)
            {
                //SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayBuf(tmpbuf, strlen(tmpbuf));
                //SerialDisplayBuf(UPNP_CRLF, 2);
                //SerialDisplayBuf("t==0", 4);
                //SerialDisplayBuf(UPNP_CRLF, 2);
            }

        }while (*len<=0);
        *offset=0;
    }
    dataLeft=*len-*offset;

    if (body_len < dataLeft)
    {
        copyLen=body_len;
    }
    else
    {
        copyLen=dataLeft;
    }
    strncpy(body, &tmpbuf[*offset], copyLen);

    *offset=*offset+copyLen;

    return copyLen;
}

int ReadLine(int fd, char *tmpbuf, int *offset, int *len, int *newlineNotFound, char *line, int line_len)
{
    int status;
    char c;
    int crFound=0;

    memset(line, 0, line_len);

    while (strlen(line)< line_len-1)
    {
        status=GetChar(fd, tmpbuf, offset, len, &c);
        if (status <=0) return status;

        strncat(line, &c, 1);
#if 0 
        LanPrint(&c, 1);
#endif

        if ( c == 0xA )
        {
            return 1;
        }
        else if ( c == 0xD )            // CR
        {
            crFound = TRUE;
        }
        else
        {
            // wanted to see LF after CR; error
            if ( crFound )
            {
                *newlineNotFound = TRUE;
                return -98;
            }
        }
    }
    return -99;
}

int ParseHttpHeader(char *finger, http_header *out)
{

  http_header *current=NULL;
  int counter;
  int max_len=strlen(finger);

    if( (max_len>0) &&
      ( ( (*finger)!=CR) || ((*(finger+1))!=LF)))
    {
      current=(http_header *) malloc(sizeof(http_header));
    }
    if (!current)
    {
      return -1;
    }

    current->next=NULL;
      
    //parse header
    if (!(counter=parse_token(finger, &current->header,max_len)))
    { 
        free_http_headers(current);
        current=NULL;
        return -1;
    }
      
    finger+=counter;
    if ( (*finger!=':'))
    {
      free_http_headers(current);
      current=NULL;
      return -1;
    }
      counter++;
      finger++;
      max_len-=counter;

      //get rid of whitespace
      counter=parse_LWS(finger,max_len);
      finger+=counter;
      max_len-=counter;
      
    //parse value, allows empty values
    if (!(counter=parse_header_value(finger,&current->value,max_len)))
    {
      current->value.size=0;
      current->value.buff=NULL;
    }
      
      finger+=counter;
      max_len-=counter;
      
      counter=parse_http_line(finger,max_len);
      finger+=counter;
      max_len-=counter;

      memcpy(out, current, sizeof(http_header));

      free_http_headers(current);
      current=NULL;
      return 0;
}

void HttpLineToUpper(char *line)
{
    int i;
    int len=strlen(line);
    for ( i = 0; i < len; i++ )
    {
        line[i] = toupper( line[i] );
    }   
}

int ParseContentLength(char *line)
{
    int i;
    int patlen=strlen(H_CONTENT_LEN);
    char* invalidChar = NULL;
    int contentLength=0;

    HttpLineToUpper(line);
#if 0 
    LanPrint(line, 80);
#endif

    if ( strncmp(line, H_CONTENT_LEN, patlen) != 0 )
    {
        // unknown header
        return -1;
    }
    
    i = patlen;
    
    {
        // skip whitespace
        while ( line[i] == ' ' || line [i] == '\t' )
        {
            i++;
        }
        
        // ":"
        if ( line[i] != ':' )
        {
            return -1;
        }
        i++;
        
        
        contentLength = (int)strtol( &line[i], &invalidChar, 10 );
        // anything other than crlf or whitespace after number is invalid
        if ( *invalidChar != '\0' )
        {
            // see if there is an invalid number
            while ( *invalidChar )
            {
                char c;
                
                c = *invalidChar;
                
                if ( !(c == ' ' || c == '\t' || c == '\r' || c == '\n') )
                {
                    // invalid char in number
                    return -1;
                }
                invalidChar++;
            }
        }
    }
    return contentLength;   
}

#if 0
int UPnPTCPRead(int fd, char *buf)
{
    int status;
    int offset=0;
    int len=-1;
    int newlineNotFound=0;
    int contentLength=0;
#if 0 
    int ReadBuf=63;
    char body[64];
#else
    int ReadBuf=3;
    char body[4];
#endif

#if 1
    char tmp[16];
#endif

    /*Read Request Line*/
    status=ReadLine(fd, TCPReadBuf, &offset, &len, &newlineNotFound, TCPReadLine, UPNP_HTTP_LINE_LEN);

    if (status <= 0)
    {
#if 1
        //NWitoa(status, tmp, 10);
        sprintf(tmp, "%d", status);
        //SerialDisplayBuf("request line\r\n", 15);
        //SerialDisplayBuf((char *)tmp, strlen((char *)tmp));
        //SerialDisplayBuf(UPNP_CRLF, 2);
#endif
        return status; 
    }

    if (newlineNotFound)
    {
        return 2;
    }

    strcat(buf, TCPReadLine);
#if 0 
    //SerialDisplayBuf(TCPReadLine, 80);
#endif

    /*Read Headers*/
    contentLength = -1;     // init
    while(1)
    {
        status=ReadLine(fd, TCPReadBuf, &offset, &len, &newlineNotFound, TCPReadLine, UPNP_HTTP_LINE_LEN);
        if (status <= 0)
        {
#if 1
        //NWitoa(status, tmp, 10);
        sprintf(tmp, "%d", status);
        //SerialDisplayBuf("header\r\n", 9);
        //SerialDisplayBuf((char *)tmp, strlen((char *)tmp));
        //SerialDisplayBuf(UPNP_CRLF, 2);
#endif
            return status; 
        }

        if (newlineNotFound)
        {
            return 2; 
        }

        strcat(buf, TCPReadLine);
#if 0 
    //SerialDisplayBuf(TCPReadLine, 80);
#endif
#if 1 
        if (contentLength<0)
        contentLength=ParseContentLength(TCPReadLine);
#endif
        if (!strcmp(TCPReadLine, UPNP_CRLF)) break;
    }

    /*Read Body*/
    if (contentLength>0)
    {
        int totalBytesRead = 0;

        
        // read body
        while ( 1 )
        {
            int bytesRead;
            
            bytesRead = ReadBody(fd, TCPReadBuf, &offset, &len, body, ReadBuf );
 
            if ( bytesRead > 0 )
            {
                body[ bytesRead ] = 0;   // null terminate string
                strcat(buf, body);
                totalBytesRead += bytesRead;
                
                if ( totalBytesRead >= contentLength )
                {
                    // done reading data
                    break;
                }
            }
            else if ( bytesRead == -22 )
            {
#if 1
                NWitoa(bytesRead, tmp, 10);
                //SerialDisplayBuf("body\r\n", 7);
                //SerialDisplayBuf((char *)tmp, strlen((char *)tmp));
                //SerialDisplayBuf(UPNP_CRLF, 2);
#endif
                return -22;
            }
        }

    }
    else
    {
#if 1 
        while (1)
        {

        int bytesRead;
        bytesRead = ReadBody(fd, TCPReadBuf, &offset, &len, body, ReadBuf );
        if ( bytesRead > 0 )
        {
            body[ bytesRead ] = 0;   // null terminate string
            strcat(buf, body);
        }
        //else if (bytesRead == -22 || bytesRead==-5)
        else if (bytesRead == -22 )
        {
#if 0
            return -22;
#else
            break;
#endif
        }
        }
#else
        ReadBodyUnknownLen(fd, buf, TCPReadBuf);
        //SerialDisplayBuf(UPNP_CRLF, 2);
        //SerialDisplayBuf("No C_Len\r\n", 11);
        //SerialDisplayBuf(buf, strlen(buf));
        //SerialDisplayBuf("No C_Len\r\n", 11);
#endif
    }

    return 1;
}
#endif

void DumpRequestMessage(http_message *message)
{
    http_header *list;
    list=message->header_list;

    //SerialDisplayBuf(UPNP_CRLF, 2);
    //SerialDisplayBuf(message->request.http_version.buff, message->request.http_version.size); 
    //SerialDisplayBuf(message->request.method.buff, message->request.method.size); 

    while (list)
    {
        //SerialDisplayBuf(UPNP_CRLF, 2);
        //SerialDisplayBuf(list->header.buff, list->header.size);
        //SerialDisplayBuf(list->value.buff, list->value.size);
        list=list->next;
    }

    //SerialDisplayBuf(UPNP_CRLF, 2);
    //SerialDisplayBuf(message->content.buff, message->content.size); 
    return;
}

void DumpResponseMessage(http_message *message)
{
    http_header *list;
    list=message->header_list;

    //SerialDisplayBuf(UPNP_CRLF, 2);
    //SerialDisplayBuf(message->status.http_version.buff, message->status.http_version.size); 
    //SerialDisplayBuf(message->status.status_code.buff, message->status.status_code.size); 
    //SerialDisplayBuf(message->status.reason_phrase.buff, message->status.reason_phrase.size); 

    while (list)
    {
        //SerialDisplayBuf(UPNP_CRLF, 2);
        //SerialDisplayBuf(list->header.buff, list->header.size);
        //SerialDisplayBuf(list->value.buff, list->value.size);
        list=list->next;
    }

    //SerialDisplayBuf(UPNP_CRLF, 2);
    //SerialDisplayBuf(message->content.buff, message->content.size); 
    return;
}

int TraverseEmbedded(PUPNP_DEVICE Device, handler_t fctn, void *para1, void *para2)
{
        return TraverseDevices(Device->Embedded, fctn, para1, para2);   
}

int TraverseDevices(PUPNP_DEVICE Device, handler_t fctn, void *para1, void *para2)
{
    int ret=0;
    while (Device)
    {
        ret=fctn(Device, para1, para2);
        if (ret==1)return 1;

        ret=TraverseEmbedded(Device, fctn, para1, para2);
        if (ret==1)return 1;
        Device=Device->Sibiling;
    }
    return 0;
}
/* vim:set sw=4 sts=4 sta si expandtab: */
