#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "upnp_types.h"
#include "fmt_cvt.h"
//#include "xml_mem.h"
#include "xml_dump.h"
#include "xml_tree.h"
#include "misc_xml.h"
#include "upnp.h"
#include "http_pas.h"
#include "upnp_utl.h"
#include "ad.h"
#include "mlisten.h"
#include "event.h"
#include "dispatch.h"
#include "descrip.h"
#include "control.h"
#include "ralink_gpio.h"
#include "readsysinfo.h"
#include <nvram.h>

#if 0
#include "xml_dump.h"
#include "xml_enti.h"
#include "xml_tree.h"
#include "xml_ext.h"
#include "xml_pars.h"
#include "xml_mem.h"
#endif


#if 0
extern void add_timer(struct TimerDataStructure * timer);
extern int del_timer(struct TimerDataStructure * timer);
#endif
//extern int sock_change_upnpip(int fd);
extern int16 upnp_ad_sock_fd;
extern int16 upnp_multi_listen_sock_fd;
extern int16 upnp_dispatcher_sock_fd;
//extern int16 ucp_msearch_sock_fd;
extern nuint32 UpnpAdExpireTime;
extern int AdBuildByeByeAndSend(PUPNP_DEVICE UPnPDevice, void *para1, void *para2);
extern int AdBuildAndSend(PUPNP_DEVICE UPnPDevice, void *para1, void *para2);
extern void CLSL_GetNodeAddress(int BoardId, char *NodeBuffer);

extern char *MyModel;
extern char *MyCompany;
extern char *MyModelDesc;
extern char *MyCompanyURL;

extern unsigned short port_number;
//extern int upnp_read_sysinfo(int len, char *buf, int subfunc);
int16 upnp_datasink_sock_fd = -1;

PUPNP_DEVICE UPnPDeviceTemplate;

#define UPNP_TIMEOUT_INTERVAL  (30*18)

#define UPNP_NOJOB        0
#define UPNP_NEWJOB       1
#define UPNP_PRINTING     5
#define UPNP_CLOSEJOB     6


#define JOBIDLIST   7
#define SST_OFFSET  10

//ACCESS upnp_access;
extern int n_port;
unsigned long UpnpIP;
extern void ip_ltoa(char * buff, unsigned long in);

//struct FGProcessStructure UPNPDataAcceptFGProcessNode;
//struct FGProcessStructure UPNPDataRecvFGProcessNode;
int CreateJob(PUPNP_ACTION_REQUEST pCAEvent, char *buf);
int CancelJob(PUPNP_ACTION_REQUEST pCAEvent, char *buf);
int GetPrinterAttributes(PUPNP_ACTION_REQUEST pCAEvent, char *buf);
int GetJobAttributes(PUPNP_ACTION_REQUEST pCAEvent, char *buf);
int UPnPReboot(PUPNP_ACTION_REQUEST pCAEvent, char *buf);
int UPnPSuspend(PUPNP_ACTION_REQUEST pCAEvent, char *buf);
int UPnPNull1(PUPNP_ACTION_REQUEST pCAEvent, char *buf);
int UPnPNull2(PUPNP_ACTION_REQUEST pCAEvent, char *buf);
int CreateDeviceElement(PUPNP_DEVICE Device, char *EmbeddedDevice);



char far RootDesc[UPNP_DOC_SIZE];
char far UnitElement[256];

char far UPNP_PRINTER_SERVER[38]="urn:cellvision:device:PrintServer:1";
char far UPNP_PRINTER[38]="urn:schemas-upnp-org:device:Printer:1";
char far UPNP_PS_FRIENDLY_PREFIX[14]="Print Server ";
char far UPNP_CS_FRIENDLY_PREFIX[15]="Camera Server ";
char far UPNP_PLANET_FRIENDLY_PREFIX[17]="Internet Camera ";
char far UPNP_PRINTER_FRIENDLY_PREFIX[9]="Printer ";

char far XML_ROOT[5]="root";
char far XML_DEVICE[7]="device";
char far XML_URLBASE[8]="URLBase";
char far XML_DEVICETYPE[11]="deviceType";

char far XML_F_NAME[13]="friendlyName";
char far XML_MANUF[13]="manufacturer";
char far XML_MANUF_URL[16]="manufacturerURL";
char far XML_MODEL_DESC[17]="modelDescription";
char far XML_MODEL_NAME[10]="modelName";
char far XML_MODEL_NO[12]="modelNumber";
char far XML_MODEL_URL[9]="modelURL";
char far XML_UDN[4]="UDN";
char far XML_UPC[4]="UPC";
char far XML_PRES_URL[16]="presentationURL";
char far XML_DEVICE_LIST[11]="deviceList";
char far UPNP_BASIC_SCPDURL[12]="/basic1.xml";

char far ROOT_DESC[127]="<?xml version=\"1.0\"?>"
                "<root xmlns=\"urn:schemas-upnp-org:device-1-0\">"
                "<specVersion>"
                "<major>1</major>"
                "<minor>0</minor>"
                "</specVersion>";

char far ROOT_DESC_SLIST[270]="<serviceList>"
                "<service>"
                "<serviceType>urn:cellvision:service:Null:1</serviceType>"
                "<serviceId>urn:cellvision:serviceId:RootNull</serviceId>"
                "<SCPDURL>/rootService.xml</SCPDURL>"
                "<controlURL>/rootControl</controlURL>"
                "<eventSubURL>/rootEvent</eventSubURL>"
                "</service>"
                "</serviceList>";

char far DESC_SLIST1[]="<serviceList>"
#if 0 
                "<service>"
                "<serviceType>urn:schemas-upnp-org:service:PrintBasic:1</serviceType>"
                "<serviceId>urn:upnp-org:serviceId:1</serviceId>"
                "<SCPDURL>/basic1.xml</SCPDURL>"
                "<controlURL>/basicControl1</controlURL>"
                "<eventSubURL>/basicEvent1</eventSubURL>"
                "</service>"
                "<service>"
                "<serviceType>urn:cellvision:service:Power:1</serviceType>"
                "<serviceId>urn:cellvision:serviceId:Port1Power</serviceId>"
                "<SCPDURL>/power1.xml</SCPDURL>"
                "<controlURL>/powerControl1</controlURL>"
                "<eventSubURL>/powerEvent1</eventSubURL>"
                "</service>"
#endif
                "</serviceList>";


#if 1 
char far basic_desc[]=
    "<?xml version=\"1.0\"?>"
    "<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">"
        "<specVersion>"
            "<major>1</major>"
            "<minor>0</minor>"
        "</specVersion>"
#if 0 
        "<actionList>"
#if 0 
            "<action>"
                "<name>CreateJob</name>"
                "<argumentList>"
                    "<argument>"
                    "<name>JobName</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>JobName</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>JobOriginatingUserName</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>JobOriginatingUserName</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>DocumentFormat</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>DocumentFormat</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>Copies</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>Copies</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>Sides</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>Sides</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>NumberUp</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>NumberUp</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>OrientationRequested</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>OrientationRequested</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>MediaSize</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>MediaSize</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>MediaType</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>MediaType</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>PrintQuality</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>PrintQuality</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>JobId</name>"
                    "<direction>out</direction>"
                    "<relatedStateVariable>JobId</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>DataSink</name>"
                    "<direction>out</direction>"
                    "<relatedStateVariable>DataSink</relatedStateVariable>"
                    "</argument>"
                "</argumentList>"
            "</action>"
#endif
            "<action>"
                "<name>CancelJob</name>"
                "<argumentList>"
                    "<argument>"
                    "<name>JobId</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>JobId</relatedStateVariable>"
                    "</argument>"
                "</argumentList>"
            "</action>"
#if 0 
            "<action>"
                "<name>GetPrinterAttributes</name>"
                "<argumentList>"
                    "<argument>"
                    "<name>PrinterState</name>"
                    "<direction>out</direction>"
                    "<relatedStateVariable>PrinterState</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>PrinterStateReasons</name>"
                    "<direction>out</direction>"
                    "<relatedStateVariable>PrinterStateReasons</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>JobIdList</name>"
                    "<direction>out</direction>"
                    "<relatedStateVariable>JobIdList</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>JobId</name>"
                    "<direction>out</direction>"
                    "<relatedStateVariable>JobId</relatedStateVariable>"
                    "</argument>"
                "</argumentList>"
            "</action>"
            "<action>"
                "<name>GetJobAttributes</name>"
                "<argumentList>"
                    "<argument>"
                    "<name>JobId</name>"
                    "<direction>in</direction>"
                    "<relatedStateVariable>JobId</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>JobName</name>"
                    "<direction>out</direction>"
                    "<relatedStateVariable>JobName</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>JobOriginatingUserName</name>"
                    "<direction>out</direction>"
                    "<relatedStateVariable>JobOriginatingUserName</relatedStateVariable>"
                    "</argument>"
                    "<argument>"
                    "<name>JobMediaSheetsCompleted</name>"
                    "<direction>out</direction>"
                    "<relatedStateVariable>JobMediaSheetsCompleted</relatedStateVariable>"
                    "</argument>"
                "</argumentList>"
            "</action>"
#endif
        "</actionList>"
#endif
        "<serviceStateTable>"
#if 0 
            "<stateVariable sendEvents=\"no\">"
                "<name>PrinterName</name>"
//              "<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue></defaultValue>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>PrinterLocation</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue></defaultValue>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>DeviceId</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                //"<defaultValue>MFG:Cellvision;CMD:PCL,PS,XHTML-Print+xml</defaultValue>"
                "<defaultValue></defaultValue>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"yes\">"
                "<name>PrinterState</name>"
                //"<sendEventsAttribute>yes</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue>idle</defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>idle</allowedValue>"
                    "<allowedValue>processing</allowedValue>"
                    "<allowedValue>stopped</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"yes\">"
                "<name>PrinterStateReasons</name>"
                //"<sendEventsAttribute>yes</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue>none</defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>none</allowedValue>"
                    "<allowedValue>attention-required</allowedValue>"
                    "<allowedValue>media-jam</allowedValue>"
                    "<allowedValue>paused</allowedValue>"
                    "<allowedValue>door-open</allowedValue>"
                    "<allowedValue>media-low</allowedValue>"
                    "<allowedValue>media-empty</allowedValue>"
                    "<allowedValue>output-area-almost-full</allowedValue>"
                    "<allowedValue>output-area-full</allowedValue>"
                    "<allowedValue>marker-supply-low</allowedValue>"
                    "<allowedValue>marker-supply-empty</allowedValue>"
                    "<allowedValue>marker-failure</allowedValue>"
                    "<allowedValue>media-change-request</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>XHTMLImageSupported</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue>image/jpeg</defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>image/jpeg</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            //"<stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>ColorSupported</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>boolean</dataType>"
                "<defaultValue>0</defaultValue>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"yes\">"
                "<name>JobIdList</name>"
                //"<sendEventsAttribute>yes</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue></defaultValue>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>JobId</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>i4</dataType>"
                "<defaultValue>0</defaultValue>"
                "<allowedValueRange>"
                "<minimum>0</minimum>"
                "<maximum>2147483647</maximum>"
                "<step>1</step>"
                "</allowedValueRange>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"yes\">"
                "<name>JobEndState</name>"
                "<dataType>string</dataType>"
                "<defaultValue></defaultValue>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>JobName</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue></defaultValue>"
            "</stateVariable>"
#endif
#if 0 
            "<stateVariable sendEvents=\"no\">"
                "<name>JobOriginatingUserName</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue></defaultValue>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>DocumentFormat</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue></defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>unknown</allowedValue>"
                    //"<allowedValue>application/vnd.pwg-xhtml-print+xml</allowedValue>"
                    "<allowedValue>application/vnd.pwg-xhtml-print</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>Copies</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>i4</dataType>"
                "<defaultValue>1</defaultValue>"
                "<allowedValueRange>"
                "<minimum>0</minimum>"
                "<maximum>2147483647</maximum>"
                "<step>1</step>"
                "</allowedValueRange>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>Sides</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue>one-sided</defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>one-sided</allowedValue>"
                    "<allowedValue>device-setting</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>NumberUp</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue>1</defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>1</allowedValue>"
                    "<allowedValue>device-setting</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>OrientationRequested</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue>portrait</defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>portrait</allowedValue>"
                    "<allowedValue>device-setting</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>MediaSize</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue></defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>device-setting</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>MediaType</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue></defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>device-setting</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>PrintQuality</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>string</dataType>"
                "<defaultValue>normal</defaultValue>"
                "<allowedValueList>"
                    "<allowedValue>normal</allowedValue>"
                    "<allowedValue>device-setting</allowedValue>"
                "</allowedValueList>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"no\">"
                "<name>DataSink</name>"
                //"<sendEventsAttribute>no</sendEventsAttribute>"
                "<dataType>uri</dataType>"
                "<defaultValue></defaultValue>"
            "</stateVariable>"
            "<stateVariable sendEvents=\"yes\">"
                "<name>JobMediaSheetsCompleted</name>"
                //"<sendEventsAttribute>yes</sendEventsAttribute>"
                "<dataType>i4</dataType>"
                "<defaultValue>-1</defaultValue>"
                "<allowedValueRange>"
                "<minimum>-1</minimum>"
                "<maximum>2147483647</maximum>"
                "<step>1</step>"
                "</allowedValueRange>"
            "</stateVariable>"
#endif
        "</serviceStateTable>"
    "</scpd>"
    ;
#endif

char far null_desc[]=
                        "<?xml version=\"1.0\"?>"
                        "<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">"
                        "<specVersion>"
                        "<major>1</major>"
                        "<minor>0</minor>"
                        "</specVersion>"
                        "<actionList>"
                        "<action>"
                        "<name>UPnPNull1</name>"
                        "</action>"
                        "<action>"
                        "<name>UPnPNull2</name>"
                        "</action>"
                        "</actionList>"
                        "<serviceStateTable>"
                        "<stateVariable sendEvents=\"yes\">"
                        "<name>NullStatus</name>"
                        //"<sendEventsAttribute>yes</sendEventsAttribute>"
                        "<dataType>string</dataType>"
                        "<defaultValue>1</defaultValue>"
                        "</stateVariable>"
                        "</serviceStateTable>"
                        "</scpd>";


char far power_desc[]=
                        "<?xml version=\"1.0\"?>"
                        "<scpd xmlns=\"urn:schemas-upnp-org:service-1-0\">"
                        "<specVersion>"
                        "<major>1</major>"
                        "<minor>0</minor>"
                        "</specVersion>"
                        "<actionList>"
                        "<action>"
                        "<name>UPnPReboot</name>"
                        "</action>"
                        "<action>"
                        "<name>UPnPSuspend</name>"
                        "</action>"
                        "</actionList>"
                        "<serviceStateTable>"
                        "<stateVariable sendEvents=\"yes\">"
                        "<name>PowerStatus</name>"
                        //"<sendEventsAttribute>yes</sendEventsAttribute>"
                        "<dataType>string</dataType>"
                        "<defaultValue>1</defaultValue>"
                        "</stateVariable>"
                        "</serviceStateTable>"
                        "</scpd>";

SERVICE_TABLE far RootService=
{
                        null_desc,
                        "urn:cellvision:service:Null:1",
                        "urn:cellvision:serviceId:RootNull",
                        "/rootService.xml",
                        "/rootControl",
                        "/rootEvent",
                        {{"NullStatus", 1, 0, STRING, {"1"}, "1", "1"}
                        },
                        {{"UPnPNull1", UPnPNull1, NULL},
                        {"UPnPNull2", UPnPNull2, NULL}
                        },
                        0,0,NULL,NULL,SUBSCRIPTION_DURATION,NULL,NULL, NULL
}
;

SERVICE_TABLE far Service1=
{
                        power_desc,
                        "urn:cellvision:service:Power:1",
                        "urn:cellvision:serviceId:Port1Power",
                        "/power1.xml",
                        "/powerControl1",
                        "/powerEvent1",
                        {{"PowerStatus", 1, 0, STRING, {"1"}, "1", "1"}
                        },
                        {{"UPnPReboot", UPnPReboot, NULL},
                        {"UPnPSuspend", UPnPSuspend, NULL}
                        },
                        0,0,NULL,NULL,SUBSCRIPTION_DURATION,NULL,NULL, NULL
}
;

SERVICE_TABLE far Service0=
{
                        basic_desc,
                        "urn:schemas-upnp-org:service:PrintBasic:1",
                        "urn:upnp-org:serviceId:1",
                        "/basic1.xml",
                        "/basicControl1",
                        "/basicEvent1",
                        {{"PrinterName", 0, 0,STRING, {""}, "", ""},
                        {"PrinterLocation", 0, 0, STRING, {""}, "", ""},
                        //{"DeviceId", 0, 0, STRING, {"MFG:Cellvision;CMD:PCL,PS,XHTML-Print+xml"}},
                        {"DeviceId", 0, 0, STRING, {""}, "", ""},
                        {"PrinterState", 1, 0, STRING, {"idle"}, "idle", "idle"},
                        {"PrinterStateReasons", 1, 0, STRING, {"none"}, "none", "none"},
                        {"XHTMLImageSupported", 0, 0, STRING, {"image/jpeg"}, "image/jpeg", "image/jpeg"},
                        {"ColorSupported", 0, 0, UPNPBOOL, {""}, "0", "0"},
                        {"JobIdList", 1, 0, STRING, {""}, "", ""},
                        {"JobId", 0, 0, I4, {"0"}, "", ""},
                        //{"JobEndState", 1, 0, CSV, {""}},
                        {"JobEndState", 1, 0, STRING, {""}, "", ""},
#if 1
                        {"JobName", 0, 0, STRING, {""}, "", ""},
                        {"JobOriginatingUserName", 0, 0, STRING, {""}, "", ""},
                        {"DocumentFormat", 0, 0, STRING, {"unknown"}, "unknown", "unknown"},
                        {"Copies", 0, 0, I4, {"1"}, "1", "1"},
                        {"Sides", 0, 0, STRING, {"one-sided"}, "one-sided", "one-sided"},
                        {"NumberUp", 0, 0, STRING, {"1"}, "1"},
                        {"OrientationRequested", 0, 0, STRING, {"portrait"}, "portrait", "portrait"},
                        {"MediaSize", 0, 0, STRING, {""}, "", ""},
                        {"MediaType", 0, 0, STRING, {""}, "", ""},
                        {"PrintQuality", 0, 0, STRING, {"normal"}, "normal", "normal"},
                        {"DataSink", 0, 0, URI, {""}, "", ""},
                        {"JobMediaSheetsCompleted", 1, 0, I4, {"-1"}, "-1", "-1"}
#endif
                        },
                        {{"CreateJob", CreateJob, NULL},
                        {"CancelJob", CancelJob, NULL},
                        {"GetPrinterAttributes",GetPrinterAttributes, NULL},
                        {"GetJobAttributes",GetJobAttributes, NULL}
                        },
                        0,0,NULL,NULL,SUBSCRIPTION_DURATION,NULL,NULL, &Service1 
}
;

UPNP_DEVICE far printer1=
{
                        "",
                        NULL,
                        0,
                        1,
                        "urn:schemas-upnp-org:device:Printer:1",
                        "",
                        "",
                        "",
                        "/desc1.xml",
                        "",
                        "",
                        "http://",
                        ADVERTISEMENT_DURATION,
                        &Service0,
                        NULL,
                        NULL
};

UPNP_DEVICE far root=
{
                        "",
                        RootDesc,
                        1,
                        0,
                        //"urn:cellvision:device:PrintServer:1",
                        "urn:schemas-upnp-org:device:Basic:1.0",
                        "",
                        "",
                        "",
                        "/rootdesc.xml",
                        "",
                        "",
                        "http://",
                        ADVERTISEMENT_DURATION,
                        &RootService,
                        //&printer1,
                        NULL,
                        NULL
};

void AddXMLModelNo(char *EmbeddedDevice)
{
    char tmpbuf[128];
#if D_LINK || D_LINK_CHINA || D_LINK_TAIWAN || D_LINK_CHT
    memset(UnitElement, 0, sizeof(UnitElement));
    memset(tmpbuf, 0, sizeof tmpbuf);
    upnp_read_sysinfo(sizeof(tmpbuf), tmpbuf, SYSINFO_MODEL);
    AddXmlElement(XML_MODEL_NO, tmpbuf, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 
#else
    char *buf=malloc(128);
    if (buf == NULL) return; 
    memset(buf, 0, 128);


    /*FW Version*/
    memset(tmpbuf, 0, sizeof tmpbuf);
    upnp_read_sysinfo(sizeof(tmpbuf), tmpbuf, SYSINFO_VERSION);
    strcpy(buf, tmpbuf);

    /*Release Date*/
    memset(tmpbuf, 0, sizeof tmpbuf);
    upnp_read_sysinfo(sizeof(tmpbuf), tmpbuf, SYSINFO_DATE);
    strcat(buf, UPNP_LPB);
    strcat(buf, tmpbuf);
    strcat(buf, UPNP_RPB);

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MODEL_NO, buf, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 
    free(buf);
#endif
    return;
}

int CreateServiceElement(PUPNP_DEVICE Printer, char *Service)
{
    return 0;
}

int CreateDeviceListElement(PUPNP_DEVICE Device)
{
    PUPNP_DEVICE    cur;

    cur=Device;

    strcat(RootDesc, UPNP_LAB); 
    strcat(RootDesc, XML_DEVICE_LIST); 
    strcat(RootDesc, UPNP_RAB); 

    while (cur)
    {
        CreateDeviceElement(Device, RootDesc);
        cur=cur->Sibiling;
    }

    strcat(RootDesc, UPNP_LAB); 
    strcat(RootDesc, UPNP_SLASH); 
    strcat(RootDesc, XML_DEVICE_LIST); 
    strcat(RootDesc, UPNP_RAB); 

    return 0;
}

#if 0
int upnp_read_sysinfo(int len, char *buf, int subfunc)
{
    int fd;

    fd = open(SYSIF_DEV, O_RDONLY);
    if (fd < 0) {
        perror(SYSIF_DEV);
        return -1;
    }
    if (ioctl(fd, (SYSIF_READ | 
                        subfunc << SUBCMD_IDX_SHIFT | 
                        (len << BUF_LEN_SHIFT)), buf) < 0) {
        perror("ioctl");
        close(fd);
        return -1;
    }

    close(fd);
    return 0;
}
#endif

int CreateDeviceElement(PUPNP_DEVICE Device, char *EmbeddedDevice)
{
    char tmpbuf[256];

    strcat(EmbeddedDevice, UPNP_LAB); 
    strcat(EmbeddedDevice, XML_DEVICE); 
    strcat(EmbeddedDevice, UPNP_RAB); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_DEVICETYPE, Device->DeviceType, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement);

    /*Friendly Name was set before this time, because different brand wish have different Name.*/
    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_F_NAME, Device->FriendlyName, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    if (Device->RootDevice)
    {
    memset(UnitElement, 0, sizeof(UnitElement));
    memset(tmpbuf, 0, sizeof tmpbuf);
    upnp_read_sysinfo(sizeof(tmpbuf), tmpbuf, SYSINFO_COMPANY);
    AddXmlElement(XML_MANUF, tmpbuf, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    memset(tmpbuf, 0, sizeof tmpbuf);
    upnp_read_sysinfo(sizeof(tmpbuf), tmpbuf, SYSINFO_COMPANY_URL);
    AddXmlElement(XML_MANUF_URL, tmpbuf, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    memset(tmpbuf, 0, sizeof tmpbuf);
    upnp_read_sysinfo(sizeof(tmpbuf), tmpbuf, SYSINFO_MODEL_DESC);
    AddXmlElement(XML_MODEL_DESC, tmpbuf, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    memset(tmpbuf, 0, sizeof tmpbuf);
    upnp_read_sysinfo(sizeof(tmpbuf), tmpbuf, SYSINFO_MODEL);
    AddXmlElement(XML_MODEL_NAME, tmpbuf, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    /*Add Model Number*/
    AddXMLModelNo(EmbeddedDevice);

    memset(UnitElement, 0, sizeof(UnitElement));
    memset(tmpbuf, 0, sizeof tmpbuf);
    upnp_read_sysinfo(sizeof(tmpbuf), tmpbuf, SYSINFO_COMPANY_URL);
    AddXmlElement(XML_MODEL_URL, tmpbuf, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 
    }
    else
    {
    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MANUF, "", UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MANUF_URL, "", UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MODEL_DESC, "", UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MODEL_NAME, "", UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MODEL_URL, "", UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 
    }

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_UDN, Device->UDN, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_UPC, Device->UPC, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    switch (Device->Port)
    {
        case 0:
            strcat(EmbeddedDevice, ROOT_DESC_SLIST);

            memset(UnitElement, 0, sizeof(UnitElement));
            AddXmlElement(XML_PRES_URL, Device->PresURL, UnitElement, 1);
            strcat(EmbeddedDevice, UnitElement); 
            break;
        case 1:
            strcat(EmbeddedDevice, DESC_SLIST1);
            break;
#if 0
        case 2:
            strcat(EmbeddedDevice, DESC_SLIST2);
            break;
        case 3:
            strcat(EmbeddedDevice, DESC_SLIST3);
            break;
#endif
    }


    if (Device->Embedded)
    {
        CreateDeviceListElement(Device->Embedded);
    }

    strcat(EmbeddedDevice, UPNP_LAB); 
    strcat(EmbeddedDevice, UPNP_SLASH); 
    strcat(EmbeddedDevice, XML_DEVICE); 
    strcat(EmbeddedDevice, UPNP_RAB); 

    return 0;
}

int CreateRootDeviceDesc(void)
{
    memset(RootDesc, 0, UPNP_DOC_SIZE);
    strcat(RootDesc, ROOT_DESC);

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_URLBASE, UPnPDeviceTemplate->URLBase, UnitElement, 1);
    strcat(RootDesc, UnitElement); 

    CreateDeviceElement(UPnPDeviceTemplate, RootDesc);

    strcat(RootDesc, UPNP_LAB); 
    strcat(RootDesc, UPNP_SLASH); 
    strcat(RootDesc, XML_ROOT); 
    strcat(RootDesc, UPNP_RAB); 

    return 0;
}


#if 0 /*Create device description which only caontain root device*/

int CreateDeviceElement(PUPNP_DEVICE Printer, char *EmbeddedDevice)
{
    strcat(EmbeddedDevice, UPNP_LAB); 
    strcat(EmbeddedDevice, XML_DEVICE); 
    strcat(EmbeddedDevice, UPNP_RAB); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_DEVICETYPE, Printer->DeviceType, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement);

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_F_NAME, Printer->FriendlyName, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MANUF, MyCompany, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MANUF_URL, MyCompanyURL, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MODEL_DESC, MyModelDesc, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MODEL_NAME, MyModel, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_MODEL_URL, MyCompanyURL, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_UDN, Printer->UDN, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_UPC, Printer->UPC, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    strcat(EmbeddedDevice, DESC_SLIST);

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_PRES_URL, UPnPDeviceTemplate->PresURL, UnitElement, 1);
    strcat(EmbeddedDevice, UnitElement); 

    strcat(EmbeddedDevice, UPNP_LAB); 
    strcat(EmbeddedDevice, UPNP_SLASH); 
    strcat(EmbeddedDevice, XML_DEVICE); 
    strcat(EmbeddedDevice, UPNP_RAB); 

    return 0;
}

int CreateDeviceDesc()
{
    PUPNP_DEVICE Printer=UPnPDeviceTemplate;

    memset(DeviceDesc, 0, 1024);
    strcat(DeviceDesc, DESC);

    memset(UnitElement, 0, sizeof(UnitElement));
    AddXmlElement(XML_URLBASE, UPnPDeviceTemplate->URLBase, UnitElement, 1);
    strcat(DeviceDesc, UnitElement); 

    for (;Printer;Printer=Printer->Embedded)
    {
        if (Printer->RootDevice==1)
        {
            memset(EmbeddedDevice, 0, 1024);
            CreateDeviceElement(Printer, EmbeddedDevice);
            strcat(DeviceDesc, EmbeddedDevice);
        }
        else
        {
        }
    }

    strcat(DeviceDesc, UPNP_LAB); 
    strcat(DeviceDesc, UPNP_SLASH); 
    strcat(DeviceDesc, XML_ROOT); 
    strcat(DeviceDesc, UPNP_RAB); 
    
    return 0;
}
#endif

#if 1 
int CreateJob(PUPNP_ACTION_REQUEST pCAEvent, char *buf)
{
    return 0;
}
int CancelJob(PUPNP_ACTION_REQUEST pCAEvent, char *buf)
{
    return 0;
}

int GetPrinterAttributes(PUPNP_ACTION_REQUEST pCAEvent, char *buf)
{
    return 0;
}

int GetJobAttributes(PUPNP_ACTION_REQUEST pCAEvent, char *buf)
{
    return 0;
}
int UPnPReboot(PUPNP_ACTION_REQUEST pCAEvent, char *buf)
{
    return 0;
}
int UPnPSuspend(PUPNP_ACTION_REQUEST pCAEvent, char *buf)
{
#if 0 
        pCAEvent->target_value=malloc(512);
        memset(pCAEvent->target_value, 0, 512);

        //UPnPDeviceTemplate->pService->next->sst[0].evented=1;
        //strcpy(UPnPDeviceTemplate->pService->next->sst[0].vdata.str, "9");
        pCAEvent->pService->sst[0].evented=1;
        strcpy(pCAEvent->pService->sst[0].vdata.str, "9");

        strcat(pCAEvent->target_value, "<u:");
        //strcat(pCAEvent->target_value, UPnPDeviceTemplate->pService->next->action[pCAEvent->action].aname);
        strcat(pCAEvent->target_value, pCAEvent->pService->action[pCAEvent->action].aname);
        strcat(pCAEvent->target_value, "Response xmlns:u=\"");
        //strcat(pCAEvent->target_value, UPnPDeviceTemplate->pService->next->serviceType); 
        strcat(pCAEvent->target_value, pCAEvent->pService->serviceType); 
        strcat(pCAEvent->target_value, "\">");
        strcat(pCAEvent->target_value, "</u:");
        //strcat(pCAEvent->target_value, UPnPDeviceTemplate->pService->next->action[pCAEvent->action].aname);
        strcat(pCAEvent->target_value, pCAEvent->pService->action[pCAEvent->action].aname);
        strcat(pCAEvent->target_value, "Response>"); 

        memset(UPnPSendBuf, 0, UPNP_SEND_BUF_SIZE);
        CreateControlActionResponse(UPnPSendBuf, pCAEvent->target_value);
        send(pCAEvent->fd, UPnPSendBuf, strlen(UPnPSendBuf), 0);

        free(pCAEvent->target_value);
#endif
    return 0;
}

int UPnPNull1(PUPNP_ACTION_REQUEST pCAEvent, char *buf)
{
    return 0;
}
int UPnPNull2(PUPNP_ACTION_REQUEST pCAEvent, char *buf)
{
    return 0;
}
#endif

#if 0
int UPnPGetDescDoc(PUPNP_DEVICE Printer, char **DescDoc)
{
    *DescDoc=malloc(strlen(device_desc1)+
                    strlen(Printer->URLBase)+
                    strlen(device_desc2)+
                    strlen(Printer->PresURL)+
                    strlen(device_desc3)+
                    1);

    if (*DescDoc == NULL) return -1;
    else memset(*DescDoc, 0, strlen(*DescDoc));
    strcpy(*DescDoc, device_desc1);
    strcat(*DescDoc, Printer->URLBase);
    strcat(*DescDoc, device_desc2);
    strcat(*DescDoc, Printer->PresURL);
    strcat(*DescDoc, device_desc3);
    return 0;
}
#endif

#if 0
int UPnPGetSCPD(PSERVICE_TABLE pService, char **SCPD)
{
    if (!strcmp(pService->SCPDURL, UPNP_BASIC_SCPDURL))
    {
            *SCPD=malloc(strlen(basic_desc));
            if (*SCPD == NULL)
            {
                //LanPrint("basic Allocate Fail", 19);
                return -1;
            }
            else memset(*SCPD, 0, strlen(*SCPD));
            strcpy(*SCPD, basic_desc);

#if 0
            *SCPD=malloc(strlen(basic_descS)+
                            strlen(basic_actionS)+
                            strlen(basic_action1)+
                            strlen(basic_action2)+
                            strlen(basic_action3)+
                            strlen(basic_action4)+
                            strlen(basic_actionE)+
                            strlen(basic_sstS)+
                            strlen(basic_sst1)+
                            strlen(basic_sst2)+
                            strlen(basic_sst3)+
                            strlen(basic_sstE)+
                            strlen(basic_descE)
                            );
            if (*SCPD == NULL)
            {
                //LanPrint("basic Allocate Fail", 19);
                return -1;
            }
            else memset(*SCPD, 0, strlen(*SCPD));
            strcpy(*SCPD, basic_descS);
            strcat(*SCPD, basic_actionS);
            strcat(*SCPD, basic_action1);
            strcat(*SCPD, basic_action2);
            strcat(*SCPD, basic_action3);
            strcat(*SCPD, basic_action4);
            strcat(*SCPD, basic_actionE);
            strcat(*SCPD, basic_sstS);
            strcat(*SCPD, basic_sst1);
            strcat(*SCPD, basic_sst2);
            strcat(*SCPD, basic_sst3);
            strcat(*SCPD, basic_sstE);
            strcat(*SCPD, basic_descE);
#endif
    }
    else
    {
            *SCPD=malloc(strlen(power_desc));
            if (*SCPD == NULL)
            {
                //LanPrint("power Allocate Fail", 19);
                return -1;
            }

            else memset(*SCPD, 0, strlen(*SCPD));
            strcpy(*SCPD, power_desc);
    }
    return 0;
}
#endif

int UPnPSetIP(unsigned long IP)
{
    PUPNP_DEVICE Device;
    char tmp[20];
    char port[6];
    
    memset(port, 0 , sizeof port);
    sprintf(port, ":%d", port_number);

    memset(tmp, 0, 20);
    addr_ipstrcpy(tmp, IP);

    for (Device=UPnPDeviceTemplate;Device;Device=Device->Embedded)
    {
#if D_LINK || D_LINK_CHINA || D_LINK_TAIWAN || D_LINK_CHT
        strcpy(Device->FriendlyName, "");
#elif PLANET
        strcpy(Device->FriendlyName, UPNP_PLANET_FRIENDLY_PREFIX);
#else
        strcpy(Device->FriendlyName, UPNP_CS_FRIENDLY_PREFIX);
#endif

        strcat(Device->FriendlyName, Device->ServerName);
#if D_LINK || D_LINK_CHINA || D_LINK_TAIWAN || D_LINK_CHT
        strcat(Device->FriendlyName, UPNP_LPB);
        strcat(Device->FriendlyName, tmp);
        strcat(Device->FriendlyName, port);
        strcat(Device->FriendlyName, UPNP_RPB);
#endif

        strcpy(Device->URLBase, UPNP_HTTP_SCHEME);
        strcat(Device->URLBase, UPNP_SCOLON);
        strcat(Device->URLBase, UPNP_SLASH);
        strcat(Device->URLBase, UPNP_SLASH);
        strcat(Device->URLBase, tmp);
        strcat(Device->URLBase, UPNP_SCOLON);
        strcat(Device->URLBase, UPNP_DISPATCH_PORT);

        strcpy(Device->PresURL, UPNP_HTTP_SCHEME);
        strcat(Device->PresURL, UPNP_SCOLON);
        strcat(Device->PresURL, UPNP_SLASH);
        strcat(Device->PresURL, UPNP_SLASH);
        strcat(Device->PresURL, tmp);
        strcat(Device->PresURL, port);
    }
#if 0
    sock_change_upnpip(upnp_ad_sock_fd);
    sock_change_upnpip(upnp_dispatcher_sock_fd);
    //sock_change_upnpip(ucp_msearch_sock_fd);
#endif

#if 0 /*1212 RELEASE*/
    sock_change_upnpip(upnp_datasink_sock_fd);
#endif
    return 0;
}

#if 0
int dumpDeviceTree(PUPNP_DEVICE Device, void *para1, void *para2)
{
    char tmp[10];
    //int i,j,k;
    SUBSCRIPTION    *tmpsub;
    PSERVICE_TABLE  pService;

    {
    LanPrint(Device->URLBase, 64);
    LanPrint(Device->UDN, 64);
    LanPrint(Device->DescDocURL, 64);
    LanPrint(Device->FriendlyName, 64);
    LanPrint(Device->PresURL, 64);
    //NWitoa((int)Device->AdvrTimeOut, tmp, 10);
    sprintf(tmp, "%d", (int)Device->AdvrTimeOut);
    LanPrint((char*)tmp, 10);

    for (pService=Device->pService;pService;pService=pService->next)
    {
        LanPrint(pService->serviceType, 64);
        LanPrint(pService->serviceId, 64);
        LanPrint(pService->SCPDURL, 64);
        LanPrint(pService->controlURL, 64);
        LanPrint(pService->eventURL, 64);
#if 0
        for(j=0; j<MAX_PRINTER_ATTRIBUTES; j++)
            LanPrint(pService->sst[j].vname, 32);
        for(k=0; k<MAX_ACTION; k++)
            LanPrint(pService->action[k].aname, 32);
#endif
        NWitoa(pService->active, tmp, 10);
        LanPrint((char*)tmp, 10);
        NWitoa(pService->TotalSubscriptions, tmp, 10);
        LanPrint((char*)tmp, 10);
        for (tmpsub=pService->subscriptionHead; tmpsub!=NULL; tmpsub=tmpsub->next)
        {
            LanPrint(tmpsub->sid, 44);
            NWitoa(tmpsub->eventKey, tmp, 10);
            LanPrint((char*)tmp, 10);
            NWitoa(tmpsub->ToSendEventKey, tmp, 10);
            LanPrint((char*)tmp, 10);
            NWultoa(tmpsub->expireTime, tmp, 10);
            LanPrint((char*)tmp, 10);
            NWitoa(tmpsub->active, tmp, 10);
            LanPrint((char*)tmp, 10);
            //NWutoa(tmpsub->connect_state, tmp, 10);
            sprintf(tmp, "%d", tmpsub->connect_state);
            LanPrint((char*)tmp, 10);
            LanPrint(tmpsub->DeliveraryIP, 32);
            LanPrint(tmpsub->DeliveraryPort, 32);
            LanPrint(tmpsub->DeliveraryPath, 64);
        }
#if 0
        if (pService->subscriptionTail==NULL)
            LanPrint("Tail NULL", 9);
#endif
        //NWitoa(pService->subduration, tmp, 10);
        sprintf(tmp, "%d", pService->subduration);
        LanPrint((char*)tmp, 10);
    }
    }

    return 0;
}
#endif

#if PS
int SubUPnPPSInit(PUPNP_DEVICE Device, void *para1, void *para2)
{
    unsigned long store=UpnpIP;
    char tmp[20];
    int i;
    struct PORT *p_port;

    memset(tmp, 0, 20);
    addr_ipstrcpy(tmp, store);


    i = 4 * sizeof(struct PORT);
    p_port = malloc(i);
    NCLGetBuffer(PPORT_SUBJECT, PPORT_INFORMATION, (unsigned char *)p_port, i);

    if (Device->RootDevice)
    {
        NCLGetBuffer(SYS_SUBJECT, SYS_NAME, Device->ServerName, SYSTEM_NAME_LENGTH); 
        strcpy(Device->FriendlyName, UPNP_PS_FRIENDLY_PREFIX);
        strcat(Device->FriendlyName, Device->ServerName);
        strcpy(Device->UDN, UPNP_UUID);
        strcat(Device->UDN, UPNP_SCOLON);
        strcat(Device->UDN, Device->ServerName);
        strcpy(Device->UPC, "");
        strcpy(Device->IP, tmp);
        strcpy(Device->URLBase, UPNP_HTTP_SCHEME);
        strcat(Device->URLBase, UPNP_SCOLON);
        strcat(Device->URLBase, UPNP_SLASH);
        strcat(Device->URLBase, UPNP_SLASH);
        strcat(Device->URLBase, tmp);
        strcat(Device->URLBase, UPNP_SCOLON);
        strcat(Device->URLBase, UPNP_DISPATCH_PORT);

        strcpy(Device->PresURL, UPNP_HTTP_SCHEME);
        strcat(Device->PresURL, UPNP_SCOLON);
        strcat(Device->PresURL, UPNP_SLASH);
        strcat(Device->PresURL, UPNP_SLASH);
        strcat(Device->PresURL, tmp);

        Device->AdvrTimeOut=ADVERTISEMENT_DURATION;

    }
    else
    {
        NCLGetBuffer(SYS_SUBJECT, SYS_NAME, Device->ServerName, SYSTEM_NAME_LENGTH); 
        strcpy(Device->FriendlyName, UPNP_PRINTER_FRIENDLY_PREFIX);
        strcat(Device->FriendlyName, p_port[Device->Port-1].Cfg_PportPrinterName);
        strcpy(Device->UDN, UPNP_UUID);
        strcat(Device->UDN, UPNP_SCOLON);
        strcat(Device->UDN, p_port[Device->Port-1].Cfg_PportPrinterName);
        strcpy(Device->UPC, "");
        strcpy(Device->IP, "");
        strcpy(Device->URLBase, UPNP_HTTP_SCHEME);
        strcat(Device->URLBase, UPNP_SCOLON);
        strcat(Device->URLBase, UPNP_SLASH);
        strcat(Device->URLBase, UPNP_SLASH);
        strcat(Device->URLBase, tmp);
        strcat(Device->URLBase, UPNP_SCOLON);
        strcat(Device->URLBase, UPNP_DISPATCH_PORT);

        strcpy(Device->PresURL, UPNP_HTTP_SCHEME);
        strcat(Device->PresURL, UPNP_SCOLON);
        strcat(Device->PresURL, UPNP_SLASH);
        strcat(Device->PresURL, UPNP_SLASH);
        strcat(Device->PresURL, tmp);
        Device->AdvrTimeOut=ADVERTISEMENT_DURATION;
    }

    free(p_port);
    return 0;
}
#endif

#if CS
void GetDeviceUuid(char *dev_uuid)
{
    char mac_addr_bin[6];
    char mac_addr_hex[13];
    char sys_uuid[37];
    FILE *fp;

    /*MAC Address*/
    memset(mac_addr_bin, 0, sizeof mac_addr_bin);
    upnp_read_sysinfo(sizeof(mac_addr_bin), mac_addr_bin, MAC_ADDRESS);
    BinToHex(mac_addr_bin, 6, mac_addr_hex); 

    memset(dev_uuid, 0, sizeof dev_uuid);
    memset(sys_uuid, 0, sizeof sys_uuid);
    /* read uuid from system*/
    strcpy(sys_uuid, nvram_bufget(RT2860_NVRAM, "UPnPuuid"));

    if (0 == strlen(sys_uuid)) {
        /* generate uuid*/
        memset(sys_uuid, 0, sizeof sys_uuid);
        fp = fopen("/proc/sys/kernel/random/uuid", "r");
        if (NULL != fp) {
            fread(sys_uuid, 1, sizeof sys_uuid - 1, fp);
            fclose(fp);
        } else {
            /*just give it a uuid*/
            sprintf(sys_uuid, "%s","de36465b-16af-4c11-ba2a-788054272b5a");
        }
        /*build device uuid*/ 
        memset(dev_uuid, 0, sizeof dev_uuid);
        sprintf(dev_uuid, "%s", sys_uuid);
        sprintf(dev_uuid + 24, "%s", mac_addr_hex);
        /*save uuid*/
        nvram_bufset(RT2860_NVRAM, "UPnPuuid", dev_uuid);
        nvram_commit(RT2860_NVRAM);
    } else {
        if (strncmp(sys_uuid + 24, mac_addr_hex, 12)) {
            /*build device uuid, cause mac addr have been changed.**/
            memset(dev_uuid, 0, sizeof dev_uuid);
            sprintf(dev_uuid, "%s", sys_uuid);
            sprintf(dev_uuid + 24, "%s", mac_addr_hex);
            nvram_bufset(RT2860_NVRAM, "UPnPuuid", dev_uuid);
            nvram_commit(RT2860_NVRAM);
        } else {
            /*copy device uuid from sys_uuid*/
            memset(dev_uuid, 0, sizeof dev_uuid);
            sprintf(dev_uuid, "%s", sys_uuid);
        }
    }
    nvram_close(RT2860_NVRAM);
    return;
}

int SubUPnPCSInit(PUPNP_DEVICE Device, void *para1, void *para2)
{
    unsigned long store=UpnpIP;
    char tmp[20];
    //char id='0';
    //char *tmac = "00:0c:43:66:80:10";
    char dev_uuid[37];
    char tmpbuf[48];
    char port[6];
    
    memset(port, 0 , sizeof port);
    sprintf(port, ":%d", port_number);


    memset(tmp, 0, sizeof tmp);
    addr_ipstrcpy(tmp, store);
    GetDeviceUuid(dev_uuid);

    if (Device->RootDevice)
    {
        memset(Device->ServerName, 0, sizeof(Device->ServerName));
        //NCLGetBuffer(SYS_SUBJECT, SYS_NAME, (unsigned char *)Device->ServerName, SERVER_NAME_LENGTH); 
        upnp_read_sysinfo(sizeof(tmpbuf), tmpbuf, SYSINFO_MODEL);
        strcpy(Device->ServerName, tmpbuf);
#if D_LINK || D_LINK_CHINA || D_LINK_TAIWAN || D_LINK_CHT
        strcpy(Device->FriendlyName, "");
#elif PLANET
        strcpy(Device->FriendlyName, UPNP_PLANET_FRIENDLY_PREFIX);
#else
        strcpy(Device->FriendlyName, UPNP_CS_FRIENDLY_PREFIX);
#endif

        strcat(Device->FriendlyName, Device->ServerName);
#if D_LINK || D_LINK_CHINA || D_LINK_TAIWAN || D_LINK_CHT
        strcat(Device->FriendlyName, UPNP_LPB);
        strcat(Device->FriendlyName, tmp);
        strcat(Device->FriendlyName, port);
        strcat(Device->FriendlyName, UPNP_RPB);
#endif
        strcpy(Device->UDN, UPNP_UUID);
        strcat(Device->UDN, UPNP_SCOLON);
        //strcat(Device->UDN, mac_addr_hex);
        //strcat(Device->UDN, UPNP_DASH);
        //strncat(Device->UDN, (char *)&id, 1);
        strcat(Device->UDN, dev_uuid);
        strcpy(Device->UPC, "");
        strcpy(Device->IP, tmp);
        strcpy(Device->URLBase, UPNP_HTTP_SCHEME);
        strcat(Device->URLBase, UPNP_SCOLON);
        strcat(Device->URLBase, UPNP_SLASH);
        strcat(Device->URLBase, UPNP_SLASH);
        strcat(Device->URLBase, tmp);
        //strcat(Device->URLBase, port);
        strcat(Device->URLBase, UPNP_SCOLON);
        strcat(Device->URLBase, UPNP_DISPATCH_PORT);

        strcpy(Device->PresURL, UPNP_HTTP_SCHEME);
        strcat(Device->PresURL, UPNP_SCOLON);
        strcat(Device->PresURL, UPNP_SLASH);
        strcat(Device->PresURL, UPNP_SLASH);
        strcat(Device->PresURL, tmp);
        strcat(Device->PresURL, port);

        Device->AdvrTimeOut=ADVERTISEMENT_DURATION;

    }
   return 0;
}
#endif

int UPnPDevInit(void)
{
    UPnPDeviceTemplate=&root;

    TraverseDevices(UPnPDeviceTemplate, SubUPnPDevInit, NULL, NULL);

    CreateRootDeviceDesc();
    CacheInit();

    return 0;
}

int UPnPDev(void)
{
    static unsigned long AddressingIP=0;
    struct  sockaddr_in  destaddr;
    nuint32 now;
    int type=0;
    time_t  t;


    if (AddressingIP!=UpnpIP)
    {
        {
        destaddr.sin_family = AF_INET;
        destaddr.sin_addr.s_addr = UPNP_MULTICAST_IP;  /* 239.255.255.250 */
        destaddr.sin_port = ntohs(UPNP_MULTICAST_PORT);
        TraverseDevices(UPnPDeviceTemplate, AdBuildByeByeAndSend, &type, &destaddr);

        AddressingIP=UpnpIP;
        UPnPSetIP(AddressingIP);
        CreateRootDeviceDesc();

        //now = POSEClockGetTick();
	now = time(&t);
        //UpnpAdExpireTime=now + ADVERTISEMENT_DURATION;
        UpnpAdExpireTime=now + RESEND_AD_DURATION;
        TraverseDevices(UPnPDeviceTemplate, AdBuildAndSend, &type, &destaddr);
        }
    }
    return 0;
}
/* vim:set sw=4 sts=4 sta si expandtab: */
