#ifndef _UPNP_
#define _UPNP_

#define DEBUG   1 

#define CS      1 

#if CS
#define PS      0
#else
#define PS      1 
#endif

#if CS
#define SubUPnPDevInit  SubUPnPCSInit
#elif PS
#define SubUPnPDevInit  SubUPnPPSInit
#endif

#define UPNP_MULTICAST_IP   0xfaffffefL      
#define UPNP_MULTICAST_IP_ASCII  "239.255.255.250" 
#define UPNP_MULTICAST_PORT 1900    
#define SERVICE_COUNT   2   
#define MAX_ACTION      4   
#define MAX_PRINTER_ATTRIBUTES      22  
#define MAX_JOB_ATTRIBUTES          12  
#define HTTP_ALT_PORT   8008
#define WEBCACHE_PORT   8080
#define TPROXY_PORT     8081


#define PRINTBASIC      0   
#define POWER           1   

#define UPNP_TYPE       128 
#define UPNP_URL        64
#define UPNP_NAME       32  
#define UPNP_STRING     64  
#define UPNP_SID        44  
#define UPNP_PAYLOAD    1460    
#define UPNP_DOC_SIZE   4096
#define UPNP_READ_BUF   2048    
#define UPNP_HTTP_LINE_LEN  80  
#define UPNP_RECV_BUF_SIZE  6144 
#define UPNP_SEND_BUF_SIZE  2048
#define UPNP_DEV_RECV_SLOT_SIZE  2048

#if 0
#define ADVERTISEMENT_DURATION  1800*18
#define RESEND_AD_DURATION      180*18
#define SUBSCRIPTION_DURATION 1800*18
#endif
#define ADVERTISEMENT_DURATION  1800
#define RESEND_AD_DURATION      180
#define SUBSCRIPTION_DURATION 1800

#define TICK_25_SECONDS      450  /* 25 seconds */
#define TICK_30_SECONDS      540  /* 30 seconds */
#define TICK_20_SECONDS      360  /* 20 seconds */
#define SEARCH_IGD_DURATION      6*60*18  /* 6 minutes*/
#if DEBUG
#define UPNP_DEV_INIT_WAIT       18*16  /* 16 seconds */
#else
#define UPNP_DEV_INIT_WAIT       18*6  /* 6 seconds */
#endif

#define UPNP_FG_CONTINUE        0
#define UPNP_FG_UNREGISTER      -1  
#define UPNP_SUCCESS        0
#define UPNP_FAILURE        -1

typedef struct 
_NOTIFY_STRUCT
{
  char * headers;
  char propertySet[1024];
  char serviceId[UPNP_TYPE];
  char UDN[UPNP_TYPE];
  char sid[UPNP_SID];
  int eventKey;
//  int *reference_count;
//  UpnpDevice_Handle device_handle;
}
NOTIFY_STRUCT;


typedef enum 
_DATA_TYPE
{
    STRING, 
    I4, 
    UPNPBOOL, 
    URI,
    CSV
}
DATA_TYPE;

typedef struct 
_STATE_VARIABLE
{
    char vname[UPNP_NAME];
    int  eventable;
    int evented;
    DATA_TYPE  type;
    union
    {
        char str[UPNP_STRING];
        long val;   
    }vdata;
    char defval[UPNP_STRING];
    char last[UPNP_STRING];
}STATE_VARIABLE;


typedef struct 
_SUBSCRIPTION 
{
  char sid[UPNP_SID];
  int eventKey;         /*Referenced by Event Happen Handling Module
                         *The eventKey will be assigned before(not when) event happened.
                         *So, it point to the next assign number.
                         */
  int ToSendEventKey;   /*Referenced by Event Sending Module
                         *The next event key to send*, If the previous event 
                         *key has not been sent, these 2 field ToSendEventKey=eventKey-1
                         */
  NOTIFY_STRUCT *NotifyStruct;
  nuint32 expireTime;
  int active;
  nuint16 connect_state;
#if 0
  URL_list DeliveryURLs;
#endif
  char  *DeliveraryURLs;
  char  DeliveraryIP[16];
  char  DeliveraryPort[6];
  char  DeliveraryPath[64];
#if 0
  int   gena_port_local;
#endif
  int   gena_sock_fd;
  //struct TimerDataStructure timer;
  struct _SUBSCRIPTION *next;
}
SUBSCRIPTION;

#if 0
typedef struct 
_STATE_VARIABLE
{
    char name[32];
    int  type;
    union
    {
    char str[32];
    long val;   
    }vdata;
    struct STATEVAR *next;
}STATE_VARIABLE;
#endif

typedef struct _UPNP_ACTION_REQUEST
{
  int fd;
  /** The result of the operation. */
  int ErrCode;
  int Socket;
  /** The error string in case of error */
  //char ErrStr[LINE_SIZE];
  struct _UPNP_DEVICE *UPnPDevice;
  struct _SERVICE_TABLE *pService;
  struct _UPNP_JOB *Job;
  //int service;
  int action;
  //int printer_port;
  //char target_value[UPNP_PAYLOAD];
  char *target_value;

}UPNP_ACTION_REQUEST, *PUPNP_ACTION_REQUEST;

typedef int (*func_ptr_t)(PUPNP_ACTION_REQUEST, char *);

typedef struct _UPNP_ACTION_ARG
{
    char name[UPNP_NAME];
    char value[UPNP_STRING];
    int InOut;
}
UPNP_ACTION_ARG, *PUPNP_ACTION_ARG;


typedef struct 
_ACTION
{
    char aname[UPNP_NAME];
    func_ptr_t  afunc; 
    PUPNP_ACTION_ARG    ActionArg;
//  struct ACTION   *next;
}
ACTION;


typedef struct _UPNP_JOB
{
   struct _UPNP_JOB * next;
   struct _UPNP_JOB * prev;
   int state;
   int fd;
   int port;
   int linefeed;
   char * mbuf;
   int mlen;
   long content_length;
   long print_data_len;
   long printed_data_len;
   int pcm_new_job;
   nuint32 expireTime;
   //struct TimerDataStructure upnp_timer;
   unsigned int version;
   unsigned int operation_id;
   unsigned long request_id;
   long job_id;
   char PathQuery[UPNP_STRING];
   unsigned int err;
   STATE_VARIABLE   sst[MAX_JOB_ATTRIBUTES];
}
UPNP_JOB, *PUPNP_JOB;


typedef struct 
_SERVICE_TABLE 
{
  char *desc;
  char serviceType[UPNP_TYPE];
  char serviceId[UPNP_TYPE];
  char SCPDURL[UPNP_URL] ;
  char controlURL[UPNP_URL];
  char eventURL[UPNP_URL];
  STATE_VARIABLE    sst[MAX_PRINTER_ATTRIBUTES];
  ACTION    action[MAX_ACTION];
  int active;
  int TotalSubscriptions;
  SUBSCRIPTION *subscriptionHead;
  SUBSCRIPTION *subscriptionTail;
  int subduration;
  /*Service Specific Field*/
  PUPNP_JOB JobHead;
  PUPNP_JOB JobTail;
//  char DataSinkURL[UPNP_URL] ;
  struct _SERVICE_TABLE * next;
}
SERVICE_TABLE, *PSERVICE_TABLE;

typedef struct 
_UPNP_DEVICE 
{
    char IP[16];
    char *desc;
    int  RootDevice;
    int  Port;
    char DeviceType[UPNP_TYPE];
    char URLBase[UPNP_URL];
    char UDN[UPNP_TYPE];
    char UPC[UPNP_STRING];
    char DescDocURL[UPNP_URL];
    char FriendlyName[64];
    char ServerName[48];
    char PresURL[UPNP_URL];
    unsigned long AdvrTimeOut;
    //int  AdvrTimeOut;
    PSERVICE_TABLE pService;
    struct _UPNP_DEVICE *Embedded;
    struct _UPNP_DEVICE *Sibiling;
}
UPNP_DEVICE, *PUPNP_DEVICE;


#if 0
typedef struct _CALLBACK_ADDR {
    char IP[16];
    char Port[6];
    char Path[64];
} CALLBACK_ADDR;
#endif

extern unsigned long UpnpIP;
extern PUPNP_DEVICE UPnPDeviceTemplate;

extern char far IGD[];
extern char far PPP_CONN[];
extern char far IP_CONN[];

extern char far MULTI_HOST[29];
extern char far SERVER[30];
extern char far HTTP200[18];
extern char far NOTIFY[20];
extern char far SEARCH[22];
extern char far AGENT[53];

extern char far BYEBYE_NONTS[12];
extern char far BYEBYE[19];
extern char far ALIVE[18];
extern char far ALL[11];
extern char far DISCOVER[16];

extern char far UPNP_OS_VER[11];
extern char far UPNP_VER[9];
extern char far UPNP_HTTP_VER[9];
extern char far UPNP_HTTP_VER_10[9];
extern char far UPNP_OK[3];

extern char far M_NOTIFY[7];
extern char far M_GET[4];
extern char far M_POST[5];

extern char far H_SERVER[7];
extern char far H_HOST[5];
extern char far H_SID[4];
extern char far H_SEQ[4];
extern char far H_EXT[4];
extern char far H_CALLBACK[9];
extern char far H_TIMEOUT[8];
extern char far H_NT[3];
extern char far H_NTS[4];
extern char far H_ST[3];
extern char far H_USN[4];
extern char far H_CACHE[14];
extern char far H_LOCATION[9];
extern char far H_CONN[11];
extern char far H_CONTENT_TYPE[13];
extern char far H_CONTENT_LEN[15];
extern char far H_MAN[4];
extern char far H_MX[3];
extern char far H_ACCEPT[7];
extern char far H_USER_AGENT[11];
extern char far H_SOAPACTION[11];

extern char far UPNP_UPNP[5];
extern char far UPNP_EVENT[11];
extern char far UPNP_PROPCHANGE[16];
extern char far UPNP_ROOT[16];
extern char far UPNP_TEXT_XML[9];
extern char far UPNP_APP_XML[16];
extern char far UPNP_CHARSET[8];
extern char far UPNP_UTF_8[8];
extern char far UPNP_CLOSE[6];
extern char far UPNP_KEEP_ALIVE[11];

extern char far UPNP_ASTERISK[2];
extern char far UPNP_SPACE[2];
extern char far UPNP_DCOLON[3];
extern char far UPNP_SCOLON[2];
extern char far UPNP_SEMICOLON[2];
extern char far UPNP_EQU[2];
extern char far UPNP_ZERO[2];
extern char far UPNP_CRLF[3];
extern char far UPNP_SLASH[2];
extern char far UPNP_LAB[2];
extern char far UPNP_RAB[2];
extern char far UPNP_LPB[2];
extern char far UPNP_RPB[2];
extern char far UPNP_COMMA[2];
extern char far UPNP_HASH[2];
extern char far UPNP_QUOTE_DBL[2];
extern char far UPNP_DASH[2];

extern char far UPNP_SEC[8];
extern char far UPNP_MAX_AGE[8];
extern char far UPNP_UUID[5];

extern char far UPNP_NS_ANY[2];
extern char far UPNP_NS_U[2];
extern char far UPNP_PROPERTY[11];
extern char far UPNP_PROPSET[14];
extern char far UPNP_NS_EVENT[41];
extern char far UPNP_NS[6];
extern char far UPNP_1[2];
extern char far UPNP_0[2];


extern char far UPNP_SCHEMAS_CTRL[];
extern char far UPNP_SCHEMAS_EVENT[];
extern char far UPNP_QUERY[19];
extern char far UPNP_VARNAME[8];


extern char far XML_DECL[22];
extern char far XML_ENCODING[9];
extern char far UPNP_SOAP_S[133];
extern char far UPNP_SOAP_E[23];
extern char far UPNP_Q_SST_S[82];
extern char far UPNP_Q_SST_E[41];

extern char far UPNP_HTTP_SCHEME[5];
extern char far UPNP_DISPATCH_PORT[5];




#endif  /*_UPNP_*/ 
