#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pthread.h>
#include "upnp_types.h"
#include "fmt_cvt.h"
#include "upnp.h"
#include "http_pas.h"
#include "upnp_utl.h"
#include "dbgtrace.h"
extern int AdBuildAndSend(PUPNP_DEVICE UPnPDevice, void *para1, void *para2);
extern int16 upnp_ad_sock_fd;
extern int IGDAdHandler(http_message *message, struct  sockaddr *remoteaddr);

extern char far ntst[128];
extern char far usn[128];
extern char far cache[32];
extern char far AdData[512];
char far mlisten_recvbuf[512];

int16 upnp_multi_listen_sock_fd = -1;


int build_search_response(char *AdData, char* cache, char *urlbase, char* descurl, char *server, char* ntst, char* usn)
{
        strcat(AdData, HTTP200);
        strcat(AdData, cache);
        strcat(AdData, H_EXT);
        strcat(AdData, UPNP_SCOLON); 
        strcat(AdData, UPNP_SPACE); 
        strcat(AdData, UPNP_CRLF);
        strcat(AdData, H_LOCATION); 
        strcat(AdData, UPNP_SCOLON); 
        strcat(AdData, UPNP_SPACE); 
        strcat(AdData, urlbase);
        strcat(AdData, descurl);
        strcat(AdData, UPNP_CRLF);
        strcat(AdData, server); 
        strcat(AdData, ntst); 
        strcat(AdData, usn); 
        strcat(AdData, UPNP_CRLF);
        return 0;
}

int SearchResponse2(PUPNP_DEVICE UPnPDevice, void *para1, void *para2)
{
    int sockaddrlen=16;
    PSERVICE_TABLE  pService;
    //http_header *list=(http_header *)para1;
    char *buf_ahead=(char *)para1;
    struct  sockaddr *remoteaddr=(struct sockaddr *)para2;

        /*Search By UDN*/
        if (!strncmp(buf_ahead, UPnPDevice->UDN, strlen(UPnPDevice->UDN)))
        {
            memset(AdData, 0, 512);

            memset(ntst, 0, 128);
            strcat(ntst, H_ST); 
            strcat(ntst, UPNP_SCOLON);
            strcat(ntst, UPNP_SPACE); 
            strcat(ntst, UPnPDevice->UDN);
            strcat(ntst, UPNP_CRLF);

            memset(usn, 0, 128);
            strcat(usn, H_USN); 
            strcat(usn, UPNP_SCOLON);
            strcat(usn, UPNP_SPACE); 
            strcat(usn, UPnPDevice->UDN);
            strcat(usn, UPNP_CRLF);

            build_search_response(AdData, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, SERVER, ntst, usn);
            sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)remoteaddr, sockaddrlen);
        }
        /*Search By DeviceType*/
        else if (!strncmp(buf_ahead, UPnPDevice->DeviceType, strlen(UPnPDevice->DeviceType)))
        {
            memset(AdData, 0, 512);

            memset(ntst, 0, 128);
            strcat(ntst, H_ST); 
            strcat(ntst, UPNP_SCOLON);
            strcat(ntst, UPNP_SPACE); 
            strcat(ntst, UPnPDevice->DeviceType);
            strcat(ntst, UPNP_CRLF);

            memset(usn, 0, 128);
            strcat(usn, H_USN); 
            strcat(usn, UPNP_SCOLON);
            strcat(usn, UPNP_SPACE); 
            strcat(usn, UPnPDevice->UDN);
            strcat(usn, UPNP_DCOLON); 
            strcat(usn, UPnPDevice->DeviceType);
            strcat(usn, UPNP_CRLF);

            build_search_response(AdData, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, SERVER, ntst, usn);
            sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)remoteaddr, sockaddrlen);
        }
        /*Search By ServiceType*/
        else
        {
            for (pService=UPnPDevice->pService;pService;pService=pService->next)
            {
                if (!strncmp(buf_ahead, pService->serviceType, strlen(pService->serviceType)))
                {
                    memset(AdData, 0, 512);

                    memset(ntst, 0, 128);
                    strcat(ntst, H_ST); 
                    strcat(ntst, UPNP_SCOLON);
                    strcat(ntst, UPNP_SPACE); 
                    strcat(ntst, pService->serviceType);
                    strcat(ntst, UPNP_CRLF);

                    memset(usn, 0, 128);
                    strcat(usn, H_USN); 
                    strcat(usn, UPNP_SCOLON);
                    strcat(usn, UPNP_SPACE); 
                    strcat(usn, UPnPDevice->UDN);
                    strcat(usn, UPNP_DCOLON); 
                    strcat(usn, pService->serviceType);
                    strcat(usn, UPNP_CRLF);

                    build_search_response(AdData, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, SERVER, ntst, usn);
                    sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)remoteaddr, sockaddrlen);
                    break;
                }
            }
        }
        return 0;
}

int SearchResponse(PUPNP_DEVICE UPnPDevice, void *para1, void *para2)
{
    int sockaddrlen=16;
    PSERVICE_TABLE  pService;
    http_header *list=(http_header *)para1;
    struct  sockaddr *remoteaddr=(struct sockaddr *)para2;

        /*Search By UDN*/
        if (!strncmp(list->value.buff, UPnPDevice->UDN, list->value.size) &&
                        (list->value.size == strlen(UPnPDevice->UDN))
           )
        {
            memset(AdData, 0, 512);

            memset(ntst, 0, 128);
            strcat(ntst, H_ST); 
            strcat(ntst, UPNP_SCOLON);
            strcat(ntst, UPNP_SPACE); 
            strcat(ntst, UPnPDevice->UDN);
            strcat(ntst, UPNP_CRLF);

            memset(usn, 0, 128);
            strcat(usn, H_USN); 
            strcat(usn, UPNP_SCOLON);
            strcat(usn, UPNP_SPACE); 
            strcat(usn, UPnPDevice->UDN);
            strcat(usn, UPNP_CRLF);

            build_search_response(AdData, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, SERVER, ntst, usn);
            sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)remoteaddr, sockaddrlen);
        }
        /*Search By DeviceType*/
        else if (!strncmp(list->value.buff, UPnPDevice->DeviceType, list->value.size))
        {
            memset(AdData, 0, 512);

            memset(ntst, 0, 128);
            strcat(ntst, H_ST); 
            strcat(ntst, UPNP_SCOLON);
            strcat(ntst, UPNP_SPACE); 
            strcat(ntst, UPnPDevice->DeviceType);
            strcat(ntst, UPNP_CRLF);

            memset(usn, 0, 128);
            strcat(usn, H_USN); 
            strcat(usn, UPNP_SCOLON);
            strcat(usn, UPNP_SPACE); 
            strcat(usn, UPnPDevice->UDN);
            strcat(usn, UPNP_DCOLON); 
            strcat(usn, UPnPDevice->DeviceType);
            strcat(usn, UPNP_CRLF);

            build_search_response(AdData, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, SERVER, ntst, usn);
            sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)remoteaddr, sockaddrlen);
        }
        /*Search By ServiceType*/
        else
        {
            for (pService=UPnPDevice->pService;pService;pService=pService->next)
            {
                if (!strncmp(list->value.buff, pService->serviceType, list->value.size))
                {
                    memset(AdData, 0, 512);

                    memset(ntst, 0, 128);
                    strcat(ntst, H_ST); 
                    strcat(ntst, UPNP_SCOLON);
                    strcat(ntst, UPNP_SPACE); 
                    strcat(ntst, pService->serviceType);
                    strcat(ntst, UPNP_CRLF);

                    memset(usn, 0, 128);
                    strcat(usn, H_USN); 
                    strcat(usn, UPNP_SCOLON);
                    strcat(usn, UPNP_SPACE); 
                    strcat(usn, UPnPDevice->UDN);
                    strcat(usn, UPNP_DCOLON); 
                    strcat(usn, pService->serviceType);
                    strcat(usn, UPNP_CRLF);

                    build_search_response(AdData, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, SERVER, ntst, usn);
                    sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)remoteaddr, sockaddrlen);
                    break;
                }
            }
        }
        return 0;
}

void *UPnPMultiListen2(void *arg)
{
    UPNP_DEVICE *UPnPDevice=UPnPDeviceTemplate;
    int len;
    int sockaddrlen=16;
    struct  sockaddr remoteaddr;
    int type=1;
    char *buf_ahead;
    int sret;
    fd_set readfds;
    struct timeval timeToWait;


    /*Use while(1) to receive all data in 239:255:255:250:1900 queue.*/
    while (1) {
        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_MLISTEN, 
                "***************&&&&&&&&&&&&&&&&UPnPMultiListen2, while\n");
        memset(AdData, 0, 512);
        memset(mlisten_recvbuf, 0, 512);
        len = recvfrom(upnp_multi_listen_sock_fd, mlisten_recvbuf, 512, 0, 
                (struct sockaddr *)&remoteaddr, (socklen_t *)&sockaddrlen);
        if (len == 0) {
            perror("peer socket closed");
        } else if (-1 == len) {
            perror("mlisten socket fail");
            sleep(1);
        } else if (len > 0) {
            //buf_ahead=strstr(mlisten_recvbuf, H_ST);
            buf_ahead=strstr(mlisten_recvbuf, "\r\nST:");
            if (buf_ahead) {

                DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_MLISTEN,
                        "mlisten_recvbuf =\r\n%s\r\n", mlisten_recvbuf);
                //buf_ahead=buf_ahead+3;
                buf_ahead=buf_ahead+5;
                if (*buf_ahead == 0x20) {
                    buf_ahead++;
                }

                /*Search By "ssdp:all"*/
                if (!strncmp(buf_ahead, ALL, strlen(ALL)))
                {
                    TraverseDevices(UPnPDeviceTemplate, AdBuildAndSend, &type, &remoteaddr);
                }
                /*Search By "upnp:rootdevice\r\n"*/
                else if (!strncmp(buf_ahead, UPNP_ROOT, strlen(UPNP_ROOT)))
                {
                    memset(AdData, 0, 512);
                    memset(ntst, 0, 128);
                    strcat(ntst, H_ST);
                    strcat(ntst, UPNP_SCOLON);
                    strcat(ntst, UPNP_SPACE);
                    strcat(ntst, UPNP_ROOT);
                    strcat(ntst, UPNP_CRLF);

                    memset(usn, 0, 128);
                    strcat(usn, H_USN); 
                    strcat(usn, UPNP_SCOLON);
                    strcat(usn, UPNP_SPACE);
                    strcat(usn, UPnPDevice->UDN);
                    strcat(usn, UPNP_DCOLON);
                    strcat(usn, UPNP_ROOT);
                    strcat(usn, UPNP_CRLF);

                    build_search_response(AdData, cache, UPnPDevice->URLBase, 
                            UPnPDeviceTemplate->DescDocURL, SERVER, ntst, usn);
                    sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)&remoteaddr, sockaddrlen);
                }
                else
                {
                    TraverseDevices(UPnPDeviceTemplate, SearchResponse2, buf_ahead, &remoteaddr); 
                }
            }
        }
    }
#if 0
    while (1) {
        memset(AdData, 0, 512);
        memset(mlisten_recvbuf, 0, 512);
        timeToWait.tv_sec = 3;
        timeToWait.tv_usec = 0;
        FD_ZERO(&readfds);
        FD_SET(upnp_multi_listen_sock_fd, &readfds);
        sret = select(upnp_multi_listen_sock_fd+ 1, &readfds, (fd_set *)0, (fd_set *)0, (struct timeval *)&timeToWait );
        if (-1 == sret) {
            perror("UPnPMultiListen2 select");
        } else {
            if (FD_ISSET(upnp_multi_listen_sock_fd, &readfds)) {
                len = recvfrom(upnp_multi_listen_sock_fd, mlisten_recvbuf, 512, 0, 
                        (struct sockaddr *)&remoteaddr, (socklen_t *)&sockaddrlen);
                if (len == 0) {
                    perror("peer socket closed");
                } else if (-1 == len) {
                    perror("socket fail");
                } else if (len > 0) {
                    //buf_ahead=strstr(mlisten_recvbuf, H_ST);
                    buf_ahead=strstr(mlisten_recvbuf, "\r\nST:");
                    if (buf_ahead) {

                        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_MLISTEN,
                                "mlisten_recvbuf =\rn%s\r\n", mlisten_recvbuf);
                        //buf_ahead=buf_ahead+3;
                        buf_ahead=buf_ahead+5;
                        if (*buf_ahead == 0x20) {
                            buf_ahead++;
                        }

                        /*Search By "ssdp:all"*/
                        if (!strncmp(buf_ahead, ALL, strlen(ALL)))
                        {
                            TraverseDevices(UPnPDeviceTemplate, AdBuildAndSend, &type, &remoteaddr);
                        }
                        /*Search By "upnp:rootdevice\r\n"*/
                        else if (!strncmp(buf_ahead, UPNP_ROOT, strlen(UPNP_ROOT)))
                        {
                            memset(AdData, 0, 512);
                            memset(ntst, 0, 128);
                            strcat(ntst, H_ST);
                            strcat(ntst, UPNP_SCOLON);
                            strcat(ntst, UPNP_SPACE);
                            strcat(ntst, UPNP_ROOT);
                            strcat(ntst, UPNP_CRLF);

                            memset(usn, 0, 128);
                            strcat(usn, H_USN); 
                            strcat(usn, UPNP_SCOLON);
                            strcat(usn, UPNP_SPACE);
                            strcat(usn, UPnPDevice->UDN);
                            strcat(usn, UPNP_DCOLON);
                            strcat(usn, UPNP_ROOT);
                            strcat(usn, UPNP_CRLF);

                            build_search_response(AdData, cache, UPnPDevice->URLBase, 
                                    UPnPDeviceTemplate->DescDocURL, SERVER, ntst, usn);
                            sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)&remoteaddr, sockaddrlen);
                        }
                        else
                        {
                            TraverseDevices(UPnPDeviceTemplate, SearchResponse2, buf_ahead, &remoteaddr); 
                        }
                    }
                }
            }
        }
    }
#endif
    pthread_exit(NULL);
}


int UPnPMultiListen(void)
{
    UPNP_DEVICE *UPnPDevice=UPnPDeviceTemplate;
    int len;
    int sockaddrlen=16;
    struct  sockaddr remoteaddr;
    http_message message;
    http_header *list;
    int type=1;

    /*Use while(1) to receive all data in 239:255:255:250:1900 queue.*/
    while (1)
    {
    memset(AdData, 0, 512);
    memset(mlisten_recvbuf, 0, 512);
    //len = recvfrom(upnp_multi_listen_sock_fd, mlisten_recvbuf, 512, 0, &remoteaddr, &sockaddrlen);
    len = recvfrom(upnp_multi_listen_sock_fd, mlisten_recvbuf, 512, 0, (struct sockaddr *)&remoteaddr, (socklen_t *)&sockaddrlen);
    if (len <= 0)
    {
        break;
    }

    if (parse_http_request(mlisten_recvbuf, &message, strlen(mlisten_recvbuf))== -1)
    {
        free_http_headers(message.header_list);
        message.header_list=NULL;
        continue;
    }

    list=message.header_list;
    while (list)
    {
        HttpHeaderToUpper(list->header.buff, list->header.size);
        if (strncmp(list->header.buff, H_ST, list->header.size))
            list=list->next;
        else
            break;
    }

    if (list)
    {
        /*Search By "ssdp:all"*/
        if (!strncmp(list->value.buff, ALL, strlen(ALL)))
        {
            TraverseDevices(UPnPDeviceTemplate, AdBuildAndSend, &type, &remoteaddr);
        }
        /*Search By "upnp:rootdevice\r\n"*/
        else if (!strncmp(list->value.buff, UPNP_ROOT, strlen(UPNP_ROOT)))
        {
            memset(AdData, 0, 512);
            memset(ntst, 0, 128);
            strcat(ntst, H_ST);
            strcat(ntst, UPNP_SCOLON);
            strcat(ntst, UPNP_SPACE);
            strcat(ntst, UPNP_ROOT);
            strcat(ntst, UPNP_CRLF);

            memset(usn, 0, 128);
            strcat(usn, H_USN); 
            strcat(usn, UPNP_SCOLON);
            strcat(usn, UPNP_SPACE);
            strcat(usn, UPnPDevice->UDN);
            strcat(usn, UPNP_DCOLON);
            strcat(usn, UPNP_ROOT);
            strcat(usn, UPNP_CRLF);

            build_search_response(AdData, cache, UPnPDevice->URLBase, UPnPDeviceTemplate->DescDocURL, SERVER, ntst, usn);
            sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)&remoteaddr, sockaddrlen);
        }
        else
        {
        TraverseDevices(UPnPDeviceTemplate, SearchResponse, list, &remoteaddr); 
        }
    }
#if 0 
    else
    {
        //SerialDisplayBuf("m0", 3);
        IGDAdHandler(&message, &remoteaddr);
    }
#endif

    if (message.header_list)
    {
        free_http_headers(message.header_list);
        message.header_list=NULL;
    }
    }

    return 0;
}


int UPnPMultiListenInit(void)
{
    nint16 MultiListenPort = UPNP_MULTICAST_PORT;
    struct  sockaddr_in  MultiListenlocaladdr;
    nint16 sockaddrlen=16;
    int ret;
    int returnStatus = UPNP_SUCCESS;
    struct ip_mreq mreq;
    u_int yes=1;            /*** MODIFICATION TO ORIGINAL */



    MultiListenlocaladdr.sin_family = AF_INET;
    //MultiListenlocaladdr.sin_addr.s_addr = UPNP_MULTICAST_IP;
    MultiListenlocaladdr.sin_addr.s_addr = htonl(INADDR_ANY); 
    //MultiListenlocaladdr.sin_port = ntohs(MultiListenPort);
    MultiListenlocaladdr.sin_port = htons(MultiListenPort);

    upnp_multi_listen_sock_fd = socket(AF_INET, SOCK_DGRAM, 0);
    if (upnp_multi_listen_sock_fd<=0)
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }

    /**** MODIFICATION TO ORIGINAL */
    /* allow multiple sockets to use the same PORT number */
    if (setsockopt(upnp_multi_listen_sock_fd,SOL_SOCKET,SO_REUSEADDR,&yes,sizeof(yes)) < 0) {
        perror("Reusing ADDR failed");
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }

    ret=bind(upnp_multi_listen_sock_fd, (struct sockaddr *)&MultiListenlocaladdr, sockaddrlen);
    if (ret !=0)
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }

    /* use setsockopt() to request that the kernel join a multicast group */
    mreq.imr_multiaddr.s_addr=(UPNP_MULTICAST_IP);
    //mreq.imr_multiaddr.s_addr=inet_addr("239.255.255.0");
    //mreq.imr_interface.s_addr=inet_addr("192.168.98.180");
    //mreq.imr_interface.s_addr=UpnpIP;
    //mreq.imr_interface.s_addr=htonl(UpnpIP);
    mreq.imr_interface.s_addr=htonl(INADDR_ANY);
    if (setsockopt(upnp_multi_listen_sock_fd,IPPROTO_IP,IP_ADD_MEMBERSHIP,&mreq,sizeof(mreq)) < 0) {
        perror("setsockopt");
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }

Exit:
    if (returnStatus!=UPNP_SUCCESS)
    {
        if (upnp_multi_listen_sock_fd>=0)
            close(upnp_multi_listen_sock_fd);
    }

    return returnStatus;
}
/* vim:set sw=4 sts=4 si sta expandtab: */
