#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "upnp_types.h"
#include "fmt_cvt.h"
#include "upnp.h"
#include "upnp_utl.h"
#include "http_pas.h"
#include "dispatch.h"
#include "xml_dump.h"
#include "xml_enti.h"
#include "xml_tree.h"
#include "xml_ext.h"
#include "xml_mem.h"
#if 0
extern void add_timer(struct TimerDataStructure * timer);
extern int del_timer(struct TimerDataStructure * timer);
#endif
extern char far UPnPSendBuf[UPNP_SEND_BUF_SIZE];

#if 0
char far PropertySetBuf[1000];
char far PropertySet[1000];

#define GenaPortBase    63000L 
#define GenaPortEnd     63999L  
nuint16 GenaPort=(unsigned int)GenaPortBase;

#define GENA_DISCONNECT     0
#define GENA_WAIT_CONNECT   1
#define GENA_CONNECTED      2
#define GENA_WAIT_RECV_RESP 3
#define GENA_COMPLETE       4   
#define GENA_IDLE           5   

void upnp_timeout(SUBSCRIPTION * tmpdata)
{
   if ( tmpdata->gena_sock_fd >= 0 )
      close(tmpdata->gena_sock_fd);
   tmpdata->connect_state = GENA_IDLE;
   tmpdata->ToSendEventKey++;
}


int UpnpAddPropertySet(char *PropertySet, char *vname, char *vdata)
{

    strcat(PropertySet, UPNP_LAB); 
    strcat(PropertySet, UPNP_PROPERTY); 
    strcat(PropertySet, UPNP_RAB); 
    strcat(PropertySet, UPNP_LAB); 
    strcat(PropertySet, vname);
    strcat(PropertySet, UPNP_RAB); 
    strcat(PropertySet, vdata);
    strcat(PropertySet, UPNP_LAB); 
    strcat(PropertySet, UPNP_SLASH); 
    strcat(PropertySet, vname);
    strcat(PropertySet, UPNP_RAB); 
    strcat(PropertySet, UPNP_LAB); 
    strcat(PropertySet, UPNP_SLASH); 
    strcat(PropertySet, UPNP_PROPERTY); 
    strcat(PropertySet, UPNP_RAB); 

    return 0;
}

int GenaNotify(SUBSCRIPTION *sub)
{
    nint16 sockaddrlen=16;
    unsigned long  GenaCallbackIP = 0;
    unsigned long  GenaCallbackPort = 0;
    struct  sockaddr_in  GenaRemoteaddr;
    struct  sockaddr_in  Genalocaladdr;
    unsigned char tmp[10];
    int len;
    int ret;
    char respbuf[32];

    while (1)
    {
    switch (sub->connect_state)
    {
    case GENA_DISCONNECT:
    {
#if 0 
    del_timer(&sub->timer);
    sub->timer.TCallBackWaitTime = RESPONSE_TIMEOUT;
    add_timer(&sub->timer);
#endif
    Genalocaladdr.sin_family = AF_INET;
    Genalocaladdr.sin_addr.s_addr = UpnpIP;
    Genalocaladdr.sin_port = ntohs(GenaPort);

    sub->gena_sock_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (sub->gena_sock_fd<=0)
    {
        POSEThreadYield();
        break;
    }
    ret=bind(sub->gena_sock_fd, (struct sockaddr *)&Genalocaladdr, sockaddrlen);
    if (ret !=0)
    {
        close(sub->gena_sock_fd);
        POSEThreadYield();
        break;
    }

    GenaCallbackIP=addr_ipatol(sub->DeliveraryIP, 1); 
    GenaCallbackPort=(unsigned long)atol(sub->DeliveraryPort);

    GenaRemoteaddr.sin_family = AF_INET;
    GenaRemoteaddr.sin_addr.s_addr = GenaCallbackIP;
    GenaRemoteaddr.sin_port = ntohs(GenaCallbackPort);

    ret=connect(sub->gena_sock_fd,(struct sockaddr *)&GenaRemoteaddr, sockaddrlen);
    sub->connect_state=GENA_WAIT_CONNECT;
    break;
    }
    case GENA_WAIT_CONNECT:
    {
        ret = check_conn(sub->gena_sock_fd);
        if (ret!=0)
        {
            POSEThreadYield();
            break;
        }
        sub->connect_state=GENA_CONNECTED;
        break;
    }
    case GENA_CONNECTED:
    {
    len=strlen(sub->NotifyStruct->propertySet);
    NWitoa(len, tmp, 10); 
    memset(UPnPSendBuf, 0, UPNP_SEND_BUF_SIZE);
    strcat(UPnPSendBuf, M_NOTIFY);
    strcat(UPnPSendBuf, UPNP_SPACE);
    strcat(UPnPSendBuf, UPNP_SLASH);
    strcat(UPnPSendBuf, sub->DeliveraryPath);
    strcat(UPnPSendBuf, UPNP_SPACE);
    strcat(UPnPSendBuf, UPNP_HTTP_VER);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_HOST);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, sub->DeliveraryIP);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, sub->DeliveraryPort);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_CONTENT_TYPE);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, UPNP_TEXT_XML);
    strcat(UPnPSendBuf, UPNP_SEMICOLON);
    strcat(UPnPSendBuf, UPNP_CHARSET);
    strcat(UPnPSendBuf, UPNP_UTF_8);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_CONTENT_LEN);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, (char *)tmp);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_CONN);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, UPNP_CLOSE);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_NT);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, UPNP_EVENT);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_NTS);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, UPNP_PROPCHANGE);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_SID);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, sub->sid);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_SEQ);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    NWitoa(sub->eventKey, tmp, 10);
    strcat(UPnPSendBuf, (char *)tmp);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, sub->NotifyStruct->propertySet);

    UPnPSend(sub->gena_sock_fd, UPnPSendBuf);
    sub->connect_state=GENA_WAIT_RECV_RESP;
    break;
    }
    case GENA_WAIT_RECV_RESP:
        recv(sub->gena_sock_fd, respbuf, 32, 0);
        if (strstr(respbuf, UPNP_OK))
            sub->connect_state=GENA_COMPLETE;
        POSEThreadYield();
        break;
    case GENA_COMPLETE:
        //del_timer(&sub->timer);
        sub->ToSendEventKey++;
        if (sub->ToSendEventKey<0)
            sub->ToSendEventKey=1;

        //free(sub->NotifyStruct);
        close(sub->gena_sock_fd);
        sub->connect_state=GENA_IDLE;
        break;
    case GENA_IDLE:
    default:
        if (++GenaPort >GenaPortEnd )
            GenaPort=(unsigned int)GenaPortBase;
        free(sub->NotifyStruct);
        return 0;
    }
    }/*while*/

    //return 0;
}

int GenaNotifyAll(PUPNP_DEVICE UPnPDevice, PSERVICE_TABLE pService)
{
    SUBSCRIPTION    *tmpsub;
    NOTIFY_STRUCT   *NotifyStruct;
    int evented=0;
    int GenaAllNotified=1;
    int j;
    PRIVILEGED_PROTECT_HANDLE protectID;

    memset(PropertySet, 0, 1000);
    memset(PropertySetBuf, 0, 1000);
#if 0
    for (tmpsub=pService->subscriptionHead; tmpsub != NULL; tmpsub=tmpsub->next)
    {
            if ((tmpsub->ToSendEventKey!=-1) && (tmpsub->eventKey!=tmpsub->ToSendEventKey))
            {
                GenaNotify(tmpsub);
                GenaAllNotified=0;
            }
    }
#endif

    if (GenaAllNotified ==1)
    {
        protectID = POSEPrivilegedProtect();
        for (j=0; j< MAX_PRINTER_ATTRIBUTES; j++)
        {
            if (pService->sst[j].evented)
            {
                UpnpAddPropertySet(PropertySetBuf, 
                            pService->sst[j].vname, 
                            pService->sst[j].vdata.str
                            );
                pService->sst[j].evented=0;
                evented=1;
            }
        }
        POSEPrivilegedUnProtect(protectID);

        if (evented ==1)
        {
        strcat(PropertySet, UPNP_LAB); 
        strcat(PropertySet, UPNP_PROPSET); 
        strcat(PropertySet, UPNP_SPACE); 
        strcat(PropertySet, UPNP_NS_EVENT); 
        strcat(PropertySet, UPNP_RAB); 
        strcat(PropertySet, PropertySetBuf);
        strcat(PropertySet, UPNP_LAB); 
        strcat(PropertySet, UPNP_SLASH); 
        strcat(PropertySet, UPNP_PROPSET); 
        strcat(PropertySet, UPNP_RAB); 
#if 0
        strcat(PropertySet, "<e:propertyset xmlns:e=\"urn:schemas-upnp-org:event-1-0\">");
        strcat(PropertySet, PropertySetBuf);
        strcat(PropertySet, "</e:propertyset>");
#endif
        for (tmpsub=pService->subscriptionHead; tmpsub != NULL; tmpsub=tmpsub->next)
        {
            if (tmpsub->eventKey==tmpsub->ToSendEventKey)
            {
                NotifyStruct=malloc(sizeof(NOTIFY_STRUCT));
                if (NotifyStruct == NULL )
                {
                    return 0;
                }
                tmpsub->NotifyStruct=NotifyStruct;
                strcpy(NotifyStruct->propertySet, PropertySet);
                strcpy(NotifyStruct->serviceId,pService->serviceId);
                strcpy(NotifyStruct->UDN, UPnPDevice->UDN);
                strcpy(NotifyStruct->sid, tmpsub->sid);
                NotifyStruct->eventKey=tmpsub->eventKey++;
                if (tmpsub->eventKey<0)
                    tmpsub->eventKey=1;
                tmpsub->connect_state=GENA_DISCONNECT;
#if 0
                del_timer(&tmpsub->timer);
                tmpsub->timer.TCallBackWaitTime = RESPONSE_TIMEOUT;
                add_timer(&tmpsub->timer);
#else
	/*The timer mechanism must be implemented here.*/
#endif

                GenaNotify(tmpsub);
            }
        }
        }
    }
    return 0;
}

int SubscriberDelete(PSERVICE_TABLE pService, SUBSCRIPTION *S)
{
    SUBSCRIPTION *sub=pService->subscriptionHead;
    SUBSCRIPTION *prev=pService->subscriptionHead;

    while(sub)
    {
        if (sub == S)
        {
            if (sub==pService->subscriptionHead)
            {
            pService->subscriptionHead=
                    pService->subscriptionHead->next;
            free(S);
            pService->TotalSubscriptions--;
            return 0;
            }
            else
            {
                prev->next=sub->next;
                free(S);
                pService->TotalSubscriptions--;
            }
            break;
        }
        else
        {
            prev=sub;
            sub=sub->next;
        }
    }
    return -1;
}

int SubscriberDeleteBySID(PSERVICE_TABLE pService, http_header *list)
{
    SUBSCRIPTION *sub, *prev;

    sub=pService->subscriptionHead;
    prev=pService->subscriptionHead;

    if (sub == NULL)
    {
        /*Response Error Messages*/
        return 0;
    }


    while (list)
    {
        if (strncmp(list->header.buff, H_SID, list->header.size))
            list=list->next;
        else
            break;
    }

    if (list)
    {
        /*Delete First Item*/
        if (!strncmp(list->value.buff, sub->sid, list->value.size))
        {
            pService->subscriptionHead=
                    pService->subscriptionHead->next;
            free(prev);
            pService->TotalSubscriptions--;
            return 0;
        }
        else
        {
            sub=sub->next;
        }
        while (sub)
        {
            if (strncmp(list->value.buff, sub->sid, list->value.size))
            {
                prev=sub;
                sub=sub->next;
            }
            else
            {
                break;
            }
        }

        if (sub)
        {
            if (sub==pService->subscriptionTail)
                pService->subscriptionTail=prev;

            prev->next=sub->next;

            free(sub);
            pService->TotalSubscriptions--;
            return 0;
        }
    }
    return 0;
}

int SIDGenerator(char *SID)
{
    static int num=0;
    unsigned char tmp[16];

    num++;
    NWitoa(num, tmp, 10);
    strcat(SID, UPNP_UUID);
    strcat(SID, UPNP_SCOLON);
    strcat(SID, (char *)tmp);
    return 0;
}


//int   gena_initevent_send(PUPNP_DEVICE UPnPDevice, SUBSCRIPTION *sub, int service)
int gena_initevent_send(PSERVICE_TABLE  pService, SUBSCRIPTION *sub)
{
    nint16 sockaddrlen=16;
    unsigned long  GenaCallbackIP = 0;
    unsigned long  GenaCallbackPort = 0;
    struct  sockaddr_in  GenaRemoteaddr;
    unsigned char tmp[10];
    int len;
    int ret;
    struct  sockaddr_in  Genalocaladdr;
    char respbuf[32];
    int j;

    

    while(1)
    {

    switch (sub->connect_state)
    {
    case GENA_DISCONNECT:
    {
#if 0
    del_timer(&sub->timer);
    sub->timer.TCallBackWaitTime = RESPONSE_TIMEOUT;
    add_timer(&sub->timer);
#endif

    Genalocaladdr.sin_family = AF_INET;
    Genalocaladdr.sin_addr.s_addr = UpnpIP;
    Genalocaladdr.sin_port = ntohs(GenaPort);

    sub->gena_sock_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (sub->gena_sock_fd<=0)
    {
        POSEThreadYield();
        break;
    }
    ret=bind(sub->gena_sock_fd, (struct sockaddr *)&Genalocaladdr, sockaddrlen);
    if (ret !=0)
    {
        close(sub->gena_sock_fd);
        POSEThreadYield();
        break;
    }

    GenaCallbackIP=addr_ipatol(sub->DeliveraryIP, 1); 
    GenaCallbackPort=(unsigned long)atol(sub->DeliveraryPort);

    GenaRemoteaddr.sin_family = AF_INET;
    GenaRemoteaddr.sin_addr.s_addr = GenaCallbackIP;
    GenaRemoteaddr.sin_port = ntohs(GenaCallbackPort);

    ret=connect(sub->gena_sock_fd,(struct sockaddr *)&GenaRemoteaddr, sockaddrlen);
    sub->connect_state=GENA_WAIT_CONNECT;
    break;
    }
    case GENA_WAIT_CONNECT:
    {
        ret = check_conn(sub->gena_sock_fd);
        if (ret!=0)
        {
            POSEThreadYield();
            break;
        }
        sub->connect_state=GENA_CONNECTED;
        break;
    }
    case GENA_CONNECTED:
    {
        memset(PropertySet, 0, 1000);
        memset(PropertySetBuf, 0, 1000);

        for (j=0; j< MAX_PRINTER_ATTRIBUTES; j++)
        {
            if (pService->sst[j].eventable)
            {
                UpnpAddPropertySet(PropertySetBuf, 
                            pService->sst[j].vname, 
                            pService->sst[j].vdata.str
                            );
            }
        }
        //strcat(PropertySet, XML_DECL); 
        strcat(PropertySet, UPNP_LAB); 
        strcat(PropertySet, UPNP_PROPSET); 
        strcat(PropertySet, UPNP_SPACE); 
        strcat(PropertySet, UPNP_NS_EVENT); 
        strcat(PropertySet, UPNP_RAB); 
        strcat(PropertySet, PropertySetBuf);
        strcat(PropertySet, UPNP_LAB); 
        strcat(PropertySet, UPNP_SLASH); 
        strcat(PropertySet, UPNP_PROPSET); 
        strcat(PropertySet, UPNP_RAB); 
#if 0
        strcat(PropertySet, "<e:propertyset xmlns:e=\"urn:schemas-upnp-org:event-1-0\">");
        strcat(PropertySet, PropertySetBuf);
        strcat(PropertySet, "</e:propertyset>");
#endif
        len=strlen(PropertySet);

    NWitoa(len, tmp, 10); 

    memset(UPnPSendBuf, 0, UPNP_SEND_BUF_SIZE);
    strcat(UPnPSendBuf, M_NOTIFY);
    strcat(UPnPSendBuf, UPNP_SPACE);
    strcat(UPnPSendBuf, UPNP_SLASH);
    strcat(UPnPSendBuf, sub->DeliveraryPath);
    strcat(UPnPSendBuf, UPNP_SPACE);
    strcat(UPnPSendBuf, UPNP_HTTP_VER);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_HOST);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, sub->DeliveraryIP);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, sub->DeliveraryPort);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_CONTENT_TYPE);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, UPNP_TEXT_XML);
    //strcat(UPnPSendBuf, UPNP_SEMICOLON);
    //strcat(UPnPSendBuf, UPNP_CHARSET);
    //strcat(UPnPSendBuf, UPNP_UTF_8);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_CONTENT_LEN);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, (char *)tmp);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_NT);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, UPNP_EVENT);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_NTS);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, UPNP_PROPCHANGE);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_SID);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, sub->sid);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, H_SEQ);
    strcat(UPnPSendBuf, UPNP_SCOLON);
    strcat(UPnPSendBuf, UPNP_ZERO); 
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, UPNP_CRLF);
    strcat(UPnPSendBuf, PropertySet);
    //strcat(UPnPSendBuf, sub->NotifyStruct->propertySet);

    //send(sub->gena_sock_fd, UPnPSendBuf, strlen(UPnPSendBuf), 0);
    UPnPSend(sub->gena_sock_fd, UPnPSendBuf);
    sub->connect_state=GENA_WAIT_RECV_RESP;
    break;
    }
    case GENA_WAIT_RECV_RESP:
        recv(sub->gena_sock_fd, respbuf, 32, 0);
        if (strstr(respbuf, UPNP_OK))
            sub->connect_state=GENA_COMPLETE;
        POSEThreadYield();
        break;
    case GENA_COMPLETE:

        //del_timer(&sub->timer);
        sub->ToSendEventKey++;
        if (sub->ToSendEventKey<0)
            sub->ToSendEventKey=1;

        close(sub->gena_sock_fd);
        sub->connect_state=GENA_IDLE;
        break;
    case GENA_IDLE:
    default:
        if (++GenaPort >GenaPortEnd )
            GenaPort=(unsigned int)GenaPortBase;
        return 0;
        //break;
    }
    } /*while*/

    //return 0;
}

int upnp_event(PUPNP_DEVICE UPnPDevice, void *para1, void *para2)
{
    PSERVICE_TABLE  pService;
    SUBSCRIPTION    *tmpsub;
    SUBSCRIPTION    *nextsub;
    nuint32 now;

    for (pService=UPnPDevice->pService;pService;pService=pService->next)
    {
        //for (tmpsub=pService->subscriptionHead; tmpsub != NULL; tmpsub=tmpsub->next)
        for (tmpsub=pService->subscriptionHead; tmpsub != NULL; tmpsub=nextsub)
        {
            nextsub=tmpsub->next;
            now=POSEClockGetTick();
            if (tmpsub->ToSendEventKey==-1)
            {
                //gena_initevent_send(UPnPDevice, tmpsub, i);
                gena_initevent_send(pService, tmpsub);
            }
            else if ((tmpsub->expireTime+30*TICKS_PER_SECOND)<now && tmpsub->connect_state == GENA_IDLE)
            {
                SubscriberDelete(pService, tmpsub);
            }
        }

        GenaNotifyAll(UPnPDevice, pService);
    }

    return 0;
}

int UPnPEvent(void)
{
    TraverseDevices(UPnPDeviceTemplate, upnp_event, NULL, NULL);
    return 0;
}

int gena_get_remoteaddr2(http_message *message, CALLBACK_ADDR   *Callback)
{
    http_header *list;
    int returnStatus=UPNP_SUCCESS;
    list=message->header_list;

    while (list)
    {
        HttpHeaderToUpper(list->header.buff, list->header.size);
        if (strncmp(list->header.buff, H_CALLBACK, list->header.size))
            list=list->next;
        else
            break;
#if 0
        if ((strncmp(list->header.buff, H_CALLBACK_L, list->header.size)) &&
            (strncmp(list->header.buff, H_CALLBACK_U, list->header.size))
           )
            list=list->next;
        else
            break;
#endif
    }

    if (list)
        if ( parse_url(list, Callback) )
            returnStatus=UPNP_FAILURE;
    return returnStatus;
}

#if 0
int gena_get_remoteaddr(char *buf, CALLBACK_ADDR    *Callback)
{
    char *buf_ahead;

    if((buf_ahead=strstr(buf, H_CALLBACK_L))
        ||(buf_ahead=strstr(buf, H_CALLBACK_U)))    /*H_CALLBACK_L has been removed*/

    //if ( (buf_ahead=strstr(duplicatebuf, "Callback:")))  
    {

        parse_callback_value(buf_ahead,Callback);

#if 0
        *GenaCallbackIP=addr_ipatol(Callback.IP, 1); 
        *GenaCallbackPort=(unsigned long)atol(Callback.Port);
#endif
#if 0
        strcpy(uprinter.Service[0].subscriptionList->DeliveraryIP, Callback.IP);
        strcpy(uprinter.Service[0].subscriptionList->DeliveraryPort, Callback.Port);
        strcpy(uprinter.Service[0].subscriptionList->DeliveraryPath, Callback.Path);
#endif
    }
    return 0;
}
#endif

int genacallback(PUPNP_DEVICE UPnPDevice, void *para1, void *para2)
{
    int fd=*(int*)para1;
    http_message *message=para2;

    PSERVICE_TABLE  pService;
    char sid[21];
    SUBSCRIPTION *tmpsub=NULL;
    http_header *list;
    //PRIVILEGED_PROTECT_HANDLE protectID;
    unsigned char tmp[8];
    int found=0;
    CALLBACK_ADDR   Callback;   

    memset(UPnPSendBuf, 0, UPNP_SEND_BUF_SIZE);

        for (pService=UPnPDevice->pService;pService;pService=pService->next)
        {

            if (!strncmp(message->request.request_uri.pathquery.buff,
                    pService->eventURL,
                    message->request.request_uri.pathquery.size))
            {
                found=1;
                break;
            }
        }

    if (pService==NULL)
    {
        /*Response Error Message*/
        //Eventing=0;
        return 0;
    }

    if (!strncmp(message->request.method.buff, "UNSUBSCRIBE", message->request.method.size))
    {
        //protectID = POSEPrivilegedProtect();
        SubscriberDeleteBySID(pService, message->header_list);
        //POSEPrivilegedUnProtect(protectID);

        strcat(UPnPSendBuf, HTTP200); 
        strcat(UPnPSendBuf, UPNP_CRLF); 
        UPnPSend(fd, UPnPSendBuf);
    }
    else
    for (list=message->header_list; list!=NULL; list=list->next)
    {
        if (!strncmp(list->header.buff, H_NT, list->header.size))
        {
        //protectID = POSEPrivilegedProtect();

        tmpsub=malloc(sizeof (SUBSCRIPTION));
        if ( tmpsub == NULL )
        {
            //POSEPrivilegedUnProtect(protectID);
            //Eventing=0;
            return 1;
        }

        memset(tmpsub, 0, sizeof(SUBSCRIPTION));

        tmpsub->gena_sock_fd=-1;
        tmpsub->ToSendEventKey=-1;
        tmpsub->eventKey=0;
        tmpsub->expireTime=POSEClockGetTick()+pService->subduration;
        tmpsub->connect_state=GENA_DISCONNECT;
        tmpsub->next=NULL;

#if 0 
        tmpsub->timer.TCallBackProcedure = (void (*)(void *))upnp_timeout;
        tmpsub->timer.TCallBackEBXParameter = tmpsub;
        del_timer(&tmpsub->timer);
        tmpsub->timer.TCallBackWaitTime = RESPONSE_TIMEOUT;
        add_timer(&tmpsub->timer);
#else
	/*The timer mechanism must be implemented here.*/
#endif

        memset(sid, 0, 21);
        SIDGenerator(sid);
        strcpy(tmpsub->sid, sid);

        if (pService->subscriptionHead==NULL)
        {
            pService->subscriptionHead=tmpsub;
            pService->subscriptionTail=tmpsub;
        }
        else
        {
            pService->subscriptionTail->next=tmpsub;
            pService->subscriptionTail=tmpsub;
        }

        pService->TotalSubscriptions++;


        strcat(UPnPSendBuf, HTTP200); 
        strcat(UPnPSendBuf, SERVER); 
        strcat(UPnPSendBuf, H_SID); 
        strcat(UPnPSendBuf, UPNP_SCOLON); 
        strcat(UPnPSendBuf, tmpsub->sid);
        strcat(UPnPSendBuf, UPNP_CRLF); 
        strcat(UPnPSendBuf, H_TIMEOUT); 
        strcat(UPnPSendBuf, UPNP_SCOLON); 
        strcat(UPnPSendBuf, UPNP_SEC); 
        NWitoa(pService->subduration/TICKS_PER_SECOND, tmp, 10);
        strcat(UPnPSendBuf, (char *)tmp);
        strcat(UPnPSendBuf, UPNP_CRLF); 
        strcat(UPnPSendBuf, H_CONN);
        strcat(UPnPSendBuf, UPNP_SCOLON);
        strcat(UPnPSendBuf, UPNP_CLOSE);
        strcat(UPnPSendBuf, UPNP_CRLF);

        strcat(UPnPSendBuf, UPNP_CRLF); 

        //gena_get_remoteaddr(buf, &Callback);
        gena_get_remoteaddr2(message, &Callback);
        strcpy(pService->subscriptionTail->DeliveraryIP, Callback.IP);
        strcpy(pService->subscriptionTail->DeliveraryPort, Callback.Port);
        strcpy(pService->subscriptionTail->DeliveraryPath, Callback.Path);
        //POSEPrivilegedUnProtect(protectID);

        //send(fd, UPnPSendBuf, strlen(UPnPSendBuf), 0);
        UPnPSend(fd, UPnPSendBuf);
        break;
        }
        else if (!strncmp(list->header.buff, H_SID, list->header.size))
        {
            found=0;
            for (tmpsub=pService->subscriptionHead; tmpsub != NULL; tmpsub=tmpsub->next)
            {
                if (!strncmp(tmpsub->sid, list->value.buff, list->value.size))
                {

                    strcat(UPnPSendBuf, HTTP200); 
                    strcat(UPnPSendBuf, SERVER); 
                    strcat(UPnPSendBuf, H_SID); 
                    strcat(UPnPSendBuf, UPNP_SCOLON); 
                    strcat(UPnPSendBuf, tmpsub->sid);
                    strcat(UPnPSendBuf, UPNP_CRLF); 
                    strcat(UPnPSendBuf, H_TIMEOUT); 
                    strcat(UPnPSendBuf, UPNP_SCOLON); 
                    strcat(UPnPSendBuf, UPNP_SEC); 
                    NWitoa(pService->subduration/TICKS_PER_SECOND, tmp, 10);
                    strcat(UPnPSendBuf, (char *)tmp);
                    strcat(UPnPSendBuf, UPNP_CRLF); 
                    strcat(UPnPSendBuf, H_CONN);
                    strcat(UPnPSendBuf, UPNP_SCOLON);
                    strcat(UPnPSendBuf, UPNP_CLOSE);
                    strcat(UPnPSendBuf, UPNP_CRLF);
                    strcat(UPnPSendBuf, UPNP_CRLF); 
                    tmpsub->expireTime=POSEClockGetTick()+SUBSCRIPTION_DURATION;
                    found=1;
                    break;
                }
            }
            if (found==1)
                UPnPSend(fd, UPnPSendBuf);
            else if (found !=1) /*Invalid SID*/
            {
            }
            break;
        }
    }
    return 1;
}
#endif
