#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <time.h>
#include <pthread.h>
#include "upnp_types.h"
#include "fmt_cvt.h"
#include "upnp.h"
#include "upnp_utl.h"
#include "descrip.h"
#include "control.h"
#include "http_pas.h"
#include "dbgtrace.h"
#include "ralink_gpio.h"
#include <nvram.h>
#if 0
struct upnpdispatchFGPS
{
    struct FGProcessStructure fgps;
    struct TimerDataStructure timer;
    int fd;
    int state;
};

extern void add_timer(struct TimerDataStructure * timer);
extern int del_timer(struct TimerDataStructure * timer);
#endif
extern int Get_Random(void);

extern int genacallback(PUPNP_DEVICE UPnPDevice, void *para1, void *para2);
extern int soapcallback(PUPNP_DEVICE UPnPDevice, void *para1, void *para2);
http_message far message;
extern char far UPnPRecvBuf[UPNP_RECV_BUF_SIZE];
static char UPnPDevReadBuf[UPNP_DEV_RECV_SLOT_SIZE];


nint16 DispatcherPort = 8000;
int16 upnp_dispatcher_sock_fd = -1;

#define DISPATCH_INIT           0   
#define DISPATCH_OPEN           1   
#define DISPATCH_WAIT_CLOSE     2   
#define DISPATCH_CLOSED         3   

int UPnP_Dispatch_State=DISPATCH_INIT;
//static struct TimerDataStructure DispatchTimer;
int16 upnp_dispatcher_accept_fd = -1;

void dispatcher_timeout(void *notUsed)
{
    UPnP_Dispatch_State=DISPATCH_WAIT_CLOSE;
    if (upnp_dispatcher_accept_fd>=0)
        close(upnp_dispatcher_accept_fd);

    return ;
}

void *UPnPDispatcher(void *arg)
{
    int len;
    struct sockaddr_in clientAddr;
    nint16 sockaddrlen=16;
    int done=0;
    int sret;
    fd_set readfds;
    struct timeval timeToWait;

    while (1)
    {
        switch (UPnP_Dispatch_State)
        {
            case DISPATCH_INIT: 
            case DISPATCH_CLOSED:
                upnp_dispatcher_accept_fd = accept(upnp_dispatcher_sock_fd, 
                        (struct sockaddr *) &clientAddr, (socklen_t *)&sockaddrlen);
                if (upnp_dispatcher_accept_fd>0)
                {
                    UPnP_Dispatch_State = DISPATCH_OPEN;
                    memset(UPnPRecvBuf, 0, UPNP_RECV_BUF_SIZE);
                }
                else
                {
                    perror("accept");
                }

            case DISPATCH_OPEN:
                timeToWait.tv_sec = 1;
                timeToWait.tv_usec = 0;
                FD_ZERO(&readfds);
                FD_SET(upnp_dispatcher_accept_fd, &readfds);
                sret = select(upnp_dispatcher_accept_fd + 1, &readfds, (fd_set *)0, (fd_set *)0, (struct timeval *)&timeToWait );
                DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_DISPATCH,
                        "UPnPDispatcher, sret = %d\n", sret);
                if (-1 == sret) {
                    perror("select");
                } else if (0 == sret){
                    UPnP_Dispatch_State=DISPATCH_WAIT_CLOSE;
                } else {
                    if (FD_ISSET(upnp_dispatcher_accept_fd, &readfds)) {
                        len= recv(upnp_dispatcher_accept_fd, UPnPDevReadBuf, UPNP_DEV_RECV_SLOT_SIZE, 0);
                        if (len > 0) {
                            if ((strlen(UPnPRecvBuf) + len )< sizeof (UPnPRecvBuf))
                                strcat(UPnPRecvBuf, UPnPDevReadBuf); 
                            DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_DISPATCH,
                                    "UPnPDispatcher, 1, len = %d\n", len);
                        } else if (len == 0) {
                            UPnP_Dispatch_State=DISPATCH_WAIT_CLOSE;
                            DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_DISPATCH,
                                    "UPnPDispatcher, 2, len = %d\n", len);
                        } else {
                            perror("len = -1");
                            DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_DISPATCH,
                                    "UPnPDispatcherm, 3, len = %d, %s\n", len, "recv socket error");
                            DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_DISPATCH,
                                    "UPnPDispatcher, Total Recv= %d\n", strlen(UPnPRecvBuf));
                            UPnP_Dispatch_State=DISPATCH_WAIT_CLOSE;
                        }
                    } else {
                        //UPnP_Dispatch_State=DISPATCH_WAIT_CLOSE;
                    }
                }
                break;
            case DISPATCH_WAIT_CLOSE:
                if (strlen(UPnPRecvBuf) > 0) {
                    if (parse_http_request(UPnPRecvBuf, &message, strlen(UPnPRecvBuf)) == -1) {
                        message.header_list=NULL;
                        UPnP_Dispatch_State=DISPATCH_WAIT_CLOSE;
                        break;
                    }

                    switch (UPnPRecvBuf[0]) {
                        case 'G':

                            TraverseDevices(UPnPDeviceTemplate, description_send, &upnp_dispatcher_accept_fd, &message); 
                            done=1;
                            break;
                        case 'N':
                        case 'S':
                        case 'U':
#if 0 /*1212 RELEASE*/
                            TraverseDevices(UPnPDeviceTemplate, genacallback, &upnp_dispatcher_accept_fd, &message);

                            done=1;
#else
                            done=1;
#endif
                            break;
                        case 'P':
                        case 'M':
#if 0 /*1212 RELEASE*/
                            TraverseDevices(UPnPDeviceTemplate, soapcallback, &upnp_dispatcher_accept_fd, &message);
                            done=1;
#else
                            done=1;
#endif
                        default:
                            done=1;
                            break;
                    }
                }
                if (upnp_dispatcher_accept_fd>=0)
                    close(upnp_dispatcher_accept_fd);
                if (message.header_list)
                {
                    free_http_headers(message.header_list);
                    message.header_list=NULL;
                }
                UPnP_Dispatch_State=DISPATCH_CLOSED;
                break;
        }
    }
    pthread_exit(NULL);
}


void ConvertDispatchPortToStr(nint port)
{
    char tmp[16];

    memset(tmp, 0, 16);
    //NWitoa((int)port, tmp, 10);
    sprintf(tmp, "%d", port);
    strncpy(UPNP_DISPATCH_PORT, (char *)tmp, 4);
    return;
}

unsigned int GetSecondPort(void)
{
    unsigned int port_number= 0;

    char *SecondHTTPPort = nvram_bufget(RT2860_NVRAM, "SecondHTTPPort");
    if (SecondHTTPPort) {
        port_number = atoi(SecondHTTPPort);
    } else {
        port_number = 0;
    }
    nvram_close(RT2860_NVRAM);
    return port_number;
}

nint GenDispatchPort(void)
{
    unsigned int i; 
    unsigned int second_port; 
    int found=0;
    time_t t;

    //i=1+(int) (10.0*rand()/(RAND_MAX+1.0));
    //i=1+(int) (10*rand()/(RAND_MAX+1));
    //DispatcherPort=DispatcherPort+i; 
    second_port=GetSecondPort();
    srandom(time(&t));
    for(;found!=1;) {
        //i=(uint)Get_Random();
        i=(uint)random();
        DispatcherPort=DispatcherPort+i % 1000;
        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_DISPATCH,
                " random i = %d, DispatcherPort = %d\n", i, DispatcherPort);
        if (DispatcherPort != HTTP_ALT_PORT
            || DispatcherPort != WEBCACHE_PORT
            || DispatcherPort != TPROXY_PORT
            || DispatcherPort != second_port) {
            found=1;
        }
    }
    return (DispatcherPort);
}


int UPnPDispatcherInit(void)
{

    struct  sockaddr_in  Dispatcherlocaladdr;
    nint16 sockaddrlen=16;
    int ret;
    int returnStatus = UPNP_SUCCESS;

    DispatcherPort=GenDispatchPort();
    ConvertDispatchPortToStr(DispatcherPort);

    Dispatcherlocaladdr.sin_family = AF_INET;
    Dispatcherlocaladdr.sin_addr.s_addr = UpnpIP;
    Dispatcherlocaladdr.sin_port = ntohs(DispatcherPort);

    upnp_dispatcher_sock_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (upnp_dispatcher_sock_fd<=0)
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }
    ret=bind(upnp_dispatcher_sock_fd, (struct sockaddr *)&Dispatcherlocaladdr, sockaddrlen);
    if (ret !=0)
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }
    //listen(upnp_dispatcher_sock_fd, 5);
    listen(upnp_dispatcher_sock_fd, 1);

    UPnP_Dispatch_State=DISPATCH_INIT;
#if 0
    DispatchTimer.TCallBackProcedure = dispatcher_timeout;
    DispatchTimer.TCallBackWaitTime = RESPONSE_TIMEOUT;
    DispatchTimer.TCallBackEBXParameter = NULL;
#endif

Exit:
    if (returnStatus!=UPNP_SUCCESS)
    {
        if (upnp_dispatcher_sock_fd>=0)
            close(upnp_dispatcher_sock_fd);
    }
    return returnStatus;
}
/* vim:set sw=4 sts=4 sta si expandtab: */
