#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "upnp_types.h"
#include "fmt_cvt.h"
#include "upnp.h"
#include "upnp_utl.h"
#include "dispatch.h"
#include "http_pas.h"
extern char far RootDesc[UPNP_DOC_SIZE];
extern char far UPnPSendBuf[UPNP_SEND_BUF_SIZE];

int SendDescriptionResponse(int fd, char *Body)
{
    int len;
    char tmp[8];

    memset(UPnPSendBuf, 0, UPNP_SEND_BUF_SIZE);
    len=strlen(Body);
    //NWitoa(len, tmp, 10); 
    sprintf(tmp, "%d", len);
    strcat(UPnPSendBuf, HTTP200); 
    strcat(UPnPSendBuf, SERVER); 
    strcat(UPnPSendBuf, H_CONTENT_LEN); 
    strcat(UPnPSendBuf, UPNP_SCOLON); 
    strcat(UPnPSendBuf, UPNP_SPACE); 
    strcat(UPnPSendBuf, (char *)tmp);
    strcat(UPnPSendBuf, UPNP_CRLF); 
    strcat(UPnPSendBuf, H_CONN); 
    strcat(UPnPSendBuf, UPNP_SCOLON); 
    strcat(UPnPSendBuf, UPNP_SPACE); 
    strcat(UPnPSendBuf, UPNP_CLOSE); 
    strcat(UPnPSendBuf, UPNP_CRLF); 
    strcat(UPnPSendBuf, H_CONTENT_TYPE); 
    strcat(UPnPSendBuf, UPNP_SCOLON); 
    strcat(UPnPSendBuf, UPNP_SPACE); 
    strcat(UPnPSendBuf, UPNP_TEXT_XML); 
    strcat(UPnPSendBuf, UPNP_CRLF); 
    strcat(UPnPSendBuf, UPNP_CRLF); 

    UPnPSend(fd, UPnPSendBuf);

    return UPnPSend(fd, Body);
}

int description_send(PUPNP_DEVICE UPnPDevice, void *para1, void *para2)
{
    PSERVICE_TABLE  pService;
    int fd=*(int*)para1;
    http_message *message=(http_message *)para2;
    int found=0;

        if (!strncmp(message->request.request_uri.pathquery.buff,
                    UPnPDevice->DescDocURL,
                    message->request.request_uri.pathquery.size))
        {
            SendDescriptionResponse(fd, RootDesc);
            found=1;
        }
        if (found ==1) return 1; 
#if 1 
        for (pService=UPnPDevice->pService;pService;pService=pService->next)
        {
            if (!strncmp(message->request.request_uri.pathquery.buff,
                    pService->SCPDURL,
                    message->request.request_uri.pathquery.size))
            {
                SendDescriptionResponse(fd, pService->desc);
                found=1;
                break;
            }
        }
        if (found ==1) return 1; 
#endif
        return 0;
}

/* vim:set sw=4 sts=4 sta si expandtab: */
