#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "upnp_types.h"
#include "fmt_cvt.h"
#include "upnp.h"
#include "upnp_utl.h"
#include "dispatch.h"
#include "http_pas.h"

extern char far UPnPSendBuf[UPNP_SEND_BUF_SIZE];

#if 1 
int AddResponseHeader(char *RespData, char *XmlBuf)
{
    int len=strlen(XmlBuf);
    char tmp[10];

    //NWitoa(len, tmp, 10); 
    sprintf(tmp, "%d", len); 
    strcpy(RespData, HTTP200); 
    strcat(RespData, SERVER); 
    strcat(RespData, H_CONN);
    strcat(RespData, UPNP_SCOLON);
    strcat(RespData, UPNP_CLOSE);
    strcat(RespData, UPNP_CRLF);
    strcat(RespData, H_EXT);
    strcat(RespData, UPNP_SCOLON);
    strcat(RespData, UPNP_CRLF);
    strcat(RespData, H_CONTENT_TYPE);
    strcat(RespData, UPNP_SCOLON);
    strcat(RespData, UPNP_TEXT_XML);
    strcat(RespData, UPNP_SEMICOLON);
    strcat(RespData, UPNP_CHARSET);
    strcat(RespData, UPNP_EQU);
    strcat(RespData, UPNP_UTF_8);
    strcat(RespData, UPNP_CRLF);
    strcat(RespData, H_CONTENT_LEN); 
    strcat(RespData, UPNP_SCOLON);
    strcat(RespData, (char *)tmp);
    strcat(RespData, UPNP_CRLF);
    strcat(RespData, UPNP_CRLF);
    strcat(RespData, XmlBuf);

    return 0;
}

int CreateControlActionResponse(char * OutBuf, char * ActBuf)
{
  char *XmlBuf;

  XmlBuf=malloc(1000);
  if (XmlBuf== NULL) return 1;
  memset(XmlBuf, 0, 1000);
#if 0
  char S[]="<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body>\n";
  char E[]="</s:Body> </s:Envelope>\r\n";
#endif

  strcpy(XmlBuf,XML_DECL);
  strcat(XmlBuf,UPNP_SOAP_S);
  strcat(XmlBuf,ActBuf);
  strcat(XmlBuf,UPNP_SOAP_E);
  AddResponseHeader(OutBuf,XmlBuf);

  free(XmlBuf);

#if 0
  strcpy(XmlBuf,S);
  strcat(XmlBuf,ActBuf);
  strcat(XmlBuf,E);
  AddResponseHeader(OutBuf,XmlBuf);
#endif
  return 1;
}

int CreateControlQueryResponse(char * OutBuf, char *Var)
{
  char *XmlBuf;

  XmlBuf=malloc(1000);
  if (XmlBuf== NULL) return 1;
  memset(XmlBuf, 0, 1000);
#if 0
  char S[]="<?xml version=\"1.0\"?><s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><s:Body><u:QueryStateVariableResponse xmlns:u=\"urn:schemas-upnp-org:control-1-0\"><return>";
  char E[]="</return> </u:QueryStateVariableResponse> </s:Body> </s:Envelope>\r\n";
#endif


  strcpy(XmlBuf,XML_DECL);
  strcat(XmlBuf,UPNP_SOAP_S);
  strcat(XmlBuf,UPNP_Q_SST_S);
  strcat(XmlBuf,Var);
  strcat(XmlBuf,UPNP_Q_SST_E);
  strcat(XmlBuf,UPNP_SOAP_E);
  AddResponseHeader(OutBuf,XmlBuf);

  free(XmlBuf);
#if 0
  strcpy(XmlBuf,S);
  strcat(XmlBuf,Var);
  strcat(XmlBuf,E);
  AddResponseHeader(OutBuf,XmlBuf);
#endif
  return 0;
}

int ActionOrQuery(int fd, PSERVICE_TABLE pService, http_message *message, PUPNP_DEVICE UPnPDevice)
{
    UPNP_ACTION_REQUEST CAEvent;
    char *target_value;
    int i,j;
    int found=0;
    char *buf_ahead;
#if 0 /*Dump XML*/
    xmlDocPtr   doc; 
    char *out;
    int size;
#endif


    if (pService!=NULL)
    {
#if 0 /*Dump XML*/
    doc=xmlParseMemory(message->content.buff, message->content.size);
    xmlDocDumpMemory(doc, &out, &size);

#if 0
    SerialDisplayBuf(UPNP_CRLF, 2);
    SerialDisplayBuf(message->content.buff, message->content.size);
    SerialDisplayBuf(UPNP_CRLF, 2);
    SerialDisplayBuf(doc->name, strlen(doc->name));
    SerialDisplayBuf(UPNP_CRLF, 2);
    SerialDisplayBuf(doc->version, strlen(doc->version));
    SerialDisplayBuf(UPNP_CRLF, 2);
#endif

    SerialDisplayBuf(UPNP_CRLF, 2);
    SerialDisplayBuf(out, strlen(out));
    SerialDisplayBuf(UPNP_CRLF, 2);
    xmlFreeDoc(doc);
#endif

    target_value=malloc(200);
    if (target_value==NULL) return -1;
    memset(target_value, 0, 200);

    memset((PUPNP_ACTION_REQUEST)&CAEvent, 0, sizeof(UPNP_ACTION_REQUEST));

    /*Control Query*/
    //if ( (buf_ahead=strstr(message->content.buff, ":varName")))
    buf_ahead=strstr(message->content.buff, ":varName");
    if ( buf_ahead )
    {
        for (i=0; buf_ahead[i]!='<'; i++);
        buf_ahead+=9;

        //for (pService=UPnPDevice->pService;pService;pService=pService->next)
        {
            for (j=0; j<MAX_PRINTER_ATTRIBUTES; j++)
            {
                if (!strncmp(pService->sst[j].vname, buf_ahead, strlen(pService->sst[j].vname)))
                {
                    strcpy(target_value, pService->sst[j].vdata.str);
                    found=1;
                }

                if (found ==1)
                break;
            }
        }

        CreateControlQueryResponse(UPnPSendBuf, target_value);
        send(fd, UPnPSendBuf, strlen(UPnPSendBuf), 0);
    }
    /*Control Action*/
    else
    {

            for (j=0; j<MAX_ACTION; j++)
            {
                if (strlen(pService->action[j].aname) == 0)
                    break;
                if (strstr(message->content.buff, pService->action[j].aname))
                {
                    CAEvent.UPnPDevice=UPnPDevice;
                    //CAEvent.service=i;
                    CAEvent.pService=pService;
                    CAEvent.action=j;
                    CAEvent.fd=fd;
                    pService->action[j].afunc(&CAEvent, message->content.buff);
                    found=1;
                    break;
                }
                if (found ==1 )break;
            }
    }

    free(target_value);
    }
    return 1;
}

int soapcallback(PUPNP_DEVICE UPnPDevice, void *para1, void *para2)
{   
    int fd=*(int*)para1;
    http_message *message=para2;
    PSERVICE_TABLE  pService;
    int found=0;


        for (pService=UPnPDevice->pService;pService;pService=pService->next)
        {
            if (!strncmp(message->request.request_uri.pathquery.buff,
                    pService->controlURL,
                    message->request.request_uri.pathquery.size))
            {
                found=1;
                break;
            }
        }
        if (found ==0) 
        {
                return 0;
        }


    if ( !strncmp(message->request.method.buff, "M-POST", 6))
    {
#if 0   /*Not Implemented*/
        strcat(RespData, "HTTP/1.1 200 OK\r\n");
        strcat(RespData, "\r\n");
        send(fd, RespData, strlen(RespData), 0);
#endif
    }
    else if (!strncmp(message->request.method.buff, "POST", 4))
    {
        ActionOrQuery(fd, pService, message, UPnPDevice);
    }

    return 1;
}


#endif
