#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "upnp_types.h"
#include "fmt_cvt.h"
#include "upnp.h"
#include "upnp_utl.h"
#include "dbgtrace.h"

nuint32 UpnpAdExpireTime =0;
int16 upnp_ad_sock_fd = -1;

char far ntst[128];
char far usn[128];
char far cache[32];
char far AdData[512];

int build_ad_data(char *AdData, char *request_response, char *host, char *cache, char *urlbase, 
                char *descurl, char *ntst, char *nts, char *server, char *usn);
int upnp_ad_expire(void);

int build_ad_byebye_data(char *AdData, char *request_response, char *host, char *ntst, char *nts, char *usn)
{
        strcat(AdData, request_response);
        strcat(AdData, host);
        strcat(AdData, ntst); 
        strcat(AdData, nts); 
        strcat(AdData, usn); 
        strcat(AdData, UPNP_CRLF); 
        return 0;
}
int build_ad_data(char *AdData, char *request_response, char *host, char *cache, char *urlbase, 
                char *descurl, char *ntst, char *nts, char *server, char *usn)
{
        strcat(AdData, request_response);
        strcat(AdData, host);
        strcat(AdData, cache);
        strcat(AdData, H_LOCATION);
        strcat(AdData, UPNP_SCOLON);
        strcat(AdData, UPNP_SPACE); 
        strcat(AdData, urlbase);
        strcat(AdData, descurl);
        strcat(AdData, UPNP_CRLF); 
        strcat(AdData, ntst); 
        strcat(AdData, nts); 
        strcat(AdData, server); 
        strcat(AdData, usn); 
        strcat(AdData, UPNP_CRLF); 
        return 0;
}

#if 0
int MessageBuild(char *Buf, int RequestOrResponse, http_message *message)
{
    if (RequestOrResponse == 0)
    {
        strcpy(Buf, message->request.method.buff, message->request.method.size) 
    }
    else
    {
    }
    return 0;
}
#endif

void CacheInit(void)
{
    char tmp[8];

    strcpy(cache, H_CACHE);
    strcat(cache, UPNP_SCOLON);
    strcat(cache, UPNP_SPACE); 
    strcat(cache, UPNP_MAX_AGE);
    strcat(cache, UPNP_EQU);
    //NWitoa(ADVERTISEMENT_DURATION/TICKS_PER_SECOND, tmp, 10);
    sprintf(tmp, "%d", ADVERTISEMENT_DURATION);
    strcat(cache, (char *)tmp); 
    strcat(cache, UPNP_CRLF); 
    return;
}

int AdBuildByeByeAndSend(PUPNP_DEVICE UPnPDevice, void *para1, void *para2)
{
    PSERVICE_TABLE  pService;
    nint16 sockaddrlen=16;
    char ntst_header[5];
    int type=*(int *)para1;
    struct  sockaddr_in *destaddr=para2;


    switch (type)
    {
        case 0:
                memset(ntst_header, 0, 4);
                strcpy(ntst_header, H_NT);
                strcat(ntst_header, UPNP_SCOLON);
                strcat(ntst_header, UPNP_SPACE);
                break;
    }


    {
        /*Send Adv. #1*/
        memset(ntst, 0, 128);
        strcat(ntst, ntst_header); 
        strcat(ntst, UPnPDevice->UDN);
        strcat(ntst, UPNP_CRLF);
        memset(usn, 0, 128);
        strcat(usn, H_USN); 
        strcat(usn, UPNP_SCOLON); 
        strcat(usn, UPNP_SPACE);
        strcat(usn, UPnPDevice->UDN);
        strcat(usn, UPNP_CRLF);
        memset(AdData, 0, 512);
        build_ad_byebye_data(AdData, NOTIFY, MULTI_HOST, ntst, BYEBYE, usn);
        sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)destaddr, sockaddrlen);
        //POSEThreadYield();
        /*Send Adv. #2*/
        memset(ntst, 0, 128);
        strcat(ntst, ntst_header); 
        strcat(ntst, UPnPDevice->DeviceType);
        strcat(ntst, UPNP_CRLF);
        memset(usn, 0, 128);
        strcat(usn, H_USN); 
        strcat(usn, UPNP_SCOLON); 
        strcat(usn, UPNP_SPACE);
        strcat(usn, UPnPDevice->UDN);
        strcat(usn, UPNP_DCOLON); 
        strcat(usn, UPnPDevice->DeviceType);
        strcat(usn, UPNP_CRLF);
        memset(AdData, 0, 512);
        build_ad_byebye_data(AdData, NOTIFY, MULTI_HOST, ntst, BYEBYE, usn);
        sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)destaddr, sockaddrlen);
        //POSEThreadYield();
        /*Send Adv. #3*/
        if (UPnPDevice->RootDevice == 1)
        {
        memset(ntst, 0, 128);
        strcat(ntst, ntst_header); 
        strcat(ntst, UPNP_ROOT);
        strcat(ntst, UPNP_CRLF);
        memset(usn, 0, 128);
        strcat(usn, H_USN); 
        strcat(usn, UPNP_SCOLON); 
        strcat(usn, UPNP_SPACE);
        strcat(usn, UPnPDevice->UDN);
        strcat(usn, UPNP_DCOLON); 
        strcat(usn, UPNP_ROOT);
        strcat(usn, UPNP_CRLF);
        memset(AdData, 0, 512);
        build_ad_byebye_data(AdData, NOTIFY, MULTI_HOST, ntst, BYEBYE, usn);
        sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)destaddr, sockaddrlen);
        //POSEThreadYield();
        }

        /*Send Adv. ServcieType*/
        for (pService=UPnPDevice->pService;pService;pService=pService->next)
        {
                memset(ntst, 0, 128);
                strcat(ntst, ntst_header); 
                strcat(ntst, pService->serviceType);
                strcat(ntst, UPNP_CRLF);

                memset(usn, 0, 128);
                strcat(usn, H_USN); 
                strcat(usn, UPNP_SCOLON); 
                strcat(usn, UPNP_SPACE);
                strcat(usn, UPnPDevice->UDN);
                strcat(usn, UPNP_DCOLON); 
                strcat(usn, pService->serviceType);
                strcat(usn, UPNP_CRLF);

                memset(AdData, 0, 512);
                build_ad_byebye_data(AdData, NOTIFY, MULTI_HOST, ntst, BYEBYE, usn);
                sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)destaddr, sockaddrlen);
                //POSEThreadYield();
        }
    }
    return 0;
}

int AdBuildAndSend(PUPNP_DEVICE UPnPDevice, void *para1, void *para2)
{
    PSERVICE_TABLE pService;
    nint16 sockaddrlen=16;
    char ntst_header[5];
    int type=*(int *)para1;
    struct  sockaddr_in *destaddr=para2;

    switch (type)
    {
        case 0:
                memset(ntst_header, 0, 4);
                strcpy(ntst_header, H_NT);
                strcat(ntst_header, UPNP_SCOLON);
                strcat(ntst_header, UPNP_SPACE);
                break;
        case 1:
                memset(ntst_header, 0, 4);
                strcpy(ntst_header, H_ST);
                strcat(ntst_header, UPNP_SCOLON);
                strcat(ntst_header, UPNP_SPACE);
                break;
    }

        /*Send Adv. #1*/
        memset(ntst, 0, 128);
        strcat(ntst, ntst_header); 
        strcat(ntst, UPnPDevice->UDN);
        strcat(ntst, UPNP_CRLF);
        memset(usn, 0, 128);
        strcat(usn, H_USN); 
        strcat(usn, UPNP_SCOLON);
        strcat(usn, UPNP_SPACE);
        strcat(usn, UPnPDevice->UDN);
        strcat(usn, UPNP_CRLF);
        memset(AdData, 0, 512);
        build_ad_data(AdData, NOTIFY, MULTI_HOST, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, ntst, ALIVE, SERVER,usn);
        sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)destaddr, sockaddrlen);
        //POSEThreadYield();
        /*Send Adv. #2*/
        memset(ntst, 0, 128);
        strcat(ntst, ntst_header); 
        strcat(ntst, UPnPDevice->DeviceType);
        strcat(ntst, UPNP_CRLF);
        memset(usn, 0, 128);
        strcat(usn, H_USN); 
        strcat(usn, UPNP_SCOLON);
        strcat(usn, UPNP_SPACE);
        strcat(usn, UPnPDevice->UDN);
        strcat(usn, UPNP_DCOLON);
        strcat(usn, UPnPDevice->DeviceType);
        strcat(usn, UPNP_CRLF);
        memset(AdData, 0, 512);
        build_ad_data(AdData, NOTIFY, MULTI_HOST, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, ntst, ALIVE, SERVER,usn);
        sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)destaddr, sockaddrlen);
        //POSEThreadYield();
        /*Send Adv. #3*/
        if (UPnPDevice->RootDevice == 1)
        {
        memset(ntst, 0, 128);
        strcat(ntst, ntst_header); 
        strcat(ntst, UPNP_ROOT);
        strcat(ntst, UPNP_CRLF);
        memset(usn, 0, 128);
        strcat(usn, H_USN); 
        strcat(usn, UPNP_SCOLON);
        strcat(usn, UPNP_SPACE);
        strcat(usn, UPnPDevice->UDN);
        strcat(usn, UPNP_DCOLON);
        strcat(usn, UPNP_ROOT);
        strcat(usn, UPNP_CRLF);
        memset(AdData, 0, 512);
        build_ad_data(AdData, NOTIFY, MULTI_HOST, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, ntst, ALIVE, SERVER,usn);
        sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)destaddr, sockaddrlen);
        //POSEThreadYield();
        }

        /*Send Adv. ServcieType*/
        for (pService=UPnPDevice->pService;pService;pService=pService->next)
        {
                memset(ntst, 0, 128);
                strcat(ntst, ntst_header); 
                strcat(ntst, pService->serviceType);
                strcat(ntst, UPNP_CRLF);

                memset(usn, 0, 128);
                strcat(usn, H_USN); 
                strcat(usn, UPNP_SCOLON);
                strcat(usn, UPNP_SPACE);
                strcat(usn, UPnPDevice->UDN);
                strcat(usn, UPNP_DCOLON);
                strcat(usn, pService->serviceType);
                strcat(usn, UPNP_CRLF);

                memset(AdData, 0, 512);
                build_ad_data(AdData, NOTIFY, MULTI_HOST, cache, UPnPDevice->URLBase, UPnPDevice->DescDocURL, ntst, ALIVE, SERVER, usn);
                sendto(upnp_ad_sock_fd, AdData, strlen(AdData), 0, (struct sockaddr *)destaddr, sockaddrlen);
                //POSEThreadYield();
        }
        return 0;
}

int upnp_ad_expire()
{
    nuint32 now;
    time_t  t;

    now = time(&t);
    if (UpnpAdExpireTime <= now )
    {
        UpnpAdExpireTime=now + RESEND_AD_DURATION; 
        return 1;
    }
    else
        return 0;
}

int UPnPAdInit(void)
{
    //nint16 AdLocalPort = 2250;
    //nint16 sockaddrlen=16;
    //int ret;
    struct  sockaddr_in  Adlocaladdr;
    int returnStatus = UPNP_SUCCESS;

    Adlocaladdr.sin_family = AF_INET;
    //Adlocaladdr.sin_addr.s_addr = UpnpIP;
    //Adlocaladdr.sin_port = ntohs(AdLocalPort);
    //Adlocaladdr.sin_port = htons(AdLocalPort);
    Adlocaladdr.sin_addr.s_addr = UPNP_MULTICAST_IP;
    Adlocaladdr.sin_port = htons(1900);
    upnp_ad_sock_fd = socket(AF_INET, SOCK_DGRAM, 0);
    if (upnp_ad_sock_fd<=0)
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }

#if 0 
    ret=bind(upnp_ad_sock_fd, (struct sockaddr *)&Adlocaladdr, sockaddrlen);
    if (ret !=0)
    {
        returnStatus=UPNP_FAILURE;
        goto Exit;
    }
#endif

Exit:
    if (returnStatus!=UPNP_SUCCESS)
    {
        if (upnp_ad_sock_fd>=0)
            close(upnp_ad_sock_fd);
    }

    return returnStatus;
}

void UPnPAdBye(int signo)
{
    nint16 dport = UPNP_MULTICAST_PORT;
    struct  sockaddr_in  destaddr;
    int type=0;

    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UDEV, UDEV_DBG_MASK_INIT,
                  "===============%s=============\r\n", __FUNCTION__);
    destaddr.sin_family = AF_INET;
    destaddr.sin_addr.s_addr = UPNP_MULTICAST_IP;  /* 239.255.255.250 */
    //destaddr.sin_port = ntohs(dport);
    destaddr.sin_port = htons(dport);
    TraverseDevices(UPnPDeviceTemplate, AdBuildByeByeAndSend, &type, &destaddr);
    TraverseDevices(UPnPDeviceTemplate, AdBuildByeByeAndSend, &type, &destaddr);
    TraverseDevices(UPnPDeviceTemplate, AdBuildByeByeAndSend, &type, &destaddr);

 
    exit (0);
    //return;
}

//int UPnPAd(void)
void UPnPAd(int signo)
{
    nint16 dport = UPNP_MULTICAST_PORT;
    struct  sockaddr_in  destaddr;
    int type=0;

    destaddr.sin_family = AF_INET;
    destaddr.sin_addr.s_addr = UPNP_MULTICAST_IP;  /* 239.255.255.250 */
    //destaddr.sin_port = ntohs(dport);
    destaddr.sin_port = htons(dport);
    TraverseDevices(UPnPDeviceTemplate, AdBuildAndSend, &type, &destaddr);

    return;
}
/* vim:set sw=4 sts=4 sta si expandtab: */
