#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <netdb.h>
#include "upnp_types.h"
#include "http_pas.h"
#include "semaphore_api.h"
#include "xml_dump.h"
#include "xml_pars.h"
#include "xml_mem.h"
#include "fmt_cvt.h"
#include "misc_xml.h"
#include "ucpbas.h"
#include "ucpmain.h"
#include "ucpsrch.h"
#include "ucpcon.h"
#include "ucpwanip.h"
#include "ucputl.h"
#include "dbgtrace.h"

#define    IGDUPNPENABLED     0 
#define    IGDUPNPDISABLED    2 
#define    DATACORRUPT     -1 

#define WANIP_DURATION      6 * 60* 18  /* 6 minutes*/
#define IGD_SEARCH_UNNORMAL 1 * 60* 18  /* 1 minutes*/
static char CurWanIP[16];
static nuint32 WanIPExpireTime = 0;
extern int ucpopen_sem_id;
extern unsigned int sleep_time;

char far UCP_IGD_NEW_EXTERNAL_IP_ADDRESS[] = "NewExternalIPAddress";

/*
 * return: 0 :  IGD UPnP Enable
 *         -1:  IGD UPnP Disable
 * OUT     ip:  ip getted from IGD by UPnP(may be 0)
 */
int UCPGetWANIP(unsigned long *ip)
{
    int status;

    if (0 != strlen(CurWanIP)) {
        *ip = addr_ipatol(CurWanIP, 1);
        status = 0;
    } else {
        *ip = 0;
        status = -1;
    }
    return status;
}

static int UCPGetExternalIPAddress(SERVICE_URL *SvcURL, char *newip)
{
    xmlDocPtr   doc;
    xmlNodePtr  node;
    static http_message msg;
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_WANIP,
                  "%s\r\n", "UCPGetExternalIPAddress");
    if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
    status = UCPGenericConnection(SvcURL, UCPCreateGetExternalIPAddressMessage, NULL);
    if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);

    doc = NULL;
    if (FAIL == status)
        status = FAIL;
    else if (FAIL == UCPParseRecvBuf(&msg))
        status = FAIL;
    else if (strncmp(msg.status.reason_phrase.buff, UCP_OK, msg.status.reason_phrase.size))
        status = FAIL;
    else if (NULL == (doc=xmlParseMemory(msg.content.buff, msg.content.size)))
        status = FAIL;
    else if (!TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_NEW_EXTERNAL_IP_ADDRESS, 0))
        status = FAIL;
    else if (FAIL == GetXMLNodeValue(node, newip))
        status = FAIL;
    else
        status = PASS;

    if (msg.header_list) {
        free_http_headers(msg.header_list);
        msg.header_list = NULL;
    }
    if (doc) {
        xmlFreeDoc(doc);
        doc = NULL;
    }
    return status;
}

void ResetWanIPExpireTime(nuint32 wait)
{
    nuint32 now;
    time_t	t;

    //now = POSEClockGetTick();
    now = time(&t);
    WanIPExpireTime = now + wait;
}

int ucp_wanip_expire(void)
{
    nuint32 now;
    int expired;
    time_t t;

    //now = POSEClockGetTick();
    now = time(&t);
    if (WanIPExpireTime <= now ) {
        WanIPExpireTime = now + WANIP_DURATION; 
        expired = TRUE;
    } else {
        expired = FALSE;
    }
    return expired;
}

int UCPRefreshWANIP(void)
{
    int status, igdstatus;
    static SERVICE_URL SvcCtrlURL; 
    char NewWanIP[16], OldWanIP[16];
    unsigned long ip;
    int upnpigd;
    unsigned short CheckWanIP;

    //status = ucp_wanip_expire();
    //if (FALSE == status) return CONTINUE;
    //thunder
    //NCLGetItem16(URL_SUBJECT, EMAIL_URL_CHECK_WANIP, &CheckWanIP);
    CheckWanIP = TRUE;
    if (FALSE == CheckWanIP) {
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_WANIP,
                  "CheckWanIP = %d\r\n", CheckWanIP);
            return CONTINUE;
    }
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_WANIP,
                  "%s\r\n", "=====UCPRefreshWANIP=====");
    memcpy(OldWanIP, CurWanIP, sizeof(OldWanIP));
    memset(&SvcCtrlURL, 0, sizeof(SvcCtrlURL));
    igdstatus = UCPGetIGDStatus();
    if (GW_UPNPDISABLED == igdstatus) {
        //ResetWanIPExpireTime(IGD_SEARCH_UNNORMAL);
	sleep_time = IGD_SEARCH_UNNORMAL;
        status = FAIL;
    } else if (GW_DATACORRUPT == igdstatus) {
        //ResetWanIPExpireTime(IGD_SEARCH_UNNORMAL);
	sleep_time = IGD_SEARCH_UNNORMAL;
        status = FAIL;
    } else {
        GetActiveConnection(&SvcCtrlURL);
        if (FAIL == UCPGetExternalIPAddress(&SvcCtrlURL, NewWanIP)) {
            status = FAIL;
        } else {
            DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_WANIP,
                       "OldWanIP = %s, NewWanIP = %s\r\n", OldWanIP, NewWanIP);
	    if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
	    strcpy(CurWanIP, NewWanIP);
	    if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);
            status = PASS;
        }
    }
    if (FAIL == status) {
	    if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
	    CurWanIP[0] = '\0';
	    if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);
    }
    upnpigd = UCPGetWANIP(&ip);
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_WANIP,
                   "upnpigd = %d\r\n", upnpigd);
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_WANIP,
                   "ip = %#8lX\r\n", ip);
    return status;
}
