/*
 * UCP Utility 
 */
#include <unistd.h>
#include <string.h>
#include <strings.h>
#include <stdarg.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sched.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "upnp_types.h"
#include "http_pas.h"
#include "xml_dump.h"
#include "xml_enti.h"
#include "xml_tree.h"
#include "xml_ext.h"
#include "xml_mem.h"
#include "fmt_cvt.h"
#include "misc_xml.h"
#include "ucpbas.h"
#include "ucputl.h"
#include "ucpmain.h"
#include "dbgtrace.h"
#include "ralink_gpio.h"

#define TAG_NAME_LENGTH		36
#define TAG_VALUE_LENGTH        80	

typedef struct 
_UCP_TAG_VALUE
{
    void *Linkage;
    char Name[TAG_NAME_LENGTH];
    char Value[TAG_VALUE_LENGTH];
}
UCP_TAG_VALUE, *PUCP_TAG_VALUE;

short error_code = 0;

static int extractIP(char *buf, CALLBACK_ADDR *Callback)
{
    char *tmp;
    int status;
    int i;
    int copy_len;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "%s\r\n", "extractIP");
    tmp = strstr(buf, "http://");
    if (NULL == tmp) {
        status = FAIL;
    } else {
        tmp = tmp + 7;
        for (i = 0; tmp[i] != ':' && tmp[i] != '/' && tmp[i] != '\0'; i++)
            ;
        if (i > 15) copy_len = 15;
        else copy_len = i;
        strncpy(Callback->IP, tmp, copy_len);
        Callback->IP[copy_len] = '\0';
        status = PASS;
    }
    return status;
}

static int extractPort(char *buf, CALLBACK_ADDR *Callback)
{
    char *tmp;
    int status;
    int i;
    int copy_len;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "%s\r\n", "extractPort");
    tmp = strstr(buf, "http://");
    if (NULL == tmp) {
        status = FAIL;
    } else {
        tmp = tmp + 7;
        tmp = strchr(tmp, ':');
        if (NULL == tmp) {
            strcpy(Callback->Port, "80"); /*Assign default port number*/
            status = PASS;
            //status = FAIL;
        } else {
            tmp += 1;
            for (i = 0; tmp[i] >= '0' && tmp[i] <= '9'; i++)
                ;
            if (i > 5) copy_len = 5;
            else copy_len = i;
            strncpy(Callback->Port, tmp, copy_len);
            Callback->Port[copy_len] = '\0';
            status = PASS;
        }
    }
    return status;
}

static int extractPath(char *buf, CALLBACK_ADDR *Callback)
{
    char *tmp;
    int status;
    int i;
    int copy_len;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "%s\r\n", "extractPath");
    tmp = strstr(buf, "http://");
    if (tmp)
        tmp = tmp + 7;
    else 
        tmp = buf;
    tmp = strchr(tmp, '/');
    if (NULL == tmp) {
        status = FAIL;
    } else {
        for (i = 0; tmp[i] != '\0'; i++)
            ;
        if (i > 63) copy_len = 63;
        else copy_len = i;
        strncpy(Callback->Path, tmp, copy_len);
        Callback->Path[copy_len] = '\0';
        status = PASS;
    }
    if (FAIL == status)
        memset(Callback->Path, 0, sizeof(Callback->Path));
    return status; 
}

int UCPParsePlainXMLxURL(char *buf, CALLBACK_ADDR *Callback)
{
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "%s\r\n", "UCPParsePlainXMLxURL");
    status = extractIP(buf, Callback);
    extractPort(buf, Callback);
    extractPath(buf, Callback);
    return status;
}

int extractLocationURL(http_header *list, CALLBACK_ADDR *Callback)
{
    int size;
    int status;
    char dest[UCP_URL];

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "%s\r\n", "extractLocationURL");
    size = list->value.size;
    memset(dest, 0, sizeof(dest));
    strncpy(dest, list->value.buff, (size > sizeof(dest)-1 ? sizeof(dest)-1 : size));
    status = UCPParsePlainXMLxURL(dest, Callback);
    return status;
}

int extractServiceCtrlURL(char *src, CALLBACK_ADDR *Callback)
{
    int status = PASS;
    char *buf, *begin, *end;
    int size;
    char dest[UCP_URL];

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "%s\r\n", "extractServiceCtrlURL");
    buf = strstr(src, UCP_XML_CTRL_URL);
    if (buf) {
        begin = buf + sizeof(UCP_XML_CTRL_URL);
        buf = strstr(begin, UCP_LAB);
        if (buf) {
            end = buf - 1;
            size = (size_t)(end - begin) + 1;
            memset(dest, 0, sizeof(dest));
            strncpy(dest, begin, (size > sizeof(dest)-1 ? sizeof(dest)-1 : size));
            //strncpy(dest, begin, (size_t)(end - begin) + 1);
            //dest[(size_t)(end - begin) + 1] = '\0';
            DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "dest = %s\r\n", dest);
            UCPParsePlainXMLxURL(dest, Callback);
        } else {
            status = FAIL;
        }
    } else {
        status = FAIL;
    }

    return status;
}

char *extractElementValue(char *src, PUCP_TAG_VALUE tagValue)
{
    int status = PASS;
    char *buf, *begin, *end;
    char *bufLAB = NULL;

    int size;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "%s\r\n", "extractElementValue");
    buf = strstr(src, tagValue->Name);
    if (buf) {
        begin = buf + sizeof(tagValue->Name) + 1;
        bufLAB = strstr(begin, UCP_LAB);
        if (bufLAB) {
            end = bufLAB - 1;
            size = (size_t)(end - begin) + 1;
            memset(tagValue->Value, 0, sizeof(tagValue->Value));
            strncpy(tagValue->Value, begin, (size > sizeof(tagValue->Value)-1 ? sizeof(tagValue->Value)-1 : size));
            DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "tagValue->Value = %s\r\n", tagValue->Value);
        } else {
            status = FAIL;
        }
    } else {
        status = FAIL;
    }

    if (status == FAIL)
        return NULL;
    else
        return bufLAB;
}

int GetErrorCode(http_message *msg)
{
    int status;
    char ecode[8];
    xmlDocPtr   doc;
    xmlNodePtr  node;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "%s\r\n", "GetErrorCode");
    status = PASS;
    doc = xmlParseMemory(msg->content.buff, msg->content.size); 
    if (doc == NULL)
        status = FAIL;
    else {
        TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_ERROR, 0);
        GetXMLNodeValue(node, ecode);
        status = atoi(ecode);
#if 0
        printf("node = %p\n", node);
        printf("ecode = %s\n", ecode);
        printf("status = %d\n", status);
#endif
    }

    if (doc) {
        xmlFreeDoc(doc);
        doc = NULL;
    }
    return status;
}

char *GetCodeDesc(CODE_DESC tab[], int ntab, int status)
{
    int i;
    int found;
    char *p;
    
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "%s\r\n", "GetCodeDesc");
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_UTL,
                  "tab NELEMS = %d\r\n", ntab);
    for (i = 0, found = 0, p = NULL; i < ntab && !found; i++) {
        if (status == tab[i].ecode) {
            p = tab[i].desc;
            found = 1;
        }
    }
    return p;
}

int UCPSend(int fd, char *buf)
{
    char *tmp = buf;
    nint16 buf_len = strlen(buf);
    nint16 out;

    while(1)
    {
        out = send(fd, tmp, buf_len, 0);
 
        if ( (nint16)out == buf_len )
        {
            return 1;
        }
        else if ( out >= 0 )
        {
            tmp = tmp+out;
            buf_len = buf_len-out;
            sched_yield();
        }
        else if ( out == -5 )
        {
            sched_yield();
        }
        else if ( out == -22 )
        {
            return 1;
        }
    }
}

int getipbyname(char *hostname)
{
	struct hostent *hp;
	struct in_addr a;

	hp = gethostbyname(hostname);

	if (hp) {
		while (*hp->h_addr_list)
		{
			bcopy(*hp->h_addr_list++, (char *) &a, sizeof(a));
			printf("address: %s\n", inet_ntoa(a));
		}
	}

	return (int)hp->h_addr_list[0];



}

int write_sysinfo_short(short in, int subfunc)
{
    int fd;

    fd = open(SYSIF_DEV, O_RDONLY);
    if (fd < 0) {
        perror(SYSIF_DEV);
        return -1;
    }
    if (ioctl(fd, (SYSIF_WRITE | 
                        subfunc << SUBCMD_IDX_SHIFT | 
                        ((sizeof in) << BUF_LEN_SHIFT)), &in) < 0) {
        perror("ioctl");
        close(fd);
        return -1;
    }

    close(fd);
    return 0;
}

int read_sysinfo(int len, char *out, int subfunc)
{
    int fd;

    fd = open(SYSIF_DEV, O_RDONLY);
    if (fd < 0) {
        perror(SYSIF_DEV);
        return -1;
    }
    if (ioctl(fd, (SYSIF_READ | 
                        subfunc << SUBCMD_IDX_SHIFT | 
                        (len << BUF_LEN_SHIFT)), out) < 0) {
        perror("ioctl");
        close(fd);
        return -1;
    }

    close(fd);
    return 0;
}

/* vim:set sw=4 sts=4 sta si expandtab: */
