#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/types.h>
#include <time.h>
//#include "nvram.h"
#include "upnp_types.h"
#include "http_pas.h"
#include "semaphore_api.h"
#include "xml_dump.h"
#include "xml_pars.h"
#include "xml_mem.h"
#include "fmt_cvt.h"
#include "misc_xml.h"
#include "ucpbas.h"
#include "ucpmain.h"
#include "ucpsrch.h"
#include "ucpcon.h"
#include "ucputl.h"
#include "dbgtrace.h"
#include "ralink_gpio.h"
#include "readsysinfo.h"
#

extern int sock_change_upnpip(int fd);
unsigned long  default_gw;
extern unsigned long UpnpIP;
extern int ucpopen_sem_id;
extern unsigned int sleep_time;

#define UPNP_MULTICAST_IP   0xfaffffefL      
#define UPNP_MULTICAST_PORT 1900    

char far UCP_IGD[]="urn:schemas-upnp-org:device:InternetGatewayDevice:1\r\n";
char far UCP_IGD_NEW_CONNECTION_STATUS[] = "NewConnectionStatus";
char far UCP_IGD_CONNECTED[] = "Connected";

static int16 ucp_msearch_sock_fd= -1;
static char far MSearch[512];
static char far trash[1024];


#define GETIGDSVC_DURATION    6 * 60 /* 6 minutes*/
#define IGD_SEARCH_UNNORMAL   1 * 60 /* 1 minutes*/
#define CTRL_URL_CAP    6
static int IGDStatus = GW_UPNPENABLED;
static nuint32 GetIGDSvcExpireTime = 0;
static SERVICE_URL CtrlURL[CTRL_URL_CAP]; 
typedef struct 
_SERVICE_URL_ARRAY
{
    PSERVICE_URL    CtrlUrl;
    int cap;
    int offset;
}SERVICE_URL_ARRAY, *PSERVICE_URL_ARRAY;

static SERVICE_URL_ARRAY CtrlUrlArray =
{
    CtrlURL, CTRL_URL_CAP, 0
};

int GetIGDDescription(SERVICE_URL *SvcURL, http_message *msg)
{
    int ret;
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "GetIGDDescription");
#if 0
    POSESemaphoreWait( &UCPsemaphore );
    ret = UCPGenericConnection(SvcURL, UCPCreateGetMessage, NULL);
    POSESemaphorePost( &UCPsemaphore );
#endif
    if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
    ret = UCPGenericConnection(SvcURL, UCPCreateGetMessage, NULL);
    if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);

    if (ret != 0)
        status = FAIL;
    else if (FAIL == UCPParseRecvBuf(msg))
        status = FAIL;
    else
        status = PASS;
    return status;
}

static int IsDefaultGW(struct sockaddr_in * remoteaddr)
{
    char gw[16];
    unsigned long gateway;
    struct in_addr intaddr;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "IsDefaultGW");

    //const char *gateway = nvram_bufget(RT2860_NVRAM, "wan_gateway");
    //const char *gateway = "192.168.98.1";
    //default_gw = inet_addr(gateway);
    //default_gw = inet_aton(gateway);

    //intaddr.s_addr = gateway;
    //default_gw = inet_ntoa(intaddr);
    //DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
    //             "gateway = %x, default_gw = %s\r\n", gateway, default_gw);

    memset(gw, 0, sizeof gw);
    BinToHex((char *)&remoteaddr->sin_addr.s_addr, sizeof(remoteaddr->sin_addr.s_addr), gw);
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "remoteaddr = %s\r\n", gw);

    upnp_read_sysinfo(sizeof(default_gw), (char *)&default_gw, CURRENT_DEFAULT_GATEWAY);
    BinToHex((char *)&default_gw, sizeof(default_gw), gw);
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "default_gw = %s\r\n", gw);

    if (remoteaddr->sin_addr.s_addr == default_gw) {
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                "This is default gw, %s", gw);
        return 1;
    } else {
        return 0;
    }
}

static int UCPSearch(char *str)
{
    int len, sockaddrlen;
    struct sockaddr_in remoteaddr;
    struct  sockaddr_in  destaddr;
    struct timespec timeToWait;
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPSearch");
    /*Clear the ucp_msearch_sock_fd queue*/
    sockaddrlen = 16;
    do {
        memset(trash, 0, 1024); 
        //len = recvfrom(ucp_msearch_sock_fd, trash, 1024, 0, (struct sockaddr *)&remoteaddr, &sockaddrlen);
        len = recvfrom(ucp_msearch_sock_fd, trash, 1024, 0, (struct sockaddr *)&remoteaddr, (unsigned *)&sockaddrlen);
	DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
			"len = %d\r\n", len);
    }while(len>0);


    destaddr.sin_family = AF_INET;
    destaddr.sin_addr.s_addr = UPNP_MULTICAST_IP;  /* 239.255.255.250 */
    destaddr.sin_port = ntohs(UPNP_MULTICAST_PORT);

    /*UPNP M-SEARCH*/   

    memset(MSearch, 0, 512);
    strcat(MSearch, UCP_SEARCH);
    strcat(MSearch, UCP_MULTI_HOST);
    strcat(MSearch, UCP_H_ST);
    strcat(MSearch, UCP_SCOLON); 
    strcat(MSearch, UCP_SPACE); 
    strcat(MSearch, str); 
    strcat(MSearch, UCP_H_MAN);
    strcat(MSearch, UCP_SCOLON); 
    strcat(MSearch, UCP_SPACE); 
    strcat(MSearch, UCP_DISCOVER);
    strcat(MSearch, UCP_H_MX);
    strcat(MSearch, UCP_SCOLON); 
    strcat(MSearch, UCP_SPACE); 
    strcat(MSearch, "3"); 
    strcat(MSearch, UCP_CRLF); 
    strcat(MSearch, UCP_CRLF); 

    timeToWait.tv_sec = 1;
    timeToWait.tv_nsec = 0;
    nanosleep(&timeToWait, NULL);

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "MSearch = \r\n%s\r\n", MSearch);
#if 0
    sendto(ucp_msearch_sock_fd, MSearch, strlen(MSearch), 0, (struct sockaddr *)&destaddr, sockaddrlen);
    sendto(ucp_msearch_sock_fd, MSearch, strlen(MSearch), 0, (struct sockaddr *)&destaddr, sockaddrlen);
    sendto(ucp_msearch_sock_fd, MSearch, strlen(MSearch), 0, (struct sockaddr *)&destaddr, sockaddrlen);
#endif
    sendto(ucp_msearch_sock_fd, MSearch, strlen(MSearch), 0, (struct sockaddr *)&destaddr, sockaddrlen);
    sendto(ucp_msearch_sock_fd, MSearch, strlen(MSearch), 0, (struct sockaddr *)&destaddr, sockaddrlen);
    sendto(ucp_msearch_sock_fd, MSearch, strlen(MSearch), 0, (struct sockaddr *)&destaddr, sockaddrlen);

    timeToWait.tv_sec = 3;
    timeToWait.tv_nsec = 0;
    nanosleep(&timeToWait, NULL);

    while(1) {
    memset(MSearch, 0, 512); 
    len = recvfrom(ucp_msearch_sock_fd, MSearch, 512, 0, (struct sockaddr *)&remoteaddr, (unsigned *)&sockaddrlen);
    if (len <= 0) {
	DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
			"receive M-SEARCH response, len = %d\r\n", len);
        status = FAIL;
        break;
    } else if (len > 0) {
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                "MSearch =\r\n%s\r\n", MSearch);
        if (!IsDefaultGW(((struct sockaddr_in *)&remoteaddr))) {
            continue; 
        } else {
            status = PASS;
            do {
                memset(trash, 0, 1024); 
                len = recvfrom(ucp_msearch_sock_fd, trash, 1024, 0, (struct sockaddr *)&remoteaddr, (unsigned *)&sockaddrlen);
                DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                        "deplete:\nMSearch = %s\r\n", MSearch);
            }while(len>0);
            break;
        }
    }
    }
    return status;
}

static int UCPGetRemoteAddr(http_message *message, CALLBACK_ADDR *Callback)
{
    http_header *list;
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPGetRemoteAddr");
    list = message->header_list;
    while (list) {
        HttpHeaderToUpper(list->header.buff, list->header.size);
        if (strncmp(list->header.buff, UCP_H_LOCATION, list->header.size))
            list = list->next;
        else
            break;
    }

    if (!list)
        status = FAIL;
    else if (FAIL == extractLocationURL(list, Callback))
        status = FAIL;
    else
        status = PASS;

    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                "%s\r\n", list->header.buff);
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "IP = %s, Port = %s, Path = %s\r\n", Callback->IP,
                  Callback->Port, Callback->Path);
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "status = %d\r\n", status);
    return status;
}

int UCPGetIGDAddr(CALLBACK_ADDR *DeviceLoc)
{
    int status;
    static http_message UCPSearchMessage;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPGetIGDAddr");
    memset(&UCPSearchMessage, 0, sizeof(UCPSearchMessage));

    if (FAIL == UCPSearch(UCP_IGD))
        status = FAIL;
    else if (FAIL == parse_http_response(MSearch, &UCPSearchMessage, strlen(MSearch)))
        status = FAIL;
    else if (FAIL == UCPGetRemoteAddr(&UCPSearchMessage, DeviceLoc))
        status = FAIL;
    else
        status = PASS;
    if (UCPSearchMessage.header_list) {
        free_http_headers(UCPSearchMessage.header_list);
        UCPSearchMessage.header_list=NULL;
    }
    return status;
}

int UCPSearchClose(void)
{
    int ret =0;

    if (ucp_msearch_sock_fd > 0) {
        close(ucp_msearch_sock_fd);
        ret = PASS;
    } else {
        ret = FAIL;
    }

    return ret;
}

int UCPSearchInit(void)
{
    int sockaddrlen=16;
    struct  sockaddr_in  Msearchlocaladdr;
    int status = PASS;
    int flags;
	

    /*MSEARCH Socket INIT*/
    Msearchlocaladdr.sin_family = AF_INET;
    //Msearchlocaladdr.sin_addr.s_addr = UpnpIP;
    Msearchlocaladdr.sin_addr.s_addr = htonl(INADDR_ANY);
    Msearchlocaladdr.sin_port = ntohs(UCP_SEARCH_PORT);

    ucp_msearch_sock_fd = socket(AF_INET, SOCK_DGRAM, 0);
    if ((ucp_msearch_sock_fd>0)
        && (0 == bind(ucp_msearch_sock_fd, (struct sockaddr *)&Msearchlocaladdr, sockaddrlen))) {
        status = PASS;
        flags = fcntl(ucp_msearch_sock_fd, F_GETFL, 0);
        fcntl(ucp_msearch_sock_fd, F_SETFL, O_NONBLOCK|flags);
	DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
			"ucp_msearch_sock_fd = %d\r\n", ucp_msearch_sock_fd);
    } else {
        if (ucp_msearch_sock_fd >= 0) {
            close(ucp_msearch_sock_fd);
            ucp_msearch_sock_fd = -1;
            DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                    "%s FAIL\n", __func__);
        }

        error_code = 6; /*TCPIP socket error*/
        write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
        status = FAIL;
    }
    return status;
}

int MSearchSocketRefresh(unsigned long ip)
{
    int ret = -2;
    //thunder
    //ret = sock_change_upnpip(ucp_msearch_sock_fd);
    return ret;
}

int isUCPSearchSocketExist(void)
{
    int ret;

    if (0 <= ucp_msearch_sock_fd) {
        ret = TRUE;
    } else {
        ret = FALSE;
    }
    return ret;
}

int UCPGetIGDxURL(xmlDocPtr doc, xmlNodePtr node, void **para1, void *para2)
{
    char *buf = (char *)para2;
    char *content;
    CALLBACK_ADDR *Callback = (CALLBACK_ADDR *)*para1; 

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPGetIGDxURL");
    if (!strcmp((char *)node->name, buf)) 
    {
        content = (char *)xmlNodeGetContent(node);
        if (content)
        {
            DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "content = %s\r\n", content);
            UCPParsePlainXMLxURL(content, Callback);
            xmlMemFree(content);
            content = NULL;
        }
        return 1;
    }
    else return 0;
}

void ResetIGDSvcExpireTime(nuint32 wait)
{
    nuint32 now;
    time_t	t;

    //now = POSEClockGetTick();
    now = time(&t);
    GetIGDSvcExpireTime = now + wait;
}

static int GetUrlNodeValue(xmlDocPtr doc, xmlNodePtr node, CALLBACK_ADDR *Callback, char *tagName)
{
    xmlNodePtr node_url;
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "GetUrlNodeValue");
    if (!TraverseXMLTree(doc, node, GetXMLSpecificNode, (void **)&node_url, tagName, 0))
        status = FAIL;
    else if (!UCPGetIGDxURL(doc, node_url, (void **)&Callback, tagName))
        status = FAIL;
    else
        status = PASS;
    return status;
}

static int Search_ALL_IP_PPPService(xmlDocPtr doc, xmlNodePtr node, void **para1, void *para2)
{
    char *buf = (char *)para2;
    char *content;
    xmlNodePtr parent;
    PSERVICE_URL_ARRAY url_array;
    PSERVICE_URL url;
    int status;

    url_array = (PSERVICE_URL_ARRAY)*para1;
    parent = NULL;
    content = NULL;
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "node->name = %s\r\n", node->name);
    if (0 != strcmp((char *)node->name, buf)) {
        status = 0;
    } else if ( NULL == (content=(char *)xmlNodeGetContent(node))) {
            status = 0;
    } else if ((0 != strcmp(content, UCP_PPP_CONN))
           &&  (0 != strcmp(content, UCP_IP_CONN))) {
            DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "trash content = %s\r\n", content);
            status = 0;
    } else {
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "content = %s\r\n", content);
        parent = (void *)node->parent;
        url = url_array->CtrlUrl + url_array->offset;
        strcpy(url->serviceType, content);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "url->serviceType = %s\r\n", url->serviceType);
        if (FAIL == GetUrlNodeValue(doc, parent, &url->Callback, UCP_XML_CTRL_URL)) {
            status = 0;
        } else {
            url_array->offset++;
            status = 1;
        }
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "IP = %s, Port = %s, Path = %s\r\n", url->Callback.IP,
                  url->Callback.Port, url->Callback.Path);
    }
    if (content) {
        xmlMemFree(content);
        content = NULL;
    }
    return status;
}

static int UCPGet_ALL_IP_PPP_CtrlURL(SERVICE_URL_ARRAY *url_array, http_message *msg)
{   
    xmlDocPtr   doc;
    int status;
    static CALLBACK_ADDR Callback; 
    PSERVICE_URL    CtrlUrl;
    int i;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPGet_ALL_IP_PPP_CtrlURL");

    doc = xmlParseMemory(msg->content.buff, msg->content.size); 
    if (doc == NULL) {
        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "doc == NULL");
        status = FAIL;
    } else if (!TraverseXMLTree(doc, doc->root, Search_ALL_IP_PPPService, (void **)&url_array, UCP_XML_SERVICE_TYPE, 1))
        status = FAIL;
    else {
        status = PASS;
        memset(&Callback, 0, sizeof(Callback));
        GetUrlNodeValue(doc, doc->root, &Callback, UCP_XML_URLBASE);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
              "IP = %s, Port = %s, Path = %s\r\n", Callback.IP,
              Callback.Port, Callback.Path);
    }
    if (doc) {
        xmlFreeDoc(doc);
        doc = NULL;
    }

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "status = %d\r\n", status);
    for (i = 0; i < url_array->offset; i++) {
        CtrlUrl = url_array->CtrlUrl + i;
        if (0 == strlen(CtrlUrl->Callback.IP)) {
            strcpy(CtrlUrl->Callback.IP, Callback.IP);
            strcpy(CtrlUrl->Callback.Port, Callback.Port);
        }
    }
    return status;
}

int UCPGetIGDStatus(void)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPGetIGDStatus");
    return IGDStatus;
}

static void UCPSetIGDStatus(int status)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPSetIGDStatus");
    IGDStatus = status;
    return;
}

static int UCPGetConSvcURL(SERVICE_URL_ARRAY *url_array)
{
    int i;
    int status;
    static http_message msg;
    static SERVICE_URL SvcURL; 
    PSERVICE_URL CtrlUrl; 

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPGetConSvcURL");
    memset(&msg, 0, sizeof(msg));
    memset(&SvcURL, 0, sizeof(SvcURL));
    if (FAIL == UCPGetIGDAddr(&SvcURL.Callback)) {
        UCPSetIGDStatus(GW_UPNPDISABLED);
        status = FAIL;
    } else if (FAIL == GetIGDDescription(&SvcURL, &msg)) {
        UCPSetIGDStatus(GW_DATACORRUPT);
        status = FAIL;
    } else if (FAIL == UCPGet_ALL_IP_PPP_CtrlURL(url_array, &msg)) {
        UCPSetIGDStatus(GW_DATACORRUPT);
        status = FAIL;
    } else
        status = PASS;

    for (i = 0; i < url_array->offset; i++) {
        CtrlUrl = url_array->CtrlUrl + i;
        if (0 == strlen(CtrlUrl->Callback.IP)) {
            strcpy(CtrlUrl->Callback.IP, SvcURL.Callback.IP);
            strcpy(CtrlUrl->Callback.Port, SvcURL.Callback.Port);
        }
    }
    if (msg.header_list) {
        free_http_headers(msg.header_list);
        msg.header_list = NULL;
    }
    return status;
}

static int ucp_GetIGDSvc_expire(void)
{
    nuint32 now;
    int expired;
    time_t t;

    //now = POSEClockGetTick();
    now = time(&t);
    if (GetIGDSvcExpireTime <= now ) {
        GetIGDSvcExpireTime = now + GETIGDSVC_DURATION; 
        expired = TRUE;
    } else {
        expired = FALSE;
    }
    return expired;
}

static int UCPGetConnectionStatusInfo(void)
{
    int i;
    int status = FAIL;
    static http_message msg;
    xmlDocPtr   doc;
    xmlNodePtr node;
    PSERVICE_URL    CtrlUrl;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPGetConnectionStatusInfo");
    for (i = 0; i < CtrlUrlArray.offset; i++) {
        CtrlUrl = CtrlUrlArray.CtrlUrl + i;
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "ip = %s, port = %s, path = %s\r\n", 
                  CtrlUrl->Callback.IP,
                  CtrlUrl->Callback.Port, 
                  CtrlUrl->Callback.Path);
#if 0
        POSESemaphoreWait( &UCPsemaphore );
        status = UCPGenericConnection(CtrlUrl, UCPCreateGetStatusInfoMessage, 0);
        POSESemaphorePost( &UCPsemaphore );
#endif
	if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
	status = UCPGenericConnection(CtrlUrl, UCPCreateGetStatusInfoMessage, 0);
	if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);
        doc = NULL;
        if (FAIL == status)
            status = FAIL;
        else if (FAIL == UCPParseRecvBuf(&msg))
            status = FAIL;
        else if (strncmp(msg.status.reason_phrase.buff, UCP_OK, msg.status.reason_phrase.size))
            status = FAIL;
        else if (NULL == (doc=xmlParseMemory(msg.content.buff, msg.content.size)))
            status = FAIL;
        else if (!TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_NEW_CONNECTION_STATUS, 0))
            status = FAIL;
        else if (FAIL == GetXMLNodeValue(node, (CtrlUrl)->status))
            status = FAIL;
        else if (STREQ((CtrlUrl->status), "Disconnected"))
            status = FAIL;
        else
            status = PASS;

        if (msg.header_list) {
            free_http_headers(msg.header_list);
            msg.header_list = NULL;
        }
        if (doc) {
            xmlFreeDoc(doc);
            doc = NULL;
        }
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", msg.content.buff);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "svcType = %s\r\nstatus = %s\r\n", 
                  CtrlUrl->serviceType, 
                  CtrlUrl->status);
    }
    return status;
}

int UCPGetIGDSvc(void)
{
    int status;

    //status = ucp_GetIGDSvc_expire();
    //if (FALSE == status) return CONTINUE;
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "%s\r\n", "UCPGetIGDSvc");
    memset(CtrlURL, 0, sizeof(CtrlURL));
    memset(&CtrlUrlArray, 0, sizeof(CtrlUrlArray));
    CtrlUrlArray.CtrlUrl = CtrlURL;
    CtrlUrlArray.cap = CTRL_URL_CAP;
    CtrlUrlArray.offset = 0;
    UCPSetIGDStatus(GW_UPNPENABLED);
    if (FAIL == UCPGetConSvcURL(&CtrlUrlArray)) {
        //ResetIGDSvcExpireTime(IGD_SEARCH_UNNORMAL);
        sleep_time = IGD_SEARCH_UNNORMAL;
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,"===========================================proceeding = %d\n", 90);
        error_code = GW_UPNP_DISABLE; /*gateway upnp disable*/
        write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
        status = FAIL;
    } else if (FAIL == UCPGetConnectionStatusInfo()) {
        //ResetIGDSvcExpireTime(IGD_SEARCH_UNNORMAL);
        sleep_time = IGD_SEARCH_UNNORMAL;
        error_code = GW_WAN_PORT_DISCONNECTED; /*gateway wan port disconnected*/
        write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
        status = FAIL;
    } else
        status = PASS;
    return status;
}

int GetActiveConnection(SERVICE_URL *SvcCtrlURL)
{
    int status; 
    int i;
    int found;

    for (i = 0, found = FALSE; i < CtrlUrlArray.offset && !found; i++) {
        if (STREQ((CtrlUrlArray.CtrlUrl+i)->status, UCP_IGD_CONNECTED)) {
            found = TRUE;
        }
    }
    if (found == TRUE) {
        status = PASS;
        memcpy(SvcCtrlURL, CtrlUrlArray.CtrlUrl+(i-1), sizeof(*(CtrlUrlArray.CtrlUrl+(i-1))));
    } else {
        status = FAIL;
        memcpy(SvcCtrlURL, CtrlUrlArray.CtrlUrl+0, sizeof(*(CtrlUrlArray.CtrlUrl+0)));
    }
    return status;
}
/* vim:set sw=4 sts=4 sta si expandtab: */
