#ifndef _UCPOPENP_
#define _UCPOPENP_
typedef struct 
_PORT_MAP
{
    char RemoteHost[16];
    char ExternalPort[8];
    char PortMappingProtocol[4];
    char InternalPort[8];
    char InternalClient[16];
    char InternalServerName[32];
    char PortMappingEnabled[2];
    char PortMappingDescription[52];
    char PortMappingLeaseDuration[16];
    char DeviceMac[18];
    char CameraName[33];
}
PORT_MAP, *PPORT_MAP;

extern int web_port;
extern unsigned short port_forwarding_enable;
int UCPOpenPort(void);
int UCPGetDeviceInfo(void);
int VerifySecondPort(void);
void ResetOpenPortExpireTime(nuint32 wait);
int UCPGetOpenPortStatus(void);
static int UCPDeleteObsoletePortMapping(SERVICE_URL *SvcURL, PORT_MAP *cs);
int UCPDeletePortMapping_SIGUSR1(void);
int UCPGetWishPortMapping(SERVICE_URL *SvcURL, PORT_MAP *PortMap, PORT_MAP *cs);
#endif /*_UCPOPENP_*/
