#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include "upnp_types.h"
#include "http_pas.h"
#include "xml_dump.h"
#include "xml_pars.h"
#include "xml_mem.h"
#include "xml_dbg.h"
#include "fmt_cvt.h"
#include "misc_xml.h"
#include "semaphore_api.h"
#include "ucpbas.h"
#include "ucpmain.h"
#include "ucpcon.h"
#include "ucpsrch.h"
#include "ucpopenp.h"
#include "ucputl.h"
#include "dbgtrace.h"
#include "ralink_gpio.h"
#include <nvram.h>
#include "readsysinfo.h"
//#include "readsysinfo.h"
//#include "nvram.h"

#define    CONFIGEDBYUS        0
#define    CONFIGEDBYOTHER     1
#define    IGDUPNPDISABLED     2 
#define    ACTIONFAIL          3 
#define    INIT                4 
#define    DATACORRUPT         -1

int web_port = 0;

enum {
    IndexInvalid = 713,
    NoSuchEntry  = 714,
    Conflict     = 718,
    ActionFail   = 501,
    DataCorrupt  = -1
};

#define OPENPORT_DURATION     1 * 60 /* for loop 6 times(6 minutes)*/
#define IGD_SEARCH_UNNORMAL   1 * 60 /* 1 minutes*/
#define PORT_FOR_DEL            3

extern void CLSL_GetNodeAddress(int BoardId, char *NodeBuffer);
unsigned long  UpnpIP;
extern int ucpopen_sem_id;
extern unsigned int sleep_time;

//int camera_name_changed = 0;
static PORT_MAP CSPort;
unsigned short port_forwarding_enable = 0;
static nuint32 OpenPortExpireTime = 0;
static int OpenPortStatus = INIT;
static CODE_DESC OpenPortDesc[] = {
    {CONFIGEDBYUS, "ConfigedByUs"},
    {CONFIGEDBYOTHER, "ConfigedByOther"},
    {IGDUPNPDISABLED, "IGDUPnPDisabled"},
    {ACTIONFAIL, "ActionFail"},
    {INIT, "Init"},
    {DATACORRUPT, "DataCorrupt"},
};

static CODE_DESC IGDErr[] = {
    {IndexInvalid, "SpecifiedArrayIndexInvalid"},
    {NoSuchEntry, "NoSuchEntryInArray"},
    {Conflict, "ConflictInMappingEntry"},
    {ActionFail, "Action Fail"},
    {DataCorrupt, "Data Corrupt"},
};


static SERVICE_URL SIGUSR1_SvcCtrlURL; 

static int UCPAddPort(SERVICE_URL *SvcURL, PORT_MAP *cs)
{
    int status;
    static http_message msg;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPAddPort");
    if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
    status = UCPGenericConnection(SvcURL, UCPCreateAddPortMappingMessage, cs);
    if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);
    if (FAIL == status)
        status = FAIL;
    else if (FAIL == UCPParseRecvBuf(&msg))
        status = FAIL;
    else if (strncmp(msg.status.reason_phrase.buff, UCP_OK, msg.status.reason_phrase.size))
        status = GetErrorCode(&msg);
    else
        status = PASS;

    if (msg.header_list) {
        free_http_headers(msg.header_list);
        msg.header_list = NULL;
    }
    return status;
}

static int ListPortMapInfo(PORT_MAP PortMap[], int i)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "ListPortMapInfo");
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "*************************************\r\n");
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "desc = %-s, r_host = %-15s\r\nport = %-5s, i_client = %-15s, mac = %-18s\r\nPortMap->PortMappingLeaseDuration = %-s, enabled = %-s, index = %-2d\r\n", 
                  PortMap->PortMappingDescription, PortMap->RemoteHost, 
                  PortMap->ExternalPort, PortMap->InternalClient, 
                  PortMap->DeviceMac,
                  PortMap->PortMappingLeaseDuration,
                  PortMap->PortMappingEnabled, i);
    return 0;
}

static int UCPDeletePortArray(SERVICE_URL *SvcURL, PORT_MAP *PortMap, int size)
{
    int i;
    int status;
    static http_message msg;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPDeletePortArray");

    for (i = 0, status = PASS; i < size && status == PASS; i++) {
        ListPortMapInfo(&PortMap[i], i);
	if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
	status = UCPGenericConnection(SvcURL, UCPCreateDeletePortMappingMessage, (void*)&PortMap[i]);
	if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);
        if (FAIL == status)
            status = FAIL;
        else if (FAIL == UCPParseRecvBuf(&msg))
            status = FAIL;
        else if (strncmp(msg.status.reason_phrase.buff, UCP_OK, msg.status.reason_phrase.size)) {
            status = GetErrorCode(&msg);
            DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                       "\r\nerrorCode = %d, desc = %s\r\n\r\n", status, 
                       GetCodeDesc(IGDErr, NELEMS(IGDErr), status));
        }
        else
            status = PASS;

        if (msg.header_list) {
            free_http_headers(msg.header_list);
            msg.header_list = NULL;
        }
    }
    return status;
}

static void convertServerNameToIP(PORT_MAP *PortMap, PORT_MAP *cs)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "convertServerNameToIP");
    if (STREQ(PortMap->InternalClient, cs->InternalServerName))
        strcpy(PortMap->InternalClient, cs->InternalClient);
    return;
}

static int ExtractMac(PORT_MAP *PortMap)
{
    char *mac_begin, *mac_end;
    char mac_buf[18];

    memset(mac_buf, 0, sizeof mac_buf);

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", __func__);

    mac_begin = NULL;
    
    /* search from right
     * because we allow '(' and ')' in Cameraname
     */
    mac_end = strrchr(PortMap->PortMappingDescription, ')');
    if (NULL != mac_end) {
        mac_begin = mac_end - 17 - 1;
        if ((NULL != mac_begin) && (*mac_begin != '(')) {
                mac_begin = NULL;
        }
    }

    if (NULL == mac_begin || NULL == mac_end) {
        strncpy(PortMap->DeviceMac, PortMap->PortMappingDescription, sizeof PortMap->DeviceMac);
    } else {
        strncpy(PortMap->DeviceMac, mac_begin + 1, ((mac_end - 1) - mac_begin));
    }
    return 0;
}

static int UCPextractPortMapInfo(http_message *msg, PORT_MAP *PortMap)
{
    xmlDocPtr   doc;
    xmlNodePtr  node;
    char EncodedValue[256];
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPextractPortMapInfo");
    status = PASS;
    doc = xmlParseMemory(msg->content.buff, msg->content.size); 
    if (doc == NULL)
        status = FAIL;
    else {
        memset(PortMap, 0, sizeof(*PortMap));
        /*GetPortMappingDescription*/
        TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_P_DESC, 0);
        memset(EncodedValue, 0, sizeof(EncodedValue));
        GetXMLNodeValue(node, EncodedValue);
        GetXMLNodeValue(node, PortMap->PortMappingDescription);
        ExtractMac(PortMap);
        /*GetPortMappingRemoteHost*/
        TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_REMOTE_HOST, 0);
        GetXMLNodeValue(node, PortMap->RemoteHost);
        /*GetPortMappingExternalPort*/
        TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_E_PORT, 0);
        GetXMLNodeValue(node, PortMap->ExternalPort);
        /*GetPortMappingProtocol*/
        TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_PROTOCOL, 0);
        GetXMLNodeValue(node, PortMap->PortMappingProtocol);
        /*GetPortMappingInternalClient*/
        TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_I_CLIENT, 0);
        GetXMLNodeValue(node, PortMap->InternalClient);
        /*GetPortMappingEnabled*/
        TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_ENABLED, 0);
        GetXMLNodeValue(node, PortMap->PortMappingEnabled);
        /*GetPortMappingInternalPort*/
        TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_I_PORT, 0);
        GetXMLNodeValue(node, PortMap->InternalPort);
        /*GetPortMappingLeaseDuration*/
        TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_IGD_L_DURA, 0);
        GetXMLNodeValue(node, PortMap->PortMappingLeaseDuration);
    }

    if (doc) {
        xmlFreeDoc(doc);
        doc = NULL;
    }
    return status;
}

//static int UCPGetWishPortMapping(SERVICE_URL *SvcURL, PORT_MAP *PortMap, PORT_MAP *cs)
int UCPGetWishPortMapping(SERVICE_URL *SvcURL, PORT_MAP *PortMap, PORT_MAP *cs)
{
    int status;
    static http_message  msg;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPGetWishPortMapping");
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "cs->ExternalPort = %s\r\n", cs->ExternalPort);
    if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
    status = UCPGenericConnection(SvcURL, UCPCreateGetSpecificPortMessage, cs->ExternalPort);
    if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);
    if (FAIL == status)
        status = FAIL;
    else if (FAIL == UCPParseRecvBuf(&msg))
        status = FAIL;
    else if (strncmp(msg.status.reason_phrase.buff, UCP_OK, msg.status.reason_phrase.size))
        status = FAIL;
    else if (FAIL == UCPextractPortMapInfo(&msg, PortMap))
        status = FAIL;
    else {
        convertServerNameToIP(PortMap, cs);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "PortMappingDescription = %s\r\n", PortMap->PortMappingDescription);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "InternalClient = %s\r\n", PortMap->InternalClient);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "InternalPort = %s\r\n", PortMap->InternalPort);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "ExternalPort = %s\r\n", PortMap->ExternalPort);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "PortMappingEnabled = %s\r\n", PortMap->PortMappingEnabled);
    }
    if (msg.header_list) {
        free_http_headers(msg.header_list);
        msg.header_list = NULL;
    }
    return status;
}

static int shouldDelete(PORT_MAP *PortMap, PORT_MAP *cs)
{
    int found_prev, found_conflict;
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "shouldDelete");
    found_prev = found_conflict = FALSE;
    //ExtractMac(PortMap);
    /* Force to delete port set by us previously*/
#if 1
    if ((STREQ(PortMap->DeviceMac, cs->DeviceMac))) {
        if (0 == port_forwarding_enable) {
            found_prev = TRUE;
        } else {
            if ((!STREQ(PortMap->PortMappingDescription, cs->PortMappingDescription)) 
                    || (!STREQ(PortMap->ExternalPort, cs->ExternalPort))
                    || (!STREQ(PortMap->InternalClient, cs->InternalClient)))
            {
                found_prev = TRUE;
            }
        }

    }
#endif
#if 0
    if ((STREQ(PortMap->PortMappingDescription, cs->PortMappingDescription))) {
        found_prev = TRUE;
    }
#endif
#if 0
    if ((STREQ(PortMap->PortMappingDescription, cs->PortMappingDescription)) 
         && ((!STREQ(PortMap->ExternalPort, cs->ExternalPort))
            || (!STREQ(PortMap->InternalClient, cs->InternalClient)))
       ) {
        found_prev = TRUE;
    }
#endif
#if 0
    /* Force to delete port conflicts with that we want*/
    if ((!STREQ(PortMap->PortMappingDescription, cs->PortMappingDescription)) 
         &&(STREQ(PortMap->ExternalPort, cs->ExternalPort))) {
        found_conflict = TRUE;
    }
#endif
    if (TRUE == found_prev || TRUE == found_conflict) {
        status = TRUE;
    } else {
        status = FALSE;
    }
    return status;
}

static int UCPSearchShouldDeletePort(SERVICE_URL *SvcURL,
        PORT_MAP *cs, PORT_MAP *PortMap, int *size)
{
    int i, j;
    int terminate;
    int status, ecode;
    static http_message  msg;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPSearchShouldDeletePort");
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "selected: desc = %s, port = %s, mac = %s\r\n", 
                  cs->PortMappingDescription, cs->ExternalPort, cs->DeviceMac);
    terminate = FALSE;
    status = PASS;
    for (i = j = 0; terminate == FALSE && status == PASS; i++) {
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                "****************************************************** index = %d\n", i);
	if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
	status = UCPGenericConnection(SvcURL, UCPCreateGetGenericPortMessage, (int *)&i);
	if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);
        if (FAIL == status)
            status = FAIL;
        else if (FAIL == UCPParseRecvBuf(&msg))
            status = FAIL;
        else if (strncmp(msg.status.reason_phrase.buff, UCP_OK, msg.status.reason_phrase.size)) {
            ecode = GetErrorCode(&msg);
            DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                       "\r\nerrorCode = %d, desc = %s\r\n\r\n", ecode,
                       GetCodeDesc(IGDErr, NELEMS(IGDErr), ecode));
            terminate = TRUE;
        }
        else if (FAIL == UCPextractPortMapInfo(&msg, &PortMap[j]))
            status = FAIL;
        else {
            convertServerNameToIP(&PortMap[j], cs);
            ListPortMapInfo(&PortMap[j], i);
#if 0
            if (TRUE == isConfigedByUs(&PortMap[j], cs))
                *configed = TRUE;
            else if (TRUE == shouldDelete(&PortMap[j], cs))
                    (*size - 1 > j) ? j++ : j;
#endif
            if (TRUE == shouldDelete(&PortMap[j], cs))
                (*size - 1 > j) ? j++ : j;
        }

        if (msg.header_list) {
            free_http_headers(msg.header_list);
            msg.header_list = NULL;
        }
    } /*for loop*/
    *size = j;
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "size = %1d\r\n", *size);
    return status;
}

int UCPGetTotalPortMappingNo(SERVICE_URL *SvcURL, unsigned *PortMappingNo)
{   
    static http_message  msg;
    xmlDocPtr   doc;
    xmlNodePtr  node;
    char tmp[8];
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPGetTotalPortMappingNo");
    if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
    status = UCPGenericConnection(SvcURL, UCPCreateQueryPortMappingNoMessage, NULL);
    if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);

    doc = NULL;
    if (FAIL == status)
        status = FAIL;
    else if (FAIL == UCPParseRecvBuf(&msg))
        status = FAIL;
    if (NULL == (doc=xmlParseMemory(msg.content.buff, msg.content.size))) 
        status = FAIL;
    else if (!TraverseXMLTree(doc, doc->root, GetXMLSpecificNode, (void **)&node, UCP_XML_RETURN, 0))
        status = FAIL;
    else if (FAIL == GetXMLNodeValue(node, tmp))
        status = FAIL;
    else
        //*PortMappingNo=Natoi(tmp);
        *PortMappingNo=atoi(tmp);

    if (doc) {
        xmlFreeDoc(doc);
        doc = NULL;
    }
    if (msg.header_list) {
        free_http_headers(msg.header_list);
        msg.header_list = NULL;
    }
    return status;
}

static int UCPDeleteObsoletePortMapping(SERVICE_URL *SvcURL, PORT_MAP *cs)
{
    static PORT_MAP PortMap[PORT_FOR_DEL];
    int size;
    int status;

    memset(PortMap, 0, sizeof PortMap);

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPDeleteObsoletePortMapping");
    size = PORT_FOR_DEL;
    if (PASS != (status=UCPSearchShouldDeletePort(SvcURL, cs, PortMap, &size)))
        ;
    else 
        status = UCPDeletePortArray(SvcURL, PortMap, size);
    return status;
}

int UCPGetOpenPortStatus(void)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPGetOpenPortStatus");
    return OpenPortStatus;
}

static void UCPSetOpenPortStatus(int status)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPSetOpenPortStatus");
    OpenPortStatus = status;
    return;
}

static int isPortMapEnabled(PORT_MAP *PortMap)
{
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "isPortMapEnabled");
    if (STREQ(PortMap->PortMappingEnabled, "1"))
        status = TRUE;
    else
        status = FALSE;
    return status;
}

static int isConfigedByUs(PORT_MAP *PortMap, PORT_MAP *cs)
{
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "isConfigedByUs");

    //ExtractMac(PortMap); 
    /*(STREQ(PortMap->DeviceMac, cs->DeviceMac)*/
    if (STREQ(PortMap->PortMappingDescription, cs->PortMappingDescription)
             && STREQ(PortMap->InternalClient, cs->InternalClient)
             && STREQ(PortMap->InternalPort, cs->InternalPort)
             && STREQ(PortMap->PortMappingEnabled, "1"))
        status = TRUE;
    else
        status = FALSE;
    return status;
}

static int UCPDoPortMapping(SERVICE_URL *SvcURL, PORT_MAP *cs)
{
    int status;
    int addstatus = PASS;
    static PORT_MAP PortMap;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "UCPDoPortMapping");
    status = UCPGetWishPortMapping(SvcURL, &PortMap, cs);
    if (FAIL == status)
        status = FAIL;
    else if (FALSE == isPortMapEnabled(&PortMap))
        status = FAIL;
    else if (TRUE == isConfigedByUs(&PortMap, cs)) {
        UCPSetOpenPortStatus(CONFIGEDBYUS);
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,"===========================================proceeding = %d\n", 100);
        error_code = PORT_FORWARDING_SUCCESS; /*port open success*/
        write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
        status = PASS;
    } else {
        UCPSetOpenPortStatus(CONFIGEDBYOTHER);
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,"===========================================proceeding = %d\n", 101);
        error_code = PORT_USED_BY_GW; /*port already used by gw*/
        write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
        status = PASS;
    }
    if (FAIL == status) {
        addstatus = UCPAddPort(SvcURL, cs);
        switch (addstatus) {
        case ActionFail:
            UCPSetOpenPortStatus(ACTIONFAIL);
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,"===========================================proceeding = %d\n", 102);
            error_code = ADD_PORT_FAIL; /*add port fail*/
            write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
            break;
        case Conflict:
            UCPSetOpenPortStatus(CONFIGEDBYOTHER);
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,"===========================================proceeding = %d\n", 103);
            error_code = PORT_USED_BY_GW; /*port already used by gw*/
            write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
            break;
        case PASS:
            UCPSetOpenPortStatus(CONFIGEDBYUS);
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,"===========================================proceeding = %d\n", 104);
            error_code = PORT_FORWARDING_SUCCESS; /*port open success*/
            write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
            break;
        case FAIL:
        default:
            UCPSetOpenPortStatus(DATACORRUPT);
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,"===========================================proceeding = %d\n", 105);
            error_code = PORT_FORWARDING_SOCKET_ERROR; /*port forwarding socket error*/
            write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
            break;
        }
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
            "\r\nAdd Port errorCode = %d, desc = %s\r\n\r\n", addstatus, 
            GetCodeDesc(IGDErr, NELEMS(IGDErr), addstatus));
    }
    return addstatus;
}

/* handle SIGUSR1 */
int UCPDeletePortMapping_SIGUSR1(void)
{
    int status, igdstatus, portstatus;
    static SERVICE_URL SvcCtrlURL; 
    static http_message  msg;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
            "IN %s\r\n", "=====UCPDeletePortMapping_SIGUSR1=====");
    if (port_forwarding_enable == 0) exit (0);
    xmlMemMonitor(XML_DBG_LEVEL_TRACE_FLOW);

    ListPortMapInfo(&CSPort, 0);
    if (!semaphore_p(ucpopen_sem_id)) exit(EXIT_FAILURE);
    status = UCPGenericConnection(&SIGUSR1_SvcCtrlURL, UCPCreateDeletePortMappingMessage, (void*)&CSPort);
    if (!semaphore_v(ucpopen_sem_id)) exit(EXIT_FAILURE);
    if (FAIL == status)
        status = FAIL;
    else if (FAIL == UCPParseRecvBuf(&msg))
        status = FAIL;
    else if (strncmp(msg.status.reason_phrase.buff, UCP_OK, msg.status.reason_phrase.size)) {
        status = GetErrorCode(&msg);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                "\r\nerrorCode = %d, desc = %s\r\n\r\n", status, 
                GetCodeDesc(IGDErr, NELEMS(IGDErr), status));
    }
    else
        status = PASS;

    if (msg.header_list) {
        free_http_headers(msg.header_list);
        msg.header_list = NULL;
    }

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
            "OUT %s\r\n", __FUNCTION__);
    exit(0);
}

static int UCPAddNewPortMapping(SERVICE_URL *SvcURL, PORT_MAP *cs)
{
    int status;
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", __FUNCTION__);
 
    if (PASS != UCPDoPortMapping(SvcURL, cs))
        status = FAIL;
    else
        status = PASS;
    return status;
}


static int UCPDeleteObsoleteAddNewPortMapping(SERVICE_URL *SvcURL, PORT_MAP *cs)
{
    int status;

    UCPDeleteObsoletePortMapping(SvcURL, cs);
    if (PASS != UCPDoPortMapping(SvcURL, cs))
        status = FAIL;
    else
        status = PASS;
    return status;
}

static int UCPGetDeviceMac(PUCP_BUFF_SPOT mac)
{
    int i;
    //int j;
    char mac_addr_bin[6];
    char mac_addr_hex[13];
    //char *str1, *saveptr1, *token;

    //char *tmac = nvram_bufget(RT2860_NVRAM, "WAN_MAC_ADDR");
    //char *tmac = "00:0c:43:66:80:20";
    //strcpy(mac->buff, tmac);

#if 0
    //CLSL_GetNodeAddress(0, mac_addr_bin);
#endif
    memset(mac_addr_hex, 0, 13);
    /*MAC Address*/
    memset(mac_addr_bin, 0, sizeof mac_addr_bin);
    upnp_read_sysinfo(sizeof(mac_addr_bin), mac_addr_bin, MAC_ADDRESS);

#if 0
    for (j = 1, str1 = mac; ; j++, str1 = NULL) {
        token = strtok_r(str1, ":", &saveptr1);
        if (token == NULL)
            break;
        strcat(mac_addr_bin, token);
    }
#endif

    BinToHex(mac_addr_bin, 6, mac_addr_hex); 
    memset(mac->buff, 0, mac->capacity);
    /* Convert mac addr. format.
     *"0011023e0F05"
     *"00:11:02:3e:0F:05"
     */
    for (i=0;i<12;i+=2) {
        strncpy(mac->cur_pstn, mac_addr_hex+i, 2);
        mac->cur_pstn+=2;
        if (10 != i) {
            strncpy(mac->cur_pstn, UCP_SCOLON, 1);
            mac->cur_pstn++;
        }
    }
    return 0;
}


#if 1
int UCPGetDeviceInfo(void)
{
    //unsigned long store;
    char tmp[20];
    char mac_addr[18];
    UCP_BUFF_SPOT mac_addr_spot;
    char model_name[32];
    char camera_name[33];

    upnp_read_sysinfo(sizeof(UpnpIP), (char *)&UpnpIP, UPNP_IP);

    memset(tmp, 0, 20);
    strcpy(tmp, (const char *)inet_ntoa(*(struct in_addr*)&UpnpIP));
    //printf("tmp = %s\n", tmp);

    strncpy(CSPort.InternalClient, tmp, sizeof(CSPort.InternalClient));
    
    strcpy(camera_name, nvram_bufget(RT2860_NVRAM, "CameraName"));

    nvram_close(RT2860_NVRAM);

#if 0
    if(STREQ(CSPort.CameraName, camera_name)) {
        camera_name_changed = 1;
    } else {
        camera_name_changed = 0;
    }
#endif

    memset(model_name, 0, sizeof model_name);
    upnp_read_sysinfo(sizeof(model_name), model_name, SYSINFO_MODEL);
    strcpy(CSPort.InternalServerName, model_name);

    mac_addr_spot.buff=mac_addr;
    mac_addr_spot.cur_pstn=mac_addr;
    mac_addr_spot.capacity=sizeof(mac_addr);
    UCPGetDeviceMac(&mac_addr_spot);
#if 0
    strncpy(CSPort.PortMappingDescription, mac_addr_spot.buff, 
            (size_t)(mac_addr_spot.cur_pstn - mac_addr_spot.buff));
#endif
    sprintf(CSPort.PortMappingDescription, "%s(%s)", camera_name, mac_addr_spot.buff);
    strcpy(CSPort.DeviceMac, mac_addr_spot.buff);
    //strcpy(CSPort.PortMappingDescription, mac_addr_spot.buff);

    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
        "PortMappingDescription = %s IP = %s DeviceMac = %s ServerName = %s\r\n", CSPort.PortMappingDescription, 
        CSPort.InternalClient, CSPort.DeviceMac, CSPort.InternalServerName);
    return 0;
}
#else
int UCPGetDeviceInfo(void)
{
    //unsigned long store;
    char tmp[20];
    char mac_addr[18];
    UCP_BUFF_SPOT mac_addr_spot;
    struct ifreq   buffer[32];
    struct ifconf  intfc;
    struct ifreq  *pIntfc;
    int            i, fd, num_intfc;
    char model_name[32];
    char camera_name[33];

    intfc.ifc_len = sizeof(buffer);
    intfc.ifc_buf = (char*) buffer;

    if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
    {
        perror("socket() failed");
        return 1;
    }

    if (ioctl(fd, SIOCGIFCONF, &intfc) < 0)
    {
        perror("ioctl SIOCGIFCONF failed");
        return 1;
    }

    pIntfc    = intfc.ifc_req;
    num_intfc = intfc.ifc_len / sizeof(struct ifreq);

    memset(tmp, 0, 20);
    for (i = 0; i < num_intfc; i++)
    {
        struct ifreq *item = &(pIntfc[i]);
#if 0
        printf("Interface # %d -> %s: IP %s, %x\n",
                i, item->ifr_name,
                inet_ntoa(((struct sockaddr_in *)&item->ifr_addr)->sin_addr), 
                (((struct sockaddr_in *)&item->ifr_addr)->sin_addr).s_addr);
#endif
        strcpy(tmp, inet_ntoa((((struct sockaddr_in *)&item->ifr_addr)->sin_addr)));
        if (0x0100007f != (unsigned int)((((struct sockaddr_in *)&item->ifr_addr)->sin_addr).s_addr)) {
            UpnpIP = (unsigned int)((((struct sockaddr_in *)&item->ifr_addr)->sin_addr).s_addr);
        }
    }
    strncpy(CSPort.InternalClient, tmp, sizeof(CSPort.InternalClient));

    strcpy(camera_name, nvram_bufget(RT2860_NVRAM, "CameraName"));
    nvram_close(RT2860_NVRAM);

    memset(model_name, 0, sizeof model_name);
    upnp_read_sysinfo(sizeof(model_name), model_name, SYSINFO_MODEL);
    strcpy(CSPort.InternalServerName, model_name);

    mac_addr_spot.buff=mac_addr;
    mac_addr_spot.cur_pstn=mac_addr;
    mac_addr_spot.capacity=sizeof(mac_addr);
    UCPGetDeviceMac(&mac_addr_spot);
#if 0
    strncpy(CSPort.PortMappingDescription, mac_addr_spot.buff, 
            (size_t)(mac_addr_spot.cur_pstn - mac_addr_spot.buff));
#endif
    sprintf(CSPort.PortMappingDescription, "%s(%s)", camera_name, mac_addr_spot.buff);
    strcpy(CSPort.DeviceMac, mac_addr_spot.buff);
    //strcpy(CSPort.PortMappingDescription, mac_addr_spot.buff);

    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
        "PortMappingDescription = %s IP = %s ServerName = %s\r\n", CSPort.PortMappingDescription, 
        CSPort.InternalClient, CSPort.InternalServerName);
    return 0;
}
#endif

#if 0
int UCPGetDeviceInfo(void)
{
    //unsigned long store;
    char tmp[20];
    char mac_addr[18];
    UCP_BUFF_SPOT mac_addr_spot;
    struct hostent *hp;
    struct in_addr a;
    char **addrs;
    char model_name[32];

    //const char *hostname = nvram_bufget(RT2860_NVRAM, "HostName");
    const char *hostname = "centosquad";

    hp = gethostbyname(hostname);

    addrs = hp->h_addr_list;
    if (hp) {
	while (*addrs)
	{
	    bcopy(*addrs++, (char *) &a, sizeof(a));
	    printf("address: %s\n", inet_ntoa(a));
	    fflush(NULL);
	}
    }
    UpnpIP = a.s_addr;
    addrs = hp->h_addr_list;
    bcopy(*addrs++, (char *) &a, sizeof(a));
#if 0
    if (hp) {
	while ((char *)*hp->h_addr_list)
	{
	    bcopy(*hp->h_addr_list++, (char *) &a, sizeof(a));
	    printf("address: %s\n", inet_ntoa(a));
	}
    }
    UpnpIP = a.s_addr;

    bcopy(*hp->h_addr_list++, (char *) &a, sizeof(a));
#endif
    memset(tmp, 0, 20);
    strcpy(tmp, inet_ntoa(a));
    //store = getipbyname("ralink");
    //addr_ipstrcpy(tmp, store);
    strncpy(CSPort.InternalClient, tmp, sizeof(CSPort.InternalClient));
    //NCLGetBuffer(SYS_SUBJECT, SYS_NAME, (unsigned char *)CSPort.InternalServerName, SERVER_NAME_LENGTH); 

    memset(model_name, 0, sizeof model_name);
    upnp_read_sysinfo(sizeof(model_name), model_name, SYSINFO_MODEL);
    strcpy(CSPort.InternalServerName, model_name);

    mac_addr_spot.buff=mac_addr;
    mac_addr_spot.cur_pstn=mac_addr;
    mac_addr_spot.capacity=sizeof(mac_addr);
    UCPGetDeviceMac(&mac_addr_spot);
#if 0
    strncpy(CSPort.PortMappingDescription, mac_addr_spot.buff, 
            (size_t)(mac_addr_spot.cur_pstn - mac_addr_spot.buff));
#endif
    strcpy(CSPort.PortMappingDescription, mac_addr_spot.buff);

    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
        "MAC = %s IP = %s ServerName = %s\r\n", CSPort.PortMappingDescription, 
        CSPort.InternalClient, CSPort.InternalServerName);
    return 0;
}
#endif

#if CS
int VerifySecondPort(void)
{
    unsigned int port_number= 0;
    char *PortForwardingEnable = nvram_bufget(RT2860_NVRAM, "UPnPPortForwarding");
    char *SecondHTTPPort = nvram_bufget(RT2860_NVRAM, "SecondHTTPPort");


    if (PortForwardingEnable) {
        port_forwarding_enable = atoi(PortForwardingEnable);
    } else {
        port_forwarding_enable = 0;
    }

    if (SecondHTTPPort) {
        port_number = atoi(SecondHTTPPort);
    } else {
        port_number = 0;
    }

    if (0 == port_number || 80 == port_number ) { 
        port_forwarding_enable=0;
        web_port = port_number;
    }

    nvram_close(RT2860_NVRAM);
#if 0
    NWutoa(port_number, (unsigned char *)CSPort.InternalPort, 10);
    NWutoa(port_number, (unsigned char *)CSPort.ExternalPort, 10);
#endif
    sprintf(CSPort.InternalPort, "%d", port_number);
    sprintf(CSPort.ExternalPort, "%d", port_number);
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "PORT = %s\r\n", CSPort.ExternalPort);
    return port_forwarding_enable;
}
#else

int VerifySecondPort(void)
{
    unsigned int port_number= 0;

    NCLGetItem16(TCPIP2_SUBJECT, TCPIP2_ENABLE_WEB_PORT, &port_forwarding_enable);

    if (port_forwarding_enable == 0) {
        return -1;
    }

    NCLGetItem16(TCPIP2_SUBJECT, TCPIP2_WEB_PORT, &port_number);

    if (port_number==0) {
        port_forwarding_enable=0;
        return -1;
    }

    //NWutoa(port_number, second_port, 10);
    NWutoa(port_number, (unsigned char *)CSPort.InternalPort, 10);
    NWutoa(port_number, (unsigned char *)CSPort.ExternalPort, 10);
    DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "PORT = %s\r\n", CSPort.ExternalPort);
    return 0;
}
#endif

void ResetOpenPortExpireTime(nuint32 wait)
{
    nuint32 now;
    time_t  t;

    //now = POSEClockGetTick();
    now = time(&t);
    OpenPortExpireTime = now + wait;
}

static int ucp_openport_expire(void)
{
    nuint32 now;
    int expired;
    time_t  t;

    //now = POSEClockGetTick();
    now = time(&t);
    if (OpenPortExpireTime <= now ) {
        OpenPortExpireTime = now + OPENPORT_DURATION; 
        expired = TRUE;
    } else {
        expired = FALSE;
    }
    return expired;
}

int UCPOpenPort(void)
{
    int status, igdstatus, portstatus;
    static SERVICE_URL SvcCtrlURL; 
    unsigned short OpenPort;

#if 0
    if (port_forwarding_enable == 0) return CONTINUE;
#endif
    //status = ucp_openport_expire();
    //if (FALSE == status) return CONTINUE;
    //NCLGetItem16(SYS2_SUBJECT, SYS2_UPNP_PORT_OPEN, &OpenPort);
#if 0
    OpenPort = TRUE;
    if (FALSE == OpenPort) {
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "OpenPort = %d\r\n", OpenPort);
            return CONTINUE;
    }
#endif
    xmlMemMonitor(XML_DBG_LEVEL_TRACE_FLOW);
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                  "%s\r\n", "=====UCPOpenPort=====");
    memset(&SvcCtrlURL, 0, sizeof(SvcCtrlURL));
    igdstatus = UCPGetIGDStatus();
    if (GW_UPNPDISABLED == igdstatus) {
        //ResetOpenPortExpireTime(IGD_SEARCH_UNNORMAL);
        sleep_time = IGD_SEARCH_UNNORMAL;
        UCPSetOpenPortStatus(IGDUPNPDISABLED);
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,"===========================================proceeding = %d\n", 98);
        error_code = GW_UPNP_DISABLE; /*gateway upnp disable*/
        write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
        status = FAIL;
    } else if (GW_DATACORRUPT == igdstatus) {
        //ResetOpenPortExpireTime(IGD_SEARCH_UNNORMAL);
        sleep_time = IGD_SEARCH_UNNORMAL;
        UCPSetOpenPortStatus(IGDUPNPDISABLED);
        UCPSetOpenPortStatus(DATACORRUPT);
        DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,"===========================================proceeding = %d\n", 99);
        error_code = PORT_FORWARDING_SOCKET_ERROR; /*port frowarding socket error*/
        write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
        status = FAIL;
    } else {
        GetActiveConnection(&SvcCtrlURL);
        memcpy(&SIGUSR1_SvcCtrlURL, &SvcCtrlURL, sizeof SvcCtrlURL);

        if (FAIL == UCPDeleteObsoletePortMapping(&SvcCtrlURL, &CSPort))
            status = FAIL;
        else {
            status = PASS;
        }
        /*spec defined* port_forwarding_enable = 3*/
        if ( 1 == port_forwarding_enable) {
            if (FAIL == UCPAddNewPortMapping(&SvcCtrlURL, &CSPort)) {
                sleep_time = IGD_SEARCH_UNNORMAL;
                status = FAIL;
            } else {
                sleep_time = OPENPORT_DURATION;
                status = PASS;
            }

            portstatus = UCPGetOpenPortStatus();
            DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_OPENP,
                    "\r\nportstatus = %d, desc = %s\r\n\r\n", 
                    portstatus, GetCodeDesc(OpenPortDesc, NELEMS(OpenPortDesc), portstatus));
        }

#if 0
        if (FAIL == UCPDeleteObsoleteAddNewPortMapping(&SvcCtrlURL, &CSPort))
            status = FAIL;
        else
            status = PASS;
#endif
    }
   xmlMemMonitor(XML_DBG_LEVEL_TRACE_FLOW);
    return status;
}
/* vim:set sw=4 sts=4 sta si expandtab: */
