#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <netinet/in.h>
#include "upnp_types.h"
#include "http_pas.h"
#include "semaphore_api.h"
#include "xml_dump.h"
#include "xml_pars.h"
#include "xml_mem.h"
#include "xml_dbg.h"
#include "fmt_cvt.h"
#include "misc_xml.h"
#include "ucp.h"
#include "upnp_wra.h"
#include "ucpbas.h"
#include "ucpmain.h"
#include "ucputl.h"
#include "ucpsrch.h"
#include "ucpcon.h"
#include "ucpopenp.h"
#include "ucpwanip.h"
#include "dbgtrace.h"
#include <signal.h>
#include "nvram.h"
#include "ralink_gpio.h"
#include "../utility/readsysinfo.h"

//thunder
#define far
//extern unsigned long UpnpIP;
//extern int camera_name_changed;
extern unsigned long UpnpIP;
extern unsigned long default_gw;
extern void CLSL_GetNodeAddress(int BoardId, char *NodeBuffer);
unsigned int sleep_time;
static char camera_name[33];
int igd_accessible = FAIL;
int open_port_success = FAIL;

char far UCP_PPP_CONN[]="urn:schemas-upnp-org:service:WANPPPConnection:1";
char far UCP_IP_CONN[]="urn:schemas-upnp-org:service:WANIPConnection:1";

char far UCP_MULTI_HOST[29]="HOST: 239.255.255.250:1900\r\n";
//char far UCP_MULTI_HOST[29]="HOST:239.255.255.250:1900\r\n";
char far UCP_SERVER[30]="SERVER: Cellvision UPnP/1.0\r\n";
char far UCP_HTTP200[18]="HTTP/1.1 200 OK\r\n";
char far UCP_NOTIFY[20]="NOTIFY * HTTP/1.1\r\n";
char far UCP_SEARCH[22]="M-SEARCH * HTTP/1.1\r\n";
char far UCP_AGENT[53]="Mozilla/4.0 (compatible; UPnP/1.0; Windows NT/5.1)\r\n";

char far UCP_BYEBYE_NONTS[12]="ssdp:byebye";
char far UCP_BYEBYE[19]="NTS: ssdp:byebye\r\n";
char far UCP_ALIVE[18]="NTS: ssdp:alive\r\n";
char far UCP_ALL[11]="ssdp:all\r\n";
char far UCP_DISCOVER[18]="\"ssdp:discover\"\r\n";

char far UCP_OS_VER[11]="Cellvision";
char far UCP_VER[9]="UPnP/1.0";
char far UCP_HTTP_VER[9]="HTTP/1.1";
char far UCP_HTTP_VER_10[9]="HTTP/1.0";
char far UCP_OK[3]="OK";

char far UCP_M_NOTIFY[7]="NOTIFY";
char far UCP_M_GET[4]="GET";
char far UCP_M_POST[5]="POST";

char far UCP_H_SERVER[7]="SERVER";
char far UCP_H_HOST[5]="HOST";
char far UCP_H_SID[4]="SID";
char far UCP_H_SEQ[4]="SEQ";
char far UCP_H_EXT[4]="EXT";
char far UCP_H_CALLBACK[9]="CALLBACK";
char far UCP_H_TIMEOUT[8]="TIMEOUT";
char far UCP_H_NT[3]="NT";
char far UCP_H_NTS[4]="NTS";
char far UCP_H_ST[3]="ST";
char far UCP_H_USN[4]="USN";
char far UCP_H_CACHE[14]="CACHE-CONTROL";
char far UCP_H_LOCATION[9]="LOCATION";
char far UCP_H_CONN[11]="CONNECTION";
char far UCP_H_CONTENT_TYPE[13]="CONTENT-TYPE";
char far UCP_H_CONTENT_LEN[15]="CONTENT-LENGTH";
char far UCP_H_MAN[4]="MAN";
char far UCP_H_MX[3]="MX";
char far UCP_H_ACCEPT[7]="ACCEPT";
char far UCP_H_USER_AGENT[11]="USER-AGENT";
char far UCP_H_SOAPACTION[11]="SOAPACTION";

char far UCP_UPNP[5]="upnp";
char far UCP_EVENT[11]="upnp:event";
char far UCP_PROPCHANGE[16]="upnp:propchange";
char far UCP_ROOT[16]="upnp:rootdevice";
char far UCP_TEXT_XML[9]="text/xml";
char far UCP_APP_XML[16]="application/xml";
char far UCP_CHARSET[8]="charset";
char far UCP_UTF_8[8]="\"utf-8\"";
char far UCP_CLOSE[6]="CLOSE";
char far UCP_KEEP_ALIVE[11]="KEEP-ALIVE";

char far UCP_ASTERISK[2]="*";
char far UCP_SPACE[2]=" ";
char far UCP_DCOLON[3]="::";
char far UCP_SCOLON[2]=":";
char far UCP_SEMICOLON[2]=";";
char far UCP_EQU[2]="=";
char far UCP_ZERO[2]="0";
char far UCP_CRLF[3]="\r\n";
char far UCP_SLASH[2]="/";
char far UCP_LAB[2]="<";
char far UCP_RAB[2]=">";
char far UCP_LPB[2]="(";
char far UCP_RPB[2]=")";
char far UCP_COMMA[2]=",";
char far UCP_HASH[2]="#";
char far UCP_QUOTE_DBL[2]="\"";
char far UCP_DASH[2]="-";

char far UCP_NS_ANY[2]="e";
char far UCP_NS_U[2]="u";
char far UCP_PROPERTY[11]="e:property";
char far UCP_PROPSET[14]="e:propertyset";
char far UCP_NS_EVENT[41]="xmlns:e=\"urn:schemas-upnp-org:event-1-0\"";
char far UCP_NS[6]="xmlns";
char far UCP_1[2]="1";
char far UCP_0[2]="0";

char far UCP_SCHEMAS_CTRL[]="urn:schemas-upnp-org:control-1-0";
char far UCP_SCHEMAS_EVENT[]="urn:schemas-upnp-org:event-1-0";

char far UCP_QUERY[19]="QueryStateVariable";
char far UCP_VARNAME[8]="varName";


char far UCP_SEC[8]="Second-";
char far UCP_MAX_AGE[8]="max-age"; 
char far UCP_UUID[5]="uuid";
char far UCP_XML_URLBASE[8]="URLBase";
char far UCP_XML_DEVICETYPE[11]="deviceType";
char far UCP_XML_RETURN[7]="return";
char far UCP_XML_CTRL_URL[11]="controlURL";
char far UCP_XML_SCPD_URL[8]="SCPDURL";
char far UCP_XML_SERVICE_TYPE[12]="serviceType";

char far UCP_IGD_STATUS_INFO[14]="GetStatusInfo";
char far UCP_IGD_GET_EXTERNAL_IP_ADDRESS[]="GetExternalIPAddress";
char far PORT_MAPPING_NO[27]="PortMappingNumberOfEntries";
char far UCP_IGD_ADD_PORT[15]="AddPortMapping";
char far UCP_IGD_REMOTE_HOST[]="NewRemoteHost";
char far UCP_IGD_E_PORT[]="NewExternalPort";
char far UCP_IGD_PROTOCOL[]="NewProtocol";
char far UCP_IGD_I_PORT[]="NewInternalPort";
char far UCP_IGD_I_CLIENT[]="NewInternalClient";
char far UCP_IGD_ENABLED[]="NewEnabled";
char far UCP_IGD_P_DESC[]="NewPortMappingDescription";
char far UCP_IGD_L_DURA[]="NewLeaseDuration";

char far UCP_IGD_DEL_PORT[18]="DeletePortMapping";

char far UCP_IGD_R_CONN[18]="RequestConnection";
char far UCP_IGD_G_GPORT[27]="GetGenericPortMappingEntry";
char far UCP_IGD_G_SPORT[28]="GetSpecificPortMappingEntry";
char far UCP_IGD_N_PORT_I[20]="NewPortMappingIndex";
char far UCP_IGD_TCP[4]="TCP";
char far UCP_IGD_ERROR[]="errorCode";

static int UCPSyncIP(void)
{
    static unsigned long AddressingIP=0;
    
    UCPGetDeviceInfo();
    if (AddressingIP!=UpnpIP) {
        AddressingIP=UpnpIP;
        //MSearchSocketRefresh(AddressingIP);
        ResetIGDSvcExpireTime(0);
        ResetOpenPortExpireTime(0);
        ResetWanIPExpireTime(0);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_MAIN,
                  "UpnpIP = %#8lX\r\n", UpnpIP);
    }
    return 0;
}

int UCPDelPortForwardingEntry()
{
    if (isUCPSearchSocketExist()) {
        UCPSyncIP();
        UCPGetIGDSvc();
        UCPOpenPort();
    } 
    return TERMINATE;
}

int isUCPCameraNameChanged(void)
{
    char tmp_camera_name[33];
    int static first = 1;
    int changed = FALSE;

    if (1 == first) {
        strcpy(camera_name, nvram_bufget(RT2860_NVRAM, "CameraName"));
        first = 0; 
    }

    memset(tmp_camera_name, 0, sizeof tmp_camera_name);
    strcpy(tmp_camera_name, nvram_bufget(RT2860_NVRAM, "CameraName"));
    nvram_close(RT2860_NVRAM);
    if (!STREQ(camera_name, tmp_camera_name)) {
        strcpy(camera_name, tmp_camera_name);
        changed = TRUE;
    } else {
        changed = FLASE;
    }
    return  changed;
}


int UCP(void)
{   
    if (isUCPSearchSocketExist()) {
        UCPGetDeviceInfo();
        UCPSyncIP();
        igd_accessible = UCPGetIGDSvc();
        if (PASS == igd_accessible)
            open_port_success = UCPOpenPort();
        //UCPRefreshWANIP();
    }
    return CONTINUE;
}

int main(void)
{
    struct sigaction del_igd_port_forwarding;
    int gw_exist;
    int changed = FLASE;
    int i;

    ALInitializeMemAllocMonitor();
    xmlMemInit();
    semaphore_init();
    upnp_read_sysinfo(sizeof(default_gw), (char *)&default_gw, CURRENT_DEFAULT_GATEWAY);
    UCPGetDeviceInfo();
    VerifySecondPort();
    UCPSearchInit();

#if 0
    del_igd_port_forwarding.sa_handler = UCPDeletePortMapping_SIGUSR1;
    sigemptyset(&del_igd_port_forwarding.sa_mask);
    del_igd_port_forwarding.sa_flags = 0;
    sigaction(SIGUSR1, &del_igd_port_forwarding, 0);
#endif
 
    if (0 == port_forwarding_enable) {
        short status;

        error_code = PORT_FORWARDING_IS_SETTING;/* port forwarding is setting*/
        write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);

        xmlMemMonitor(XML_DBG_LEVEL_TRACE_FLOW);
        UCPDelPortForwardingEntry();
        xmlMemMonitor(XML_DBG_LEVEL_TRACE_FLOW);

        if (80 == web_port) {
            error_code = PORT_USED_BY_GW; /*port already used by gw*/
            write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
        } else {
            error_code = PORT_FORWARDING_DISABLE; /*port forwarding disable*/
            write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
        }

        read_sysinfo(sizeof(status), (char *)&status, PORT_FORWARDING_STATUS);
        DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_MAIN,
                "disable, port forwarding status = %d\r\n", status);
    } else {
        while(1) {
            short int status;
            int count = 6;
            changed = FALSE;

            sleep_time = UCP_SLEEP_SHORT;
            error_code = PORT_FORWARDING_IS_SETTING;/* port forwarding is setting*/
            write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
#if 0
            gw_exist = isDefaultGWexist();
            if (1 == gw_exist) {
                xmlMemMonitor(XML_DBG_LEVEL_TRACE_FLOW);
                UCP();
                xmlMemMonitor(XML_DBG_LEVEL_TRACE_FLOW);

                read_sysinfo(sizeof(status), (char *)&status, PORT_FORWARDING_STATUS);
                DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_MAIN,
                        "enable, port forwarding status = %d\r\n", status);
            } else {
                error_code = DEFAULT_GW_NOT_EXIST; /*defult gw not exist*/
                write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
                sleep_time = UCP_SLEEP_SHORT;
            }
#else
            xmlMemMonitor(XML_DBG_LEVEL_TRACE_FLOW);
            UCP();
            xmlMemMonitor(XML_DBG_LEVEL_TRACE_FLOW);

            read_sysinfo(sizeof(status), (char *)&status, PORT_FORWARDING_STATUS);
            DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_MAIN,
                    "enable, port forwarding status = %d\r\n", status);
#endif
            DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_MAIN,
                    "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@sleep_time = %d\r\n", sleep_time);
            if (FAIL == igd_accessible || FAIL == open_port_success)
                count = 1;
            else 
                count = 6;

            for (i = 0; i < count && FALSE == changed; i++) {
                if (TRUE == isUCPCameraNameChanged()) { 
                    changed = TRUE;
                    break;
                } else {
                    changed = FALSE;
                }
                sleep(sleep_time);
            }
        }
    }
    UCPSearchClose();
    return CONTINUE;
}
/* vim:set sw=4 sts=4 sta si expandtab: */
