#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <errno.h>
#include "upnp_types.h"
#include "http_pas.h"
#include "xml_dump.h"
#include "xml_pars.h"
#include "xml_mem.h"
#include "fmt_cvt.h"
//#include "sendrecv.h"
#include "ucpbas.h"
#include "ucpmain.h"
#include "ucpopenp.h"
#include "ucpcon.h"
#include "ucputl.h"
#include "dbgtrace.h"
#include "ralink_gpio.h"

extern int check_conn(int fd);
extern unsigned long UpnpIP;
extern unsigned long default_gw;
extern unsigned int sleep_time;

#define UCP_DISCONNECT      0
#define UCP_WAIT_CONNECT    1
#define UCP_CONNECTED       2
#define UCP_WAIT_RECV_RESP  3
#define UCP_COMPLETE        4   
#define UCP_IDLE            5   
#define UCP_BROKEN          6   
#define UCP_REMOTE_CLOSE    7   

#define UCPTCPPortBase  64000L   
#define UCPTCPPortEnd   64999L   
#define UCP_CON_TIMEOUT     6 


#define UCP_TCP_TIMEOUT     3

typedef void (*ucp_timeout_t)(int *fd);
static unsigned int UCPTCPPort = (unsigned int)UCPTCPPortBase;
static int ucp_tcp_sock_fd = -1;

static int UCP_Connect_State = UCP_DISCONNECT;
static char UCPTCPReadBuf[UCP_READ_BUF];
static char far UCPRecvBuf[UCP_RECV_BUF_SIZE];
static char far UCPSendBuf[UCP_SEND_BUF_SIZE];
//sem_t       UCPsemaphore;
static char far trash[1024];

char far UCP_XML_DECL[22] = "<?xml version=\"1.0\"?>";
char far UCP_XML_ENCODING[9] = "encoding";
char far UCP_SOAP_S[133] = 
                "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\""
                " s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">"
                "<s:Body>";
char far UCP_SOAP_E[23] = "</s:Body>"
            "</s:Envelope>";

char far Request_Conn[298]=
"<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n"
"<s:Envelope s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\">\r\n"
"   <s:Body>\r\n"
"      <u:RequestConnection xmlns:u=\"urn:schemas-upnp-org:service:WANPPPConnection:1\" />\r\n"
"   </s:Body>\r\n"
"</s:Envelope>\r\n";

static CODE_DESC ConnDesc[] = {
    {UCP_DISCONNECT, "DISCONNECT"},
    {UCP_WAIT_CONNECT, "WAIT_CONNECT"},
    {UCP_CONNECTED, "CONNECTED"},
    {UCP_WAIT_RECV_RESP, "WAIT_RECV_RESP"},
    {UCP_COMPLETE, "COMPLETE"},
    {UCP_IDLE, "IDLE"},
    {UCP_BROKEN, "BROKEN"},
    {UCP_REMOTE_CLOSE, "REMOTE_CLOSE"}
};

int UCPParseRecvBuf(http_message *msg)
{
    int status;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPParseRecvBuf");
    memset(msg, 0, sizeof(*msg));
    if (FAIL == parse_http_response(UCPRecvBuf, msg, strlen(UCPRecvBuf))) { 
        status = FAIL;
    } else {
        status = PASS;
    }
    return status;
}

int AddActionHeader(char *XmlBuf, SERVICE_URL *SvcURL, char *action)
{
    int len = strlen(XmlBuf);
    char tmp[10];
    CALLBACK_ADDR *Callback = &SvcURL->Callback;

    //NWitoa(len, tmp, 10); 
    sprintf((char *)tmp, "%d", len);

    memset(UCPSendBuf, 0, 1024);
    strcat(UCPSendBuf, UCP_M_POST);
    strcat(UCPSendBuf, UCP_SPACE);
    //strcat(UCPSendBuf, UCP_SLASH);
    strcat(UCPSendBuf, Callback->Path);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_HTTP_VER);
    strcat(UCPSendBuf, UCP_CRLF);
    strcat(UCPSendBuf, UCP_H_HOST);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, Callback->IP);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, Callback->Port);
    strcat(UCPSendBuf, UCP_CRLF);


    strcat(UCPSendBuf, UCP_H_CONTENT_TYPE);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_TEXT_XML);
#if 1 
    strcat(UCPSendBuf, UCP_SEMICOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_CHARSET);
    strcat(UCPSendBuf, UCP_EQU);
    strcat(UCPSendBuf, UCP_UTF_8);
#endif
    strcat(UCPSendBuf, UCP_CRLF);

    strcat(UCPSendBuf, UCP_H_CONTENT_LEN); 
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, (char *)tmp);
    strcat(UCPSendBuf, UCP_CRLF);

#if 0
    strcat(UCPSendBuf, UCP_H_USER_AGENT);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, AGENT);
#endif
    strcat(UCPSendBuf, UCP_H_CONN);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    //strcat(UCPSendBuf, UCP_KEEP_ALIVE);
    strcat(UCPSendBuf, UCP_CLOSE);
    strcat(UCPSendBuf, UCP_CRLF);

    strcat(UCPSendBuf, UCP_H_SOAPACTION);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_QUOTE_DBL);
    strcat(UCPSendBuf,SvcURL->serviceType);
    strcat(UCPSendBuf, UCP_HASH);
    strcat(UCPSendBuf, action);
    strcat(UCPSendBuf, UCP_QUOTE_DBL);
    strcat(UCPSendBuf, UCP_CRLF);


    strcat(UCPSendBuf, UCP_CRLF);
    strcat(UCPSendBuf, XmlBuf);
    return PASS;
}

int AddQueryHeader(char *XmlBuf, CALLBACK_ADDR *Callback)
{
    int len = strlen(XmlBuf);
    char tmp[10];

    //NWitoa(len, tmp, 10); 
    sprintf(tmp, "%d", len);

    memset(UCPSendBuf, 0, 1024);
    strcat(UCPSendBuf, UCP_M_POST);
    strcat(UCPSendBuf, UCP_SPACE);
    //strcat(UCPSendBuf, UCP_SLASH);
    strcat(UCPSendBuf, Callback->Path);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_HTTP_VER);
    strcat(UCPSendBuf, UCP_CRLF);
    strcat(UCPSendBuf, UCP_H_HOST);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, Callback->IP);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, Callback->Port);
    strcat(UCPSendBuf, UCP_CRLF);

    strcat(UCPSendBuf, UCP_H_CONTENT_TYPE);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_TEXT_XML);
#if 0
    strcat(UCPSendBuf, UCP_SEMICOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_CHARSET);
    strcat(UCPSendBuf, UCP_EQU);
    strcat(UCPSendBuf, UCP_UTF_8);
#endif
    strcat(UCPSendBuf, UCP_CRLF);

    strcat(UCPSendBuf, UCP_H_CONTENT_LEN); 
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, (char *)tmp);
    strcat(UCPSendBuf, UCP_CRLF);

#if 0
    strcat(UCPSendBuf, UCP_H_USER_AGENT);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, AGENT);
#endif
    strcat(UCPSendBuf, UCP_H_CONN);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    //strcat(UCPSendBuf, UCP_KEEP_ALIVE);
    strcat(UCPSendBuf, UCP_CLOSE);
    strcat(UCPSendBuf, UCP_CRLF);

    strcat(UCPSendBuf, UCP_H_SOAPACTION);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_QUOTE_DBL);
    strcat(UCPSendBuf, UCP_SCHEMAS_CTRL);
    strcat(UCPSendBuf, UCP_HASH);
    strcat(UCPSendBuf, UCP_QUERY);
    strcat(UCPSendBuf, UCP_QUOTE_DBL);
    strcat(UCPSendBuf, UCP_CRLF);

    strcat(UCPSendBuf, UCP_CRLF);
    strcat(UCPSendBuf, XmlBuf);

    return PASS;
}

int UCPCreateGetStatusInfoMessage(SERVICE_URL *SvcURL, void *para)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPCreateGetStatusInfoMessage");
    /*Body*/
    memset(trash, 0, 1024);

    //strcpy(trash, UCP_XML_DECL);
    strcat(trash, UCP_SOAP_S);
    /*GetStatusInfo*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_STATUS_INFO);
    strcat(trash, UCP_SPACE);
    strcat(trash, UCP_NS);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_EQU);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, SvcURL->serviceType);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_RAB);
    /*GetStatusInfo*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_STATUS_INFO);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_SOAP_E);
    /**/
    strcat(trash, UCP_CRLF);

    /* Header */
    AddActionHeader(trash, SvcURL, UCP_IGD_STATUS_INFO);

    return PASS;
}

int UCPCreateDeletePortMappingMessage(SERVICE_URL *SvcURL, void *para)
{
    PPORT_MAP PortMap = (PPORT_MAP)para;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPCreateDeletePortMappingMessage");
    /*Body*/
    memset(trash, 0, 1024);

    //strcpy(trash, UCP_XML_DECL);
    strcat(trash, UCP_SOAP_S);
    /*DeletePortMapping*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_DEL_PORT);
    strcat(trash, UCP_SPACE);
    strcat(trash, UCP_NS);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_EQU);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, SvcURL->serviceType);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_RAB);

    /*RemoteHost*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_REMOTE_HOST);
    strcat(trash, UCP_RAB);
    //strcat(trash, UCP_SPACE);
    strcat(trash, PortMap->RemoteHost);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_REMOTE_HOST);
    strcat(trash, UCP_RAB);
    /*ExternalPort*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_E_PORT);
    strcat(trash, UCP_RAB);
    strcat(trash, PortMap->ExternalPort);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_E_PORT);
    strcat(trash, UCP_RAB);
    /*Protocol*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_PROTOCOL);
    strcat(trash, UCP_RAB);
    strcat(trash, UCP_IGD_TCP);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_PROTOCOL);
    strcat(trash, UCP_RAB);

    /*DeletePortMapping*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_DEL_PORT);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_SOAP_E);
    /**/
    strcat(trash, UCP_CRLF);

    /* Header */
    AddActionHeader(trash, SvcURL, UCP_IGD_DEL_PORT);
    return PASS;
}

int UCPCreateAddPortMappingMessage(SERVICE_URL *SvcURL, void *para)
{
    char EncodedValue[256];

    PORT_MAP *entry = (PORT_MAP *)para;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPCreateAddPortMappingMessage");
    /*Body*/
    memset(trash, 0, 1024);

    //strcpy(trash, UCP_XML_DECL);
    strcat(trash, UCP_SOAP_S);
    /*AddPortMapping*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_ADD_PORT);
    strcat(trash, UCP_SPACE);
    strcat(trash, UCP_NS);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_EQU);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, SvcURL->serviceType);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_RAB);

    /*RemoteHost*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_REMOTE_HOST);
    strcat(trash, UCP_RAB);
    //strcat(trash, UCP_SPACE);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_REMOTE_HOST);
    strcat(trash, UCP_RAB);
    /*ExternalPort*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_E_PORT);
    strcat(trash, UCP_RAB);
    strcat(trash, entry->ExternalPort);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_E_PORT);
    strcat(trash, UCP_RAB);
    /*Protocol*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_PROTOCOL);
    strcat(trash, UCP_RAB);
    strcat(trash, UCP_IGD_TCP);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_PROTOCOL);
    strcat(trash, UCP_RAB);
    /*InternalPort*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_I_PORT);
    strcat(trash, UCP_RAB);
    strcat(trash, entry->InternalPort);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_I_PORT);
    strcat(trash, UCP_RAB);
    /*InternalClient*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_I_CLIENT);
    strcat(trash, UCP_RAB);
    strcat(trash, entry->InternalClient);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_I_CLIENT);
    strcat(trash, UCP_RAB);
    /*Enabled*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_ENABLED);
    strcat(trash, UCP_RAB);
    strcat(trash, UCP_1);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_ENABLED);
    strcat(trash, UCP_RAB);
    /*PortMappingDescription*/
    memset(EncodedValue, 0, sizeof(EncodedValue));
    UNITxmlEncodeEntities_R(entry->PortMappingDescription, EncodedValue, sizeof(EncodedValue)); 
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_P_DESC);
    strcat(trash, UCP_RAB);
    //strcat(trash, entry->PortMappingDescription);
    strcat(trash, EncodedValue);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_P_DESC);
    strcat(trash, UCP_RAB);
    /*LeaseDuration*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_L_DURA);
    strcat(trash, UCP_RAB);
    strcat(trash, UCP_0);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_L_DURA);
    strcat(trash, UCP_RAB);
    /*AddPortMapping*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_ADD_PORT);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_SOAP_E);
    /**/
    strcat(trash, UCP_CRLF);

    /* Header */
    AddActionHeader(trash, SvcURL, UCP_IGD_ADD_PORT);

    return PASS;
}

int UCPCreateGetSpecificPortMessage(SERVICE_URL *SvcURL, void *para)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPCreateGetSpecificPortMessage");
    /*Body*/
    memset(trash, 0, 1024);

    //strcpy(trash, UCP_XML_DECL);
    strcat(trash, UCP_SOAP_S);
    /**/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_G_SPORT);
    strcat(trash, UCP_SPACE);
    strcat(trash, UCP_NS);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_EQU);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, SvcURL->serviceType);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_RAB);
    /*RemoteHost*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_REMOTE_HOST);
    strcat(trash, UCP_RAB);
    //strcat(trash, UCP_SPACE);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_REMOTE_HOST);
    strcat(trash, UCP_RAB);
    /*ExternalPort*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_E_PORT);
    strcat(trash, UCP_RAB);
    strcat(trash, (char *)para);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_E_PORT);
    strcat(trash, UCP_RAB);
    /*Protocol*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_IGD_PROTOCOL);
    strcat(trash, UCP_RAB);
    strcat(trash, UCP_IGD_TCP);
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_IGD_PROTOCOL);
    strcat(trash, UCP_RAB);


    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_G_SPORT);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_SOAP_E);
    /**/
    strcat(trash, UCP_CRLF);

    /* Header */
    AddActionHeader(trash, SvcURL, UCP_IGD_G_SPORT);

    return PASS;
}

int UCPCreateGetGenericPortMessage(SERVICE_URL *SvcURL, void *para)
{
    char tmp[8];

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPCreateGetGenericPortMessage");
    /*Body*/
    memset(trash, 0, 1024);

    //strcpy(trash, UCP_XML_DECL);
    strcat(trash, UCP_SOAP_S);
    /**/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_G_GPORT);
    strcat(trash, UCP_SPACE);
    strcat(trash, UCP_NS);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_EQU);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, SvcURL->serviceType);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_LAB);
    //strcat(trash, UCP_NS_U);
    //strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_N_PORT_I);
    strcat(trash, UCP_RAB);

    //NWitoa(*(int *)para, tmp, 10);
    sprintf(tmp, "%d", *(int *)para);
    strcat(trash, (char *)tmp);

    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    //strcat(trash, UCP_NS_U);
    //strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_N_PORT_I);
    strcat(trash, UCP_RAB);


    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_G_GPORT);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_SOAP_E);
    /**/
    strcat(trash, UCP_CRLF);

    /* Header */
    AddActionHeader(trash, SvcURL, UCP_IGD_G_GPORT);

    return PASS;
}

int UCPCreateRequestConnectionMessage(SERVICE_URL *SvcURL, void *para)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPCreateRequestConnectionMessage");
    /*Body*/
    memset(trash, 0, 1024);
#if 0
    //strcpy(trash, UCP_XML_DECL);
    strcat(trash, UCP_SOAP_S);
    /**/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_R_CONN);
    strcat(trash, UCP_SPACE);
    strcat(trash, UCP_NS);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_EQU);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_PPP_CONN);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_R_CONN);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_SOAP_E);
    /**/
    strcat(trash, UCP_CRLF);
#endif
    strcat(trash, Request_Conn);

    /* Header */
    AddActionHeader(trash, SvcURL, UCP_IGD_R_CONN);

    return PASS;
}

int UCPCreateQueryPortMappingNoMessage(SERVICE_URL *SvcURL, void *para)
{
    CALLBACK_ADDR *Callback = &SvcURL->Callback;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPCreateQueryPortMappingNoMessage");
    /*Body*/
    memset(trash, 0, 1024);

    //strcpy(trash, UCP_XML_DECL);
    strcat(trash, UCP_SOAP_S);
    /**/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_QUERY);
    strcat(trash, UCP_SPACE);
    strcat(trash, UCP_NS);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_EQU);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_SCHEMAS_CTRL);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_LAB);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_VARNAME);
    strcat(trash, UCP_RAB);

    strcat(trash, PORT_MAPPING_NO);

    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_VARNAME);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_QUERY);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_SOAP_E);

    /* Header */
    AddQueryHeader(trash, Callback);

    return PASS;
}

int UCPCreateGetMessage(SERVICE_URL *SvcURL, void *para)
{
    CALLBACK_ADDR *Callback = &SvcURL->Callback;

    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPCreateGetMessage");
    memset(UCPSendBuf, 0, sizeof(UCPSendBuf));
    strcat(UCPSendBuf, UCP_M_GET);
    strcat(UCPSendBuf, UCP_SPACE);
    //strcat(UCPSendBuf, UCP_SLASH);
    strcat(UCPSendBuf, Callback->Path);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_HTTP_VER);
    strcat(UCPSendBuf, UCP_CRLF);
    strcat(UCPSendBuf, UCP_H_HOST);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, Callback->IP);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, Callback->Port);
    strcat(UCPSendBuf, UCP_CRLF);

    strcat(UCPSendBuf, UCP_H_ACCEPT);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_TEXT_XML);
    strcat(UCPSendBuf, UCP_COMMA);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_APP_XML);
    strcat(UCPSendBuf, UCP_CRLF);
    strcat(UCPSendBuf, UCP_H_USER_AGENT);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_AGENT);

    strcat(UCPSendBuf, UCP_H_CONN);
    strcat(UCPSendBuf, UCP_SCOLON);
    strcat(UCPSendBuf, UCP_SPACE);
    strcat(UCPSendBuf, UCP_CLOSE);
    //strcat(UCPSendBuf, UCP_KEEP_ALIVE);
    strcat(UCPSendBuf, UCP_CRLF);
    strcat(UCPSendBuf, UCP_CRLF);
    return 0;
}

int connect_timeout (int sock, struct sockaddr *addr, int size_addr, int timeout)
{
    int error = 0;
    int	flags;
    fd_set	rset, wset;
    int 	n;
    struct timeval tval;

    flags = fcntl (sock, F_GETFL, 0);
    fcntl (sock, F_SETFL, flags | O_NONBLOCK);		// set the socket as nonblocking IO

    if ((n = connect (sock, addr, size_addr)) < 0) {		// we connect, but it will return soon
        if (errno == EINPROGRESS) {
            FD_ZERO (&rset);
            FD_ZERO (&wset);
            FD_SET (sock, &rset);
            FD_SET (sock, &wset);
            tval.tv_sec = timeout;
            tval.tv_usec = 0;

            /* We "select()" until connect() returns its result or timeout
            */
            if ( (n = select(sock+1, &rset, &wset, NULL, timeout ? &tval : NULL)) == 0) {	
                close (sock);
                DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                        "connect_timeout(), Connect Timeout\n");
                error = ETIMEDOUT;
                return -1;
            }
            if (FD_ISSET(sock, &rset) || FD_ISSET(sock, &wset)) {
                int len = sizeof(error);
                if (getsockopt (sock, SOL_SOCKET, SO_ERROR, &error, &len) < 0) {
                    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                            "connect_timeout(), getsockopt fail\n");
                    perror ("getsockopt");
                    return -1;
                }
            } else {
                DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                        "connect_timeout(), Unknow error\n");
                return -1;
            }
        }
    }
    /* We change the socket options back to blocking IO */
    fcntl (sock, F_SETFL, flags);
    if (error) {

        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                "connect_timeout(), Connect fail\n");
        close (sock);
        return -1;
    }

    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
            "connect_timeout(), Connect success\n");
    return 0;
}

int UCPMakeConnect(CALLBACK_ADDR *Callback)
{
    unsigned long  UCPCallbackIP = 0;
    unsigned long  UCPCallbackPort = 0;
    struct  sockaddr_in  UCPRemoteaddr;
    int sockaddrlen = 16;
    int ret;
    int status = PASS;


    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "IP = %s, PORT = %s\r\n", Callback->IP, Callback->Port);
    UCPCallbackIP=addr_ipatol(Callback->IP, 1); 
    if (UCPCallbackIP == 0) {
        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "IP ERR\r\n");
        status = FAIL;
        goto Exit;
    }
    //UCPCallbackIP=inet_addr(Callback->IP);
    UCPCallbackPort = (unsigned long)atol(Callback->Port);
    if ((UCPCallbackPort<=0) || UCPCallbackPort>65535L) {
        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "PORT ERR\r\n");
        status = FAIL;
        goto Exit;
    }

    //DEBUG_trace(DBG_LEVEL_TRACE_INFO, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
	//             "IP = %d, PORT = %d\r\n", UCPCallbackIP, UCPCallbackPort);
    UCPRemoteaddr.sin_family = AF_INET;
    //UCPRemoteaddr.sin_addr.s_addr = inet_addr("192.168.98.1");
    UCPRemoteaddr.sin_addr.s_addr = UCPCallbackIP;
    UCPRemoteaddr.sin_port = htons(UCPCallbackPort);

    //ret = connect(ucp_tcp_sock_fd,(struct sockaddr *)&UCPRemoteaddr, sockaddrlen);
    ret = connect_timeout(ucp_tcp_sock_fd,(struct sockaddr *)&UCPRemoteaddr, sockaddrlen, UCP_TCP_TIMEOUT);
    //sched_yield();
    //POSEThreadYield();
    //usleep(3);
#if 0
    ret = check_conn(ucp_tcp_sock_fd);
#endif
    if (ret != 0) {
        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "CONN FAIL\r\n");
	//perror("");
        status = FAIL;
    }
Exit:
    return status;
}

int UCPMakeEndPoint(void)
{
    //struct  sockaddr_in  UCPTCPAddr;
    //int sockaddrlen = 16;
    //int ret;
    int status = PASS;
    //int flags;

    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "Local PORT = %u\r\n", UCPTCPPort);
#if 0 
    UCPTCPAddr.sin_family = AF_INET;
    UCPTCPAddr.sin_addr.s_addr = (UpnpIP);
    //UCPTCPAddr.sin_port = ntohs(UCPTCPPort);
    UCPTCPAddr.sin_addr.s_addr = htonl(INADDR_ANY);
    UCPTCPAddr.sin_port = htons(UCPTCPPort);
#endif

    ucp_tcp_sock_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (ucp_tcp_sock_fd<=0)
    {
        status = FAIL;
        goto Exit;
    }

#if 0
    flags = fcntl(ucp_tcp_sock_fd, F_GETFL, 0);
    fcntl(ucp_tcp_sock_fd, F_SETFL, O_NONBLOCK|flags);
#endif
#if 0 
    ret = bind(ucp_tcp_sock_fd, (struct sockaddr *)&UCPTCPAddr, sockaddrlen);
    if (ret !=0)
    {
        if (ucp_tcp_sock_fd >= 0)
            close(ucp_tcp_sock_fd);
        status = FAIL;
        goto Exit;
    }
#endif

Exit:
    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "ucp_tcp_sock_fd = %u, status = %d\r\n", ucp_tcp_sock_fd, status);
    return status;
}


int isDefaultGWexist(void)
{
    int i, ret;
    nuint32 timeout;
    nuint32 timenow;
    time_t t;
    int status;
    int test_socket;
    struct  sockaddr_in  gw_addr;

    //timeout= POSEClockGetTick() + UCP_CON_TIMEOUT * TICKS_PER_SECOND;
    //timeout= time(&t) + UCP_CON_TIMEOUT * 1000;
    timenow = time(&t);
    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
            "isDefaultGWexist timenow = %d\r\n", timenow); 
    timeout = timenow + UCP_CON_TIMEOUT;
    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
            "isDefaultGWexist timeout = %d\r\n", timeout); 

    for (i = 0; i < 100; i++) {
        test_socket = socket(AF_INET, SOCK_STREAM, 0);
        if (test_socket > 0) {
            break;
        }
    }
    if (test_socket <= 0) {
        status = TRUE;
        goto Exit;
    }

#if 0
    flags = fcntl(test_socket, F_GETFL, 0);
    fcntl(test_socket, F_SETFL, O_NONBLOCK|flags);
#endif
    gw_addr.sin_family = AF_INET;
    //gw_addr.sin_addr.s_addr = inet_addr("192.168.98.1");
    gw_addr.sin_addr.s_addr = default_gw;
    gw_addr.sin_port = htons(80);

    //ret = connect(test_socket,(struct sockaddr *)&gw_addr, sockaddrlen);
    ret = connect_timeout(test_socket,(struct sockaddr *)&gw_addr, sizeof gw_addr, UCP_TCP_TIMEOUT);
    if (ret != 0) {
        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "isDefaultGWexist CONN FAIL\r\n");
	//perror("");
        status = FALSE;
    } else {
        shutdown(test_socket, SHUT_RDWR);
        close(test_socket);
        status = TRUE;
    }

Exit:
    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_SRCH,
                  "isDefaultGWexis test_socket = %u, status = %d\r\n", test_socket, status);
    return status;
}




int UCPGenericConnection(SERVICE_URL *SvcURL, ucp_create_m_t CreateMessage, void *para)
{
    int len;
    nuint32 timeout;
    nuint32 timenow;
    time_t t;
    int sret;
    fd_set readfds;
    struct timeval timeToWait;
    int status = FAIL;

    //timeout= POSEClockGetTick() + UCP_CON_TIMEOUT * TICKS_PER_SECOND;
    //timeout= time(&t) + UCP_CON_TIMEOUT * 1000;
    timenow = time(&t);
    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
            "UCPGenericConnection timenow = %d\r\n", timenow); 
    timeout = timenow + UCP_CON_TIMEOUT;

    DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
            "UCPGenericConnection timeout = %d\r\n", timeout); 
    UCP_Connect_State = UCP_DISCONNECT;
    memset(UCPRecvBuf, 0, sizeof(UCPRecvBuf));
    for (; UCP_Connect_State != UCP_IDLE;) {
        if (timeout < time(&t)) {
            DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "UCPGenericConnection Timeout desc = %s\r\n", 
                  GetCodeDesc(ConnDesc, NELEMS(ConnDesc), UCP_Connect_State));

            DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                    "UCPGenericConnection exit for loop time = %d\r\n", time(&t)); 
            UCP_Connect_State = UCP_BROKEN;
        }
        switch (UCP_Connect_State) {
        case UCP_DISCONNECT:
            if(PASS == UCPMakeEndPoint()) {
                UCP_Connect_State = UCP_WAIT_CONNECT;
            }            break;
        case UCP_WAIT_CONNECT:
            if (PASS == UCPMakeConnect(&SvcURL->Callback))
                UCP_Connect_State = UCP_CONNECTED;
            else 
                UCP_Connect_State = UCP_DISCONNECT; /*Ref. Unix Network Programming $4.3 connect*/
            break;
        case UCP_CONNECTED:
            CreateMessage(SvcURL, para);
            UCPSend(ucp_tcp_sock_fd, UCPSendBuf);
            //SendData(ucp_tcp_sock_fd, UCPSendBuf);
            UCP_Connect_State = UCP_WAIT_RECV_RESP;
            break;
        case UCP_WAIT_RECV_RESP:
            timeToWait.tv_sec = 3;
            timeToWait.tv_usec = 0;
            FD_ZERO(&readfds);
            FD_SET(ucp_tcp_sock_fd, &readfds);
            memset(UCPTCPReadBuf, 0, sizeof(UCPTCPReadBuf));
            sret = select(ucp_tcp_sock_fd + 1, &readfds, (fd_set *)0, (fd_set *)0, (struct timeval *)&timeToWait );
            DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                    "UCPGenericConnection sret = %d\r\n", sret);
            if (-1 == sret) {
                perror("UCPGenericConnection select");
                UCP_Connect_State = UCP_BROKEN;
            } else {
                if (FD_ISSET(ucp_tcp_sock_fd, &readfds)) {
                    len = recv(ucp_tcp_sock_fd, UCPTCPReadBuf, sizeof(UCPTCPReadBuf)-3, 0); 
                    if (len > 0) {
                        if (strlen(UCPRecvBuf) + len < sizeof(UCPRecvBuf))
                            strcat(UCPRecvBuf, UCPTCPReadBuf); 
                        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                                "UCPGenericConnection len = %d\r\n", len);
                    } else if (len == 0) {
                        UCP_Connect_State = UCP_COMPLETE;
                        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                                "UCPGenericConnection len = %d\r\n", len);
#if 0
                    }else if (len == -5) {
                        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                                "len = %d\r\n", len);
#endif
                    } else {
                        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                                "UCPGenericConnection len = %d, %s\r\n", len, "recv socket error");
                        DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                                "UCPGenericConnection Total Recv= %d\r\n", strlen(UCPRecvBuf));
                        UCP_Connect_State = UCP_BROKEN;
                    }
                } else {
                    UCP_Connect_State = UCP_COMPLETE;
                }
            }
            break;
        case UCP_BROKEN:
            status = FAIL;

            error_code = PORT_FORWARDING_SOCKET_ERROR; /*port frowarding socket error*/
            write_sysinfo_short(error_code, PORT_FORWARDING_STATUS);
            UCP_Connect_State = UCP_IDLE;
            break;
        case UCP_COMPLETE:
        default:
            if (ucp_tcp_sock_fd >= 0) {
                close(ucp_tcp_sock_fd);
                DEBUG_trace(DBG_LEVEL_TRACE_FLOW, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                        "UCPGenericConnection close\r\n");
            }
            if (++UCPTCPPort > UCPTCPPortEnd )
                UCPTCPPort = (unsigned int)UCPTCPPortBase;
            status = PASS;
            UCP_Connect_State = UCP_IDLE;
        }
    } /*for loop*/
    return status;
}

int UCPCreateGetExternalIPAddressMessage(SERVICE_URL *SvcURL, void *para)
{
    DEBUG_trace(DBG_LEVEL_TRACE_ENTRY, PROJ_DBG_MASK_UCP, UCP_DBG_MASK_CON,
                  "%s\r\n", "UCPCreateGetExternalIPAddressMessage");
    /*Body*/
    memset(trash, 0, 1024);

    //strcpy(trash, UCP_XML_DECL);
    strcat(trash, UCP_SOAP_S);
    /*GetExternalIPAddress*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_GET_EXTERNAL_IP_ADDRESS);
    strcat(trash, UCP_SPACE);
    strcat(trash, UCP_NS);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_EQU);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, SvcURL->serviceType);
    strcat(trash, UCP_QUOTE_DBL);
    strcat(trash, UCP_RAB);
    /*GetExternalIPAddress*/
    strcat(trash, UCP_LAB);
    strcat(trash, UCP_SLASH);
    strcat(trash, UCP_NS_U);
    strcat(trash, UCP_SCOLON);
    strcat(trash, UCP_IGD_GET_EXTERNAL_IP_ADDRESS);
    strcat(trash, UCP_RAB);

    strcat(trash, UCP_SOAP_E);
    /**/
    strcat(trash, UCP_CRLF);

    /* Header */
    AddActionHeader(trash, SvcURL, UCP_IGD_GET_EXTERNAL_IP_ADDRESS);
    return PASS;
}

#if 0
int UCPSemaphoreInit(void)
{
    int status;

    if (POSEUnnamedSemaphoreInitialize( &UCPsemaphore, 1, 1 )) {
        status = FAIL;
    }
    return status;
}

int UCPSemaphoreDestroy(void)
{
    int status = PASS;

    POSEUnnamedSemaphoreDestroy(&UCPsemaphore);
    return status;
}
#endif
/* vim:set sw=4 sts=4 sta si expandtab: */
