/*
 * See Copyright for the status of this software.
 *
 * Daniel.Veillard@w3.org
 */

#if 0
#include "nplat.h"
#include "nest.h"
#include "poseapi.h"
#include "system.h"
#include "nppkt.h"
#include "nptapi.h"
#include "syslib.h"
#include "string.h"
#include "timer.h"
#include "err.h"
#include "netcfg.h"
#include "socket.h"
#include "in.h"
#include "syscfg.h"
#endif

//#include "upnp.h"
//#include "upnp_utl.h"
//#include "upnp_wra.h"

#include <stdlib.h>
#include <string.h>
#include "xml_dump.h"
#include "xml_tree.h"
#include "xml_enti.h"
#include "xml_vali.h"
#include "xml_mem.h"
#include "xml_dbg.h"

#define TRUE	1
#define FALSE	0

extern int SerialDisplayBuf(char *pBuf, int Len);

#define IS_CHAR(c)							\
    ( ((c) == 0x09) || ((c) == 0x0a) || ((c) == 0x0d) ||		\
      ((c) >= 0x20) )

/************************************************************************
 *									*
 *		Commodity functions to handle CHARs			*
 *									*
 ************************************************************************/

/**
 * xmlStrndup:
 * @cur:  the input CHAR *
 * @len:  the len of @cur
 *
 * a strndup for array of CHAR's
 *
 * Returns a new CHAR * or NULL
 */
CHAR *
xmlStrndup(const CHAR *cur, unsigned long len) 
//xmlStrndup(const CHAR *cur, int len) 
{
#if 1 /*OXYGEN*/
    CHAR *ret;
    if (len<0) {
        //SerialDisplayBuf(XML_CRLF, 2);
        //SerialDisplayBuf("==========xmlStrndup==========", 30);
        //SerialDisplayBuf(XML_CRLF, 2);
        printf("\n==========xmlStrndup==========\n");
        return NULL;
    }
    ret = xmlMemAlloc((len + 1) * sizeof(CHAR));
#else
    CHAR *ret = xmlMemAlloc((len + 1) * sizeof(CHAR));
#endif

    if (ret == NULL) {
#if 0 /*OXYGEN*/
        fprintf(stderr, "xmlMemAlloc of %d byte failed\n",
	        (len + 1) * sizeof(CHAR));
#endif
#if 1 /*OXYGEN*/
        //SerialDisplayBuf(XML_CRLF, 2);
        //SerialDisplayBuf("xmlStrndup AM fail", 18); 
        //SerialDisplayBuf(XML_CRLF, 2);
        printf("\nxmlStrndup AM fail\n"); 
#endif
        return(NULL);
    }
    memcpy(ret, cur, (int)len * sizeof(CHAR));
    ret[(int)len] = 0;
    return(ret);
}

/**
 * xmlStrdup:
 * @cur:  the input CHAR *
 *
 * a strdup for array of CHAR's
 *
 * Returns a new CHAR * or NULL
 */
CHAR *
xmlStrdup(const CHAR *cur) 
{
#if 1 /*OXYGEN*/
    const CHAR *p = cur;
    if (cur==NULL) {
        //SerialDisplayBuf(XML_CRLF, 2);
        //SerialDisplayBuf("==========xmlStrdup==========", 29);
        //SerialDisplayBuf(XML_CRLF, 2);
        printf("\n==========xmlStrdup==========\n");
        return NULL;
    }
    p=cur;
#else
    const CHAR *p = cur;
#endif
    while (IS_CHAR(*p)) p++;
    return(xmlStrndup(cur, p - cur));
}

/**
 * xmlCharStrndup:
 * @cur:  the input char *
 * @len:  the len of @cur
 *
 * a strndup for char's to CHAR's
 *
 * Returns a new CHAR * or NULL
 */

CHAR *
xmlCharStrndup(const char *cur, unsigned long len) 
//xmlCharStrndup(const char *cur, int len) 
{
    int i;
    CHAR *ret = xmlMemAlloc((len + 1) * sizeof(CHAR));

    if (ret == NULL) {

#if 0 /*OXYGEN*/
        fprintf(stderr, "xmlMemAlloc of %d byte failed\n",
	        (len + 1) * sizeof(CHAR));
#endif
        return(NULL);
    }
    for (i = 0;i < len;i++)
        ret[i] = (CHAR) cur[i];
    ret[(int)len] = 0;
    return(ret);
}

/**
 * xmlCharStrdup:
 * @cur:  the input char *
 * @len:  the len of @cur
 *
 * a strdup for char's to CHAR's
 *
 * Returns a new CHAR * or NULL
 */

CHAR *
xmlCharStrdup(const char *cur) 
{
    const char *p = cur;

    while (*p != '\0') p++;
    return(xmlCharStrndup(cur, p - cur));
}

/**
 * xmlStrcmp:
 * @str1:  the first CHAR *
 * @str2:  the second CHAR *
 *
 * a strcmp for CHAR's
 *
 * Returns the integer result of the comparison
 */

int
xmlStrcmp(const CHAR *str1, const CHAR *str2) 
{
    register int tmp;

#if 1 /*OXYGEN*/
    if (str1 == NULL || str2 == NULL) {
        //SerialDisplayBuf("null str cmp\r\n", 14);        
        printf("null str cmp\n");        
        return TRUE;
    }
#endif
    do {
        tmp = *str1++ - *str2++;
	if (tmp != 0) return(tmp);
    } while ((*str1 != 0) && (*str2 != 0));
    return (*str1 - *str2);
}

/**
 * xmlStrncmp:
 * @str1:  the first CHAR *
 * @str2:  the second CHAR *
 * @len:  the max comparison length
 *
 * a strncmp for CHAR's
 *
 * Returns the integer result of the comparison
 */

int
xmlStrncmp(const CHAR *str1, const CHAR *str2, int len) 
{
    register int tmp;
#if 1 /*OXYGEN*/
    if (str1 == NULL || str2 == NULL) {
        //SerialDisplayBuf("null strn cmp\r\n", 15);        
        printf("null strn cmp\n");        
        return TRUE;
    }
#endif


    if (len <= 0) return(0);
    do {
        tmp = *str1++ - *str2++;
	if (tmp != 0) return(tmp);
	len--;
        if (len <= 0) return(0);
    } while ((*str1 != 0) && (*str2 != 0));
    return (*str1 - *str2);
}

/**
 * xmlStrchr:
 * @str:  the CHAR * array
 * @val:  the CHAR to search
 *
 * a strchr for CHAR's
 *
 * Returns the CHAR * for the first occurence or NULL.
 */

CHAR *
xmlStrchr(const CHAR *str, CHAR val) 
{
    while (*str != 0) {
        if (*str == val) return((CHAR *) str);
	str++;
    }
    return(NULL);
}

/**
 * xmlStrlen:
 * @str:  the CHAR * array
 *
 * lenght of a CHAR's string
 *
 * Returns the number of CHAR contained in the ARRAY.
 */

int
xmlStrlen(const CHAR *str) 
{
    int len = 0;

    if (str == NULL) return(0);
    while (*str != 0) {
	str++;
	len++;
    }
    return(len);
}

/**
 * xmlStrncat:
 * @cur:  the original CHAR * array
 * @add:  the CHAR * array added
 * @len:  the length of @add
 *
 * a strncat for array of CHAR's
 *
 * Returns a new CHAR * containing the concatenated string.
 */

CHAR *
xmlStrncat(CHAR *cur, const CHAR *add, unsigned long len) 
//xmlStrncat(CHAR *cur, const CHAR *add, int len) 
{
    int size;
    CHAR *ret;
#if 1 /*OXYGEN*/
    if ((add == NULL) || (len <= 0))
        return(cur);
#else
    if ((add == NULL) || (len == 0))
        return(cur);
#endif
    if (cur == NULL)
        return(xmlStrndup(add, len));
#if 0 /*OXYGEN*/
    size = xmlStrlen(cur);
    ret = realloc(cur, (size + len + 1) * sizeof(CHAR));
    if (ret == NULL) {
        fprintf(stderr, "xmlStrncat: realloc of %d byte failed\n",
	        (size + len + 1) * sizeof(CHAR));
        return(cur);
    }
    memcpy(&ret[size], add, len * sizeof(CHAR));
    ret[size + len] = 0;
#else
    size = xmlStrlen(cur);
    ret=xmlMemAlloc((size + len +1) *sizeof(CHAR));
    if (ret== NULL) return (cur);
#if 0 /*WCN*/
    memcpy(&ret, cur, size * sizeof(CHAR));
    memcpy(&ret[size], add, (int)len * sizeof(CHAR));
#endif
    memcpy(ret, cur, size * sizeof(CHAR));
    memcpy(ret+size, add, (int)len * sizeof(CHAR));
    ret[size + (int)len] = 0;
    xmlDEBUG_trace(XML_DBG_LEVEL_TRACE_INFO, XML_DBG_MASK_XML_UTIL,
                   "cur addr= %p\r\n", cur);
    xmlMemFree(cur);
    xmlDEBUG_trace(XML_DBG_LEVEL_TRACE_INFO, XML_DBG_MASK_XML_UTIL,
                   "ret addr= %p\r\n", ret);
#endif
    return(ret);
}

/**
 * xmlStrcat:
 * @cur:  the original CHAR * array
 * @add:  the CHAR * array added
 *
 * a strcat for array of CHAR's
 *
 * Returns a new CHAR * containing the concatenated string.
 */
CHAR *
xmlStrcat(CHAR *cur, const CHAR *add) 
{
    const CHAR *p = add;

    if (add == NULL) return(cur);
    if (cur == NULL) 
        return(xmlStrdup(add));

    while (IS_CHAR(*p)) p++;
    return(xmlStrncat(cur, add, p - add));
}


CHAR *xml_dump_buf = NULL;
int buffer_index = 0;
int buffer_size = 0;

/**
 * xmlBufferWriteCHAR:
 * @string:  the string to add
 *
 * routine which manage and grows an output buffer. This one add
 * CHARs at the end of the array.
 */
void
xmlBufferWriteCHAR(const CHAR *string) 
{
    const CHAR *cur;

    if (xml_dump_buf == NULL) {
#if 0 /*OXYGEN*/
        buffer_size = 50000;
#else
        buffer_size = 5000;
#endif
        xml_dump_buf = (CHAR *) xmlMemAlloc(buffer_size * sizeof(CHAR));
	if (xml_dump_buf == NULL) {
//	    fprintf(stderr, "xmlBufferWrite : out of memory!\n");
//	    exit(1);
            return;
	}
    }
#if 0 /*OXYGEN*/
        SerialDisplayBuf(XML_CRLF, 2);
        //SerialDisplayBuf("==========xmlBufferWriteCHAR==========", 38); 
        SerialDisplayBuf((char *)string, strlen((char *)string)); 
        SerialDisplayBuf(XML_CRLF, 2);
        SerialDisplayBuf(XML_CRLF, 2);
        SerialDisplayBuf((char *)xml_dump_buf, strlen((char *)xml_dump_buf));
        SerialDisplayBuf(XML_CRLF, 2);
#endif

    if (string == NULL) return;
    for (cur = string;*cur != 0;cur++) {
        if (buffer_index  + 10 >= buffer_size) {
                return;
//		exit(1);
#if 0 /*OXYGEN*/
	    buffer_size *= 2;
	    xml_dump_buf = (CHAR *) realloc(xml_dump_buf, buffer_size * sizeof(CHAR));
	    if (xml_dump_buf == NULL) {
	        fprintf(stderr, "xmlBufferWrite : out of memory!\n");
		exit(1);
	    }
#endif
	}
        xml_dump_buf[buffer_index++] = *cur;
    }
    xml_dump_buf[buffer_index] = 0;
}

/**
 * xmlBufferWriteChar:
 * @string:  the string to add
 *
 * routine which manage and grows an output buffer. This one add
 * C chars at the end of the array.
 */
void
xmlBufferWriteChar(const char *string) 
{
    const char *cur;

    if (xml_dump_buf == NULL) {
#if 0 /*OXYGEN*/
        buffer_size = 50000;
#else
        buffer_size = 5000;
#endif
        xml_dump_buf = (CHAR *) xmlMemAlloc(buffer_size * sizeof(CHAR));
	if (xml_dump_buf == NULL) {
#if 0 /*OXYGEN*/
	    fprintf(stderr, "xmlBufferWrite : out of memory!\n");
#endif
//	    exit(1);
            return;
	}
    }
#if 0 /*OXYGEN*/
        SerialDisplayBuf(XML_CRLF, 2);
        //SerialDisplayBuf("==========xmlBufferWriteChar==========", 38); 
        SerialDisplayBuf(string, strlen(string)); 
        SerialDisplayBuf(XML_CRLF, 2);
        SerialDisplayBuf(XML_CRLF, 2);
        SerialDisplayBuf((char *)xml_dump_buf, strlen((char *)xml_dump_buf));
        SerialDisplayBuf(XML_CRLF, 2);
#endif

    if (string == NULL) return;
    for (cur = string;*cur != 0;cur++) {
        if (buffer_index  + 10 >= buffer_size) {
                return;
//		exit(1);
#if 0 /*OXYGEN*/
	    buffer_size *= 2;
	    xml_dump_buf = (CHAR *) realloc(xml_dump_buf, buffer_size * sizeof(CHAR));
	    if (xml_dump_buf == NULL) {
	        fprintf(stderr, "xmlBufferWrite : out of memory!\n");
		exit(1);
	    }
#endif
	}
        xml_dump_buf[buffer_index++] = *cur;
    }
    xml_dump_buf[buffer_index] = 0;
}

