#ifndef __XML_MEM_H__
#define __XML_MEM_H__

typedef unsigned int mem_size_t;
//typedef unsigned int uint;

typedef struct  _XML_MEM_DEF                 /* memory block header definition */
{
  mem_size_t    mem_size;       /* memory block size */
  struct _XML_MEM_DEF *mem_nxt;       /* link to next block */
}XML_MEM_DEF;

void xmlMemInit(void);
void  *xmlMemAlloc(mem_size_t  reqsize); /* number of bytes requested */
int xmlMemFree( void *reladr ); /* addr. of memory to release */
XML_MEM_DEF *xmlMemCheck(
    mem_size_t  *bytes,                 /* total number of free bytes */
    uint        *chunks                 /* total number of free blocks */
    ); 

XML_MEM_DEF *xmlMemAllocCheck(
    mem_size_t  *bytes,                 /* total number of alloc bytes */
    uint        *chunks                 /* total number of alloc blocks */
    ); 

int xmlgrowBuffer2(void **pOrigMem, int block, int block_size);
void xmlMemMonitor(int level);
#endif /* __XML_MEM_H__ */
