#if 0
#include "nplat.h"
#include "nest.h"
#include "poseapi.h"
#include "system.h"
#include "nppkt.h"
#include "nptapi.h"
#include "syslib.h"
#include "string.h"
#include "timer.h"
#include "err.h"
#include "netcfg.h"
#include "socket.h"
#include "in.h"
#include "syscfg.h"
#endif

//#include "upnp.h"
//#include "upnp_wra.h"
//#include "upnp_utl.h"
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "semaphore_api.h"
#include "xml_dump.h"
#include "xml_tree.h"
#include "xml_enti.h"
#include "xml_vali.h"
#include "xml_ext.h"
#include "xml_mem.h"
#include "xml_dbg.h"

extern int xmlmem_sem_id;
//thunder
#define MEMRSZ	16
#define huge_
typedef unsigned char byte;

#define MT_SUCCESS	0	/*successful operation*/
#define E_RELMEM	-19	/*invalid memory release*/
//thunder

#define XML_MEM_MONITOR_DURATION  0*18
//#define XML_MEM_MONITOR_DURATION  60*18
#define XML_MEM_SIZE        65535   /*64K BYTES*/ 
//#define XML_MEM_SIZE        65472   /*64K-64 BYTES*/ 
/* If do not minus 64 BYTES, the xmlMemFree will cause memory leak.
 */

//#define XML_MEM_SIZE        65424  /*64K-112 BYTES*/
//#define XML_MEM_SIZE        57344  /*56K BYTES*/
//#define XML_MEM_SIZE        49152  /*48K BYTES*/
/* If do not minus 112 BYTES, the Paradigm
 * will warn:
 * Warn :  :Segment XML_MEM5_BSS will wrap around and requires 
 * the alignment to be increased
 */
                                     
//#define XML_MEM_SIZE        32768   /*32K BYTES*/ 
//#define XML_MEM_SIZE        10240   /*10K BYTES*/ 

#define XML_BUFFER          0x1F000000L /*64K BYTES*/
uint CPUInterruptProtect(void);
void CPUInterruptUnProtect(uint);
extern int SerialDisplayBuf(char *pBuf, int Len);

void xmlMemMonitor(int level);
static char XML_GROW_BUF2[]="XMLgrowBuffer2";
static char XML_FREE_BYTES[]="xml free bytes";
static char XML_FREE_CHUNKS[]="xml free chunks";
static char XML_ALLOC_BYTES[]="xml alloc bytes";
static char XML_ALLOC_CHUNKS[]="xml alloc chunks";

static unsigned int xmlMemMonitorExpireTime =0;


char xml_mem[XML_MEM_SIZE];
//char *xml_mem = XML_BUFFER;

XML_MEM_DEF  *xml_free_list,            /* free memory pointer */
         *xml_allocated_list;         /* system memory pointer */

//#if INC_REQMEM
#if 1
void xmlMemInit(void)
{
    static int xml_init=0;

    if (0 == xml_init) {
        xml_init=1;
        xml_free_list=(XML_MEM_DEF *)xml_mem;
        xml_free_list->mem_size=XML_MEM_SIZE-sizeof(XML_MEM_DEF);
        xml_free_list->mem_nxt=NULL;
    }
    return;
}

/* ------------------------------------------------------------------- xmlMemAlloc *
 * request memory block
 *    exit:     NULL    insufficient memory
 *              <addr>  address pointer to memory block
 ******************************************************************************/
//void  *xmlMemAlloc(mem_size_t  reqsize) REENTRANT /* number of bytes requested */
void  *xmlMemAlloc(mem_size_t  reqsize) /* number of bytes requested */
{
XML_MEM_DEF  *curmpt;          /* current memory pointer */
XML_MEM_DEF  *prvmpt,        /* previous memory pointer */
         *cur_tmpt,                /* current task memory pointer */
         *prev_tmpt;               /* previous task memory pointer */
mem_size_t    leftover;       /* leftover bytes */
//uint x;

    //x = CPUInterruptProtect();
    if (!semaphore_p(xmlmem_sem_id)) exit(EXIT_FAILURE);

    reqsize = (reqsize + 7)  &  ~7;
    if( reqsize < MEMRSZ )              /* force min req size */
        reqsize = MEMRSZ;

    prvmpt = NULL;
    curmpt = xml_free_list;   /* curmpt = head of list */
    while( curmpt   &&   curmpt->mem_size < reqsize){
        prvmpt = curmpt;
        curmpt = curmpt->mem_nxt;
    }

    if( !curmpt ){                              /* no mem avail */
        xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_MEM,
                  "%s\r\n", "xml mem: no mem avail");
        xmlMemMonitor(XML_DBG_LEVEL_CRITICAL);
        //CPUInterruptUnProtect(x);
        if (!semaphore_v(xmlmem_sem_id)) exit(EXIT_FAILURE);
        return((void *)curmpt);
    }else{                                      /* mem avail */
        leftover = curmpt->mem_size - reqsize;
        if( leftover >= (MEMRSZ + sizeof(XML_MEM_DEF)) ){
            leftover -= sizeof(XML_MEM_DEF);
            prvmpt = curmpt;    /* split the block */
            prvmpt->mem_size = leftover;
            curmpt = (XML_MEM_DEF *) ((byte huge_ *) prvmpt + leftover) + 1;
            curmpt->mem_size = reqsize;
        }else{                          /* delink the block */
            if( !prvmpt )
                xml_free_list = curmpt->mem_nxt;
            else
                prvmpt->mem_nxt = curmpt->mem_nxt;
        }

        prev_tmpt = NULL;
        cur_tmpt = xml_allocated_list;
        while( cur_tmpt ){
            prev_tmpt = cur_tmpt;
            cur_tmpt = cur_tmpt->mem_nxt;
        }
        if( !prev_tmpt ){
            xml_allocated_list = curmpt;
        }else{
            prev_tmpt->mem_nxt = curmpt;
        }
        curmpt->mem_nxt = NULL;
        memset(curmpt+1, 0, curmpt->mem_size);
        //CPUInterruptUnProtect(x);
        if (!semaphore_v(xmlmem_sem_id)) exit(EXIT_FAILURE);
        return (void *)(curmpt + 1);
    }
}

/* ------------------------------------------------------------------- xmlMemFree *
 * release memory block
 *
 *    release:  SUCCESS         released memory to free memory
 *              E_RELMEM        error releasing memory
 ******************************************************************************/
//int xmlMemFree( void *reladr )REENTRANT /* addr. of memory to release */
int xmlMemFree( void *reladr ) /* addr. of memory to release */
{
XML_MEM_DEF  huge_ *prvmpt;
XML_MEM_DEF  huge_ *curmpt;
XML_MEM_DEF  huge_ *keympt;
XML_MEM_DEF  huge_ *oldmpt;
XML_MEM_DEF  huge_ *tstmpt;
XML_MEM_DEF   **current_list;
//uint x;

    //x = CPUInterruptProtect();
    if (!semaphore_p(xmlmem_sem_id)) exit(EXIT_FAILURE);
    keympt = (XML_MEM_DEF *) ((byte *)reladr - sizeof(XML_MEM_DEF));

    current_list = &xml_allocated_list;  /* global memory list */
    {        /* previously allocated memory */
        prvmpt = NULL;
        curmpt = *current_list;
        /* find block in current appropriate linked list */
        while( curmpt  !=  keympt   &&   curmpt ){
            prvmpt = curmpt;
            curmpt = curmpt->mem_nxt;
        }
        if( !curmpt ){  /* not in the list */
            xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_MEM,
                  "%p, %s\r\n", reladr, "xml mem: not allocated");
            //CPUInterruptUnProtect(x);
	    if (!semaphore_v(xmlmem_sem_id)) exit(EXIT_FAILURE);
            return(E_RELMEM);
        }
        if( !prvmpt )   /* unlink block from list its in */
            *current_list = curmpt->mem_nxt;
        else
            prvmpt->mem_nxt = curmpt->mem_nxt;
    }

    prvmpt = NULL;
    curmpt = xml_free_list;
    /* find where to insert it into free memory list */
    while( curmpt  &&  keympt > curmpt){
        prvmpt = curmpt;
        curmpt = curmpt->mem_nxt;
    }
    oldmpt = prvmpt;

    /* link in block */
    if( !prvmpt ){
        xml_free_list = (XML_MEM_DEF *)keympt;
    }else{
        prvmpt->mem_nxt = (XML_MEM_DEF *)keympt;
    }
    keympt->mem_nxt = (XML_MEM_DEF *)curmpt;

    /* combine or link with prior block */

    if( prvmpt ){                               /* prior block */
        tstmpt = (XML_MEM_DEF huge_ *) ((byte huge_ *) prvmpt +
                        prvmpt->mem_size) + 1;
        if( tstmpt > keympt ){          /* overlap condition - delink, error */
            prvmpt->mem_nxt = keympt->mem_nxt;
            xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_MEM,
                  "%p, %s\r\n", reladr, "xml mem: pre overlap current");
            //CPUInterruptUnProtect(x);
	    if (!semaphore_v(xmlmem_sem_id)) exit(EXIT_FAILURE);
            return(E_RELMEM);
        }
        if( tstmpt == keympt ){
            prvmpt->mem_size = prvmpt->mem_size + keympt->mem_size +
                                                        sizeof(XML_MEM_DEF);
            prvmpt->mem_nxt = keympt->mem_nxt;
        }else
            prvmpt = keympt;
    }else{
        prvmpt = keympt;
    }

    /* combine or link with next block */

    if( curmpt ){                               /* next block */
        tstmpt = (XML_MEM_DEF huge_ *) ((byte huge_ *) prvmpt +
                    prvmpt->mem_size) + 1;
        if( tstmpt > curmpt ){          /* overlap condition */
            if( !oldmpt ){              /* block at head */
                xml_free_list = prvmpt->mem_nxt;
            } else if ( oldmpt == prvmpt ){     /* block recombined */
                oldmpt->mem_size = oldmpt->mem_size -
                        keympt->mem_size - sizeof(XML_MEM_DEF);
            }else{                      /* block simply linked */
                oldmpt->mem_nxt = prvmpt->mem_nxt;
            }
            xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_MEM,
                  "%p, %s\r\n", reladr, "xml mem: current overlap next");
            //CPUInterruptUnProtect(x);
	    if (!semaphore_v(xmlmem_sem_id)) exit(EXIT_FAILURE);
            return(E_RELMEM);           /* overlap error */
        } else if ( tstmpt == curmpt ){ /* combine with next */
            prvmpt->mem_size = prvmpt->mem_size + curmpt->mem_size
                            + sizeof(XML_MEM_DEF);
            prvmpt->mem_nxt = curmpt->mem_nxt;
        }
    }
    //CPUInterruptUnProtect(x);
    if (!semaphore_v(xmlmem_sem_id)) exit(EXIT_FAILURE);
    return(MT_SUCCESS);
}
#endif          /* INC_REQMEM */

/* ------------------------------------------------------------------- chkmem *
 * check free memory
 *
 *  exit:       <bytes> = number of free bytes
 *              <chunks> = number of free blocks
 * return:      address of first free block
 *          (should use REQMEM to actually request it)
 ******************************************************************************/
XML_MEM_DEF *xmlMemCheck(
    mem_size_t  *bytes,                 /* total number of free bytes */
    uint        *chunks                 /* total number of free blocks */
    ) 
{
XML_MEM_DEF  *memptr;                  /* memory ptr */

    *chunks = 0;
    *bytes = 0;
    memptr = xml_free_list;
    while( memptr ){
        *chunks += 1;
        *bytes += memptr->mem_size;
        memptr = memptr->mem_nxt;
    }
    memptr = xml_free_list;
    return((XML_MEM_DEF *)memptr);
}

/* ------------------------------------------------------------------- chkmem *
 * check alloc memory
 *
 *  exit:       <bytes> = number of alloc bytes
 *              <chunks> = number of alloc blocks
 * return:      address of first alloc block
 *          (should use REQMEM to actually request it)
 ******************************************************************************/
XML_MEM_DEF *xmlMemAllocCheck(
    mem_size_t  *bytes,                 /* total number of alloc bytes */
    uint        *chunks                 /* total number of alloc blocks */
    ) 
{
XML_MEM_DEF  *memptr;                  /* memory ptr */

    *chunks = 0;
    *bytes = 0;
    memptr = xml_allocated_list;
    while( memptr ){
        *chunks += 1;
        *bytes += memptr->mem_size;
        memptr = memptr->mem_nxt;
    }
    memptr = xml_allocated_list;
    return((XML_MEM_DEF *)memptr);
}



void  *xmlMemRealloc(void **pOrigMem, mem_size_t  reqsize) /* number of bytes requested */
{
    void *pNewMem;

    pNewMem=xmlMemAlloc(reqsize);
    if (pNewMem != NULL){
        memcpy(pNewMem, *pOrigMem, (size_t)reqsize); 
        xmlMemFree(*pOrigMem);
        *pOrigMem=NULL;
    }
    return pNewMem;
}


int xmlgrowBuffer2(void **pOrigMem, int block, int block_size) 
{
    int returnStatus=XML_SUCCESS;
    void *pNewMem;

    xmlDEBUG_trace(XML_DBG_LEVEL_VERBOSE, XML_DBG_MASK_XML_MEM, 
              "%s S\r\n", XML_GROW_BUF2);
    pNewMem=xmlMemRealloc(pOrigMem, block * block_size);
    if (pNewMem != NULL) {
        *pOrigMem=pNewMem;
    } else {
        returnStatus=XML_FAILURE;
    }
    xmlDEBUG_trace(XML_DBG_LEVEL_VERBOSE, XML_DBG_MASK_XML_MEM, 
              "%s E\r\n", XML_GROW_BUF2);
    return returnStatus;
}

int IsxmlMemMonitorExpired(void)
{
    unsigned int now;
    time_t t;

    //now = POSEClockGetTick();
    now = time(&t);
    if (xmlMemMonitorExpireTime <= now ) {
        xmlMemMonitorExpireTime=now + XML_MEM_MONITOR_DURATION; 
        return 1;
    }
    else
        return 0;
}

void xmlMemMonitor(int level)
{
    int ret;
    mem_size_t bytes;
    uint chunks;

    ret=IsxmlMemMonitorExpired();
    if (ret == 1) {
        xmlMemCheck(&bytes, &chunks);
        xmlDEBUG_trace(level, XML_DBG_MASK_XML_MEM,
                  "%s=%lu, %s=%u\r\n",
                  XML_FREE_BYTES, bytes,
                  XML_FREE_CHUNKS, chunks);
        xmlMemAllocCheck(&bytes, &chunks);
        xmlDEBUG_trace(level, XML_DBG_MASK_XML_MEM,
                  "%s=%lu, %s=%u\r\n", 
                  XML_ALLOC_BYTES, bytes, 
                  XML_ALLOC_CHUNKS, chunks);
    }
    return;
}

