/*
 * See Copyright for the status of this software.
 *
 * Daniel.Veillard@w3.org
 */

#if 0
#include "nplat.h"
#include "nest.h"
#include "poseapi.h"
#include "system.h"
#include "nppkt.h"
#include "nptapi.h"
#include "syslib.h"
#include "string.h"
#include "timer.h"
#include "err.h"
#include "netcfg.h"
#include "socket.h"
#include "in.h"
#include "syscfg.h"
#endif

//#include "upnp.h"
//#include "upnp_wra.h"
//#include "upnp_utl.h"
#include <stdlib.h>
#include <string.h>
#include "xml_dump.h"
#include "xml_tree.h"
#include "xml_enti.h"
#include "xml_vali.h"
#include "xml_ext.h"
#include "xml_mem.h"
#include "xml_dbg.h"

#define ENCODE_ENTI_SIZE    1000

extern int SerialDisplayBuf(char *pBuf, int Len);

CHAR *
xmlEncodeEntities_R(xmlDocPtr doc, const CHAR *input, CHAR *output) 
{
    const CHAR *cur = input;
    CHAR *out;
    int block=1;

    if (input == NULL) {
        output=NULL;
        return output;
    }
    output = (CHAR *) xmlMemAlloc(ENCODE_ENTI_SIZE* sizeof(CHAR));
    if (output == NULL) 
        return output;

    out = output; 
    while (*cur != '\0') {
        if (out - output> ENCODE_ENTI_SIZE * block - 100) {
	    int index = (int)(out - output); 
            block++;
	    if (xmlgrowBuffer2((void **)&output, block, ENCODE_ENTI_SIZE) == XML_SUCCESS) {
	        out = &output[index];
            } else {
                xmlMemFree(output);
                output=NULL;
                return output;
            }
	}

	/*
	 * By default one have to encode at least '<', '>', '"' and '&' !
	 */
	if (*cur == '<') {
	    *out++ = '&';
	    *out++ = 'l';
	    *out++ = 't';
	    *out++ = ';';
	} else if (*cur == '>') {
	    *out++ = '&';
	    *out++ = 'g';
	    *out++ = 't';
	    *out++ = ';';
	} else if (*cur == '&') {
	    *out++ = '&';
	    *out++ = 'a';
	    *out++ = 'm';
	    *out++ = 'p';
	    *out++ = ';';
	} else if (*cur == '"') {
	    *out++ = '&';
	    *out++ = 'q';
	    *out++ = 'u';
	    *out++ = 'o';
	    *out++ = 't';
	    *out++ = ';';
	} else if (*cur == '\'') {
	    *out++ = '&';
	    *out++ = 'a';
	    *out++ = 'p';
	    *out++ = 'o';
	    *out++ = 's';
	    *out++ = ';';
	} else if (((*cur >= 0x20) && (*cur < 0x80)) ||
	    (*cur == '\n') || (*cur == '\r') || (*cur == '\t')) {
	    /*
	     * default case, just copy !
	     */
	    *out++ = *cur;
	} 
	cur++;
    }
    *out++ = 0;
    return(output);
}

PNODE_AREA xmlBufferWriteCHAR_R(PNODE_AREA area, const CHAR *string)
{
    const CHAR *cur;
    int index=0;
    char *out;

    if (area->out == NULL) {
        area->out = (char *) xmlMemAlloc(area->gap * sizeof(char));
        area->cap=area->gap;
        area->block=1;
	if (area->out == NULL) {
            return NULL;
	}
    }
    if (string == NULL) return area;
    out=area->out+strlen(area->out);
    index=strlen(area->out);
    for (cur = string;*cur != 0;cur++) {
        if (out - area->out+ 10 >= area->cap) {
            area->block++;
            index=(int)(out-area->out);
	    if (xmlgrowBuffer2((void **)&area->out, area->block, area->gap) == XML_SUCCESS) {
	        out = &(area->out[index]);
                area->cap+=area->gap;
            } else {
                xmlMemFree(area->out);
                //SerialDisplayBuf("**********\r\n", 12);
                printf("**********\r\n");
                area->out=NULL;
                return NULL;
            }
	}
        *out++ = *cur;
    }
    *out++ = 0;
    return area;
}

PNODE_AREA xmlBufferWriteChar_R(PNODE_AREA area, const char *string)
{
    const char *cur;
    int index=0;
    char *out;

    if (area->out == NULL) {
        area->out = (char *) xmlMemAlloc(area->gap * sizeof(char));
        area->cap=area->gap;
        area->block=1;
	if (area->out == NULL) {
            return NULL;
	}
    }
    if (string == NULL) return area;
    out=area->out+strlen(area->out);
    index=strlen(area->out);
    for (cur = string;*cur != 0;cur++) {
        if (out - area->out+ 10 >= area->cap) {
            area->block++;
            index=(int)(out-area->out);
	    if (xmlgrowBuffer2((void **)&area->out, area->block, area->gap) == XML_SUCCESS) {
	        out = &(area->out[index]);
                area->cap+=area->gap;
            } else {
                xmlMemFree(area->out);
                //SerialDisplayBuf("##########\r\n", 12);
                printf("##########\r\n");
                area->out=NULL;
                return NULL;
            }
	}
        *out++ = *cur;
    }
    *out++ = 0;
    return area;
}


#if 0
PNODE_AREA xmlBufferWriteCHAR_R_tmp1(PNODE_AREA area, int *output_cap;const CHAR *string)
{
    const CHAR *cur;
    int buffer_size=5000;
    int buffer_index=0;
    int block=output_cap/buffer_size;
    char *out;

    if (area->out == NULL) {
        area->out = (char *) xmlMemAlloc(buffer_size * sizeof(char));
        area->cap+=buffer_size;
	if (area->out == NULL) {
            return;
	}
    }
    
    if (string == NULL) return;
    out=area->out;
    buffer_index=strlen(area->out);
    for (cur = string;*cur != 0;cur++) {
        if (buffer_index + 10 >= area->cap) {
            block++;
	    if (xmlgrowBuffer2(&(void *)area->out, block, buffer_size) == XML_SUCCESS) {
	        out = &(area->out[buffer_index]);
            } else {
                xmlMemFree(area->out);
                return NULL;
            }
	}
        out[buffer_index++] = *cur;
    }
    out[buffer_index] = 0;
    return area;
}

int xmlBufferWriteCHAR_R_tmp(char *output, int *output_cap;const CHAR *string)
{
    const CHAR *cur;
    int buffer_size=5000;
    int buffer_index=0;
    int block=output_cap/buffer_size;
    char *out;

    if (output == NULL) {
        output = (char *) xmlMemAlloc(buffer_size * sizeof(char));
        output_cap=buffer_size;
	if (output == NULL) {
            return;
	}
    }
    
    if (string == NULL) return;
    out=output;
    for (cur = string;*cur != 0;cur++) {
        if (buffer_index + strlen(output) + 10 >= output_cap) {
            block++;
	    if (xmlgrowBuffer2(&(void *)output, block, buffer_size) == XML_SUCCESS) {
	        out = &output[buf_index];
            } else {
                xmlMemFree(output);
                return NULL;
            }
	}
        out[buffer_index++] = *cur;
    }
    out[buffer_index] = 0;

}
#endif
