/*
 * error.c: module displaying/handling XML parser errors
 *
 * See Copyright for the status of this software.
 *
 * Daniel Veillard <Daniel.Veillard@w3.org>
 */
#include <stdarg.h>
#include <string.h>

#if 0
#include "nest.h"
#include "poseapi.h"
#include "system.h"
#include "nppkt.h"
#include "nptapi.h"
#include "syslib.h"
#include "string.h"
#include "timer.h"
#include "err.h"
#include "netcfg.h"
#include "socket.h"
#include "in.h"
#include "syscfg.h"
#endif

//#include "upnp.h"
//#include "upnp_utl.h"

#include "xml_dump.h"
#include "xml_pars.h"
#include "xml_dbg.h"

#define XML_PARSER_ERR_SIZE     256
//static char xml_parser_error[XML_PARSER_ERR_SIZE];
/**
 * xmlParserError:
 * @ctxt:  an XML parser context
 * @msg:  the message to display/transmit
 * @...:  extra parameters for the message display
 * 
 * Display and format an error messages, gives file, line, position and
 * extra parameters.
 */
void
xmlParserError(xmlParserCtxtPtr ctxt, const char *msg, ...)
{
    const CHAR *cur, *base;
    const CHAR *begin, *index;
    va_list args;
    char *out;
    int max_extra;
    char xml_parser_error[XML_PARSER_ERR_SIZE];

    xmlDEBUG_trace(XML_DBG_LEVEL_TRACE_INFO, XML_DBG_MASK_XML_ERR,
                  "%s\r\n", "xmlParserError");
    if (ctxt->input->filename)
        xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, 
                       "%s:%d: ", ctxt->input->filename,
	                ctxt->input->line);
    else
        xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, 
                       "line %d: ", ctxt->input->line);
        
    xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, "error:\r\n");

    out=xml_parser_error;
    memset(out, 0, sizeof(xml_parser_error));
    va_start(args, msg);
    vsprintf(out, msg, args);
    va_end(args);
    xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, "%s\r\n", out);

    xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, "Position Info:\r\n");
    cur = ctxt->input->cur;
    max_extra=0;
    xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, 
                       "extra characters =\r\n");
    while (( 0 != *cur) && (max_extra < 20)) {
        xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, 
                       "%#x,", *cur);
	cur++;
        max_extra++;
    }
    xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, "\r\n");
    cur = ctxt->input->cur;
    base = ctxt->input->base;
    while ((cur > base) && (*cur != '<') ) {
        cur--;
    }
    begin=cur;

    index=begin;
    cur = ctxt->input->cur;
    while ((cur > index)) {
        xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, 
                       "%c", (unsigned char) *index++);
    }
    xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, "\r\n");

    index=begin;
    cur = ctxt->input->cur;
    while ((cur > index)) {
        if (0x9 == *index) {
            xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, "%c", *index);
        } else {
            xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, " ");
        }
        index++;
    }
    xmlDEBUG_trace(XML_DBG_LEVEL_WARNING, XML_DBG_MASK_XML_ERR, "^\r\n");
}
#if 0
void
xmlParserError(xmlParserCtxtPtr ctxt, const char *msg, ...)
{
    PRIVILEGED_PROTECT_HANDLE protectID;
    const CHAR *cur, *base;
    const CHAR *begin;
    int n;
    va_list args;
    char *out;
    int max_extra;

    xmlDEBUG_trace(XML_DBG_LEVEL_TRACE_INFO, XML_DBG_MASK_XML_ERR,
                  "%s\r\n", "xmlParserError");
    if (ctxt->input->filename)
        xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, 
                       "%s:%d: ", ctxt->input->filename,
	                ctxt->input->line);
    else
        xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, 
                       "line %d: ", ctxt->input->line);
        
    xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, "error:\r\n");

    protectID = POSEPrivilegedProtect();
    out=xml_parser_error;
    memset(out, 0, sizeof(xml_parser_error));
    va_start(args, msg);
    vsprintf(out, msg, args);
    va_end(ap);
    POSEPrivilegedUnProtect(protectID);
    xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, "%s\r\n", out);

    xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, "\r\nPosition Info:\r\n");
    cur = ctxt->input->cur;
    max_extra=0;
    xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, 
                       "extra characters =\r\n");
    while (( 0 != *cur) && (max_extra < 20)) {
        xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, 
                       "%#x,", *cur);
	cur++;
        max_extra++;
    }
    n = 0;
    cur = ctxt->input->cur;
    base = ctxt->input->base;
    cur--;
    while ((n++ < 60) && (cur > base) && (*cur != '\n') && (*cur != '\r')) {
        cur--;
    }
    if ((*cur == '\n') || (*cur == '\r')) cur++;
    if (n == 60) cur++;
    begin=cur;
    n = 0;
    while ((*cur != 0) && (*cur != '\n') && (*cur != '\r') && (n++ < 60)) {
        xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, 
                       "%c", (unsigned char) *cur++);
    }
    xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, "\r\n");
    cur = ctxt->input->cur;
    while ((*cur == '\n') || (*cur == '\r'))
	cur--;
    n = 0;
    while ((cur >= begin) && (n++ < 60)) {
        if (0x9 == *begin) {
            xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, "%c", *begin);
        } else {
            xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, " ");
        }
        begin++;
    }
    xmlDEBUG_trace(XML_DBG_LEVEL_CRITICAL, XML_DBG_MASK_XML_ERR, "^\r\n");
}
#endif

/**
 * xmlParserWarning:
 * @ctxt:  an XML parser context
 * @msg:  the message to display/transmit
 * @...:  extra parameters for the message display
 * 
 * Display and format a warning messages, gives file, line, position and
 * extra parameters.
 */
void
xmlParserWarning(xmlParserCtxtPtr ctxt, const char *msg, ...)
{
    const CHAR *cur, *base;
    int n;

#if 0 /*OXYGEN*/
    va_list args;

    va_start(args, msg);

    if (ctxt->input->filename)
        fprintf(stderr, "%s:%d: ", ctxt->input->filename,
	        ctxt->input->line);
    else
        fprintf(stderr, "line %d: ", ctxt->input->line);
        
    fprintf(stderr, "warning: ");
    vfprintf(stderr, msg, args);
    va_end(ap);
#endif

    cur = ctxt->input->cur;
    base = ctxt->input->base;
    n = 0;
    while ((n++ < 60) && (cur > base) && (*cur != '\n') && (*cur != '\r'))
        cur--;
    if ((*cur != '\n') || (*cur != '\r')) cur++;
    base = cur;
    n = 0;
    while ((*cur != 0) && (*cur != '\n') && (*cur != '\r') && (n < 79)) {
#if 0 /*OXYGEN*/
        fprintf(stderr, "%c", (unsigned char) *cur++);
#endif
	n++;
    }
#if 0 /*OXYGEN*/
    fprintf(stderr, "\n");
#endif
    cur = ctxt->input->cur;
    n = 0;
    while ((cur != base) && (n++ < 60)) {
#if 0 /*OXYGEN*/
        fprintf(stderr, " ");
#endif
        base++;
    }
#if 0 /*OXYGEN*/
    fprintf(stderr,"^\n");
#endif
}

