/*
 * See Copyright for the status of this software.
 *
 */

#ifndef _XML_DBG_
#define _XML_DBG_

#define XML_DBG_SERIAL      1
#define XML_DBG_LAN         0

#define  XML_DBG_LEVEL_DISABLE                       0               /*disable debug feature*/
#define  XML_DBG_LEVEL_DEATH                         1               /*system is going to die*/
#define  XML_DBG_LEVEL_CRITICAL                      2               /*system is unable to perform its functionality*/
#define  XML_DBG_LEVEL_ERROR                         4               /*handled errors*/
#define  XML_DBG_LEVEL_WARNING                       6               /*warning about abnormal situation*/
#define  XML_DBG_LEVEL_TEST                          8               /*for temp test*/
#define  XML_DBG_LEVEL_TRACE_FLOW                    10              /*trace showing the processing flow, could be routine entries*/
#define  XML_DBG_LEVEL_TRACE_ENTRY                   11              /*trace for regular routine entries*/
#define  XML_DBG_LEVEL_TRACE_INFO                    12              /*informational trace in regular routines*/
#define  XML_DBG_LEVEL_VERBOSE                       24              /*say whatever you like, level 1*/
#define  XML_DBG_LEVEL_DUMPING                       32              /*dumping everything*/


#define XML_DBG_MASK_ALL               0xFFFFFFFF
#define XML_DBG_MASK_NULL              0x00000100
#define XML_DBG_MASK_XML_ERR           0x00002000
#define XML_DBG_MASK_XML_MEM           0x00004000
#define XML_DBG_MASK_XML_PARS          0x00008000
#define XML_DBG_MASK_XML_NODE_TRACE    0x00010000
#define XML_DBG_MASK_XML_EXT           0x00020000
#define XML_DBG_MASK_XML_TREE          0x00040000
#define XML_DBG_MASK_XML_UTIL          0x00080000
#define XML_DBG_MASK_TEST              0x80000000      /*for testing code*/
//typedef unsigned long ULONG;
#define ULONG unsigned long
int xmlDEBUG_trace(ULONG level, ULONG mask, const char *format, ...);
void xmlDEBUG_assert(char *format, ...);
#define assert(p) ((p) ? (void)0 :(void) xmlDEBUG_assert( \
                    "Assertion failed: %s, file %s, line %d", \
                    #p, __FILE__, __LINE__ ) )
void PrintxmlDocPtr(xmlDocPtr doc);
extern char XML_CRLF[3];
#endif  /*_XML_DBG_*/ 
