/*
 * See Copyright for the status of this software.
 *
 */

#if 0
#include "nplat.h"
#include "nest.h"
#include "poseapi.h"
#include "system.h"
#include "nppkt.h"
#include "nptapi.h"
#include "syslib.h"
#include "string.h"
#include "timer.h"
#include "err.h"
#include "netcfg.h"
#include "socket.h"
#include "in.h"
#include "syscfg.h"
#endif
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "semaphore_api.h"
#include "xml_dump.h"
#include "xml_tree.h"
#include "xml_mem.h"
#include "xml_dbg.h"

#define TRUE 1
#define FALSE 0

extern int SerialDisplayBuf(char *pBuf, int Len);

char XML_CRLF[3]="\r\n";

#define XML_DBG_MEM_SIZE        10240 
#define  XML_IS_TRACEABLE(level, mask)               ( (level <= XMLDebugLevel) && (((XMLDebugMask) & (mask)) != 0) )

ULONG   XMLDebugLevel              =  //XML_DBG_LEVEL_DUMPING
                                      //XML_DBG_LEVEL_TRACE_FLOW
                                      //XML_DBG_LEVEL_TRACE_INFO
                                      XML_DBG_LEVEL_CRITICAL
                                      ;
ULONG   XMLDebugMask               = 
                                      XML_DBG_MASK_XML_MEM
                                      |XML_DBG_MASK_XML_PARS
                                      | XML_DBG_MASK_XML_ERR
                                      | XML_DBG_MASK_XML_EXT
                                      //| XML_DBG_MASK_XML_TREE
                                      //| XML_DBG_MASK_XML_UTIL
                                      | XML_DBG_MASK_TEST
                                      ;
#if UCP|MS
//extern CHAR *xml_dump_buf;
#endif

static char xml_dbg_mem[XML_DBG_MEM_SIZE];

extern int xmldbg_sem_id;

int xmlDEBUG_trace(ULONG level, ULONG mask, const char *format, ...)
{
    int retval=0;
    va_list ap;
    char *out;

    if (XML_IS_TRACEABLE(level, mask) == TRUE) {
        if (!semaphore_p(xmldbg_sem_id)) exit(EXIT_FAILURE);
        out=xml_dbg_mem;
        //out=ALAllocateMemory(XML_RECV_BUF_SIZE);
        //out=tblMemAlloc(xml_dbg_mem, DEBUG_TRACE_SIZE);
        if (NULL != out) {
            memset(out, 0, sizeof(xml_dbg_mem));
            va_start(ap, format);
            /*Paradigm has no vsnprintf()*/
            retval=vsprintf(out, format, ap);
            va_end(ap);
            if (retval > 0) {
#if XML_DBG_SERIAL
                //SerialDisplayBuf(out, retval);
		printf("%s\n", out);
#elif XML_DBG_LAN
                LanPrint(out, retval);
#endif
            }
            //tblMemFree(out);
            //ALFreeMemory(out);
        }
        if (!semaphore_v(xmldbg_sem_id)) exit(EXIT_FAILURE);
    }
    return retval;
}

//void DEBUG_assert(char *msg, char *cond, char *file, int line)
void xmlDEBUG_assert(char *format, ...)
{
    int retval=0;
    va_list ap;
    char *out;

    if (!semaphore_p(xmldbg_sem_id)) exit(EXIT_FAILURE);
    out=xml_dbg_mem;
    //out=ALAllocateMemory(DEBUG_ASSERT_SIZE);
    //out=tblMemAlloc(xml_dbg_mem, DEBUG_ASSERT_SIZE);
    if (NULL != out) {
        memset(out, 0, sizeof(xml_dbg_mem));
        va_start(ap, format);
        /*We have no vsnprintf()*/
        retval=vsprintf(out, format, ap);
        va_end(ap);
        if (retval > 0) {
#if XML_DBG_SERIAL
            //SerialDisplayBuf(out, retval);
	    printf("%s\n", out);
#elif XML_DBG_LAN
            LanPrint(out, retval);
#endif
        }
        //tblMemFree(out);
        //ALFreeMemory(out);

    }
    if (!semaphore_v(xmldbg_sem_id)) exit(EXIT_FAILURE);
    abort();
}

void PrintxmlDocPtr(xmlDocPtr doc)
{
    //PRIVILEGED_PROTECT_HANDLE protectID;
    NODE_AREA   output={NULL,0,0,0,2000};

    //protectID = POSEPrivilegedProtect();
    xmlDocDumpMemory_R(&output, doc);
    if (output.out != NULL) {
        xmlDEBUG_trace(XML_DBG_LEVEL_DUMPING, XML_DBG_MASK_XML_EXT, "%s%s", output.out, XML_CRLF);
        xmlMemFree((void *)output.out);
        output.out=NULL;
    }
    //POSEPrivilegedUnProtect(protectID);
    return;
}
