/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2004, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	ee_flash.c

	Abstract:
	Miniport generic portion header file

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/


#include	"rt_config.h"

#include        "ralink_gpio.h"

/* The definition of the EeBuffer[] located in chips/rtxxxx.c */
extern UCHAR EeBuffer[EEPROM_SIZE];

static NDIS_STATUS rtmp_ee_flash_init(PRTMP_ADAPTER pAd, PUCHAR start);


static UCHAR init_flag = 0;
static PUCHAR nv_ee_start = 0;

static USHORT EE_FLASH_ID_LIST[]={
#ifdef RT305x
	0x3052,
	0x3051,
	0x3050,
#endif // RT305x //
};

#define EE_FLASH_ID_NUM  (sizeof(EE_FLASH_ID_LIST) / sizeof(USHORT))

extern RTMP_ADAPTER *pGlobalAd;
int ra_mtd_read_nm(char *name, loff_t from, size_t len, u_char *buf);
int ra_mtd_write_nm(char *name, loff_t to, size_t len, const u_char *buf);


/*******************************************************************************
  *
  *	Flash-based EEPROM read/write procedures.
  *		some chips use the flash memory instead of internal EEPROM to save the 
  *		calibration info, we need these functions to do the read/write.
  *
  ******************************************************************************/
USHORT rtmp_ee_flash_read(
	IN PRTMP_ADAPTER pAd, 
	IN USHORT Offset,
	OUT USHORT *pValue)
{	
	if (!init_flag)
	{
		*pValue = 0xffff;
	}
	else
	{
		memcpy(pValue, nv_ee_start+ Offset, 2);
	}
	return (*pValue);
}


VOID rtmp_ee_flash_write(PRTMP_ADAPTER pAd, USHORT Offset, USHORT Data)
{
	if (init_flag)
	{
		memcpy(nv_ee_start+ Offset, &Data, 2);
		//rt_nv_commit();
		//rt_cfg_commit();
		RtmpFlashWrite(EeBuffer, RF_OFFSET, EEPROM_SIZE);
	}
	return;
}


VOID rtmp_ee_flash_read_all(PRTMP_ADAPTER pAd, USHORT *Data)
{	
	if (!init_flag)
		return;
		
	memcpy(Data, nv_ee_start, EEPROM_SIZE);
}


VOID rtmp_ee_flash_write_all(PRTMP_ADAPTER pAd, USHORT *Data)
{
        char *pdata;

	if (!init_flag)
		return;
        pdata = (char *)Data;
        memcpy(&(pdata[4]), &(nv_ee_start[4]), 6);		//don't change mac address, andy
	memcpy(nv_ee_start, Data, EEPROM_SIZE);
	RtmpFlashWrite(EeBuffer, RF_OFFSET, EEPROM_SIZE);
}


#if 0
static NDIS_STATUS rtmp_ee_flash_reset(PUCHAR start)
{
	PUCHAR				src;
	RTMP_OS_FS_INFO		osFsInfo;
	RTMP_OS_FD			srcf;
	INT 					retval;

	src = EEPROM_DEFAULT_FILE_PATH;

	RtmpOSFSInfoChange(&osFsInfo, TRUE);

	if (src && *src)
	{
		srcf = RtmpOSFileOpen(src, O_RDONLY, 0);
		if (IS_FILE_OPEN_ERR(srcf)) 
		{
			DBGPRINT(RT_DEBUG_TRACE, ("--> Error opening file %s\n", src));
			return NDIS_STATUS_FAILURE;
		}
		else 
		{
			// The object must have a read method
			NdisZeroMemory(start, EEPROM_SIZE);
			
			retval = RtmpOSFileRead(srcf, start, EEPROM_SIZE);
			if (retval < 0)
			{
				DBGPRINT(RT_DEBUG_TRACE, ("--> Read %s error %d\n", src, -retval));
			}
			else
			{
				DBGPRINT(RT_DEBUG_TRACE, ("--> rtmp_ee_flash_reset copy %s to eeprom buffer\n", src));
			}

			retval = RtmpOSFileClose(srcf);
			if (retval)
			{
				DBGPRINT(RT_DEBUG_TRACE, ("--> Error %d closing %s\n", -retval, src));
			}
		}
	}

	RtmpOSFSInfoChange(&osFsInfo, FALSE);

	return NDIS_STATUS_SUCCESS;
}
#endif

#if 0
#ifdef LINUX
/* 0 -- Show ee buffer */
/* 1 -- force reset to default */
/* 2 -- Change ee settings */
int	Set_EECMD_Proc(
	IN	PRTMP_ADAPTER	pAd, 
	IN	PUCHAR			arg)
{
	USHORT i;
	
	i = simple_strtol(arg, 0, 10);
	switch(i)
	{
		case 0:
			{
				USHORT value, k;
				for (k = 0; k < EEPROM_SIZE; k+=2)
				{
					RT28xx_EEPROM_READ16(pAd, k, value);
					DBGPRINT(RT_DEBUG_OFF, ("%4.4x ", value));
					if (((k+2) % 0x20) == 0)
						DBGPRINT(RT_DEBUG_OFF,("\n"));
				}
				
			}
			break;
		case 1:
			if (pAd->infType == RTMP_DEV_INF_RBUS)
			{
#if 0
				DBGPRINT(RT_DEBUG_OFF, ("EEPROM reset to default......\n"));
				DBGPRINT(RT_DEBUG_OFF, ("The last byte of MAC address will be re-generated...\n"));
				if (rtmp_ee_flash_reset(nv_ee_start) != NDIS_STATUS_SUCCESS)
				{
					DBGPRINT(RT_DEBUG_ERROR, ("Set_EECMD_Proc: rtmp_ee_flash_reset() failed\n"));
					return FALSE;
				}
#endif
			
				// Random number for the last bytes of MAC address
				{
					USHORT  Addr45;

					rtmp_ee_flash_read(pAd, 0x08, &Addr45);
					Addr45 = Addr45 & 0xff;
					Addr45 = Addr45 | (RandomByte(pAd)&0xf8) << 8;
					DBGPRINT(RT_DEBUG_OFF, ("Addr45 = %4x\n", Addr45));
					rtmp_ee_flash_write(pAd, 0x08, Addr45);
				}
			
				if ((rtmp_ee_flash_read(pAd, 0, &i) != 0x2880) && (rtmp_ee_flash_read(pAd, 0, &i) != 0x2860))
				{
					DBGPRINT(RT_DEBUG_ERROR, ("Set_EECMD_Proc: invalid eeprom\n"));
					return FALSE;
				}
			}
			break;
		case 2:
			{
				USHORT offset, value = 0;
				PUCHAR p;
				
				p = arg+2;
				offset = simple_strtol(p, 0, 10);
				p+=2;
				while (*p != '\0')
				{
					if (*p >= '0' && *p <= '9')
						value = (value << 4) + (*p - 0x30);
					else if (*p >= 'a' && *p <= 'f')
						value = (value << 4) + (*p - 0x57);
					else if (*p >= 'A' && *p <= 'F')
						value = (value << 4) + (*p - 0x37);
					p++;
				}
				RT28xx_EEPROM_WRITE16(pAd, offset, value);
			}
			break;
		default:
			break;
	}

	return TRUE;
}
#endif // LINUX //
#endif


#if 0
static BOOLEAN  validFlashEepromID(RTMP_ADAPTER *pAd)
{
	USHORT eeFlashId;
	int listIdx;
	
	rtmp_ee_flash_read(pAd, 0, &eeFlashId);
	for(listIdx =0 ; listIdx < EE_FLASH_ID_NUM; listIdx++)
	{
		if (eeFlashId == EE_FLASH_ID_LIST[listIdx])
			return TRUE;
	}
	return FALSE;
}
#endif


#if 0
static NDIS_STATUS rtmp_ee_flash_init(PRTMP_ADAPTER pAd, PUCHAR start)
{
	init_flag = 1;
	nv_ee_start = start;

//	if (validFlashEepromID(pAd) == FALSE)
	{
//		if (rtmp_ee_flash_reset(start) != NDIS_STATUS_SUCCESS)
//		{
//			DBGPRINT(RT_DEBUG_ERROR, ("rtmp_ee_init(): rtmp_ee_flash_init() failed\n"));
//			return NDIS_STATUS_FAILURE;
//		}

		// Random number for the last bytes of MAC address
		{
			USHORT  Addr45;
			
			rtmp_ee_flash_read(pAd, 0x08, &Addr45);
			Addr45 = Addr45 & 0xff;
			Addr45 = Addr45 | (RandomByte(pAd)&0xf8) << 8;
		
			rtmp_ee_flash_write(pAd, 0x08, Addr45);
		}

		if (validFlashEepromID(pAd) == FALSE)
		{

			DBGPRINT(RT_DEBUG_ERROR, ("rtmp_ee_flash_init(): invalid eeprom\n"));
			return NDIS_STATUS_FAILURE;
		}
	}
	
	return NDIS_STATUS_SUCCESS;
}
#endif


NDIS_STATUS rtmp_nv_init(PRTMP_ADAPTER pAd)
{
	UCHAR eepromBuf[EEPROM_SIZE];
	unsigned char mac_addr[6] = {0x00, 0xff, 0x11, 0x66, 0x88, 0x88};
        RTMP_ADAPTER *pAdapter = NULL;
        int i;

#if MODEL_IPC1000W || MODEL_IPC1000WI || MODEL_TVIP651W || MODEL_TVIP651WI
        EeBuffer[0x6e] = 0xc5;
        EeBuffer[0x6f] = 0xb0;
        EeBuffer[0x70] = 0xa7;
        EeBuffer[0x71] = 0x98;
        EeBuffer[0x72] = 0x80;
        EeBuffer[0x73] = 0x68;
        EeBuffer[0x74] = 0x52;
        EeBuffer[0x75] = 0x3d;
        EeBuffer[0x76] = 0x28;
        EeBuffer[0x77] = 0x01;

        EeBuffer[0xde] = 0x88;
        EeBuffer[0xdf] = 0x88;
        EeBuffer[0xe0] = 0xcc;
        EeBuffer[0xe1] = 0xcc;
        EeBuffer[0xe2] = 0xaa;
        EeBuffer[0xe3] = 0x88;
        EeBuffer[0xe4] = 0xcc;
        EeBuffer[0xe5] = 0xcc;
        EeBuffer[0xe6] = 0xaa;
        EeBuffer[0xe7] = 0x88;
        EeBuffer[0xe8] = 0xcc;
        EeBuffer[0xe9] = 0xcc;
        EeBuffer[0xea] = 0xaa;
        EeBuffer[0xeb] = 0x88;
        EeBuffer[0xec] = 0xcc;
        EeBuffer[0xed] = 0xcc;
        EeBuffer[0xee] = 0xaa;
        EeBuffer[0xef] = 0x88;
        printk("***** Init GLM-300 RF/MAC data *****\n");
#endif
#if MODEL_TVIP551W || MODEL_TVIP551WI
        EeBuffer[0x6e] = 0xd0;
        EeBuffer[0x6f] = 0xcd;
        EeBuffer[0x70] = 0xb0;
        EeBuffer[0x71] = 0xa0;
        EeBuffer[0x72] = 0x88;
        EeBuffer[0x73] = 0x80;
        EeBuffer[0x74] = 0x60;
        EeBuffer[0x75] = 0x48;
        EeBuffer[0x76] = 0x38;
        EeBuffer[0x77] = 0x01;

        printk("***** Init TV-IP551 RF/MAC data *****\n");
#endif

        printk("***** Init RF/MAC data from flash memory *****\n");
	NdisZeroMemory(eepromBuf, EEPROM_SIZE);
	RtmpFlashRead(eepromBuf, RF_OFFSET, EEPROM_SIZE);
        if((eepromBuf[0] != 0x50) || (eepromBuf[1] != 0x30))
        {
            printk("***** Invalid RF/MAC data on flash memory!!! *****\n");
       	    NdisMoveMemory(eepromBuf, EeBuffer, EEPROM_SIZE); 
            memcpy(&(eepromBuf[0x04]), mac_addr, 6);            /* wlan mac location 0x04 */
            RtmpFlashWrite(eepromBuf, RF_OFFSET, EEPROM_SIZE);  /* Write default to Flash */ 
            printk("***** Write default RF/MAC data on flash memory!!! *****\n");

	    NdisZeroMemory(eepromBuf, EEPROM_SIZE);
	    RtmpFlashRead(eepromBuf, RF_OFFSET, EEPROM_SIZE);
            if((eepromBuf[0] != 0x50) || (eepromBuf[1] != 0x30))
            {
                printk("***** Cannot write default RF/MAC data to flash memory!!! *****\n");
       	        NdisMoveMemory(eepromBuf, EeBuffer, EEPROM_SIZE);           
                mac_addr[5] = RandomByte(pAd);
                memcpy(&(eepromBuf[0x04]), mac_addr, 6);   
            } 
        }
        else	//Update changed data to EEPROM (don't update -- mac address, country code, Freq. offset and TX0 power, web language
        {
            if(eepromBuf[0x02] != 0xff)					    //if version is 0xff --> don't change EEPROM content
            {
                if(eepromBuf[0x39] == 0xff)
                    eepromBuf[0x39] = 0x05;				    //if country code is 0xff (undefined) -> set default to 0x05 (ch1 - 14)
                if(eepromBuf[0x1af] == 0xff)
                    eepromBuf[0x1af] = 0x00;				    //if web language is 0xff (undefined) -> set default to 0x00 (English)
                NdisMoveMemory(&(EeBuffer[0x04]) ,&(eepromBuf[0x04]), 6);   //mac address
     	        NdisMoveMemory(&(EeBuffer[0x39]) ,&(eepromBuf[0x39]), 1);   //country code
     	        NdisMoveMemory(&(EeBuffer[0x3a]) ,&(eepromBuf[0x3a]), 1);   //Freq. offset 
                NdisMoveMemory(&(EeBuffer[0x52]) ,&(eepromBuf[0x52]), 14);  //TX0 Power
     	        NdisMoveMemory(&(EeBuffer[0x1af]) ,&(eepromBuf[0x1af]), 1); //web language
                for(i = 0; i < EEPROM_SIZE; i++)
                {
                    if(EeBuffer[i] == eepromBuf[i])
                        continue;
                    else
                    {
                        printk("***** Need to update new RF data on flash memory!!! *****\n");
       	                NdisMoveMemory(eepromBuf, EeBuffer, EEPROM_SIZE); 
                        RtmpFlashWrite(eepromBuf, RF_OFFSET, EEPROM_SIZE);  /* Write default to Flash */ 
                        printk("***** Write updated RF data on flash memory!!! *****\n");
                        break;
                    }
                } 
            }
        }

     	NdisMoveMemory(EeBuffer ,eepromBuf, EEPROM_SIZE); 

	init_flag = 1;
	nv_ee_start = EeBuffer;
       
	return NDIS_STATUS_SUCCESS;
}


void Setup_New_Mac(char *mac)
{
    printk("***** Setup Mac Address *****\n");
    RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
    memcpy(&(EeBuffer[0x04]), mac, 6);                  /* wlan mac location - 0x04 */
    RtmpFlashWrite(EeBuffer, RF_OFFSET, EEPROM_SIZE);

    RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
    if(memcmp(&(EeBuffer[0x04]), mac, 6))
        printk("***** Cannot write MAC address to flash memory!!! *****\n");
}


void Setup_Country_Region(char region)
{
    printk("***** Setup Country Region *****\n");
    RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
    EeBuffer[0x39] = region;                            /* country region location - 0x39 */
    RtmpFlashWrite(EeBuffer, RF_OFFSET, EEPROM_SIZE);

    RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
    if(EeBuffer[0x39] != region)
        printk("***** Cannot write Country Region flash memory!!! *****\n");
}

void Get_EEPROM_MAC(char *mac)
{
    RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
    memcpy(mac, &(EeBuffer[0x04]), 6);                  /* wlan mac location - 0x04 */
}

char Get_Country_Region(void)
{
    RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
    return (char)(EeBuffer[0x39]);
}

void Setup_ALC(char alc)
{
    if(alc)
    {
        printk("***** Enable ALC *****\n");
        RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
        EeBuffer[0x36] |= 2;                                       /* ALC - bit 1 of offset 0x36 */
        RtmpFlashWrite(EeBuffer, RF_OFFSET, EEPROM_SIZE);
	pGlobalAd->bAutoTxAgcA = pGlobalAd->bAutoTxAgcG = TRUE;    /* bAutoTxAgcG used on cmm_asic.c */
    }
    else
    {
        printk("***** Disable ALC *****\n");
        RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
        EeBuffer[0x36] &= ~(2);                                    /* ALC - bit 1 of offset 0x36 */
        RtmpFlashWrite(EeBuffer, RF_OFFSET, EEPROM_SIZE);
	pGlobalAd->bAutoTxAgcA = pGlobalAd->bAutoTxAgcG = FALSE;   /* bAutoTxAgcG used on cmm_asic.c */
    }
}

char get_web_language(void)
{
    char language;

    printk("***** Get Web Language *****\n");
    ra_mtd_read_nm("Config", 0x1800, 1, &language); 

    return language;

#if 0
    RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
    return (char)(EeBuffer[0x1af]);
#endif
}

void set_web_language(char language)
{
    char read_language;

    printk("***** Setup Web Language *****\n");
    ra_mtd_write_nm("Config", 0x1800, 1, &language); 	//system configuration "2860" is placed at offset 0x2000, don't overwrite this area -> see ralink doc. for configuration map
    ra_mtd_read_nm("Config", 0x1800, 1, &read_language); 

    if(read_language != language)
        printk("***** Cannot write Web Language flash memory!!! *****\n");

#if 0
    printk("***** Setup Web Language *****\n");
    RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
    EeBuffer[0x1af] = weblanguage;                            /* web language location - 0x1af */
    RtmpFlashWrite(EeBuffer, RF_OFFSET, EEPROM_SIZE);

    RtmpFlashRead(EeBuffer, RF_OFFSET, EEPROM_SIZE);
    if(EeBuffer[0x1af] != weblanguage)
        printk("***** Cannot write Web Language flash memory!!! *****\n");
#endif
}


void clear_uboot_para(int mode)
{
    char *clear_buf;
    long clear_len;

    if(mode == 0)	        //clear uboot parameter
    {
        printk("***** Clear Uboot Parameters *****\n");
        clear_len = 4*1024L;
    }
    else if(mode == 1)          //clear all config parameter
    {
        printk("***** Clear All Parameters *****\n");
        clear_len = 64*1024L;
    }
    else
    {
        printk("***** No Clear *****\n");
        return;
    }

    clear_buf = kmalloc(clear_len, GFP_ATOMIC);  
    if(clear_buf == NULL)
        return;

    memset(clear_buf, 0xff, clear_len);	                        

    ra_mtd_write_nm("Config", 0x0000, clear_len, clear_buf); 

    kfree(clear_buf);
}