/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright, Ralink Technology, Inc.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 ***************************************************************************
 */

#ifndef __RALINK_GPIO_H__
#define __RALINK_GPIO_H__

#include <asm/rt2880/rt_mmap.h>

#include "verdate.h"

#define SYSIF_DEV "/dev/gpio"

/*
 * ioctl commands
 */
#define	RALINK_GPIO_SET_DIR		0x01
#define RALINK_GPIO_SET_DIR_IN		0x11
#define RALINK_GPIO_SET_DIR_OUT		0x12
#define	RALINK_GPIO_READ		0x02
#define	RALINK_GPIO_WRITE		0x03
#define	RALINK_GPIO_SET			0x21
#define	RALINK_GPIO_CLEAR		0x31
#define	RALINK_GPIO_READ_BIT		0x04
#define	RALINK_GPIO_WRITE_BIT		0x05
#define	RALINK_GPIO_READ_BYTE		0x06
#define	RALINK_GPIO_WRITE_BYTE		0x07
#define	RALINK_GPIO_READ_INT		0x02 
#define	RALINK_GPIO_WRITE_INT		0x03 
#define	RALINK_GPIO_SET_INT		0x21 
#define	RALINK_GPIO_CLEAR_INT		0x31 
#define RALINK_GPIO_ENABLE_INTP		0x08
#define RALINK_GPIO_DISABLE_INTP	0x09
#define RALINK_GPIO_REG_IRQ		0x0A
#define RALINK_GPIO_LED_SET		0x41



#define	SYSIF_READ                      0x80
#define	SYSIF_WRITE             	0x81


/*
 * Address of RALINK_ Registers
 */
#define RALINK_SYSCTL_ADDR		RALINK_SYSCTL_BASE	
#define RALINK_REG_GPIOMODE		(RALINK_SYSCTL_ADDR + 0x60)
#define RALINK_REG_FW_MEMO_1		(RALINK_SYSCTL_ADDR + 0x68)
#define RALINK_REG_FW_MEMO_2		(RALINK_SYSCTL_ADDR + 0x6C)

#define RALINK_IRQ_ADDR			RALINK_INTCL_BASE
#define RALINK_REG_INTENA		(RALINK_IRQ_ADDR + 0x34)
#define RALINK_REG_INTDIS		(RALINK_IRQ_ADDR + 0x38)

#define RALINK_PRGIO_ADDR		RALINK_PIO_BASE 
#define RALINK_REG_PIOINT		(RALINK_PRGIO_ADDR + 0)
#define RALINK_REG_PIOEDGE		(RALINK_PRGIO_ADDR + 0x04)
#define RALINK_REG_PIORENA		(RALINK_PRGIO_ADDR + 0x08)
#define RALINK_REG_PIOFENA		(RALINK_PRGIO_ADDR + 0x0C)
#define RALINK_REG_PIODATA		(RALINK_PRGIO_ADDR + 0x20)
#define RALINK_REG_PIODIR		(RALINK_PRGIO_ADDR + 0x24)
#define RALINK_REG_PIOSET		(RALINK_PRGIO_ADDR + 0x2C)
#define RALINK_REG_PIORESET		(RALINK_PRGIO_ADDR + 0x30)
#define RALINK_REG_PIOTOGGLE		(RALINK_PRGIO_ADDR + 0x34)
#define RALINK_REG_PIO3924INT		(RALINK_PRGIO_ADDR + 0x38)
#define RALINK_REG_PIO3924EDGE		(RALINK_PRGIO_ADDR + 0x3C)
#define RALINK_REG_PIO3924RENA		(RALINK_PRGIO_ADDR + 0x40)
#define RALINK_REG_PIO3924FENA		(RALINK_PRGIO_ADDR + 0x44)
#define RALINK_REG_PIO3924DATA		(RALINK_PRGIO_ADDR + 0x48)
#define RALINK_REG_PIO3924DIR		(RALINK_PRGIO_ADDR + 0x4C)
#define RALINK_REG_PIO3924SET		(RALINK_PRGIO_ADDR + 0x54)
#define RALINK_REG_PIO3924RESET		(RALINK_PRGIO_ADDR + 0x58)
#define RALINK_REG_PIO3924TOGGLE	(RALINK_PRGIO_ADDR + 0x5C)
#define RALINK_REG_PIO5140INT		(RALINK_PRGIO_ADDR + 0x60)
#define RALINK_REG_PIO5140EDGE		(RALINK_PRGIO_ADDR + 0x64)
#define RALINK_REG_PIO5140RENA		(RALINK_PRGIO_ADDR + 0x68)
#define RALINK_REG_PIO5140FENA		(RALINK_PRGIO_ADDR + 0x6C)
#define RALINK_REG_PIO5140DATA		(RALINK_PRGIO_ADDR + 0x70)
#define RALINK_REG_PIO5140DIR		(RALINK_PRGIO_ADDR + 0x74)
#define RALINK_REG_PIO5140SET		(RALINK_PRGIO_ADDR + 0x7C)
#define RALINK_REG_PIO5140RESET		(RALINK_PRGIO_ADDR + 0x80)
#define RALINK_REG_PIO5140TOGGLE	(RALINK_PRGIO_ADDR + 0x84)


/*
 * Values for the GPIOMODE Register
 */
#ifdef CONFIG_RALINK_RT2880
#define RALINK_GPIOMODE_I2C		0x01
#define RALINK_GPIOMODE_UARTF		0x02
#define RALINK_GPIOMODE_SPI		0x04
#define RALINK_GPIOMODE_UARTL		0x08
#define RALINK_GPIOMODE_JTAG		0x10
#define RALINK_GPIOMODE_MDIO		0x20
#define RALINK_GPIOMODE_SDRAM		0x40
#define RALINK_GPIOMODE_PCI		0x80
#elif defined (CONFIG_RALINK_RT3052) || defined (CONFIG_RALINK_RT2883)
#define RALINK_GPIOMODE_I2C		0x01
#define RALINK_GPIOMODE_SPI		0x02
#define RALINK_GPIOMODE_UARTF		0x1C
#define RALINK_GPIOMODE_UARTL		0x20
#define RALINK_GPIOMODE_JTAG		0x40
#define RALINK_GPIOMODE_MDIO		0x80
#define RALINK_GPIOMODE_SDRAM		0x100
#define RALINK_GPIOMODE_RGMII		0x200
#endif



#define RALINK_GPIOMODE_DFT		(RALINK_GPIOMODE_UARTF)

/*
 * bit is the unit of length
 */
#define RALINK_GPIO_NUMBER		24
#define RALINK_GPIO_DATA_MASK		0x000000FF 
#define RALINK_GPIO_DATA_LEN		24
#define RALINK_GPIO_DIR_IN		0
#define RALINK_GPIO_DIR_OUT		1
#define RALINK_GPIO_DIR_ALLIN		0
#define RALINK_GPIO_DIR_ALLOUT		0x00FFFFFF

/*
 * structure used at regsitration
 */
typedef struct {
	unsigned int irq;		
	pid_t pid;			
} ralink_gpio_reg_info;

#define RALINK_GPIO_LED_LOW_ACT		1
#define RALINK_GPIO_LED_INFINITY	4000
typedef struct {
	int gpio;			
	unsigned int on;		
	unsigned int off;		
	unsigned int blinks;		
	unsigned int rests;		
	unsigned int times;		
} ralink_gpio_led_info;


#define RALINK_GPIO_0			0x00000001
#define RALINK_GPIO_1			0x00000002
#define RALINK_GPIO_2			0x00000004
#define RALINK_GPIO_3			0x00000008
#define RALINK_GPIO_4			0x00000010
#define RALINK_GPIO_5			0x00000020
#define RALINK_GPIO_6			0x00000040
#define RALINK_GPIO_7			0x00000080
#define RALINK_GPIO_8			0x00000100
#define RALINK_GPIO_9			0x00000200
#define RALINK_GPIO_10			0x00000400
#define RALINK_GPIO_11			0x00000800
#define RALINK_GPIO_12			0x00001000
#define RALINK_GPIO_13			0x00002000
#define RALINK_GPIO_14			0x00004000
#define RALINK_GPIO_15			0x00008000
#define RALINK_GPIO_16			0x00010000
#define RALINK_GPIO_17			0x00020000
#define RALINK_GPIO_18			0x00040000
#define RALINK_GPIO_19			0x00080000
#define RALINK_GPIO_20			0x00100000
#define RALINK_GPIO_21			0x00200000
#define RALINK_GPIO_22			0x00400000
#define RALINK_GPIO_23			0x00800000
#define RALINK_GPIO(x)			(1 << x)








#define BUF_LEN_SHIFT	        15    
#define SUBCMD_IDX_SHIFT	8     


#define SYSINFO_MODEL		0x01  
#define SYSINFO_COMPANY         0x02  
#define SYSINFO_VERSION		0x03  
#define SYSINFO_DATE		0x04  
#define SYSINFO_MODEL_DESC	0x05  
#define SYSINFO_COMPANY_URL	0x06  
#define SYSINFO_HW_VERSION	0x07  
#define SYSINFO_ROM_VERSION	0x08  
#define SYSINFO_SERVER_STATUS	0x09  
#define SYSINFO_PROTOCOL	0x0a  
#define USER1_SIG_FLAG          0x0b  
#define USER2_SIG_FLAG          0x0c  
#define USER_SIG_PID            0x0d  
#define ETHERNET_LINK           0x0e  
#define ETHERNET_SPEED          0x0f  
#define ETHERNET_DUPLEX         0x10  
#define FRAME_LIST_INIT		0x11  
#define FRAME_READY_LIST_Q      0x12  
#define FRAME_GET_IMAGE         0x13  
#define FRAME_RELEASE_IMAGE     0x14  
#define FRAME_BUFFER_SIZE       0x15  
#define FRAME_VIDEO_SIZE        0x16  
#define WIRELESS_SUPPORT	0x17  
#define PTZ_SUPPORT             0x18  
#define MAC_ADDRESS		0x19  
#define FTP_TEST_RESULT         0x1a  
#define EMAIL_TEST_RESULT       0x1b  
#define DDNS_STATUS             0x1c  
#define UPNP_IP			0x1d  
#define CURRENT_IP		0x1e  
#define CURRENT_SUBNET_MASK	0x1f  
#define CURRENT_DEFAULT_GATEWAY 0x20  
#define CURRENT_DNS1		0x21  
#define CURRENT_DNS2		0x22  
#define WLAN_LINK_STATUS	0x23  
#define WLAN_LINK_SSID		0x24  
#define	WLAN_LINK_AP_MAC	0x25  
#define	WLAN_LINK_CHANNEL	0x26  
#define WLAN_LINK_TX_RATE	0x27  
#define WLAN_LINK_ENCRYPTION	0x28  
#define DOWNLOAD_STATUS     	0x29  
#define DOWNLOAD_MESSAGE	0x2a  
#define START_SITE_SURVEY       0x2b  
#define	GET_SITE_SURVEY		0x2c  
#define WIRELESS_ON_OFF		0x2d  
#define DDNS_MESSAGE            0x2e  
#define ACTIVE_USER_TABLE	0x2f  
#define ADD_ACTIVE_USER         0x30  
#define GET_ACTIVE_USER         0x31  
#define DEL_ACTIVE_USER         0x32  
#define ACTIVE_USER_AUDIO_ON    0x33  
#define ACTIVE_USER_AUDIO_OFF   0x34  
#define LED_CONTROL             0x35  
#define QUEUE_AUDIO_DATA        0x36  
#define ACTIVE_USER_KEEP_ALIVE  0x37  
#define READ_EVENT_FLAG         0x38  
#define SET_EVENT_FLAG          0x39  
#define CLEAR_EVENT_FLAG        0x3a  
#define PPPOE_IP	        0x3b  
#define PPPOE_SUBNET_MASK	0x3c  
#define SYSINFO_VERSION_BUILD	0x3d  
#define MOTION_DETECTION_STATUS 0x3e  
#define SET_MAC_ADDRESS         0x3f  
#define BOOTINFO_SIGNATURE      0x40  
#define LED_OPERATION           0x41  
#define REBOOT_TIME             0x42  
#define SET_QC_TEST		0x43  
#define WLAN_CHANNEL_LIST       0x44  
#define COUNTRY_REGION          0x45  
#define ACTIVE_USER_NUMBER      0x46  
#define PORT_FORWARDING_STATUS  0x47  
#define MANUAL_FTP_EMAIL_STATE  0x48  
#define SET_DAY_NIGHT_MODE      0x49  
#define IR_LED_ON_OFF		0x4a  
#define WLAN_ALC                0x4b  
#define SET_EMAIL_FRAME_TIME    0x4c  
#define EMAIL_GET_QUEUE_FRAME   0x4d  
#define PPPOE_STATE		0x4e  
#define WEB_LANGUAGE            0x4f  
#define AUTO_IP			0x50  
#define DHCP_STATE		0x51  
#define CLEAR_UBOOT_PARAMETER   0x52  






#define USER2_SIG_RESTART       0x00000001
#define USER2_SIG_FACTORY_RESET	0x00000002      
#define USER2_SIG_DOWN_WLAN     0x00000004
#define USER2_SIG_UP_WLAN       0x00000008
#define USER2_SIG_WPS           0x00000010
#define USER2_SIG_DOWN_UP_WLAN  0x00000020
#define USER2_SIG_PING          0x00000040


#define SCH_USER1_SIG_MOTION_DETECTED    0x00000001
#define SCH_USER1_SIG_MOTION_ENDED       0x00000002
#define FTP_USER1_SIG_MOTION_DETECTED    0x00000004
#define FTP_USER1_SIG_MOTION_ENDED       0x00000008
#define MAIL_USER1_SIG_MOTION_DETECTED   0x00000010
#define MAIL_USER1_SIG_MOTION_ENDED      0x00000020
#define SCH_USER1_SIG_MANUAL_FTP_ON      0x00000040
#define SCH_USER1_SIG_MANUAL_FTP_OFF     0x00000080
#define SCH_USER1_SIG_MANUAL_EMAIL_ON    0x00000100
#define SCH_USER1_SIG_MANUAL_EMAIL_OFF   0x00000200
 

#define IPUSH_USER1_SIG_MOTION_DETECTED  0x00000001
#define IPUSH_USER1_SIG_MOTION_ENDED     0x00000002
#define IPUSH_USER1_SIG_VIDEO_CONFIG     0x00000004


#define PTZ_USER1_SIG_PRIVACY            0x00000001


#define PUSH_BUTTON_1_IRQ	0       
#define PUSH_BUTTON_2_IRQ	10	
#define WPS_LED			13      
#define POWER_LED		8       
#define LINK_LED                9       
#define LIGHT_SENSOR_IN         11      
#define IR_LED_OUT_1            12      
#define IR_LED_OUT_2            14      
#define HW_ID_1                 1       
#define HW_ID_2                 2       
#define CHIP_RESET              7       
#define PRIVACY_BUTTON		20	


#define EVENT_FTP_CONFIG        0x0001      
#define EVENT_EMAIL_CONFIG      0x0002      
#define EVENT_VIEW_FTP_ON       0x0004      
#define	EVENT_VIEW_FTP_OFF      0x0008      
#define EVENT_IMAGE_CONFIG	0x0010      
#define EVENT_AUDIO_CONFIG      0x0020      
#define EVENT_VIDEO_CONFIG_IN   0x0040      
#define EVENT_VIDEO_CONFIG_OUT  0x0080      
#define EVENT_VIDEO_CONFIG_SCH  0x0100      
#define EVENT_UDP_CONFIG        0x0200      
#define EVENT_EMAIL_TEST        0x0400      
#define EVENT_FTP_TEST          0x0800      
#define EVENT_MOTION_DETECTED   0x1000      
#define EVENT_MOTION_ENDED      0x2000      
#define EVENT_MOTION_CONFIG     0x4000      
#define EVENT_MYDLINK_CONFIG    0x8000      
#define EVENT_WPS_CONFIG        0x00010000  
#define EVENT_TFTP_UPLOAD       0x00020000  
#define EVENT_SEND_EMAIL        0x00040000  
#define	EVENT_VIEW_EMAIL_ON     0x00080000  
#define	EVENT_VIEW_EMAIL_OFF    0x00100000  
#define EVENT_IR_LED_CHANGE     0x00200000  
#define EVENT_DAY_NIGHT_CONFIG  0x00400000  


struct AUDIODATA
{
   struct AUDIODATA *pNextAudio;
   unsigned long myaddr;
   unsigned short mymark;
   short  AudioLen;
   char   AudioData;
};

#define USER_NAME_LENGTH        12  
#define MAX_USER_NUMBER		64  
struct ACTIVEUSER
{
   unsigned long  Pid;				
   short          Keep_Alive;			
   unsigned long  IpAddress;
   char           Name[USER_NAME_LENGTH];
   unsigned long  StartViewTime;                
   short          AudioVideo;                   
   short          AudioOnOff;			
   unsigned long  AudioDataLen;			
   struct AUDIODATA *pAudio;                    
};

#define MAX_AP_NUMBER   	64
struct SCAN_TABLE
{
   short channel;                 
   char  ssid[33];
   char  apmac[6];
   short encryption;              
   short signal;
   char  mode[8];                 
   short type;                    
};

struct USER_PID
{
   short process;     
   unsigned long pid;
};

struct USER_SIG_FLAG
{
   short process;     
   unsigned long sig_flag;
};

#define MAX_ACTIVE_VIDEO_USER		10 
#define MAX_ACTIVE_AUDIO_USER		10 
struct ACTIVE_USER_NUM
{
   short ActiveVideoUser;
   short ActiveAudioUser;
};

#endif
