/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright, Ralink Technology, Inc.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 ***************************************************************************
 *
 */
#include <linux/init.h>
#include <linux/version.h>
#include <linux/module.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/interrupt.h>
#include <linux/fs.h>
#ifdef CONFIG_RALINK_GPIO_LED
#include <linux/timer.h>
#endif
#include <linux/netdevice.h>
#include <linux/inetdevice.h>
#include <linux/spinlock.h> 
#include <linux/slab.h>
#include <asm/uaccess.h>
#include "ralink_gpio.h"
#include "frame.h"

#include <asm/rt2880/surfboardint.h>

#ifdef  CONFIG_DEVFS_FS
#include <linux/devfs_fs_kernel.h>
static  devfs_handle_t devfs_handle;
#endif

#define NAME			"ralink_gpio"
#define RALINK_GPIO_DEVNAME	"gpio"
int ralink_gpio_major = 252;
u32 ralink_gpio_intp = 0;
int ralink_gpio_irqnum = 0;
u32 ralink_gpio_edge = 0;
ralink_gpio_reg_info ralink_gpio_info[RALINK_GPIO_NUMBER];
extern unsigned long volatile jiffies;
#ifdef CONFIG_RALINK_GPIO_LED
#define RALINK_LED_DEBUG 0
#define RALINK_GPIO_LED_FREQ (HZ/10)     //HZ == 100 (100/second)
struct timer_list ralink_gpio_led_timer;
ralink_gpio_led_info ralink_gpio_led_data[RALINK_GPIO_NUMBER];
u32 ralink_gpio_led_value = 0;
struct ralink_gpio_led_status_t {
	int ticks;
	unsigned int ons;
	unsigned int offs;
	unsigned int resting;
	unsigned int times;
} ralink_gpio_led_stat[RALINK_GPIO_NUMBER];
#endif

MODULE_DESCRIPTION("Ralink SoC GPIO Driver");
MODULE_AUTHOR("Winfred Lu <winfred_lu@ralinktech.com.tw>");
MODULE_LICENSE("GPL");
ralink_gpio_reg_info info;


///////////////////////////////////////////////////////////////
//Need to move these data to private code area
#ifdef MODEL_DCS930          //DCS-930
char *CopyRight              = "Copyright (c) 2010 Alpha Networks Inc.";
char *MyModel	             = "DCS-930";
char *MyCompany              = "D-Link";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet Camera";
char *MyCompanyURL           = "http://www.dlink.com";
#endif

#ifdef MODEL_DCS930L         //DCS-930L
char *CopyRight              = "Copyright (c) 2010 Alpha Networks Inc.";
char *MyModel	             = "DCS-930L";
char *MyCompany              = "D-Link";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet Camera";
char *MyCompanyURL           = "http://www.dlink.com";
#endif

#ifdef MODEL_DCS932          //DCS-932
char *CopyRight              = "Copyright (c) 2010 Alpha Networks Inc.";
char *MyModel	             = "DCS-932";
char *MyCompany              = "D-Link";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet Camera";
char *MyCompanyURL           = "http://www.dlink.com";
#endif

#ifdef MODEL_DCS932L         //DCS-932L
char *CopyRight              = "Copyright (c) 2010 Alpha Networks Inc.";
char *MyModel	             = "DCS-932L";
char *MyCompany              = "D-Link";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet Camera";
char *MyCompanyURL           = "http://www.dlink.com";
#endif

#ifdef MODEL_IPC1000W        //IPC-1000W
#ifdef TRENDNET
char *CopyRight              = "Copyright (c) 2010 Alpha Networks Inc.";
char *MyModel	             = "IPC1000W";
char *MyCompany              = "KEEBOX";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet Camera";
char *MyCompanyURL           = "http://www.trendnet.com";
#endif
#ifdef ALPHA
char *CopyRight              = "Copyright (c) 2010 Alpha Networks Inc.";
char *MyModel	             = "Wireless Internet Camera";
char *MyCompany              = "";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet Camera";
char *MyCompanyURL           = "";
#endif
#endif

#ifdef MODEL_IPC1000WI       //IPC-1000WI
#ifdef TRENDNET
char *CopyRight              = "Copyright (c) 2010 Alpha Networks Inc.";
char *MyModel	             = "IPC1000WI";
char *MyCompany              = "KEEBOX";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet IR Camera";
char *MyCompanyURL           = "http://www.trendnet.com";
#endif
#ifdef ALPHA
char *CopyRight              = "Copyright (c) 2010 Alpha Networks Inc.";
char *MyModel	             = "Wireless Internet IR Camera";
char *MyCompany              = "";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet IR Camera";
char *MyCompanyURL           = "";
#endif
#endif

#ifdef MODEL_TVIP551W        //TV-IP551W
char *CopyRight              = "Copyright (c) 2011 Alpha Networks Inc.";
char *MyModel	             = "TV-IP551W";
char *MyCompany              = "TRENDnet";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet Camera";
char *MyCompanyURL           = "http://www.trendnet.com";
#endif

#ifdef MODEL_TVIP551WI       //TV-IP551WI
char *CopyRight              = "Copyright (c) 2011 Alpha Networks Inc.";
char *MyModel	             = "TV-IP551WI";
char *MyCompany              = "TRENDnet";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet IR Camera";
char *MyCompanyURL           = "http://www.trendnet.com";
#endif

#ifdef MODEL_TVIP651W        //TV-IP651W
char *CopyRight              = "Copyright (c) 2011 Alpha Networks Inc.";
char *MyModel	             = "TV-IP651W";
char *MyCompany              = "TRENDnet";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet Camera";
char *MyCompanyURL           = "http://www.trendnet.com";
#endif

#ifdef MODEL_TVIP651WI       //TV-IP651WI
char *CopyRight              = "Copyright (c) 2011 Alpha Networks Inc.";
char *MyModel	             = "TV-IP651WI";
char *MyCompany              = "TRENDnet";
unsigned long MyVersionBuild = MY_FW_VERSION;
char *MyReleaseVersion       = MY_FW_VERSION_ASCII;
char *MyReleaseDate          = RELEASE_DATE;
char *MyModelDesc            = "Wireless Internet IR Camera";
char *MyCompanyURL           = "http://www.trendnet.com";
#endif

///////////////////////////////////////////////////////////////
unsigned long HWVersion = 0x41312020; //A1
unsigned long ROMVersion = 0x00000000; //0.00 --> will be initized
unsigned short ServerStatus = 0;
unsigned short ServerProtocol = 0xeae2; //bit10-9: Flash Size - 00(see bit5), 01:4M, 10:8M, 11:16M //bit8: Version - 0:A1, 1:A2 //Others bit same old definition.
unsigned long User1SigFlag = 0;         //defined at ralink_gpio.h //nvram_daemon
unsigned long User2SigFlag = 0;         //defined at ralink_gpio.h //nvram_daemon
unsigned long UserSigPid = 0;                                      //nvram_daemon
unsigned short lan_link = 0;            //0:down, 1:up
unsigned short lan_speed = 0;           //0:10M, 1:100M, 2:1000M
unsigned short lan_duplex = 0;          //0:half, 1:full
unsigned long FrameBufferSize;          //frame buffer size (not include frame header)
unsigned long FrameVideoSize = 0;       //jpeg size
short OnFlashWrite = 0;                 //who set it?????
unsigned short Resolution = 1;
unsigned short Compression = 2;
unsigned short FrameRate = 0;
short Wireless_Support = 1;
short PTZ_Support = 0;
char My_MAC[6];
short FTP_TestResult = 0;
short EMAIL_TestResult = 0;
short DDNS_Status = 0;
long UPNP_IP_Addr = 0;
long Current_IP_Addr = 0;
long Current_Subnet_Mask = 0;
long Current_Default_Gateway = 0;
long Current_DNS1 = 0;
long Current_DNS2 = 0;
short WLAN_Link_Status = 0;
char WLAN_Link_SSID[33];
char WLAN_Link_AP_MAC[6];
short WLAN_Link_Channel;
short WLAN_Link_Tx_Rate;
short WLAN_Link_Encryption;
struct ACTIVEUSER Active_User_Table[MAX_USER_NUMBER];
short Download_Status = 0;      /* 0: success, -1: downloading, others: fail */
short Download_Message = 0;
struct SCAN_TABLE ScanTable[MAX_AP_NUMBER];
short WirelessDisable = 0;
char DDNS_Message[128];
short LED_Control = -1;  	/* 0: Normal, 1: Off, 2: Dummy */
unsigned long event_flag = 0;
unsigned long pppoe_ip = 0;
unsigned long pppoe_subnet = 0;
unsigned long motion_status = 0;  /* 0: no motion, 1: on motion */
unsigned long schedule_pid = 0;
unsigned long schedule_user1_sigflag = 0;
unsigned long schedule_user2_sigflag = 0;
unsigned long ipush_user1_sigflag = 0;
unsigned long ipush_user2_sigflag = 0;
unsigned long ftp_pid = 0;
unsigned long ftp_user1_sigflag = 0;
unsigned long ftp_user2_sigflag = 0;
unsigned long mail_pid = 0;
unsigned long mail_user1_sigflag = 0;
unsigned long mail_user2_sigflag = 0;
unsigned long ptz_pid = 0;
unsigned long ptz_user1_sigflag = 0;
unsigned long ptz_user2_sigflag = 0;
char bootcode_signature[64];
short power_led_indicator = 0; /* 0 normal, 1 reset, 2 download, 3 test power led, 4 test link led, 5 test wps led */
short test_mode = 0;           /* 0 normal, 1 test lan, 2 test wlan */
short on_qctest = 0;
short TotalVideoUser = 0;
short TotalAudioUser = 0;
struct ACTIVE_USER_NUM ActiveUserNum;
short upnp_port_forwarding = 0;
short manual_ftpemail_state = 0;
short daynight_mode = 0;
short ir_led_onoff = 0;
short email_frame_queue_interval = 0;    //0: email 6 frame mode is disable, 1: 0.5 second, 1: 1 second
short pppoe_state = 0;			 //0: processing, 1: authentication, 2: cannot find modem, others: error
char weblanguage = 0;  //0:English, 1:Chinese (Simplified), 2:Chinese (Traditional), 3:German, 4:French, 5:Italian, 6:Spanish
unsigned long autoip = 0;
short dhcpstate = 0;   //0: disable, 1: request, 2: got ip address


extern void Get_Wlan_Link_Status(short *);
extern void Get_Wlan_Link_SSID(char *);
extern void Get_Wlan_Link_AP_MAC(char *);
extern void Get_Wlan_Link_Channel(short *);
extern void Get_Wlan_Link_Tx_Rate(short *);
extern void Get_Wlan_Link_Encryption(short *);
extern void StartSiteSurvey(void);
extern void GetSiteSurvey(struct SCAN_TABLE *);
extern void Setup_New_Mac(char *mac);
extern unsigned short get_channel_list(void);
extern void DisableLan(void);
extern void EnableLan(void);
extern char Get_Country_Region(void);
extern void Setup_Country_Region(char region);
extern void Get_EEPROM_MAC(char *);
extern char get_web_language(void);
extern void set_web_language(char);
extern void restore_configured_ssid(char *configured_ssid);

void Send_User2_Sig_Down_Wlan(void);
void Send_User2_Sig_Up_Wlan(void); 
void set_ir_event_flag(void); 
struct FRM *Get_Email_Frame_Queue(unsigned long);

short DebugReadyCnt = 0;
short DebugTimeCnt = 0;
short DebugGetCnt = 0;
short DebugReadyCnt30 = 0;
short DebugStartReadyCnt30 = 0;
short DebugTimes = 0;
unsigned long DebugImgLen = 0;
unsigned long DebugImgLenNow = 0;

spinlock_t mr_lock = SPIN_LOCK_UNLOCKED;
int have_rx_tx = 0;
int set_ir_led = 0;
int ir_led_t3sec = 0;
u32 Old_LightSensorStatus = 0xffffffffL;
int t3sec_cnt = 0;
int light_sensor_status_changed = 0;
int email_frame_queue_timer = 0;
int queue_email_frame = 0;
struct FRM *pEmailFRMQueue[3];
char EmailFrameQueue[1024L * 72L * 3L];   //reserve 72K*3bytes for email frame queue
unsigned long q_sequence_num = 0xffffffffL;
unsigned long pppoe_find_modem = 0;
int WlanEnableForSiteSurvey = 0;
char configured_ssid[33];
int tvip651_wps_led = 0;
 

int ralink_gpio_ioctl(struct inode *inode, struct file *file, unsigned int req,
		unsigned long arg)
{
	unsigned long idx, tmp;
	ralink_gpio_reg_info info;
	ralink_gpio_led_info led;
        struct FrameInfo FrmInfo;
        struct FRM *pFRM, FRM_Header;
        unsigned long buf_len, img_len, audio_len;
        unsigned long cmd;
        unsigned long seq_num;
        unsigned short ticks_interval;
        struct FRAME *pFrame;
	struct net_device *pTargetNetDev = NULL;
        struct in_device *in_dev;
        struct in_ifaddr *ifa;
        int i;
        struct ACTIVEUSER *pUser, User, *pU;
        unsigned long user_pid, user_ip;
        unsigned long flags;
        struct AUDIODATA *pA, *pNextA, *pBuf;
        int found;
        char *pABuf;
        struct task_struct *p = NULL;
        struct USER_PID u_pid;
        struct USER_SIG_FLAG user_sigflag;
        char new_mac[6];
        unsigned long fw_memo_1, fw_memo_2;
        char reboottime[8];
        unsigned short channellist;
        char region, alc;
        short tmp_short;
        
 
        cmd = req;
	idx = (req >> RALINK_GPIO_DATA_LEN) & 0xFFL;
	req &= RALINK_GPIO_DATA_MASK;

	switch(req) {
	case SYSIF_READ:
                idx = (cmd >> SUBCMD_IDX_SHIFT) & 0x7FL;      //7 bit
                buf_len = (cmd >> BUF_LEN_SHIFT) & 0x1FFFFL;  //17 bit
#if 0
if(idx != 0x38)
{
printk("[READ]\n");
printk("idx=%x\n", idx);
}
#endif
                switch(idx)
                {
                    case SYSINFO_MODEL:
                         copy_to_user((int __user *)arg, MyModel, strlen(MyModel)+1);
                         break;
                    case SYSINFO_COMPANY:
                         copy_to_user((int __user *)arg, MyCompany, strlen(MyCompany)+1);
                         break;
                    case SYSINFO_VERSION:
                         copy_to_user((int __user *)arg, MyReleaseVersion, strlen(MyReleaseVersion)+1);
                         break;
                    case SYSINFO_DATE:
                         copy_to_user((int __user *)arg, MyReleaseDate, strlen(MyReleaseDate)+1);
                         break;
                    case SYSINFO_MODEL_DESC:
                         copy_to_user((int __user *)arg, MyModelDesc, strlen(MyModelDesc)+1);
                         break;
                    case SYSINFO_COMPANY_URL:
                         copy_to_user((int __user *)arg, MyCompanyURL, strlen(MyCompanyURL)+1);
                         break;
                    case SYSINFO_HW_VERSION:
                         copy_to_user((int __user *)arg, &HWVersion, 4);
                         break;
                    case SYSINFO_ROM_VERSION:
                         copy_to_user((int __user *)arg, &ROMVersion, 4);
                         break;
                    case SYSINFO_SERVER_STATUS:
                         copy_to_user((int __user *)arg, &ServerStatus, 2);
                         break;
                    case SYSINFO_PROTOCOL:
                         copy_to_user((int __user *)arg, &ServerProtocol, 2);
                         break;
                     case USER1_SIG_FLAG:
                         copy_from_user(&user_sigflag, (int __user *)arg, sizeof(struct USER_SIG_FLAG));
#if DEBUG_MOTION_DETECTION
printk("**************Get Sig Flag -- process = %x\n", user_sigflag.process);
#endif
                         if(user_sigflag.process == 1)         /* nvram_daemon */
                             user_sigflag.sig_flag = User1SigFlag;     
                         else if(user_sigflag.process == 2)    /* schedule */
                             user_sigflag.sig_flag = schedule_user1_sigflag;                         
                         else if(user_sigflag.process == 3)    /* ipush */
                             user_sigflag.sig_flag = ipush_user1_sigflag; 
                         else if(user_sigflag.process == 4)    /* ftp */
                         {
                             user_sigflag.sig_flag = ftp_user1_sigflag;
#if DEBUG_MOTION_DETECTION
                             printk("ftp sig flag = %x\n", user_sigflag.sig_flag);
#endif
                         }
                         else if(user_sigflag.process == 5)    /* mail */
                         {
                             user_sigflag.sig_flag = mail_user1_sigflag;   
#if DEBUG_MOTION_DETECTION
                             printk("mail sig flag = %x\n", user_sigflag.sig_flag);
#endif
                         }    
                         else if(user_sigflag.process == 6)    /* ptz */
                         {
                             user_sigflag.sig_flag = ptz_user1_sigflag;   
#if DEBUG_MOTION_DETECTION
                             printk("ptz sig flag = %x\n", user_sigflag.sig_flag);
#endif
                         }                                            
                         copy_to_user((int __user *)arg, &user_sigflag, sizeof(struct USER_SIG_FLAG));
                         break;
                     case USER2_SIG_FLAG:
                         copy_from_user(&user_sigflag, (int __user *)arg, sizeof(struct USER_SIG_FLAG));
                         if(user_sigflag.process == 1)         /* nvram_daemon */
                             user_sigflag.sig_flag = User2SigFlag;     
                         else if(user_sigflag.process == 2)    /* schedule */
                             user_sigflag.sig_flag = schedule_user2_sigflag;                         
                         else if(user_sigflag.process == 3)    /* ipush */
                             user_sigflag.sig_flag = ipush_user2_sigflag;    
                         else if(user_sigflag.process == 4)    /* ftp */
                             user_sigflag.sig_flag = ftp_user2_sigflag;
                         else if(user_sigflag.process == 5)    /* mail */
                             user_sigflag.sig_flag = mail_user2_sigflag; 
                         else if(user_sigflag.process == 6)    /* ptz */
                             user_sigflag.sig_flag = ptz_user2_sigflag;                          
                         copy_to_user((int __user *)arg, &user_sigflag, sizeof(struct USER_SIG_FLAG));
                         break;
                     case ETHERNET_LINK:
                         copy_to_user((int __user *)arg, &lan_link, 2);
                         break;
                     case ETHERNET_SPEED:
                         copy_to_user((int __user *)arg, &lan_speed, 2);
                         break;
                     case ETHERNET_DUPLEX:
                         copy_to_user((int __user *)arg, &lan_duplex, 2);
                         break;
                     case FRAME_BUFFER_SIZE:
                         copy_to_user((int __user *)arg, &FrameBufferSize, 4);
                         break;
                     case FRAME_VIDEO_SIZE:
                         copy_to_user((int __user *)arg, &FrameVideoSize, 4);
                         break;
                     case WIRELESS_SUPPORT:
                         copy_to_user((int __user *)arg, &Wireless_Support, 2);
                         break;
                     case PTZ_SUPPORT:
#if MODEL_TVIP651W || MODEL_TVIP651WI
			 PTZ_Support = 1;
#endif
                         copy_to_user((int __user *)arg, &PTZ_Support, 2);
                         break;
                     case MAC_ADDRESS:
                         copy_to_user((int __user *)arg, My_MAC, 6);
                         break;
                     case FTP_TEST_RESULT:
                         copy_to_user((int __user *)arg, &FTP_TestResult, 2);
                         break;
                     case EMAIL_TEST_RESULT:
                         copy_to_user((int __user *)arg, &EMAIL_TestResult, 2);
                         break;
                     case DDNS_STATUS:
                         copy_to_user((int __user *)arg, &DDNS_Status, 2);
                         break;
                     case UPNP_IP:
                         UPNP_IP_Addr = 0;
                 	 pTargetNetDev = dev_get_by_name("br0"); 
                         if(pTargetNetDev)
                         {
                             if(pTargetNetDev->ip_ptr)
                             {
                                 in_dev = pTargetNetDev->ip_ptr;
                                 if(in_dev->ifa_list)
                                 {
                                     ifa = in_dev->ifa_list;
                                     UPNP_IP_Addr = ifa->ifa_address;
                                 }
                             }
                         }
//printk("UPNP_IP=%x\n", UPNP_IP_Addr); 
                         copy_to_user((int __user *)arg, &UPNP_IP_Addr, 4);
                         break;
                     case CURRENT_IP:
                         Current_IP_Addr = 0;
                 	 pTargetNetDev = dev_get_by_name("br0");  
                         if(pTargetNetDev)
                         {
                             if(pTargetNetDev->ip_ptr)
                             {
                                 in_dev = pTargetNetDev->ip_ptr;
                                 if(in_dev->ifa_list)
                                 {
                                     ifa = in_dev->ifa_list;
                                     Current_IP_Addr = ifa->ifa_address;
                                 }
                             }
                         }
//printk("CURRENT_IP=%x\n", Current_IP_Addr);
                         copy_to_user((int __user *)arg, &Current_IP_Addr, 4);
                         break;
                    case CURRENT_SUBNET_MASK:
                         Current_Subnet_Mask = 0;
                 	 pTargetNetDev = dev_get_by_name("br0");  
                         if(pTargetNetDev)
                         {
                             if(pTargetNetDev->ip_ptr)
                             {
                                 in_dev = pTargetNetDev->ip_ptr;
                                 if(in_dev->ifa_list)
                                 {
                                     ifa = in_dev->ifa_list;
                                     Current_Subnet_Mask = ifa->ifa_mask;
                                 }
                             }
                         }
//printk("CURRENT_SUBNET_MASK=%x\n", Current_Subnet_Mask); 
                         copy_to_user((int __user *)arg, &Current_Subnet_Mask, 4);
                         break;
                    case CURRENT_DEFAULT_GATEWAY:
//printk("CURRENT_DEFAULT_GATEWAY=%x\n", Current_Default_Gateway); 
                         copy_to_user((int __user *)arg, &Current_Default_Gateway, 4);
                         break;
                    case CURRENT_DNS1:
//printk("CURRENT_DNS1=%x\n", Current_DNS1); 
                         copy_to_user((int __user *)arg, &Current_DNS1, 4);
                         break;
                    case CURRENT_DNS2:
//printk("CURRENT_DNS2=%x\n", Current_DNS2); 
                         copy_to_user((int __user *)arg, &Current_DNS2, 4);
                         break;
                    case WLAN_LINK_STATUS:
                         Get_Wlan_Link_Status(&WLAN_Link_Status);
                         copy_to_user((int __user *)arg, &WLAN_Link_Status, 2);
                         break;
                    case WLAN_LINK_SSID:
//                       memset(WLAN_Link_SSID, 0, 33);
                         Get_Wlan_Link_SSID(WLAN_Link_SSID);
                         copy_to_user((int __user *)arg, WLAN_Link_SSID, 32);
                         break;
                    case WLAN_LINK_AP_MAC:
//                       memset(WLAN_Link_AP_MAC, 0, 6);
                         Get_Wlan_Link_AP_MAC(WLAN_Link_AP_MAC);
                         copy_to_user((int __user *)arg, WLAN_Link_AP_MAC, 6);
                         break;
                    case WLAN_LINK_CHANNEL:
                         Get_Wlan_Link_Channel(&WLAN_Link_Channel);
                         copy_to_user((int __user *)arg, &WLAN_Link_Channel, 2);
                         break;
                    case WLAN_LINK_TX_RATE:
                         Get_Wlan_Link_Tx_Rate(&WLAN_Link_Tx_Rate);
                         copy_to_user((int __user *)arg, &WLAN_Link_Tx_Rate, 2);
                         break;
                    case WLAN_LINK_ENCRYPTION:
                         Get_Wlan_Link_Encryption(&WLAN_Link_Encryption);
                         copy_to_user((int __user *)arg, &WLAN_Link_Encryption, 2);
                         break;
                    case DOWNLOAD_STATUS:
                         copy_to_user((int __user *)arg, &Download_Status, 2);
                         break;
                    case DOWNLOAD_MESSAGE:
                         copy_to_user((int __user *)arg, &Download_Message, 2);
                         break;
                    case GET_SITE_SURVEY:
//                       GetSiteSurvey(ScanTable);
                         if(WlanEnableForSiteSurvey)
                         {
                             WlanEnableForSiteSurvey = 0;
                             restore_configured_ssid(configured_ssid);
                             WirelessDisable = 1;
                             Send_User2_Sig_Down_Wlan();
                         }
                         copy_to_user((int __user *)arg, ScanTable, sizeof(struct SCAN_TABLE) * MAX_AP_NUMBER);
                         break;
                    case DDNS_MESSAGE:
                         copy_to_user((int __user *)arg, DDNS_Message, 128);
                         break;
                    case ACTIVE_USER_TABLE:
                         copy_to_user((int __user *)arg, Active_User_Table, sizeof(struct ACTIVEUSER) * MAX_USER_NUMBER);
#if 1
                         pUser = Active_User_Table;
                         for(i = 0; i < MAX_USER_NUMBER; i++)
                         {
                             if(pUser->Pid == 0)
                             {
                                 pUser++;
                                 continue;
                             }
                             printk("user: %s\n", pUser->Name);
                             pUser++;
                         }
                         printk("**********************\n");
#endif
                         break;
                    case GET_ACTIVE_USER:
                         copy_from_user(&User, (int __user *)arg, sizeof(struct ACTIVEUSER));
                         user_pid = User.Pid;
                         found = 0;
                         pUser = Active_User_Table;
                         for(i = 0; i < MAX_USER_NUMBER; i++)
                         {
                             if(pUser->Pid == user_pid)
                             {
                                 spin_lock_irqsave(&mr_lock, flags);
	                         pU = (struct ACTIVEUSER *)kmalloc(buf_len, GFP_ATOMIC);  //Need to use GFP_ATOMIC -- Because No Sleep
	                         if(pU == NULL)
                                 {
                                      spin_unlock_irqrestore(&mr_lock, flags);
                                      printk("Get Audio -- No Buffer!\n");
                                      break;
                                 }

                                 found = 1;
                                 audio_len = 0;
                                 memcpy(pU, pUser, sizeof(struct ACTIVEUSER));

                                 pABuf = (char *)(pU + 1);
                                 buf_len -= sizeof(struct ACTIVEUSER);
                                 if(pUser->pAudio == NULL)
                                 {
                                     spin_unlock_irqrestore(&mr_lock, flags);
                                     break;
                                 }

                                 pA = pUser->pAudio;
//                               while(buf_len >= pA->AudioLen)
                                 if(buf_len >= pA->AudioLen)     	//get one block (1024 bytes) each time -- let audio packet always 1k per packet                      
                                 {
                                     memcpy(pABuf, &(pA->AudioData), pA->AudioLen);

                                     pABuf += pA->AudioLen;
                                     buf_len -= pA->AudioLen;
                                     audio_len += pA->AudioLen;

                                     pUser->AudioDataLen -= pA->AudioLen;
                                     pUser->pAudio = pA->pNextAudio;
                                     if(pA->myaddr != (unsigned long)pA)
                                         printk("????? Invalid Audio Buffer 3 - %x %x ?????\n", (unsigned long)pA, pA->mymark);
                                     pA->myaddr = 0;
                                     pA->mymark = 0;
                                     kfree(pA);
                                     if(pUser->pAudio == NULL)
                                         break;
                                     pA = pUser->pAudio;
                                 }

                                 spin_unlock_irqrestore(&mr_lock, flags);                        
                                 break;
                             }
                             pUser++;
                         }

                         if(found)
                         {

//if((audio_len != 1024) && (audio_len != 0))
//   printk("get audio len = %d\n", audio_len);

                             pU->AudioDataLen = audio_len;
                             copy_to_user((int __user *)arg, pU, sizeof(struct ACTIVEUSER) + audio_len);
                             kfree(pU);
                         }
                         else
                         {
                             User.Pid = 0;
                             User.AudioDataLen = 0;
                             copy_to_user((int __user *)arg, &User, sizeof(struct ACTIVEUSER));
                         }
                         break;
                    case READ_EVENT_FLAG:
                         copy_to_user((int __user *)arg, &event_flag, 4);
                         break;
                    case PPPOE_IP:
                         copy_to_user((int __user *)arg, &pppoe_ip, 4);
                         break;
                    case PPPOE_SUBNET_MASK:
                         copy_to_user((int __user *)arg, &pppoe_subnet, 4);
                         break;
                    case SYSINFO_VERSION_BUILD:
                         copy_to_user((int __user *)arg, &MyVersionBuild, 4);
                         break;
                    case MOTION_DETECTION_STATUS:
                         copy_to_user((int __user *)arg, &motion_status, 4);
                         break;
                    case SET_MAC_ADDRESS:	//READ MAC FROM EEPROM
                         Get_EEPROM_MAC(new_mac);
                         copy_to_user((int __user *)arg, new_mac, 6);
                         break;
                    case BOOTINFO_SIGNATURE:
                         copy_to_user((int __user *)arg, bootcode_signature, 64);
                         break;
                    case LED_OPERATION:
                         copy_to_user((int __user *)arg, &power_led_indicator, 2);
                         break;
                    case REBOOT_TIME:
	                 fw_memo_1 = le32_to_cpu(*(volatile u32 *)(RALINK_REG_FW_MEMO_1));
	                 fw_memo_2 = le32_to_cpu(*(volatile u32 *)(RALINK_REG_FW_MEMO_2));
                         memcpy(&(reboottime[0]), &fw_memo_1, 4);
                         memcpy(&(reboottime[4]), &fw_memo_2, 4);
                         copy_to_user((int __user *)arg, reboottime, 8);
                         break;
                    case WLAN_CHANNEL_LIST:
                         channellist = get_channel_list();
                         copy_to_user((int __user *)arg, &channellist, 2); 
                         break;
                    case COUNTRY_REGION:
                         region = Get_Country_Region();
                         copy_to_user((int __user *)arg, &region, 1);  
                         break;  
                    case ACTIVE_USER_NUMBER:
                         ActiveUserNum.ActiveVideoUser = TotalVideoUser;
                         ActiveUserNum.ActiveAudioUser = TotalAudioUser;
                         copy_to_user((int __user *)arg, &ActiveUserNum, sizeof(struct ACTIVE_USER_NUM));  
                         break;  
                    case PORT_FORWARDING_STATUS:
                         copy_to_user((int __user *)arg, &upnp_port_forwarding, 2);
                         break; 
                    case MANUAL_FTP_EMAIL_STATE:
                         copy_to_user((int __user *)arg, &manual_ftpemail_state, 2);
                         break; 
                    case IR_LED_ON_OFF:
                         copy_to_user((int __user *)arg, &ir_led_onoff, 2);
                         break; 
                    case PPPOE_STATE:
                         if((pppoe_state == 2) && (pppoe_find_modem <= (6*10))) //6 seconds
                             tmp_short = 0;					//processing
                         else
                             tmp_short = pppoe_state;                         
                         copy_to_user((int __user *)arg, &tmp_short, 2);
printk("get pppoe state = %d\n", tmp_short);
                         break; 
                    case WEB_LANGUAGE:
                         weblanguage = get_web_language();
                         copy_to_user((int __user *)arg, &weblanguage, 1);
                         break; 
                    case AUTO_IP:
                         copy_to_user((int __user *)arg, &autoip, 4);
                         break; 
                    case DHCP_STATE:
                         copy_to_user((int __user *)arg, &dhcpstate, 2);
                         break; 
                    default:
                         break;
                } 
#if 0
if(idx != 0x38)
{
printk("[READ-End]\n");
}
#endif
	        break;
        case SYSIF_WRITE:
                idx = (cmd >> SUBCMD_IDX_SHIFT) & 0x7FL;     //7bit
                buf_len = (cmd >> BUF_LEN_SHIFT) & 0x1FFFFL; //17bit
#if 0
if((idx != 0x12) && (idx != 0x36))
{
printk("[WRITE]\n");
printk("idx=%x\n", idx);
}
#endif
                switch(idx)
                {
                    case USER_SIG_PID:
                         copy_from_user(&u_pid, (int __user *)arg, sizeof(struct USER_PID));
                         if(u_pid.process == 1)      //nvram_daemon
                             UserSigPid = u_pid.pid;
                         else if(u_pid.process == 2) //schedule
                             schedule_pid = u_pid.pid;
                         else if(u_pid.process == 3) //reserved
                             ;
                         else if(u_pid.process == 4) //ftp
                         {
                             ftp_pid = u_pid.pid;
#if DEBUG_MOTION_DETECTION
printk("FTP PID = %x\n", ftp_pid);
#endif
                         }
                         else if(u_pid.process == 5) //mail
                         {
                             mail_pid = u_pid.pid;
#if DEBUG_MOTION_DETECTION
printk("MAIL PID = %x\n", mail_pid);
#endif
                         }
                         else if(u_pid.process == 6) //ptz
                         {
                             ptz_pid = u_pid.pid;
#if DEBUG_MOTION_DETECTION
printk("MAIL PID = %x\n", ptz_pid);
#endif
                         }
                         break;
                    case FRAME_LIST_INIT:
                         copy_from_user(&FrmInfo, (int __user *)arg, sizeof(struct FrameInfo));
                         Resolution = FrmInfo.FrmReso;
                         Compression = FrmInfo.FrmComp;
                         FrameRate = FrmInfo.FrmRate;
                         FrameBufferSize = Frame_List_Init();
                         break;
                    case FRAME_READY_LIST_Q:
                         pFRM = Frame_Empty_List_DeQueue(); 
                         if(!pFRM)
                         {
                             pFRM = Frame_Ready_List_DeQueue();
                         } 
                         if(pFRM)
                         {
                             if(buf_len <= FrameBufferSize)
                             {
                                 pFrame = (struct FRAME *)pFRM;
                                 copy_from_user(&(pFrame->Frame_Data), (int __user *)arg, buf_len);
                                 pFRM->frame_len = buf_len-1;   
                                 pFRM->frame_flag = 0;
                                 pABuf = &(pFrame->Frame_Data);
                                 if(pABuf[buf_len-1] & IS_MOTION_FRAME)
                                     pFRM->frame_flag |= IS_MOTION_FRAME; 
                                 Frame_Ready_List_Queue(pFRM);
                                 DebugReadyCnt++;
                                 DebugImgLenNow = buf_len;
                             }
                             else
                             {
                                 printk("Invalid image size!!!\n");
                             }
                         }
                         else
                         {
                             printk("Frame queue error!\n");
                             Release_All_Lock_Frame();
                         }

                         if(queue_email_frame)
                         {
                             queue_email_frame = 0;

                             pFRM = pEmailFRMQueue[0];
                             pEmailFRMQueue[0] =  pEmailFRMQueue[1];
                             pEmailFRMQueue[1] =  pEmailFRMQueue[2];
                             pEmailFRMQueue[2] =  pFRM;

                             if(buf_len <= (1024L * 72L))
                             {
                                 pFrame = (struct FRAME *)pFRM;
                                 copy_from_user(&(pFrame->Frame_Data), (int __user *)arg, buf_len);
                                 pFRM->frame_len = buf_len-1; 
                                 q_sequence_num++;
                                 if(q_sequence_num == 0xffffffffL)
                                     q_sequence_num = 0; 
                                 pFRM->sequence_num = q_sequence_num;  
                              }
                             else
                             {
                                 printk("Invalid image size 1!!!\n");
                             }
                         }
                         break;
                    case FRAME_GET_IMAGE:
                         copy_from_user(&FRM_Header, (int __user *)arg, sizeof(struct FRM));
                         seq_num = FRM_Header.sequence_num;
                         ticks_interval = FRM_Header.ticks_interval;
                         pFRM = Frame_Get_Image(seq_num, ticks_interval, FRM_Header.frame_flag);

                         spin_lock_irqsave(&mr_lock, flags);
                         if(pFRM)
                         {
                             img_len = pFRM->frame_len;
                             if(img_len <= buf_len)
                             { 
                                 copy_to_user((int __user *)arg, pFRM, sizeof(struct FRM)+img_len);
                                 DebugGetCnt++;
                                 if(img_len >= DebugImgLen)
                                 {
//                                   printk("ImgLen=%d\n", img_len);
                                     DebugImgLen = img_len;
                                 }
                             }
                             else
                             {
                                 printk("Invalid image buffer size!!!\n");
                                 FRM_Header.frame_len = 0;
                                 copy_to_user((int __user *)arg, &FRM_Header, sizeof(struct FRM));
                             }
                         }
                         else
                         {
                             FRM_Header.frame_len = 0;
                             copy_to_user((int __user *)arg, &FRM_Header, sizeof(struct FRM));
                         }
                         spin_unlock_irqrestore(&mr_lock, flags);
                         break;
                    case FRAME_RELEASE_IMAGE:
                         copy_from_user(&FRM_Header, (int __user *)arg, sizeof(struct FRM));
                         pFRM = (struct FRM *)(FRM_Header.my_buffer_addr);

                         if(pFRM)	//andy
                         {
                             if(pFRM->my_buffer_addr != (unsigned long)pFRM)
                             {
                                 printk("Frame_release_image error (1)\n");
	                         return 1;		/* error input */
                             }
                         }
                         else
                         {
                             printk("Frame_release_image error (2)\n");
	                     return 1;		/* error input */
                         }

                         pFRM->frame_flag = FRM_Header.frame_flag;
                         Frame_Release_Image(pFRM);
                         break;
                    case FTP_TEST_RESULT:
                         copy_from_user(&FTP_TestResult, (int __user *)arg, 2);
                         break;
                    case EMAIL_TEST_RESULT:
                         copy_from_user(&EMAIL_TestResult, (int __user *)arg, 2);
                         break;
                    case DDNS_STATUS:
                         copy_from_user(&DDNS_Status, (int __user *)arg, 2);
                         break;
                    case UPNP_IP:
                         copy_from_user(&UPNP_IP_Addr, (int __user *)arg, 4);
//printk("SET UPNP_IP:%x\n",UPNP_IP_Addr); 
                         break;
                    case CURRENT_IP:
                         copy_from_user(&Current_IP_Addr, (int __user *)arg, 4);
//printk("SET CURRENT_IP:%x\n",Current_IP_Addr);
                         break;
                    case CURRENT_SUBNET_MASK:
                         copy_from_user(&Current_Subnet_Mask, (int __user *)arg, 4);
//printk("SET CURRENT_SUBNET_MASK:%x\n",Current_Subnet_Mask);
                         break;
                    case CURRENT_DEFAULT_GATEWAY:
                         copy_from_user(&Current_Default_Gateway, (int __user *)arg, 4);
                         break;
                    case CURRENT_DNS1:
                         copy_from_user(&Current_DNS1, (int __user *)arg, 4);
//printk("SET CURRENT_DNS1=%x\n", Current_DNS1);
                         break;
                    case CURRENT_DNS2:
                         copy_from_user(&Current_DNS2, (int __user *)arg, 4);
//printk("SET CURRENT_DNS2=%x\n", Current_DNS2);
                         break;
                    case DOWNLOAD_STATUS:
                         copy_from_user(&Download_Status, (int __user *)arg, 2);
                         break;
                    case DOWNLOAD_MESSAGE:
                         copy_from_user(&Download_Message, (int __user *)arg, 2);
                         break;
                    case START_SITE_SURVEY:
//                       memset(ScanTable, 0, sizeof(struct SCAN_TABLE) * MAX_AP_NUMBER); //Clear table for new site survey
                         StartSiteSurvey();
                         break;
                    case WIRELESS_ON_OFF:
                         copy_from_user(&WirelessDisable, (int __user *)arg, 2);
                         if(WirelessDisable)
                         {
                             memset(ScanTable, 0, sizeof(struct SCAN_TABLE) * MAX_AP_NUMBER); //Clear table if wireless is disabled
                         }
                         WlanEnableForSiteSurvey = 0;	
                         break;
                    case DDNS_MESSAGE:
                         memset(DDNS_Message, 0, 128);
                         copy_from_user(DDNS_Message, (int __user *)arg, 128);
                         break;
                    case ADD_ACTIVE_USER:                        
                         copy_from_user(&User, (int __user *)arg, sizeof(struct ACTIVEUSER));

                         if((User.AudioVideo == 1) && (TotalAudioUser >= MAX_ACTIVE_AUDIO_USER))       //check audio user > max number
                         {
                             User.Keep_Alive = 0;
                             copy_to_user((int __user *)arg, &User, sizeof(struct ACTIVEUSER));
                         }
                         else if((User.AudioVideo != 1) && (TotalVideoUser >= MAX_ACTIVE_VIDEO_USER))  //check video user > max number
                         {
                             User.Keep_Alive = 0;
                             copy_to_user((int __user *)arg, &User, sizeof(struct ACTIVEUSER));
                         }
                         else
                         {
                             pUser = Active_User_Table;
                             for(i = 0; i < MAX_USER_NUMBER; i++)
                             {
                                 if(pUser->Pid == 0)
                                 {
                                     spin_lock_irqsave(&mr_lock, flags);
                                     copy_from_user(pUser, (int __user *)arg, sizeof(struct ACTIVEUSER));
                                     pUser->Keep_Alive = 1;
                                     if(pUser->AudioVideo == 1) /* AUDIO */
                                     {
                                         pUser->AudioOnOff = 1;
                                         pUser->AudioDataLen = 0;
                                         pUser->pAudio = NULL;
                                         TotalAudioUser++;
                                     }
                                     else
                                     {
                                         TotalVideoUser++;
                                     }
                                     spin_unlock_irqrestore(&mr_lock, flags);
#if 0
                                     printk("add user: %s\n", pUser->Name);
#endif
                                     break;
                                 }
                                 pUser++;
                             }
                         }
                         break;
                    case DEL_ACTIVE_USER:
                         copy_from_user(&user_pid, (int __user *)arg, 4);
                         pUser = Active_User_Table;
                         for(i = 0; i < MAX_USER_NUMBER; i++)
                         {
                             if(pUser->Pid == user_pid)
                             {
                                 spin_lock_irqsave(&mr_lock, flags);
                                 pUser->Pid = 0;
                                 if(pUser->AudioVideo == 1) /* AUDIO */
                                 {
                                     pA = pUser->pAudio;
                                     while(pA)
                                     {
                                         pNextA = pA->pNextAudio;
                                         if(pA->myaddr != (unsigned long)pA)
                                             printk("????? Invalid Audio Buffer 4 - %x %x ?????\n", (unsigned long)pA, pA->mymark);
                                         pA->myaddr = 0;
                                         pA->mymark = 0;
                                         kfree(pA);
                                         pA = pNextA;
                                     }
                                     TotalAudioUser--;
                                 }
                                 else
                                 {
                                     TotalVideoUser--;
                                 }
                                 spin_unlock_irqrestore(&mr_lock, flags);
#if 0
                                 printk("del user: %s\n", pUser->Name);
#endif
                                 break;
                             }
                             pUser++;
                         }
                         break;
                    case ACTIVE_USER_AUDIO_ON:
                         copy_from_user(&user_ip, (int __user *)arg, 4);
                         pUser = Active_User_Table;
                         for(i = 0; i < MAX_USER_NUMBER; i++)
                         {
                             if((pUser->Pid) && (pUser->IpAddress == user_ip) && (pUser->AudioVideo == 1))
                             {
                                 pUser->AudioOnOff = 1;  /* On */
                             }
                             pUser++;
                         }
                         break;
                    case ACTIVE_USER_AUDIO_OFF:
                         copy_from_user(&user_ip, (int __user *)arg, 4);
                         pUser = Active_User_Table;
                         for(i = 0; i < MAX_USER_NUMBER; i++)
                         {
                             if((pUser->Pid) && (pUser->IpAddress == user_ip) && (pUser->AudioVideo == 1))
                             {
                                 pUser->AudioOnOff = 0;  /* Off */
                             }
                             pUser++;
                         }
                         break;
                    case LED_CONTROL:
                         copy_from_user(&LED_Control, (int __user *)arg, 2);
                         break;
                    case QUEUE_AUDIO_DATA:
                         pUser = Active_User_Table;
                         for(i = 0; i < MAX_USER_NUMBER; i++)
                         {
                             if((pUser->Pid) && (pUser->AudioVideo == 1))  /* Audio User */
                             {
                                 if(pUser->AudioDataLen > (1024*128))      /* Too much audio data not yet get from process */
                                 {
//                                    printk("Queue Audio -- Too Much!\n");

                                      spin_lock_irqsave(&mr_lock, flags);
                                      pA = pUser->pAudio;
                                      while(pA)
                                      {
                                          pNextA = pA->pNextAudio;
                                          if(pA->myaddr != (unsigned long)pA)
                                              printk("????? Invalid Audio Buffer 5 - %x %x ?????\n", (unsigned long)pA, pA->mymark);
                                          pA->myaddr = 0;
                                          pA->mymark = 0;
                                          kfree(pA);
                                          pA = pNextA;
                                      }
                                      pUser->pAudio = NULL;
                                      pUser->AudioDataLen = 0;
                                      spin_unlock_irqrestore(&mr_lock, flags);

                                      pUser++;
                                      continue;
                                 }

//if(buf_len != 1024)
//   printk("queue audio len = %d\n", buf_len);

                                 spin_lock_irqsave(&mr_lock, flags);
	                         pBuf = (struct AUDIODATA *)kmalloc(sizeof(struct AUDIODATA) + buf_len, GFP_ATOMIC); //Need to use GFP_ATOMIC -- Because No Sleep
	                         if(pBuf == NULL)
                                 {
                                      spin_unlock_irqrestore(&mr_lock, flags);
                                      printk("Queue Audio -- No Buffer!\n");
                                      break;
                                 }

                                 pBuf->pNextAudio = NULL;
                                 pBuf->myaddr = (unsigned long)pBuf;
                                 pBuf->mymark = 0x5a5a;
                                 pBuf->AudioLen = buf_len;
                                 copy_from_user(&(pBuf->AudioData), (int __user *)arg, buf_len);

                                 if(pUser->pAudio == NULL)
                                 {
                                     pUser->pAudio = pBuf;
                                 }
                                 else
                                 {
                                     pA = pUser->pAudio;
                                     if(pA->myaddr != (unsigned long)pA)
                                         printk("????? Invalid Audio Buffer 1 - %x %x ?????\n", (unsigned long)pA, pA->mymark);
                                     while(pA->pNextAudio)
                                     {
                                         pA = pA->pNextAudio;
                                         if(pA->myaddr != (unsigned long)pA)
                                             printk("????? Invalid Audio Buffer 2 - %x %x ?????\n", (unsigned long)pA, pA->mymark);
                                     }  

                                     pA->pNextAudio = pBuf;
                                 }
                                 pUser->AudioDataLen += buf_len;
 
                                 spin_unlock_irqrestore(&mr_lock, flags);
                             }                            
                             pUser++;
                         }               
                         break;
                    case ACTIVE_USER_KEEP_ALIVE:
                         copy_from_user(&user_pid, (int __user *)arg, 4);
                         pUser = Active_User_Table;
                         for(i = 0; i < MAX_USER_NUMBER; i++)
                         {
                             if(pUser->Pid == user_pid)
                             {
                                 pUser->Keep_Alive++;
                                 break;
                             }
                             pUser++;
                         }
                         break;
                    case SET_EVENT_FLAG:
                         copy_from_user(&tmp, (int __user *)arg, 4);
                         event_flag |= tmp;
//printk("EventFlag = %x\n", event_flag);

#if DEBUG_MOTION_DETECTION
if(tmp == EVENT_MOTION_CONFIG)
    printk("*** SET EVENT_MOTION_CONFIG ***\n");
#endif

                         if(event_flag & EVENT_VIDEO_CONFIG_OUT)
                         {
                             event_flag &= (~EVENT_VIDEO_CONFIG_OUT);

                             pUser = Active_User_Table;
                             for(i = 0; i < MAX_USER_NUMBER; i++)
                             {
                                 if((pUser->Pid) && ((pUser->AudioVideo == 0) || (pUser->AudioVideo == 2)))  /* Video User (0), Motion Video User (2) */
                                 {
                                     if((p = find_task_by_pid(pUser->Pid)) != NULL)
                                     {
                                         ipush_user1_sigflag = IPUSH_USER1_SIG_VIDEO_CONFIG;
//                                       printk("send SIGUSR1 (Video Changed) to pid %x\n", pUser->Pid);
                                         send_sig(SIGUSR1, p, 0);
                                     }
                                 }                            
                                 pUser++;
                             }
                         }

                         if(event_flag & EVENT_MOTION_DETECTED)
                         {
                             event_flag &= (~EVENT_MOTION_DETECTED);

//                           printk("Motion Detected\n");

                             pUser = Active_User_Table;
                             for(i = 0; i < MAX_USER_NUMBER; i++)
                             {
                                 if((pUser->Pid) && (pUser->AudioVideo == 2))  /* Motion Video User */
                                 {
                                     if((p = find_task_by_pid(pUser->Pid)) != NULL)
                                     {
                                         ipush_user1_sigflag = IPUSH_USER1_SIG_MOTION_DETECTED;
//                                       printk("send SIGUSR1 (Motion-Detected) to pid %x\n", pUser->Pid);
                                         send_sig(SIGUSR1, p, 0);
                                     }
                                 }                            
                                 pUser++;
                             }

#if 0
                             if((p = find_task_by_pid(schedule_pid)) != NULL)
                             {
                                 schedule_user1_sigflag = SCH_USER1_SIG_MOTION_DETECTED;
//                               printk("send SIGUSR1 (Motion-Detected) to pid %x\n", schedule_pid);
                                 send_sig(SIGUSR1, p, 0);
                             }
#endif 
#if 1 
                             if((p = find_task_by_pid(ftp_pid)) != NULL)
                             {
                                 ftp_user1_sigflag = FTP_USER1_SIG_MOTION_DETECTED;
#if DEBUG_MOTION_DETECTION
                             printk("send SIGUSR1 (Motion-Detected) to FTP - pid %x\n", ftp_pid);
#endif
                                 send_sig(SIGUSR1, p, 0);
                             } 
                             if((p = find_task_by_pid(mail_pid)) != NULL)
                             {
                                 mail_user1_sigflag = MAIL_USER1_SIG_MOTION_DETECTED;
#if DEBUG_MOTION_DETECTION
                             printk("send SIGUSR1 (Motion-Detected) to MAIL - pid %x\n", mail_pid);
#endif
                                 send_sig(SIGUSR1, p, 0);
                             }   
#endif
                         }

                         if(event_flag & EVENT_MOTION_ENDED)
                         {
                             event_flag &= (~EVENT_MOTION_ENDED);

//                           printk("Motion Ended\n");

                             pUser = Active_User_Table;
                             for(i = 0; i < MAX_USER_NUMBER; i++)
                             {
                                 if((pUser->Pid) && (pUser->AudioVideo == 2))  /* Motion Video User */
                                 {
                                     if((p = find_task_by_pid(pUser->Pid)) != NULL)
                                     {
                                         ipush_user1_sigflag = IPUSH_USER1_SIG_MOTION_ENDED;
//                                       printk("send SIGUSR1 (Motion-Ended) to pid %x\n", pUser->Pid);
                                         send_sig(SIGUSR1, p, 0);
                                     }
                                 }                            
                                 pUser++;
                             }

#if 0
                             if((p = find_task_by_pid(schedule_pid)) != NULL)
                             {
                                 schedule_user1_sigflag = SCH_USER1_SIG_MOTION_ENDED;
//                               printk("send SIGUSR1 (Motion-Ended) to pid %x\n", schedule_pid);
                                 send_sig(SIGUSR1, p, 0);
                             } 
#endif
#if 1 
                             if((p = find_task_by_pid(ftp_pid)) != NULL)
                             {
                                 ftp_user1_sigflag = FTP_USER1_SIG_MOTION_ENDED;
#if DEBUG_MOTION_DETECTION
                             printk("send SIGUSR1 (Motion-Ended) to FTP - pid %x\n", ftp_pid);
#endif
                                 send_sig(SIGUSR1, p, 0);
                             } 
                             if((p = find_task_by_pid(mail_pid)) != NULL)
                             {
                                 mail_user1_sigflag = MAIL_USER1_SIG_MOTION_ENDED;
#if DEBUG_MOTION_DETECTION
                             printk("send SIGUSR1 (Motion-Ended) to MAIL - pid %x\n", mail_pid);
#endif
                                 send_sig(SIGUSR1, p, 0);
                             }  
#endif 
                         }

                         if(event_flag & EVENT_VIEW_FTP_ON)  
                         {
                             event_flag &= (~EVENT_VIEW_FTP_ON);

                             if((p = find_task_by_pid(schedule_pid)) != NULL)
                             {
                                 schedule_user1_sigflag = SCH_USER1_SIG_MANUAL_FTP_ON;
                                 manual_ftpemail_state |= 1;	/* bit0: FTP state */
//                               printk("send SIGUSR1 (FTP On) to pid %x\n", schedule_pid);
                                 send_sig(SIGUSR1, p, 0);
                             }
                         }
                         if(event_flag & EVENT_VIEW_FTP_OFF) 
                         {
                             event_flag &= (~EVENT_VIEW_FTP_OFF);

                             if((p = find_task_by_pid(schedule_pid)) != NULL)
                             {
                                 schedule_user1_sigflag = SCH_USER1_SIG_MANUAL_FTP_OFF;
                                 manual_ftpemail_state &= (~1);	/* bit0: FTP state */
//                               printk("send SIGUSR1 (FTP Off) to pid %x\n", schedule_pid);
                                 send_sig(SIGUSR1, p, 0);
                             }
                         }
                         if(event_flag & EVENT_VIEW_EMAIL_ON)
                         {
                             event_flag &= (~EVENT_VIEW_EMAIL_ON);

                             if((p = find_task_by_pid(schedule_pid)) != NULL)
                             {
                                 schedule_user1_sigflag = SCH_USER1_SIG_MANUAL_EMAIL_ON;
                                 manual_ftpemail_state |= 2;	/* bit1: EMAIL state */
//                               printk("send SIGUSR1 (EMAIL On) to pid %x\n", schedule_pid);
                                 send_sig(SIGUSR1, p, 0);
                             }
                         }
                         if(event_flag & EVENT_VIEW_EMAIL_OFF)
                         {
                             event_flag &= (~EVENT_VIEW_EMAIL_OFF);

                             if((p = find_task_by_pid(schedule_pid)) != NULL)
                             {
                                 schedule_user1_sigflag = SCH_USER1_SIG_MANUAL_EMAIL_OFF;
                                 manual_ftpemail_state &= (~2);	/* bit1: EMAIL state */
//                               printk("send SIGUSR1 (EMAIL Off) to pid %x\n", schedule_pid);
                                 send_sig(SIGUSR1, p, 0);
                             }
                         }

                         break;
                    case CLEAR_EVENT_FLAG:
                         copy_from_user(&tmp, (int __user *)arg, 4);
                         event_flag &= (~tmp);

#if DEBUG_MOTION_DETECTION
if(tmp == EVENT_MOTION_CONFIG)
    printk("*** CLEAR EVENT_MOTION_CONFIG ***\n");
#endif

                         break;
                    case PPPOE_IP:
                         copy_from_user(&pppoe_ip, (int __user *)arg, 4);
                         if(pppoe_ip)
                         {
                             pppoe_state = 0;	//success
printk("got pppoe ip = %x\n", pppoe_ip);
                         }
                         break;
                    case PPPOE_SUBNET_MASK:
                         copy_from_user(&pppoe_subnet, (int __user *)arg, 4);
                         break;
                    case MOTION_DETECTION_STATUS:
                         copy_from_user(&motion_status, (int __user *)arg, 4);
                         break;
                    case SET_MAC_ADDRESS:
                         copy_from_user(new_mac, (int __user *)arg, 6);
                         Setup_New_Mac(new_mac);
                         break;
                    case LED_OPERATION:
                         copy_from_user(&power_led_indicator, (int __user *)arg, 2);
                         break;
                    case REBOOT_TIME:
                         copy_from_user(reboottime, (int __user *)arg, 8);
                         memcpy(&fw_memo_1, &(reboottime[0]), 4);
                         memcpy(&fw_memo_2, &(reboottime[4]), 4);
                         *(volatile u32 *)(RALINK_REG_FW_MEMO_1) = cpu_to_le32(fw_memo_1);
                         *(volatile u32 *)(RALINK_REG_FW_MEMO_2) = cpu_to_le32(fw_memo_2);
                         break;
                    case SET_QC_TEST:
                         copy_from_user(&test_mode, (int __user *)arg, 2);
                         if(test_mode == 0) 		//normal
                         {
                             EnableLan();
                         }
                         else if(test_mode == 1)        //test lan
                         {
                             on_qctest = 1;
                             Send_User2_Sig_Down_Wlan();
                         }
                         else if(test_mode == 2)        //test wlan
                         {
                             on_qctest = 1;
                             WirelessDisable = 0;
                             DisableLan();
                             Send_User2_Sig_Up_Wlan();  
                         }
                         break;
                    case COUNTRY_REGION:
                         copy_from_user(&region, (int __user *)arg, 1);
                         Setup_Country_Region(region);
                         break;
                    case PORT_FORWARDING_STATUS:
                         copy_from_user(&upnp_port_forwarding, (int __user *)arg, 2);
                         break;
                    case SET_DAY_NIGHT_MODE:
#if MODEL_DCS932 || MODEL_DCS932L || MODEL_IPC1000WI || MODEL_TVIP551WI || MODEL_TVIP651WI
                         copy_from_user(&daynight_mode, (int __user *)arg, 2);

                         if(daynight_mode == 0)  //Auto mode
                         {
                             Old_LightSensorStatus = 0xffffffffL;
                             t3sec_cnt = 0;
                             light_sensor_status_changed = 0;
                         }
                         if(daynight_mode == 1)  //Manual mode
                         {
                             ir_led_onoff = 0;   //Default set as Off
                             set_ir_led = 1;
                             ir_led_t3sec = 30;
                             set_ir_event_flag();
                         }
                         if(daynight_mode == 2)  //Day mode
                         {
                             ir_led_onoff = 0;
                             set_ir_led = 1;
                             ir_led_t3sec = 30;
                             set_ir_event_flag();
                         }
                         if(daynight_mode == 3)  //Night mode
                         {
                             ir_led_onoff = 1;
                             set_ir_led = 1;
                             ir_led_t3sec = 30;
                             set_ir_event_flag();
                         }
                         if(daynight_mode == 4)  //Schedule mode
                         {
                             ir_led_onoff = 0;   //Init set as Off
                             set_ir_led = 1;
                             ir_led_t3sec = 30;
                             set_ir_event_flag();
                         }
#endif
                         break;
                    case IR_LED_ON_OFF:
#if MODEL_DCS932 || MODEL_DCS932L || MODEL_IPC1000WI || MODEL_TVIP551WI || MODEL_TVIP651WI
                         if((daynight_mode == 1) || (daynight_mode == 4))	//Manual and Schedule mode
                         {
                             copy_from_user(&ir_led_onoff, (int __user *)arg, 2);
                             if(ir_led_onoff)
                             {
                                 ir_led_onoff = 1;
                             }
                             set_ir_led = 1;
                             ir_led_t3sec = 30;
                             set_ir_event_flag();
                         }
#endif
                         break;
                    case WLAN_ALC:
                         copy_from_user(&alc, (int __user *)arg, 1);
                         Setup_ALC(alc);
                         break;
                    case SET_EMAIL_FRAME_TIME:
                         copy_from_user(&email_frame_queue_interval, (int __user *)arg, 2);
                         break;
                    case EMAIL_GET_QUEUE_FRAME:
                         copy_from_user(&FRM_Header, (int __user *)arg, sizeof(struct FRM));
                         seq_num = FRM_Header.sequence_num;
                         pFRM = Get_Email_Frame_Queue(seq_num);

                         spin_lock_irqsave(&mr_lock, flags);
                         if(pFRM)
                         {
                             img_len = pFRM->frame_len;
                             if(img_len <= buf_len)
                             { 
                                 copy_to_user((int __user *)arg, pFRM, sizeof(struct FRM)+img_len);
                             }
                             else
                             {
                                 printk("Invalid image buffer size!!!\n");
                                 FRM_Header.frame_len = 0;
                                 copy_to_user((int __user *)arg, &FRM_Header, sizeof(struct FRM));
                             }
                         }
                         else
                         {
                             FRM_Header.frame_len = 0;
                             copy_to_user((int __user *)arg, &FRM_Header, sizeof(struct FRM));
                         }
                         spin_unlock_irqrestore(&mr_lock, flags);
                         break;
                    case PPPOE_STATE:
                         copy_from_user(&tmp_short, (int __user *)arg, 2);
                         if(tmp_short == 2)
                         {
                             pppoe_find_modem = 0;	//start find_modem counter
                         }
                         if(tmp_short == 16)		//clear to 0 command
                         {
                             pppoe_state = tmp_short = 0;
                             pppoe_find_modem = 0;	
                         }

                         if(pppoe_state == 2) 	 //modem not found -> other state
                         {
                             pppoe_state = tmp_short;
                             printk("set pppoe state = %d\n", pppoe_state);
                         }
                         else if(pppoe_state)    //have error code
                         {
                             /* don't change error state, state will be changed on SET PPPoE IP to 0 */
			     printk("set pppoe state = No Change\n");
                         }
                         else                   //processing/success -> other state
                         {
                             pppoe_state = tmp_short;
                             printk("set pppoe state = %d\n", pppoe_state);
                         }
                         break;
                    case WEB_LANGUAGE:
                         copy_from_user(&weblanguage, (int __user *)arg, 1);
                         set_web_language(weblanguage);
                         break;
                    case AUTO_IP:
                         copy_from_user(&autoip, (int __user *)arg, 4);
                         break;
                    case DHCP_STATE:
                         copy_from_user(&dhcpstate, (int __user *)arg, 2);
printk("Set DHCP State = %d\n", dhcpstate);
                         break;
                    case CLEAR_UBOOT_PARAMETER:
                         copy_from_user(&tmp_short, (int __user *)arg, 2);
                         clear_uboot_para(tmp_short);
                         break;
                    default:
                        break;
                } 
#if 0
if((idx != 0x12) && (idx != 0x36))
{
printk("[WRITE-End]\n");
}
#endif
	        break;
	case RALINK_GPIO_SET_DIR:
		*(volatile u32 *)(RALINK_REG_PIODIR) = cpu_to_le32(arg);
		break;
	case RALINK_GPIO_SET_DIR_IN:
		tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODIR));
		tmp &= ~cpu_to_le32(arg);
		*(volatile u32 *)(RALINK_REG_PIODIR) = tmp;
		break;
	case RALINK_GPIO_SET_DIR_OUT:
		tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODIR));
		tmp |= cpu_to_le32(arg);
		*(volatile u32 *)(RALINK_REG_PIODIR) = tmp;
		break;
	case RALINK_GPIO_READ: //RALINK_GPIO_READ_INT
		tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODATA));
		put_user(tmp, (int __user *)arg);
		break;
	case RALINK_GPIO_WRITE: //RALINK_GPIO_WRITE_INT
		*(volatile u32 *)(RALINK_REG_PIODATA) = cpu_to_le32(arg);
		break;
	case RALINK_GPIO_SET: //RALINK_GPIO_SET_INT
		*(volatile u32 *)(RALINK_REG_PIOSET) = cpu_to_le32(arg);
		break;
	case RALINK_GPIO_CLEAR: //RALINK_GPIO_CLEAR_INT
		*(volatile u32 *)(RALINK_REG_PIORESET) = cpu_to_le32(arg);
		break;
	case RALINK_GPIO_READ_BIT:
		tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODATA));
		if (0L <= idx && idx < RALINK_GPIO_DATA_LEN) {
			tmp = (tmp >> idx) & 1L;
			put_user(tmp, (int __user *)arg);
		}
		else
			return -EINVAL;
		break;
	case RALINK_GPIO_WRITE_BIT:
		if (0L <= idx && idx < RALINK_GPIO_DATA_LEN) {
			tmp =le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODATA));
			if (arg & 1L)
				tmp |= (1L << idx);
			else
				tmp &= ~(1L << idx);
			*(volatile u32 *)(RALINK_REG_PIODATA)= cpu_to_le32(tmp);
		}
		else
			return -EINVAL;
		break;
	case RALINK_GPIO_READ_BYTE:
		tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODATA));
		if (0L <= idx && idx < RALINK_GPIO_DATA_LEN/8) {
			tmp = (tmp >> idx*8) & 0xFFL;
			put_user(tmp, (int __user *)arg);
		}
		else
			return -EINVAL;
		break;
	case RALINK_GPIO_WRITE_BYTE:
		if (0L <= idx && idx < RALINK_GPIO_DATA_LEN/8) {
			tmp =le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODATA));
			tmp &= ~(0xFFL << idx*8);
			tmp |= ((arg & 0xFFL) << idx*8);
			*(volatile u32 *)(RALINK_REG_PIODATA)= cpu_to_le32(tmp);
		}
		else
			return -EINVAL;
		break;
	case RALINK_GPIO_ENABLE_INTP:
		*(volatile u32 *)(RALINK_REG_INTENA) = cpu_to_le32(RALINK_INTCTL_PIO);
		break;
	case RALINK_GPIO_DISABLE_INTP:
		*(volatile u32 *)(RALINK_REG_INTDIS) = cpu_to_le32(RALINK_INTCTL_PIO);
		break;
	case RALINK_GPIO_REG_IRQ:
		copy_from_user(&info, (ralink_gpio_reg_info *)arg, sizeof(info));
		if (0 <= info.irq && info.irq < RALINK_GPIO_NUMBER) {
			ralink_gpio_info[info.irq].pid = info.pid;
			tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIORENA));
			tmp |= (0x1 << info.irq);
			*(volatile u32 *)(RALINK_REG_PIORENA) = cpu_to_le32(tmp);
			tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOFENA));
			tmp |= (0x1 << info.irq);
			*(volatile u32 *)(RALINK_REG_PIOFENA) = cpu_to_le32(tmp);
		}
		else
			printk(KERN_ERR NAME ": irq number(%d) out of range\n",
					info.irq);
		break;
	case RALINK_GPIO_LED_SET:
#ifdef CONFIG_RALINK_GPIO_LED
		copy_from_user(&led, (ralink_gpio_led_info *)arg, sizeof(led));
		if (0 <= led.gpio && led.gpio < RALINK_GPIO_NUMBER) {
			if (led.on > RALINK_GPIO_LED_INFINITY)
				led.on = RALINK_GPIO_LED_INFINITY;
			if (led.off > RALINK_GPIO_LED_INFINITY)
				led.off = RALINK_GPIO_LED_INFINITY;
			if (led.blinks > RALINK_GPIO_LED_INFINITY)
				led.blinks = RALINK_GPIO_LED_INFINITY;
			if (led.rests > RALINK_GPIO_LED_INFINITY)
				led.rests = RALINK_GPIO_LED_INFINITY;
			if (led.times > RALINK_GPIO_LED_INFINITY)
				led.times = RALINK_GPIO_LED_INFINITY;
			if (led.on == 0 && led.off == 0 && led.blinks == 0 &&
					led.rests == 0) {
				ralink_gpio_led_data[led.gpio].gpio = -1; //stop it
				break;
			}

#if MODEL_TVIP651W || MODEL_TVIP651WI
                        if(led.on)
                        {
                            tvip651_wps_led = 1;
                        }
                        else
                        {
                            tvip651_wps_led = 0;
                        }
#endif

			//register led data
			ralink_gpio_led_data[led.gpio].gpio = led.gpio;
			ralink_gpio_led_data[led.gpio].on = led.on;
			ralink_gpio_led_data[led.gpio].off = led.off;
			ralink_gpio_led_data[led.gpio].blinks = led.blinks;
			ralink_gpio_led_data[led.gpio].rests = led.rests;
			ralink_gpio_led_data[led.gpio].times = led.times;

			//clear previous led status
			ralink_gpio_led_stat[led.gpio].ticks = -1;
			ralink_gpio_led_stat[led.gpio].ons = 0;
			ralink_gpio_led_stat[led.gpio].offs = 0;
			ralink_gpio_led_stat[led.gpio].resting = 0;
			ralink_gpio_led_stat[led.gpio].times = 0;

			//set gpio direction to 'out'
			tmp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIODIR));
			tmp |= RALINK_GPIO(led.gpio);
			*(volatile u32 *)(RALINK_REG_PIODIR) = tmp;
#if RALINK_LED_DEBUG
			printk("dir_%x gpio_%d - %d %d %d %d %d\n", tmp,
					led.gpio, led.on, led.off, led.blinks,
					led.rests, led.times);
#endif
		}
		else
			printk(KERN_ERR NAME ": gpio number(%d) out of range\n",
					led.gpio);
#else
		printk(KERN_ERR NAME ": gpio led support not built\n");
#endif
		break;
	default:
		return -ENOIOCTLCMD;
	}
	return 0;
}

int ralink_gpio_open(struct inode *inode, struct file *file)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
	MOD_INC_USE_COUNT;
#else
	try_module_get(THIS_MODULE);
#endif
	return 0;
}

int ralink_gpio_release(struct inode *inode, struct file *file)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
	MOD_DEC_USE_COUNT;
#else
	module_put(THIS_MODULE);
#endif
	return 0;
}

struct file_operations ralink_gpio_fops =
{
	owner:		THIS_MODULE,
	ioctl:		ralink_gpio_ioctl,
	open:		ralink_gpio_open,
	release:	ralink_gpio_release,
};

#ifdef CONFIG_RALINK_GPIO_LED

#if RALINK_GPIO_LED_LOW_ACT
#define __LED_ON(gpio) ralink_gpio_led_value &= ~RALINK_GPIO(gpio);
#define __LED_OFF(gpio) ralink_gpio_led_value |= RALINK_GPIO(gpio);
#else
#define __LED_ON(gpio) ralink_gpio_led_value |= RALINK_GPIO(gpio);
#define __LED_OFF(gpio) ralink_gpio_led_value &= ~RALINK_GPIO(gpio);
#endif

/* DCS-930 Power/Link LED */
/* poll interval: 0.1 second */
void poll_power_link_led(void) 
{
    short wlan_link;
    static short onoff_toggle = 0;
#if 0
    static long random_num = 0;
#endif

    if(power_led_indicator)    /* power led is used as indicator */
        return;

    if(LED_Control == 0)       /* Normal */
    {
#if D_LINK
        Get_Wlan_Link_Status(&wlan_link);

        if(lan_link || wlan_link)
        {
#if 1	    //fixed flash
//          if(have_rx_tx)     //for have packets case
            if(TotalVideoUser) //for have user view case
            {
                have_rx_tx = 0;
                if(onoff_toggle)
                {
                    onoff_toggle = 0;
                    __LED_OFF(POWER_LED);
                    __LED_ON(LINK_LED);
                }
                else
                {
                    onoff_toggle = 1;
                    __LED_OFF(POWER_LED);
                    __LED_OFF(LINK_LED);
                }
            }
            else
            {
                onoff_toggle = 0;
                __LED_OFF(POWER_LED);
                __LED_ON(LINK_LED);
            } 
#endif
#if 0	    //random flash
            __LED_OFF(POWER_LED);
            __LED_ON(LINK_LED);
#endif
        }
        else
        {
            __LED_OFF(LINK_LED);
            __LED_ON(POWER_LED);
        }
#endif
#if MODEL_IPC1000W || MODEL_IPC1000WI || MODEL_TVIP551W || MODEL_TVIP551WI || MODEL_TVIP651W || MODEL_TVIP651WI
        Get_Wlan_Link_Status(&wlan_link);

        if(lan_link || wlan_link)
        {
            __LED_ON(POWER_LED);
            __LED_ON(LINK_LED);
#if MODEL_TVIP651W || MODEL_TVIP651WI
            if(tvip651_wps_led)
            {
                __LED_OFF(LINK_LED);
            }
#endif
        }
        else
        {
            __LED_ON(POWER_LED);
            __LED_OFF(LINK_LED);
        }
#endif
    }
    else if(LED_Control == 1)  /* OFF */
    {
        __LED_OFF(LINK_LED);
        __LED_OFF(POWER_LED);
    }
    else if(LED_Control == 2)  /* Dummy */
    {
#if D_LINK
	//Not support
#endif
#if MODEL_IPC1000W || MODEL_IPC1000WI || MODEL_TVIP551W || MODEL_TVIP551WI || MODEL_TVIP651W || MODEL_TVIP651WI
#if 0
        __LED_ON(POWER_LED);
	if((random_num & 0x0000000f) == 0)
        {
            if(onoff_toggle)
            {
                __LED_ON(LINK_LED);
                onoff_toggle = 0;
            }
            else
            {
                __LED_OFF(LINK_LED);
                onoff_toggle = 1;
            }
            random_num = random_num >> 4;
            if(random_num == 0)
                random_num = jiffies * 0x12345678L;
        }
        random_num--;
#endif
#endif
    }
    else                       /* System startup time */             
    {
#if D_LINK
        __LED_OFF(LINK_LED);
        __LED_ON(POWER_LED);
#endif
#if MODEL_IPC1000W || MODEL_IPC1000WI || MODEL_TVIP551W || MODEL_TVIP551WI || MODEL_TVIP651W || MODEL_TVIP651WI
        __LED_ON(LINK_LED);
        __LED_ON(POWER_LED);
#endif
    }
}


/* poll interval: 0.1 second */
void poll_power_indicator_led(void)
{
    static int times_counter = 0;
    static int toggle_flag = 0;


    if(!power_led_indicator)      /* power led is used as power/link led */
        return;

    if(times_counter++ >= 2) 
    {
        times_counter = 0;
        if(toggle_flag)
            toggle_flag = 0;
        else
            toggle_flag = 1;
    }  
 
    if(power_led_indicator == 1)  /* reset or factory reset *//* system will reboot */
    {
#if D_LINK
        __LED_OFF(LINK_LED);
        __LED_ON(POWER_LED);
#endif
#if MODEL_IPC1000W || MODEL_IPC1000WI || MODEL_TVIP551W || MODEL_TVIP551WI || MODEL_TVIP651W || MODEL_TVIP651WI
        __LED_ON(LINK_LED);
        __LED_ON(POWER_LED);
#endif

        return;
    }

    if(power_led_indicator == 2)  /* download *//* system will reboot */
    {
#if D_LINK
        if(toggle_flag)           /* on power led */
        {
            __LED_OFF(LINK_LED);
            __LED_ON(POWER_LED);
        }
        else                      /* off power led */
        {   
            __LED_OFF(LINK_LED);
            __LED_OFF(POWER_LED);
        }
#endif
#if MODEL_IPC1000W || MODEL_IPC1000WI || MODEL_TVIP551W || MODEL_TVIP551WI || MODEL_TVIP651W || MODEL_TVIP651WI
        if(toggle_flag)           /* on power led */
        {
            __LED_ON(LINK_LED);
            __LED_ON(POWER_LED);
        }
        else                      /* off power led */
        {   
            __LED_OFF(LINK_LED);
            __LED_OFF(POWER_LED);
        }
#endif

        return;
    }

    if(power_led_indicator == 3)  /* test power led *//* system will not reboot */
    {
#if D_LINK
        if(toggle_flag)           /* on power led */
        {
            __LED_OFF(LINK_LED);
            __LED_ON(POWER_LED);
        }
        else                      /* off power led */
        {   
            __LED_OFF(LINK_LED);
            __LED_OFF(POWER_LED);
        }
#endif
#if MODEL_IPC1000W || MODEL_IPC1000WI || MODEL_TVIP551W || MODEL_TVIP551WI || MODEL_TVIP651W || MODEL_TVIP651WI
        if(toggle_flag)           /* on power led */
        {
            __LED_ON(POWER_LED);
        }
        else                      /* off power led */
        {   
            __LED_OFF(POWER_LED);
        }
#endif
 
        return;
    }

    if(power_led_indicator == 4)  /* test link led *//* system will not reboot */
    {
#if D_LINK
        if(toggle_flag)           /* on link led */
        {
            __LED_ON(LINK_LED);
            __LED_OFF(POWER_LED);
        }
        else                      /* off link led */
        {   
            __LED_OFF(LINK_LED);
            __LED_OFF(POWER_LED);
        }
#endif
#if MODEL_IPC1000W || MODEL_IPC1000WI || MODEL_TVIP551W || MODEL_TVIP551WI || MODEL_TVIP651W || MODEL_TVIP651WI
        if(toggle_flag)           /* on link led */
        {
            __LED_ON(LINK_LED);
        }
        else                      /* off link led */
        {   
            __LED_OFF(LINK_LED);
        }
#if MODEL_TVIP651W || MODEL_TVIP651WI
        __LED_OFF(WPS_LED);
#endif
#endif
 
        return;
    }

    if(power_led_indicator == 5)  /* test wps led *//* system will not reboot */
    {
        if(toggle_flag)           /* on wps led */
        {
            __LED_ON(WPS_LED);
        }
        else                      /* off wps led */
        {   
            __LED_OFF(WPS_LED);
        }
#if MODEL_TVIP651W || MODEL_TVIP651WI
        __LED_OFF(LINK_LED);
#endif
 
        return;
    }

    power_led_indicator = 0;      /* invalid value -> reset to 0 (normal) */ 

    return;
}


void poll_wlan_test(void)
{
    static int tickcnt = 0;

    if(test_mode == 2)
    {
        if(++tickcnt >= (18*10))	//18 seconds -- qctest program will wait 15 seconds for link checking
        {
            test_mode = 0;
            EnableLan();
        }
    }
    else
    {
        tickcnt = 0;
    }
}


void set_ir_event_flag(void)
{
#if MODEL_DCS932 || MODEL_DCS932L || MODEL_IPC1000WI || MODEL_TVIP551WI || MODEL_TVIP651WI
    event_flag |= EVENT_IR_LED_CHANGE;
#endif
}

void poll_light_sensor(void)  //POLL interval 0.1 second
{
    u32 ralink_gpio_value;
    u32 LightSensorStatus;
    static int light_sensor_status_changed = 0;

    if(daynight_mode != 0)    //Only for Auto mode
        return;

    ralink_gpio_value = *(volatile u32 *)(RALINK_REG_PIODATA);
    LightSensorStatus = ralink_gpio_value & RALINK_GPIO(LIGHT_SENSOR_IN);

    if(light_sensor_status_changed == 0)
    {
        if(LightSensorStatus == Old_LightSensorStatus)
        {
            t3sec_cnt = 0;
            return;
        }
        else
        {
            t3sec_cnt++;
            if(on_qctest)
                t3sec_cnt = 3*10;
            if(t3sec_cnt < 3*10)
            {
                return;
            }
            else
            {
                light_sensor_status_changed = 1;
                Old_LightSensorStatus = LightSensorStatus;
                if(Old_LightSensorStatus)
                {
                    ir_led_onoff = 0;
                    set_ir_event_flag();
                }
                else
                {
                    ir_led_onoff = 1;
                    set_ir_event_flag();
                }
                return;
            }
        }
    }

    if(t3sec_cnt)
    {
        if(on_qctest)
        {
            if(LightSensorStatus != Old_LightSensorStatus)
            {
                light_sensor_status_changed = 0;
                return;
            }
        }

        t3sec_cnt--;

        if(Old_LightSensorStatus)
        {
//          printk("11\n");
            /* OFF IR LED */
            ralink_gpio_led_value |= RALINK_GPIO(IR_LED_OUT_1);     
      	    ralink_gpio_led_value |= RALINK_GPIO(IR_LED_OUT_2);
        }
        else
        {
//          printk("00\n");
            /* ON IR LED */
       	    ralink_gpio_led_value &= ~RALINK_GPIO(IR_LED_OUT_1);     
            ralink_gpio_led_value &= ~RALINK_GPIO(IR_LED_OUT_2);
        }
    }
    else
    {
        light_sensor_status_changed = 0;

        if(Old_LightSensorStatus)
        {
//          printk("10\n");
            ralink_gpio_led_value |= RALINK_GPIO(IR_LED_OUT_1);     
            ralink_gpio_led_value &= ~RALINK_GPIO(IR_LED_OUT_2);
        }
        else
        {
//          printk("01\n");
       	    ralink_gpio_led_value &= ~RALINK_GPIO(IR_LED_OUT_1);   
      	    ralink_gpio_led_value |= RALINK_GPIO(IR_LED_OUT_2);  
        }
    }
}


void poll_ir_led(void)  //POLL interval 0.1 second
{
    u32 ralink_gpio_value;

    if(set_ir_led == 0)       //not set led time
        return;

    ralink_gpio_value = *(volatile u32 *)(RALINK_REG_PIODATA);

    if(ir_led_t3sec)
    {
        ir_led_t3sec--;

        if(ir_led_onoff == 0)
        {
//          printk("11\n");
            /* OFF IR LED */
            ralink_gpio_led_value |= RALINK_GPIO(IR_LED_OUT_1);     
      	    ralink_gpio_led_value |= RALINK_GPIO(IR_LED_OUT_2);
        }
        else
        {
//          printk("00\n");
            /* ON IR LED */
       	    ralink_gpio_led_value &= ~RALINK_GPIO(IR_LED_OUT_1);     
            ralink_gpio_led_value &= ~RALINK_GPIO(IR_LED_OUT_2);
        }
    }
    else
    {
        set_ir_led = 0;

        if(ir_led_onoff == 0)
        {
//          printk("10\n");
            ralink_gpio_led_value |= RALINK_GPIO(IR_LED_OUT_1);     
            ralink_gpio_led_value &= ~RALINK_GPIO(IR_LED_OUT_2);
        }
        else
        {
//          printk("01\n");
       	    ralink_gpio_led_value &= ~RALINK_GPIO(IR_LED_OUT_1);   
      	    ralink_gpio_led_value |= RALINK_GPIO(IR_LED_OUT_2);  
        }
    }
}


void re_position_icr_timer(void)
{
    static unsigned long minute5_cnt = 0;

    minute5_cnt++;
    if(minute5_cnt < 5*60*10)		   //5 minute
        return;

    minute5_cnt = 0;

#if MODEL_DCS932 || MODEL_DCS932L || MODEL_IPC1000WI || MODEL_TVIP551WI || MODEL_TVIP651WI
    set_ir_led = 1;    			
    ir_led_t3sec = 30;
#endif
}

void timer_of_email_frame_queue(void)      //interval is 0.1 second
{
    if(email_frame_queue_interval == 0)    //email 6 frame mode is disable
        return;

    email_frame_queue_timer++;

    if(email_frame_queue_interval == 1)    //0.5 second
    {
        if(email_frame_queue_timer >= 5)
        {
            email_frame_queue_timer = 0;
            queue_email_frame = 1;
        }

        return; 
    }
    if(email_frame_queue_interval == 2)    //1 second
    {
        if(email_frame_queue_timer >= 10)
        {
            email_frame_queue_timer = 0;
            queue_email_frame = 1;
        }

        return; 
    }
}


void pppoe_find_modem_timer(void)  	//interval is 0.1 second
{
    pppoe_find_modem++;
}   


int Init_Email_Frame_Queue(void)
{
    unsigned long FRMAddr;
    struct FRM *pFRM;
    int i;

    FRMAddr = (unsigned long)EmailFrameQueue;
    pFRM = (struct FRM *)FRMAddr;

    for(i = 0; i < 3; i++)
    {
        pFRM->my_buffer_addr = FRMAddr;
        pFRM->sequence_num = 0;
        pFRM->frame_len = 0;
        pEmailFRMQueue[i] = pFRM;
	FRMAddr += (1024L * 72L);
        pFRM = (struct FRM *)FRMAddr;
    }
}

struct FRM *Get_Email_Frame_Queue(unsigned long prev_sequence_num)
{
    unsigned long get_seq_num;
    int i;

    if(prev_sequence_num == 0xffffffffL)    //first get
    {
//printk("get pEmailFRMQueue[0], seq = %x \n", pEmailFRMQueue[0]->sequence_num);
        return pEmailFRMQueue[0];
    }
    else
    {
        get_seq_num = prev_sequence_num + 1;
        if(get_seq_num == 0xffffffffL)
            get_seq_num = 0;

        for(i = 0; i < 3; i++)
        {
            if(pEmailFRMQueue[i]->sequence_num == get_seq_num)
            {
//printk("get pEmailFRMQueue[i], i=%x, seq = %x \n", i, pEmailFRMQueue[i]->sequence_num);
                return pEmailFRMQueue[i];
            }
        }
    }

    return (struct FRM *)0;
}


void ActiveUser_KeepAlive(void)
{
    unsigned long flags;
    struct ACTIVEUSER *pUser;
    struct AUDIODATA *pA, *pNextA;
    static int tickcnt = 0;
    int i;

    if(++tickcnt >= (30*10))	//30 seconds
    {
        tickcnt = 0;

        pUser = Active_User_Table;
        for(i = 0; i < MAX_USER_NUMBER; i++)
        {
            if(pUser->Pid)
            {
                if(pUser->Keep_Alive)
                {
                    pUser->Keep_Alive = 0;
                }
                else
                {
                    spin_lock_irqsave(&mr_lock, flags);
                    pUser->Pid = 0;
                    if(pUser->AudioVideo == 1)  /* Audio */
                    {
                        pA = pUser->pAudio;
                        while(pA)
                        {
                            pNextA = pA->pNextAudio;
                            if(pA->myaddr != (unsigned long)pA)
                                printk("????? Invalid Audio Buffer 6- %x %x ?????\n", (unsigned long)pA, pA->mymark);
                            pA->myaddr = 0;
                            pA->mymark = 0;
                            kfree(pA);
                            pA = pNextA;
                        }
                        TotalAudioUser--;
                    }
                    else
                    {
                        TotalVideoUser--;
                    }
                    spin_unlock_irqrestore(&mr_lock, flags);
                    printk("Delete un-active user entry!\n");
                }
            }
            pUser++;
        }
    }
}


void get_bootcode_info(void)
{
     char *pflash = CONFIG_MTD_PHYSMAP_START; //0xbf000000;
     unsigned long i;
     char *pSignature = "Signature: ";  //11 bytes
     char *pRelease = "Release ";       //8  bytes (offset 36 position of signature)
     unsigned long j = (unsigned long)1024 * 64 * 3; //boot code max size
     int len;
     char *pNotFound = "Not Found";
     char Major, Minor;

     memset(bootcode_signature, 0, 64);
     printk("--- Boot Code Signature ---\n");

     for(i = 0; i < j; i++)
     {
         if(*pflash != 'S')
         {
             pflash++;
             continue;
         }

         if(strncmp(pflash, pSignature, 11)) 
         {
             pflash++;
             continue;
         }

         if(strncmp(pflash+36, pRelease, 8))
         {
             pflash++;
             continue;
         }

         len = strlen(pflash);
         if(len > 64)
             len = 64;

         memcpy(bootcode_signature, pflash, len);
         printk("%s\n", bootcode_signature);

         Major = pflash[44] - '0';
         Minor = (pflash[46] - '0') * 10 + (pflash[47] - '0'); 
         ROMVersion = (Major << 24) + (Minor << 16);                

         return;
     }
     
     printk("%s\n", pNotFound);
}


static void ralink_gpio_led_do_timer(unsigned long unused)
{
	int i;
	unsigned int x;

	for (i = 0; i < RALINK_GPIO_NUMBER; i++) {
		ralink_gpio_led_stat[i].ticks++;
		if (ralink_gpio_led_data[i].gpio == -1) //-1 means unused
			continue;
		if (ralink_gpio_led_data[i].on == RALINK_GPIO_LED_INFINITY ||
				ralink_gpio_led_data[i].off == 0) { //always on
			__LED_ON(i);
			continue;
		}
		if (ralink_gpio_led_data[i].off == RALINK_GPIO_LED_INFINITY ||
				ralink_gpio_led_data[i].rests == RALINK_GPIO_LED_INFINITY ||
				ralink_gpio_led_data[i].on == 0 ||
				ralink_gpio_led_data[i].blinks == 0 ||
				ralink_gpio_led_data[i].times == 0) { //always off
			__LED_OFF(i);
			continue;
		}

		//led turn on or off
		if (ralink_gpio_led_data[i].blinks == RALINK_GPIO_LED_INFINITY ||
				ralink_gpio_led_data[i].rests == 0) { //always blinking
			x = ralink_gpio_led_stat[i].ticks % (ralink_gpio_led_data[i].on
					+ ralink_gpio_led_data[i].off);
		}
		else {
			unsigned int a, b, c, d, o, t;
			a = ralink_gpio_led_data[i].blinks / 2;
			b = ralink_gpio_led_data[i].rests / 2;
			c = ralink_gpio_led_data[i].blinks % 2;
			d = ralink_gpio_led_data[i].rests % 2;
			o = ralink_gpio_led_data[i].on + ralink_gpio_led_data[i].off;
			//t = blinking ticks
			t = a * o + ralink_gpio_led_data[i].on * c;
			//x = ticks % (blinking ticks + resting ticks)
			x = ralink_gpio_led_stat[i].ticks %
				(t + b * o + ralink_gpio_led_data[i].on * d);
			//starts from 0 at resting cycles
			if (x >= t)
				x -= t;
			x %= o;
		}
		if (x < ralink_gpio_led_data[i].on) {
			__LED_ON(i);
			if (ralink_gpio_led_stat[i].ticks && x == 0)
				ralink_gpio_led_stat[i].offs++;
#if RALINK_LED_DEBUG
			printk("t%d gpio%d on,", ralink_gpio_led_stat[i].ticks, i);
#endif
		}
		else {
			__LED_OFF(i);
			if (x == ralink_gpio_led_data[i].on)
				ralink_gpio_led_stat[i].ons++;
#if RALINK_LED_DEBUG
			printk("t%d gpio%d off,", ralink_gpio_led_stat[i].ticks, i);
#endif
		}

		//blinking or resting
		if (ralink_gpio_led_data[i].blinks == RALINK_GPIO_LED_INFINITY ||
				ralink_gpio_led_data[i].rests == 0) { //always blinking
			continue;
		}
		else {
			x = ralink_gpio_led_stat[i].ons + ralink_gpio_led_stat[i].offs;
			if (!ralink_gpio_led_stat[i].resting) {
				if (x == ralink_gpio_led_data[i].blinks) {
					ralink_gpio_led_stat[i].resting = 1;
					ralink_gpio_led_stat[i].ons = 0;
					ralink_gpio_led_stat[i].offs = 0;
					ralink_gpio_led_stat[i].times++;
				}
			}
			else {
				if (x == ralink_gpio_led_data[i].rests) {
					ralink_gpio_led_stat[i].resting = 0;
					ralink_gpio_led_stat[i].ons = 0;
					ralink_gpio_led_stat[i].offs = 0;
				}
			}
		}
		if (ralink_gpio_led_stat[i].resting) {
			__LED_OFF(i);
#if RALINK_LED_DEBUG
			printk("resting,");
		} else {
			printk("blinking,");
#endif
		}

		//number of times
		if (ralink_gpio_led_data[i].times != RALINK_GPIO_LED_INFINITY)
		{
			if (ralink_gpio_led_stat[i].times ==
					ralink_gpio_led_data[i].times) {
				__LED_OFF(i);
				ralink_gpio_led_data[i].gpio = -1; //stop
			}
#if RALINK_LED_DEBUG
			printk("T%d\n", ralink_gpio_led_stat[i].times);
		} else {
			printk("T@\n");
#endif
		}
	}

        poll_power_link_led();
        poll_power_indicator_led();
        poll_wlan_test();
        poll_light_sensor();
        poll_ir_led();
        timer_of_email_frame_queue();
        re_position_icr_timer();
        pppoe_find_modem_timer();

	*(volatile u32 *)(RALINK_REG_PIODATA) = ralink_gpio_led_value;

#if RALINK_LED_DEBUG
	printk("led_value= %x\n", ralink_gpio_led_value);
#endif

	init_timer(&ralink_gpio_led_timer);
	ralink_gpio_led_timer.expires = jiffies + RALINK_GPIO_LED_FREQ; //0.1 second
	add_timer(&ralink_gpio_led_timer);

        // printk("jiffies = %d, LED_FREQ = %d\n", jiffies, RALINK_GPIO_LED_FREQ);
        // RALINK_GPIO_LED_FREQ is 25

        ActiveUser_KeepAlive();

        DebugTimeCnt++;
        if(DebugTimeCnt == 10)
        {
            DebugTimeCnt = 0;

            if(DebugReadyCnt >= 30)
                DebugStartReadyCnt30 = 1;
            if(DebugStartReadyCnt30)
            {
                DebugReadyCnt30 += (30 - DebugReadyCnt);
                DebugTimes++;
            }
                
//            printk("ReadyCnt=%d(%d), %d/%d, GetCnt=%d\n", DebugReadyCnt, DebugImgLenNow, DebugReadyCnt30, DebugTimes, DebugGetCnt);
            DebugReadyCnt = 0;
            DebugGetCnt = 0;
        }
}

void ralink_gpio_led_init_timer(void)
{
	int i;

	ralink_gpio_led_value = *(volatile u32 *)(RALINK_REG_PIODATA);

	for (i = 0; i < RALINK_GPIO_NUMBER; i++) {
		ralink_gpio_led_data[i].gpio = -1; //-1 means unused
#if 0   //andy -- led state have been set on bootcode, don't init here, some of pio pin are used to act as control pin out, not only for led out
#if RALINK_GPIO_LED_LOW_ACT
		ralink_gpio_led_value |= RALINK_GPIO(i);
#else
		ralink_gpio_led_value &= ~RALINK_GPIO(i);
#endif
#endif
	}
#if 1   //andy -- init led (POWER LED ON, LINK LED OFF, WPS LED OFF)
      	ralink_gpio_led_value &= ~RALINK_GPIO(POWER_LED);     
      	ralink_gpio_led_value |= RALINK_GPIO(LINK_LED);
       	ralink_gpio_led_value |= RALINK_GPIO(WPS_LED);  

       	ralink_gpio_led_value |= RALINK_GPIO(IR_LED_OUT_1);  
       	ralink_gpio_led_value &= ~RALINK_GPIO(IR_LED_OUT_2);  
#endif

        jiffies = 0; /* start jiffies from 0 *//* andy */
	init_timer(&ralink_gpio_led_timer);
	ralink_gpio_led_timer.function = ralink_gpio_led_do_timer;
	ralink_gpio_led_timer.expires = jiffies + RALINK_GPIO_LED_FREQ;
	add_timer(&ralink_gpio_led_timer);
}
#endif

int __init ralink_gpio_init(void)
{
	unsigned int i;
	u32 gpiomode;
        unsigned long fw_build;

#ifdef  CONFIG_DEVFS_FS
	if (devfs_register_chrdev(ralink_gpio_major, RALINK_GPIO_DEVNAME,
				&ralink_gpio_fops)) {
		printk(KERN_ERR NAME ": unable to register character device\n");
		return -EIO;
	}
	devfs_handle = devfs_register(NULL, RALINK_GPIO_DEVNAME,
			DEVFS_FL_DEFAULT, ralink_gpio_major, 0,
			S_IFCHR | S_IRUGO | S_IWUGO, &ralink_gpio_fops, NULL);
#else
	int r = 0;
	r = register_chrdev(ralink_gpio_major, RALINK_GPIO_DEVNAME,
			&ralink_gpio_fops);
	if (r < 0) {
		printk(KERN_ERR NAME ": unable to register character device\n");
		return r;
	}
	if (ralink_gpio_major == 0) {
		ralink_gpio_major = r;
		printk(KERN_DEBUG NAME ": got dynamic major %d\n", r);
	}
#endif

	//config these pins to gpio mode
#if 0   //andy -- this have been setup on bootcode,
	gpiomode = le32_to_cpu(*(volatile u32 *)(RALINK_REG_GPIOMODE));
#if defined (CONFIG_RALINK_RT3052) || defined (CONFIG_RALINK_RT2883)
	gpiomode &= ~0x1C;  //clear bit[2:4]UARTF_SHARE_MODE
#endif
	gpiomode |= RALINK_GPIOMODE_DFT;
	*(volatile u32 *)(RALINK_REG_GPIOMODE) = cpu_to_le32(gpiomode);
#endif
#if MODEL_TVIP651W || MODEL_TVIP651WI
	gpiomode = le32_to_cpu(*(volatile u32 *)(RALINK_REG_GPIOMODE));
	gpiomode |= 0x00000040;             /* Select JTAG to GPIO mode. */
	*(volatile u32 *)(RALINK_REG_GPIOMODE) = cpu_to_le32(gpiomode);
#endif

	//enable gpio interrupt
	*(volatile u32 *)(RALINK_REG_INTENA) = cpu_to_le32(RALINK_INTCTL_PIO);
	for (i = 0; i < RALINK_GPIO_NUMBER; i++) {
		ralink_gpio_info[i].irq = i;
		ralink_gpio_info[i].pid = 0;
	}

#ifdef CONFIG_RALINK_GPIO_LED
	ralink_gpio_led_init_timer();
#endif
	printk("Ralink gpio driver initialized\n");

        memset(DDNS_Message, 0, 128);
        memset(Active_User_Table, 0, sizeof(struct ACTIVEUSER) * MAX_USER_NUMBER);

        //Get bootcode info -- signature/verdate/date -- andy
        get_bootcode_info();
        //Display F/W version information
        fw_build = MyVersionBuild & 0x000000ff;
        printk("===== %s v%s build %d (%s) =====\n", MyModel, MyReleaseVersion, fw_build, MyReleaseDate);

        //Email motion frame queue init
        Init_Email_Frame_Queue();

	return 0;
}

void __exit ralink_gpio_exit(void)
{
#ifdef  CONFIG_DEVFS_FS
	devfs_unregister_chrdev(ralink_gpio_major, RALINK_GPIO_DEVNAME);
	devfs_unregister(devfs_handle);
#else
	unregister_chrdev(ralink_gpio_major, RALINK_GPIO_DEVNAME);
#endif

	//config these pins to normal mode
	*(volatile u32 *)(RALINK_REG_GPIOMODE) &= ~RALINK_GPIOMODE_DFT;
	//disable gpio interrupt
	*(volatile u32 *)(RALINK_REG_INTDIS) = cpu_to_le32(RALINK_INTCTL_PIO);
#ifdef CONFIG_RALINK_GPIO_LED
	del_timer(&ralink_gpio_led_timer);
#endif
	printk("Ralink gpio driver exited\n");
}

/*
 * send a signal(SIGUSR1) to the registered user process whenever any gpio
 * interrupt comes
 * (called by interrupt handler)
 */
void ralink_gpio_notify_user(int usr)
{
	struct task_struct *p = NULL;

	if (ralink_gpio_irqnum < 0 || RALINK_GPIO_NUMBER <= ralink_gpio_irqnum)
        {
		printk(KERN_ERR NAME ": gpio irq number out of range\n");
		return;
	}

	//don't send any signal if pid is 0 or 1
	if ((int)ralink_gpio_info[ralink_gpio_irqnum].pid < 2)
		return;

	p = find_task_by_pid(ralink_gpio_info[ralink_gpio_irqnum].pid);

	if (NULL == p)
        {
		printk(KERN_ERR NAME ": no registered process to notify\n");
		return;
	}

	if (usr == 1)
        {
                send_sig(SIGUSR1, p, 0);
		printk(KERN_NOTICE NAME ": sending a SIGUSR1 to process %d\n",
				ralink_gpio_info[ralink_gpio_irqnum].pid);
	}
	else if (usr == 2) 
        {
                send_sig(SIGUSR2, p, 0);
		printk(KERN_NOTICE NAME ": sending a SIGUSR2 to process %d\n",
				ralink_gpio_info[ralink_gpio_irqnum].pid);
	}
}

/*
 * 1. save the PIOINT and PIOEDGE value
 * 2. clear PIOINT by writing 1
 * (called by interrupt handler)
 */
void ralink_gpio_save_clear_intp(void)
{
	ralink_gpio_intp = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOINT));
	ralink_gpio_edge = le32_to_cpu(*(volatile u32 *)(RALINK_REG_PIOEDGE));
	*(volatile u32 *)(RALINK_REG_PIOINT) = cpu_to_le32(0x00FFFFFF);
	*(volatile u32 *)(RALINK_REG_PIOEDGE) = cpu_to_le32(0x00FFFFFF);
}

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
void ralink_gpio_irq_handler(unsigned int irq, struct irqaction *irqaction)
#else
irqreturn_t ralink_gpio_irq_handler(int irq, void *irqaction)
#endif
{
	struct gpio_time_record
        {
		unsigned long falling;
		unsigned long rising;
	};
	static struct gpio_time_record record[RALINK_GPIO_NUMBER];
	unsigned long now;
	int i;

	ralink_gpio_save_clear_intp();
	now = jiffies;
	for (i = 0; i < RALINK_GPIO_NUMBER; i++)
        {
		if (! (ralink_gpio_intp & (1 << i)))
			continue;
		ralink_gpio_irqnum = i;
		if (ralink_gpio_edge & (1 << i))
                { //rising edge
			if (record[i].rising != 0 && time_before_eq(now,
						record[i].rising + 30L))
                        {
                                 ;
				/*
				 * If the interrupt comes in a short period,
				 * it might be floating. We ignore it.
				 */
			}
			else
                        {
				record[i].rising = now;
//				if (time_before(now, record[i].falling + 200L))
				if (time_before(now, record[i].falling + 24L*10*3))  //jiffies -> 24/0.1 second -> 24*10*3=3 seconds

                                {
					//one click
                                        if(i == PUSH_BUTTON_2_IRQ)
                                        {
                                            if(power_led_indicator != 2)      /* not on downloading */
                                            {
                                                if(on_qctest == 0)            /* normal mode */
                                                {
                                                    User2SigFlag = USER2_SIG_RESTART;
					            ralink_gpio_notify_user(2);
                                                    power_led_indicator = 1;  /* power led on */
                                                }
                                                else
                                                {
                                                    power_led_indicator = 3;  /* same test power led */
                                                }
                                            }
                                        }
                                        else if(i == PUSH_BUTTON_1_IRQ)
                                        {
                                            if(power_led_indicator != 2)      /* not on downloading */
                                            {
                                                if(on_qctest == 0)
                                                {
#if 0						    //Not support WPS on one click
                                                    User2SigFlag = USER2_SIG_WPS;
                                                    ralink_gpio_notify_user(2);
#endif
                                                }
                                                else
                                                {
                                                    power_led_indicator = 5;  /* same test wps led */
                                                }
                                            }
                                        }
                                        else if(i == PRIVACY_BUTTON)
                                        {
                                            printk("Push Privacy Button - short \n");
                                            if(power_led_indicator != 2)      /* not on downloading */
                                            {
                                                ptz_user1_sigflag = PTZ_USER1_SIG_PRIVACY;
					        ralink_gpio_notify_user(1);
                                            }
                                        }
                                }  				
				else
                                {
					//press for several seconds
                                        if(i == PUSH_BUTTON_2_IRQ)
                                        {  
                                            if(power_led_indicator != 2)      /* not on downloading */
                                            {
                                                if(on_qctest == 0)            /* normal mode */
                                                {
                                                    User2SigFlag = USER2_SIG_FACTORY_RESET;
					            ralink_gpio_notify_user(2);
                                                    power_led_indicator = 1;  /* power led on */
                                                }
                                                else
                                                {
                                                    power_led_indicator = 3;  /* same test power led */
                                                }
                                            }
                                        }
                                        else if(i == PUSH_BUTTON_1_IRQ)
                                        {
                                            if(power_led_indicator != 2)      /* not on downloading */
                                            {
                                                if(on_qctest == 0)
                                                {
                                                    User2SigFlag = USER2_SIG_WPS;
                                                    ralink_gpio_notify_user(2);
                                                }
                                                else
                                                {
                                                    power_led_indicator = 5;  /* same test wps led */
                                                }
                                            }
                                        }
                                        else if(i == PRIVACY_BUTTON)
                                        {
                                            printk("Push Privacy Button - long \n");
                                            if(power_led_indicator != 2)      /* not on downloading */
                                            {
                                                ptz_user1_sigflag = PTZ_USER1_SIG_PRIVACY;
					        ralink_gpio_notify_user(1);
                                            }
                                        }
                                }
			}
		}
		else
                { //falling edge
			record[i].falling = now;
		}

		break;
	}

	return IRQ_HANDLED;
}

//////////////////////////////////////////////////////////////////////////////////////
//For SYSIF
//////////////////////////////////////////////////////////////////////////////////////

void Send_User2_Sig_Down_Wlan(void)
{
    struct task_struct *p = NULL;

    User2SigFlag = USER2_SIG_DOWN_WLAN;
    if((p = find_task_by_pid(UserSigPid)) != NULL)
    {
        send_sig(SIGUSR2, p, 0);
    }
}

void Send_User2_Sig_Up_Wlan(void)
{
    struct task_struct *p = NULL;

    User2SigFlag = USER2_SIG_UP_WLAN;
    if((p = find_task_by_pid(UserSigPid)) != NULL)
    {
        send_sig(SIGUSR2, p, 0);
    }
}

void Send_User2_Sig_Down_Up_Wlan(void)
{
    struct task_struct *p = NULL;

    User2SigFlag = USER2_SIG_DOWN_UP_WLAN;
    if((p = find_task_by_pid(UserSigPid)) != NULL)
    {
        send_sig(SIGUSR2, p, 0);
    }
}

void Send_User2_Sig_Restart(void)
{
    struct task_struct *p = NULL;

    User2SigFlag = USER2_SIG_RESTART;
    if((p = find_task_by_pid(UserSigPid)) != NULL)
    {
        send_sig(SIGUSR2, p, 0);
    }
}

void Send_User2_Sig_Ping(void)
{
    struct task_struct *p = NULL;

    User2SigFlag = USER2_SIG_PING;
    if((p = find_task_by_pid(UserSigPid)) != NULL)
    {
        send_sig(SIGUSR2, p, 0);
    }
}

void Update_Lan_Status(unsigned short link, unsigned short speed, unsigned short duplex)
{
    lan_link = link;
    lan_speed = speed;
    lan_duplex = duplex;
}

void Setup_My_Mac(char *my_mac)
{
    memcpy(My_MAC, my_mac, 6);
}

void Get_My_Mac(char *my_mac)
{
    memcpy(my_mac, My_MAC, 6);
}

void SaveScanTable(void)
{
    spinlock_t mr_lock = SPIN_LOCK_UNLOCKED;
    unsigned long flags;
//  static int only_do_once = 1;

    spin_lock_irqsave(&mr_lock, flags);
//  if(only_do_once)
    {
//      only_do_once = 0;
        memset(ScanTable, 0, sizeof(struct SCAN_TABLE) * MAX_AP_NUMBER);
        GetSiteSurvey(ScanTable);
    }
    spin_unlock_irqrestore(&mr_lock, flags);
}

int Is_Wireless_Disable(void)
{
    return WirelessDisable;
}


void Enable_Wireless(void)
{
    WirelessDisable = 0;
    WlanEnableForSiteSurvey = 0;	
}

void flash_link_led(void)
{
    short wlan_link;

    if(power_led_indicator)    /* power led is used as indicator */
        return;

    if(LED_Control == 0)       /* Normal */
    {
        Get_Wlan_Link_Status(&wlan_link);

        if(lan_link || wlan_link)
        {
#if D_LINK
#if 1       //fixed flash
            have_rx_tx = 1;
            return;
#endif
#if 0       //random flash
            __LED_OFF(POWER_LED);
            __LED_OFF(LINK_LED);
#endif
#endif
#if MODEL_IPC1000W || MODEL_IPC1000WI || MODEL_TVIP551W || MODEL_TVIP551WI || MODEL_TVIP651W || MODEL_TVIP651WI
            __LED_ON(POWER_LED);
            __LED_OFF(LINK_LED);
#endif
            *(volatile u32 *)(RALINK_REG_PIODATA) = ralink_gpio_led_value;
        }
    }
}


void WirelessEnableForSiteSurvey(void)
{
    WlanEnableForSiteSurvey = 1;
}


int Is_WirelessEnableForSiteSurvey(void)
{
    return WlanEnableForSiteSurvey; 
}

void save_configured_ssid(char *ssid)
{
    memset(configured_ssid, 0, 33);
    memcpy(configured_ssid, ssid, strlen(ssid));
}

void get_configured_ssid(char *ssid)
{
    memcpy(ssid, configured_ssid, 33);
}


////////////////////////////////////////////////////////////////////////////////////

struct irqaction ralink_gpio_irqaction = {
	.handler = ralink_gpio_irq_handler,
	.flags = SA_INTERRUPT,
	.mask = 0,
	.name = "ralink_gpio",
};

void __init ralink_gpio_init_irq(void)
{
	setup_irq(SURFBOARDINT_GPIO, &ralink_gpio_irqaction);
}

module_init(ralink_gpio_init);
module_exit(ralink_gpio_exit);

