#ifndef __I2CDRV_H
#define __I2CDRV_H

#include <linux/types.h>
#include <asm/rt2880/rt_mmap.h>

#define RT2880_I2C_PAN_TILT		1
#define RT2880_I2C_CONFIG_READ		2
#define RT2880_I2C_CONFIG_WRITE		3
#define RT2880_I2C_READ			4
#define RT2880_I2C_WRITE		5

#define I2C_DEV_NAME			"i2cM0"

/*---------------------------------------------------------------------*/
/* Symbol & Macro Definitions                                          */
/*---------------------------------------------------------------------*/

#define	RT2880_REG(x)			(*((volatile u32 *)(x)))
#define	RT2880_RSTCTRL_REG		(RALINK_SYSCTL_BASE+0x34)
#define RT2880_GPIOMODE_REG		(RALINK_SYSCTL_BASE+0x60)

#define RSTCTRL_I2C_RESET		RALINK_I2C_RST

#define RT2880_I2C_REG_BASE		(RALINK_I2C_BASE)
#define RT2880_I2C_CONFIG_REG		(RT2880_I2C_REG_BASE+0x00)
#define RT2880_I2C_CLKDIV_REG		(RT2880_I2C_REG_BASE+0x04)
#define RT2880_I2C_DEVADDR_REG		(RT2880_I2C_REG_BASE+0x08)
#define RT2880_I2C_ADDR_REG		(RT2880_I2C_REG_BASE+0x0C)
#define RT2880_I2C_DATAOUT_REG	 	(RT2880_I2C_REG_BASE+0x10)
#define RT2880_I2C_DATAIN_REG  		(RT2880_I2C_REG_BASE+0x14)
#define RT2880_I2C_STATUS_REG  		(RT2880_I2C_REG_BASE+0x18)
#define RT2880_I2C_STARTXFR_REG		(RT2880_I2C_REG_BASE+0x1C)
#define RT2880_I2C_BYTECNT_REG		(RT2880_I2C_REG_BASE+0x20)

/* I2C_CFG register bit field */
#define I2C_CFG_ADDRLEN_8		(7<<5)	/* 8 bits */
#define I2C_CFG_DEVADLEN_7		(6<<2)	/* 7 bits */
#define I2C_CFG_ADDRDIS			(1<<1)	/* disable address transmission*/
#define I2C_CFG_DEVADDIS		(1<<0)	/* disable device address transmission */

#define IS_BUSY				(RT2880_REG(RT2880_I2C_STATUS_REG) & 0x01)
#define IS_SDOEMPTY			(RT2880_REG(RT2880_I2C_STATUS_REG) & 0x02)
#define IS_DATARDY			(RT2880_REG(RT2880_I2C_STATUS_REG) & 0x04)

/* Instruction codes */
#define READ_CMD			0x01
#define WRITE_CMD			0x00
#define	WRITE_CMD_NODATA		0x02

#define CLKDIV_VALUE			851	// CPU=320M, I2C=(320M/3)/((2+CLKDIV)+5); 424=125K,851=62.5K
#define I2C_CFG_DEFAULT			(I2C_CFG_ADDRLEN_8 | I2C_CFG_DEVADLEN_7)
typedef struct _I2C_CONFIG {
	__u32	ConfigRegister;
	__u32	ClockDivisor;
	__u32	DeviceAddress;
} I2C_CONFIG, *pI2C_CONFIG;

typedef struct _I2C_READ_WRITE {
	__u32	Address;
	__u32	Data;
} I2C_READ_WRITE, *pI2C_READ_WRITE;

#define I2C_BUSY_LOOP			(CLKDIV_VALUE*30)
#define max_ee_busy_loop		(CLKDIV_VALUE*25)

/*---------------------------------------------------------------------*/
/* I2C for pan-tilt command                                            */
/*---------------------------------------------------------------------*/
#define	PAN_TILT_DEVICE_ADDRESS		0x13
typedef struct _PAN_TILT_COMMAND {
	int	Function;
	union {
		int	Steps;		// Move Left/Right/Up/Down & Swing (for swing,0=default step)
		int	Speed;		// PT_FUNC_PAN_SPEED & PT_FUNC_TILT_SPEED
		int	Version;	// 0 - 255
		int	SwitchStatus;	// bit 0:tilt , bit 1:pan ; limit switch status 0=OK, 1=fail
		int	MovingStatus;	// bit 0:tilt , bit 1:pan ; motor moving status 0=OFF, 1=ON
		int	Privacy;	// bit 0: 1=set privacy, 0= clear privacy mode and switch to run mode
		int	ActiveMode;	// 0x00= RunMode, 0x11=StandBy Mode, 0x22=Boot Mode, 0x33=Privacy Mode
	};
	union {
		int	PanPosition;	// Home/Position
		int	LoopCount;	// Swing, 0=infinite loop
	};
	union {
		int	TiltPosition;	// Home/Position
		int	StayTime;	// Swing, 0=default delay time
	};
} PAN_TILT_COMMAND, *pPAN_TILT_COMMAND;

// Pan-Tilt Function
enum {
	PT_FUNC_GET_VERSION=0,
	PT_FUNC_GO_HOME,		// 1
	PT_FUNC_GET_HOME,		// 2
	PT_FUNC_CALIBRATION,		// 3
	PT_FUNC_GET_POTISION,		// 4
	PT_FUNC_MOVE_LEFT,		// 5
	PT_FUNC_MOVE_RIGHT,		// 6
	PT_FUNC_MOVE_UP,		// 7
	PT_FUNC_MOVE_DOWN,		// 8
	PT_FUNC_GO_POSITION,		// 9
	PT_FUNC_PAN_SPEED,		// 10
	PT_FUNC_TILT_SPEED,		// 11
	PT_FUNC_GET_MAX_POSITION,	// 12
	PT_FUNC_GET_MIN_POSITION,	// 13
	PT_FUNC_LIMIT_SWITCH_TEST,	// 14
	PT_FUNC_LIMIT_SWITCH_STATUS,	// 15
	PT_FUNC_LOST_STEP_TEST_PAN,	// 16
	PT_FUNC_LOST_STEP_STATUS_PAN,	// 17
	PT_FUNC_LOST_STEP_TEST_TILT,	// 18
	PT_FUNC_LOST_STEP_STATUS_TILT,	// 19
	PT_FUNC_GET_MOVING_STATUS,	// 20
	PT_FUNC_SET_PRIVACY,		// 21
	PT_FUNC_GET_ACTIVE_MODE,	// 22
	PT_FUNC_MAX,
	//
	PT_FUNC_SWING_STATUS=100,
	PT_FUNC_SWING_STOP,		// 101
	PT_FUNC_SWING_PRESET,		// 102
	PT_FUNC_SWING_HORIZONTAL,	// 103
	PT_FUNC_SWING_VERTICAL,		// 104
	PT_FUNC_SWING_MAX,
};

// Pan-Tilt motor Sub Address
enum {
	PT_ADDRESS_FIRMWARE_VERSION=0,		// 0x00, Read only
	PT_ADDRESS_POWER_DOWN,			// 0x01, Write only
	PT_ADDRESS_WAKE_UP,			// 0x02, Read only
	PT_ADDRESS_POWER_STATUS,		// 0x03, Read only
	PT_ADDRESS_MOTOR_STATUS,		// 0x04
	PT_ADDRESS_TILT_DEFAULT_STEP_H,		// 0x05
	PT_ADDRESS_TILT_DEFAULT_STEP_L,		// 0x06
	PT_ADDRESS_TILT_MAX_STEP_H,		// 0x07
	PT_ADDRESS_TILT_MAX_STEP_L,		// 0x08
	PT_ADDRESS_TILT_MIN_STEP_H,		// 0x09
	PT_ADDRESS_TILT_MIN_STEP_L,		// 0x0A
	PT_ADDRESS_PAN_DEFAULT_STEP_H,		// 0x0B
	PT_ADDRESS_PAN_DEFAULT_STEP_L,		// 0x0C
	PT_ADDRESS_PAN_MAX_STEP_H,		// 0x0D
	PT_ADDRESS_PAN_MAX_STEP_L,		// 0x0E
	PT_ADDRESS_PAN_MIN_STEP_H,		// 0x0F
	PT_ADDRESS_PAN_MIN_STEP_L,		// 0x10
	PT_ADDRESS_TILT_HOME_STEP_H,		// 0x11
	PT_ADDRESS_TILT_HOME_STEP_L,		// 0x12
	PT_ADDRESS_PAN_HOME_STEP_H,		// 0x13
	PT_ADDRESS_PAN_HOME_STEP_L,		// 0x14
	PT_ADDRESS_TILT_MOTOR_STATUS,		// 0x15
	PT_ADDRESS_TILT_SHIFT_STEP_H,		// 0x16
	PT_ADDRESS_TILT_SHIFT_STEP_L,		// 0x17
	PT_ADDRESS_TILT_SHIFT_TARGET_STEP_H,	// 0x18
	PT_ADDRESS_TILT_SHIFT_TARGET_STEP_L,	// 0x19
	PT_ADDRESS_PAN_MOTOR_STATUS,		// 0x1A
	PT_ADDRESS_PAN_SHIFT_STEP_H,		// 0x1B
	PT_ADDRESS_PAN_SHIFT_STEP_L,		// 0x1C
	PT_ADDRESS_PAN_SHIFT_TARGET_STEP_H,	// 0x1D
	PT_ADDRESS_PAN_SHIFT_TARGET_STEP_L,	// 0x1E
	PT_ADDRESS_TILT_MOTOR_SPEED,		// 0x1F
	PT_ADDRESS_PAN_MOTOR_SPEED,		// 0x20
	PT_ADDRESS_TILT_CURRENT_STEP_H,		// 0x21
	PT_ADDRESS_TILT_CURRENT_STEP_L,		// 0x22
	PT_ADDRESS_PAN_CURRENT_STEP_H,		// 0x23
	PT_ADDRESS_PAN_CURRENT_STEP_L,		// 0x24
	PT_ADDRESS_TILT_MOVE_TARGET_STEP_H,	// 0x25
	PT_ADDRESS_TILT_MOVE_TARGET_STEP_L,	// 0x26
	PT_ADDRESS_PAN_MOVE_TARGET_STEP_H,	// 0x27
	PT_ADDRESS_PAN_MOVE_TARGET_STEP_L,	// 0x28
	PT_ADDRESS_TILT_LOST_STEP_H,		// 0x29
	PT_ADDRESS_TILT_LOST_STEP_L,		// 0x2A
	PT_ADDRESS_PAN_LOST_STEP_H,		// 0x2B
	PT_ADDRESS_PAN_LOST_STEP_L,		// 0x2C
	PT_ADDRESS_LIMIT_SWITCH_STATUS,		// 0x2D
	PT_ADDRESS_MOTOR_MOVING_STATUS,		// 0x2E
	PT_ADDRESS_TILE_STEP_PER_DEGREE,	// 0x2F
	PT_ADDRESS_PAN_STEP_PER_DEGREE,		// 0x30
	PT_ADDRESS_TILT_MAX_SITE_BUFFER_STEPS_H,// 0x31		PT_ADDRESS_TILT_UP_BUFFER_STEPS_H
	PT_ADDRESS_TILT_MAX_SITE_BUFFER_STEPS_L,// 0x32		PT_ADDRESS_TILT_UP_BUFFER_STEPS_L
	PT_ADDRESS_TILT_MIN_SITE_BUFFER_STEPS_H,// 0x33		PT_ADDRESS_TILT_DOWN_BUFFER_STEPS_H
	PT_ADDRESS_TILT_MIN_SITE_BUFFER_STEPS_L,// 0x34		PT_ADDRESS_TILT_DOWN_BUFFER_STEPS_L
	PT_ADDRESS_PAN_MAX_SITE_BUFFER_STEPS_H,	// 0x35		PT_ADDRESS_PAN_LEFT_BUFFER_STEPS_H
	PT_ADDRESS_PAN_MAX_SITE_BUFFER_STEPS_L,	// 0x36		PT_ADDRESS_PAN_LEFT_BUFFER_STEPS_L
	PT_ADDRESS_PAN_MIN_SITE_BUFFER_STEPS_H,	// 0x37		PT_ADDRESS_PAN_RIGHT_BUFFER_STEPS_H
	PT_ADDRESS_PAN_MIN_SITE_BUFFER_STEPS_L,	// 0x38		PT_ADDRESS_PAN_RIGHT_BUFFER_STEPS_L
	PT_ADDRESS_MAX,
};
// PT_ADDRESS_POWER_STATUS, 0x03
#define	PT_ACTIVE_MODE_RUN			0x00
#define	PT_ACTIVE_MODE_STANDBY			0x11
#define	PT_ACTIVE_MODE_BOOT			0x22
#define	PT_ACTIVE_MODE_PRIVACY			0x33
// PT_ADDRESS_MOTOR_STATUS, 0x04
#define PT_MOTOR_STATUS_CALIBRATION		(1 << 0)
#define PT_MOTOR_STATUS_HOME			(1 << 1)
#define PT_MOTOR_STATUS_PRIVACY			(1 << 2)
#define PT_MOTOR_STATUS_TILT_LOST_STEP_TEST	(1 << 3)
#define PT_MOTOR_STATUS_PAN_LOST_STEP_TEST	(1 << 4)
#define PT_MOTOR_STATUS_PAN_TILT_GOTO_POSITION	(1 << 5)
#define PT_MOTOR_STATUS_CHANGE_MOTOR_SPEED	(1 << 6)
// PT_ADDRESS_LIMIT_SWITCH_STATUS, 0x2D
#define PT_LIMIT_SWITCH_STATUS_TILT_FAIL	(1 << 0)
#define PT_LIMIT_SWITCH_STATUS_PAN_FAIL		(1 << 1)
#define PT_LIMIT_SWITCH_STATUS_RIGHT_ALARM	(1 << 4)
#define PT_LIMIT_SWITCH_STATUS_LEFT_ALARM	(1 << 5)
#define PT_LIMIT_SWITCH_STATUS_DOWN_ALARM	(1 << 6)
#define PT_LIMIT_SWITCH_STATUS_UP_ALARM		(1 << 7)
// PT_ADDRESS_MOTOR_MOVING_STATUS, 0x2E
#define	PT_MOTOR_STATUS_TILT_ON			(1 << 0)
#define	PT_MOTOR_STATUS_PAN_ON			(1 << 1)

#define	PAN_MOTOR_ASCENDING_FOR_LEFT		0
#define	TILT_MOTOR_ASCENDING_FOR_UP		1

#endif	// __I2CDRV_H
