


#define DEBUG_MOTION_DETECTION 	0

struct IMG
{
    unsigned long sequence_num;
    unsigned long frame_len;
};


#define	IS_MOTION_FRAME		0x0001
#define GET_MOTION_FRAME	0x0002
#define RELEASE_MOTION_FRAME    0x0004


struct FRM
{
    unsigned long my_buffer_addr;
    struct FRM *link_up;
    struct FRM *link_down;
    short user_type;
    short lock_count;
    unsigned short max_lock_count;  
    unsigned short frame_flag;      
    unsigned long free_time;
    unsigned short ticks_interval;
    unsigned long sequence_num;
    unsigned long frame_len;
};

struct FRAME
{
    struct FRM Frame_Header;
    char       Frame_Data;
};

struct FrameInfo
{
    unsigned short FrmReso;
    unsigned short FrmComp;
    unsigned short FrmRate;
};

#define USER_TYPE_INTERNET	0x5678
#define USER_TYPE_LOCAL 	0x5679


short Frame_Empty_List_Queue(struct FRM *pFRM);
struct FRM *Frame_Empty_List_DeQueue(void);
short Frame_Ready_List_Queue(struct FRM *pFRM);
struct FRM *Frame_Ready_List_DeQueue(void);
short Frame_Lock_List_Queue(struct FRM *pFRM);
short Frame_Lock_List_DeQueue(struct FRM *pFRM);
struct FRM *Frame_Lock_List_Newest(unsigned long sequence_num);
struct FRM *Frame_Lock_List_InternetNewest(unsigned long sequence_num);
unsigned long Frame_List_Init(void);
unsigned long Frame_Get_Size(void);
struct FRM *Frame_Get_Image(unsigned long prev_sequence_num, unsigned short ticks_interval, unsigned short frame_flag);
short Frame_Release_Image(struct FRM *pFRM);
short Frame_Clear(void);

