.\" Copyright (c) 1994-1996, 1998-2005, 2007
.\" 	Todd C. Miller <Todd.Miller@courtesan.com>
.\" 
.\" Permission to use, copy, modify, and distribute this software for any
.\" purpose with or without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
.\" WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
.\" MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
.\" ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
.\" WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
.\" ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
.\" OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\" 
.\" Sponsored in part by the Defense Advanced Research Projects
.\" Agency (DARPA) and Air Force Research Laboratory, Air Force
.\" Materiel Command, USAF, under agreement number F39502-99-1-0512.
.\" 
.\" $Sudo: sudo.man.in,v 1.29.2.24 2008/03/05 13:05:05 millert Exp $
.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` 
.    ds C' 
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "SUDO 8"
.TH SUDO 8 "February 19, 2008" "1.6.9p14" "MAINTENANCE COMMANDS"
.SH "NAME"
sudo, sudoedit \- execute a command as another user
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBsudo\fR \fB\-h\fR | \fB\-K\fR | \fB\-k\fR | \fB\-L\fR | \fB\-l\fR | \fB\-V\fR | \fB\-v\fR
.PP
\&\fBsudo\fR [\fB\-bEHPS\fR]
.\" [\fB\-a\fR\ \fIauth_type\fR]
.\" [\fB\-c\fR\ \fIclass\fR|\fI\-\fR]
[\fB\-p\fR\ \fIprompt\fR]
.\" [\fB\-r\fR\ \fIrole\fR] [\fB\-t\fR\ \fItype\fR]
[\fB\-u\fR\ \fIusername\fR|\fI#uid\fR]
[\fB\s-1VAR\s0\fR=\fIvalue\fR] {\fB\-i\fR\ |\ \fB\-s\fR\ |\ \fIcommand\fR}
.PP
\&\fBsudoedit\fR [\fB\-S\fR]
.\" [\fB\-a\fR\ \fIauth_type\fR]
.\" [\fB\-c\fR\ \fIclass\fR|\fI\-\fR]
[\fB\-p\fR\ \fIprompt\fR] [\fB\-u\fR\ \fIusername\fR|\fI#uid\fR]
file ...
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBsudo\fR allows a permitted user to execute a \fIcommand\fR as the
superuser or another user, as specified in the \fIsudoers\fR file.
The real and effective uid and gid are set to match those of the
target user as specified in the passwd file and the group vector
is initialized based on the group file (unless the \fB\-P\fR option was
specified).  If the invoking user is root or if the target user is
the same as the invoking user, no password is required.  Otherwise,
\&\fBsudo\fR requires that users authenticate themselves with a password
by default (\s-1NOTE:\s0 in the default configuration this is the user's
password, not the root password).  Once a user has been authenticated,
a timestamp is updated and the user may then use sudo without a
password for a short period of time (\f(CW\*(C`5\*(C'\fR minutes unless
overridden in \fIsudoers\fR).
.PP
When invoked as \fBsudoedit\fR, the \fB\-e\fR option (described below),
is implied.
.PP
\&\fBsudo\fR determines who is an authorized user by consulting the file
\&\fI/etc/sudoers\fR.  By giving \fBsudo\fR the \fB\-v\fR flag, a user
can update the time stamp without running a \fIcommand\fR. The password
prompt itself will also time out if the user's password is not
entered within \f(CW\*(C`5\*(C'\fR minutes (unless overridden via
\&\fIsudoers\fR).
.PP
If a user who is not listed in the \fIsudoers\fR file tries to run a
command via \fBsudo\fR, mail is sent to the proper authorities, as
defined at configure time or in the \fIsudoers\fR file (defaults to
\&\f(CW\*(C`root\*(C'\fR).  Note that the mail will not be sent if an unauthorized
user tries to run sudo with the \fB\-l\fR or \fB\-v\fR flags.  This allows
users to determine for themselves whether or not they are allowed
to use \fBsudo\fR.
.PP
If \fBsudo\fR is run by root and the \f(CW\*(C`SUDO_USER\*(C'\fR environment variable
is set, \fBsudo\fR will use this value to determine who the actual
user is.  This can be used by a user to log commands through sudo
even when a root shell has been invoked.  It also allows the \fB\-e\fR
flag to remain useful even when being run via a sudo-run script or
program.  Note however, that the sudoers lookup is still done for
root, not the user specified by \f(CW\*(C`SUDO_USER\*(C'\fR.
.PP
\&\fBsudo\fR can log both successful and unsuccessful attempts (as well
as errors) to \fIsyslog\fR\|(3), a log file, or both.  By default \fBsudo\fR
will log via \fIsyslog\fR\|(3) but this is changeable at configure time
or via the \fIsudoers\fR file.
.SH "OPTIONS"
.IX Header "OPTIONS"
\&\fBsudo\fR accepts the following command line options:
.\" .IP "\-a" 4
.\" .IX Item "-a"
.\" The \fB\-a\fR (\fIauthentication type\fR) option causes \fBsudo\fR to use the
.\" specified authentication type when validating the user, as allowed
.\" by \fI/etc/login.conf\fR.  The system administrator may specify a list
.\" of sudo-specific authentication methods by adding an \*(L"auth\-sudo\*(R"
.\" entry in \fI/etc/login.conf\fR.  This option is only available on systems
.\" that support \s-1BSD\s0 authentication.
.IP "\-b" 4
.IX Item "-b"
The \fB\-b\fR (\fIbackground\fR) option tells \fBsudo\fR to run the given
command in the background.  Note that if you use the \fB\-b\fR
option you cannot use shell job control to manipulate the process.
.\" .IP "\-c" 4
.\" .IX Item "-c"
.\" The \fB\-c\fR (\fIclass\fR) option causes \fBsudo\fR to run the specified command
.\" with resources limited by the specified login class.  The \fIclass\fR
.\" argument can be either a class name as defined in \f(CW\*(C`/etc/login.conf\*(C'\fR,
.\" or a single '\-' character.  Specifying a \fIclass\fR of \f(CW\*(C`\-\*(C'\fR indicates
.\" that the command should be run restricted by the default login
.\" capabilities for the user the command is run as.  If the \fIclass\fR
.\" argument specifies an existing user class, the command must be run
.\" as root, or the \fBsudo\fR command must be run from a shell that is already
.\" root.  This option is only available on systems with \s-1BSD\s0 login classes.
.IP "\-E" 4
.IX Item "-E"
The \fB\-E\fR (\fIpreserve\fR \fIenvironment\fR) option will override the
\&\fIenv_reset\fR option in \fIsudoers\fR\|(5)).  It is only
available when either the matching command has the \f(CW\*(C`SETENV\*(C'\fR tag
or the \fIsetenv\fR option is set in \fIsudoers\fR\|(5).
.IP "\-e" 4
.IX Item "-e"
The \fB\-e\fR (\fIedit\fR) option indicates that, instead of running
a command, the user wishes to edit one or more files.  In lieu
of a command, the string \*(L"sudoedit\*(R" is used when consulting
the \fIsudoers\fR file.  If the user is authorized by \fIsudoers\fR
the following steps are taken:
.RS 4
.IP "1." 4
Temporary copies are made of the files to be edited with the owner
set to the invoking user.
.IP "2." 4
The editor specified by the \f(CW\*(C`VISUAL\*(C'\fR or \f(CW\*(C`EDITOR\*(C'\fR environment
variables is run to edit the temporary files.  If neither \f(CW\*(C`VISUAL\*(C'\fR
nor \f(CW\*(C`EDITOR\*(C'\fR are set, the program listed in the \fIeditor\fR \fIsudoers\fR
variable is used.
.IP "3." 4
If they have been modified, the temporary files are copied back to
their original location and the temporary versions are removed.
.RE
.RS 4
.Sp
If the specified file does not exist, it will be created.  Note
that unlike most commands run by \fBsudo\fR, the editor is run with
the invoking user's environment unmodified.  If, for some reason,
\&\fBsudo\fR is unable to update a file with its edited version, the
user will receive a warning and the edited copy will remain in a
temporary file.
.RE
.IP "\-H" 4
.IX Item "-H"
The \fB\-H\fR (\fI\s-1HOME\s0\fR) option sets the \f(CW\*(C`HOME\*(C'\fR environment variable
to the homedir of the target user (root by default) as specified
in \fIpasswd\fR\|(5).  By default, \fBsudo\fR does not modify \f(CW\*(C`HOME\*(C'\fR
(see \fIset_home\fR and \fIalways_set_home\fR in \fIsudoers\fR\|(5)).
.IP "\-h" 4
.IX Item "-h"
The \fB\-h\fR (\fIhelp\fR) option causes \fBsudo\fR to print a usage message and exit.
.IP "\-i" 4
.IX Item "-i"
The \fB\-i\fR (\fIsimulate initial login\fR) option runs the shell specified
in the \fIpasswd\fR\|(5) entry of the user that the command is
being run as.  The command name argument given to the shell begins
with a `\f(CW\*(C`\-\*(C'\fR' to tell the shell to run as a login shell.  \fBsudo\fR
attempts to change to that user's home directory before running the
shell.  It also initializes the environment, leaving \fI\s-1TERM\s0\fR
unchanged, setting \fI\s-1HOME\s0\fR, \fI\s-1SHELL\s0\fR, \fI\s-1USER\s0\fR, \fI\s-1LOGNAME\s0\fR, and
\&\fI\s-1PATH\s0\fR, and unsetting all other environment variables.  Note that
because the shell to use is determined before the \fIsudoers\fR file
is parsed, a \fIrunas_default\fR setting in \fIsudoers\fR will specify
the user to run the shell as but will not affect which shell is
actually run.
.IP "\-K" 4
.IX Item "-K"
The \fB\-K\fR (sure \fIkill\fR) option is like \fB\-k\fR except that it removes
the user's timestamp entirely.  Like \fB\-k\fR, this option does not
require a password.
.IP "\-k" 4
.IX Item "-k"
The \fB\-k\fR (\fIkill\fR) option to \fBsudo\fR invalidates the user's timestamp
by setting the time on it to the Epoch.  The next time \fBsudo\fR is
run a password will be required.  This option does not require a password
and was added to allow a user to revoke \fBsudo\fR permissions from a .logout
file.
.IP "\-L" 4
.IX Item "-L"
The \fB\-L\fR (\fIlist\fR defaults) option will list out the parameters
that may be set in a \fIDefaults\fR line along with a short description
for each.  This option is useful in conjunction with \fIgrep\fR\|(1).
.IP "\-l" 4
.IX Item "-l"
The \fB\-l\fR (\fIlist\fR) option will list out the allowed (and
forbidden) commands for the invoking user on the current host.
.IP "\-P" 4
.IX Item "-P"
The \fB\-P\fR (\fIpreserve\fR \fIgroup vector\fR) option causes \fBsudo\fR to
preserve the invoking user's group vector unaltered.  By default,
\&\fBsudo\fR will initialize the group vector to the list of groups the
target user is in.  The real and effective group IDs, however, are
still set to match the target user.
.IP "\-p" 4
.IX Item "-p"
The \fB\-p\fR (\fIprompt\fR) option allows you to override the default
password prompt and use a custom one.  The following percent (`\f(CW\*(C`%\*(C'\fR')
escapes are supported:
.RS 4
.ie n .IP "%H" 4
.el .IP "\f(CW%H\fR" 4
.IX Item "%H"
expanded to the local hostname including the domain name
(on if the machine's hostname is fully qualified or the \fIfqdn\fR
\&\fIsudoers\fR option is set)
.ie n .IP "%h" 4
.el .IP "\f(CW%h\fR" 4
.IX Item "%h"
expanded to the local hostname without the domain name
.ie n .IP "%p" 4
.el .IP "\f(CW%p\fR" 4
.IX Item "%p"
expanded to the user whose password is being asked for (respects the
\&\fIrootpw\fR, \fItargetpw\fR and \fIrunaspw\fR flags in \fIsudoers\fR)
.ie n .IP "%U" 4
.el .IP "\f(CW%U\fR" 4
.IX Item "%U"
expanded to the login name of the user the command will
be run as (defaults to root)
.ie n .IP "%u" 4
.el .IP "\f(CW%u\fR" 4
.IX Item "%u"
expanded to the invoking user's login name
.ie n .IP "\*(C`%%\*(C'" 4
.el .IP "\f(CW\*(C`%%\*(C'\fR" 4
.IX Item "%%"
two consecutive \f(CW\*(C`%\*(C'\fR characters are collapsed into a single \f(CW\*(C`%\*(C'\fR character
.RE
.RS 4
.RE
.\" .IP "\-r" 4
.\" .IX Item "-r"
.\" The \fB\-r\fR (\fIrole\fR) option causes the new (SELinux) security context to 
.\" have the role specified by \fIrole\fR.
.IP "\-S" 4
.IX Item "-S"
The \fB\-S\fR (\fIstdin\fR) option causes \fBsudo\fR to read the password from
the standard input instead of the terminal device.
.IP "\-s" 4
.IX Item "-s"
The \fB\-s\fR (\fIshell\fR) option runs the shell specified by the \fI\s-1SHELL\s0\fR
environment variable if it is set or the shell as specified
in \fIpasswd\fR\|(5).
.\" .IP "\-t" 4
.\" .IX Item "-t"
.\" The \fB\-t\fR (\fItype\fR) option causes the new (SELinux) security context to 
.\" have the type specified by \fItype\fR.  If no type is specified, the default
.\" type is derived from the specified role.
.IP "\-u" 4
.IX Item "-u"
The \fB\-u\fR (\fIuser\fR) option causes \fBsudo\fR to run the specified
command as a user other than \fIroot\fR.  To specify a \fIuid\fR instead
of a \fIusername\fR, use \fI#uid\fR.  When running commands as a \fIuid\fR,
many shells require that the '#' be escaped with a backslash ('\e').
Note that if the \fItargetpw\fR Defaults option is set (see \fIsudoers\fR\|(5))
it is not possible to run commands with a uid not listed in the
password database.
.IP "\-V" 4
.IX Item "-V"
The \fB\-V\fR (\fIversion\fR) option causes \fBsudo\fR to print the version
number and exit.  If the invoking user is already root the \fB\-V\fR
option will print out a list of the defaults \fBsudo\fR was compiled
with as well as the machine's local network addresses.
.IP "\-v" 4
.IX Item "-v"
If given the \fB\-v\fR (\fIvalidate\fR) option, \fBsudo\fR will update the
user's timestamp, prompting for the user's password if necessary.
This extends the \fBsudo\fR timeout for another \f(CW\*(C`5\*(C'\fR minutes
(or whatever the timeout is set to in \fIsudoers\fR) but does not run
a command.
.IP "\-\-" 4
The \fB\-\-\fR flag indicates that \fBsudo\fR should stop processing command
line arguments.  It is most useful in conjunction with the \fB\-s\fR flag.
.PP
Environment variables to be set for the command may also be passed
on the command line in the form of \fB\s-1VAR\s0\fR=\fIvalue\fR, e.g.
\&\fB\s-1LD_LIBRARY_PATH\s0\fR=\fI/usr/local/pkg/lib\fR.  Variables passed on the
command line are subject to the same restrictions as normal environment
variables with one important exception.  If the \fIsetenv\fR option
is set in \fIsudoers\fR, the command to be run has the \f(CW\*(C`SETENV\*(C'\fR tag
set or the command matched is \f(CW\*(C`ALL\*(C'\fR, the user may set variables
that would overwise be forbidden.  See \fIsudoers\fR\|(5) for more information.
.SH "RETURN VALUES"
.IX Header "RETURN VALUES"
Upon successful execution of a program, the return value from \fBsudo\fR
will simply be the return value of the program that was executed.
.PP
Otherwise, \fBsudo\fR quits with an exit value of 1 if there is a
configuration/permission problem or if \fBsudo\fR cannot execute the
given command.  In the latter case the error string is printed to
stderr.  If \fBsudo\fR cannot \fIstat\fR\|(2) one or more entries in the user's
\&\f(CW\*(C`PATH\*(C'\fR an error is printed on stderr.  (If the directory does not
exist or if it is not really a directory, the entry is ignored and
no error is printed.)  This should not happen under normal
circumstances.  The most common reason for \fIstat\fR\|(2) to return
\&\*(L"permission denied\*(R" is if you are running an automounter and one
of the directories in your \f(CW\*(C`PATH\*(C'\fR is on a machine that is currently
unreachable.
.SH "SECURITY NOTES"
.IX Header "SECURITY NOTES"
\&\fBsudo\fR tries to be safe when executing external commands.
.PP
There are two distinct ways to deal with environment variables.
By default, the \fIenv_reset\fR \fIsudoers\fR option is enabled.
This causes commands to be executed with a minimal environment
containing \f(CW\*(C`TERM\*(C'\fR, \f(CW\*(C`PATH\*(C'\fR, \f(CW\*(C`HOME\*(C'\fR, \f(CW\*(C`SHELL\*(C'\fR, \f(CW\*(C`LOGNAME\*(C'\fR, \f(CW\*(C`USER\*(C'\fR
and \f(CW\*(C`USERNAME\*(C'\fR in addition to variables from the invoking process
permitted by the \fIenv_check\fR and \fIenv_keep\fR \fIsudoers\fR options.
There is effectively a whitelist for environment variables.
.PP
If, however, the \fIenv_reset\fR option is disabled in \fIsudoers\fR, any
variables not explicitly denied by the \fIenv_check\fR and \fIenv_delete\fR
options are inherited from the invoking process.  In this case,
\&\fIenv_check\fR and \fIenv_delete\fR behave like a blacklist.  Since it
is not possible to blacklist all potentially dangerous environment
variables, use of the default \fIenv_reset\fR behavior is encouraged.
.PP
In all cases, environment variables with a value beginning with
\&\f(CW\*(C`()\*(C'\fR are removed as they could be interpreted as \fBbash\fR functions.
The list of environment variables that \fBsudo\fR allows or denies is
contained in the output of \f(CW\*(C`sudo \-V\*(C'\fR when run as root.
.PP
Note that the dynamic linker on most operating systems will remove
variables that can control dynamic linking from the environment of
setuid executables, including \fBsudo\fR.  Depending on the operating
system this may include \f(CW\*(C`_RLD*\*(C'\fR, \f(CW\*(C`DYLD_*\*(C'\fR, \f(CW\*(C`LD_*\*(C'\fR, \f(CW\*(C`LDR_*\*(C'\fR,
\&\f(CW\*(C`LIBPATH\*(C'\fR, \f(CW\*(C`SHLIB_PATH\*(C'\fR, and others.  These type of variables are
removed from the environment before \fBsudo\fR even begins execution
and, as such, it is not possible for \fBsudo\fR to preserve them.
.PP
To prevent command spoofing, \fBsudo\fR checks \*(L".\*(R" and "" (both denoting
current directory) last when searching for a command in the user's
\&\s-1PATH\s0 (if one or both are in the \s-1PATH\s0).  Note, however, that the
actual \f(CW\*(C`PATH\*(C'\fR environment variable is \fInot\fR modified and is passed
unchanged to the program that \fBsudo\fR executes.
.PP
\&\fBsudo\fR will check the ownership of its timestamp directory
(\fI/var/run/sudo\fR by default) and ignore the directory's contents if
it is not owned by root or if it is writable by a user other than
root.  On systems that allow non-root users to give away files via
\&\fIchown\fR\|(2), if the timestamp directory is located in a directory
writable by anyone (e.g., \fI/tmp\fR), it is possible for a user to
create the timestamp directory before \fBsudo\fR is run.  However,
because \fBsudo\fR checks the ownership and mode of the directory and
its contents, the only damage that can be done is to \*(L"hide\*(R" files
by putting them in the timestamp dir.  This is unlikely to happen
since once the timestamp dir is owned by root and inaccessible by
any other user, the user placing files there would be unable to get
them back out.  To get around this issue you can use a directory
that is not world-writable for the timestamps (\fI/var/adm/sudo\fR for
instance) or create \fI/var/run/sudo\fR with the appropriate owner (root)
and permissions (0700) in the system startup files.
.PP
\&\fBsudo\fR will not honor timestamps set far in the future.
Timestamps with a date greater than current_time + 2 * \f(CW\*(C`TIMEOUT\*(C'\fR
will be ignored and sudo will log and complain.  This is done to
keep a user from creating his/her own timestamp with a bogus
date on systems that allow users to give away files.
.PP
Please note that \fBsudo\fR will normally only log the command it
explicitly runs.  If a user runs a command such as \f(CW\*(C`sudo su\*(C'\fR or
\&\f(CW\*(C`sudo sh\*(C'\fR, subsequent commands run from that shell will \fInot\fR be
logged, nor will \fBsudo\fR's access control affect them.  The same
is true for commands that offer shell escapes (including most
editors).  Because of this, care must be taken when giving users
access to commands via \fBsudo\fR to verify that the command does not
inadvertently give the user an effective root shell.  For more
information, please see the \f(CW\*(C`PREVENTING SHELL ESCAPES\*(C'\fR section in
\&\fIsudoers\fR\|(5).
.SH "ENVIRONMENT"
.IX Header "ENVIRONMENT"
\&\fBsudo\fR utilizes the following environment variables:
.ie n .IP "\*(C`EDITOR\*(C'" 16
.el .IP "\f(CW\*(C`EDITOR\*(C'\fR" 16
.IX Item "EDITOR"
Default editor to use in \fB\-e\fR (sudoedit) mode if \f(CW\*(C`VISUAL\*(C'\fR is not set
.ie n .IP "\*(C`HOME\*(C'" 16
.el .IP "\f(CW\*(C`HOME\*(C'\fR" 16
.IX Item "HOME"
In \fB\-s\fR or \fB\-H\fR mode (or if sudo was configured with the
\&\-\-enable\-shell\-sets\-home option), set to homedir of the target user
.ie n .IP "\*(C`PATH\*(C'" 16
.el .IP "\f(CW\*(C`PATH\*(C'\fR" 16
.IX Item "PATH"
Set to a sane value if the \fIsecure_path\fR sudoers option is set.
.ie n .IP "\*(C`SHELL\*(C'" 16
.el .IP "\f(CW\*(C`SHELL\*(C'\fR" 16
.IX Item "SHELL"
Used to determine shell to run with \f(CW\*(C`\-s\*(C'\fR option
.ie n .IP "\*(C`SUDO_PROMPT\*(C'" 16
.el .IP "\f(CW\*(C`SUDO_PROMPT\*(C'\fR" 16
.IX Item "SUDO_PROMPT"
Used as the default password prompt
.ie n .IP "\*(C`SUDO_COMMAND\*(C'" 16
.el .IP "\f(CW\*(C`SUDO_COMMAND\*(C'\fR" 16
.IX Item "SUDO_COMMAND"
Set to the command run by sudo
.ie n .IP "\*(C`SUDO_USER\*(C'" 16
.el .IP "\f(CW\*(C`SUDO_USER\*(C'\fR" 16
.IX Item "SUDO_USER"
Set to the login of the user who invoked sudo
.ie n .IP "\*(C`SUDO_UID\*(C'" 16
.el .IP "\f(CW\*(C`SUDO_UID\*(C'\fR" 16
.IX Item "SUDO_UID"
Set to the uid of the user who invoked sudo
.ie n .IP "\*(C`SUDO_GID\*(C'" 16
.el .IP "\f(CW\*(C`SUDO_GID\*(C'\fR" 16
.IX Item "SUDO_GID"
Set to the gid of the user who invoked sudo
.ie n .IP "\*(C`SUDO_PS1\*(C'" 16
.el .IP "\f(CW\*(C`SUDO_PS1\*(C'\fR" 16
.IX Item "SUDO_PS1"
If set, \f(CW\*(C`PS1\*(C'\fR will be set to its value
.ie n .IP "\*(C`USER\*(C'" 16
.el .IP "\f(CW\*(C`USER\*(C'\fR" 16
.IX Item "USER"
Set to the target user (root unless the \fB\-u\fR option is specified)
.ie n .IP "\*(C`VISUAL\*(C'" 16
.el .IP "\f(CW\*(C`VISUAL\*(C'\fR" 16
.IX Item "VISUAL"
Default editor to use in \fB\-e\fR (sudoedit) mode
.SH "FILES"
.IX Header "FILES"
.IP "\fI/etc/sudoers\fR" 24
.IX Item "/etc/sudoers"
List of who can run what
.IP "\fI/var/run/sudo\fR" 24
.IX Item "/var/run/sudo"
Directory containing timestamps
.SH "EXAMPLES"
.IX Header "EXAMPLES"
Note: the following examples assume suitable \fIsudoers\fR\|(5) entries.
.PP
To get a file listing of an unreadable directory:
.PP
.Vb 1
\& $ sudo ls /usr/local/protected
.Ve
.PP
To list the home directory of user yazza on a machine where the
file system holding ~yazza is not exported as root:
.PP
.Vb 1
\& $ sudo -u yazza ls ~yazza
.Ve
.PP
To edit the \fIindex.html\fR file as user www:
.PP
.Vb 1
\& $ sudo -u www vi ~www/htdocs/index.html
.Ve
.PP
To shutdown a machine:
.PP
.Vb 1
\& $ sudo shutdown -r +15 "quick reboot"
.Ve
.PP
To make a usage listing of the directories in the /home
partition.  Note that this runs the commands in a sub-shell
to make the \f(CW\*(C`cd\*(C'\fR and file redirection work.
.PP
.Vb 1
\& $ sudo sh -c "cd /home ; du -s * | sort -rn > USAGE"
.Ve
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fIgrep\fR\|(1), \fIsu\fR\|(1), \fIstat\fR\|(2),
.\" \&\fIlogin_cap\fR\|(3),
\&\fIpasswd\fR\|(5), \fIsudoers\fR\|(5), \fIvisudo\fR\|(8)
.SH "AUTHORS"
.IX Header "AUTHORS"
Many people have worked on \fBsudo\fR over the years; this
version consists of code written primarily by:
.PP
.Vb 2
\&        Todd C. Miller
\&        Chris Jepeway
.Ve
.PP
See the \s-1HISTORY\s0 file in the \fBsudo\fR distribution or visit
http://www.sudo.ws/sudo/history.html for a short history
of \fBsudo\fR.
.SH "CAVEATS"
.IX Header "CAVEATS"
There is no easy way to prevent a user from gaining a root shell
if that user is allowed to run arbitrary commands via \fBsudo\fR.
Also, many programs (such as editors) allow the user to run commands
via shell escapes, thus avoiding \fBsudo\fR's checks.  However, on
most systems it is possible to prevent shell escapes with \fBsudo\fR's
\&\fInoexec\fR functionality.  See the \fIsudoers\fR\|(5) manual
for details.
.PP
It is not meaningful to run the \f(CW\*(C`cd\*(C'\fR command directly via sudo, e.g.,
.PP
.Vb 1
\& $ sudo cd /usr/local/protected
.Ve
.PP
since when the command exits the parent process (your shell) will
still be the same.  Please see the \s-1EXAMPLES\s0 section for more information.
.PP
If users have sudo \f(CW\*(C`ALL\*(C'\fR there is nothing to prevent them from
creating their own program that gives them a root shell regardless
of any '!' elements in the user specification.
.PP
Running shell scripts via \fBsudo\fR can expose the same kernel bugs that
make setuid shell scripts unsafe on some operating systems (if your \s-1OS\s0
has a /dev/fd/ directory, setuid shell scripts are generally safe).
.SH "BUGS"
.IX Header "BUGS"
If you feel you have found a bug in \fBsudo\fR, please submit a bug report
at http://www.sudo.ws/sudo/bugs/
.SH "SUPPORT"
.IX Header "SUPPORT"
Limited free support is available via the sudo-users mailing list,
see http://www.sudo.ws/mailman/listinfo/sudo\-users to subscribe or
search the archives.
.SH "DISCLAIMER"
.IX Header "DISCLAIMER"
\&\fBsudo\fR is provided ``\s-1AS\s0 \s-1IS\s0'' and any express or implied warranties,
including, but not limited to, the implied warranties of merchantability
and fitness for a particular purpose are disclaimed.  See the \s-1LICENSE\s0
file distributed with \fBsudo\fR or http://www.sudo.ws/sudo/license.html
for complete details.
