#######################################################################
##
## Embedded Target Makefile (ISD2)
## Realtek 8196C 1T1R 11n SOC Router
## Product: TEW735AP
## Author: Jimmy Ho
## History: Copy frome (Engenius)eap150_300
#######################################################################

PRODUCT_NAME=TEW735AP
CONFIG_TEW735AP=y
CONFIG_NO_BRAND=n
export CONFIG_USE_COMBINED_FW_IMAGE=y


CONFIG_REALTEK_PLATFORM=y
CONFIG_REALTEK_RTL_819X_PLATFORM=y
CONFIG_REALTEK_AP_APCLI=y

CONFIG_VLAN_SUPPORT=y
CONFIG_HAS_MINIUPNPD=n
CONFIG_WSC_UPNP_SUPPORT=y
#######################################################################
#
# Kernel setting (overwrite the setting in config.make) 
# 
#######################################################################
#KERNEL_VER =  2.6.30
#KERNEL_DIR =  linux-2.6.30
#KERNEL_FULL_DIR = $(TOP_DIR)/$(PLATFORM)/$(KERNEL_DIR)
#KIMAGE_DIR = $(KERNEL_FULL_DIR)/images
#KERNEL_HEADERS_INCLUDE = -I$(KERNEL_FULL_DIR)/include
#KERNEL_ZIP =  linux-2.6.30.gz
#ZIMAGE_DIR = $(TOP_DIR)/IXP42x/$(KERNEL_DIR)/arch/mips/boot/zImage
#BZIMAGE_DIR = $(TOP_DIR)/IXP42x/$(KERNEL_DIR)/arch/mips/boot/bzImage
#AUTOCONF_H_DIR   = $(KERNEL_FULL_DIR)/include/linux
#KCFLAGS= -D__KERNEL__ -I$(KERNEL_FULL_DIR)/include -O2 \
         -fno-strict-aliasing -fno-common -fomit-frame-pointer \
         -I$(KERNEL_FULL_DIR)/include/asm/gcc -G 0 -mno-abicalls \
         -fno-pic -pipe  -finline-limit=100000 -march=4181 -mabi=32 \
         -Wa,--trap -DMODULE -mlong-calls

#KCFLAGS= -D__KERNEL__ -I$(KERNEL_FULL_DIR)/include -march=4181 -mno-check-zero-division -mabi=32 -mno-abicalls -msoft-float -auxbase-strip -Os -Wall -Wundef -Wstrict-prototypes -Wno-trigraphs -Werror-implicit-function-declaration -Wdeclaration-after-statement -Werror -fno-strict-aliasing -fno-common -fno-delete-null-pointer-checks -ffunction-sections -fno-pic -ffreestanding -fomit-frame-pointer 

#KCFLAGS= -D__KERNEL__ -I$(KERNEL_FULL_DIR)/include  -march=4181 -mno-check-zero-division -mabi=32 -mno-abicalls -msoft-float -auxbase-strip -Os -Wall -Wundef -Wstrict-prototypes -Wno-trigraphs -Werror-implicit-function-declaration -Wdeclaration-after-statement -fno-strict-aliasing -fno-common -fno-delete-null-pointer-checks -ffunction-sections -fno-pic



#######################################################################
#
# System Related (RTL8196C platform)
#
#######################################################################
# Applications use ramdisk
CONFIG_HAS_INITRAMFS=y
CONFIG_HAS_APPSCORE_ON_MTD=n
CONFIG_MOUNT_APPSCORE_AT_CONFIG_INIT2=y

# Flash sector size
CONFIG_FLASH_SECTOR_SIZE=4096   ###this value is depending on flash sectore size
                                ###please refer to HW spec
CONFIG_SUPPORT_AUTH_TOOL=y
CONFIG_REALTEK_SUPPORT_WPS=y
#######################################################################
# Lib Related
#######################################################################
# Applications use libgcc
export CONFIG_USE_RTL4181_LIB_GCC=y
# Applications use rtk math library
export CONFIG_USE_RTLIB_MATH=y
# Applications use libmath
export CONFIG_USE_LIBMATH=y
# Applications use libz
export CONFIG_USE_LIBZ=y
# Applications use librt
export CONFIG_USE_LIBRT=y
# Applications use libssl
export CONFIG_USE_LIBSSL=n
# Applications use matrix_ssl (https)
export CONFIG_USE_LIB_MATRIXSSL=y
#####################################################################
##
## RADIO Setting
## cfho 2008-0722
## The sysconfd can config up to two radios (ra+ath, 2 ra, or 2 ath)
########################################################################
CONFIG_HAS_RADIO_SETTING=y
CONFIG_SUPPORT_MULTI_WLAN_PLATFORM=y
#######################################################################
#
# System config daemon modules, sysutil, Ap_cfg, httpd
# 
#######################################################################
CONFIG_NEW_WLAN_SETTINGS=y
CONFIG_HAS_TELNET_CLI=y
CONFIG_HAS_SSHD=y
# CLI setting in GUI, CLI, SNMP
CONFIG_HAS_CLI_SETTING=y
CONFIG_POWER_SAVING_WLAN=n
CONFIG_AP_PROFILE=y
CONFIG_MULTIDMZ_SUPPORT=n
CONFIG_USE_PRODUCT_ID=y
CONFIG_HAS_INSTALL_WIZARD=y
CONFIG_HAS_QOS_ENGENIUS=y
CONFIG_HAS_QOS_SITECOM=n
CONFIG_HAS_QOS_TC=y
CONFIG_SCHEDULE_ENGENIUS=y
#Adonn 11-0316: EAP not support Router
CONFIG_STATIC_ROUTE_ENGENIUS=n
CONFIG_USE_PRODUCT_ID=y
CONFIG_HAS_LLTD=y
CONFIG_HAS_NETBIOS_FUNCTION=n
CONFIG_HAS_NETBIOSD=y
CONFIG_PACKET_HANDLER=y
# CONFIG_PACKET_HANDLER_PASSTHROUGH is not set
CONFIG_PACKET_HANDLER_PASSME=y
CONFIG_PPPOE_JAPAN=n
CONFIG_WAN_MANAGER=n
CONFIG_RTL_WLAN_CFG_ON_STORAGE=n
CONFIG_HAS_TR_AGENT=n
#Adonn 11-0316: EAP not support WAN
CONFIG_HAS_ONLY_LAN_FUNCTION=y
# syslog sent to network
CONFIG_SUPPORT_LOG_TO_NETWORK=n
CONFIG_COUNT_BY_EACH_STA=y
CONFIG_HAS_LED_CONTROL=y
CONFIG_HAS_EBTABLE=y
CONFIG_HAS_EBTABLE_SSID_ISOLATION=y
CONFIG_NOT_SUPPORT_FIREWALL_LOG=y
CONFIG_AP_BRIDGE_HAS_DHCP_SERVER=y
CONFIG_HAS_ADVANCED_STP=y
CONFIG_HAS_LOCAL_NTP_SERVER=y
# lan dns
CONFIG_HAS_DNS_CLIENT_FUNCTION=y
CONFIG_SUPPORT_APPS_SQSH_CHECK=y
#######################################################################
#
# IPv6 Settings (sysconfig ipv6 setting)
# 
#######################################################################
CONFIG_SUPPORT_IPV6_SETTING=y
CONFIG_HAS_TC_IPROUTE=y
CONFIG_SUPPORT_IPV6_6RD=n
CONFIG_SUPPORT_IPV6_DSLITE=n
#######################################################################
#
# Modifcations in iptables v1.4.4
# 
#######################################################################
CONFIG_IPTABLES_SUPPORT_IPV6=y
#######################################################################
#
# TurboNAT/TurboBridge
# 
#######################################################################
CONFIG_HAS_TURBO_NAT=n
CONFIG_HAS_TURBO_NAT_BRIDGE=n
CONFIG_HAS_TURBO_NAT_DOS_FILTER=n
CONFIG_HAS_TURBO_NAT_URL_FILTER=n
#######################################################################
#
# Fastpath NAT
# 
#######################################################################
CONFIG_HAS_FASTPATH=y
CONFIG_HAS_FASTPATH_BRIDGE=n
CONFIG_HAS_FASTPATH_DOS_FILTER=n
CONFIG_HAS_FASTPATH_URL_FILTER=y
#######################################################################
#
# Wireless LAN (RTL8188, 8192)
# 
#######################################################################
#First, we disable the RALINK config in sysconfigd
CONFIG_NOT_SUPPORT_RALINK_WLAN=y
CONFIG_HAS_REALTEK_WLAN=y
CONFIG_HAS_REALTEK_WLAN_8192_8188=y
CONFIG_HAS_REALTEK_WLAN_A_BAND=y
CONFIG_AUTO_CHANNEL=y
CONFIG_RTL_WSC_SUPPORT_CLIENT_MODE=n
#Support Realtek Universal Repeater Mode#
CONFIG_RTL_REPEATER_MODE_SUPPORT=y
CONFIG_HAS_SINGLE_RADIO_REPEATER=y
#Support Realtek Client Bridge Mode#
CONFIG_RTL_CLIENT_MODE_SUPPORT=y
CONFIG_HAS_WLAN_STA_FUNCTION=y
CONFIG_RTL_WSC_SUPPORT_WPSV1=y
##--------------------------------------------------------------------##
#cfho 2010-0611, we build the wlan driver with kerenl, this should be 'n'
CONFIG_WLAN_DRIVER_BUILD_IN_MODULE=n

ifeq ($(CONFIG_WLAN_DRIVER_BUILD_IN_MODULE),y)
# CONFIG_RTL865X_LANPORT_RESTRICTION is not set
CONFIG_RTL_IVL_SUPPORT=y
CONFIG_RTL_IPTABLES_RULE_2_ACL=y
CONFIG_RTL865X_MBUF_HEADROOM=128
CONFIG_RTL_ETH_PRIV_SKB=y
CONFIG_EXTRTL8212_PHYID_P1=18
CONFIG_EXTRTL8212_PHYID_P3=20
CONFIG_EXTRTL8212_PHYID_P5=22
CONFIG_RTL_HARDWARE_MULTICAST=y
# CONFIG_RTL_HARDWARE_NAT is not set
# CONFIG_RTL_PROC_DEBUG is not set
# CONFIG_RTL865X_ROMEPERF is not set
CONFIG_RTK_VLAN_SUPPORT=y
# CONFIG_MESH_ENABLE is not set
# CONFIG_RTL_UNKOWN_UNICAST_CONTROL is not set
# CONFIG_PHONE is not set
#### WLAN Driver, copy from .config of kernel
CONFIG_RTL_819X=y
CONFIG_RTL_8196C_GW=y
CONFIG_RTL8196C_REVISION_B=y
CONFIG_RTL8196C_GREEN_ETHERNET=y
CONFIG_RTL_PCIE_SIMPLE_INIT=y
CONFIG_RTL_WTDOG=y
CONFIG_RTK_VLAN_SUPPORT=y
# CONFIG_WLAN_PRE80211 is not set
# CONFIG_WLAN_80211 is not set
CONFIG_RTL8192CD=m
CONFIG_RTL8190_PRIV_SKB=y
CONFIG_RTL_WDS_SUPPORT=y
# CONFIG_RTL_DFS_SUPPORT is not set
CONFIG_RTL_VAP_SUPPORT=y
# CONFIG_ENABLE_EFUSE is not set
# CONFIG_RTL_WAPI_SUPPORT is not set
CONFIG_RTL_COMAPI_CFGFILE=y
CONFIG_RTL_COMAPI_WLTOOLS=y
CONFIG_PCIE_POWER_SAVING=y
# CONFIG_RTL_92D_SUPPORT is not set
 
endif ## CONFIG_WLAN_DRIVER_BUILD_IN_MODULE
##--------------------------------------------------------------------##

#######################################################################
#
# Ethernet Switch LAN (RTL8196C)
# 
#######################################################################
#CONFIG_HAS_RTL819X_ETH_SWITCH=y
#The WAN port is on ethernet port #4 (the 5th port). This config is defined in the kernel config in Ralink kernel
CONFIG_WAN_AT_P4=y

#######################################################################
#
# Unix Util (Mount, swapon, swapoff )
# 
#######################################################################
CONFIG_UNIT_UTIL_HAS_NO_SWAPONOFF=y

#######################################################################
#
# Modifcations in busybox (udhcpd)
# 
#######################################################################
CONFIG_HAS_FIXED_MANAGEMENT_IP_IN_AP_MODE=y

#######################################################################
#
# Language File
# 
#######################################################################
HAS_MULTIPLE_LANGUAGE=n
HAS_RUSSIAN_LANGUAGE=n

# jerry: install language files in web_EG_ODM
HAS_ITALIAN_LANGUAGE=n
HAS_TRADITIONAL_CHINESE_LANGUAGE=y
HAS_SIMPLIFIED_CHINESE_LANGUAGE=y
HAS_JAPANESE_LANGUAGE=n

CONFIG_APCFG_USE_STORAGE2=n
CONFIG_HAS_FWM=y
CONFIG_USE_SIMPLE_TIMEZONE_TABLE=y

CONFIG_HTTPD_REMOTEPORT=n
CONFIG_HTTPD_HAS_SSL=y

# disable buttom image
CONFIG_WEB_NONE_BOTTOM_IMG=y

#######################################################################
# Linuxigd (libupnpd)
#######################################################################
#CONFIG_LIBUPNPD_THREAD_IDLE_TIME=1000
#CONFIG_LIBUPNPD_JOBS_PER_THREAD=2
#CONFIG_LIBUPNPD_MIN_THREADS=1 
#CONFIG_LIBUPNPD_MAX_THREADS=2 
#CONFIG_LIBUPNPD_OPT_DISABLE_CLIENTS=y
#CONFIG_LIBUPNPD_OPT_DISABLE_SAMPLES=y
#######################################################################
#
# Web
# 
#######################################################################
#MRTG is Multi Router Traffic Grapher. Include mrtg, gd, libpng#
CONFIG_HAS_MRTG=y
CONFIG_USE_WEB_SCR_MINI=y


# jerry chen: Allow users to make port forwarding changes through UPnP
CONFIG_UPNPD_PORTFORWARDING=n

# joey : Use old method, use html to login
CONFIG_WEB_USE_HTML_LOGIN=y
#Leonard: if use html web login, you can choise which one style you need.
CONFIG_WEB_USE_LOGIN_STYLE_2=n

#Support WEB upgrade DDWRT Software
CONFIG_HAS_SUPPORT_DDWRT=y
CONFIG_HAS_ADVANCE_WMM_SETTING=n

# Adonn : Support 802.1d spanning tree advanced settngs
CONFIG_HAS_ADVANCED_STP=y

CONFIG_OMIT_POWERSAVING=y

#20121109 stevenlin: web_ECB use TRENDNET style
CONFIG_WEB_USE_TRENDNET_STYLE=y

CONFIG_HTTPD_HAS_XML_AGENT=y

CONFIG_SUPPORT_REPEATER_EASYSETUP=y

WEB_INSTALL_FILE = \
picture/logo_trendnet_735.gif:picture/logo.gif
#######################################################################
#
# Modifcations in net-snmp
#
#######################################################################
#
CONFIG_SNMPD_SUPPORT=y
CONFIG_SNMP_TRAP_SUPPORT=y
CONFIG_NETSNMP_DISABLE_SNMPV3=y
SNMP_MIB_MODULES_INCLUDED_ENTERPRISE= senao/entSystem senao/entSNMP senao/entLAN senao/entMacFilter senao/entMultiWlan
SNMP_ENTERPRISE_OID=14125
SNMP_ENTERPRISE_SYSOID=.1.3.6.1.4.1.14125.100.1.3
SNMP_MIB_MODULES_INCLUDED_NMS = engenius/EngeniusMesh
#engenius/privateSystem engenius/privateClientTable engenius/privateMacAccess
#20110110 Jason:snmp support wlan client list info
CONFIG_SNMP_WLAN_CLIENTLIST=y
# Only allow specific IP to access DUT via SNMP
CONFIG_SNMP_MANAGEMENT_IP_SUPPORT=y

#######################################################################
#
# factory configuration
# 
#######################################################################
CONFIG_HAS_REALTEK_GPIO=y
CONFIG_FACTORY_SUPPORT_LED_TESTING=y


#######################################################################
#
# NO PRINTF configuration
#
#######################################################################
CONFIG_NO_PRINTF_APCFG=y
CONFIG_NO_PRINTF_SYSUTIL=n
CONFIG_NO_PRINTF_SYSCONFIG=n
CONFIG_NO_PRINTF_WEB=n
CONFIG_NO_PRINTF_RMGMT=y
CONFIG_NO_PRINTF_MINIUPNPD=n
CONFIG_NO_PRINTF_WSCD=y
CONFIG_NO_PRINTF_IPROUTE=y
CONFIG_NO_PRINTF_NTPCLIENT=y
CONFIG_NO_PRINTF_DNSMASQ=y

