/*****************************************************************************
;
;   (C) Unpublished Work of Senao Networks, Inc.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF SENAO INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) SENAO EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN SENAO WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF SENAO.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project :
;    Creator :
;    File    : sn_flash_map.h
;    Abstract: Flash partition related
;
;       Modification History:
;       By              Date     Ver.   Modification Description
;       --------------- -------- -----  --------------------------------------
;
;*****************************************************************************/

#ifndef _SN_FLASH_MAP_H_
#define _SN_FLASH_MAP_H_

#include <linux/mtd/partitions.h>

/*-------------------------------------------------------------------------*/
/*                        RTL8198 SOC Flash map                           */
/*-------------------------------------------------------------------------*/
#define USER_DEFINITION_FLASH_MAP
#define DYNAMIC_UDPATE_PARTITION_TBL    1   /*dynamic update cb-app partition table offset*/
/* combine firmware type:
   1. Kernel | app
   2. app    | cb-app */
#define COMBINED_FW_IMAGE_TYPE      1 

#define MTD_WRITEABLE				0x400

static struct mtd_partition physmap_partitions_t[] = {
        {
                name:           "Bootloader",  /* mtdblock0 */
                size:           0x10000,			/* 64KB */
                offset:         0,
        }, {
                name:           "caldata",		/* mtdblock1 */
                size:           0x2000,         /* 8KB */
                offset:         0x10000,
        }, {
                name:           "Config",		/* mtdblock2 */
                size:           0x6000,			/* 24KB */
                offset:         0x12000,
        }, {
                name:           "Kernel",		/* mtdblock3 */
                size:           0x3C4000,		/* 3856KB, Combined image, it is KNL+APP size */
                offset:         0x18000,
        }, {
                name:           "app",			/* mtdblock4 */
                size:           0x200000,
                offset:         0x1C8000,
        }, {
                name:           "manufacture", 	/* mtdblock5 */
                size:           0xC000,			/* 48KB */
                offset:         0x3DC000,
        }, {
                name:           "backup", 		/* mtdblock6 */
                size:           0x8000,		/* 32KB */
                offset:         0x3E8000,
        }, {
                name:           "storage", 
                size:           0x10000,			/* mtdblock7 */
                offset:         0x3F0000,		/* 64KB */
        }
};

#endif /*SN_FLASH_MAP_T*/
