/**
 * $Id: config.h,v 1.1.1.1 2003/06/22 02:40:00 cfho Exp $
 * $Author: cfho $
 * $Date: 2003/06/22 02:40:00 $
 * $Locker:  $
 * $Revision: 1.1.1.1 $
 *
 * Send comments to: 
 *
 * Copyright (C) , SENAO INTERNATIONAL CO., LTD All rights reserved.
 * No part of this document may be reproduced in any form or by any 
 * means or used to make any derivative work (such as translation,
 * transformation, or adaptation) without permission from Senao
 * Corporation.
 */

#ifndef _GCONFIG_H_
#define _GCONFIG_H_

/**
 * IMPORTANT NOTE:
 * DO NOT modify any part of this file for board-specific customization. That
 * should be done in the 'board_xxx.h' file, where xxx="name of the board".
 */


/* #include "supportwlan.h" */



#ifdef __cplusplus
extern "C" {
#endif

/*-------------------------------------------------------------------------*/
/* Linux Kernel Version Information */
/*-------------------------------------------------------------------------*/
#define KERNEL_VERSION_NUM(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#define LINUX_VER_CODE KERNEL_VERSION_NUM(2,6,30)

#define IPTABLES_VERSION_NUM(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#define IPTABLES_VER_CODE IPTABLES_VERSION_NUM(1,4,4)


/*-------------------------------------------------------------------------*/
/*                        HW Features                                      */
/*-------------------------------------------------------------------------*/
#define HAS_IXP_NPE         0
#define HAS_MII_CMD         0
#define HAS_PBX             0
#define HAS_DNS_PROXY       0  //Adonn 111207: EAP not support WAN function
#define HAS_HW_DSP          0
#define HAS_HW_CPLD         0
#define HAS_HW_GPIO_BUTTONS      1       /* We should either use CPLD or GPIO */
#define HAS_HW_FXS          0
#define HAS_HW_RTC          0
#define HAS_HW_USB          0
#define HAS_MAC_CLONE       0  //Adonn 110316: EAP not support WAN function
#define HAS_PPPOE_MAC_CLONE 0  //Adonn 110316: EAP not support WAN function
#define HAS_IGMPPROXY       0
/*#define HAS_POWER_SAVING        1*/
#define HAS_BANDWIDTH_MONITOR   1
#define HAS_SWITCH_5_VLAN       0
/*-------------------------------------------------------------------------*/
/*                        Partition Info                                   */
/*-------------------------------------------------------------------------*/
/********* MTD partition numbers *******************************/
#define BOOTLOADER_PARTITION_NAME			"Bootloader"
#define FACTORY_PARTITION_NAME				"manufacture"
#define KERNEL_PARTITION_NAME				"Kernel"
#define APP_STORAGE_PARTITION_NAME          "app"
#define COMBINED_APP_PARTITION_NAME         "cb-app"
#define SOUNDS_STORAGE_PARTITION_NAME       "sounds"
#define MTD_STORAGE_PARTITION_NAME          "storage"
#define MTD_VOICE_PARTITION_NAME            "voice"
#define TINY_APP_STORAGE_PARTITION_NAME     "littleapp"
#define FACTORY_APP_STORAGE_PARTITION_NAME  "manufacture"
#define MTD_BACKUP_PARTITION_NAME           "backup"
#define CONFIG_PARTITION_NAME               "Config"
/*following are used in seconfig, config_init*/
#define UBOOT_ENV_PARTITION "/dev/mtd2"
#define RF_DATA_PARTITION "/dev/mtd1"
#define BACKUP_PARTITION "/dev/mtd5"
#define APP_DIR "/apps"
#define STORAGE_DIR "/storage"
#define SOUNDS_DIR "/sounds"
#define USBDISK_DEV "/dev/sda1"
#define USBDISK_PATH "/mnt/usb"
#define FACTORY_DIR "/factory"
#define MAXIMUM_DISKSPACE_FOR_FW_UPGRADE    (1024*2)
#define FW_UPGRADE_IN_PROGRESS_FILE         FIRMWARE_UPAGRADE_TAG_FILE
#define MAX_TMPFS_NODES                     "64"

/*-------------------------------------------------------------------------*/
/*                        Interface name                                   */
/*-------------------------------------------------------------------------*/

/**
 * Now, we need to override potential destructive defines that were not correctly
 * setup in the include directive above.
 */

/**
 * The following variables define which logical linux nexwork devices
 * are to be assigned the function of LAN/WAN/WLAN, etc.
 *
 * WAN_DEV: WAN port network device.
 * ETHER_DEV:   LAN (802.1d) ethernet device.
 * WLAN_A_DEV:  802.11a wireless device.
 * WLAN_B_DEV:  802.11b wireless device.
 */


/* define the device interface name */
#define LOOP_DEV     "lo"          /* The loop-back device */
#define WANBRG_DEV   "br1"
#define BRG_DEV      "br0"     /* There is ALWAYS a bridge device on the ISD */
#define ETH_GMMI_1_DEV      "eth0"  /*   */


#define ETHER_A_DEV  "eth0"     /* LAN interface, configed by vconfig*/
#define ETHER_B_DEV  "eth0"     /* WAN interface, configed by vconfig*/
#define ETHER_C_DEV  "eth2"     /* DMZ interface, configed by vconfig*/
#define ETHER_D_DEV  "eth3"     /* WAN interface, configed by vconfig*/
#define ETHER_E_DEV  "eth4"     /* DMZ interface, configed by vconfig*/

#define WLAN_G_DEV  "wlan0"
#define PPP_DEV     "ppp0"

#define MAX_VLAN_DEV_NUM  4
/* 2010-01-26 use WLAN_SSID_NUM to replace MAX_SSID_NUM */
/* #define MAX_SSID_NUM  4 */


#define WDS_DEV_NUM  4
#define WDS_DEV     "wds"
#define WDS_DEV_    "wlan0-wds" 	
#define WDS_0_DEV   "wlan0-wds0"
#define WDS_1_DEV   "wlan0-wds1"
#define WDS_2_DEV   "wlan0-wds2"
#define WDS_3_DEV   "wlan0-wds3"

/** 
* Realtek AP mode
* AP_interface : wlan0, wlan0-va1, wlan0-va2
*
* Realtek Repeater mode
* AP_interface: wlan0-vxd
* Repeater_interface: wlan0 Note: multiple ssid is not supported
* in repeater mode.
*
* Realtek CB/CR mode
* station interface: wlan0
*/

#define APCLI_DEV   WLAN_G_DEV
#define RTL_REPEATER_DEV	"wlan0-vxd"

#define AGING_TIME  "0x0065"

#define HAS_LOADBALANCE_FUNCTION 0

#define SUPPORT_TWO_BOTTON  1
#define SUPPORT_DOUBLE_VLAN_TAG 1

#if HAS_LOADBALANCE_FUNCTION

#define WAN1_DEV	ETHER_B_DEV
#define ETHER_DEV	ETHER_A_DEV
#define LAN_DEV		WLAN_G_DEV //ETHER_A_DEV  
#define DMZ_DEV     ETHER_C_DEV  

/* Has Second WAN */
#define HAS_WAN2_DEV 0

/* Has Third WAN */
//#define HAS_WAN3_DEV

/* Has fourth WAN */
//#define HAS_WAN4_DEV 1

#else

#define WAN1_DEV	ETHER_B_DEV
#define ETHER_DEV	ETHER_A_DEV 
#define LAN_DEV		ETHER_A_DEV  
#define DMZ_DEV     ETHER_C_DEV  

#endif

#define WAN_DEV WAN1_DEV

/*-------------------------------------------------------------------------*/
/*                        Normal define                                    */
/*-------------------------------------------------------------------------*/
/* marklin 20070525 : flash size = 256MB */
#define FLASH_SIZE_256MB 1

/* TODO!!!!!*/
#define WLAN_PUREG 1 /* cfho 2006-0314, for cli, get back and check it!*/
#define G_TYPE 1
/* END TODO!!!***/

/*************Router *****************/
#define CONFIG_TARGET 
// #define ROUTER_SUPPORT //Adonn 110316: EAP not support router

/* cfho 2010-0611, it is used by config_init, mmi and httpd */
#define G_MIN_START_YEAR    2010
#define G_MAX_END_YEAR      2037



/* kenny 2007-01-31 ,Firmware Upgrade :display time to web UI */

#define G_WEB_FWD_APP_NEED_TIME 100
#define G_WEB_FWD_KERNEL_NEED_TIME 60
#define G_WEB_FWD_NEED_KERNELAPP_TIME 30
#define WEB_APPLY_TIME 10
#undef TMP_DIR_SIZE

/* cfho 2007-1113, this file is used for firmware upgrade,
    when the fwmanager or web starts to erase the flash, they should
    write the mtd number to this file. When the whole firmware upgarde
    process has been completed (erase, write and check); they should 
    delete this File.
    The config_init will mount the /storage and check this file,
    if it finds this file, it will start the udhcpd, and backup web server
    for firmware upgrade. Once the firmware upgrade has been completed (OK),
    the config_init should delete this file and reboot the board  */
#define FIRMWARE_UPAGRADE_TAG_FILE "/storage/firmware_upg_tag.txt"
#define FIRMWARE_UPAGRADE_CHECKSUM_FILE "/storage/firmware_upg_chksum.txt"

/* web daemon port */
#define HTTP_PRIVATE_PORT  (8080)
#define HTTP_PRIVATE_PORT6 (80)

/*-------------------------------------------------------------------------*/
/*                        Has Functions                                    */
/*-------------------------------------------------------------------------*/
/**
 * Here, we include the file for "board_xxx.h" that defines default values for
 * each specific board.
 */

/**
 * SI-690B is an AP+Router+VOIP box

 */

/*jay 20070620*/
#define HAS_ADVANCED_ROUTE  0 //Adonn 110316: EAP not support Router
/* cfho 2007-0329, support L7 filtering in iptables, and WEB UI.
    we do not use L7 filtering because the IXP425 is not fast enough */
#define HAS_L7_FILTERING 0 
/* cfho 2007-0514, support PPTP server? */
#define HAS_PPTP_SERVER 0
/*jaykung20070704 support multiple ssid*/
#define HAS_MULTIPLE_SSID   1
/*jaykung 20070705 scroll in help datebase*/
#define HAS_SCROLL_FUNCTION 0
/*leonard 20100826 add for web to only show one version*/
#define HAS_SHOW_ONE_VERSION 1

/* cfho 2007-1008 support PPTP */
#define HAS_WAN_PPTP   0  //Adonn 110316: EAP not support WAN function
#define HAS_WAN_WLAN   0
#define HAS_WAN_PPPOE  0 //Adonn 110316: EAP not support WAN function
#define HAS_DMZ_IF_FUNCTION 0
#define DMZ_ELEMENTS 5

/* cfho 2008-0409 Maximum NAT session for ip conntrack table.
   Must be muplier of 8 */
/** cfho 2010-0701, because the free memory is not enough, limit it to 800+200 session. */
#define MAX_NAT_SESSION_NUM 20000

/* cfho 2010-0611 Tune for the Realtek RTL8192CD driver for the RTL8188 chip (1T1R) */
#define RTL8192CD_OPTIMIZE_FOR_RTL8188  1
#define RTL8192CD_OPTIMIZE_FOR_RTL8192  0

/* david, 20100819, optimize for ethernet/wlan driver buffer*/
#define OPTIMIZE_RTL819X_ETH_SKB_NUM    1

/** User can choice dns server which assigned by Dhcpd */
#define DNS_SERVERS_ASSIGNED_BY_DHCP_SERVER 1

/* Upload file will close some applications */
#define HTTPD_UPLOADFILE_WITH_CLOSE_MODULE  1

#define HAS_UPNP_GUI    0
/* Nelson 20100413 Fouce disable UPNP */
//#define HAS_DISABLED_UPNP_FUNCTION      1
/* AP Mode support dhcp client  */
#define HAS_DHCP_CLIENT_IN_AP_MODE  1
/* Repeater mode support dhcp client*/
#define HAS_DHCP_CLIENT_IN_REPEATER_MODE  1
/* LAN ( with VLAN tag) VLAN setting */
#define HAS_LAN_VLAN_MGMT 1
/* VLAN tag/untag*/
#define HAS_VLAN_TAG_UNTAG 1
#ifdef HAS_VLAN_TAG_UNTAG
#define BRG_UNTAG_DEV	"br3"
#endif
/* Zero Configuration Networking (Zeroconfig), is a set of techniques that automatically creates a usable
 *  *  *    IP network without configuration or special servers. */
#define HAS_ZERO_CONFIG_FUNCTION 1
/* Sunway 20100604 LAN VLAN ID can be same as WLAN  1:allow 0:check duplicate*/
#define OMIT_LAN_VLAN_ID_CHECK 1
/* Nelson 2010-0524 : for site survey wizard or logout page to skip AUTH check */
#define HAS_OMIT_AUTH_PAGE_CHECK 1

/*jason 20101026 support advanced isolation*/
#define HAS_ADVANCED_ISOLATED 1
/*tim 20111221 support WLAN with LAN isolation */
#define HAS_WLAN2LAN_ISOLATION  0

/*Let particular VLAN packets passthrough for Realtek switch*/
#define HAS_LET_PARTICULAR_VLAN_PKTS_PASS_SWITCH 1
/*Support bridge shortcut on Senao VLAN*/
#define FOR_BR_SHORTCUT_SENAO_VLAN 1

/*leonard 20110825 : Define tx-power setting with dBm.*/
#define HAS_TX_POWER_DBM_SETTING	1
#ifdef HAS_TX_POWER_DBM_SETTING
#define	TXPOWER_DBM_LOW	11
#define TXPOWER_DBM_HIGH 29
#endif

/*liwei 20111226 support disable TX power UI*/
#define HAS_DISABLE_TX_POWER_UI 0

/*liwei 20120106 change operation mode style*/
#define HAS_CHANGE_OPERATION_MODE_STYLE 1

#define HAS_WHITE_AND_BLACK_ACL         1

/* leonard 20120328 support 8021x radius accounting setting */
#define HAS_RADIUS_ACCOUNTING			0
/************************************************/
/* Config for sysutil                           */
/************************************************/
/* cfho 2010-0622, do not print out any messages*/
#define SYSUTIL_HAS_NO_TPRINTF 0
#define SYSUTIL_HAS_NO_SUPPORT_KERNEL_MODULES 1

/************************************************/
/* Config for sysconfd                          */
/************************************************/
#define SYSCONFD_FLUSH_CACHED_MEMORY_THRESHOLD (1.5*1024*1024)

/************************************************/
/*-------------------------------------------------------------------------*/
/*                        Specific Function Definition                     */
/*-------------------------------------------------------------------------*/
#define HAS_SYSTEM_SCHEDULE_FUNCTION 1
#define HAS_SCHEDULE_FUNCTION   0
/*jaykung 20070705 mac schedule function */
#define HAS_SCHEDULE_MACACL     0
#define HAS_WIRELESS_SCHEDULE   1
#define HAS_RESET_SCHEDULE      1
/* 20120817 liwei: If has wireless schedule and reset schedule, please add HAS_HIDDEN_SCHEDULE_RULE 
	to fix the issue for only enable reset schedule will down wireless. */
#define HAS_HIDDEN_SCHEDULE_RULE  1
#if HAS_ADVANCED_ROUTE
#define HAS_DYNAMIC_ROUTE 0
#define HAS_STATIC_ROUTE  1
#endif
//20110128 Tim:snmp support firmware update
#define SUPPORT_SNMP_FW_UPDATE   1

#define FOR_TRENDNET    					1
#define GEN_ADMIN_PASSWORD_BY_MACADDR		1
#define HAS_WLAN_TRENDNET_NEW_SSID_PWD   	1
#define USE_WPA2PSK_AS_DEFAULT_SECURITY 	1
#define USE_SN_WPA2PSK_TO_DEFAULT_SECURITY  1
#define HAS_HTTP_FIRST_LOGIN_DETECTION		1
#define HAS_HTTP_SYSTEM_NAME                1
/**************************/
/* Radio related settings */
/**************************/
#define HAS_SUPPORT_REALTEK_WLAN    1
#define RADIO_CARD_NUM  1
#define MAX_RADIO_NUM   RADIO_CARD_NUM
/*RADIO_SUPPORT_TYPE : 0: DISABLE, 1: RALINK, 2: ATHEROS, 3: REALTEK*/
#define RADIO1_PLATFORM	     3
#define RADIO2_PLATFORM	     0
/**************************/

#define WLAN_SSID_NUM 1
#define WLAN_DEV    "wlan"
#define WLAN_DEV_1  "wlan0"
#define	WLAN_DEV_   "wlan0-va"
#if HAS_MULTIPLE_SSID

/* second SSID */
#define HAS_WLAN2_DEV   1 
/* Third SSID */
#define HAS_WLAN3_DEV   1
/* Fourth SSID */
#define HAS_WLAN4_DEV   1

#if HAS_WLAN2_DEV		
#define WLAN_DEV_2        "wlan0-va0"
#undef  WLAN_SSID_NUM
#define WLAN_SSID_NUM     2 /* WLAN device numbers */
#endif

#if HAS_WLAN3_DEV
#define WLAN_DEV_3        "wlan0-va1"
#undef  WLAN_SSID_NUM
#define WLAN_SSID_NUM     3 /* WAN device numbers */
#ifndef HAS_WLAN2_DEV
#error "define HAS_WLAN2_DEV needed"
#endif
#endif

#if HAS_WLAN4_DEV
#define WLAN_DEV_4        "wlan0-va2"
#undef  WLAN_SSID_NUM
#define WLAN_SSID_NUM     4 /* WAN device numbers */
#ifndef HAS_WLAN3_DEV
#error "define HAS_WLAN3_DEV needed"
#endif
#endif

#endif /* HAS_MULTIPLE_SSID */

#ifdef ETHER_DEV 
#define HAS_ETHER_DEV 1 
#else        
#define HAS_ETHER_DEV 0
#endif

#ifdef WAN_DEV 
#define HAS_WAN_DEV 1 
#else        
#define HAS_WAN_DEV 0
#endif

#define WAN_DEV_NUM 1

#if HAS_WAN_DEV
#define HAS_MULTI_WAN_DEV 1
#endif

#if HAS_MULTI_WAN_DEV
#ifdef HAS_PPPOE_JAPAN
#define HAS_WAN2_DEV      1
#endif

#ifdef HAS_WAN2_DEV
#ifdef HAS_PPPOE_JAPAN
#define WAN2_DEV        ETHER_B_DEV
#endif
#define WAN2_DEV        ETHER_B_DEV
#undef  WAN_DEV_NUM
#define WAN_DEV_NUM     2 /* WAN device numbers */
#endif  /* HAS_WAN2_DEV */

#ifdef HAS_WAN3_DEV
#define WAN3_DEV        ETHER_C_DEV
#define WAN_DEV_NUM     3 /* WAN device numbers */
#ifndef HAS_WAN2_DEV
#error "define HAS_WAN2_DEV needed"
#endif
#endif /* HAS_WAN3_DEV */

#ifdef HAS_WAN4_DEV
#define WAN4_DEV        ETHER_D_DEV
#define WAN_DEV_NUM     4 /* WAN device numbers */
#ifndef HAS_WAN3_DEV
#error "define HAS_WAN3_DEV needed"
#endif
#endif /* HAS_WAN4_DEV */

#define WAN_MAX_NUM   WAN_DEV_NUM


#endif
#ifdef WLAN_G_DEV 
#define HAS_WLAN_G_DEV 1 
#else        
#define HAS_WLAN_G_DEV 0
#endif



#ifdef WLAN_A_DEV
#define HAS_WLAN_A_DEV 1
#else
#define HAS_WLAN_A_DEV 0
#endif

#ifdef WLAN_B_DEV
#define HAS_WLAN_B_DEV 1
#else
#define HAS_WLAN_B_DEV 0
#endif

#ifndef USE_UDHCPD
#define USE_ISC_DHCPD
#endif

#ifdef ROUTER_SUPPORT
#define HAS_ROUTER_SUPPORT 1
#define HAVE_ROUTER_FUNCTION 1
#define HAS_WAN_DEV        1
#define HAS_DNS_PROXY      1
#define PPTPD_SUPPORT  1
#define HAS_MEDIA_SUPPORT  0
#define WLAN_ACL_APCFG     1
#define IMQ_SUPPORT        1
#else
#define HAS_ROUTER_SUPPORT 0
#endif

#ifdef PRINTER_SUPPORT
#define HAS_PRINTER_SUPPORT 1
#else
#define HAS_PRINTER_SUPPORT 0
#endif

#ifdef PPTPD_SUPPORT
#define HAS_PPTPD_SUPPORT 1
#else
#define HAS_PPTPD_SUPPORT 0
#endif

#ifdef RADIUS_SUPPORT
#define HAS_RADIUS_SUPPORT 1
#else
#define HAS_RADIUS_SUPPORT 0
#endif

#ifdef MEDIA_SUPPORT
#define HAS_MEDIA_SUPPORT 1
#else
#define HAS_MEDIA_SUPPORT 0
#endif

#ifdef IMQ_SUPPORT
#define HAS_IMQ_SUPPORT 1
#else
#define HAS_IMQ_SUPPORT 0
#endif

#define HAS_WAN_STATUS_LED  0

#define HAS_QOS_HWPORT     0
#define HAS_QOS_PRIO_QUEUE 1
#define HAS_QOS_IP_LIMIT_QUEUE 0
#define QOS_BANDWIDTH_RATE_MAX  43000
#define NETPKT_PASSME_UNIT 100

#define HAS_APCLI_WPS      1
#define HAS_MULTI_OPMODE   1
#define HAS_MULTI_OPMODE_INTERFACE 1

#define HAS_NTP_USED_INDEX 1
#define HAS_MANUAL_TIME_SETTING 1

#define HAS_SPECIAL_PASS_THROUGH	0
#define SUPPORT_DETAILED_TIMEINFO 1
#define HAS_ADVANCED_PRIORITY_QUEUE 1

/* 2009/2/11 jerry: support total bandwidth setting for bandwidth allocation */
#define HAS_QOS_TOTAL_BANDWIDTH_SETTING 1

#define HAS_KERNEL_PPTP 0
#define HAS_MULTI_DNS_MODE			1

#define HAS_REALTEK_DEFAULT_THERMAL_VALUE	12

/* 20110916 leonard: use day light saving as Dlink style */
#define USE_STANDARD_DAYLIGHTSAVING 1

/* 20111216 Jason : remove wget function in ftp fwupg*/
#define HAS_NO_WGET_IN_FTPUPG	1
/* 20111216 Jason : reboot after ftp fwupg*/
#define HAS_REBOOT_AFTER_FTPUPG 1

/* BRG_DEV fix MAC address
 * The value should be 6 or 7
 * 6    : LAN MAC address
 * 7    : WAN MAC address  */
#define SUPPORT_BRG_DEV_FIX_MAC_ADDRESS_AS_X	6
/*-------------------------------------------------------------------------*/
/*                        Vendor (Unique)                                  */
/*-------------------------------------------------------------------------*/
#define FOR_SMC          0
#define FOR_SITECOM      0
#define FOR_EG	         1
#define FOR_EG_EAP9550   1 /* Model Name EAP9550 for EG */
/*-------------------------------------------------------------------------*/
/*                        Ethernet Port                                   */
/*-------------------------------------------------------------------------*/
#define HAS_SINGLE_ETH_PORT 1
/*-------------------------------------------------------------------------*/
/*                        Vendor Specials                                  */
/*-------------------------------------------------------------------------*/
/* 20110518 Jason: Use for sending trap in different vendor */
#define ENTERPRISE_TRAP_OID ".1.3.6.1.4.1.14125.100"
#define DEF_REGULAR_DOMAIN      1
#define HAS_HOTEL_FUNCTION      0
/*regular domain
0:1-11  1:1-13 2:10-11 3:10-13 4:14 5:1-14 6:3-9 7:5-13
*/

/*-------------------------------------------------------------------------*/
/*                        TR-069 Values                                    */
/*-------------------------------------------------------------------------*/
#define WANDEV_NUM    "1"
#define LANDEV_NUM    "4"
#define LAYER_1_UP_STREAM_MAX_BITRATE	"100"
#define LAYER_1_DOWN_STREAM_MAX_BITRATE "100"

/*---------------------------------------------*/
/*           APCFG_DEF_NUMBER VALUE            */
/*---------------------------------------------*/
#define NUM_PORT_QOS                            16
#define NUM_LAN_MAC_FILTERS                     32
#define NUM_IP_FILTERS 	                        32
#define NUM_URL_FILTER                          20
#define NUM_DHCPD_MACTOIP                       10
#define NUM_STATICROUTING                       20

#define NUM_MAC_FILTERS                         32
#define NUM_PORT_FORWARD                        32
#define NUM_NAT_VSERVER                         32
#define NUM_TRIGGER_PORT                        16
#define NAT_VSERVER_NAME_MAX                    25
#define NUM_SCHEDULE_LIST                       11
#define NUM_SPEC_APP_PUBLIC_PORT_LIST           10 /* 5 Pairs */
#define NUM_STA_CLIENT				64

#ifdef HAS_PPPOE_JAPAN
#define NUM_DUALWAN_ROUTING                                             10
#endif
#define NUM_NTP_SERVER							1

/*---------------------------------------------*/
/*           APCFG_DEF_VALUE                  */
/*-------------------------------------------*/

/*jaykung for WSCINFO*/
/* auto generated encryption type, 0: disable, 1: WPA-TKIP, 2: WPA2-AES, 3: WPA/WPA2 MIX*/
#define RTL_WSC_VENDOR_SECURITY_TYPE	3 
#define RTL_WSC_VENDOR_KEY_LENGTH		8 /*8~64*/
/*set realtek 2.4G and 5G led type, please refer to 8192cd.h enum led_type*/
#define RTL_WLAN_LED_2G_TYPE           	4
#if FOR_EG

#define VENDOR_NAME "TRENDnet"
#define VENDOR_MODE "Wireless-N Multi-function AP"
#define MODEL_NAME  "TEW735AP"
#define MODEL_NAME_FORHOSTNAME  "tew735ap"
#define WEB_TITLE_NAME  "2.4GHz Wireless-N "
#define MODEL_NUMBER  "735"

#define AP_WSC_MANUFACTURE     VENDOR_NAME" Technologies, Inc."
#define AP_WSC_MODEL_NAME      VENDOR_NAME" 2.4GHz Wireless-N Multi-function AP"
#define AP_WSC_DEVICE_NAME     VENDOR_NAME" 2.4GHz Wireless-N Multi-function AP"
#define CLI_WSC_MODEL_NAME     VENDOR_NAME" Wireless Client"
#define CLI_WSC_DEVICE_NAME    VENDOR_NAME" Client"
#define CLI_WSC_DEVICE_NAME_R  VENDOR_NAME" EX-Registrar"

#define MULTIPLE_FW_MODLE_NAME "TEW735AP"
#endif

#define LANMAC_HASCHANGED_TAG "/storage/lanMACChanged.tag"

#define SYSLOG_MESSAGE_SIZE 16000
/***************************************************************************/
/*-------------------------------------------------------------------------*/
/*                        Web OPMode List                                  */
/*-------------------------------------------------------------------------*/
#define WEB_OPMODE_LIST "0100110"
/* opmode list
   Definition: [SYS_OPM_ARRP][SYS_OPM_WDSB][SYS_OPM_CBRT][SYS_OPM_CB][SYS_OPM_AP][SYS_OPM_APRP][SYS_OPM_AR]
   Example:
        "0000011" : AR, APRP
        "0001101" : AR, AP, CB
*/

/* 20110525 leonard: support WDS Repeater */
#define HAS_OP_MODE_WDSRP 1

/*-------------------------------------------------------------------------*/
/*                        Web Function List                                */
/*-------------------------------------------------------------------------*/
#define WEB_HAS_DUAL_PPPOE				0
#define WEB_HAS_PASS_THROUGH			1
#define WEB_HAS_PORTBASED_QOS			0
#define WEB_HAS_WLAN_CONNECTION_CONTROL	0
/* 20110530 leonard: web support dynamic lan ip. */
#define WEB_HAS_DYNAMIC_LAN_IP			1
/* 20110518 leonard: special settings on GUI for eap serious products */
#define WEB_HAS_EAP_SPECIAL_SETTING	1
/* 20110531 leonard: add Schedule setting in WDS mode */
#define WEB_HAS_WDS_SCHEDULE_SETTING	1

#define WEB_HAS_SHOW_GW_INFO			1
/*-------------------------------------------------------------------------*/
/*                        RMGMT Settings                                   */
/*-------------------------------------------------------------------------*/
#define RMGMT_INTERFACE_BRG						BRG_DEV
#define RMGMT_INTERFACE_LAN						ETHER_A_DEV
#define RMGMT_INTERFACE_WLAN					WLAN_G_DEV



/*---------------------------------------------*/
/*           FACTORY_VALUE	                  */
/*-------------------------------------------*/
/*#define HAS_GET_FACTORY_IMG_FROM_TFTP				1*/
#define USING_WPS_LED_AS_INDICATOR					1

/*---------------------------------------------*/
/*                 Tim                         */
/*---------------------------------------------*/
#define DHCPD_HAS_OPTION_66     1

#ifdef __cplusplus
}
#endif

#define tr(x) x


#endif
