.SS dst
This module matches the parameters in Destination Options header
.TP
[\fB!\fP] \fB\-\-dst\-len\fP \fIlength\fP
Total length of this header in octets.
.TP
\fB\-\-dst\-opts\fP \fItype\fP[\fB:\fP\fIlength\fP][\fB,\fP\fItype\fP[\fB:\fP\fIlength\fP]...]
numeric type of option and the length of the option data in octets.
.SS eui64
This module matches the EUI-64 part of a stateless autoconfigured IPv6 address.
It compares the EUI-64 derived from the source MAC address in Ethernet frame
with the lower 64 bits of the IPv6 source address. But "Universal/Local"
bit is not compared. This module doesn't match other link layer frame, and
is only valid in the
.BR PREROUTING ,
.BR INPUT
and
.BR FORWARD
chains.
.SS frag
This module matches the parameters in Fragment header.
.TP
[\fB!\fP] \fB\-\-fragid\fP \fIid\fP[\fB:\fP\fIid\fP]
Matches the given Identification or range of it.
.TP
[\fB!\fP] \fB\-\-fraglen\fP \fIlength\fP
This option cannot be used with kernel version 2.6.10 or later. The length of
Fragment header is static and this option doesn't make sense.
.TP
\fB\-\-fragres\fP
Matches if the reserved fields are filled with zero.
.TP
\fB\-\-fragfirst\fP
Matches on the first fragment.
.TP
\fB\-\-fragmore\fP
Matches if there are more fragments.
.TP
\fB\-\-fraglast\fP
Matches if this is the last fragment.
.SS hbh
This module matches the parameters in Hop-by-Hop Options header
.TP
[\fB!\fP] \fB\-\-hbh\-len\fP \fIlength\fP
Total length of this header in octets.
.TP
\fB\-\-hbh\-opts\fP \fItype\fP[\fB:\fP\fIlength\fP][\fB,\fP\fItype\fP[\fB:\fP\fIlength\fP]...]
numeric type of option and the length of the option data in octets.
.SS hl
This module matches the Hop Limit field in the IPv6 header.
.TP
[\fB!\fP] \fB\-\-hl\-eq\fP \fIvalue\fP
Matches if Hop Limit equals \fIvalue\fP.
.TP
\fB\-\-hl\-lt\fP \fIvalue\fP
Matches if Hop Limit is less than \fIvalue\fP.
.TP
\fB\-\-hl\-gt\fP \fIvalue\fP
Matches if Hop Limit is greater than \fIvalue\fP.
.SS icmp6
This extension can be used if `\-\-protocol ipv6\-icmp' or `\-\-protocol icmpv6' is
specified. It provides the following option:
.TP
[\fB!\fP] \fB\-\-icmpv6\-type\fP \fItype\fP[\fB/\fP\fIcode\fP]|\fItypename\fP
This allows specification of the ICMPv6 type, which can be a numeric
ICMPv6
.IR type ,
.IR type
and
.IR code ,
or one of the ICMPv6 type names shown by the command
.nf
 ip6tables \-p ipv6\-icmp \-h
.fi
.SS iprange
This matches on a given arbitrary range of IP addresses.
.TP
[\fB!\fR] \fB\-\-src\-range\fP \fIfrom\fP[\fB\-\fP\fIto\fP]
Match source IP in the specified range.
.TP
[\fB!\fR] \fB\-\-dst\-range\fP \fIfrom\fP[\fB\-\fP\fIto\fP]
Match destination IP in the specified range.
.SS ipv6header
This module matches IPv6 extension headers and/or upper layer header.
.TP
\fB\-\-soft\fP
Matches if the packet includes \fBany\fP of the headers specified with
\fB\-\-header\fP.
.TP
[\fB!\fP] \fB\-\-header\fP \fIheader\fP[\fB,\fP\fIheader\fP...]
Matches the packet which EXACTLY includes all specified headers. The headers
encapsulated with ESP header are out of scope.
Possible \fIheader\fP types can be:
.TP
\fBhop\fP|\fBhop\-by\-hop\fP
Hop-by-Hop Options header
.TP
\fBdst\fP
Destination Options header
.TP
\fBroute\fP
Routing header
.TP
\fBfrag\fP
Fragment header
.TP
\fBauth\fP
Authentication header
.TP
\fBesp\fP
Encapsulating Security Payload header
.TP
\fBnone\fP
No Next header which matches 59 in the 'Next Header field' of IPv6 header or
any IPv6 extension headers
.TP
\fBproto\fP
which matches any upper layer protocol header. A protocol name from
/etc/protocols and numeric value also allowed. The number 255 is equivalent to
\fBproto\fP.
.SS length
This module matches the length of the layer-3 payload (e.g. layer-4 packet)
f a packet against a specific value
or range of values.
.TP
[\fB!\fP] \fB\-\-length\fP \fIlength\fP[\fB:\fP\fIlength\fP]
.SS limit
This module matches at a limited rate using a token bucket filter.
A rule using this extension will match until this limit is reached
(unless the `!' flag is used).  It can be used in combination with the
.B LOG
target to give limited logging, for example.
.TP
[\fB!\fP] \fB\-\-limit\fP \fIrate\fP[\fB/second\fP|\fB/minute\fP|\fB/hour\fP|\fB/day\fP]
Maximum average matching rate: specified as a number, with an optional
`/second', `/minute', `/hour', or `/day' suffix; the default is
3/hour.
.TP
\fB\-\-limit\-burst\fP \fInumber\fP
Maximum initial number of packets to match: this number gets
recharged by one every time the limit specified above is not reached,
up to this number; the default is 5.
.SS mac
.TP
[\fB!\fP] \fB\-\-mac\-source\fP \fIaddress\fP
Match source MAC address.  It must be of the form XX:XX:XX:XX:XX:XX.
Note that this only makes sense for packets coming from an Ethernet device
and entering the
.BR PREROUTING ,
.B FORWARD
or
.B INPUT
chains.
.SS mark
This module matches the netfilter mark field associated with a packet
(which can be set using the
.B MARK
target below).
.TP
[\fB!\fP] \fB\-\-mark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Matches packets with the given unsigned mark value (if a \fImask\fP is
specified, this is logically ANDed with the \fImask\fP before the
comparison).
.SS mh
This extension is loaded if `\-\-protocol ipv6\-mh' or `\-\-protocol mh' is
specified. It provides the following option:
.TP
[\fB!\fP] \fB\-\-mh\-type\fP \fItype\fP[\fB:\fP\fItype\fP]
This allows specification of the Mobility Header(MH) type, which can be
a numeric MH
.IR type ,
.IR type
or one of the MH type names shown by the command
.nf
 ip6tables \-p ipv6\-mh \-h
.fi
.SS rt
Match on IPv6 routing header
.TP
[\fB!\fP] \fB\-\-rt\-type\fP \fItype\fP
Match the type (numeric).
.TP
[\fB!\fP] \fB\-\-rt\-segsleft\fP \fInum\fP[\fB:\fP\fInum\fP]
Match the `segments left' field (range).
.TP
[\fB!\fP] \fB\-\-rt\-len\fP \fIlength\fP
Match the length of this header.
.TP
\fB\-\-rt\-0\-res\fP
Match the reserved field, too (type=0)
.TP
\fB\-\-rt\-0\-addrs\fP \fIaddr\fP[\fB,\fP\fIaddr\fP...]
Match type=0 addresses (list).
.TP
\fB\-\-rt\-0\-not\-strict\fP
List of type=0 addresses is not a strict list.
.SS state
This module, when combined with connection tracking, allows access to
the connection tracking state for this packet.
.TP
[\fB!\fP] \fB\-\-state\fP \fIstate\fP
Where state is a comma separated list of the connection states to
match.  Possible states are
.B INVALID
meaning that the packet could not be identified for some reason which
includes running out of memory and ICMP errors which don't correspond to any
known connection,
.B ESTABLISHED
meaning that the packet is associated with a connection which has seen
packets in both directions,
.B NEW
meaning that the packet has started a new connection, or otherwise
associated with a connection which has not seen packets in both
directions, and
.B RELATED
meaning that the packet is starting a new connection, but is
associated with an existing connection, such as an FTP data transfer,
or an ICMP error.
.SS string
This modules matches a given string by using some pattern matching strategy. It requires a linux kernel >= 2.6.14.
.TP
\fB\-\-algo\fP {\fBbm\fP|\fBkmp\fP}
Select the pattern matching strategy. (bm = Boyer-Moore, kmp = Knuth-Pratt-Morris)
.TP
\fB\-\-from\fP \fIoffset\fP
Set the offset from which it starts looking for any matching. If not passed, default is 0.
.TP
\fB\-\-to\fP \fIoffset\fP
Set the offset from which it starts looking for any matching. If not passed, default is the packet size.
.TP
[\fB!\fP] \fB\-\-string\fP \fIpattern\fP
Matches the given pattern.
.TP
[\fB!\fP] \fB\-\-hex\-string\fP \fIpattern\fP
Matches the given pattern in hex notation.
.SS tcp
These extensions can be used if `\-\-protocol tcp' is specified. It
provides the following options:
.TP
[\fB!\fP] \fB\-\-source\-port\fP,\fB\-\-sport\fP \fIport\fP[\fB:\fP\fIport\fP]
Source port or port range specification. This can either be a service
name or a port number. An inclusive range can also be specified,
using the format \fIfirst\fP\fB:\fP\fIlast\fP.
If the first port is omitted, "0" is assumed; if the last is omitted,
"65535" is assumed.
If the first port is greater than the second one they will be swapped.
The flag
\fB\-\-sport\fP
is a convenient alias for this option.
.TP
[\fB!\fP] \fB\-\-destination\-port\fP,\fB\-\-dport\fP \fIport\fP[\fB:\fP\fIport\fP]
Destination port or port range specification.  The flag
\fB\-\-dport\fP
is a convenient alias for this option.
.TP
[\fB!\fP] \fB\-\-tcp\-flags\fP \fImask\fP \fIcomp\fP
Match when the TCP flags are as specified.  The first argument \fImask\fP is the
flags which we should examine, written as a comma-separated list, and
the second argument \fIcomp\fP is a comma-separated list of flags which must be
set.  Flags are:
.BR "SYN ACK FIN RST URG PSH ALL NONE" .
Hence the command
.nf
 iptables \-A FORWARD \-p tcp \-\-tcp\-flags SYN,ACK,FIN,RST SYN
.fi
will only match packets with the SYN flag set, and the ACK, FIN and
RST flags unset.
.TP
[\fB!\fP] \fB\-\-syn\fP
Only match TCP packets with the SYN bit set and the ACK,RST and FIN bits
cleared.  Such packets are used to request TCP connection initiation;
for example, blocking such packets coming in an interface will prevent
incoming TCP connections, but outgoing TCP connections will be
unaffected.
It is equivalent to \fB\-\-tcp\-flags SYN,RST,ACK,FIN SYN\fP.
If the "!" flag precedes the "\-\-syn", the sense of the
option is inverted.
.TP
[\fB!\fP] \fB\-\-tcp\-option\fP \fInumber\fP
Match if TCP option set.
.SS udp
These extensions can be used if `\-\-protocol udp' is specified. It
provides the following options:
.TP
[\fB!\fP] \fB\-\-source\-port\fP,\fB\-\-sport\fP \fIport\fP[\fB:\fP\fIport\fP]
Source port or port range specification.
See the description of the
\fB\-\-source\-port\fP
option of the TCP extension for details.
.TP
[\fB!\fP] \fB\-\-destination\-port\fP,\fB\-\-dport\fP \fIport\fP[\fB:\fP\fIport\fP]
Destination port or port range specification.
See the description of the
\fB\-\-destination\-port\fP
option of the TCP extension for details.
