#include <linux/module.h>	
#include <linux/proc_fs.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/kernel_stat.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/slab.h>
#include <asm/uaccess.h>
//#include <linux/brlock.h>
#include <linux/net.h>
#include <linux/socket.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/string.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/sock.h>
#include <net/arp.h>
#include <net/raw.h>
#include <net/checksum.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netlink.h>
#include <linux/inetdevice.h>
#include <linux/icmp.h>
#include <net/udp.h>
#include <net/tcp.h>//brad

#include <net/rtl/rtl_types.h>
#include <net/rtl/fastpath/fastpath_core.h>
#ifdef FASTPATH_FILTER
#include "filter_v2.c"
#endif
//#ifdef CONFIG_RTL8196B_KLD
//#define DNS_QUERY_FILTER_FOR_HTTPS_URL_FILTER
//#endif
//#ifdef URL_CONTENT_AUTHENTICATION
#include <net/rtl/rtl865x_netif.h>
//#include <common/rtl865x_netif_local.h>
//#include <AsicDriver/rtl865x_asicCom.h>
//#include <AsicDriver/rtl865x_asicL2.h>
//#endif

/*David, 20100818*/
#ifdef CONFIG_HAS_FASTPATH_DOS_FILTER
#else
    #undef DOS_FILTER
#endif

///////////////////////////////////////////////////////////////////////////
#ifdef URL_CONTENT_AUTHENTICATION
#include <asm/semaphore.h>
#include <linux/wait.h>
#endif
#ifdef CONFIG_FAST_PATH_MODULE
extern int32 rtl865x_del_acl(rtl865x_AclRule_t *rule, char *netifName,int32 chainNo);
#endif

#if defined(CONFIG_RTL8186_GR)
#define DOS_LOG_SENDMAIL
#endif

#ifdef DOS_LOG_SENDMAIL
static u_int32_t dosLogCount;
static char dosBuf[1024];
#endif

#ifdef DOS_FILTER
#if !defined(SUCCESS)
#define SUCCESS 0
#endif
#if !defined(FAILED)
#define FAILED 1
#endif
#define TCP_FIN 1
#define TCP_SYN 2
#define HashSize 256
#define TableSize 1024
#define HighSensitivity 10
#define LowSensitivity 200
#define SmartHighThres 4000
#define SmartLowThres  500

#define control_message 0x8000
#define connect_control 0xc
#define stop_control 0x4

#define NONE_DOS_PKT_THRES 3000 //david

struct s_dos_pkt {
	char use;
	int syn_cnt;
	int fin_cnt;
	int udp_cnt;
	int icmp_cnt;
	int  scan_cnt;
	u_int32_t ip;
	u_int16_t id;
	u_int16_t offset;
	u_int16_t dest;
};
enum {
	EnableDosSet=0x1,
	WholeSynFloodSet=0x2,
	WholeFinFloodSet=0x4,
	WholeUdpFloodSet=0x8,
	WholeIcmpFloodSet=0x10,
	PerSynFloodSet=0x20,
	PerFinFloodSet=0x40,
	PerUdpFloodSet=0x80,
	PerIcmpFloodSet=0x100,
	TcpUdpPortScanSet=0x200,
	IcmpSmurfSet=0x400,
	IpLandSet=0x800,
	IpSpoofSet=0x1000,
	TearDropSet=0x2000,
	PingOfDeathSet=0x4000,
	TcpScanSet=0x8000,
	TcpSynWithDataSet=0x10000,
	UdpBombSet=0x20000,
	UdpEchoChargenSet=0x40000,
	IpBlockSet=0x400000,
	SensitivitySet=0x800000
};

enum {
	PerSynFlood=1,
	PerFinFlood,
	PerUdpFlood,
	PerIcmpFlood,
	TcpUdpPortScan,
	IcmpSmurf,
	IpLand,
	IpSpoof,
	TearDrop,
	PingOfDeath,
	TcpScan,
	TcpSynWithData,
	UdpBomb,
	UdpEchoChargen
};
#endif // DOS_FILTER

#ifdef URL_FILTER 
#if defined(CUSTOM_RSP_PACKET) 
#define URL_FILTER_BLOCK_PAGE_MESSAGE \
	"HTTP/1.1 401 The web site is blocked by administrator\r\nServer: Embedded HTTP Server 2.00\r\nConnection: close\r\n\r\n"\
	"<HTML><HEAD><TITLE>401 The web site is blocked by administrator</TITLE></HEAD>"\
	"\n<BODY BGCOLOR=\"#ffffff\"><H4>401 The web site is blocked by administrator</H4></BODY></HTML>\n"
static char *block_message = NULL;
struct filter_trace
{
	__u16 ip_id;
	__u32 wanside_ip;
	__u32 lanside_ip;
	__u16 tcp_window;                  
	__u8 ip_ttl;         
	__u8 isSent401;      
	__u8 isSentFinAck;
};
static struct filter_trace url_cache={0,0,0,0,0,0};
#endif // CONFIG_RTL8186_TR
#endif

#ifdef DOS_FILTER
static u_int32_t LogFlag,ConnectedIp[HashSize];
static struct s_dos_pkt dos_pkt[TableSize], *cur_p_pkt;
static struct timer_list dos_timer;

#if 1
static char _tcpDosScanBitmap[64];
/** cfho 2010-0622, we got the following from SDK2.2, it seems that the opmode does not affect the fastpath behaviour, for safty, set it to gateway mode (0).
LINUX/apmib.h:typedef enum { GATEWAY_MODE=0, BRIDGE_MODE=1, WISP_MODE=2 } OPMODE_T;
*/
static char op_mode=0;

#else
static char _tcpDosScanBitmap[64],op_mode;

#endif

#if 1 /** cfho 2010-0622 give DOS default values */

static int whole_syn_threshold=1000;
static int whole_fin_threshold=1000;
static int whole_udp_threshold=10000; /* unlimited, is 8738 max? */
static int whole_icmp_threshold=10000;
static int per_syn_threshold=30;
static int per_fin_threshold=30;
static int per_udp_threshold=10000;
static int per_icmp_threshold=30;
static int block=1,block_time=2,block_count=1;

#else
static int whole_syn_threshold;
static int whole_fin_threshold;
static int whole_udp_threshold;
static int whole_icmp_threshold;
static int per_syn_threshold;
static int per_fin_threshold;
static int per_udp_threshold;
static int per_icmp_threshold;
static int block=0,block_time=0,block_count=0;
#endif

/** cfho 2010-0622, item=0 means disable the dos_filter function */
__DRAM_L34_FWD static u_int32_t item=0;
static u_int32_t lan_addr,lan_mask;
static u_int32_t attack_saddr[14],attack_daddr[14];
//static u_int32_t pre_saddr,pre_daddr;
//static u_int16_t pre_tot_len;
static char dos_flag[80];
__DRAM_L34_FWD static u_int32_t none_dos_drop_pkt_cnt=0; // david
static u_int32_t item_backup=0; // david
static struct net_device *wan_dev,*wan_ppp_dev;
#endif // DOS_FILTER

#ifdef URL_FILTER
__DRAM_L34_FWD static char url_count=0;
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_KB_N) ||defined(CONFIG_RTL8186_KB) || defined(DNS_QUERY_FILTER_FOR_HTTPS_URL_FILTER)
static char url_mode=0;
#endif
#ifdef CONFIG_RTL8186_GR

#define RTL_URL_FILTER_ENTRY_COUNT 20
#define RTL_URL_FILTER_CONTENT_MAXNUM 40
typedef struct _filter_ipRange
{
	struct list_head list;
	uint32 srcaddr_start; /*src ipaddr start*/	
	uint32 srcaddr_end; /*src address end*/
	uint32 dstaddr_start; /*dst ipaddr start*/	
	uint32 dstaddr_end; /*dst ip address end*/	
	uint32 valid:1,
		   reserved;

}rtl_ipRange;
typedef struct _filter_l4portRange
{
	struct list_head list;
	uint32 	srcport_start:16, /*src port start*/
			srcport_end:16; /*src port end*/

	uint32 	dstport_start:16, /*dst port start*/
		   	dstport_end:16; /*dst port end*/
	uint32 valid:1,
		   reserved;
	
}rtl_l4PortRange;

typedef struct _url_entry
{
	struct list_head ip_range;
	uint32 valid:1,
		   reserved;
	char url_content[RTL_URL_FILTER_CONTENT_MAXNUM];

}rtl_url_entry;


rtl_url_entry url_entry_array[RTL_URL_FILTER_ENTRY_COUNT];
#else
static char url_flag[1024];
static char url_tbl[20][40];
unsigned long url_addr;
unsigned char url_range;
#endif

#ifdef MAC_BASED_URL_FILTER
__DRAM_L34_FWD static uint8 mac_list_count = 0;
static char mac_list_flag[1024];
//sizeof mac_url_info = /* mac(6)+mask(6)+url_index(64bit) + action_flag(1byte)*/
static mac_url_info mac_url_tbl[40]; 
#endif

#if defined(CONFIG_BASEON_SCHEDULE_FILTER)  
__DRAM_L34_FWD static uint8 sch_list_count = 0;
static char sch_list_flag[1024];
static sch_url_info sch_url_tbl[20]; 
unsigned long sch_url_addr;
unsigned char sch_url_range;
#if 0
#define SCH_DEBUG
#endif
#endif

//#define CONFIG_RTL8186_GR 1
#if (defined(CONFIG_RTL8186_GR) || defined(CONFIG_RTL8186_KB))
#define OTHERS_FILTER 1	//added for debug

static uint8 domain_name_count = 0;
static char domain_name_flag[1024];
static domain_name_info domain_name_tbl[DOMAIN_NAME_NUM];
//domain_name_tbl[0].ptrIP=domain_name_tbl[0].ipAddr[0];
//domain_name_tbl[0].ipNum=0;

static uint8 others_count = 0;
static char others_flag[1024];
static others_info others_tbl[OTHERS_NUM];
#endif
#endif

#ifdef URL_CONTENT_AUTHENTICATION
//DECLARE_MUTEX(queueBuf_rw);
typedef struct _sch_time_s
{
	struct list_head list;
	uint32 weekMask; /*bit0: sunday, bit 1: monday, .... bit 6 saturday*/
	uint32 startTime; /*minutes, ex. 5:21 = 5*60+21 minutes*/
	uint32 endTime; /*minutes*/	
}sch_time_t;

typedef struct _content_auth_schedule_s
{
	uint32 srcIpAddr; /*src ipaddr*/
	uint32 dstIpAddr; /*dst ip address*/	
	uint32 valid:1,
		   action:1, /*0:permit, 1:drop*/
		flags; /*reserved now*/
	struct list_head sch_time_listHead;
}content_auth_schedule_t;

typedef struct _content_cache_connection_s
{
	uint32 srcaddr_start; /*src ipaddr start*/	
	uint32 srcaddr_end; /*src address end*/
	uint32 dstaddr_start; /*dst ipaddr start*/	
	uint32 dstaddr_end; /*dst ip address end*/
	
	uint32 srcport_start:16, /*src port start*/
		   srcport_end:16; /*src port end*/

	uint32 dstport_start:16, /*dst port start*/
		   dstport_end:16; /*dst port end*/
	
	uint32 valid:1,
		   action:1, /*0:permit, 1:drop*/
		   reserved;
	
}content_cache_connection_t;



DECLARE_MUTEX(recv_newSkb_flag);
static DECLARE_WAIT_QUEUE_HEAD(unAuth_url_content);
static int recv_flag = 0;
int urlContAuth_enable = 0;
LIST_HEAD(unAuth_skb_list);
LIST_HEAD(waitAuthResult_skb_list);

char* HttpRedirectHead = 
	"HTTP/1.1 302 Object Moved\r\n"
	"Location: http://%s/fw_netstar_pass.asp?errorno=%d&id=%d\r\n"
	"Server: rtl865x-gateway\r\n"
	"Content-Type: text/html\r\n"
	"Content-Length: %d\r\n"
	"\r\n"
	"%s";
char* HttpRedirectContent = 
	"<html><head><title>Object Moved</title></head>"
	"<body><h1>Object Moved</h1>This Object may be found in "
	"<a HREF=\"http://%s/fw_netstar_pass.asp?errorno=%d&id=%d\">here</a></body><html>";
	
#define CONTENT_AUTH_SCH_NUM 8
#define CONTENT_AUTH_CACHE_NUM 16
content_auth_schedule_t rtl_content_auth_sch_list[CONTENT_AUTH_SCH_NUM];
content_cache_connection_t rtl_content_auth_cache_list[CONTENT_AUTH_CACHE_NUM];
int rtl_content_auth_cache_firstIdx;


#endif

#ifdef CONFIG_RTL_LAYERED_DRIVER
static int  Del_Pattern_ACL_For_ContentFilter(void);
int  Add_Pattern_ACL_For_ContentFilter(void);
#endif


//static char flag='1';
#if 1
extern int scrlog_printk(const char * fmt, ...);
#else
#if 1
#define scrlog_printk printk
#else
#define scrlog_printk(format, args...)
#endif
#endif
///////////////////////////////////////////////////////////////////////////
#ifdef URL_FILTER
#if defined(CUSTOM_RSP_PACKET) 
//Brad add
static int  GenerateTCPENDACK(struct sk_buff *skb)
{
	struct iphdr *iph;
        struct tcphdr *tcph;
        struct sk_buff *nskb=NULL;
        struct iphdr *oiph;
        struct tcphdr *otcph;
        struct iphdr niph;
        struct tcphdr ntcph;
        struct neighbour *neigh;
	unsigned int tcplen;
	u_int32_t tmp_seq;
	struct hh_cache *hh;
	struct net_device *lan_dev;
	
	lan_dev =__dev_get_by_name(&init_net,"br0");	
	iph=ip_hdr(skb);
	
	otcph = (struct tcphdr *)((u_int32_t*)iph + iph->ihl);
	neigh = neigh_lookup(&arp_tbl, &iph->saddr, lan_dev);
	if (neigh == NULL || neigh->hh == NULL) {
		//printk("%s: neigh_lookup() failed\n", __FUNCTION__);		
		return 0;
	}         	

 	nskb = skb_copy_expand(skb, LL_MAX_HEADER,0, GFP_ATOMIC);
	if (!nskb) {
		scrlog_printk("dos_filter: alloc skb fail!\n");
		return 0;
	}
	oiph= ip_hdr(nskb);
	skb_trim(nskb, oiph->ihl*4 + sizeof(struct tcphdr));
	skb_put(nskb,0);
     	hh = neigh->hh;
       	read_lock_bh(&hh->hh_lock);
      	memcpy(nskb->data - 16, hh->hh_data, 16);
       	read_unlock_bh(&hh->hh_lock);
       	skb_push(nskb, hh->hh_len);
       	neigh_release(neigh);       
       		
      
       	nskb->nfct = NULL;
//	nskb->nfcache = 0;
//	nskb->nfmark = 0;
       tcph=&ntcph;
	
	tcph->source = otcph->dest;
	tcph->dest = otcph->source;
       	tmp_seq= otcph->seq;
	tcph->seq = otcph->ack_seq;
	tcph->ack_seq= tmp_seq+1;
	tcph->doff=5;
	((u_int8_t *)tcph)[13] = 0;
	tcph->rst = 0;
	tcph->ack = 1;
	tcph->fin =0;
	tcph->urg_ptr = 0;
	tcph->window=  url_cache.tcp_window;
	tcplen = nskb->len - 20-14;
     	tcph->check = 0;
       tcph->check = csum_tcpudp_magic(iph->saddr, iph->daddr, tcplen, IPPROTO_TCP, csum_partial((char *)tcph, tcplen, 0));
       memcpy(nskb->data + ETH_HLEN+20, tcph, sizeof(ntcph)); 
       	//fill ip header
	niph.version	=	4;
	niph.ihl		=	sizeof(struct iphdr) >> 2;
	niph.frag_off	=	0;			
	niph.protocol	=	IPPROTO_TCP;
	niph.tos		=	0;
    	niph.daddr		=	iph->saddr;
    	niph.saddr		=	iph->daddr;
    	niph.ttl 		=	url_cache.ip_ttl;      
    	skb->ip_summed		=	CHECKSUM_NONE;			
    	niph.tot_len	=	htons(40);		
    	niph.id			=	url_cache.ip_id+1;
    	niph.check		=	0;
    	niph.check		=	ip_fast_csum((unsigned char *)&niph, (niph.ihl));	
    	
    	memcpy(nskb->data + ETH_HLEN, &niph, sizeof(niph)); 
		
	url_cache.isSentFinAck=0;
//	printk("Sent FINACK already\n");	
	dev_queue_xmit(nskb); //send tcp fin ack;
	return 0;
}

static int  GenerateTCPFINACK(struct sk_buff *skb)
{
	struct iphdr *iph;
        struct tcphdr *tcph;
        struct sk_buff *nskb=NULL;
        struct iphdr *oiph;
        struct tcphdr *otcph;
        struct iphdr niph;
        struct tcphdr ntcph;
        struct neighbour *neigh;
	unsigned int tcplen;
	u_int32_t tmp_seq;
	struct hh_cache *hh;
	struct net_device *lan_dev;
	
	lan_dev =__dev_get_by_name(&init_net,"br0");	
	iph=ip_hdr(skb);
	otcph = (struct tcphdr *)((u_int32_t*)iph + iph->ihl);
	neigh = neigh_lookup(&arp_tbl, &iph->saddr, lan_dev);
	if (neigh == NULL || neigh->hh == NULL) {
		//printk("%s: neigh_lookup() failed\n", __FUNCTION__);		
		return 0;
	}         	
       		
 	nskb = skb_copy_expand(skb, LL_MAX_HEADER,0, GFP_ATOMIC);
	if (!nskb) {
		scrlog_printk("dos_filter: alloc skb fail!\n");
		return 0;
	}
	oiph= (void *) ip_hdr(nskb);
	
	skb_trim(nskb, oiph->ihl*4 + sizeof(struct tcphdr));
	skb_put(nskb,0);
     	hh = neigh->hh;
       	read_lock_bh(&hh->hh_lock);
      	memcpy(nskb->data - 16, hh->hh_data, 16);
       	read_unlock_bh(&hh->hh_lock);
       	skb_push(nskb, hh->hh_len);
       	neigh_release(neigh); 
	   
       	nskb->nfct = NULL;
//	nskb->nfcache = 0;
//	nskb->nfmark = 0;
       tcph=&ntcph;
	
	tcph->source = otcph->dest;
	tcph->dest = otcph->source;
       	tmp_seq= otcph->seq;
	tcph->seq = otcph->ack_seq;
	tcph->ack_seq= tmp_seq;
	tcph->doff=5;
	((u_int8_t *)tcph)[13] = 0;
	tcph->rst = 0;
	tcph->ack = 1;
	tcph->fin =1;
	tcph->urg_ptr = 0;
	tcph->window=  url_cache.tcp_window;
	tcplen = nskb->len - 20-14;
     	tcph->check = 0;
       tcph->check = csum_tcpudp_magic(iph->saddr, iph->daddr, tcplen, IPPROTO_TCP, csum_partial((char *)tcph, tcplen, 0));
       memcpy(nskb->data + ETH_HLEN+20, tcph, sizeof(ntcph)); 
       	//fill ip header
	niph.version	=	4;
	niph.ihl		=	sizeof(struct iphdr) >> 2;
	niph.frag_off	=	0;			
	niph.protocol	=	IPPROTO_TCP;
	niph.tos		=	0;
    	niph.daddr		=	iph->saddr;
    	niph.saddr		=	iph->daddr;
    	niph.ttl 		=	url_cache.ip_ttl;      
    	skb->ip_summed		=	CHECKSUM_NONE;			
    	niph.tot_len	=	htons(40);		
    	niph.id			=	url_cache.ip_id+1;
    	niph.check		=	0;
    	niph.check		=	ip_fast_csum((unsigned char *)&niph, (niph.ihl));	
    	
    	memcpy(nskb->data + ETH_HLEN, &niph, sizeof(niph)); 
		
	url_cache.isSent401=0;		
	url_cache.isSentFinAck=1;
//	printk("Sent FINACK already\n");	
	dev_queue_xmit(nskb); //send tcp fin ack;
	return 0;
}

//Brad add end

int  GenerateHTTP401(struct sk_buff *skb)
{
	struct iphdr *iph;
        struct tcphdr *tcph;
        struct sk_buff *nskb=NULL;
        struct sk_buff *nskb1=NULL;
        struct iphdr *oiph;
        struct tcphdr *otcph;
        struct iphdr niph;
        struct tcphdr ntcph;
        struct neighbour *neigh;
        unsigned char *data;
	unsigned int tcplen;
	u_int16_t tmp_port;
	u_int32_t tmp_seq;
	u_int32_t tmp_addr;
	u_int8_t skb_data[100];
	struct hh_cache *hh;
	struct net_device *lan_dev;
	int i;
	
	lan_dev =__dev_get_by_name(&init_net,"br0");	
	
	iph=(void *) ip_hdr(skb);
	otcph = (struct tcphdr *)((u_int32_t*)iph + iph->ihl);
	//get lan host ip address by arp table	
	neigh = neigh_lookup(&arp_tbl, &iph->saddr, lan_dev);
	if (neigh == NULL || neigh->hh == NULL) {
		//printk("%s: neigh_lookup() failed\n", __FUNCTION__);		
		return 0;
	}

	nskb1 = skb_copy_expand(skb, LL_MAX_HEADER,0, GFP_ATOMIC);
	if (!nskb1) {
		scrlog_printk("dos_filter: alloc skb fail!\n");
		return 0;
	}
	
	skb_trim(nskb1, ip_hdr(nskb1)->ihl*4 + sizeof(struct tcphdr));
	skb_put(nskb1,0);

     	hh = neigh->hh;
       	read_lock_bh(&hh->hh_lock);
      	memcpy(nskb1->data - 16, hh->hh_data, 16);
       	read_unlock_bh(&hh->hh_lock);
       	skb_push(nskb1, hh->hh_len);
       	neigh_release(neigh); 	
       	nskb1->nfct = NULL;
//	nskb1->nfcache = 0;
//	nskb1->nfmark = 0;
	
       tcph=&ntcph;
	tcph->source = otcph->dest;
	tcph->dest = otcph->source;
       	tmp_seq= otcph->seq;
	tcph->seq = otcph->ack_seq;
	tcph->ack_seq= tmp_seq+skb->len-40;
	tmp_seq = tcph->seq;
	tcph->doff=5;
	((u_int8_t *)tcph)[13] = 0;
	tcph->rst = 0;
	tcph->ack = 1;
	tcph->psh =0;
	tcph->urg_ptr = 0;
	tcph->window=  url_cache.tcp_window;
	tcplen = nskb1->len - 20-14;
     	tcph->check = 0;
       tcph->check = csum_tcpudp_magic(iph->saddr, iph->daddr, tcplen, IPPROTO_TCP, csum_partial((char *)tcph, tcplen, 0));
       memcpy(nskb1->data + ETH_HLEN+20, tcph, sizeof(ntcph));
// 	memcpy(nskb1->data +20, tcph, sizeof(ntcph));
       	//fill ip header
	niph.version	=	4;
	niph.ihl		=	sizeof(struct iphdr) >> 2;
	niph.frag_off	=	0;			
	niph.protocol	=	IPPROTO_TCP;
	niph.tos		=	0;
    	niph.daddr		=	iph->saddr;
    	niph.saddr		=	iph->daddr;
    	niph.ttl 		=	url_cache.ip_ttl;      
    	//nskb1->ip_summed		=	CHECKSUM_NONE;			
    	niph.tot_len	=	htons(40);		
    	niph.id			=	url_cache.ip_id+1;
    	niph.check		=	0;
    	niph.check		=	ip_fast_csum((unsigned char *)&niph, (niph.ihl));	
    	memcpy(nskb1->data + ETH_HLEN, &niph, sizeof(niph)); 
// 	memcpy(nskb1->data, &niph, sizeof(niph)); 
 	memcpy(&skb_data, nskb1->data, 54);;
	
	dev_queue_xmit(nskb1); //send tcp ack;
	if (block_message)
	      	nskb = skb_copy_expand(skb, LL_MAX_HEADER, /*skb_tailroom(skb) + */strlen(block_message), GFP_ATOMIC);
	else
		nskb = skb_copy_expand(skb, LL_MAX_HEADER, strlen(URL_FILTER_BLOCK_PAGE_MESSAGE), GFP_ATOMIC);
	
	if (!nskb) {
		scrlog_printk("dos_filter: alloc skb fail!\n");
		return 0;
	}
	oiph= (void *) ip_hdr(nskb);
	
	skb_trim(nskb, oiph->ihl*4 + sizeof(struct tcphdr));

	if (block_message)
		skb_put(nskb,strlen(block_message));
	else
	skb_put(nskb,strlen(URL_FILTER_BLOCK_PAGE_MESSAGE));
		
     	hh = neigh->hh;
       	read_lock_bh(&hh->hh_lock);
      	memcpy(nskb->data - 16, hh->hh_data, 16);
       	read_unlock_bh(&hh->hh_lock);
       	skb_push(nskb, hh->hh_len);
       	neigh_release(neigh); 
       	
	nskb->nfct = NULL;
//	nskb->nfcache = 0;
//	nskb->nfmark = 0;
	tmp_addr = oiph->saddr;
	oiph->saddr = oiph->daddr;
	oiph->daddr = tmp_addr;
	tcph = (struct tcphdr *)((u_int32_t*)oiph + oiph->ihl);
	data = (void *)tcph + tcph->doff*4;
	tmp_port = tcph->source;
	tcph->source = tcph->dest;
	tcph->dest = tmp_port;

	if (block_message)
		memcpy(data, block_message, strlen(block_message));
	else
	memcpy(data, URL_FILTER_BLOCK_PAGE_MESSAGE, strlen(URL_FILTER_BLOCK_PAGE_MESSAGE));
	
	tmp_seq= tcph->seq;
	tcph->seq = tcph->ack_seq;
	tcph->ack_seq= tmp_seq+skb->len-40;
	tcph->window = url_cache.tcp_window;
	((u_int8_t *)tcph)[13] = 0;
	tcph->rst = 0;
	tcph->ack = 1;
	tcph->psh =1;
	tcph->fin =0;
	tcph->urg_ptr = 0;

	tcplen = nskb->len - oiph->ihl*4-14;
     	tcph->check = 0;
	tcph->check = csum_tcpudp_magic(oiph->saddr, oiph->daddr, tcplen, IPPROTO_TCP, csum_partial((char *)tcph, tcplen, 0));
	oiph->tot_len = htons(nskb->len-14);
	oiph->ttl = url_cache.ip_ttl;                 
	oiph->frag_off = 0;
	oiph->id = url_cache.ip_id+2;

	oiph->check = 0;
	oiph->check = ip_fast_csum((unsigned char *)oiph, oiph->ihl);
	url_cache.isSent401=1;
	 memcpy(&skb_data, nskb->data, 54);
	dev_queue_xmit(nskb);
	return 0;
}
#endif
#ifdef MAC_BASED_URL_FILTER
//hyking add
static mac_url_info* find_mac_url_entry_by_smac(char *smac)
{
	int i,j;
	mac_url_info *retentry = NULL;

	for(i= 0; i < mac_list_count;i++)
	{
		/*endian...*/
		for(j=0;j<ETHER_ADDR_LEN;j++)
		{			
			if((mac_url_tbl[i].mac[j] & mac_url_tbl[i].mask[j]) != (smac[j] & mac_url_tbl[i].mask[j]))
				break;			
		}
		
		if(j == ETHER_ADDR_LEN)
		{
			retentry = &(mac_url_tbl[i]);
			break;
		}
	}
	
	return retentry;
}

/*
* retval 1: in scheduling
* retval 0: NOT in scheduling
*/
static uint32 is_mac_url_in_scheduling(mac_url_info *mac_url_entry)
{
	struct timeval tv;
	uint32 today, hour,minute;
	uint32 curtime;

	//printk("%d:%d:%d week%d\n", (tv.tv_sec/3600)%24, (tv.tv_sec/60)%60, (tv.tv_sec)%60, ((tv.tv_sec/86400) + 4)%7);

	if(mac_url_entry == NULL)
	{
		printk("%s(%d), error.......\n", __FUNCTION__,__LINE__);
		return 0;
	}

	/*get system time*/
	do_gettimeofday(&tv);
	today = ((tv.tv_sec/86400) + 4)%7;
	hour = (tv.tv_sec/3600)%24;
	minute = (tv.tv_sec/60)%60;

	if((mac_url_entry->weekMask & WEEK_ALL_DAY ) || (mac_url_entry->weekMask & (1<< today)))
	{
		curtime = hour * 60 + minute;
		if( (mac_url_entry->allTimeFlag & TIME_ALL_TIME ) || ((mac_url_entry->startTime <= curtime) && (curtime < mac_url_entry->endTime)))
		{
			/*bingo.....*/
			return 1;
		}			
	}		
	return 0;
}
#endif

#ifndef FASTPATH_FILTER
int  find_pattern(char *data, int dlen,  char *pattern, int plen, char term, unsigned int *numoff, unsigned int *numlen)
{
	int i,j,k;
	int state =0;
	*numoff = *numlen=0;
	for(i=0; i <= (dlen -plen);i++)
	{
	      if (*(data + i) == '\r')
	      {
            	  if (!(state % 2)) state++;  /* forwarding move */
              	  else state = 0;             /* reset */
              }
	      else if (*(data + i) == '\n')
	      {
	          if (state % 2) state++;
	          else state = 0;
              }
              else state = 0;

	      if (state >= 4)
	           break;
	      if(memcmp(data + i, pattern, plen)!=0)
		      continue;
	      *numoff=i + plen;
	      for (j = *numoff, k = 0; data[j] != term; j++, k++)
	        if (j > dlen) return 0 ;   /* no terminal char */
	      *numlen = k;
	      return 1;
		      
	}
 return 0;

}
#endif
static int find_url(const char *data, size_t dlen, const char *pattern, size_t plen, char term)
{
	int i;

	if(plen > dlen)
	  return 0;
	for(i=0; data[i+plen] !=term ;i++)
	{
	      if(memcmp(data + i, pattern, plen)!=0)
		      continue;
	      else
			return 1;
	}
  return 0;
}
#ifdef FASTPATH_FILTER
static int  FilterWeb(struct sk_buff *skb)
{
	return FilterWeb_v2(skb);
}
#elif defined(CONFIG_BASEON_SCHEDULE_FILTER) 
static int scan_sch_url_tbl(const char *data, size_t dlen, const char *pattern, size_t plen, char term)
{
	int i;
	
	if(pattern[plen] == '\0')
	{
		plen--;
	}
	if(plen > dlen)
	  	return 0;
	
	for(i=0; data[i+plen] !=term ;i++)
	{
	      if(memcmp(data + i, pattern, plen)!=0)
		      continue;
	      else
			return 1;
	}
  return 0;
}

/*
* retval 1: in scheduling
* retval 0: NOT in scheduling
*/
static uint32 is_in_scheduling(sch_url_info *sch_url_entry)
{
	struct timeval tv;
	uint32 today, hour,minute;
	uint32 curtime;

	if(sch_url_entry == NULL)
	{
		printk("%s(%d), error.......\n", __FUNCTION__,__LINE__);
		return 0;
	}

	/*get system time*/
	do_gettimeofday(&tv);
	today = ((tv.tv_sec/86400) + 4)%7;
	hour = (tv.tv_sec/3600)%24;
	minute = (tv.tv_sec/60)%60;

	if((sch_url_entry->weekMask & WEEK_ALL_DAY) || (sch_url_entry->weekMask & (1<< today)))
	{
		curtime = hour * 60 + minute;
		if( (sch_url_entry->allTimeFlag ) || ((sch_url_entry->startTime <= curtime) && (curtime < sch_url_entry->endTime)))
		{
			/*bingo.....*/
			return 1;
		}			
	}		
	return 0;
}

static int  FilterWeb(struct sk_buff *skb)
{	
	struct iphdr *iph;
 	struct tcphdr *tcph;
	iph=(void *) skb->nh.iph;
	tcph=(void *) iph + iph->ihl*4;
	unsigned char *data = (void *)tcph + tcph->doff*4;
	int found=0, offset,hostlen,pathlen;
	int datalen,i;
	char str[2048];
	
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_KB_N) ||defined(CONFIG_RTL8186_KB)	
	struct net_device *if_check;
#endif	
//Brad add
	struct in_device *in_dev;
	struct in_ifaddr **ifap = NULL;
	struct in_ifaddr *ifa = NULL;
	struct net_device *landev;
	struct net_device *wandev;

        if (url_addr != 0 && (iph->saddr & 0xFFFFFF00)==(url_addr & 0xFFFFFF00)
			 && (iph->saddr & 0xFF) >= (url_addr & 0xFF)
			 && (iph->saddr & 0xFF) < ((url_addr & 0xFF)+url_range))
	          return 0;
		
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_KB_N) ||defined(CONFIG_RTL8186_KB)
	if_check = skb->dev;
	if((!strcmp(if_check->name, "eth1") || !strcmp(if_check->name, "ppp0")) && tcph->source ==80 && tcph->syn==1 && tcph->ack==1){
		url_cache.ip_id = iph->id;
		url_cache.tcp_window = tcph->window;                  
		url_cache.ip_ttl = iph->ttl;     
		url_cache.wanside_ip=iph->saddr;
	}
#endif	

	datalen= ntohs(iph->tot_len) -(iph->ihl*4)-(tcph->doff*4);
	if(memcmp(data, "GET ",sizeof("GET ") -1)!=0)
		return 0;
	
	found = find_pattern(data,datalen,"Host: ",sizeof("Host: ")-1,'\r',&offset, &hostlen);
	if(!found)
		return 0;
	strncpy(str,data+offset,hostlen);
	*(str+hostlen)=0;

	found = find_pattern(data,datalen,"GET ",sizeof("GET ")-1,'\r',&offset, &pathlen);
        if (!found || (pathlen -= (sizeof(" HTTP/x.x") - 1)) <= 0)
		return 0;	
//Brad add 
        	if ((landev = __dev_get_by_name("br0")) != NULL){
		     ifa =NULL;		
		if ((in_dev=__in_dev_get_rcu(landev)) != NULL) {
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
				if (strcmp("br0", ifa->ifa_label) == 0){
					break; 
				}
			}		
		//accept the http packet if the dest ip is our lan ip, always
			if(ifa != NULL){
				if(iph->daddr == ifa->ifa_address){
					
					return 0;
				}
			}
		}
	}
	if ((wandev = __dev_get_by_name("ppp0")) != NULL){
      		ifa =NULL;
		if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) {
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
				if (strcmp("ppp0", ifa->ifa_label) == 0){
					break; 
				}
			}
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa !=NULL){
				if(iph->daddr == ifa->ifa_local){
					return 0;
				}
			}
		}
	}else if ((wandev = __dev_get_by_name("eth1")) != NULL){
			ifa =NULL;
			if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) {
				for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
					if (strcmp("eth1", ifa->ifa_label) == 0){
						break; 
					}
				}
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa != NULL){
				if(iph->daddr == ifa->ifa_address){
					return 0;
				}
			}
		}
	}
#ifndef CONFIG_RTL8186_TR	
	 if ((wandev = __dev_get_by_name("wlan0")) != NULL){
			ifa =NULL;
      			if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) {
      				for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
					if (strcmp("wlan0", ifa->ifa_label) == 0){
						break; 
					}
				}
				//accept the http packet if the dest ip is our wan ip, always
				if(ifa !=NULL){
					if(iph->daddr == ifa->ifa_address){
						return 0;
					}
				}
		}
	}
#endif

//cary add
	strncpy(str+hostlen,data+offset,pathlen);
	*(str+hostlen+pathlen)='\0';


	for(i=0; i< sch_list_count ;i++)
	{
		found = scan_sch_url_tbl(str,strlen(str),sch_url_tbl[i].urlInfo,strlen(sch_url_tbl[i].urlInfo),'\0');
	
		if(found)
		{	
			if(is_in_scheduling(&sch_url_tbl[i]))
			{
				return 1;	//block
			}
			return 0;
		}
	}
	return 0;
}

#else

#ifdef CONFIG_RTL8186_GR

/*flag 
*	0: src ipaddress
*	1: dst ipaddress
*/
static int rtl_isInipRange(struct list_head *listhead, ipaddr_t ipAddr,uint32 flag)
{
	int ret = 0;
	rtl_ipRange *ipRange,*ipRange_next;
	list_for_each_entry_safe(ipRange,ipRange_next,listhead,list)
	{
		/*flag 0: src */
		if(flag == 0)
		{
			if(ipRange->srcaddr_start <= ipAddr && ipRange->srcaddr_end >= ipAddr)
			{
				ret = 1;
				break;
			}
		}
		else
		{
			if(ipRange->dstaddr_start <= ipAddr && ipRange->dstaddr_end >= ipAddr)
			{
				ret = 1;
				break;
			}
		}
	}
	return ret;
	
}

static int  FilterWeb(struct sk_buff *skb)
{	
	struct iphdr *iph;
 	struct tcphdr *tcph;
	iph=(void *) skb->nh.iph;
	tcph=(void *) iph + iph->ihl*4;
	unsigned char *data = (void *)tcph + tcph->doff*4;
	int found=0, inIpRange = 0, offset,hostlen,pathlen;
	int datalen,i;
	int retval = 0;
	char *str = NULL;
//Brad add
	struct in_device *in_dev;
	struct in_ifaddr **ifap = NULL;
	struct in_ifaddr *ifa = NULL;
	struct net_device *landev;
	struct net_device *wandev;
//---------------------	
#ifdef MAC_BASED_URL_FILTER
	mac_url_info *mac_url_entry = NULL;
	char smac[ETHER_ADDR_LEN];

	for(i = 0; i<ETHER_ADDR_LEN;i++)
		smac[i] = skb->mac.raw[ETHER_ADDR_LEN+i];
	
#endif

	datalen= ntohs(iph->tot_len) -(iph->ihl*4)-(tcph->doff*4);
	if(memcmp(data, "GET ",sizeof("GET ") -1)!=0)
		return 0;
	
	found = find_pattern(data,datalen,"Host: ",sizeof("Host: ")-1,'\r',&offset, &hostlen);
	if(!found)
		return 0;
	
	str = kmalloc(2048, GFP_KERNEL);
	if(str == NULL)
	{
		printk("not enough memory for filter....\n");
		return 1;
	}
	
	strncpy(str,data+offset,hostlen);
	*(str+hostlen)=0;

	found = find_pattern(data,datalen,"GET ",sizeof("GET ")-1,'\r',&offset, &pathlen);
        if (!found || (pathlen -= (sizeof(" HTTP/x.x") - 1)) <= 0)
        {
		retval = 0;
		goto ret;
        }
		
//Brad add
	if ((landev = __dev_get_by_name("br0")) != NULL)
	{
		ifa =NULL;		
		if ((in_dev=__in_dev_get_rcu(landev)) != NULL)
		{
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
			{
				if (strcmp("br0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}		

			//accept the http packet if the dest ip is our lan ip, always
			if(ifa != NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{
					retval = 0;
					goto ret;
					//return 0;
				}
			}
		}
	}

	if ((wandev = __dev_get_by_name("ppp0")) != NULL)
	{
      		ifa =NULL;
		if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) 
		{
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) 
			{
				if (strcmp("ppp0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}
			
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa !=NULL)
			{
				if(iph->daddr == ifa->ifa_local)
				{
					retval = 0;
					goto ret;
					//return 0;
				}
			}
		}
	}
	else if ((wandev = __dev_get_by_name("eth1")) != NULL)
	{
			ifa =NULL;
			if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) 
			{
				for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
				{
					if (strcmp("eth1", ifa->ifa_label) == 0)
					{
						break; 
					}
				}
				
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa != NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{
					retval = 0;
					goto ret;
					//return 0;
				}
			}
		}
	}

#ifdef MAC_BASED_URL_FILTER
//hyking add
	/*1. if block all bit is set, drop this packet*/	
	mac_url_entry = find_mac_url_entry_by_smac(smac);	
	if(mac_url_entry)
	{
#if defined TIME_SCHEDULE_FILTER
		/*KB: if week_all_day && all time && mac_control's action is deny, it's not nessary to check the url... */
		if((mac_url_entry->weekMask & WEEK_ALL_DAY) && (mac_url_entry->allTimeFlag & TIME_ALL_TIME))
		{
			if((mac_url_entry->action_flag & MAC_BASED_URL_ALLOW) == 0)
			{
				scrlog_printk("URL: MAC-Based Filter MAC, all days && all time && deny....\n");
				retval = 1;
				goto ret;
				//return 1;
			}
		}

		/*is time in the range specified by mac_url entry?*/
		if( is_mac_url_in_scheduling(mac_url_entry) == 0)
		{
			/*NOT in scheduling, return default action*/
			if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
			{
				retval = 0;
				goto ret;
				//return 0;
			}
			else
			{
				scrlog_printk("URL: MAC-Based Filter MAC=%02x:%02x:%02x:%02x:%02x:%02x  Source=%u.%u.%u.%u\n",
					mac_url_entry->mac[0],mac_url_entry->mac[1],mac_url_entry->mac[2],mac_url_entry->mac[3],
					mac_url_entry->mac[4],mac_url_entry->mac[5], NIPQUAD(iph->saddr));
				retval = 1;
				goto ret;
				//return 1;
			}
		}
		
#endif
		if(mac_url_entry->action_flag & MAC_BASED_URL_BLOCL_ALL)
		{
			scrlog_printk("URL: MAC-Based Filter MAC=%02x:%02x:%02x:%02x:%02x:%02x  Source=%u.%u.%u.%u\n",
				mac_url_entry->mac[0],mac_url_entry->mac[1],mac_url_entry->mac[2],mac_url_entry->mac[3],
				mac_url_entry->mac[4],mac_url_entry->mac[5], NIPQUAD(iph->saddr));
			retval = 1;
			goto ret;
			//return 1;
		}
	}
	else 
	{
		/*not restriction for this mac address, maybe iptables rule is used...., so, default permit*/
		retval = 0;
		goto ret;
		//return 0;
	}
#endif

//---------------------------------------------------------------	
	strncpy(str+hostlen,data+offset,pathlen);
	*(str+hostlen+pathlen)='\0';

	for(i=0; i< RTL_URL_FILTER_ENTRY_COUNT;i++)
	{
		if(url_entry_array[i].valid == 0)
			continue;

		inIpRange = rtl_isInipRange(&url_entry_array[i].ip_range, iph->saddr, 0);
		if(inIpRange)		
			found = find_url(str,strlen(str),url_entry_array[i].url_content,strlen(url_entry_array[i].url_content),'\0');

		if(found)
		{
#if defined MAC_BASED_URL_FILTER
			if(mac_url_entry)
			{
				/*url filter is applied to mac entry*/
				if(mac_url_entry->index_flag & (1<<i))
				{
					if(mac_url_entry->action_flag & MAC_BASED_URL_ALLOW)
					{
						retval = 0;
						goto ret;
					}
					else
					{
						scrlog_printk("URL: Filter URL=%s i = %d Source=%u.%u.%u.%u\n",url_entry_array[i].url_content, i,NIPQUAD(iph->saddr));
						retval = 1;
						goto ret;
					}	
				}
				else if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
				{
					retval = 0;
					goto ret;
				}

			}				
#endif			
			scrlog_printk("URL: Filter URL=%s i=%d Source=%u.%u.%u.%u\n",url_entry_array[i].url_content,i, NIPQUAD(iph->saddr));
			retval = 1;
			goto ret;
	      }	  
	   }

#if defined MAC_BASED_URL_FILTER
	/*all url mismatch...., default action*/
	if(mac_url_entry)
	{
		if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
		{
			retval = 0;
			goto ret;
		}
		else
		{
			scrlog_printk("URL: MAC-Based Filter MAC=%02x:%02x:%02x:%02x:%02x:%02x  Source=%u.%u.%u.%u\n",
				mac_url_entry->mac[0],mac_url_entry->mac[1],mac_url_entry->mac[2],mac_url_entry->mac[3],
				mac_url_entry->mac[4],mac_url_entry->mac[5], NIPQUAD(iph->saddr));
			retval = 1;
			goto ret;
		}		
	}	
#endif
	retval = 0;
ret:
	if(str)
		kfree(str);
	return retval;
	
}
#elif defined(CUSTOM_FILTER)
static int  FilterWeb(struct sk_buff *skb)
{
        struct iphdr *iph;
        struct tcphdr *tcph;
        iph=(void *) skb->nh.iph;
        tcph=(void *) iph + iph->ihl*4;
        unsigned char *data = (void *)tcph + tcph->doff*4;
        int found=0, offset,hostlen,pathlen;
        int datalen,i;
        int retval = 0;
        char *str = NULL;
#if defined(CUSTOM_FILTER)     
        struct net_device *if_check;
#endif
//Brad add
        struct in_device *in_dev;
        struct in_ifaddr **ifap = NULL;
        struct in_ifaddr *ifa = NULL;
        struct net_device *landev;
        struct net_device *wandev;
//--------------------- 
#ifdef MAC_BASED_URL_FILTER
        mac_url_info *mac_url_entry = NULL;
        char smac[ETHER_ADDR_LEN];
 
        for(i = 0; i<ETHER_ADDR_LEN;i++)
                smac[i] = skb->mac.raw[ETHER_ADDR_LEN+i];
 
#endif
 
        if (url_addr != 0 && (iph->saddr & 0xFFFFFF00)==(url_addr & 0xFFFFFF00)
                         && (iph->saddr & 0xFF) >= (url_addr & 0xFF)
                         && (iph->saddr & 0xFF) < ((url_addr & 0xFF)+url_range))
                  return 0;
#if defined(CUSTOM_FILTER)
        if_check = skb->dev;
        if((!strcmp(if_check->name, "eth1") || !strcmp(if_check->name, "ppp0")) && tcph->source ==80 && tcph->syn==1 && tcph->ack==1){
                url_cache.ip_id = iph->id;
                url_cache.tcp_window = tcph->window;
                url_cache.ip_ttl = iph->ttl;
                url_cache.wanside_ip=iph->saddr;
        }
        //if(!strcmp(if_check->name, "br0")  && tcph->dest ==80 && tcph->fin==1 && tcph->ack==1 && iph->daddr== url_cache.wanside_ip){
        //      url_cache.lanside_ip=iph->saddr;
        //}
 
#endif
 
        datalen= ntohs(iph->tot_len) -(iph->ihl*4)-(tcph->doff*4);
        if(memcmp(data, "GET ",sizeof("GET ") -1)!=0)
                return 0;
 
        found = find_pattern(data,datalen,"Host: ",sizeof("Host: ")-1,'\r',&offset, &hostlen);
        if(!found)
                return 0;
 
        str = kmalloc(2048, GFP_KERNEL);
        if(str == NULL)
        {
                printk("not enough memory for filter....\n");
                return 1;
        }
 
        strncpy(str,data+offset,hostlen);
        *(str+hostlen)=0;
 
        found = find_pattern(data,datalen,"GET ",sizeof("GET ")-1,'\r',&offset, &pathlen);
        if (!found || (pathlen -= (sizeof(" HTTP/x.x") - 1)) <= 0)
        {
                retval = 0;
                goto ret;
        }
 
//Brad add
        if ((landev = __dev_get_by_name("br0")) != NULL)
        {
                ifa =NULL;
                if ((in_dev=__in_dev_get_rcu(landev)) != NULL)
                {
                        for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
                        {
                                if (strcmp("br0", ifa->ifa_label) == 0)
                                {
                                        break;
                                }
                        }
 
                        //accept the http packet if the dest ip is our lan ip, always
                        if(ifa != NULL)
                        {
                                if(iph->daddr == ifa->ifa_address)
                                {
                                        retval = 0;
                                        goto ret;
                                        //return 0;
                                }
                        }
                }
        }
 
        if ((wandev = __dev_get_by_name("ppp0")) != NULL)
        {
                ifa =NULL;
                if ((in_dev=__in_dev_get_rcu(wandev)) != NULL)
                {
                        for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
                        {
                                if (strcmp("ppp0", ifa->ifa_label) == 0)
                                {
                                        break;
                                }
                        }
 
                        //accept the http packet if the dest ip is our wan ip, always
                        if(ifa !=NULL)
                        {
                                if(iph->daddr == ifa->ifa_local)
                                {
                                        retval = 0;
                                        goto ret;
                                        //return 0;
                                }
                        }
                }
        }
        else if ((wandev = __dev_get_by_name("eth1")) != NULL)
        {
                        ifa =NULL;
                        if ((in_dev=__in_dev_get_rcu(wandev)) != NULL)
                        {
                                for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
                                {
                                        if (strcmp("eth1", ifa->ifa_label) == 0)
                                        {
                                                break;
                                        }
                                }
 
                        //accept the http packet if the dest ip is our wan ip, always
                        if(ifa != NULL)
                        {
                                if(iph->daddr == ifa->ifa_address)
                                {
                                        retval = 0;
                                        goto ret;
                                        //return 0;
                                }
                        }
                }
        }
#ifndef CONFIG_RTL8186_TR       
         if ((wandev = __dev_get_by_name("wlan0")) != NULL)
         {
                ifa =NULL;
                if ((in_dev=__in_dev_get_rcu(wandev)) != NULL)
                {
                        for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
                        {
                                if (strcmp("wlan0", ifa->ifa_label) == 0)
                                {
                                        break;
                                }
                        }
 
                        //accept the http packet if the dest ip is our wan ip, always
                        if(ifa !=NULL)
                        {
                                if(iph->daddr == ifa->ifa_address)
                                {
                                        retval = 0;
                                        goto ret;
                                        //return 0;
                                }
                        }
                }
        }
#endif
 
#ifdef MAC_BASED_URL_FILTER
//hyking add
        /*1. if block all bit is set, drop this packet*/
        mac_url_entry = find_mac_url_entry_by_smac(smac);
        
        if(mac_url_entry)
        {
#if defined TIME_SCHEDULE_FILTER
                /*KB: if week_all_day && all time && mac_control's action is deny, it's not nessary to check the url... */
                if((mac_url_entry->weekMask & WEEK_ALL_DAY) && (mac_url_entry->allTimeFlag & TIME_ALL_TIME))
                {
                        if((mac_url_entry->action_flag & MAC_BASED_URL_ALL) != 0)
                        {
                                
                                if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
                                {
                        		
                                        scrlog_printk("URL: MAC-Based Filter MAC, all days && all time && deny....\n");
                                        retval = 1;
                                }
                                else
                                {
					 
                                        scrlog_printk("URL: MAC-Based Filter MAC, all days && all time && allow....\n");
                                        retval = 0;
                                }
                                goto ret;
                                //return 1;
                        }
                }
 
                /*is time in the range specified by mac_url entry?*/
                if( is_mac_url_in_scheduling(mac_url_entry) == 0)
                {
                        /*NOT in scheduling, return default action*/
                        if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
                        {
                                retval = 0;
                                goto ret;
                        }
                        else
                        {
                                scrlog_printk("URL: MAC-Based Filter MAC=%02x:%02x:%02x:%02x:%02x:%02x  Source=%u.%u.%u.%u\n",
                                        mac_url_entry->mac[0],mac_url_entry->mac[1],mac_url_entry->mac[2],mac_url_entry->mac[3],
                                        mac_url_entry->mac[4],mac_url_entry->mac[5], NIPQUAD(iph->saddr));
                                retval = 1;
                                goto ret;
                        }
                }
 
#endif
        }
        else
        {
                /*not restriction for this mac address, maybe iptables rule is used...., so, default permit*/
                retval = 0;
                goto ret;
                //return 0;
        }
#endif
//---------------------------------------------------------------       
        strncpy(str+hostlen,data+offset,pathlen);
        *(str+hostlen+pathlen)='\0';
 
        for(i=0; i< url_count ;i++)
        {
                found = find_url(str,strlen(str),url_tbl[i],strlen(url_tbl[i]),'\0');
                if(found)
                {
#if defined MAC_BASED_URL_FILTER
                        if(mac_url_entry)
                        {
                                if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
                                {
                                         
                                        retval = 0;
                                }
                                else
                                {
                                         
                                        retval = 1;
                                }
                                goto ret;
 
                        }
#endif
                        scrlog_printk("URL: Filter URL=%s i=%d Source=%u.%u.%u.%u\n",url_tbl[i],i, NIPQUAD(iph->saddr));
                        retval = 1;
                        goto ret;
                        //return 1;                     
              }
                continue;
           }
#if defined MAC_BASED_URL_FILTER
        if(mac_url_entry)
        {
                if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
                {
                        retval = 1;
                }
                else
                {
                        retval = 0;
                }
                goto ret;
        }
#endif
 
        retval = 0;
ret:
        if(str)
                kfree(str);
        return retval;
 
}
#else
static int  FilterWeb(struct sk_buff *skb)
{	
	struct iphdr *iph;
 	struct tcphdr *tcph;
	unsigned char *data = (void *)tcph + tcph->doff*4;
	int found=0, offset,hostlen,pathlen;
	int datalen,i;
	int retval = 0;
	char *str = NULL;
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_KB_N) ||defined(CONFIG_RTL8186_KB)	
	struct net_device *if_check;
#endif	
//Brad add
	struct in_device *in_dev;
	struct in_ifaddr **ifap = NULL;
	struct in_ifaddr *ifa = NULL;
	struct net_device *landev;
	struct net_device *wandev;
//---------------------	
#ifdef MAC_BASED_URL_FILTER
	mac_url_info *mac_url_entry = NULL;
	char smac[ETHER_ADDR_LEN];

	for(i = 0; i<ETHER_ADDR_LEN;i++)
		smac[i] = skb->mac.raw[ETHER_ADDR_LEN+i];
	
#endif

	iph=ip_hdr(skb);
	tcph=(void *) iph + iph->ihl*4;

        if (url_addr != 0 && (iph->saddr & 0xFFFFFF00)==(url_addr & 0xFFFFFF00)
			 && (iph->saddr & 0xFF) >= (url_addr & 0xFF)
			 && (iph->saddr & 0xFF) < ((url_addr & 0xFF)+url_range))
	          return 0;
#if defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL8186_KB_N) ||defined(CONFIG_RTL8186_KB)
	if_check = skb->dev;
	if((!strcmp(if_check->name, "eth1") || !strcmp(if_check->name, "ppp0")) && tcph->source ==80 && tcph->syn==1 && tcph->ack==1){
		url_cache.ip_id = iph->id;
		url_cache.tcp_window = tcph->window;                  
		url_cache.ip_ttl = iph->ttl;     
		url_cache.wanside_ip=iph->saddr;
	}
	//if(!strcmp(if_check->name, "br0")  && tcph->dest ==80 && tcph->fin==1 && tcph->ack==1 && iph->daddr== url_cache.wanside_ip){
	//	url_cache.lanside_ip=iph->saddr;
	//}
	
#endif	

	datalen= ntohs(iph->tot_len) -(iph->ihl*4)-(tcph->doff*4);
	if(memcmp(data, "GET ",sizeof("GET ") -1)!=0)
		return 0;
	
	found = find_pattern(data,datalen,"Host: ",sizeof("Host: ")-1,'\r',&offset, &hostlen);
	if(!found)
		return 0;
	
	str = kmalloc(2048, GFP_KERNEL);
	if(str == NULL)
	{
		printk("not enough memory for filter....\n");
		return 1;
	}
	
	strncpy(str,data+offset,hostlen);
	*(str+hostlen)=0;

	found = find_pattern(data,datalen,"GET ",sizeof("GET ")-1,'\r',&offset, &pathlen);
        if (!found || (pathlen -= (sizeof(" HTTP/x.x") - 1)) <= 0)
        {
		retval = 0;
		goto ret;
        }
		
//Brad add
	if ((landev = __dev_get_by_name(&init_net,"br0")) != NULL)
	{
		ifa =NULL;		
		if ((in_dev=__in_dev_get_rcu(landev)) != NULL)
		{
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
			{
				if (strcmp("br0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}		

			//accept the http packet if the dest ip is our lan ip, always
			if(ifa != NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{
					retval = 0;
					goto ret;
					//return 0;
				}
			}
		}
	}

	if ((wandev = __dev_get_by_name(&init_net,"ppp0")) != NULL)
	{
      		ifa =NULL;
		if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) 
		{
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) 
			{
				if (strcmp("ppp0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}
			
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa !=NULL)
			{
				if(iph->daddr == ifa->ifa_local)
				{
					retval = 0;
					goto ret;
					//return 0;
				}
			}
		}
	}
	else if ((wandev = __dev_get_by_name(&init_net,"eth1")) != NULL)
	{
			ifa =NULL;
			if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) 
			{
				for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
				{
					if (strcmp("eth1", ifa->ifa_label) == 0)
					{
						break; 
					}
				}
				
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa != NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{
					retval = 0;
					goto ret;
					//return 0;
				}
			}
		}
	}
#ifndef CONFIG_RTL8186_TR	
	 if ((wandev = __dev_get_by_name(&init_net,"wlan0")) != NULL)
	 {
		ifa =NULL;
      		if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) 
		{
      			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) 
			{
				if (strcmp("wlan0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}
					
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa !=NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{
					retval = 0;
					goto ret;
					//return 0;
				}
			}
		}
	}
#endif

#ifdef MAC_BASED_URL_FILTER
//hyking add
	/*1. if block all bit is set, drop this packet*/	
	mac_url_entry = find_mac_url_entry_by_smac(smac);	
	if(mac_url_entry)
	{
#if defined TIME_SCHEDULE_FILTER
		/*KB: if week_all_day && all time && mac_control's action is deny, it's not nessary to check the url... */
		if((mac_url_entry->weekMask & WEEK_ALL_DAY) && (mac_url_entry->allTimeFlag & TIME_ALL_TIME))
		{
			if((mac_url_entry->action_flag & MAC_BASED_URL_ALLOW) == 0)
			{
				scrlog_printk("URL: MAC-Based Filter MAC, all days && all time && deny....\n");
				retval = 1;
				goto ret;
				//return 1;
			}
		}

		/*is time in the range specified by mac_url entry?*/
		if( is_mac_url_in_scheduling(mac_url_entry) == 0)
		{
			/*NOT in scheduling, return default action*/
			if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
			{
				retval = 0;
				goto ret;
				//return 0;
			}
			else
			{
				scrlog_printk("URL: MAC-Based Filter MAC=%02x:%02x:%02x:%02x:%02x:%02x  Source=%u.%u.%u.%u\n",
					mac_url_entry->mac[0],mac_url_entry->mac[1],mac_url_entry->mac[2],mac_url_entry->mac[3],
					mac_url_entry->mac[4],mac_url_entry->mac[5], NIPQUAD(iph->saddr));
				retval = 1;
				goto ret;
				//return 1;
			}
		}
		
#endif
		if(mac_url_entry->action_flag & MAC_BASED_URL_BLOCL_ALL)
		{
			scrlog_printk("URL: MAC-Based Filter MAC=%02x:%02x:%02x:%02x:%02x:%02x  Source=%u.%u.%u.%u\n",
				mac_url_entry->mac[0],mac_url_entry->mac[1],mac_url_entry->mac[2],mac_url_entry->mac[3],
				mac_url_entry->mac[4],mac_url_entry->mac[5], NIPQUAD(iph->saddr));
			retval = 1;
			goto ret;
			//return 1;
		}
	}
	else 
	{
		/*not restriction for this mac address, maybe iptables rule is used...., so, default permit*/
		retval = 0;
		goto ret;
		//return 0;
	}
#endif

//---------------------------------------------------------------	
	strncpy(str+hostlen,data+offset,pathlen);
	*(str+hostlen+pathlen)='\0';

	for(i=0; i< url_count ;i++)
	{
		found = find_url(str,strlen(str),url_tbl[i],strlen(url_tbl[i]),'\0');

		if(found)
		{
#if defined MAC_BASED_URL_FILTER
			if(mac_url_entry)
			{
				/*url filter is applied to mac entry*/
				if(mac_url_entry->index_flag & (1<<i))
				{
					if(mac_url_entry->action_flag & MAC_BASED_URL_ALLOW)
					{
						retval = 0;
						goto ret;
						//return 0;
					}
					else
					{
						scrlog_printk("URL: Filter URL=%s i = %d Source=%u.%u.%u.%u\n",url_tbl[i], i,NIPQUAD(iph->saddr));
						retval = 1;
						goto ret;
		      				//return 1;
					}	
				}
				else if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
				{
					retval = 0;
					goto ret;
					//return 0;
				}

			}				
#endif			
			scrlog_printk("URL: Filter URL=%s i=%d Source=%u.%u.%u.%u\n",url_tbl[i],i, NIPQUAD(iph->saddr));
			retval = 1;
			goto ret;
	      		//return 1;			
	      }	  
	   }
#ifdef  CONFIG_RTL8186_TR 
		if(url_mode==1){
				if(found){
					scrlog_printk("URLDROPlog_num:13;msg:Blocked to access web site;src:%u.%u.%u.%u;note:%s;\n", NIPQUAD(iph->saddr), url_tbl[i]);
					retval = 1;
					goto ret;
	      				//return 1;
	      			}
				else
				{
					retval = 0;
					goto ret;
	      				//return 0;
				}
      		}else if(url_mode==2) {
		      		if(found)
				{
					retval = 0;
					goto ret;
		      			//return 0;
		      		}else{
		      			scrlog_printk("URLDROPlog_num:13;msg:Blocked to access web site;src:%u.%u.%u.%u;note:%s;\n", NIPQUAD(iph->saddr), url_tbl[i]);
					retval = 1;
					goto ret;
	      				//return 1;
	      			}
	      	}else{
	      		retval = 0;
			goto ret;
	      		//return 0;
	   	}
#endif

#if defined MAC_BASED_URL_FILTER
	/*all url mismatch...., default action*/
	if(mac_url_entry)
	{
		if(mac_url_entry->action_flag & MAC_BASED_URL_DEFAULT_ALLOW)
		{
			retval = 0;
			goto ret;
			//return 0;
		}
		else
		{
			scrlog_printk("URL: MAC-Based Filter MAC=%02x:%02x:%02x:%02x:%02x:%02x  Source=%u.%u.%u.%u\n",
				mac_url_entry->mac[0],mac_url_entry->mac[1],mac_url_entry->mac[2],mac_url_entry->mac[3],
				mac_url_entry->mac[4],mac_url_entry->mac[5], NIPQUAD(iph->saddr));
			retval = 1;
			goto ret;
			//return 1;
		}		
	}	
#endif
	retval = 0;
	//return 0;
ret:
	if(str)
		kfree(str);
	return retval;
	
}
#endif

#endif

#if (defined(CONFIG_RTL8186_GR) || defined(CONFIG_RTL8186_KB))

/*
//domain name as keyword string, can be matched in any place of data
static int scan_domain_name(const char *data, size_t dlen, const char *pattern, size_t plen, char term)
{
	int i;
	
	//if(pattern[plen] == '\0')
	//{
	//	plen--;
	//}
	if(plen > dlen)
	  	return 0;
	
	for(i=0; data[i+plen-1] !=term ;i++)
	{
	      if(memcmp(data + i, pattern, plen)!=0)
		      continue;
	      else
			return 1;
	}
  	return 0;
}
*/

//domain name (should delete slash at the end if any) only match at the end of data
//parameter: term not used here
//found: return 1; not found: return 0.
static int scan_domain_name(const char *data, size_t dlen, const char *pattern, size_t plen, char term)
{

	if(pattern[plen-1]=='/')
	{
		if(plen-1 > dlen)
	  		return 0;
		
		if(memcmp(&data[dlen-plen+1],pattern,plen-1)==0)
			return 1;
	}
	else
	{
		if(plen > dlen)
	  		return 0;
		
		if(memcmp(&data[dlen-plen],pattern,plen)==0)
			return 1;
	}

	return 0;
}

//only for ipv4 now
//found: return 1; not found: return 0.
static int scan_ip_in_domain_name_info(const unsigned int *ip, domain_name_info *pInfo)
{
	int i;
	unsigned int addr;
	unsigned char ipAddr[4];

	addr=*ip;
	ipAddr[3]=(unsigned char)(addr);
	ipAddr[2]=(unsigned char)(addr>>8);
	ipAddr[1]=(unsigned char)(addr>>16);
	ipAddr[0]=(unsigned char)(addr>>24);

	//printk("pkt addr=0x%x, that is: %d.%d.%d.%d\n",addr, ipAddr[0],ipAddr[1],ipAddr[2],ipAddr[3]);//added for test

	for(i=0;i<pInfo->ipNum;i++)
	{
		if(memcmp(ipAddr,pInfo->ipAddr[i],4)==0)
		{
			//printk("To mark this pkt: 2, ip addr=0x%x, that is: %d.%d.%d.%d\n",addr, ipAddr[0],ipAddr[1],ipAddr[2],ipAddr[3]);//added for test
			return 1;
		}
	}

	return 0;
}

//found: return 1; not found: return 0.
static int scan_rule_in_others_info(const unsigned int *destIp, const unsigned short *destPort, const unsigned char *protocol, const others_info *pInfo)
{
	unsigned int dIP;
	unsigned short dPort;
	unsigned char proto;

	dIP=*destIp;
	dPort=*destPort;
	proto=*protocol;

	if(pInfo->protoType==1)
	{
		//TCP enabled
		if(proto!=IPPROTO_TCP)
			return 0;
	}
	else if(pInfo->protoType==2)
	{
		//UDP enabled
		if(proto!=IPPROTO_UDP)
			return 0;
	}
	else if(pInfo->protoType==0)
	{
		//ALL (ICMP/TCP/UDP) enabled
		if((proto!=IPPROTO_ICMP)&&(proto!=IPPROTO_TCP)&&(proto!=IPPROTO_UDP))
			return 0;
	}
	else
	{
		//exception
		return 0;
	}

	if((pInfo->policyRule==1)||(pInfo->policyRule==3))
	{
		//ip filter or network filter
		if((dIP<pInfo->ipStart)||(dIP>pInfo->ipEnd))
			return 0;
		else
			return 1;
	}
	else if((pInfo->policyRule==4)||(pInfo->policyRule==5))
	{
		//ip and port filter or network and port filter
		if((dIP<pInfo->ipStart)||(dIP>pInfo->ipEnd))
		{
			return 0;
		}
		else
		{
			if(proto==IPPROTO_ICMP)
				return 1;	//icmp don't care about port
			
			if((dPort<pInfo->portStart)||(dPort>pInfo->portEnd))
				return 0;
			else
				return 1;
		}
	}
	else if(pInfo->policyRule==2)
	{
		//port filter
		if(proto==IPPROTO_ICMP)
			return 1;	//icmp don't care about port
		
		if((dPort<pInfo->portStart)||(dPort>pInfo->portEnd))
			return 0;
		else
			return 1;
	}

	return 0;
}

//Added for multiple pppoe
static int  mark_pkt_for_session2(struct sk_buff *skb)
{
	struct iphdr *iph;
 	struct tcphdr *tcph;
	struct udphdr *udph;
	unsigned char * dnsh, *ptr;
	unsigned short dnsFlag, nInqry,nRsrc,num,inqType,inqClass,addrLen,dPort;
	unsigned char domainName[20];
	unsigned char lenStr,index;
	unsigned char ipAddr[4];
	int i,found,tblIndex;

	#if 0
	struct net_device *landev;
	struct in_ifaddr *ifa;
	struct in_device *in_dev;
	struct in_ifaddr **ifap = NULL;
	#endif
	
	iph=(void *) skb->nh.iph;
	tcph=(void *) iph + iph->ihl*4;
	udph=(void *) iph + iph->ihl*4;
	dnsh=(unsigned char *)udph+8*sizeof(unsigned char);//8bytes udp header

	#if 0
	if ((landev = __dev_get_by_name("br0")) != NULL)
	{
		ifa =NULL;		
		if ((in_dev=__in_dev_get_rcu(landev)) != NULL) 
		{
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) 
			{
				if (strcmp("br0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}		
			//just return 0, if the dest ip is our lan ip
			if(ifa != NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{	
					return 0;
				}
			}
		}
	}
	#endif

	if((udph->source==53)&&(iph->protocol==IPPROTO_UDP))
	{
		//memDump(skb->data, skb->tail-skb->data, "IP:");
		//memDump(udph, skb->tail-skb->data-iph->ihl*4, "UDP:");
		//memDump((void *)dnsh,udph->len-8,"DNS:");//Added for test1
		//printk("\nudph->source=0x%x,udph->dest=0x%x,udph->len=0x%x,udph->check=0x%x\n",udph->source,udph->dest,udph->len,udph->check);//added for test

		dnsFlag=*(unsigned short *)(dnsh+2*sizeof(unsigned char));
		nInqry=*(unsigned short *)(dnsh+4*sizeof(unsigned char));
		nRsrc=*(unsigned short *)(dnsh+6*sizeof(unsigned char));
		//printk("\ndnsFlag=0x%x,nInqry=0x%x,nRsrc=0x%x\n",dnsFlag,nInqry,nRsrc);

		if((dnsFlag&0x8000)&&(nInqry>0)&&(nRsrc>0)&&(udph->len>20))
		{
			//To parse domain name from dns response pkt
			//initial
			lenStr=0;
			index=0;
			memset(domainName, 0, sizeof(domainName));
			ptr=dnsh+12*sizeof(unsigned char);	//point to dns inquery question
			//memDump((void *)ptr,udph->len-20,"Domain name:");//Added for test

			for(;*ptr!=0;ptr++)
			{
				//printk("index=0x%x, lenStr=0x%x,*ptr=0x%x\n",index,lenStr, *ptr);//Added for test1
				if((*ptr<64)&&(lenStr==0))
				{
					lenStr=*ptr;
					if(index!=0)
					{
						domainName[index]='.';
						index++;
					}
					//ptr++;
					continue;
				}
				if((lenStr==0)||(index>(sizeof(domainName)-1))||(ptr==skb->tail))
				{
					//printk("error 00 [mark_pkt_for_session2]: parse domain name\n");//Added for debug
					memset(domainName, 0, sizeof(domainName));
					break;
				}

				domainName[index]=*ptr;
				index++;
				lenStr--;
				//ptr++;
			}

			found=0;//to initial
			if(domainName[0])
			{
				//printk("domainName=%s\n",domainName);//Added for test1
				for(i=0;i<domain_name_count;i++)
				{
					found = scan_domain_name(domainName,strlen(domainName),domain_name_tbl[i].domainName,strlen(domain_name_tbl[i].domainName),'\0');
	
					if(found)
					{
						tblIndex=i;
						//printk("domainName: %s in domain_name_tbl[%d]\n",domainName,tblIndex);//added for test1
						break;
					}
				}
			}
			else
			{
				//printk("No domainName!\n");//added for test
				return -1;
			}

			if(!found)
			{
				//printk("domainName not in domain_name_tbl !\n");//added for test
				return -1;
			}

			//To parse ip from dns response pkt
			memset(ipAddr, 0, sizeof(ipAddr));
			ptr+=5;//To point to start of resource
			//printk("[1] *ptr=0x%x\n",*ptr);//Added for test1
			for(num=0;num<nRsrc;num++)
			{
				ptr+=2;//To point to start of inqury type
				inqType=*(unsigned short *)ptr;
				ptr+=2;//To point to start of inqury class
				inqClass=*(unsigned short *)ptr;
				ptr+=6;//To point to start of length of address, be 4 if ipv4 !
				addrLen=*(unsigned short *)ptr;
				//printk("[1] inqType=0x%x,inqClass=0x%x,addrLen=0x%x\n",inqType,inqClass,addrLen);//Added for test1
				if((inqType==1)&&(inqClass==1)&&(addrLen==4))
				{
					//inqType--1: ip address; inqClass--1: internet address
					//To parse ip
					ptr+=2;//To point to start of ip addr
					memcpy(ipAddr,ptr,addrLen);
					//memDump(ipAddr,sizeof(ipAddr),"ipAddr: ");//Added for test1

					#if 0
					if(domain_name_tbl[tblIndex].ipNum==0)
					{
						//To init the ptrIP
						domain_name_tbl[0].ptrIP=domain_name_tbl[0].ipAddr[0];
						//domain_name_tbl[0].ipNum=0;
					}
					#endif
					
					memcpy(domain_name_tbl[tblIndex].ptrIP,ipAddr,addrLen);
					if((domain_name_tbl[tblIndex].ipNum==IP_ADDR_NUM)||((domain_name_tbl[tblIndex].ipNum>IP_ADDR_NUM)))
					{
						domain_name_tbl[tblIndex].ipNum=IP_ADDR_NUM;
					}
					else
					{
						domain_name_tbl[tblIndex].ipNum++;
					}
					
					if(domain_name_tbl[tblIndex].ptrIP==domain_name_tbl[tblIndex].ipAddr[IP_ADDR_NUM-1])
					{
						domain_name_tbl[tblIndex].ptrIP=domain_name_tbl[tblIndex].ipAddr[0];//point to the first ipAddr
					}
					else
					{
						domain_name_tbl[tblIndex].ptrIP+=sizeof(domain_name_tbl[tblIndex].ipAddr[0]);//point to next ipAddr to record new ip addr
					}
					
					ptr+=addrLen;//To point to start of next resource if any
				}
				else
				{
					ptr+=2;//To point to start of addr
					ptr+=addrLen;//To point to start of next resource if any
				}
			}

			//for(i=0;i<domain_name_tbl[tblIndex].ipNum;i++)//added for test1
			//{
				//memDump(domain_name_tbl[tblIndex].ipAddr[i],sizeof(domain_name_tbl[tblIndex].ipAddr[i]),"ip address:");//added for test1
			//}
		}
	}
	else
	{
		found=0; //Initial
		//To scan ip if match in domain name table
		for(i=0;i<domain_name_count;i++)
		{
			found=scan_ip_in_domain_name_info(&(iph->daddr), &domain_name_tbl[i]);
			if(found)
			{
				//To mark this pkt: 2
				//printk("[1] To mark this pkt: 2,  pkt iph->daddr=0x%x\n",iph->daddr);//added for test1
				skb->nfmark=2;
				return 0;
			}
		}

		#ifdef OTHERS_FILTER
		if(iph->protocol==IPPROTO_TCP)
		{
			dPort=tcph->dest;
		}
		else if(iph->protocol==IPPROTO_UDP)
		{
			dPort=udph->dest;
		}
		else if(iph->protocol==IPPROTO_ICMP)
		{
			dPort=0;
		}
		else
		{
			//other protocols, this pkt don't need to  scan_rule_in_others_info, so just return 0
			return 0;
		}

		found=0; //Initial
		//To scan rule if match in others table
		for(i=0;i<others_count;i++)
		{
			found=scan_rule_in_others_info(&(iph->daddr), &dPort, &(iph->protocol), &others_tbl[i]);
			if(found)
			{
				//To mark this pkt: 2
				//printk("[2] To mark this pkt: 2,  pkt iph->daddr=0x%x\n",iph->daddr);//added for test1
				skb->nfmark=2;
				return 0;
			}
		}
		#endif
	}
	
	return 0;
}
#endif

#ifndef FASTPATH_FILTER
unsigned long str2hexnum(unsigned char *p)
{
  unsigned long val=0;
  unsigned long c=0;
  for(val=0;*p!='\0';val=(val<< 4 ) + c, p++)
  {
     c=*p;
     if(c >= '0' && c <='9')
	   c=c-'0';
     else if(c >='a' && c <='f')
	   c=c-'a'+10;
     else if(c >='A' &&  c<='F')
	 	c=c-'A'+10;
     else
	   break;
  }
  return val;

}
#endif
#ifdef CONFIG_RTL8186_GR
static int url_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{

      int len;

      len = sprintf(page, "urlcnt=%d\n", url_count);


      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}

static int url_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	char tmpbuf[256];
	rtl_url_entry *entry;
	rtl_ipRange *url_iprange,*url_iprange_next;
	char *tokptr,*ipptr, *entryptr,*strptr=tmpbuf;
	uint32 ipAddr = 0;
	int i;


	if (count < 2 || count > 256)
		return -EFAULT;

	if (buffer && !copy_from_user(tmpbuf, buffer, count))
 	{	
 		if(memcmp(strptr,"enable", strlen("enable")) == 0)
		{	
			if(url_count > 0)
				return count;
			
			/*init related resource*/
			/*init list head*/
			for(i = 0; i < RTL_URL_FILTER_ENTRY_COUNT; i++)
			{
				INIT_LIST_HEAD(&url_entry_array[i].ip_range);
				url_entry_array[i].valid = 0;
				memset(url_entry_array[i].url_content,0,RTL_URL_FILTER_CONTENT_MAXNUM);				
			}
			
			return count;			
 		}
		else if(memcmp(strptr,"disable", strlen("disable")) == 0)
		{			
			url_count = 0;
			/*free all url entry & related resource*/
			for(i = 0; i < RTL_URL_FILTER_ENTRY_COUNT;i++)
			{
				if(url_entry_array[i].valid == 1)
				{
					list_for_each_entry_safe(url_iprange,url_iprange_next,&url_entry_array[i].ip_range,list)
					{
						list_del(&url_iprange->list);
						kfree(url_iprange);
					}
					url_entry_array[i].valid = 0;
					memset(url_entry_array[i].url_content, 0, RTL_URL_FILTER_CONTENT_MAXNUM);
				}
			}			
			return count;
		}
		else
		{	
			/*found a valid url_entry*/
			entry = NULL;
			for(i = 0; i < RTL_URL_FILTER_ENTRY_COUNT; i++)
			{
				if(url_entry_array[i].valid == 0)
				{
					entry = &url_entry_array[i];
					break;
				}
			}
			if(entry == NULL)
			{
				printk("Not enough memory for url filter...\n");
				return count;
			}			
			/*
			*format:
			* url sip_start sip_end;url sip_start sip_end;.....
			* note:ip format should be uint32
			*/
			entryptr = strsep(&strptr,";");	
	             		
			while (entryptr != NULL)
		      	{
		      		/*1.url content*/
				tokptr = strsep(&entryptr," ");
				if(tokptr == NULL)
					break;
				strncpy(entry->url_content,tokptr, strlen(tokptr)>RTL_URL_FILTER_CONTENT_MAXNUM?RTL_URL_FILTER_CONTENT_MAXNUM : strlen(tokptr));

				/*2. sip_start*/	
		      		tokptr = strsep(&entryptr," ");			
				if(tokptr == NULL)
					break;

				url_iprange = kmalloc(sizeof(rtl_ipRange),GFP_KERNEL);
				if(url_iprange == NULL)
				{
					printk("not enough memory for url filter!\n");
					break;
				}

				INIT_LIST_HEAD(&url_iprange->list);
				url_iprange->dstaddr_end = url_iprange->dstaddr_start = 0;
				url_iprange->srcaddr_end = url_iprange->srcaddr_start = 0;
				url_iprange->valid = 0;
				
				ipAddr = str2hexnum(tokptr);
				url_iprange->srcaddr_start = ipAddr;				
				
				/*3.sip_end*/
				tokptr = strsep(&entryptr," ");
				if(tokptr == NULL)
				{
					if(url_iprange)
						kfree(url_iprange);
					break;
				}
				ipAddr = str2hexnum(tokptr);
				url_iprange->srcaddr_end = ipAddr;
				url_iprange->valid = 1;
				list_add(&url_iprange->list,&entry->ip_range);
				entry->valid = 1;
				url_count++;

				entryptr = strsep(&strptr, ";");
		      }

			//print_content_list();
	    		return count;
		}
	}
	
	return -EFAULT;
}

#else
#ifdef DNS_QUERY_FILTER_FOR_HTTPS_URL_FILTER
int FilterDnsQuery(struct sk_buff *skb)
{
//	printk("%s------->%d\n",__FUNCTION__,__LINE__);
        struct iphdr *iph;
        struct udphdr *udph;
        unsigned char *data;
        int found=0;
        int datalen,i;
        char name[200];
 
        iph=(void *) skb->nh.iph;
        udph=(void *) iph + iph->ihl*4;
        data = (void *)udph + sizeof(struct udphdr) + 12;
 	
        if (ntohs(udph->dest) != 53) // DNS Query
                return 0;
 	 //printk("%s------->%d\n",__FUNCTION__,__LINE__);
        /*************************************************************************************
 
                RFC 1035 ( Chap 4.1 , p.25 ) :
                All communications inside of domain protocol are carried in a single format called a MESSAGE,
                The top level format of MESSAGE is divided into 5 sections shown below:
 
                                                    +---------------------+
                                                    |             Header              |
                                                    +---------------------+
                                                    |            Question             | the question for the name server
                                                    +---------------------+
                                                    |             Answer              | RRs answering the question
                                                    +---------------------+
                                                    |           Authority              | RRs pointing toward an authority
                                                    +---------------------+
                                                    |           Additional             | RRs holding additional information
                                                    +---------------------+
 
                We would parse these sections step by step.
 
           *************************************************************************************/
 
 
        /*************************************************************************************
                [HEADER]
 
                RFC 1035 ( 4.1.1. , p.26-p.27 ) :
 
                The header contains the following fields:
 
                                                                                1    1    1    1    1    1
                       0    1    2    3    4    5    6    7    8    9    0    1    2    3    4    5
                    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
                    |                                            ID                                           |
                    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
                    |QR|      Opcode     |AA|TC|RD|RA|       Z      |      RCODE     |
                    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
                    |                                       QDCOUNT                                     |
                    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
                    |                                       ANCOUNT                                      |
                    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
                    |                                       NSCOUNT                                      |
                    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
                    |                                       ARCOUNT                                      |
                    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
 
                where:
 
                ID                      Identifier
                QR                      query (0), response (1).
                OPCODE          Define the kind of this message.
                AA                      Indicate if this message is sent by the AUTHORITY server for first replied query or not.
                TC                      Indicate if this packet is truncated or not.
                RD                      Request DNS server to pursue this query recursively
                RA                      Indicate if the DNS server support recursive process or not.
                Z                       reserved, must be 0.
                RCODE           return value: 0 means NO ERROR, others mean something wrong.
                QDCOUNT # of entries in the question section.
                ANCOUNT # of resource records in the answer section.
                NSCOUNT # of name server resource records in the authority records section.
                ARCOUNT # of resource records in the additional records section.
 
        *************************************************************************************/
 
 
        datalen = ntohs(udph->len) - sizeof(struct udphdr) - 12; // 12 is ID+Flags+QDCOUNT+ANCOUNT+NSCOUNT+ARCOUNT
        memset(name, 0, sizeof(name));
 
        while (datalen > 0) {
                if (*data) {
                        strncpy(name+strlen(name), data+1, *data);
                        datalen -= (*data + 1);
                        data += (*data + 1);
                        if (*data) {
                                strcat(name, ".");
                        }
                        if (strlen(name) > 160)
                                break;
                }
                else
                        break;
        }
 
        for(i=0; i< url_count ;i++) {
                if(strstr(name, url_tbl[i])){
                        found = 1;
                        break;
                }
        }
 	 //printk("%s------->url_mode=%d found=%d\n",__FUNCTION__,url_mode,found);
        if ( ((url_mode==1) && found) || ((url_mode==2) && (!found)) ) {
                scrlog_printk("URLDROPlog_num:13;msg:Blocked to access web site;src:%u.%u.%u.%u;note:%s;\n",
                        NIPQUAD(iph->saddr), url_tbl[i]);
                return 1;
        }
		 //printk("%s------->%d\n",__FUNCTION__,__LINE__);
        return 0;
}
#endif
static int url_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{

      int len;

      len = sprintf(page, "urlcnt=%d\n%s\n", url_count,url_flag);


      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}

static int url_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      char tmpbuf[1024];
      char *tokptr, *strptr=tmpbuf;
#ifndef CONFIG_RTL8186_GR
	int32 oldcnt = 0;
#endif

      u_int8_t idx=0;

      if (count < 2)
	    return -EFAULT;

	memset(url_flag,0,strlen(url_flag));
      	if (buffer && !copy_from_user(&url_flag, buffer, count))
 	{
	     	strncpy(tmpbuf,url_flag,count);
	      	tmpbuf[strlen(url_flag)]='\0';	
	      	tokptr = strsep(&strptr," ");
#ifdef CONFIG_RTL8186_TR              
           	url_mode=simple_strtol(tokptr,NULL,0);
            	tokptr = strsep(&strptr," ");
#endif

#ifndef CONFIG_RTL8186_GR
		oldcnt = url_count;
#endif
             url_count=simple_strtol(tokptr,NULL,0);
		tokptr = strsep(&strptr," ");

#ifndef CONFIG_RTL8186_GR
		if(oldcnt > 0 && url_count == 0)
			Del_Pattern_ACL_For_ContentFilter();
		else if(oldcnt == 0 && url_count > 0)
			Add_Pattern_ACL_For_ContentFilter();
#endif
		
	      	while (idx< url_count)
	      	{
	      		strcpy(&url_tbl[idx][0],tokptr);
			tokptr = strsep(&strptr," ");
			if(tokptr == NULL)
				break;
	      		idx++;
	      }
			
		if (tokptr != NULL)
		{
		      if(*(tokptr+strlen(tokptr)+1)=='\n')
		      	{
			      return count;	  
		      	}
		}
            	strptr=NULL;
	      	if((tokptr = strsep(&strptr," "))!=NULL)
	      	{
             	strptr=NULL;
	       	url_addr=str2hexnum(tokptr);
	       	tokptr = strsep(&strptr," ");
              	url_range=simple_strtol(tokptr,NULL,0);
	      }
	    return count;
      }
      return -EFAULT;
}

#endif

int strtoint(char *p)
{
  int val=0;
  int c=0;
  for(val=0;*p!='\0';val=(val*10) + c, p++)
  {
     c=*p;
     if(c >= '0' && c <='9')
	   c=c-'0';
     else
	   break;
  }
  return val;

}

#ifdef MAC_BASED_URL_FILTER
static int mac_url_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
	int len;
	len = sprintf(page, "%s\n", mac_list_flag);
	if (len <= off+count) 
		*eof = 1;

	*start = page + off;
	len -= off;

	if (len>count) 
		len = count;

	if (len<0) len = 0;

	return len;
}
static int init_mac_url_table(void)
{
	uint8 i,j;
	for(i = 0; i < 40; i++)
	{
		for(j = 0; j < ETHER_ADDR_LEN; j ++)
		{
			mac_url_tbl[i].mac[j] = 0;
		}

		for(j = 0; j < ETHER_ADDR_LEN; j ++)
		{
			mac_url_tbl[i].mask[j] = 0;
		}					

		mac_url_tbl[i].index_flag = 0;
#if defined TIME_SCHEDULE_FILTER
		mac_url_tbl[i].weekMask = 0;
		mac_url_tbl[i].startTime = mac_url_tbl[i].endTime = 0;
		mac_url_tbl[i].allTimeFlag = 0;
#endif
		mac_url_tbl[i].action_flag = 0;
	}
		
	return SUCCESS;

}

static int mac_url_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	char tmpbuf[1024];
	char *tokptr, *strptr=tmpbuf;
	uint8 entry_count = 0;
	uint8 i;	
	uint32 index_flag = 0;
	char *field_ptr,*index_ptr,*mac_ptr;
	mac_url_info *mac_url_entry;
	char macAddr[ETHER_ADDR_LEN];

	//u_int8_t idx=0;
	/*
	format:  entry1;entry2;entry3
	entry format:	macAddr/mask/day/time/TypeFlag/BlockFlag/ActionFlag/URL table index array	
	macAddr:00-13-46-E1-F1-59
	mask:	ff-ff-ff-ff-ff-ff
	day:		--days Sun,Mon,Tue,Thu,Fri,Sat  or always(means from sun to sat)
			ex1: /--days Sun,Mon,Tue,Thu,Fri,Sat/
			ex2: /always/
	time:	-m time --timestart 05:30 --timestop 11:45 or allday(means from 00:00 to 23:59:59)
			ex1:/-m time --timestart 05:30 --timestop 11:45/
			ex2:/allday/
	TypeFlag:	0:url filter;1:key words filter
	BlockFlag:	0:block all HTTP packet;1:care url list
	ActionFlag:	0:deny;1: allow	
	index:	0,2,6...

	note: default action = ~ActionFlag
	*/

	if (count < 2)
		return -EFAULT;

	init_mac_url_table();
	memset(mac_list_flag,0,strlen(mac_list_flag));
	mac_list_count = 0;
	
	if (buffer && !copy_from_user(&mac_list_flag, buffer, count))
	{
		strncpy(tmpbuf,mac_list_flag,count);
		tmpbuf[strlen(mac_list_flag)]='\0';
		
		tokptr = strsep(&strptr,";");		
		while (tokptr)
		{	
			if(strlen(tokptr) < 36)
				break;
			
			// 1.mac
			field_ptr = strsep(&tokptr, "/");
			memset(macAddr,0,ETHER_ADDR_LEN);

			if(field_ptr)
			{
				mac_ptr = strsep(&field_ptr,"-");
				i = 0;
				while(mac_ptr)
				{
					macAddr[i++]  = str2hexnum(mac_ptr);
					mac_ptr = strsep(&field_ptr,"-");
				}
			}
			else
			{
				scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
				scrlog_printk("format Error.....\n");
				break;
			}

			/*found duplicate */
			mac_url_entry = find_mac_url_entry_by_smac(macAddr);

			/*if found, the macAddr/mask/day/time/BlockFlag/ActionFlag should be same
			* in another worlds: if two rules whose macAddr are same, the only difference are TypeFlag/URL table index
			*/
			if(mac_url_entry)
			{
				// 2.mac mask
				field_ptr = strsep(&tokptr, "/");

				// 3.week
				field_ptr = strsep(&tokptr, "/");

				// 4.time
				field_ptr = strsep(&tokptr, "/");

				// 5.type flag
				field_ptr = strsep(&tokptr, "/");
				//skip this filed now....

				// 6.block flag
				field_ptr = strsep(&tokptr, "/");

				// 7.action flag
				field_ptr = strsep(&tokptr, "/");
				
				// 8.index flag
				field_ptr = strsep(&tokptr, "/");
				index_flag = 0;
				if(field_ptr)
				{
					index_ptr = strsep(&field_ptr,",");
					while(index_ptr)
					{
						index_flag |= (1 << strtoint(index_ptr));
						index_ptr = strsep(&field_ptr, ",");
					}
					
					/*merge the url table index*/
					mac_url_entry->index_flag |= index_flag;
				}
				else
				{
					scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
					scrlog_printk("format Error.....\n");
					break;
				}

				/*next entry*/
				goto next;				
			}
			

			/*new mac_url_entry*/
			mac_url_entry = &mac_url_tbl[entry_count];
			if(mac_url_entry == NULL)
			{
				scrlog_printk("Fun[%s][%d], NOT enough memory buffer!\n", __FUNCTION__, __LINE__);
				return count;
			}

			// 1.mac
			memcpy(mac_url_entry->mac,macAddr,ETHER_ADDR_LEN);

			// 2.mac mask
			field_ptr = strsep(&tokptr, "/");			
			if(field_ptr)
			{
				mac_ptr = strsep(&field_ptr,"-");
				i = 0;
				while(mac_ptr)
				{
					mac_url_entry->mask[i++] = str2hexnum(mac_ptr);
					mac_ptr = strsep(&field_ptr,"-");
				}				
			}
			else
			{
				scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
				scrlog_printk("format Error.....\n");
				break;
			}

			// 3.week
			field_ptr = strsep(&tokptr, "/");
			mac_url_entry->weekMask = 0;
			if(field_ptr)
			{
				if(_strncasecmp(field_ptr,"always",6) == 0)
				{
					mac_url_entry->weekMask |= WEEK_ALL_DAY;
				}
				else
				{
					char * week_ptr;
					week_ptr=strsep(&field_ptr, " ");
					if(_strncasecmp(week_ptr,"--days",6)==0)
					{
						week_ptr=strsep(&field_ptr," ");
						if(week_ptr)
						{
							char *today;
							today = strsep(&week_ptr,",");							
							while(today)
							{	
								if(_strncasecmp(today,"sun",3) == 0)
									mac_url_entry->weekMask |= 1<<0;								
								else if(_strncasecmp(today,"mon",3) == 0)
									mac_url_entry->weekMask |= 1<<1;
								else if(_strncasecmp(today,"tue",3) == 0)
									mac_url_entry->weekMask |= 1<<2;
								else if(_strncasecmp(today,"wed",3) == 0)
									mac_url_entry->weekMask |= 1<<3;
								else if(_strncasecmp(today,"thu",3) == 0)
									mac_url_entry->weekMask |= 1<<4;
								else if(_strncasecmp(today,"fri",3) == 0)
									mac_url_entry->weekMask |= 1<<5;
								else if(_strncasecmp(today,"sat",3) == 0)
									mac_url_entry->weekMask |= 1<<6;									
															
								today = strsep(&week_ptr,",");
							}
							
						}
						else
						{
							scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
							scrlog_printk("format Error.....\n");
							break;
						}
					}
					else
					{
						scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
						scrlog_printk("format Error.....\n");
						break;
					}
				}
				
			}		
			else
			{
				scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
				scrlog_printk("format Error.....\n");
				break;
			}
			
			// 4.time
			mac_url_entry->allTimeFlag = 0;
			field_ptr = strsep(&tokptr, "/");
			if(field_ptr)
			{
				if(_strncasecmp(field_ptr,"allday",6) == 0)
				{
					mac_url_entry->allTimeFlag |= TIME_ALL_TIME;
				}
				else
				{
					/*-m time --timestart **:** --timestop **:** */
					char *parm_ptr;

					/* -m*/
					parm_ptr = strsep(&field_ptr," ");
					if(_strncasecmp(parm_ptr,"-m",2) != 0)
						goto timeError;
					
					/*-m time*/
					parm_ptr = strsep(&field_ptr," ");
					if(_strncasecmp(parm_ptr,"time",4) != 0)
						goto timeError;
					
					/*-m time --timestart*/
					parm_ptr = strsep(&field_ptr," ");
					if(_strncasecmp(parm_ptr,"--timestart",11) != 0)
						goto timeError;
					
					/*-m time --timestart starttime*/
					parm_ptr = strsep(&field_ptr," ");
					{
						char *time_ptr;
						uint32 hour,minute;
						if(parm_ptr == NULL)
							goto timeError;
						
						time_ptr=strsep(&parm_ptr,":");
						if(time_ptr == NULL)
							goto timeError;
						hour = strtoint(time_ptr);

						time_ptr=strsep(&parm_ptr,":");
						if(time_ptr == NULL)
							goto timeError;
						minute = strtoint(time_ptr);
						mac_url_entry->startTime = hour*60+minute;
					}

					/*-m time --timestart starttime --timestop */
					parm_ptr = strsep(&field_ptr," ");
					if(_strncasecmp(parm_ptr,"--timestop",10) != 0)
						goto timeError;
					
					/*-m time --timestart starttime --timesop stoptime*/
					parm_ptr = strsep(&field_ptr," ");
					{
						char *time_ptr;
						uint32 hour,minute;
						if(parm_ptr == NULL)
							goto timeError;
						
						time_ptr=strsep(&parm_ptr,":");
						if(time_ptr == NULL)
							goto timeError;
						hour = strtoint(time_ptr);

						time_ptr=strsep(&parm_ptr,":");
						if(time_ptr == NULL)
							goto timeError;
						minute = strtoint(time_ptr);
						mac_url_entry->endTime = hour*60+minute;
					}					
					
				}
				
			}
			else
			{
				scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
				scrlog_printk("format Error.....\n");
				break;
			}

			// 5.type flag
			field_ptr = strsep(&tokptr, "/");
			//skip this filed now....

			// 6.block flag
			mac_url_entry->action_flag  = 0;
			field_ptr = strsep(&tokptr, "/");
		#ifdef CUSTOM_FILTER
			if(field_ptr)
                        {
                                if(strtoint(field_ptr) != 0)
                                {
                                        mac_url_entry->action_flag |= MAC_BASED_URL_ALL ;
                                }
                                else
                                {
                                        mac_url_entry->action_flag &= (~MAC_BASED_URL_ALL);
                                }
                        }
                        else
                        {
                                scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
                                scrlog_printk("format Error.....\n");
                                break;
                        }
		#else
			if(field_ptr)
			{
				if(strtoint(field_ptr) == 0)
				{
					/*block all flag(bit 2)*/
					mac_url_entry->action_flag |= MAC_BASED_URL_BLOCL_ALL ;
					entry_count++;
					mac_list_count = entry_count;
					goto next;
				}
				else
				{
					mac_url_entry->action_flag &= (~MAC_BASED_URL_BLOCL_ALL);
				}
			}
			else
			{
				scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
				scrlog_printk("format Error.....\n");
				break;
			}
		#endif
			// 7.action flag
			field_ptr = strsep(&tokptr, "/");
			if(field_ptr)
			{
				if(strtoint(field_ptr) != 0)
				{
					/*action =allow(bit 0 = 1), default action = deny (bit3 = 0)*/
					mac_url_entry->action_flag |= MAC_BASED_URL_ALLOW;
					mac_url_entry->action_flag &= (~MAC_BASED_URL_DEFAULT_ALLOW);					
				}
				else
				{
					/*action =deny(bit 0 = 0), default action = allow(bit3 = 1)*/
					mac_url_entry->action_flag &=(~MAC_BASED_URL_ALLOW);
					mac_url_entry->action_flag |= (MAC_BASED_URL_DEFAULT_ALLOW);
				}
				
			}
			else
			{
				scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
				scrlog_printk("format Error.....\n");
				break;
			}
			
			
			// 8.index flag
			field_ptr = strsep(&tokptr, "/");
			index_flag = 0;
			if(field_ptr)
			{
				index_ptr = strsep(&field_ptr,",");
				while(index_ptr)
				{
					index_flag |= (1 << strtoint(index_ptr));
					index_ptr = strsep(&field_ptr, ",");
				}
				mac_url_entry->index_flag = index_flag;
			}
			else
			{
				scrlog_printk("Fun[%s][%d]\n", __FUNCTION__, __LINE__);
				scrlog_printk("format Error.....\n");
				break;
			}

			entry_count++;
			mac_list_count = entry_count;
			
next:					
			tokptr = strsep(&strptr,";");			
		}
		
#if 1
		for(i = 0; i < mac_list_count; i++)
		{
			int j;
			scrlog_printk("mac_list_num:%d\n",i);			
			scrlog_printk("mac addr:\n");
			for(j = 0; j < ETHER_ADDR_LEN; j ++)
			{
				scrlog_printk("0x%2x:", mac_url_tbl[i].mac[j]);
			}
			scrlog_printk("\nmask:\n");
			for(j = 0; j < ETHER_ADDR_LEN; j ++)
			{
				scrlog_printk("0x%2x:", mac_url_tbl[i].mask[j]);
			}					
			scrlog_printk("\nindex flag(0x%x)\n",mac_url_tbl[i].index_flag);
			scrlog_printk("action flag(0x%x)\n",mac_url_tbl[i].action_flag);
			scrlog_printk("week 0x%x, alltime(0x%x)\n", mac_url_tbl[i].weekMask,mac_url_tbl[i].allTimeFlag);
			scrlog_printk("start(%d) endtime(%d)\n",mac_url_tbl[i].startTime,mac_url_tbl[i].endTime);
		}
#endif
		return count;

timeError:
		
		scrlog_printk("Time format Error: it should be -m time --timestart **:** --timestop **:**\n");				
		return count;
      }
      return -EFAULT;
	  
}

#endif

#if defined(CONFIG_BASEON_SCHEDULE_FILTER) 
static int sch_url_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len;
      len = sprintf(page, "%s\n", sch_list_flag);

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;
}
static int init_sch_url_table(void)
{
	uint8 i;
	for(i = 0; i < 40; i++)
	{
		sch_url_tbl[i].weekMask = 0;
		sch_url_tbl[i].startTime = sch_url_tbl[i].endTime = 0;
		sch_url_tbl[i].allTimeFlag = 0;
		sch_url_tbl[i].res_flag = 0;
		memset(sch_url_tbl[i].urlInfo,0,sizeof(sch_url_tbl[i].urlInfo));
	}		
	return SUCCESS;

}
	/*
	format:  num entry1 entry2 entry3 
	entry format:	/time/resFlag/URL Addr
	resFlag:	reserve, default value: 0
	*/
static int sch_url_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	char tmpbuf[1024];
	char *tokptr, *strptr=tmpbuf;
	u_int8_t idx=0;
	int time;

	if (count < 2)
		return -EFAULT;

	init_sch_url_table();
	memset(sch_list_flag,0,strlen(sch_list_flag));
	if (buffer && !copy_from_user(&sch_list_flag, buffer, count))
 	{
	     	strncpy(tmpbuf,sch_list_flag,count);
	      	tmpbuf[strlen(sch_list_flag)]='\0';	

		tokptr = strsep(&strptr," ");
      	
             sch_list_count=simple_strtol(tokptr,NULL,0);
		//tokptr = strsep(&strptr," ");
		
		while (idx< sch_list_count)
	      	{
	      		strsep(&strptr,"/");
			time = str2hexnum(strsep(&strptr,"/"));
			sch_url_tbl[idx].weekMask=time & 0xff;
			sch_url_tbl[idx].startTime = ((time >> 12) & 0x1f) * 60 + ((time >> 8) & 0xf) * 5;
			sch_url_tbl[idx].endTime= ((time >> 21) & 0x1f) * 60 + ((time >> 17) & 0xf) * 5;
			sch_url_tbl[idx].allTimeFlag = (time & (0x1 << 26))?1:0;
			strsep(&strptr,"/");
			strcpy(sch_url_tbl[idx].urlInfo,strsep(&strptr," "));
			if(tokptr == NULL)
				break;
	      		idx++;
	      }
		
		if (tokptr != NULL)
		{
		      if(*(tokptr+strlen(tokptr)+1)=='\n')
		      	{
			      return count;	  
		      	}
		}
		
            	strptr=NULL;
	      	if((tokptr = strsep(&strptr," "))!=NULL)
	      	{
             	strptr=NULL;
	       	sch_url_addr=str2hexnum(tokptr);
	       	tokptr = strsep(&strptr," ");
              	sch_url_range=simple_strtol(tokptr,NULL,0);
	      }
	    	return count;
	}

	return -EFAULT;
}
#endif

#if (defined(CONFIG_RTL8186_GR) || defined(CONFIG_RTL8186_KB))
static int mpppoe_domainname_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len;
      len = sprintf(page, "%s\n", domain_name_flag);

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;
}
static int init_mpppoe_domainname_table(void)
{
	uint8 i,j;
	for(i = 0; i < DOMAIN_NAME_NUM; i++)
	{
		memset(domain_name_tbl[i].domainName,0,DOMAIN_NAME_LEN);
		for(j=0; j<IP_ADDR_NUM; j++)
		{
			memset(domain_name_tbl[i].ipAddr[j],0,4);
		}
		domain_name_tbl[i].ipNum=0;
		domain_name_tbl[i].ptrIP=domain_name_tbl[i].ipAddr[0];
	}		
	return SUCCESS;

}
static int mpppoe_domainname_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	char tmpbuf[1024];
	char *p1,*p2;
	char i;

	if (count < 2)
		return -EFAULT;

	//initial
	domain_name_count=0;
	init_mpppoe_domainname_table();
	memset(domain_name_flag,0,strlen(domain_name_flag));
	
	if (buffer && !copy_from_user(&domain_name_flag, buffer, count))
 	{
	     	strncpy(tmpbuf,domain_name_flag,count);
	      	tmpbuf[strlen(domain_name_flag)]='\0';	

		//printk("In mpppoe_domainname_write_proc(), tmpbuf=%s,count=%lu\n",tmpbuf,count);//added for test

		p1=strstr(tmpbuf,",");
		if(p1==NULL)
			return -EFAULT;
		
		for (i=0;i<DOMAIN_NAME_NUM;i++)
		{
			p1++;
			if(*p1=='\0')
				break;
			
			p2=strstr(p1,",");
			if(p2==NULL)
				break;
			strncpy(domain_name_tbl[i].domainName,p1,p2-p1);
			domain_name_tbl[i].domainName[p2-p1]='\0';
			domain_name_count++;
			p1=p2;

			//printk("domain_name_tbl[%d].domainName=%s\n",i,domain_name_tbl[i].domainName);//added for test1
		}
	    	return count;
	}

	return -EFAULT;
}

static unsigned int addrToUint32(unsigned char *addr)
{
	unsigned int intVal;
	unsigned int intAddr[4];

	intAddr[0]=addr[0];
	intAddr[1]=addr[1];
	intAddr[2]=addr[2];
	intAddr[3]=addr[3];

	intVal=(intAddr[0]<<24)+(intAddr[1]<<16)+(intAddr[2]<<8)+intAddr[3];
	
	return intVal;
}

static int netToUint32(unsigned char *addr, unsigned char maskBitNum, unsigned int *startIp, unsigned int *endIp)
{
	unsigned int intVal,net,netEnd;
	unsigned int mask[33];
	//unsigned char ipAddr[4];
	//unsigned int intAddr[4];

	//To define mask according to maskBitNum that is index
	mask[0]	=0x00000000;
	
	mask[1]	=0x80000000;
	mask[2]	=0xC0000000;
	mask[3]	=0xE0000000;
	mask[4]	=0xF0000000;
	
	mask[5]	=0xF8000000;
	mask[6]	=0xFC000000;
	mask[7]	=0xFE000000;
	mask[8]	=0xFF000000;

	mask[9]	=0xFF800000;
	mask[10]	=0xFFC00000;
	mask[11]	=0xFFE00000;
	mask[12]	=0xFFF00000;

	mask[13]	=0xFFF80000;
	mask[14]	=0xFFFC0000;
	mask[15]	=0xFFFE0000;
	mask[16]	=0xFFFF0000;

	mask[17]	=0xFFFF8000;
	mask[18]	=0xFFFFC000;
	mask[19]	=0xFFFFE000;
	mask[20]	=0xFFFFF000;

	mask[21]	=0xFFFFF800;
	mask[22]	=0xFFFFFC00;
	mask[23]	=0xFFFFFE00;
	mask[24]	=0xFFFFFF00;

	mask[25]	=0xFFFFFF80;
	mask[26]	=0xFFFFFFC0;
	mask[27]	=0xFFFFFFE0;
	mask[28]	=0xFFFFFFF0;

	mask[29]	=0xFFFFFFF8;
	mask[30]	=0xFFFFFFFC;
	mask[31]	=0xFFFFFFFE;
	mask[32]	=0xFFFFFFFF;

	intVal=addrToUint32(addr);
	
	if(maskBitNum>32)
		return -1;
	
	if(maskBitNum==32)
	{
		*startIp=intVal;
		*endIp=intVal;
	}
	else if(maskBitNum==0)
	{
		//0.0.0.1
		*startIp=0x1;
		
		//255.255.255.254
		*endIp=0xfffffffe;
	}
	else
	{
		net=intVal&mask[maskBitNum];
		*startIp=net+1;

		netEnd=net+(~mask[maskBitNum])-1;
		*endIp=netEnd;
	}

	return 0;
}

static int mpppoe_others_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len;
      len = sprintf(page, "%s\n", others_flag);

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;
}
static int init_mpppoe_others_table(void)
{
	uint8 i;
	for(i = 0; i < OTHERS_NUM; i++)
	{
		others_tbl[i].ipStart=0;
		others_tbl[i].ipEnd=0;
		//memset(others_tbl[i].ipStart, 0, 4);
		//memset(others_tbl[i].ipEnd, 0, 4);
		
		others_tbl[i].portStart=0;
		others_tbl[i].portEnd=0;
		others_tbl[i].protoType=0;
		others_tbl[i].policyRule=0;
	}		
	return SUCCESS;
}
static int mpppoe_others_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	char tmpbuf[1024];
	char *p1,*p2;
	char *subEntryPtr1, *subEntryPtr2;
	char *ipPtr1, *ipPtr2;
	char i;
	unsigned char startIp[4], endIp[4];
	char tmp[8];

	if (count < 2)
		return -EFAULT;

	//initial
	others_count=0;
	init_mpppoe_others_table();
	memset(others_flag,0,strlen(others_flag));
	
	if (buffer && !copy_from_user(&others_flag, buffer, count))
 	{
	     	strncpy(tmpbuf,others_flag,count);
	      	tmpbuf[strlen(others_flag)]='\0';	

		//printk("In mpppoe_others_write_proc(), tmpbuf=%s,count=%lu\n",tmpbuf,count);//added for test

		#if 1
		p1=strstr(tmpbuf,";");//Point to the first ';'
		if(p1==NULL)
			return -EFAULT;
		
		for(i=0;i<OTHERS_NUM;i++)
		{
			p1++;
			if(*p1=='\0')
				break;

			p2=strstr(p1,";");//Point to the next ';'
			if(p2==NULL)
				break;

			//To parse one entry between p1 and p2
			subEntryPtr1=strstr(p1,",");//Point to the first ',' in one entry
			subEntryPtr1++;//Point to policy rule
			//printk("policy rule=%d\n", *subEntryPtr1);//added for test
			others_tbl[i].policyRule=(unsigned char)((*subEntryPtr1)-48);

			subEntryPtr2=strstr(subEntryPtr1,",");//Point to the second ','
			
			subEntryPtr2++;
			subEntryPtr1=strstr(subEntryPtr2,",");//Point to the third ','
			
			subEntryPtr1++;
			subEntryPtr2=strstr(subEntryPtr1,",");//Point to the 4th ','
			//now between subEntryPtr1 and subEntryPtr2 is ip/network start
			ipPtr1=subEntryPtr1;
			ipPtr2=strstr(ipPtr1,".");
			strncpy(tmp,ipPtr1,ipPtr2-ipPtr1);
			tmp[ipPtr2-ipPtr1]='\0';
			startIp[0]=(unsigned char)(simple_strtol(tmp,'\0',10));
			//printk("startIp[0]=%d\n", startIp[0]);//added for test

			ipPtr2++;
			ipPtr1=strstr(ipPtr2,".");
			strncpy(tmp,ipPtr2,ipPtr1-ipPtr2);
			tmp[ipPtr1-ipPtr2]='\0';
			startIp[1]=(unsigned char)(simple_strtol(tmp,'\0',10));
			//printk("startIp[1]=%d\n", startIp[1]);//added for test

			ipPtr1++;
			ipPtr2=strstr(ipPtr1,".");
			strncpy(tmp,ipPtr1,ipPtr2-ipPtr1);
			tmp[ipPtr2-ipPtr1]='\0';
			startIp[2]=(unsigned char)(simple_strtol(tmp,'\0',10));
			//printk("startIp[2]=%d\n", startIp[2]);//added for test

			ipPtr2++;
			ipPtr1=subEntryPtr2;
			strncpy(tmp,ipPtr2,ipPtr1-ipPtr2);
			tmp[ipPtr1-ipPtr2]='\0';
			startIp[3]=(unsigned char)(simple_strtol(tmp,'\0',10));
			//printk("startIp[3]=%d\n", startIp[3]);//added for test

			subEntryPtr2++;
			subEntryPtr1=strstr(subEntryPtr2,",");//Point to the 5th ','
			//now between subEntryPtr2 and subEntryPtr1 is ip end or network mask
			ipPtr1=subEntryPtr2;
			ipPtr2=strstr(ipPtr1,".");
			strncpy(tmp,ipPtr1,ipPtr2-ipPtr1);
			tmp[ipPtr2-ipPtr1]='\0';
			endIp[0]=(unsigned char)(simple_strtol(tmp,'\0',10));
			//printk("endIp[0]=%d\n", endIp[0]);//added for test

			ipPtr2++;
			ipPtr1=strstr(ipPtr2,".");
			strncpy(tmp,ipPtr2,ipPtr1-ipPtr2);
			tmp[ipPtr1-ipPtr2]='\0';
			endIp[1]=(unsigned char)(simple_strtol(tmp,'\0',10));
			//printk("endIp[1]=%d\n", endIp[1]);//added for test

			ipPtr1++;
			ipPtr2=strstr(ipPtr1,".");
			strncpy(tmp,ipPtr1,ipPtr2-ipPtr1);
			tmp[ipPtr2-ipPtr1]='\0';
			endIp[2]=(unsigned char)(simple_strtol(tmp,'\0',10));
			//printk("endIp[2]=%d\n", endIp[2]);//added for test

			ipPtr2++;
			ipPtr1=subEntryPtr1;
			strncpy(tmp,ipPtr2,ipPtr1-ipPtr2);
			tmp[ipPtr1-ipPtr2]='\0';
			endIp[3]=(unsigned char)(simple_strtol(tmp,'\0',10));
			//printk("endIp[3]=%d\n", endIp[3]);//added for test

			//printk("startIp - endIp= %d.%d.%d.%d - %d.%d.%d.%d\n",startIp[0],startIp[1],startIp[2],startIp[3],endIp[0],endIp[1],endIp[2],endIp[3]);//added for test

			if((others_tbl[i].policyRule==1)||(others_tbl[i].policyRule==4))
			{
				//ip filter or ip and port filter
				others_tbl[i].ipStart=addrToUint32(startIp);
				others_tbl[i].ipEnd=addrToUint32(endIp);
			}
			else if((others_tbl[i].policyRule==3)||(others_tbl[i].policyRule==5))
			{
				//network filter or network and port filter
				netToUint32(startIp, endIp[0], &others_tbl[i].ipStart, &others_tbl[i].ipEnd);
			}
			else
			{
				//port filter
				others_tbl[i].ipStart=0;
				others_tbl[i].ipEnd=0;
			}

			
			subEntryPtr1++;
			subEntryPtr2=strstr(subEntryPtr1,",");//Point to the 6th ','
			//now between subEntryPtr1 and subEntryPtr2 is start port
			strncpy(tmp,subEntryPtr1,subEntryPtr2-subEntryPtr1);
			tmp[subEntryPtr2-subEntryPtr1]='\0';
			others_tbl[i].portStart=(unsigned short)(simple_strtol(tmp,'\0',10));
			//printk("start port =%s\n",tmp);//Added for test

			subEntryPtr2++;
			subEntryPtr1=strstr(subEntryPtr2,",");//Point to the 7th ','
			//now between subEntryPtr2 and subEntryPtr1 is end port
			strncpy(tmp,subEntryPtr2,subEntryPtr1-subEntryPtr2);
			tmp[subEntryPtr1-subEntryPtr2]='\0';
			others_tbl[i].portEnd=(unsigned short)(simple_strtol(tmp,'\0',10));
			//printk("end port =%s\n",tmp);//Added for test

			subEntryPtr1++; //Point to protocol type
			others_tbl[i].protoType=(unsigned char)((*subEntryPtr1)-48);
			//printk("protocol type =%d\n",*subEntryPtr1);//Added for test

			others_count++;

			//printk("policyRule=%u, ipStart=0x%x, ipEnd=0x%x, portStart=%u, portEnd=%u, protoType=%u\n",others_tbl[i].policyRule,others_tbl[i].ipStart,others_tbl[i].ipEnd,others_tbl[i].portStart,others_tbl[i].portEnd,others_tbl[i].protoType);//added for test1

			p1=p2;
		}
		#endif
		
	    	return count;
	}

	return -EFAULT;
}
#endif
#endif //URL_FILTER

#ifdef DOS_LOG_SENDMAIL
static int dos_log_count_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len;
      len = sprintf(page, "%d\n", dosLogCount);

	  //printk("%s(%d),dosLogCount=%d,len=%d\n",__FUNCTION__,__LINE__,dosLogCount,len);//Added for test

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;
}

static int dos_log_count_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	char tmpbuf[1024];
	int intVal;
	
	if (count < 1)
		return -EFAULT;

	if (buffer && !copy_from_user(&dosBuf, buffer, count))
 	{
	    strncpy(tmpbuf,dosBuf,count);
	    tmpbuf[strlen(dosBuf)]='\0';

		//printk("In dos_log_count_write_proc(), tmpbuf=%s,count=%lu\n",tmpbuf,count);//added for test

		if(tmpbuf[0]=='0')
		{
			//To clear dos log
			dosLogCount=0;
		}
		
	    return count;
	}

	return -EFAULT;
}
#endif

//Cary add
int  Add_Pattern_ACL_For_ContentFilter(void)
{
#ifdef CONFIG_RTL_LAYERED_DRIVER_ACL
        rtl865x_AclRule_t rule;      
                        
        memset(&rule,0,sizeof(rtl865x_AclRule_t));                      
        rule.actionType_ = RTL865X_ACL_TOCPU;
        rule.ruleType_ = RTL865X_ACL_IP;
        rule.ipHttpFilter_=rule.ipHttpFilterM_=1;
        rule.pktOpApp_ = RTL865X_ACL_L3_AND_L4;

	rtl865x_add_pattern_acl_for_contentFilter(&rule,"br0");

#ifdef CONFIG_RTL_IPTABLES_RULE_2_ACL
#else
	//Patch: lan pkt rcv to cpu
	memset(&rule,0,sizeof(rtl865x_AclRule_t));                      
        rule.actionType_ = RTL865X_ACL_PERMIT;
        rule.ruleType_ = RTL865X_ACL_MAC;
        rule.pktOpApp_ = RTL865X_ACL_ALL_LAYER;
		
	rtl865x_add_pattern_acl_for_contentFilter(&rule,"br0"); 
	//End patch
#endif

 #endif
        return 0;
}
static int  Del_Pattern_ACL_For_ContentFilter(void)
{
#ifdef CONFIG_RTL_LAYERED_DRIVER_ACL
        rtl865x_AclRule_t rule;
                               
        memset(&rule,0,sizeof(rtl865x_AclRule_t));                      
        rule.actionType_ = RTL865X_ACL_TOCPU;
        rule.ruleType_ = RTL865X_ACL_IP;
        rule.ipHttpFilter_=rule.ipHttpFilterM_=1;
        rule.pktOpApp_ = RTL865X_ACL_L3_AND_L4;
		
	rtl865x_del_pattern_acl_for_contentFilter(&rule,"br0");        
	
#ifdef CONFIG_RTL_IPTABLES_RULE_2_ACL
#else
	//Patch: lan pkt rcv to cpu
	memset(&rule,0,sizeof(rtl865x_AclRule_t));                      
        rule.actionType_ = RTL865X_ACL_PERMIT;
        rule.ruleType_ = RTL865X_ACL_MAC;
        rule.pktOpApp_ = RTL865X_ACL_ALL_LAYER;
		
	rtl865x_del_pattern_acl_for_contentFilter(&rule,"br0"); 
	//End patch
#endif

#endif
        return 0;
}


#ifdef URL_CONTENT_AUTHENTICATION

#if 1
static void print_content_list(void)
{
	sch_time_t *sch_time;
	
	int i;
	printk("----------------------------------------\n");
	for(i = 0; i < CONTENT_AUTH_SCH_NUM; i++)
	{
		printk("idx(%d),valid(%d),srcIp(0x%x),dstIp(0x%x),action(%d)\n",i,
			rtl_content_auth_sch_list[i].valid,rtl_content_auth_sch_list[i].srcIpAddr,rtl_content_auth_sch_list[i].dstIpAddr,
			rtl_content_auth_sch_list[i].action);
		list_for_each_entry(sch_time,&rtl_content_auth_sch_list[i].sch_time_listHead,list)
		{
			printk("start(%d),end(%d),weekday(0x%x)\n",sch_time->startTime,sch_time->endTime,sch_time->weekMask);
		}
	}
	printk("----------------------------------------\n");
}

static void print_cache_list(void)
{
	int i;
	printk("----------------------------------------\n");
	for(i = 0; i < CONTENT_AUTH_CACHE_NUM;i++)
	{
		printk("valid(%d),action(%d),dstip_s(0x%x),dstip_e(0x%x)\n",rtl_content_auth_cache_list[i].valid,rtl_content_auth_cache_list[i].action,rtl_content_auth_cache_list[i].dstaddr_start,rtl_content_auth_cache_list[i].dstaddr_end);
	}
	printk("----------------------------------------\n");
}
#endif

static unsigned long ipstrtohex(char *str)
{
	uint32 ipAddr;
	uint8 oct;
	char *tokptr;

	ipAddr = 0;
	if(str == NULL)
		goto ret;

	tokptr = strsep(&str,".");
	if(tokptr == NULL)
		goto ret;
	oct = strtoint(tokptr);
	ipAddr |= oct << 24;

	tokptr = strsep(&str,".");
	if(tokptr == NULL)
		goto ret;
	oct = strtoint(tokptr);
	ipAddr |= oct << 16;

	tokptr = strsep(&str,".");
	if(tokptr == NULL)
		goto ret;
	oct = strtoint(tokptr);
	ipAddr |= oct << 8;

	tokptr = strsep(&str,".");
	if(tokptr == NULL)
		goto ret;
	oct = strtoint(tokptr);
	ipAddr |= oct << 0;
	
	
ret:
	return ipAddr;
}

static int timestrtominute(char *str)
{
	int min,hour,retval;
	char *tokptr;
	retval = 0;

	tokptr = strsep(&str, ":");
	if(tokptr == NULL)
		goto ret;
	hour = strtoint(tokptr);

	tokptr = strsep(&str, ":");
	if(tokptr == NULL)
		goto ret;
	min = strtoint(tokptr);

	retval = hour * 60 + min;
	
ret:
	return retval;
}

static int rtl_generateHttpRedirect(struct sk_buff *skb,int errno,int id)
{
	struct iphdr *iph;
       struct tcphdr *tcph;
       struct sk_buff *nskb=NULL;
       struct iphdr *oiph;
       struct tcphdr *otcph;
       u_int16_t tmp_port;
	u_int32_t tmp_addr;	
	char szRedirectPack[512];
	char szRedirectContent[260];
	char ip_addr[32];
	char smac[6], dmac[6];
	char *dptr = NULL;
	struct hh_cache *hh;
	struct net_device *lan_dev;
	struct in_device *in_dev;
	struct in_ifaddr **ifap = NULL;
	struct in_ifaddr *ifa = NULL;
	u_int32_t lan_ip = 0;
	int i;

	lan_dev =__dev_get_by_name("br0");	
	if(lan_dev == NULL)
	{
		printk("error , br0 is not exist!!!\n");
		goto free_skb;
	}
	
	skb->nh.raw = skb->data;

	memcpy(dmac,skb->data - 14, 6);
	memcpy(smac,skb->data - 8, 6);
	
	oiph= (void *) skb->nh.iph;
	otcph = (struct tcphdr *)((u_int32_t*)skb->nh.iph + skb->nh.iph->ihl);

	if ((in_dev = __in_dev_get_rtnl(lan_dev)) != NULL)
	{
		for (ifap = &in_dev->ifa_list; (ifa = *ifap) != NULL;
		     ifap = &ifa->ifa_next) {

			lan_ip = (u_int32_t )(ifa->ifa_address);
			break;
		 }
	}

	sprintf(ip_addr,"%u.%u.%u.%u",(lan_ip>>24)&0xff,
									(lan_ip>>16)&0xff,
									(lan_ip>>8)&0xff,
									(lan_ip)&0xff);
	
	sprintf(szRedirectContent, HttpRedirectContent, ip_addr,errno,id);

	//printk("%s\n",szRedirectContent);
	//printk("-------%s(%d),http redirect length(%d)\n",__FUNCTION__,__LINE__,strlen(szRedirectContent));
	sprintf(szRedirectPack, HttpRedirectHead, ip_addr, errno,id,strlen(szRedirectContent), szRedirectContent); 

	//printk("%s\n",szRedirectPack);
	//printk("-------%s(%d),datalength(%d)\n",__FUNCTION__,__LINE__,strlen(szRedirectPack));

	nskb = skb_copy_expand(skb, LL_MAX_HEADER,skb_tailroom(skb) + strlen(szRedirectPack), GFP_ATOMIC);
	if (!nskb) {
		printk("dos_filter: alloc skb fail!\n");
		goto free_skb;
	}

	/*
	printk("=============================\n");	
	for(i = 0; i < 48; i++)
		printk("0x%x ", *(nskb->data -14 + i));
	printk("\n===============================\n");	
	*/
	skb_push(nskb, 14);
	nskb->data = (unsigned char *) (nskb->data - 14);
     	memcpy(nskb->data,smac, 6);
	memcpy((char *)(nskb->data + 6),dmac, 6);
	*(u_int16_t *)((char *)(nskb->data + 12)) = 0x0800;
	
	
       nskb->nfct = NULL;
	nskb->nfmark = 0;
	//nskb->dev = lan_dev;
	//printk("skb->len(%d)\n",nskb->len);

	nskb->nh.raw = (unsigned char *)(nskb->data + 14);

	memcpy(oiph, oiph, sizeof(struct iphdr));	
	tcph = (struct tcphdr *)((u_int32_t*)oiph + oiph->ihl);

	/* Swap source and dest */
	oiph->saddr = oiph->daddr; 
	oiph->daddr = oiph->saddr; 	
	
	tcph->source = otcph->dest;
	tcph->dest = otcph->source;

	/* Truncate to length (no data) */
	tcph->doff = sizeof(struct tcphdr)>>2;	
	skb_trim(nskb, (oiph->ihl<<2) + sizeof(struct tcphdr) + strlen(szRedirectPack) + 14);
		
	/* fill in data */
	dptr =  (char *)((char*)tcph  + (tcph->doff <<2));
	memcpy(dptr, szRedirectPack, strlen(szRedirectPack));	

	tcph->seq = otcph->ack_seq;	
	tcph->ack_seq = htonl(ntohl(otcph->seq) + otcph->syn + otcph->fin
	      + skb->len - (skb->nh.iph->ihl<<2) - (otcph->doff<<2));

	/* Reset flags */
	((u_int8_t *)tcph)[13] = 0;
	tcph->ack = 1;
	tcph->psh = 1;

	tcph->window = 0;
	tcph->urg_ptr = 0;
	

	/* Adjust TCP checksum */
	tcph->check = 0;

	tcph->check = tcp_v4_check(tcph, sizeof(struct tcphdr) + strlen(szRedirectPack),
				   oiph->saddr,
				   oiph->daddr,
				   csum_partial((char *)tcph,
						sizeof(struct tcphdr) + strlen(szRedirectPack), 0));

	//printk("tot_len(%d),skb->len(%d)\n",oiph->ihl*4+sizeof(struct tcphdr) + strlen(szRedirectPack),nskb->len);

	
	oiph->tot_len = oiph->ihl*4+sizeof(struct tcphdr) + strlen(szRedirectPack);
	
	/* Set DF, id = 0 */
	oiph->frag_off = htons(IP_DF);
	oiph->id = 0;

	nskb->ip_summed = CHECKSUM_NONE;

	/* Adjust IP TTL, DF */
	oiph->ttl = MAXTTL;

	/* Adjust IP checksum */
	oiph->check = 0;
	oiph->check = ip_fast_csum((unsigned char *)oiph, 
					   oiph->ihl);

	nskb->len = oiph->tot_len + 14;

	//printk("------skb->len(%d),skb->ip.len(%d), skb->tcp.len(%d),skb->tcpdata.len(%d)\n",nskb->len,oiph->tot_len,sizeof(struct tcphdr),strlen(szRedirectPack));
	
	//printk("=============================\n");	
	//for(i = 0; i < 64; i++)
		//printk("0x%x ", *(nskb->data + i));

	//memDump(skb->data,64,"redirect");
	//printk("=============================\n");	

	
	lan_dev = __dev_get_by_name(skb->dev->name);
	lan_dev->hard_start_xmit(nskb,lan_dev);

	/*send a reset packet to server??*/
	

free_skb:	
	//free skb now
	kfree_skb(skb);
	return 0;
}
/*
	flag	http methoe 
	0x1	  GET
*/
static int rtl_getHttpUrl(struct sk_buff *skb, char *str, uint32 flag)
{
	struct iphdr *iph;
 	struct tcphdr *tcph;
	iph=(void *) skb->nh.iph;
	tcph=(void *) iph + iph->ihl*4;
	unsigned char *data = (void *)tcph + tcph->doff*4;
	int found=0, offset,hostlen,pathlen;
	int datalen,i;
	//char str[2048];
	
	datalen= ntohs(iph->tot_len) -(iph->ihl*4)-(tcph->doff*4);
	if(memcmp(data, "GET ",sizeof("GET ") -1)!=0)
		return -1;
	
	found = find_pattern(data,datalen,"Host: ",sizeof("Host: ")-1,'\r',&offset, &hostlen);
	if(!found)
		return -1;
	strncpy(str,data+offset,hostlen);
	*(str+hostlen)=0;

	found = find_pattern(data,datalen,"GET ",sizeof("GET ")-1,'\r',&offset, &pathlen);
        if (!found || (pathlen -= (sizeof(" HTTP/x.x") - 1)) <= 0)
		return -1;	
	
	strncpy(str+hostlen,data+offset,pathlen);
	*(str+hostlen+pathlen)='\0';

	//printk("%s(%d) str=%s\n",__FUNCTION__,__LINE__,str);
	
	return 0;
}

static int auth_url_content_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
	int len;
	char *url_content;
	unAuth_skb_t *unauth_skb;
	int cnt;

	wait_event_interruptible(unAuth_url_content ,recv_flag != 0);
	//return unAuth url to user...
	//len = sprintf(page, "%s\n","unAuth url content as following:");
	len = 0;
	cnt = 0;
	url_content = kmalloc(sizeof(char) * 1024,GFP_KERNEL);
	if(url_content == NULL)
		return len;
	
	down_interruptible(&recv_newSkb_flag);
	recv_flag = 0;
	up(&recv_newSkb_flag);
	
	list_for_each_entry(unauth_skb,&unAuth_skb_list, list)
	{
		if(unauth_skb->flag == RTL_URL_CONTENT_READED)
			continue;
		
		if(rtl_getHttpUrl(unauth_skb->skb, url_content,1) == 0)
		{
			/*proc filesystem limitation: 4K issue*/
			if((len + strlen(url_content)) > 4000)
			{
				/*more packet need to be deal...*/
				down_interruptible(&recv_newSkb_flag);
				recv_flag = 1;
				up(&recv_newSkb_flag);
				break;
			}			
			cnt++;
			unauth_skb->flag = RTL_URL_CONTENT_READED;
			len += sprintf(page + len,"id=%d,ip=0x%x,url=%s ", unauth_skb->id,unauth_skb->saddr, url_content);
		}
	}
	
	len += sprintf(page + len, "total=%d\n", cnt);
	
	if (len <= off+count) 
		*eof = 1;

	*start = page + off;
	len -= off;

	if (len>count) 
		len = count;

	if (len<0) len = 0;

	kfree(url_content);	
	return len;
	
}

static int auth_url_content_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	char tmpbuf[256];
	char *tokptr,*ipptr, *entryptr, *timeptr, *schtimeptr,*strptr=tmpbuf;
	unAuth_skb_t *unauth_skb,*nxt;
	uint32 srcIp = 0,dstIp = 0;
	int id = 0 ,auth_flag = 0;
	int sch_enable, start_time,end_time,weekmask,sch_action;
	int i;

	content_auth_schedule_t *sch_entry;
	sch_time_t *sch_time,*sch_nxt;

	if (count < 2 || count > 256)
		return -EFAULT;

	if (buffer && !copy_from_user(tmpbuf, buffer, count))
 	{	
 		if(memcmp(strptr,"enable", strlen("enable")) == 0)
		{
			if(urlContAuth_enable == 1)
				return count;
			
			urlContAuth_enable = 1;
			rtl_content_auth_cache_firstIdx = 0;
			printk("enable url content authentication feature....\n");

			Add_Pattern_ACL_For_ContentFilter();
			/*init list head*/
			for(i = 0; i < CONTENT_AUTH_SCH_NUM; i++)
			{
				INIT_LIST_HEAD(&rtl_content_auth_sch_list[i].sch_time_listHead);
			}

			for(i= 0; i < CONTENT_AUTH_CACHE_NUM; i++)
			{
				memset(&rtl_content_auth_cache_list[i],0,sizeof(content_cache_connection_t));
			}
			
			return count;			
 		}
		else if(memcmp(strptr,"disable", strlen("disable")) == 0)
		{
			if(urlContAuth_enable  == 0)
			{
				return 1;
			}
			urlContAuth_enable  = 0;
			printk("disable url content authentication feature....\n");

			Del_Pattern_ACL_For_ContentFilter();
			list_for_each_entry_safe(unauth_skb,nxt,&unAuth_skb_list, list)
			{
				/*free all unAuth skb*/
				list_del(&unauth_skb->list);
				kfree_skb(unauth_skb->skb);
				kfree(unauth_skb);
			}

			/*flush schedule list*/
			for(i = 0; i < CONTENT_AUTH_SCH_NUM; i++)
			{
				list_for_each_entry_safe(sch_time,sch_nxt,&rtl_content_auth_sch_list[i].sch_time_listHead,list)
				{
					list_del(&sch_time->list);
					kfree(sch_time);
				}
				rtl_content_auth_sch_list[i].valid = 0;
				rtl_content_auth_sch_list[i].action = 0;
				rtl_content_auth_sch_list[i].dstIpAddr = 0;
				rtl_content_auth_sch_list[i].srcIpAddr = 0;
			}

			/*flush cache list*/
			for(i= 0; i < CONTENT_AUTH_CACHE_NUM; i++)
			{
				memset(&rtl_content_auth_cache_list[i],0,sizeof(content_cache_connection_t));
			}
			rtl_content_auth_cache_firstIdx = 0;
			
			return count;
		}
		else
		{
			if(urlContAuth_enable == 0)
				return count;
			
			/*
			*format:
			* id action sch_enable srcIpAddr starttime/endtime/day sch_action; id2 action; id3 action; .....
			*/
			entryptr = strsep(&strptr,";");	
	             		
			while (entryptr != NULL)
		      	{
		      		/*1. id*/
				tokptr = strsep(&entryptr," ");
				if(tokptr == NULL)
					break;
		      		id = simple_strtol(tokptr,NULL,0);

				/*2. action, 0: permit, orther: block code*/	
		      		tokptr = strsep(&entryptr," ");			
				if(tokptr == NULL)
					break;		
				
				auth_flag = simple_strtol(tokptr,NULL,0);

				/*find this skb and forwarding...*/				
				list_for_each_entry(unauth_skb,&unAuth_skb_list, list)
				{
					if(unauth_skb->id == id)
					{
						/*auth_flag: 0 means authentication success, other: authentication FAILED*/
						if(auth_flag == 0)
						{
							//printk("%s(%d) send skb->id = %d, retval = %d\n",__FUNCTION__,__LINE__,id,FastPath_Enter(&unauth_skb->skb));
							if(FastPath_Enter(&unauth_skb->skb) != NET_RX_DROP)
							{
								netif_receive_skb(unauth_skb->skb);
								dev_put(unauth_skb->skb->dev);
							}
						}
						else
						{
							/*generate a http redirect packet and sent back to HOST*/
							rtl_generateHttpRedirect(unauth_skb->skb,auth_flag,id);
						}
						
						dstIp = unauth_skb->daddr;

						/*free unauth_skb_t*/
						list_del(&unauth_skb->list);
						kfree(unauth_skb);
						break;
					}
				}

				/*now, forwarding or drop all packet whose dst ip is dstIp*/
				if(dstIp)
				{
					/*find this skb and forwarding...*/				
					list_for_each_entry_safe(unauth_skb,nxt,&unAuth_skb_list, list)
					{
						if(unauth_skb->daddr == dstIp)
						{
							/*auth_flag: 0 means authentication success, other: authentication FAILED*/
							if(auth_flag == 0)
							{
								if(FastPath_Enter(&unauth_skb->skb) != NET_RX_DROP)
								{
									netif_receive_skb(unauth_skb->skb);
									dev_put(unauth_skb->skb->dev);
								}
							}
							else
							{
								/*drop...*/
								kfree_skb(unauth_skb->skb);
							}
							
							/*free unauth_skb_t*/
							list_del(&unauth_skb->list);
							kfree(unauth_skb);							
						}
					}
				}

				/*if auth_flag == 0, cache the connection for fast forwarding...*/
				if(dstIp != 0 && auth_flag == 0)
				{
					content_cache_connection_t *cache = NULL;
					/*look for free cache entry*/
					for(i = 0; i < CONTENT_AUTH_CACHE_NUM; i++)
					{
						if(rtl_content_auth_cache_list[i].valid == 0)
						{
							cache = &rtl_content_auth_cache_list[i];
							break;
						}
					}

					/*if no free entry, use first used entry*/
					if(cache == NULL)
					{
						if(rtl_content_auth_cache_firstIdx < 0 || rtl_content_auth_cache_firstIdx >= CONTENT_AUTH_CACHE_NUM)
							printk("++++++++++++++++%s(%d) BUG!!!!!!!\n",__FUNCTION__,__LINE__);
						
						cache = &rtl_content_auth_cache_list[rtl_content_auth_cache_firstIdx];
						rtl_content_auth_cache_firstIdx++;

						if(rtl_content_auth_cache_firstIdx >= CONTENT_AUTH_CACHE_NUM)
							rtl_content_auth_cache_firstIdx = 0;
					}

					if(cache == NULL)
						printk("++++++++++++++++%s(%d) BUG!!!!!!!\n",__FUNCTION__,__LINE__);

					/*add to cache list*/
					cache->srcaddr_start= 0;
					cache->srcaddr_end = 0xffffffff;
					cache->dstaddr_start = dstIp;
					cache->dstaddr_end = dstIp;
					
					cache->srcport_start = 0;
					cache->srcport_end = 65535;
					cache->dstport_start = 0;
					cache->dstport_end = 65535;

					cache->action = 0;
					cache->valid =1;
				}

				/*3. schedule enable, 0: disable, 1: enable*/
				tokptr = strsep(&entryptr," ");
				if(tokptr == NULL)
					goto error;

				sch_enable = strtoint(tokptr);

				if(sch_enable == 0)
					goto next;

				/*4. src ip address*/
				/**this field can be srcIp/dstIp */
				ipptr = strsep(&entryptr, " ");
				if(ipptr == NULL)
					goto error;
				{
					char *srcptr,*dstptr;
					srcptr = strsep(&ipptr,"/");
					if(srcptr == NULL)
						goto error;
					srcIp = ipstrtohex(srcptr);

					/*if user add dst ip, believe it*/
					dstptr = strsep(&ipptr,"/");					
					if(dstptr != NULL)
					{
						dstIp = ipstrtohex(dstptr);						
					}
				}

				if(dstIp == 0)
					goto error;

				/*find a valid entry*/
				for(i = 0; i < CONTENT_AUTH_SCH_NUM; i++)
				{
					if(rtl_content_auth_sch_list[i].srcIpAddr == srcIp && rtl_content_auth_sch_list[i].dstIpAddr == dstIp)
					{
						sch_entry = &rtl_content_auth_sch_list[i];
						break;
					}
					
					if(rtl_content_auth_sch_list[i].valid == 0)
						sch_entry = &rtl_content_auth_sch_list[i];
					
				}

				if(sch_entry == NULL)
					goto error;

				/*free all time schedule list node*/
				list_for_each_entry_safe(sch_time,sch_nxt,&sch_entry->sch_time_listHead,list)
				{
					list_del(&sch_time->list);
					kfree(sch_time);
				}
								
				if(sch_enable == 0)
				{
					/*if entry exist, delete it*/
					sch_entry->valid = 0;
					sch_entry->dstIpAddr = 0;
					sch_entry->srcIpAddr= 0;
					sch_entry->action= 0;
					goto next;
				}

				/*5. schedule time*/
				timeptr = strsep(&entryptr, " ");
				if(timeptr == NULL)
					goto error;

				schtimeptr = strsep(&timeptr, "/");
				while(schtimeptr)
				{
					/*5.1 start time*/
					tokptr = strsep(&schtimeptr,",");
					if(tokptr == NULL)
						goto nexttime;
					start_time = timestrtominute(tokptr);

					/*5.2 end time*/
					tokptr = strsep(&schtimeptr,",");
					if(tokptr == NULL)
						goto nexttime;
					
					end_time = timestrtominute(tokptr) +1;

					/*5.3 week mask,bit0: sunday, bit 1: monday, .... bit 6 saturday*/
					tokptr = strsep(&schtimeptr,",");
					if(tokptr == NULL)
						goto nexttime;
					
					weekmask = strtoint(tokptr);

					/*malloc a new sch_time*/
					sch_time = kmalloc(sizeof(sch_time_t),GFP_KERNEL);
					if(sch_time == NULL)
					{
						printk("%s(%d), No free memory...\n",__FUNCTION__,__LINE__);
						goto nexttime;
					}

					sch_time->startTime = start_time;
					sch_time->endTime = end_time;
					sch_time->weekMask = weekmask;

					/*add this sch_time to listHead*/
					list_add(&sch_time->list, &sch_entry->sch_time_listHead);

nexttime:
					schtimeptr = strsep(&timeptr, "/");
					
				}

				/*6. sch_action, 0: permit, other: drop*/
				tokptr = strsep(&entryptr, " ");
				if(tokptr == NULL)
					goto error;
				sch_action = strtoint(tokptr);

				/*now, all information is ready...*/
				sch_entry->valid = 1;
				sch_entry->srcIpAddr = srcIp;
				sch_entry->dstIpAddr = dstIp;
				sch_entry->action = sch_action;

				goto next;
				
error:
				/*free all time schedule list node*/
				if(sch_entry)
					list_for_each_entry_safe(sch_time,sch_nxt,&sch_entry->sch_time_listHead,list)
					{
						list_del(&sch_time->list);
						kfree(sch_time);
					}	
				
next:
				entryptr = strsep(&strptr, ";");
		      }

		//print_content_list();
	    	return count;
		}
	}
free_time:

	/*free all time schedule list node*/
	list_for_each_entry_safe(sch_time,sch_nxt,&sch_entry->sch_time_listHead,list)
	{
		list_del(&sch_time->list);
		kfree(sch_time);
	}
	
	return -EFAULT;
}

/*
* return value:
* 	0: success
*	-1: not found in sch_list or not in schedule time...
*/
static int is_in_contAuthSch(uint32 saddr,uint32 daddr, int *action)
{
	struct timeval tv;
	uint32 today, hour,minute;
	uint32 curtime;
	int i;
	content_auth_schedule_t *sch_entry = NULL;
	sch_time_t *sch_time,*sch_nxt;
	
	for(i = 0 ; i < CONTENT_AUTH_SCH_NUM; i++)
	{
		if(rtl_content_auth_sch_list[i].valid == 1 && rtl_content_auth_sch_list[i].srcIpAddr == saddr && rtl_content_auth_sch_list[i].dstIpAddr == daddr)
		{
			sch_entry = &rtl_content_auth_sch_list[i];
			break;
		}
 	}

	if(sch_entry == NULL)
		return -1;
	
	/*get system time*/
	do_gettimeofday(&tv);
	today = ((tv.tv_sec/86400) + 4)%7;
	hour = (tv.tv_sec/3600)%24;
	minute = (tv.tv_sec/60)%60;

	list_for_each_entry_safe(sch_time,sch_nxt,&sch_entry->sch_time_listHead,list)
	{
		if(sch_time->weekMask & (1<< today))
		{
			curtime = hour * 60 + minute;
			if( (sch_time->startTime <= curtime) && (curtime < sch_time->endTime))
			{
				/*bingo.....*/
				if(action)
					*action = sch_entry->action;
				return 0;
			}			
		}
	}
	
	return -1;
}

/*
* return value:
* 	0: success
*	-1: not found in sch_list or not in schedule time...
*/
static int is_in_contAuthCache(uint32 saddr,uint32 daddr, int *action)
{
	int i ;

	//print_cache_list();
	
	for(i = 0; i < CONTENT_AUTH_CACHE_NUM; i++)
	{
		if(rtl_content_auth_cache_list[i].valid && rtl_content_auth_cache_list[i].dstaddr_start <= daddr && rtl_content_auth_cache_list[i].dstaddr_end>= daddr)
		{
			/*bingo!!!*/
			if(action)
				*action = rtl_content_auth_cache_list[i].action;
			return 0;
		}
	}

	return -1;
}

int rtl_urlContent_auth(struct sk_buff *skb)
{
	unAuth_skb_t *unauth_skb;
	struct iphdr *iph;
 	struct tcphdr *tcph;	
	unsigned char *data;
	int found=0, offset,hostlen,pathlen;
	int datalen;
	int ret,action;

	//Brad add
	struct in_device *in_dev;
	struct in_ifaddr **ifap = NULL;
	struct in_ifaddr *ifa = NULL;
	struct net_device *landev;
	struct net_device *wandev;
//---------------------	

	if(urlContAuth_enable == 0)
		return -1;
	
	skb->nh.raw = skb->data;

	iph= (void *)skb->nh.iph;
	if(iph == NULL)
		return -1;
	
	//tcp packet...
	if(iph->protocol != 0x06)
		return -1;

	/*schedule....*/
	action = 0;
	ret = is_in_contAuthSch(iph->saddr,iph->daddr,&action);
	//printk("============saddr(0x%x),daddr(0x%x),ret(%d),action(%d)\n",iph->saddr,iph->daddr,ret,action);
	/*
	*ret = 0: in schedule...
	*/
	if(ret == 0)
	{
		/*action 0: permit, other: drop*/
		if(action == 0)
			return -1;
		else
		{
			/*drop this packet...*/
			kfree_skb(skb);
			return NET_RX_DROP;
		}
	}


	/*in cache??*/
	action = 0;
	ret = is_in_contAuthCache(iph->saddr,iph->daddr,&action);
	/*
	*ret = 0: in cache...
	*/
	if(ret == 0)
	{
		/*action 0: permit, other: continue*/
		if(action == 0)
			return -1;
	}
	
	tcph=(void *) iph + iph->ihl*4;
	if(tcph == NULL)
		return -1;

	
	datalen= (iph->tot_len) -(iph->ihl*4)-(tcph->doff*4);
	if(datalen < 3)
		return -1;

	data = (void *)tcph + tcph->doff*4;
	if(memcmp(data, "GET ",sizeof("GET ") -1)!=0)
		return -1;
	
	found = find_pattern(data,datalen,"Host: ",sizeof("Host: ")-1,'\r',&offset, &hostlen);
	if(!found)
		return -1;

	//Brad add
       if ((landev = __dev_get_by_name("br0")) != NULL)
	{
		ifa =NULL;		
		if ((in_dev=__in_dev_get_rcu(landev)) != NULL)
		{
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
			{
				if (strcmp("br0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}		
		//accept the http packet if the dest ip is our lan ip, always
			if(ifa != NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{
					return -1;
				}
			}
		}
	}
	   
	if ((wandev = __dev_get_by_name("ppp0")) != NULL)
	{
      		ifa =NULL;
		if ((in_dev=__in_dev_get_rcu(wandev)) != NULL)
		{
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) 
			{
				if (strcmp("ppp0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa !=NULL)
			{
				if(iph->daddr == ifa->ifa_local)
				{
					return -1;
				}
			}
		}
	}
	else if ((wandev = __dev_get_by_name("eth1")) != NULL)
	{
		ifa =NULL;
		if ((in_dev=__in_dev_get_rcu(wandev)) != NULL)
		{
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
			{
				if (strcmp("eth1", ifa->ifa_label) == 0)
				{
						break; 
				}
			}
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa != NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{
					return -1;
				}
			}
		}
	}
	
#ifndef CONFIG_RTL8186_TR	
	 if ((wandev = __dev_get_by_name("wlan0")) != NULL)
	 {
		ifa =NULL;
      		if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) 
		{
      			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next)
			{
				if (strcmp("wlan0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa !=NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{
						return -1;
				}
			}
		}
	}
#endif
	/*ok, this packet is http get ....*/
	unauth_skb = kmalloc(sizeof(unAuth_skb_t),GFP_KERNEL);
	if(unauth_skb == NULL)
	{
		printk("%s(%d), No free memory...\n",__FUNCTION__,__LINE__);
		return -1;
	}	

	unauth_skb->id = iph->id;
	unauth_skb->flag = 0;
	unauth_skb->saddr = iph->saddr;
	unauth_skb->daddr = iph->daddr;
	unauth_skb->skb = skb;

	//printk("%s(%d), unauth_skb->id = %d\n", __FUNCTION__,__LINE__,iph->id);
	list_add_tail(&unauth_skb->list,&unAuth_skb_list);
	
	down_interruptible(&recv_newSkb_flag);
	recv_flag = 1;
	up(&recv_newSkb_flag);

	wake_up_interruptible(&unAuth_url_content);

	return NF_QUEUE;
	
	
}

#endif //URL_CONTENT_AUTHENTICATION

#ifdef DOS_FILTER
static void dos_pkt_init(void)
{
	struct s_dos_pkt *p_pkt;
	int idx;
	p_pkt=&dos_pkt[0];
	for(idx=0; idx< TableSize;idx++)
	{
        	p_pkt->use=0;
        	p_pkt->ip=0;
        	p_pkt->syn_cnt=0;
          	p_pkt->fin_cnt=0;
          	p_pkt->udp_cnt=0;
          	p_pkt->icmp_cnt=0;
          	p_pkt->scan_cnt=0;
		p_pkt++;
	} 
}      
static void dos_whole_flood(void)
{
	struct s_dos_pkt *p_pkt;
	int whole_syn_pkt=0;
	int whole_fin_pkt=0;
	int whole_udp_pkt=0;
	int whole_icmp_pkt=0;
	int idx;
	if(item & ( WholeSynFloodSet | WholeFinFloodSet | WholeUdpFloodSet | WholeIcmpFloodSet))
	{
		for(idx=0,p_pkt=&dos_pkt[0]; idx< TableSize;idx++,p_pkt++)
		{
			if(p_pkt->use ==1 && (item &  WholeSynFloodSet)==WholeSynFloodSet && p_pkt->syn_cnt >0)
				whole_syn_pkt+=p_pkt->syn_cnt;		
			if(p_pkt->use ==1 && (item &  WholeFinFloodSet)==WholeFinFloodSet && p_pkt->fin_cnt >0)
				whole_fin_pkt+=p_pkt->fin_cnt;
			if(p_pkt->use ==1 && (item &  WholeUdpFloodSet)==WholeUdpFloodSet && p_pkt->udp_cnt >0)
				whole_udp_pkt+=p_pkt->udp_cnt;
			if(p_pkt->use ==1 && (item &  WholeIcmpFloodSet)==WholeIcmpFloodSet && p_pkt->icmp_cnt >0)
				whole_icmp_pkt+=p_pkt->icmp_cnt;
		}
	
		
		if(whole_syn_pkt > whole_syn_threshold && (item & WholeSynFloodSet)==WholeSynFloodSet && whole_syn_threshold > 0) 
			LogFlag |=WholeSynFloodSet;		
		if(whole_fin_pkt > whole_fin_threshold && (item & WholeFinFloodSet)==WholeFinFloodSet && whole_fin_threshold > 0)
			LogFlag |=WholeFinFloodSet;
		if(whole_udp_pkt > whole_udp_threshold && (item & WholeUdpFloodSet)==WholeUdpFloodSet && whole_udp_threshold > 0)
			LogFlag |=WholeUdpFloodSet;
		if(whole_icmp_pkt > whole_icmp_threshold && (item & WholeIcmpFloodSet)==WholeIcmpFloodSet && whole_icmp_threshold >0)
			LogFlag |=WholeIcmpFloodSet;
	}


}
static int dos_pkt_syn_flood(u_int32_t item,struct iphdr *iph,struct tcphdr *tcph)
{
        unsigned char *tflag;
        tflag=(void *) tcph + 13;
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	

	if(iph->protocol==IPPROTO_TCP && (*tflag & 0x3f)==TCP_SYN)
	{
	        if(block==1 && attack_saddr[PerSynFlood]==iph->saddr)	
			return FAILED;
      		(p_pkt->syn_cnt)++;
			
		if(p_pkt->syn_cnt > per_syn_threshold && (item & PerSynFloodSet)==PerSynFloodSet && per_syn_threshold > 0)
		{
		 	attack_saddr[PerSynFlood]=iph->saddr;
			attack_daddr[PerSynFlood]=iph->daddr;
			block=1;
			LogFlag |=PerSynFloodSet;
		}
	}
	return SUCCESS;

}

static int dos_pkt_fin_flood(u_int32_t item,struct iphdr *iph,struct tcphdr *tcph)
{
        unsigned char *tflag;
        tflag=(void *) tcph + 13;
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	
	if(iph->protocol==IPPROTO_TCP && (*tflag & 0x3f)==TCP_FIN )
	{
	        if(block==1 && attack_saddr[PerFinFlood]==iph->saddr)	
			return FAILED;
       		(p_pkt->fin_cnt)++;
		if(p_pkt->fin_cnt > per_fin_threshold && (item & PerFinFloodSet)==PerFinFloodSet && per_fin_threshold > 0)
		{
		 	attack_saddr[PerFinFlood]=iph->saddr;
			attack_daddr[PerFinFlood]=iph->daddr;
			block=1;
			LogFlag |=PerFinFloodSet;
		}
	}
	return SUCCESS;
}

static int dos_pkt_udp_flood(u_int32_t item,struct iphdr *iph)
{
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	
	if(iph->protocol==IPPROTO_UDP)
	{
	        if(block==1 && attack_saddr[PerUdpFlood]==iph->saddr)	
			return FAILED;
      		(p_pkt->udp_cnt)++;
		if(p_pkt->udp_cnt > per_udp_threshold && (item & PerUdpFloodSet)==PerUdpFloodSet && per_udp_threshold > 0)
		{
		 	attack_saddr[PerUdpFlood]=iph->saddr;
			attack_daddr[PerUdpFlood]=iph->daddr;
			block=1;
			LogFlag |=PerUdpFloodSet;
		}
	}
	return SUCCESS;
}

static int dos_pkt_icmp_flood(u_int32_t item,struct iphdr *iph)
{
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	
	if(iph->protocol==IPPROTO_ICMP)
	{
	        if(block==1 && attack_saddr[PerIcmpFlood]==iph->saddr)	
			return FAILED;
       		(p_pkt->icmp_cnt)++;
		if(p_pkt->icmp_cnt > per_icmp_threshold && (item & PerIcmpFloodSet)==PerIcmpFloodSet && per_icmp_threshold >0)
		{
		 	attack_saddr[PerIcmpFlood]=iph->saddr;
			attack_daddr[PerIcmpFlood]=iph->daddr;
			block=1;
			LogFlag |=PerIcmpFloodSet;
		}
	}
	return SUCCESS;
}

static int dos_pkt_locate(struct iphdr *iph)
{
	struct s_dos_pkt *p_pkt;
	int16_t idx=0;
        idx=iph->saddr % TableSize;	
	p_pkt=&dos_pkt[idx];
	if(iph->saddr == ConnectedIp[iph->saddr % HashSize] && p_pkt->ip==iph->saddr)
	{
		p_pkt->use=0;
		return 0;
	}
	if(p_pkt->ip!=iph->saddr && p_pkt->use ==0)
	{
		p_pkt->ip=iph->saddr;
		p_pkt->use=1;
 		cur_p_pkt=p_pkt;
		return 1;
	}
	else if(p_pkt->ip==iph->saddr && p_pkt->use ==1)
	{
 		cur_p_pkt=p_pkt;		
		return 1;
	}
	else
		return 0;
}

static int _IpSpoof(struct iphdr *iph)
{
	
	if((iph->saddr & lan_mask)==(lan_addr & lan_mask) && iph->protocol!=IPPROTO_ICMP)
	{
		LogFlag |=IpSpoofSet;
		attack_saddr[IpSpoof]=iph->saddr;
		attack_daddr[IpSpoof]=iph->daddr;
		return FAILED;
	}
	return SUCCESS;
}
		
static int _IcmpSmurf(struct iphdr *iph)
{
	struct icmphdr *icmph;
	icmph=(void *) iph + iph->ihl*4;
	if(iph->protocol==IPPROTO_ICMP && icmph->type == ICMP_ECHO)
	{	
		if((iph->saddr & lan_mask)==(lan_addr & lan_mask))
		{
	   	LogFlag |=IcmpSmurfSet;
		attack_saddr[IcmpSmurf]=iph->saddr;
		attack_daddr[IcmpSmurf]=iph->daddr;
		return FAILED;
		}
	}
	return SUCCESS;
		
}
static int _IpLand(struct iphdr *iph)
{
	if(iph->saddr==iph->daddr)
	{
        	LogFlag |=IpLandSet;
		attack_saddr[IpLand]=iph->saddr;
		attack_daddr[IpLand]=iph->daddr;
		return FAILED;
	}
	
	return SUCCESS;
		   
}
static int _UdpBomb(struct iphdr *iph, struct udphdr *udph)
{
	int ipPayLoadLength;

	if(iph->protocol==IPPROTO_UDP)
	{	
        	if (!(iph->frag_off & (IP_OFFSET|IP_MF)))
		{
	        	ipPayLoadLength = ntohs(iph->tot_len) - ((iph->ihl) << 2);
	       		if (ipPayLoadLength > ntohs(udph->len))
			{
	       	      		LogFlag |=UdpBombSet;
				attack_saddr[UdpBomb]=iph->saddr;
				attack_daddr[UdpBomb]=iph->daddr;
				return FAILED;
			}	
		}
	}
	return SUCCESS;
}

static int _TcpSynWithData(struct iphdr *iph,struct tcphdr *tcph)
{
        unsigned char *tflag;
        tflag=(void *) tcph + 13;
	if(iph->protocol==IPPROTO_TCP && (*tflag & 0x3f)== TCP_SYN)
	{
		unsigned long datalen= ntohs(iph->tot_len)-((iph->ihl)<<2)- (tcph->doff<<2);
		if(datalen>0)            
	       		{
	       	      	LogFlag |=TcpSynWithDataSet;
			attack_saddr[TcpSynWithData]=iph->saddr;
			attack_daddr[TcpSynWithData]=iph->daddr;
			return FAILED;
			}
		if(htons(iph->frag_off) & IP_MF)   
		     	{
	       	      	LogFlag |=TcpSynWithDataSet;
			attack_saddr[TcpSynWithData]=iph->saddr;
			attack_daddr[TcpSynWithData]=iph->daddr;
			return FAILED;
			}
				
											}
	return SUCCESS;
}

static int _PingOfDeath(struct iphdr *iph)
{
	unsigned short iph_off = ntohs(iph->frag_off);
	unsigned long  val;

        if((iph_off & IP_MF) == 0 && (iph_off & IP_OFFSET))
        {
        iph_off &= IP_OFFSET;
        val = (iph_off << 3) + ntohs(iph->tot_len) -((iph->ihl) << 2);
        if(val > 65535)
		{
	      	LogFlag |=PingOfDeathSet;
		attack_saddr[PingOfDeath]=iph->saddr;
		attack_daddr[PingOfDeath]=iph->daddr;
		return FAILED;
	      	}
        }
	return SUCCESS;
}
static int _UdpEchoChargen(struct iphdr *iph, struct udphdr *udph) 
{
	if(iph->protocol==IPPROTO_UDP)
	{
        	if((udph->dest==htons(7)||udph->dest==htons(17)||udph->dest==htons(19)) || (udph->source==htons(7)||udph->source==htons(17)||udph->source==htons(19)))
		{
			LogFlag |=UdpEchoChargenSet;
			attack_saddr[UdpEchoChargen]=iph->saddr;
			attack_daddr[UdpEchoChargen]=iph->daddr;
			return FAILED;
		}
	}
	return SUCCESS;
}
static int _TcpScan(struct iphdr *iph,struct tcphdr *tcph)
{
        unsigned char *tflag;
        tflag=(void *) tcph + 13;
	if(iph->protocol==IPPROTO_TCP)
	{	
		if(_tcpDosScanBitmap[*tflag & 0x3f])
		{
		LogFlag |=TcpScanSet;
		attack_saddr[TcpScan]=iph->saddr;
		attack_daddr[TcpScan]=iph->daddr;
		return FAILED;
		}
	}
	return SUCCESS;
}
static int _TearDrop(struct iphdr *iph)
{
	struct s_dos_pkt *p_pkt;
	if(dos_pkt_locate(iph))
         	p_pkt=cur_p_pkt;	
        else	
		return SUCCESS;
	if(ntohs(iph->id)!=p_pkt->id && ntohs(p_pkt->id) !=0)
		return SUCCESS;
	
	if((ntohs(iph->frag_off)) & (IP_MF | IP_OFFSET))
	{
        	if(((ntohs(iph->frag_off) & IP_OFFSET) << 3) >= p_pkt->offset)
			{
			if(!(ntohs(iph->frag_off) & IP_MF))
			        {
                        	p_pkt->id=0;
                        	p_pkt->offset=0;
				}
			else  
			    	{
				p_pkt->id=ntohs(iph->id);
				p_pkt->offset=p_pkt->offset + ntohs(iph->tot_len)-((iph->ihl) << 2);
				}
			}
		else  
			{			
	       	      	LogFlag |=TearDropSet;
			attack_saddr[TearDrop]=iph->saddr;
			attack_daddr[TearDrop]=iph->daddr;
			return FAILED;
			}
			
	}
	return SUCCESS;
}
static int _TcpUdpPortScan(struct iphdr *iph, struct tcphdr *tcph,struct udphdr *udph) 
{
	struct s_dos_pkt *p_pkt;
        p_pkt=cur_p_pkt;	
	
	if(iph->protocol==IPPROTO_TCP)
	{
		
		if(p_pkt->dest != 0 && p_pkt->dest!=tcph->dest)  
			(p_pkt->scan_cnt)++;
		if(p_pkt->dest == 0)  
			p_pkt->dest=tcph->dest;
	}
	if(iph->protocol==IPPROTO_UDP)
	{
		if(p_pkt->dest != 0 && p_pkt->dest!=udph->dest)  
			(p_pkt->scan_cnt)++;
		if(p_pkt->dest == 0)  
			p_pkt->dest=udph->dest;
	}
	       
	if((item & SensitivitySet)==SensitivitySet && p_pkt->scan_cnt > HighSensitivity)
	{
	       	LogFlag |=TcpUdpPortScanSet;
		attack_saddr[TcpUdpPortScan]=iph->saddr;
		attack_daddr[TcpUdpPortScan]=iph->daddr;
	}
	if((item & SensitivitySet)!=SensitivitySet && p_pkt->scan_cnt > LowSensitivity)
	{
	       	LogFlag |=TcpUdpPortScanSet;
		attack_saddr[TcpUdpPortScan]=iph->saddr;
		attack_daddr[TcpUdpPortScan]=iph->daddr;
	}
	  
	return SUCCESS;
}
static void ShowLog(u_int32_t flag)
{
	if(flag & WholeSynFloodSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;note:Rule:Default deny;\n");
	}
#else
	{
	  	scrlog_printk("DoS: Whole System SYN Flood Attack\n");
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif

	if(flag & WholeFinFloodSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;note:Rule:Default deny;\n");
	}
#else
	{
		scrlog_printk("DoS: Whole System FIN Flood Attack\n");
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif

	if(flag & WholeUdpFloodSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;note:Rule:Default deny;\n");
	}
#else	
	{
		scrlog_printk("DoS: Whole System UDP Flood Attack\n");
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif

	if(flag & WholeIcmpFloodSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;note:Rule:Default deny;\n");
	}
#else
	{
	scrlog_printk("DoS: Whole System ICMP Flood Attack\n");
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif
		
	if(flag & PerSynFloodSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PerSynFlood]),NIPQUAD(attack_daddr[PerSynFlood]));
		scrlog_printk("DoSATTACKlog_num:13;msg: Per-source SYN Flood Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PerSynFlood]),  NIPQUAD(attack_daddr[PerSynFlood]));
	}
#else	
	{
		scrlog_printk("DoS: Per-source SYN Flood Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PerSynFlood]),NIPQUAD(attack_daddr[PerSynFlood]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif

	if(flag & PerFinFloodSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PerFinFlood]),NIPQUAD(attack_daddr[PerFinFlood]));
		scrlog_printk("DoSATTACKlog_num:13;msg: Per-source FIN Flood Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PerFinFlood]),  NIPQUAD(attack_daddr[PerFinFlood]));
		
	}
#else	
	{
		scrlog_printk("DoS: Per-source FIN Flood Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PerFinFlood]),NIPQUAD(attack_daddr[PerFinFlood]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif

	if(flag & PerUdpFloodSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PerUdpFlood]),NIPQUAD(attack_daddr[PerUdpFlood]));
		scrlog_printk("DoSATTACKlog_num:13;msg: Per-source UDP Flood Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PerUdpFlood]),  NIPQUAD(attack_daddr[PerUdpFlood]));
	}
#else
	{
		scrlog_printk("DoS: Per-source UDP Flood Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PerUdpFlood]),NIPQUAD(attack_daddr[PerUdpFlood]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif

	if(flag & PerIcmpFloodSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PerIcmpFlood]),NIPQUAD(attack_daddr[PerIcmpFlood]));
		scrlog_printk("DoSATTACKlog_num:13;msg: Per-source ICMP Flood Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PerIcmpFlood]),  NIPQUAD(attack_daddr[PerIcmpFlood]));
	}
#else
	{
		scrlog_printk("DoS: Per-source ICMP Flood Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PerIcmpFlood]),NIPQUAD(attack_daddr[PerIcmpFlood]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif		
	}
#endif	

	if(flag & TcpUdpPortScanSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[TcpUdpPortScan]),NIPQUAD(attack_daddr[TcpUdpPortScan]));
		scrlog_printk("DoSATTACKlog_num:13;msg: Port Scan Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[TcpUdpPortScan]),  NIPQUAD(attack_daddr[TcpUdpPortScan]));
		
	}
#else
	{
		scrlog_printk("DoS: Port Scan Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[TcpUdpPortScan]),NIPQUAD(attack_daddr[TcpUdpPortScan]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif	
	}
#endif

	if(flag & TcpScanSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[TcpScan]),NIPQUAD(attack_daddr[TcpScan]));
		scrlog_printk("DoSATTACKlog_num:13;msg:Tcp Scan Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[TcpScan]),  NIPQUAD(attack_daddr[TcpScan]));
	}
#else
	{
	scrlog_printk("DoS: Tcp Scan Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[TcpScan]),NIPQUAD(attack_daddr[TcpScan]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif	
		
	if(flag & TcpSynWithDataSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[TcpSynWithData]),NIPQUAD(attack_daddr[TcpSynWithData]));
		scrlog_printk("DoSATTACKlog_num:13;msg:Tcp SYN With Data Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[TcpSynWithData]),  NIPQUAD(attack_daddr[TcpSynWithData]));
	}
#else
	{
		scrlog_printk("DoS: Tcp SYN With Data Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[TcpSynWithData]),NIPQUAD(attack_daddr[TcpSynWithData]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif

	if(flag & IpLandSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[IpLand]),NIPQUAD(attack_daddr[IpLand]));
		scrlog_printk("DoSATTACKlog_num:13;msg:IpLand Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[IpLand]),  NIPQUAD(attack_daddr[IpLand]));
	}
#else	
	{
		scrlog_printk("DoS: IP Land Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[IpLand]),NIPQUAD(attack_daddr[IpLand]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif		
	}
#endif

	if(flag & UdpEchoChargenSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[UdpEchoChargen]),NIPQUAD(attack_daddr[UdpEchoChargen]));
		scrlog_printk("DoSATTACKlog_num:13;msg:UdpEchoChargen Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[UdpEchoChargen]),  NIPQUAD(attack_daddr[UdpEchoChargen]));
	}
#else
	{
		scrlog_printk("DoS: UdpEchoChargen Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[UdpEchoChargen]),NIPQUAD(attack_daddr[UdpEchoChargen]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif

	if(flag & UdpBombSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[UdpBomb]),NIPQUAD(attack_daddr[UdpBomb]));
		scrlog_printk("DoSATTACKlog_num:13;msg:UdpBomb Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[UdpBomb]),  NIPQUAD(attack_daddr[UdpBomb]));
	}
#else
	{
	scrlog_printk("DoS: UdpBomb Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[UdpBomb]),NIPQUAD(attack_daddr[UdpBomb]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif	
		
	if(flag & PingOfDeathSet)
#ifdef CONFIG_RTL8186_TR
	{
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[PingOfDeath]),NIPQUAD(attack_daddr[PingOfDeath]));
		scrlog_printk("DoSATTACKlog_num:13;msg:PingOfDeath Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[PingOfDeath]),  NIPQUAD(attack_daddr[PingOfDeath]));
	
	}
#else
	{
	scrlog_printk("DoS: PingOfDeath Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[PingOfDeath]),NIPQUAD(attack_daddr[PingOfDeath]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif	
		
	if(flag & IcmpSmurfSet)
#ifdef CONFIG_RTL8186_TR
	{  
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[IcmpSmurf]),NIPQUAD(attack_daddr[IcmpSmurf]));
		scrlog_printk("DoSATTACKlog_num:13;msg:IcmpSmurf Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[IcmpSmurf]),  NIPQUAD(attack_daddr[IcmpSmurf]));
	}	
#else	
	{
		scrlog_printk("DoS: IcmpSmurf Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[IcmpSmurf]),NIPQUAD(attack_daddr[IcmpSmurf]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif

	if(flag & IpSpoofSet)
#ifdef  CONFIG_RTL8186_TR
	{  
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[IpSpoof]),NIPQUAD(attack_daddr[IpSpoof]));
		scrlog_printk("DoSATTACKlog_num:13;msg:IpSpoof Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[IpSpoof]),  NIPQUAD(attack_daddr[IpSpoof]));
	}
#else
	{
	scrlog_printk("DoS: IpSpoof Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[IpSpoof]),NIPQUAD(attack_daddr[IpSpoof]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif	
		
	if(flag & TearDropSet)
#ifdef  CONFIG_RTL8186_TR
	{  
		scrlog_printk("DoSDROPlog_num:13;msg:Drop packet from WAN;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Rule:Default deny;\n", NIPQUAD(attack_saddr[TearDrop]),  NIPQUAD(attack_daddr[TearDrop]));
		scrlog_printk("DoSATTACKlog_num:13;msg:TearDrop Attack Detect;src:%u.%u.%u.%u;dst:%u.%u.%u.%u;note:Packet Dropped;\n", NIPQUAD(attack_saddr[TearDrop]),  NIPQUAD(attack_daddr[TearDrop]));
	}
#else
	{
		scrlog_printk("DoS: TearDrop Attack source=%u.%u.%u.%u destination=%u.%u.%u.%u\n", NIPQUAD(attack_saddr[TearDrop]),NIPQUAD(attack_daddr[TearDrop]));
#ifdef DOS_LOG_SENDMAIL
		dosLogCount++;
#endif
	}
#endif	 	
		
        LogFlag=0;	
}

static void dos_timer_fn(unsigned long arg)
{	
        if (item) {       
		if(block_count >=block_time) {		
			block=0;
			block_count=0;
		}
		if(block == 1)
			block_count++;
				
 		dos_whole_flood();
		ShowLog(LogFlag);
        	dos_pkt_init();

	}
		
// david --------------------------------------
	if (none_dos_drop_pkt_cnt > NONE_DOS_PKT_THRES) {
		if (item) {		
			item_backup = item;
			item = 0;
			//printk("disable DoS\n");			
		}
	}	
	else {		
		if (item_backup) {
			item = item_backup;
			item_backup = 0;
			//printk("enable DoS\n");						
		}
	}
	if (none_dos_drop_pkt_cnt > 0)
		none_dos_drop_pkt_cnt=0;
//-------------------------------------------
	
      	mod_timer(&dos_timer, jiffies + 100);
}

static int  filter_dos(struct sk_buff *skb)
{
	struct iphdr *iph;
        struct tcphdr *tcph;	
	struct udphdr *udph;
	int ret=0;
	iph=ip_hdr(skb);
	tcph=(void *) iph + iph->ihl*4;
	udph=(void *) iph + iph->ihl*4;

// david		  
      	wan_ppp_dev=__dev_get_by_name(&init_net,"ppp0"); //brad modify
     	wan_dev=__dev_get_by_name(&init_net,"eth1");		  //brad modify     		     
	if(skb->dev && (skb->dev == wan_dev || skb->dev == wan_ppp_dev)) //brad modify
	//if (skb->dev && !memcmp(skb->dev->name, "eth1", 4))	
	{
		if(item & (WholeSynFloodSet | WholeFinFloodSet | WholeUdpFloodSet  | WholeIcmpFloodSet | PerSynFloodSet | PerFinFloodSet | PerUdpFloodSet | PerIcmpFloodSet | TcpUdpPortScanSet))
                {	              
			if(dos_pkt_locate(iph))
		  	{
		  	if(item & (WholeSynFloodSet | PerSynFloodSet)) 
				ret|=dos_pkt_syn_flood(item,iph,tcph);		  	
		  	if(item & (WholeFinFloodSet | PerFinFloodSet))
				ret|=dos_pkt_fin_flood(item,iph,tcph);
		  	if(item & (WholeUdpFloodSet | PerUdpFloodSet))
				ret|=dos_pkt_udp_flood(item,iph);
		  	if(item & (WholeIcmpFloodSet | PerIcmpFloodSet))
				ret|=dos_pkt_icmp_flood(item,iph);
		  	if(item & TcpUdpPortScanSet)
				ret|=_TcpUdpPortScan(iph,tcph,udph); 
			if(!(item & IpBlockSet))
				ret=SUCCESS; 
		  	}
		}  		
		if(item & TcpScanSet)
			ret|=_TcpScan(iph,tcph);		
		if(item & TcpSynWithDataSet)
			ret|=_TcpSynWithData(iph,tcph);		
		if(item & IpLandSet)
			ret|=_IpLand(iph);		
		if(item & UdpEchoChargenSet)
			ret|=_UdpEchoChargen(iph, udph); 		
		if(item & UdpBombSet)
	        	ret|=_UdpBomb(iph, udph);	        
		if(item & PingOfDeathSet)
			ret|=_PingOfDeath(iph);		
		if(item & IcmpSmurfSet)
	 		ret|=_IcmpSmurf(iph);	 	
		if(item & IpSpoofSet)
      			ret|=_IpSpoof(iph);       		
		if(item & TearDropSet)
			ret|=_TearDrop(iph);		
	}
	if(ret)
	  return FAILED;
	else  	  
	  return SUCCESS;
}

static int dos_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{

      int len;

      len = sprintf(page, "%s\n", dos_flag);


      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}

#ifndef __HAVE_ARCH_STRTOK
char * ___strtok;
/**
 * strtok - Split a string into tokens
 * @s: The string to be searched
 * @ct: The characters to search for
 *
 * WARNING: strtok is deprecated, use strsep instead.
 */
char * strtok(char * s,const char * ct)
{
	char *sbegin, *send;

	sbegin  = s ? s : ___strtok;
	if (!sbegin) {
		return NULL;
	}
	sbegin += strspn(sbegin,ct);
	if (*sbegin == '\0') {
		___strtok = NULL;
		return( NULL );
	}
	send = strpbrk( sbegin, ct);
	if (send && *send != '\0')
		*send++ = '\0';
	___strtok = send;
	return (sbegin);
}
#endif


static int dos_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      char tmpbuf[80];
      char *tokptr, *strptr=tmpbuf; 
      u_int8_t idx=1;
      u_int32_t val;
      
      if (count < 2) 
	    return -EFAULT;
      
      if (buffer && !copy_from_user(&dos_flag, buffer, 80)) {
	      strncpy(tmpbuf,dos_flag,80);
	      
	      while ((tokptr = strtok(strptr," ")) !=NULL)
	      {
              	strptr=NULL;
              	val=simple_strtol(tokptr,NULL,0);
		switch(idx)
		  {	
                  case 1: 
			op_mode=val;
			break;
                  case 2:
              	        val=simple_strtol(tokptr,NULL,16);
			lan_addr=val;
			break;
                  case 3: 
              	        val=simple_strtol(tokptr,NULL,16);
			lan_mask=val;
			break;
			
                  case 4: 
			item=val;
			item_backup = 0; // david			
			break;
	          case 5:
		        whole_syn_threshold=val;				
			break;
	          case 6:
		        whole_fin_threshold=val;
			break;
	          case 7:
		        whole_udp_threshold=val;
			break;
	          case 8:
		        whole_icmp_threshold=val;
			break;
	          case 9:
		        per_syn_threshold=val;
			break;
	          case 10:
		        per_fin_threshold=val;
			break;
	          case 11:
		        per_udp_threshold=val;
			break;
	          case 12:
		        per_icmp_threshold=val;
			break;
	          case 13:
		        block_time=val;
			break;
		  default:
			break;	
		  }
	          idx++;
			
              }	      
	    return count;
      }
      return -EFAULT;
}
#endif

#ifdef DOS_FILTER
void filter_addconnect(__u32 ipaddr)
{
//	if (item & EnableDosSet) 
		 ConnectedIp[((__u32)ipaddr) % HashSize]=(__u32)ipaddr;
}

void filter_delconnect(__u32 ipaddr)
{
//	if (item & EnableDosSet) 
		 ConnectedIp[((__u32)ipaddr) % HashSize]=0;
}
#endif

#if defined(CUSTOM_RSP_PACKET) 	    

int (*fast_path_cusRsp401_func)(struct sk_buff *pskb) = NULL;
int (*fast_path_cusRspTCPFinAck_func)(struct sk_buff *pskb) = NULL;
int (*fast_path_cusRspTCPEndAck_func)(struct sk_buff *pskb) = NULL;

void register_customRspStr(char *_str)
{
	unregister_customRspStr();
	if(_str)
	{
		block_message=kmalloc(strlen(_str),GFP_KERNEL);
		if(block_message)
			sprintf(block_message,"%s",_str);			
	}
	else
	{
		block_message=kmalloc(strlen(URL_FILTER_BLOCK_PAGE_MESSAGE),GFP_KERNEL);
		if(block_message)
			sprintf(block_message,"%s",URL_FILTER_BLOCK_PAGE_MESSAGE);
	}
	return;
};

void unregister_customRspStr()
{
	if(block_message)
	{
		kfree(block_message);
		block_message=NULL;
	}
	return;
}

void register_customRspHook(int *_cusRsp401_func,int *_cusRspTCPFinAck_func,int *_cusRspTCPEndAck_func)
{	
	if(_cusRsp401_func)
		fast_path_cusRsp401_func=_cusRsp401_func;
	else
		fast_path_cusRsp401_func=GenerateHTTP401;

	if(_cusRspTCPFinAck_func)
		fast_path_cusRspTCPFinAck_func=_cusRspTCPFinAck_func;
	else
		fast_path_cusRspTCPFinAck_func=GenerateTCPFINACK;
	
	if(_cusRspTCPEndAck_func)
		fast_path_cusRspTCPEndAck_func=_cusRspTCPEndAck_func;
	else
		fast_path_cusRspTCPEndAck_func=GenerateTCPENDACK;
	return;
}

void unregister_customRspHook()
{	
	fast_path_cusRsp401_func=NULL;
	fast_path_cusRspTCPFinAck_func=NULL;
	fast_path_cusRspTCPEndAck_func=NULL;
	return;
}
#endif /*CUSTOM_RSP_PACKET*/

/*David, 20100818*/
#if defined (DOS_FILTER) || defined (URL_FILTER) 		  
int filter_enter(struct sk_buff *skb)
{
//	struct iphdr* iph;

#if (defined(CONFIG_RTL8186_GR) || defined(CONFIG_RTL8186_KB))
	//Added for multiple pppoe
	//To mark this pkt: 0x2, if in domain_name_tbl or others_tbl
	mark_pkt_for_session2(skb);
#endif
#ifdef DOS_FILTER
	if (!item 
#ifdef URL_FILTER
#if defined MAC_BASED_URL_FILTER
		&& !(mac_list_count|url_count)
#elif defined(CONFIG_BASEON_SCHEDULE_FILTER)
		&& !(sch_list_count )
#elif defined(FASTPATH_FILTER) 			
		&& 0		
#else
		&& !url_count
#endif
#endif
		) {
		none_dos_drop_pkt_cnt++;
	      return NF_ACCEPT;
	}
#endif

      if (skb->pkt_type != PACKET_HOST ) return NF_REPEAT;
      if (skb->protocol != htons(ETH_P_IP) ) return NF_REPEAT;  

#ifdef URL_FILTER
#if defined(FASTPATH_FILTER) 
	if (table_list_head.num > 1)
#elif defined MAC_BASED_URL_FILTER
	if (mac_list_count|url_count)
#elif defined(CONFIG_BASEON_SCHEDULE_FILTER) 
	if (sch_list_count)		
#else
      if(url_count)
#endif
      {
	        if(FilterWeb(skb)){
				
#if defined(CUSTOM_RSP_PACKET) 
			if(fast_path_cusRsp401_func)
				fast_path_cusRsp401_func(skb);
#endif	       
		      	return NF_DROP;
		    }	
#if defined(CUSTOM_RSP_PACKET) 	    
		    else if(fast_path_cusRsp401_func)
		   {
		     if(url_cache.isSent401==1){
				if(fast_path_cusRspTCPFinAck_func)			 	
					fast_path_cusRspTCPFinAck_func(skb);
				return NF_DROP;
			}else{
				if(url_cache.isSentFinAck==1){
					if(fast_path_cusRspTCPEndAck_func)
		 				fast_path_cusRspTCPEndAck_func(skb);
	      				return NF_DROP;
		 		}
		 	}
		    }
#endif	
	//printk("%s------->%d\n",__FUNCTION__,__LINE__);
	#ifdef DNS_QUERY_FILTER_FOR_HTTPS_URL_FILTER
                if (url_count && (((struct iphdr *)((void *) skb->nh.iph))->protocol == IPPROTO_UDP)) {
                        if(FilterDnsQuery(skb)){
				    //printk("%s------->%d\n",__FUNCTION__,__LINE__);
                                return NF_DROP;
                        }
                }
        #endif
      }		
	    	
#endif      

#ifdef DOS_FILTER
      if (item & EnableDosSet) {     
	      	if (filter_dos(skb))  
			return NF_DROP;		
      } 	
#endif         	     

      if (ip_hdr(skb)->protocol == IPPROTO_ICMP ) return NF_REPEAT;
      // here may add the ip_MISMATCH check

#if defined(CONFIG_UDP_FRAG_CACHE)
	//hyking:fast path for fragment is ready...
	
#else
	if (ip_hdr(skb)->frag_off & htons(IP_MF|IP_OFFSET)) return NF_REPEAT;
#endif

#if 0
	if (skb->nh.iph->frag_off & htons(IP_MF|IP_OFFSET)) {
		skb = ip_ct_gather_frags(skb);
		if (skb == NULL)
			return NF_STOLEN;		
		*pskb = skb;			
		return NF_ACCEPT;
    	}
#endif		

// david
#if 0
      // ipsec pass through
      if ((skb->nh.iph->protocol == 50 || skb->nh.iph->protocol == 51)) return NF_REPEAT;
      // here may add the dst mtu check

      // check ip headers now -------------------------------------------
      if ((skb = skb_share_check(skb, GFP_ATOMIC)) == NULL)
	    goto out;

      if (!pskb_may_pull(skb, sizeof(struct iphdr)))
	    goto inhdr_error;
      iph = skb->nh.iph;
      if (iph->ihl < 5 || iph->version != 4)
	    goto inhdr_error; 
      if (!pskb_may_pull(skb, iph->ihl*4))
	    goto inhdr_error;
      iph = skb->nh.iph;

      // we move the ip_rcv_finish check at here
      // we don't want to play with ip option
      if (iph->ihl > 5) 
	    return NF_REPEAT;
      // we move the ip_forward check at here
      if (iph->ttl<=1)
	    return NF_REPEAT;
      if (skb->ip_summed == CHECKSUM_NONE)
	    if (ip_fast_csum((u8 *)iph, iph->ihl) != 0)
		  goto inhdr_error;
      {
	    __u32 len = ntohs(iph->tot_len); 
	    if (skb->len < len || len < (iph->ihl<<2))
		  goto inhdr_error;
	      
	    /* Our transport medium may have padded the buffer out. Now we know it
	     * is IP we can trim to the true length of the frame.
	     * Note this now means skb->len holds ntohs(iph->tot_len).
	     */
	    if (skb->len > len) {
		  __pskb_trim(skb, len);
		  if (skb->ip_summed == CHECKSUM_HW)
			skb->ip_summed = CHECKSUM_NONE;
	    }
      }
      if (skb_is_nonlinear(skb) && skb_linearize(skb, GFP_ATOMIC) != 0) {
	    printk("Skb is nonlinear!\n");
	    return NF_DROP;
      }
#endif

#ifdef DOS_FILTER
	none_dos_drop_pkt_cnt++;	  
#endif         	     

      return NF_ACCEPT;
// inhdr_error:
//      IP_INC_STATS_BH(IpInHdrErrors);
// out:
//      return NF_DROP;
}

#if 0
static int read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{

      int len;

      len = sprintf(page, "%c\n", flag);

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}
static int write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{      
      if (count < 2) 
	    return -EFAULT;
      
      if (buffer && !copy_from_user(&flag, buffer, 1))       	
	    return count;     
      return -EFAULT;
}
#endif


#if defined(CONFIG_PROC_FS)

#ifdef URL_CONTENT_AUTHENTICATION
static struct proc_dir_entry *res0=NULL;
#endif
#ifdef MAC_BASED_URL_FILTER
static struct proc_dir_entry *res1=NULL;
#endif

#ifdef URL_FILTER
static struct proc_dir_entry *res2=NULL;
#endif

#ifdef DOS_FILTER
static struct proc_dir_entry *res3=NULL;
#endif

#if defined(CONFIG_BASEON_SCHEDULE_FILTER) 
static struct proc_dir_entry *res4=NULL;
#endif

#if (defined(CONFIG_RTL8186_GR) || defined(CONFIG_RTL8186_KB))
//domain name filter for pppoe session2
//for domain name filter
static struct proc_dir_entry *res5=NULL;


#ifdef OTHERS_FILTER
//for ip, network, port and protocol filter
static struct proc_dir_entry *res6=NULL;
#endif
#endif

#endif

#ifdef DOS_LOG_SENDMAIL
static struct proc_dir_entry *res7=NULL;
#endif
int __init filter_init(void)
{
#if defined(CONFIG_PROC_FS)
#ifdef URL_CONTENT_AUTHENTICATION
	res0 = create_proc_entry("auth_url_content",0,NULL);
	if(res0)
	{
		res0->read_proc = auth_url_content_read_proc;
		res0->write_proc = auth_url_content_write_proc;
	}
#endif

#ifdef MAC_BASED_URL_FILTER
	res1 = create_proc_entry("mac_url_filter", 0, NULL);
	if(res1)
	{
		res1->read_proc = mac_url_read_proc;
		res1->write_proc = mac_url_write_proc;
	}
#endif

#ifdef URL_FILTER       
	res2 = create_proc_entry("url_filter", 0, NULL);
#ifdef CONFIG_RTL8186_GR
#ifdef CONFIG_RTL_LAYERED_DRIVER
       Add_Pattern_ACL_For_ContentFilter();
#endif
#endif
	if (res2) {
	    res2->read_proc = url_read_proc;
	    res2->write_proc = url_write_proc;
      }
#endif
      
#ifdef DOS_FILTER      
      res3 = create_proc_entry("enable_dos", 0, NULL);
      if (res3) {
	    res3->read_proc = dos_read_proc;
	    res3->write_proc = dos_write_proc;
      }      
      init_timer(&dos_timer);
      dos_timer.expires  = jiffies + 100;
      dos_timer.data     = 0L;
      dos_timer.function = dos_timer_fn;
      mod_timer(&dos_timer, jiffies + 100);
      
      memset(&_tcpDosScanBitmap[0], 0, sizeof(_tcpDosScanBitmap));
      _tcpDosScanBitmap[0]=_tcpDosScanBitmap[3]=_tcpDosScanBitmap[8]=_tcpDosScanBitmap[9]= _tcpDosScanBitmap[32]=_tcpDosScanBitmap[33]=_tcpDosScanBitmap[40]=_tcpDosScanBitmap[41]= _tcpDosScanBitmap[58]=_tcpDosScanBitmap[63]=1;
#endif

#if defined(CONFIG_BASEON_SCHEDULE_FILTER) 
	res4 = create_proc_entry("sch_url_filter", 0, NULL);
	if(res4)
	{
		res4->read_proc = sch_url_read_proc;
		res4->write_proc = sch_url_write_proc;
	}
#endif

#if (defined(CONFIG_RTL8186_GR) || defined(CONFIG_RTL8186_KB))
	res5 = create_proc_entry("mpppoe_domainname_filter", 0, NULL);
	if(res5)
	{
		res5->read_proc = mpppoe_domainname_read_proc;
		res5->write_proc = mpppoe_domainname_write_proc;
	}

#ifdef OTHERS_FILTER
	res6 = create_proc_entry("mpppoe_others_filter", 0, NULL);
	if(res6)
	{
		res6->read_proc = mpppoe_others_read_proc;
		res6->write_proc = mpppoe_others_write_proc;
	}
#endif
#endif

#ifdef DOS_LOG_SENDMAIL
	//initial
	dosLogCount=0;
	
	res7 = create_proc_entry("dos_log_count", 0, NULL);
	if(res7)
	{
		res7->read_proc = dos_log_count_read_proc;
		res7->write_proc = dos_log_count_write_proc;
	}
#endif
#ifdef FASTPATH_FILTER
	filter_init_fastpath();
#endif
#endif // CONFIG_PROC_FS
	return 0;
}

void __exit filter_exit(void)
{
#if defined(CONFIG_PROC_FS)
#if 0
	if (res1) {
		remove_proc_entry("fast_nat", res1);		
		res1 = NULL;
	}
#endif	
#ifdef URL_FILTER		
	if (res2) {
		remove_proc_entry("url_filter", res2);				
		res2 = NULL;
	}
#endif		
#ifdef DOS_FILTER 
	if (res3) {
		remove_proc_entry("enable_dos", res3);	
		res3 = NULL;
	}
	del_timer_sync(&dos_timer);		
#endif		
#if defined(CONFIG_BASEON_SCHEDULE_FILTER) 
	if (res4) {
		remove_proc_entry("sch_url_filter", res4);				
		res4 = NULL;
	}
#endif	
#if (defined(CONFIG_RTL8186_GR) || defined(CONFIG_RTL8186_KB))
	if (res5) {
		remove_proc_entry("mpppoe_domainname_filter", res5);				
		res5 = NULL;
	}
#ifdef OTHERS_FILTER
	if (res6) {
		remove_proc_entry("mpppoe_others_filter", res6);				
		res6 = NULL;
	}
#endif
#endif

#ifdef FASTPATH_FILTER
	filter_exit_fastpath();
#endif

#ifdef DOS_LOG_SENDMAIL
	if (res7) {
		remove_proc_entry("dos_log_count", res7);				
		res7 = NULL;
	}
#endif
#endif // CONFIG_PROC_FS
}
#endif
#if 0
#ifdef CONFIG_FAST_PATH_MODULE
EXPORT_SYMBOL(filter_exit);
EXPORT_SYMBOL(filter_init);
EXPORT_SYMBOL(filter_enter);
EXPORT_SYMBOL(filter_delconnect);
EXPORT_SYMBOL(filter_addconnect);
#endif
#endif
