/*
Linux Kernel Hacking:
	net/core/neighbour.c						// ARP
	net/ipv4/fib_hash.c						// ROUTE
	net/ipv4/netfilter/ip_conntrack_core.c				// NAPT (PATH*2)
	net/ipv4/netfilter/ip_nat_core.c				// NAPT (PATH*2)
	net/ipv4/ip_input.c						// FastPath_Enter()
	net/ipv4/ip_output.c						// FastPath_Track()
*/
/*skb->h.raw = skb->nh.raw = skb->data*/

#ifndef __KERNEL__
#define	__KERNEL__
#endif

#if defined(CONFIG_NET_SCHED)
#include <linux/netfilter_ipv4/ip_tables.h>
extern int gQosEnabled;
#endif

#include <net/netfilter/nf_conntrack.h>
#include <net/rtl/rtl_types.h>
#include <net/rtl/rtl_queue.h>
#include <net/rtl/fastpath/fastpath_core.h>
#include <net/route.h>
#include <linux/inetdevice.h>
#if defined(PATH_CHAIN_HLIST) || defined(NAPT_CHAIN_HLIST)
#include <linux/list.h>
#endif

#ifdef CONFIG_FAST_PATH_MODULE
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#endif
#ifdef	MODULE_VERSION
#undef	MODULE_VERSION
#endif
#define	MODULE_NAME		"Realtek FastPath"
#define	MODULE_VERSION	"v1.02"

#if defined (FAST_PPTP) || defined(FAST_L2TP)
	#include <net/ip.h> 
#endif
#if 0//#ifdef FAST_L2TP
	#include <linux/inetdevice.h>
#endif
/*when udp checksum 0 ingore it*/
#define UDP_ZERO_CHECKSUM

static int fast_nat_fw = 1;
//Brad disable 
#if 0
static void flush_all_table(void);
#endif 

#if defined(IMPROVE_QOS)
#if defined(CONFIG_NET_SCHED)
#include <net/sch_generic.h>
#include <net/pkt_sched.h>
#endif
#endif
#ifdef CONFIG_BRIDGE
#include <bridge/br_private.h>
#endif

//#if defined(IMPROVE_QOS) && defined(CONFIG_NET_SCHED)
//#include <net/arp.h>
//#endif

#if defined(IMPROVE_QOS)
#include <net/arp.h>
#include <net/rtl/rtl_nic.h>

/*David, 20100818*/
#ifdef CONFIG_HAS_FASTPATH_DOS_FILTER
#else
    #undef DOS_FILTER
#endif

//To query hardware address based on IP through arp table of dev
int arp_req_get_ha(__be32 queryIP, struct net_device *dev, unsigned char * resHwAddr)
{
	__be32 ip = queryIP;
	struct neighbour *neigh;
	int err = -ENXIO;

	neigh = neigh_lookup(&arp_tbl, &ip, dev);
	if (neigh) {
		read_lock_bh(&neigh->lock);
		memcpy(resHwAddr, neigh->ha, dev->addr_len);
		read_unlock_bh(&neigh->lock);
		neigh_release(neigh);
		err = 0;
	}
	//else
	//{
	//	resHwAddr=NULL;
	//}
	
	return err;
}

//EXPORT_SYMBOL(arp_req_get_ha);
#endif

/* =========================
=========================================================================== */
//static uint8 fastpath_forward_flag = 1;		/* default: On */

#ifndef NO_ARP_USED
/* --- ARP Table Structures --- */
struct Arp_List_Entry
{
	uint8 vaild;
	ipaddr_t ip;
	ether_addr_t mac;
	enum ARP_FLAGS flags;
	CTAILQ_ENTRY(Arp_List_Entry) arp_link;
	CTAILQ_ENTRY(Arp_List_Entry) tqe_link;
};

struct Arp_Table
{
	CTAILQ_HEAD(Arp_list_entry_head, Arp_List_Entry) list[ARP_TABLE_LIST_MAX];
};

CTAILQ_HEAD(Arp_list_inuse_head, Arp_List_Entry) arp_list_inuse;
CTAILQ_HEAD(Arp_list_free_head, Arp_List_Entry) arp_list_free;

#ifdef CONFIG_FAST_PATH_MODULE
static struct Arp_Table *table_arp=NULL;
#else
struct Arp_Table *table_arp;
#endif

#endif

/* --- Route Table Structures --- */
struct Route_List_Entry
{
	uint8 vaild;
	ipaddr_t ip;
	ipaddr_t mask;
	ipaddr_t gateway;
	uint8 ifname[IFNAME_LEN_MAX];
	enum RT_FLAGS flags;
	CTAILQ_ENTRY(Route_List_Entry) route_link;
	CTAILQ_ENTRY(Route_List_Entry) tqe_link;
};

struct Route_Table
{
	//ROUTE_TABLE_LIST_MAX == 16
	CTAILQ_HEAD(Route_list_entry_head, Route_List_Entry) list[ROUTE_TABLE_LIST_MAX];
};


CTAILQ_HEAD(Route_list_inuse_head, Route_List_Entry) route_list_inuse;
CTAILQ_HEAD(Route_list_free_head, Route_List_Entry) route_list_free;

#ifndef DEL_ROUTE_TBL
#ifdef CONFIG_FAST_PATH_MODULE
static struct Route_Table *table_route=NULL;
#else
struct Route_Table *table_route;
#endif
#endif

#ifndef DEL_NAPT_TBL
/* --- NAPT Table Structures --- */
struct Napt_List_Entry
{
#if defined(NAPT_CHAIN_HLIST)
	struct hlist_node napt_link;
#endif
	uint8 vaild;
	enum NP_PROTOCOL protocol;
	ipaddr_t	intIp;
	uint32		intPort;
	ipaddr_t	extIp;
	uint32		extPort;
	ipaddr_t	remIp;
	uint32		remPort;
	enum NP_FLAGS 	flags;
#if !defined(NAPT_CHAIN_HLIST)
	CTAILQ_ENTRY(Napt_List_Entry) napt_link;
	CTAILQ_ENTRY(Napt_List_Entry) tqe_link;
#endif
};

#if !defined(NAPT_CHAIN_HLIST)
struct Napt_Table
{
	CTAILQ_HEAD(Napt_list_entry_head, Napt_List_Entry) list[NAPT_TABLE_LIST_MAX];
};

CTAILQ_HEAD(Napt_list_inuse_head, Napt_List_Entry) napt_list_inuse;
CTAILQ_HEAD(Napt_list_free_head, Napt_List_Entry) napt_list_free;

#ifdef CONFIG_FAST_PATH_MODULE
static struct Napt_Table *table_napt=NULL;
#else
struct Napt_Table *table_napt;
#endif
#else /* !NAPT_CHAIN_HLIST */
static struct hlist_head *table_napt;
static HLIST_HEAD(napt_list_free);
#endif /* NAPT_CHAIN_HLIST */

#endif // DEL_NAPT_TBL

#if defined(IMPROVE_QOS)
#define	MARK_UNDEFINE		0x5d309b1c
#endif
/* --- PATH Table Structures --- */
struct Path_List_Entry
{
#if defined(PATH_CHAIN_HLIST)
	struct hlist_node	path_link;
#endif
	uint8			vaild;	
	uint8			type;	
	uint8			course;			/* 1:In-Bonud 2:Out-Bound */	
	
	/*diff with sd2 port1 start*/
	enum NP_PROTOCOL	protocol;
	ipaddr_t		in_sIp;
	uint32			in_sPort;
	ipaddr_t		in_dIp;
	uint32			in_dPort;
	ipaddr_t		out_sIp;
	uint32			out_sPort;
	ipaddr_t		out_dIp;
	uint32			out_dPort;
	/*diff with sd2 port1 end*/
	uint32			last_used;
	uint8			*out_ifname;
#ifndef NO_ARP_USED
	struct Arp_List_Entry	*arp_entry;		/* for Out-dMac */
#endif

#if defined(IMPROVE_QOS)
#if defined(CONFIG_NET_SCHED)
	uint32	upNfmark;		//nfmark of uplink
	uint32	downNfmark;	//nfmark of downlink
#endif
	struct nf_conn *ct;
	unsigned long		   timeout;
#endif
//	struct dst_entry 	*dst;
		
#if !defined(PATH_CHAIN_HLIST)
	CTAILQ_ENTRY(Path_List_Entry) path_link;
	CTAILQ_ENTRY(Path_List_Entry) tqe_link;
#endif
};
//============================================================================
#if 0
#define CTAILQ_HEAD(name, type)						\
struct name {\
	struct type *tqh_first;	/* first element */			\
	struct type **tqh_last;	/* addr of last next element */		\
	int tqh_count;\
}
#endif
//============================================================================
#if !defined(PATH_CHAIN_HLIST)
struct Path_Table
{
	//PATH_TABLE_LIST_MAX 1024,list �OPath_Table������
	CTAILQ_HEAD(Path_list_entry_head, Path_List_Entry) list[PATH_TABLE_LIST_MAX];
};

CTAILQ_HEAD(Path_list_inuse_head, Path_List_Entry) path_list_inuse;
CTAILQ_HEAD(Path_list_free_head, Path_List_Entry) path_list_free;

struct Path_Table *table_path;
#else /* !PATH_CHAIN_HLIST */
static struct hlist_head *table_path;
static HLIST_HEAD(path_list_free);

static inline struct hlist_node *hlist_first(const struct hlist_head *h)
{
	return h->first;
}
#endif /* PATH_CHAIN_HLIST */

#if 0
/* --- InterFace Table Structures --- */
struct If_List_Entry
{
	uint8			vaild;
	uint8			ifname[IFNAME_LEN_MAX];
	ipaddr_t		ipAddr;
	ether_addr_t	mac;
	uint32			mtu;
	enum IF_FLAGS	flags;
	CTAILQ_ENTRY(If_List_Entry) if_link;
	CTAILQ_ENTRY(If_List_Entry) tqe_link;
};

CTAILQ_HEAD(If_list_inuse_head, If_List_Entry) if_list_inuse;
CTAILQ_HEAD(If_list_free_head, If_List_Entry) if_list_free;
#endif

/* ==================================================================================================== */
#ifdef CONFIG_UDP_FRAG_CACHE

#define MAX_UDP_FRAG_ENTRY 64 //kernel => 64 frag queue!!

#define FRAG_IDLE 0
#define FRAG_FORWADING 1
#define FRAG_COMPLETE 2

//#define FRAG_CACHE_TIMEOUT  IP_FRAG_TIME/2;
#define FRAG_CACHE_TIMEOUT (10 * HZ)

struct Udp_FragCache_Entry {
	uint8	status;
	uint8	protocol;
	uint16	frag_id;
	uint32	src_ip;
	uint32	dst_ip;
	uint16	src_port;
	uint16	dst_port;
	struct timer_list timer; 
	CTAILQ_ENTRY(Udp_FragCache_Entry) path_link;
	CTAILQ_ENTRY(Udp_FragCache_Entry) tqe_link;
};

struct Udp_FragCache_Table
{	
	CTAILQ_HEAD(Udp_cache_list_head, Udp_FragCache_Entry) list[MAX_UDP_FRAG_ENTRY];
};

CTAILQ_HEAD(Udp_cache_free_head,Udp_FragCache_Entry) udp_cache_list_free;

struct Udp_FragCache_Table *udp_cache_table;

#endif

#ifdef CONFIG_UDP_FRAG_CACHE
static inline unsigned int frag_hashfn(uint16 id, uint32 saddr, uint32 daddr, uint8 prot)
{
	unsigned int h = saddr ^ daddr;

	h ^= (h>>16)^id;
	h ^= (h>>8)^prot;
	return h & (MAX_UDP_FRAG_ENTRY - 1);
}

static inline void free_fragEntry(struct Udp_FragCache_Entry *entry)
{	
	unsigned int hash = frag_hashfn(entry->frag_id, entry->src_ip, entry->dst_ip, entry->protocol);	

	entry->status= FRAG_IDLE;
	CTAILQ_REMOVE(&udp_cache_table->list[hash], entry, path_link);	
	CTAILQ_INSERT_TAIL(&udp_cache_list_free, entry, tqe_link);		
}

static void cache_timeout(unsigned long arg)
{
	struct Udp_FragCache_Entry *entry = (struct Udp_FragCache_Entry *)arg;
	//####issue !!! need lock ? , mark_dbg#####			
	if(entry->status == FRAG_IDLE)
	{
		//panic_printk(" timeout But IDLE\n"); 
		return;
	}				
	free_fragEntry(entry);	
}	

static inline void free_cache(struct Udp_FragCache_Entry *entry)
{	
	del_timer(&entry->timer); 
	free_fragEntry(entry);
}

static int udp_fragCache_init(void) 
{	
	int i;
	udp_cache_table = (struct Udp_FragCache_Table *)kmalloc(sizeof(struct Udp_FragCache_Table), GFP_ATOMIC);
	if (udp_cache_table == NULL) {
		DEBUGP_SYS("MALLOC Failed! (Udp_FragCache_Table) \n");
		return 0;
	}	
	CTAILQ_INIT(&udp_cache_list_free);

	for (i=0; i<MAX_UDP_FRAG_ENTRY; i++) {
		CTAILQ_INIT(&udp_cache_table->list[i]);
	}		
	for (i=0; i<MAX_UDP_FRAG_ENTRY; i++) {
		struct Udp_FragCache_Entry *entry = (struct Udp_FragCache_Entry *)kmalloc(sizeof(struct Udp_FragCache_Entry), GFP_ATOMIC);
		if (entry == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Path Table Entry) \n");
			return 0;
		}
		//init timer , start timer in add_entry!!!
		init_timer(&entry->timer);
		entry->timer.data = (unsigned long)entry;	/* pointer to queue	*/
		entry->timer.function = cache_timeout;		/* expire function	*/		
		CTAILQ_INSERT_TAIL(&udp_cache_list_free, entry, tqe_link);
	}
	return 1;
}

static inline struct Udp_FragCache_Entry *find_fragEntry(uint16 id,uint32 sip,uint32 dip,uint8 protocol)
{
	unsigned int hash = frag_hashfn(id, sip, dip, protocol);
	struct Udp_FragCache_Entry *entry;

	CTAILQ_FOREACH(entry, &udp_cache_table->list[hash], path_link) 
	{		
		if ((entry->frag_id== id) && 			
			(entry->src_ip== sip) &&
			(entry->dst_ip== dip) &&
			(entry->protocol== protocol) && 
			(entry->status == FRAG_FORWADING))
		{			
			return ((struct Udp_FragCache_Entry *)entry);
		}
	}	
	return NULL;
}

static inline int add_fragEntry(uint16 id,uint32 sip, uint16 sport, uint32 dip, uint16 dport, uint8 protocol)
{		
	unsigned int hash = frag_hashfn(id, sip, dip, protocol);
	struct Udp_FragCache_Entry *entry;
	
	if(CTAILQ_EMPTY(&udp_cache_list_free))
	{
		//panic_printk("table full ,fail!!!\n"); 
		return 0;
	}	
	
	entry = CTAILQ_FIRST(&udp_cache_list_free);

	entry->frag_id= id;
	entry->src_ip= sip;
	entry->dst_ip= dip;
	entry->protocol= protocol;
	entry->src_port= sport;
	entry->dst_port= dport;
	entry->status= FRAG_FORWADING;	
	CTAILQ_REMOVE(&udp_cache_list_free, entry, tqe_link);
	CTAILQ_INSERT_TAIL(&udp_cache_table->list[hash], entry, path_link);
	
	entry->timer.expires = jiffies + FRAG_CACHE_TIMEOUT;
	add_timer(&entry->timer);	

	return 1;
}
#endif

#ifndef NO_ARP_USED
static uint32 FastPath_Hash_ARP_Entry(ipaddr_t ip)
{
	return (ip % 16);
}
#endif

#ifndef DEL_ROUTE_TBL
static uint32
FastPath_Hash_ROUTE_Entry(ipaddr_t ip, ipaddr_t mask)
{
	int i;
	ipaddr_t tmp = (ip & mask);
	
	for(i=0; i<32; i++) {
		if (tmp & 0x00000001) {
			return (tmp + (uint32)i) % ROUTE_TABLE_LIST_MAX;
		}
		tmp = tmp >> 1;
	}
	
	return 0;
}
#endif

// david
#if 0
static uint32
FastPath_Hash_NAPT_Entry(ipaddr_t intIp,uint32 intPort,
			ipaddr_t extIp, uint32 extPort,
			ipaddr_t remIp, uint32 remPort, int protoocal)
{
	uint32 hash;

	hash = (0xff000000 & intIp) >> 24;
	hash ^= (0x00ff0000 & intIp) >> 16;
	hash ^= (0x0000ff00 & intIp) >> 8;
	hash ^= (0x000000ff & intIp);
	hash ^= (0x0000ff00 & intPort) >> 8;
	hash ^= (0x000000ff & intPort);
	
	hash ^= (0xff000000 & extIp) >> 24;
	hash ^= (0x00ff0000 & extIp) >> 16;
	hash ^= (0x0000ff00 & extIp) >> 8;
	hash ^= (0x000000ff & extIp);
	hash ^= (0x0000ff00 & extPort) >> 8;
	hash ^= (0x000000ff & extPort);

	hash ^= (0xff000000 & remIp) >> 24;
	hash ^= (0x00ff0000 & remIp) >> 16;
	hash ^= (0x0000ff00 & remIp) >> 8;
	hash ^= (0x000000ff & remIp);
	hash ^= (0x0000ff00 & remPort) >> 8;
	hash ^= (0x000000ff & remPort);
	
	return 0x000003ff & (hash ^ (hash >> 12));
}
#endif

#ifndef DEL_NAPT_TBL
static uint32
FastPath_Hash_NAPT_Entry(ipaddr_t sip, uint32 sport, ipaddr_t dip, uint32 dport, uint16 protocol)
{
	register uint32 hash;	
	
	hash = ((sip>>16)^sip);	
	hash ^= ((dip>>16)^dip);	
	hash ^= sport;	
	hash ^= dport;	
	hash ^= protocol;
	return ((NAPT_TABLE_LIST_MAX - 1) & (hash ^ (hash >> 12)));
}
#endif

__IRAM_GEN inline static uint32
FastPath_Hash_PATH_Entry(ipaddr_t sip, uint32 sport, ipaddr_t dip, uint32 dport, uint16 protocol)
{
	register uint32 hash;

// david ------------------------------	
#if 0
	hash = ((sip>>16)^sip);
	hash ^= ((dip>>16)^dip);
	hash ^= sport;
	hash ^= dport;	
	return 0x000003ff & (hash ^ (hash >> 12));
#endif
	hash = ((sip>>8)^sip);
	hash ^= ((dip>>16)^dip);
	hash ^= sport>>4;
	hash ^= dport;	
	hash ^= protocol;
	return (PATH_TABLE_LIST_MAX-1) & (hash ^ (hash >> 12));
//-------------------------------------

}


/* ====================================================================== */

#if 0
enum LR_RESULT
rtk_addFdbEntry(uint32 vid,
		uint32 fid,
		ether_addr_t* mac,
		uint32 portmask,
		enum FDB_FLAGS flags)
{
	DEBUGP_API("addFdbEntry: vid=%u fid=%u mac=%p portmask=0x%08X flasg=0x%08X \n", vid, fid, mac, portmask, flags);
	
	return LR_SUCCESS;
}

enum LR_RESULT
rtk_delFdbEntry(uint32 vid,
		uint32 fid,
		ether_addr_t* mac)
{
	DEBUGP_API("delFdbEntry: vid=%u fid=%u mac=%p \n", vid, fid, mac);
	
	return LR_SUCCESS;
}
#endif
/*======================================================================= */
enum LR_RESULT
rtk_addArp(ipaddr_t ip,
		ether_addr_t* mac,
		enum ARP_FLAGS flags)
{
#ifndef NO_ARP_USED
	uint32 hash = FastPath_Hash_ARP_Entry(ip);
	struct Arp_List_Entry *ep;
	
	DEBUGP_API("addArp: ip=0x%08X mac=%02X:%02X:%02X:%02X:%02X:%02X flags=0x%08X Hash=%u \n", ip, MAC2STR(*mac), flags, hash);
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_arp->list[hash], arp_link) {
		if (ep->ip == ip) {
		//	DEBUGP_SYS("addArp: ERROR - arp(ip=0x%08X) already exist! \n", ip);
			return LR_EXIST;
		}
	}
	
	/* Create */
	if(!CTAILQ_EMPTY(&arp_list_free)) {
		struct Arp_List_Entry *entry_arp;
		entry_arp = CTAILQ_FIRST(&arp_list_free);
		entry_arp->ip = ip;
		entry_arp->mac = *mac;
		entry_arp->flags = flags;
		entry_arp->vaild = 0xff;
		CTAILQ_REMOVE(&arp_list_free, entry_arp, tqe_link);
		CTAILQ_INSERT_TAIL(&arp_list_inuse, entry_arp, tqe_link);
		CTAILQ_INSERT_TAIL(&table_arp->list[hash], entry_arp, arp_link);
	} else {
		DEBUGP_SYS("addArp: ERROR - arp_list_free is empty! \n");
		return LR_FAILED;
	}
#endif	
	return LR_SUCCESS;
}
/*======================================================================= */
enum LR_RESULT
rtk_modifyArp(ipaddr_t ip,
		ether_addr_t* mac,
		enum ARP_FLAGS flags)
{
#ifndef NO_ARP_USED
	uint32 hash = FastPath_Hash_ARP_Entry(ip);
	struct Arp_List_Entry *ep;
	
	DEBUGP_API("modifyArp: ip=0x%08X mac=%02X:%02X:%02X:%02X:%02X:%02X flags=0x%08X \n", ip, MAC2STR(*mac), flags);
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_arp->list[hash], arp_link) {
		if (ep->ip == ip) {
			ep->mac = *mac;
			ep->flags = flags;
			return LR_SUCCESS;
		}
	}
#endif
	return LR_SUCCESS;
}
/*======================================================================= */
/*
	delArp() - Delete an entry of Arp Table.
*/
enum LR_RESULT
rtk_delArp(ipaddr_t ip)
{
#ifndef NO_ARP_USED
	uint32 hash = FastPath_Hash_ARP_Entry(ip);
	struct Arp_List_Entry *ep;
	
	DEBUGP_API("delArp: ip=0x%08X \n", ip);
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_arp->list[hash], arp_link) {
		if (ep->ip == ip) {
			ep->vaild = 0x00;
			CTAILQ_REMOVE(&table_arp->list[hash], ep, arp_link);
			CTAILQ_REMOVE(&arp_list_inuse, ep, tqe_link);
			CTAILQ_INSERT_TAIL(&arp_list_free, ep, tqe_link);
			return LR_SUCCESS;
		}
	}
#endif
	return LR_NONEXIST;
}
/*======================================================================= */
enum LR_RESULT
rtk_addRoute(ipaddr_t ip,
		ipaddr_t mask,
		ipaddr_t gateway,
		uint8* ifname,
		enum RT_FLAGS flags)
{
#ifndef DEL_ROUTE_TBL
	uint32 hash = FastPath_Hash_ROUTE_Entry(ip, mask);
	
	DEBUGP_API("addRoute: ip=0x%08X mask=0x%08X gateway=0x%08X ifname=%s flags=0x%08X Hash=%u \n", 
		ip, mask, gateway, ifname, flags, hash);
	if(!CTAILQ_EMPTY(&route_list_free)) {
		struct Route_List_Entry *entry_route;
		entry_route = CTAILQ_FIRST(&route_list_free);
		entry_route->ip = ip;
		entry_route->mask = mask;
		entry_route->gateway = gateway;
		memcpy(&entry_route->ifname, ifname, IFNAME_LEN_MAX - 1);
		entry_route->flags = flags;
		entry_route->vaild = 0xff;
		CTAILQ_REMOVE(&route_list_free, entry_route, tqe_link);
		CTAILQ_INSERT_TAIL(&route_list_inuse, entry_route, tqe_link);
		CTAILQ_INSERT_TAIL(&table_route->list[hash], entry_route, route_link);
	} else {
		DEBUGP_SYS("addRoute: ERROR - Route_list_free is empty! \n");		
		return LR_FAILED;
	}
#endif
	
	return LR_SUCCESS;
}
/*======================================================================= */
enum LR_RESULT
rtk_modifyRoute(ipaddr_t ip,
		ipaddr_t mask,
		ipaddr_t gateway,
		uint8* ifname,
		enum RT_FLAGS flags)
{

#ifndef DEL_ROUTE_TBL
	uint32 hash = FastPath_Hash_ROUTE_Entry(ip, mask);
	struct Route_List_Entry *ep;
	
	DEBUGP_API("modifyRoute: ip=0x%08X mask=0x%08X gateway=0x%08X ifname=%s flags=0x%08X \n", 
		ip, mask, gateway, ifname, flags);
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_route->list[hash], route_link) {
		if (ep->ip == ip && ep->mask == mask) {
			ep->gateway = gateway;
			memcpy(&ep->ifname, ifname, IFNAME_LEN_MAX - 1);
			ep->flags = flags;
			CTAILQ_REMOVE(&table_route->list[hash], ep, route_link);
			CTAILQ_REMOVE(&route_list_inuse, ep, tqe_link);
			CTAILQ_INSERT_TAIL(&route_list_free, ep, tqe_link);
			return LR_SUCCESS;
		}
	}
#endif

	return LR_SUCCESS;
}
/*======================================================================= */
enum LR_RESULT
rtk_delRoute(ipaddr_t ip, ipaddr_t mask)
{

#ifndef DEL_ROUTE_TBL
	uint32 hash = FastPath_Hash_ROUTE_Entry(ip, mask);
	struct Route_List_Entry *ep;
	
	DEBUGP_API("delRoute: ip=0x%08X mask=0x%08X \n", ip, mask);
	/* Lookup */
	CTAILQ_FOREACH(ep, &table_route->list[hash], route_link) {
		if (ep->ip == ip && ep->mask == mask) {
			ep->vaild = 0x00;
			CTAILQ_REMOVE(&table_route->list[hash], ep, route_link);
			CTAILQ_REMOVE(&route_list_inuse, ep, tqe_link);
			CTAILQ_INSERT_TAIL(&route_list_free, ep, tqe_link);
			return LR_SUCCESS;
		}
	}
#endif

	return LR_NONEXIST;
}
/*======================================================================= */
enum LR_RESULT
rtk_addSession(uint8* ifname,
		enum SE_TYPE seType,
		uint32 sessionId,
		enum SE_FLAGS flags )
{
	return LR_SUCCESS;
}

enum LR_RESULT
rtk_delSession(uint8* ifname)
{
	return LR_SUCCESS;
}
/*======================================================================= */

enum LR_RESULT 
rtk_addNaptConnection(enum NP_PROTOCOL protocol,
		ipaddr_t intIp, uint32 intPort,
		ipaddr_t extIp, uint32 extPort,
		ipaddr_t remIp, uint32 remPort,	
#if defined(IMPROVE_QOS)
		struct sk_buff *pskb, struct nf_conn *ct, 
#endif	
		enum NP_FLAGS flags)
{
// david
//	uint32 hash = FastPath_Hash_NAPT_Entry(intIp, intPort, extIp, extPort, remIp, remPort);
#ifndef DEL_NAPT_TBL
	uint32 hash = FastPath_Hash_NAPT_Entry(intIp, intPort, remIp, remPort, (uint16)protocol);
	struct Napt_List_Entry *ep;
#if defined(PATH_CHAIN_HLIST)
	struct hlist_node *node;
#endif
#endif /* DEL_NAPT_TBL */

	uint16 ipprotocol;
#if defined(IMPROVE_QOS)
	struct iphdr *iph;	
	struct tcphdr *tcphupuh;  //just keep one , don't care tcp or udp //
	u_int ori_saddr, ori_daddr;
	u_short ori_sport, ori_dport;

	if(pskb==NULL)				
		return LR_FAILED;
			
	iph = ip_hdr(pskb);
	tcphupuh = (struct tcphdr*)((__u32 *)iph + iph->ihl);
#endif
	
#if 0	/* FastPath DONT check */
	if (intIp == exitIp && intPort == extPort && !LocalPublicIP_CHECK(intIp))
		return LR_FAILED;
#endif

	if (protocol == NP_TCP)
		ipprotocol = IPPROTO_TCP;
	else		
		ipprotocol = IPPROTO_UDP;
	
	 DEBUGP_API("addNaptConnection: P=%s int=%u.%u.%u.%u:%u ext=%u.%u.%u.%u:%u rem=%u.%u.%u.%u:%u F=%d (Ha=%u, Hb=%u)\n", 
		(protocol==NP_TCP)? "TCP" : "UDP", NIPQUAD(intIp), intPort, NIPQUAD(extIp), extPort, NIPQUAD(remIp), remPort, flags, 
		FastPath_Hash_PATH_Entry(intIp, intPort, remIp, remPort, ipprotocol), FastPath_Hash_PATH_Entry(remIp, remPort, extIp, extPort,ipprotocol));

#ifdef DOS_FILTER
	filter_addconnect(remIp);
#endif

#ifndef DEL_NAPT_TBL
	/* Lookup */
#if defined(PATH_CHAIN_HLIST)
	hlist_for_each(node, &table_napt[hash]) {
		ep = (struct Napt_List_Entry *)node;
#else
	CTAILQ_FOREACH(ep, &table_napt->list[hash], napt_link) {
#endif /* PATH_CHAIN_HLIST */
		if ((ep->protocol == protocol) &&
			(ep->intIp == intIp) &&
			(ep->intPort == intPort) &&
			(ep->extIp == extIp) &&
			(ep->extPort == extPort) &&
			(ep->remIp == remIp) &&
			(ep->remPort == remPort)) {
			//DEBUGP_SYS("addNaptConnection: ERROR - the entry already exist! \n");			
			return LR_SUCCESS;
		}
	}

#if defined(NAPT_CHAIN_HLIST)
	if (!hlist_empty(&napt_list_free)) {
		struct Napt_List_Entry *entry_napt;
		entry_napt = (struct Napt_List_Entry *)hlist_first(&napt_list_free);
#else
	if(!CTAILQ_EMPTY(&napt_list_free)) {
		struct Napt_List_Entry *entry_napt;
		entry_napt = CTAILQ_FIRST(&napt_list_free);
#endif /* NAPT_CHAIN_HLIST */

		entry_napt->protocol = protocol;
		entry_napt->intIp = intIp;
		entry_napt->intPort = intPort;
		entry_napt->extIp = extIp;
		entry_napt->extPort = extPort;
		entry_napt->remIp = remIp;
		entry_napt->remPort = remPort;
		entry_napt->flags = flags;
		entry_napt->vaild = 0xff;
#if defined(NAPT_CHAIN_HLIST)
		hlist_del(&entry_napt->napt_link);
		hlist_add_head(&entry_napt->napt_link, &table_napt[hash]);
#else
		CTAILQ_REMOVE(&napt_list_free, entry_napt, tqe_link);
		CTAILQ_INSERT_TAIL(&napt_list_inuse, entry_napt, tqe_link);
		CTAILQ_INSERT_TAIL(&table_napt->list[hash], entry_napt, napt_link);
#endif /* NAPT_CHAIN_HLIST */
#else
	if (1) {
#endif
		uint32	hash;
		struct Path_List_Entry *entry_path;
		/*===================add Path Table Entry=====================*/		
		/* course = 1 (Outbound) */
		hash = FastPath_Hash_PATH_Entry(intIp, intPort, remIp, remPort, ipprotocol);
		
#if defined(PATH_CHAIN_HLIST)
		if (!hlist_empty(&path_list_free)) {

		/* path_link is the first element of struct Path_List_Entry */
		entry_path = (struct Path_List_Entry *)hlist_first(&path_list_free);
#else
		if(!CTAILQ_EMPTY(&path_list_free)) {    //brad modify 2007-11-27
		entry_path = CTAILQ_FIRST(&path_list_free);
#endif /* PATH_CHAIN_HLIST */
		entry_path->protocol	= protocol;
		entry_path->in_sIp	= intIp;
		entry_path->in_sPort	= intPort;
		entry_path->in_dIp	= remIp;
		entry_path->in_dPort	= remPort;
		entry_path->out_sIp	= extIp;
		entry_path->out_sPort	= extPort;
		entry_path->out_dIp	= remIp;
		entry_path->out_dPort	= remPort;
		
		entry_path->out_ifname	= FastPath_Route(entry_path->out_dIp);
#ifndef NO_ARP_USED
		entry_path->arp_entry	= NULL;
#endif
		entry_path->course		= 1;
		entry_path->vaild		= 0xff;
//		entry_path->dst			= NULL;		
		entry_path->type		= 0;	/* Init: Normal (Only Routing) */				
		if (entry_path->in_sIp != entry_path->out_sIp) {
			entry_path->type |= 1;	// SNAT 
		}
		if (entry_path->in_sPort != entry_path->out_sPort) {
			entry_path->type |= 2;	// SNPT 
		}		

#if defined(IMPROVE_QOS)
#if defined(CONFIG_NET_SCHED)
		entry_path->upNfmark = 0;
		entry_path->downNfmark = 0;

		{
//			memDump(pskb->nh.iph, 32, "iph");
			u_short proto = ntohs(pskb->protocol);
			unsigned char oriSrcMac[6],oriDstMac[6],oriHhDataMac[6],resMac[14];
			unsigned char pppProto[2],ipProto[2];
			struct net_device * lanDev;
			struct dst_entry *dst;
			struct hh_cache *hh;
			__u32 oriSkbMark;

			//initial
			pppProto[0]=0x00;
			pppProto[1]=0x21;
			ipProto[0]=0x08;
			ipProto[1]=0x00;
			
			//Bak orignal skb mark
			oriSkbMark=pskb->mark;

			//check ip-based qos rule at iptables mangle table
			//To record original info
			ori_saddr=iph->saddr;
			ori_sport=tcphupuh->source;
			ori_daddr=iph->daddr;
			ori_dport=tcphupuh->dest;

			//Replace source addr to check uplink mark
			iph->saddr=intIp;
			tcphupuh->source=intPort;
			
			pskb->mark=0;//initial
			if(proto == ETH_P_IP){
				(list_empty(&nf_hooks[PF_INET][NF_IP_PRE_ROUTING]))?: \
					ipt_do_table(pskb, NF_IP_PRE_ROUTING, pskb->dev, NULL,\
					dev_net(pskb->dev)->ipv4.iptable_mangle);
			}
			entry_path->upNfmark = pskb->mark;

			//Replace dest addr to check uplink mark
			iph->daddr=intIp;
			tcphupuh->dest=intPort;

			pskb->mark=0;//initial
			if(proto == ETH_P_IP){
				(list_empty(&nf_hooks[PF_INET][NF_IP_POST_ROUTING]))?: \
					ipt_do_table(pskb, NF_IP_POST_ROUTING, pskb->dev, NULL,\
					dev_net(pskb->dev)->ipv4.iptable_mangle);
			}
			entry_path->downNfmark= pskb->mark;

			//back to original info
			iph->saddr=ori_saddr;
			tcphupuh->source=ori_sport;
			iph->daddr=ori_daddr;
			tcphupuh->dest=ori_dport;

			//check mac-based qos rule at iptables mangle table
			if((entry_path->upNfmark==0)||(entry_path->downNfmark==0))
			{
				memset(resMac,0,14);
				lanDev=NULL;
				lanDev=__dev_get_by_name(&init_net, QOS_LAN_DEV_NAME);
				if((lanDev!=NULL)&&(arp_req_get_ha(intIp,lanDev,resMac)==0))
				{					
					//Patch for pppoe wantype: run udp chariot
					//bak skb mac header
					if((memcmp(pskb->data-2, pppProto,2)==0)	//equal 0x0021
						&&(skb_mac_header_was_set(pskb)==1)
						&&(eth_hdr(pskb)->h_proto!=ntohs(0x0800))) //not equal to 0x0800
					{
							skb_set_mac_header(pskb, -22);
					}
					
					//To bak origal protol mac
					memcpy(oriSrcMac,eth_hdr(pskb)->h_source,ETH_ALEN);
					memcpy(oriDstMac,eth_hdr(pskb)->h_dest,ETH_ALEN);

					if(entry_path->upNfmark==0)
					{
						//Replace source mac addr to check uplink mark
						memcpy(eth_hdr(pskb)->h_source,resMac, ETH_ALEN);
						pskb->mark=0;//initial
						if(proto == ETH_P_IP){
							(list_empty(&nf_hooks[PF_INET][NF_IP_PRE_ROUTING]))?: \
								ipt_do_table(pskb, NF_IP_PRE_ROUTING, pskb->dev, NULL,\
								dev_net(pskb->dev)->ipv4.iptable_mangle);
						}
						entry_path->upNfmark = pskb->mark;
						
						//Back to origal protol mac
						memcpy(eth_hdr(pskb)->h_source,oriSrcMac, ETH_ALEN);
					}
#if 1
					if(entry_path->downNfmark==0)
					{
						//Replace dest mac addr and  hh data mac to check uplink mark
						memcpy(eth_hdr(pskb)->h_dest,resMac,ETH_ALEN);
							
						dst = pskb->dst;
						if ((dst)&& (dst->hh)&&(dst->hh->hh_data))
						{
							hh = dst->hh;

							//bak hh data mac
							memcpy(oriHhDataMac, (((u8*)hh->hh_data) + 2), ETH_ALEN);
							
							memcpy((((u8*)hh->hh_data) + 2), resMac, ETH_ALEN);
						}

						pskb->mark=0;//initial
						if(proto == ETH_P_IP){
							(list_empty(&nf_hooks[PF_INET][NF_IP_POST_ROUTING]))?: \
								ipt_do_table(pskb, NF_IP_POST_ROUTING, pskb->dev, NULL,\
								dev_net(pskb->dev)->ipv4.iptable_mangle);
						}
						entry_path->downNfmark= pskb->mark;

						if ((dst)&& (dst->hh)&&(dst->hh->hh_data)) 
						{
							//Back to orignal hh data mac
							memcpy((((u8*)hh->hh_data) + 2), oriHhDataMac, ETH_ALEN);
						}

						//Back to orignal protol mac
						memcpy(eth_hdr(pskb)->h_dest,oriDstMac,ETH_ALEN);
					}
#endif
				}
				else
				{
					//printk("%s(%d):[Warning] %s, queryIP=0x%x no query result!!!!\n",__FUNCTION__,__LINE__,lanDev==NULL?"lanDev is NULL":lanDev->name,intIp);//Added for test
				}
			}
			
			//Back to original skb mark
			pskb->mark=oriSkbMark;
		}
#endif
		if(protocol==NP_TCP)
			entry_path->timeout = tcp_get_timeouts_by_state(ct->proto.tcp.state);
		else
			entry_path->timeout = nf_ct_udp_timeout_stream;

		entry_path->ct = ct;
		entry_path->last_used=jiffies;
#endif
		
#if defined(PATH_CHAIN_HLIST)
		hlist_del(&entry_path->path_link);
		hlist_add_head(&entry_path->path_link, &table_path[hash]);
#else
		CTAILQ_REMOVE(&path_list_free, entry_path, tqe_link);
		CTAILQ_INSERT_TAIL(&path_list_inuse, entry_path, tqe_link);
		CTAILQ_INSERT_TAIL(&table_path->list[hash], entry_path, path_link);
#endif /* PATH_CHAIN_HLIST */
		}//else{
		//	printk("<<<----DEBUG course 1 got NULL ---->>>>>>\n");
		//}
		/* course = 2 (Inbound) */
		hash = FastPath_Hash_PATH_Entry(remIp, remPort, extIp, extPort, ipprotocol);
		
#if defined(PATH_CHAIN_HLIST)
		if (!hlist_empty(&path_list_free)) {
		entry_path = (struct Path_List_Entry *)hlist_first(&path_list_free);
#else
		if(!CTAILQ_EMPTY(&path_list_free)) {    //brad modify 2007-11-27
		entry_path = CTAILQ_FIRST(&path_list_free);
#endif /* PATH_CHAIN_HLIST */
		entry_path->protocol	= protocol;
		entry_path->in_sIp	= remIp;
		entry_path->in_sPort	= remPort;
		entry_path->in_dIp	= extIp;
		entry_path->in_dPort	= extPort;
		entry_path->out_sIp	= remIp;
		entry_path->out_sPort	= remPort;
		entry_path->out_dIp	= intIp;
		entry_path->out_dPort	= intPort;
		
		entry_path->out_ifname	= FastPath_Route(entry_path->out_dIp);
#ifndef NO_ARP_USED
		entry_path->arp_entry	= NULL;
#endif
		entry_path->course	= 2;
		entry_path->vaild	= 0xff;
//		entry_path->dst		= NULL;
		entry_path->type	= 0;	/* Init: Normal (Only Routing) */				
		if (entry_path->in_dIp != entry_path->out_dIp) {
			entry_path->type |= 4;	// DNAT 
		}
		if (entry_path->in_dPort != entry_path->out_dPort) {
			entry_path->type |= 8;	// DNPT
		}
		
#if defined(IMPROVE_QOS)
#if defined(CONFIG_NET_SCHED)
		entry_path->upNfmark = 0;
		entry_path->downNfmark = 0;
		{
//			printk("%s(%d): pskb is not null\n",__FUNCTION__,__LINE__);//Added for test
//			memDump(pskb->nh.iph, 32, "iph");
			u_short proto = ntohs(pskb->protocol);
			unsigned char oriSrcMac[6],oriDstMac[6],oriHhDataMac[6],resMac[14];
			unsigned char pppProto[2],ipProto[2];
			struct net_device * lanDev;
			struct dst_entry *dst;
			struct hh_cache *hh;
			__u32 oriSkbMark;

			//initial
			pppProto[0]=0x00;
			pppProto[1]=0x21;
			ipProto[0]=0x08;
			ipProto[1]=0x00;

			//Bak orignal skb mark
			oriSkbMark=pskb->mark;

			//check ip-based qos rule at iptables mangle table
			//To record original info
			ori_saddr=iph->saddr;
			ori_sport=tcphupuh->source;
			ori_daddr=iph->daddr;
			ori_dport=tcphupuh->dest;

			//Replace source addr to check uplink mark
			iph->saddr=intIp;
			tcphupuh->source=intPort;

			pskb->mark=0;//initial
			if(proto == ETH_P_IP){
				(list_empty(&nf_hooks[PF_INET][NF_IP_PRE_ROUTING]))?: \
					ipt_do_table(pskb, NF_IP_PRE_ROUTING, pskb->dev, NULL,\
					dev_net(pskb->dev)->ipv4.iptable_mangle);
			}
			entry_path->upNfmark = pskb->mark;

			
			//Replace dest addr to check uplink mark
			iph->daddr=intIp;
			tcphupuh->dest=intPort;

			pskb->mark=0;//initial
			if(proto == ETH_P_IP){
				(list_empty(&nf_hooks[PF_INET][NF_IP_POST_ROUTING]))?: \
					ipt_do_table(pskb, NF_IP_POST_ROUTING, pskb->dev, NULL,\
					dev_net(pskb->dev)->ipv4.iptable_mangle);
			}
			entry_path->downNfmark= pskb->mark;

			//back to original info
			iph->saddr=ori_saddr;
			tcphupuh->source=ori_sport;
			iph->daddr=ori_daddr;
			tcphupuh->dest=ori_dport;

			//check mac-based qos rule at iptables mangle table
			if((entry_path->upNfmark==0)||(entry_path->downNfmark==0))
			{
				memset(resMac,0,14);
				lanDev=NULL;
				lanDev=__dev_get_by_name(&init_net, QOS_LAN_DEV_NAME);
				if((lanDev!=NULL)&&(arp_req_get_ha(intIp,lanDev,resMac)==0))
				{						
					//Patch for pppoe wantype: run udp chariot
					if((memcmp(pskb->data-2, pppProto,2)==0)	//equal 0x0021
						&&(skb_mac_header_was_set(pskb)==1)
						&&(eth_hdr(pskb)->h_proto!=ntohs(0x0800))) //not equal to 0x0800
					{
						skb_set_mac_header(pskb, -22);
					}
					
					//To bak origal protol mac
					memcpy(oriSrcMac,eth_hdr(pskb)->h_source,ETH_ALEN);
					memcpy(oriDstMac,eth_hdr(pskb)->h_dest,ETH_ALEN);
					
					if(entry_path->upNfmark==0)
					{
						//Replace source mac addr to check uplink mark
						memcpy(eth_hdr(pskb)->h_source,resMac, ETH_ALEN);
						pskb->mark=0;//initial
						if(proto == ETH_P_IP){
							(list_empty(&nf_hooks[PF_INET][NF_IP_PRE_ROUTING]))?: \
								ipt_do_table(pskb, NF_IP_PRE_ROUTING, pskb->dev, NULL,\
								dev_net(pskb->dev)->ipv4.iptable_mangle);
						}
						entry_path->upNfmark = pskb->mark;
						
						//Back to origal protol mac
						memcpy(eth_hdr(pskb)->h_source,oriSrcMac, ETH_ALEN);
					}
#if 1
					if(entry_path->downNfmark==0)
					{
						//Replace dest mac addr and  hh data mac to check uplink mark
						memcpy(eth_hdr(pskb)->h_dest,resMac,ETH_ALEN);
							
						dst = pskb->dst;
						if ((dst)&& (dst->hh)&&(dst->hh->hh_data)) 
						{
							hh = dst->hh;

							//bak hh data mac
							memcpy(oriHhDataMac, (((u8*)hh->hh_data) + 2), ETH_ALEN);
							
							memcpy((((u8*)hh->hh_data) + 2), resMac, ETH_ALEN);
						}

						pskb->mark=0;//initial
						if(proto == ETH_P_IP){
							(list_empty(&nf_hooks[PF_INET][NF_IP_POST_ROUTING]))?: \
								ipt_do_table(pskb, NF_IP_POST_ROUTING, pskb->dev, NULL,\
								dev_net(pskb->dev)->ipv4.iptable_mangle);
						}
						entry_path->downNfmark= pskb->mark;

						if ((dst)&& (dst->hh)&&(dst->hh->hh_data)) 
						{
							//Back to orignal hh data mac
							memcpy((((u8*)hh->hh_data) + 2), oriHhDataMac, ETH_ALEN);
						}

						//Back to orignal protol mac
						memcpy(eth_hdr(pskb)->h_dest,oriDstMac,ETH_ALEN);
					}
#endif
				}
				else
				{
					//printk("%s(%d):[Warning] %s, queryIP=0x%x no query result!!!!\n",__FUNCTION__,__LINE__,lanDev==NULL?"lanDev is NULL":lanDev->name,intIp);//Added for test
				}
			}
			
			//Back to original skb mark
			pskb->mark=oriSkbMark;
		}
#endif
		if(protocol==NP_TCP)
			entry_path->timeout = tcp_get_timeouts_by_state(ct->proto.tcp.state);
		else
			entry_path->timeout = nf_ct_udp_timeout_stream;

		entry_path->ct = ct;
		entry_path->last_used=jiffies;
#if 0
		{
			extern rwlock_t ip_conntrack_lock;
			write_lock_bh(&ip_conntrack_lock);
			mod_timer(&entry_path->ct->timeout,  (jiffies+entry_path->timeout));
			write_unlock_bh(&ip_conntrack_lock);
		}
#endif
#endif

#if defined(PATH_CHAIN_HLIST)
		hlist_del(&entry_path->path_link);
		hlist_add_head(&entry_path->path_link, &table_path[hash]);
#else
		CTAILQ_REMOVE(&path_list_free, entry_path, tqe_link);
		CTAILQ_INSERT_TAIL(&path_list_inuse, entry_path, tqe_link);
		CTAILQ_INSERT_TAIL(&table_path->list[hash], entry_path, path_link);
#endif /* PATH_CHAIN_HLIST */
		}//else{
		//	printk("<<<----DEBUG course 2 got NULL ---->>>>>>\n");
		//}
		/*===================add Path Table Entry=====================*/	
	} else {
		DEBUGP_SYS("addNaptConnection: ERROR - Napt_list_free is empty! \n");		
		return LR_FAILED;
	}

	
	return LR_SUCCESS;
}
/*======================================================================= */
enum LR_RESULT 
rtk_delNaptConnection(enum NP_PROTOCOL protocol,
		ipaddr_t intIp, uint32 intPort,
		ipaddr_t extIp, uint32 extPort,
		ipaddr_t remIp, uint32 remPort)
{
// david
//	uint32 hash = FastPath_Hash_NAPT_Entry(intIp, intPort, extIp, extPort, remIp, remPort);
#ifndef DEL_NAPT_TBL
	uint32 hash = FastPath_Hash_NAPT_Entry(intIp, intPort, remIp, remPort, (uint16)protocol);
	struct Napt_List_Entry *ep;
#if defined(NAPT_CHAIN_HLIST)
	struct hlist_node *napt_node, *napt_n;
#endif	
#endif /* DEL_NAPT_TBL */	
	uint16 ipprotocol;
	
	DEBUGP_API("delNaptConnection: P=%s int=%u.%u.%u.%u:%u ext=%u.%u.%u.%u:%u rem=%u.%u.%u.%u:%u \n", 
		(protocol==NP_TCP)? "TCP" : "UDP", NIPQUAD(intIp), intPort, NIPQUAD(extIp), extPort, NIPQUAD(remIp), remPort);

	if (protocol == NP_TCP)
		ipprotocol = IPPROTO_TCP;
	else		
		ipprotocol = IPPROTO_UDP;

#ifdef DOS_FILTER
	filter_delconnect(remIp);
#endif

#ifndef DEL_NAPT_TBL
	/* Lookup */
#if defined(NAPT_CHAIN_HLIST)
	hlist_for_each_entry_safe(ep, napt_node, napt_n, &table_napt[hash], napt_link) {
#else
	CTAILQ_FOREACH(ep, &table_napt->list[hash], napt_link) {
#endif /* NAPT_CHAIN_HLIST */
		if ((ep->protocol == protocol) &&
			(ep->intIp == intIp) &&
			(ep->intPort == intPort) &&
			(ep->extIp == extIp) &&
			(ep->extPort == extPort) &&
			(ep->remIp == remIp) &&
			(ep->remPort == remPort)) {
			ep->vaild = 0x00;
#if defined(NAPT_CHAIN_HLIST)
			hlist_del(&ep->napt_link);
			hlist_add_head(&ep->napt_link, &napt_list_free);
#else
			CTAILQ_REMOVE(&table_napt->list[hash], ep, napt_link);
			CTAILQ_REMOVE(&napt_list_inuse, ep, tqe_link);
			CTAILQ_INSERT_TAIL(&napt_list_free, ep, tqe_link);
#endif /* NAPT_CHAIN_HLIST */
#else
	if (1) { {		
#endif		
			/* del Path Table Entry */

			uint32	hash;
			struct Path_List_Entry *entry_path;
#if defined(PATH_CHAIN_HLIST)
			struct hlist_node *node, *n;
#endif
		
			/* course = 1 (Outbound) */
			hash = FastPath_Hash_PATH_Entry(intIp, intPort, remIp, remPort, ipprotocol);
#if defined(PATH_CHAIN_HLIST)
			hlist_for_each_entry_safe(entry_path, node, n, &table_path[hash], path_link) {
#else
			CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {
#endif /* PATH_CHAIN_HLIST */

// Remove entry only when ip/port are matched ---------------------
//				if ((entry_path->protocol == ep->protocol) && (entry_path->course == 1)){
				if ((entry_path->protocol == protocol) &&
					(entry_path->course == 1)	&&		
					(entry_path->in_sIp == intIp) &&
					(entry_path->in_sPort == intPort) &&
					(entry_path->out_sIp == extIp) &&
					(entry_path->out_sPort == extPort) &&
					(entry_path->in_dIp == remIp) &&
					(entry_path->in_dPort == remPort)) {

//					if (entry_path->dst) {//brad go back original 20080813
//						dst_release(entry_path->dst);	 //original					
//						//entry_path->dst->dst_cache = NULL;				
//						entry_path->dst = NULL;	
//					}					
//-------------------------------------------- david+2007-05-28

					entry_path->vaild = 0x00;
#if defined(PATH_CHAIN_HLIST)
					hlist_del(&entry_path->path_link);
					hlist_add_head(&entry_path->path_link, &path_list_free);
#else
					CTAILQ_REMOVE(&table_path->list[hash], entry_path, path_link);
					CTAILQ_REMOVE(&path_list_inuse, entry_path, tqe_link);
					CTAILQ_INSERT_TAIL(&path_list_free, entry_path, tqe_link);
#endif /* PATH_CHAIN_HLIST */
					break;
				}
			}
		
			/* course = 2 (Inbound) */
			hash = FastPath_Hash_PATH_Entry(remIp, remPort, extIp, extPort, ipprotocol);
#if defined(PATH_CHAIN_HLIST)
			hlist_for_each_entry_safe(entry_path, node, n, &table_path[hash], path_link) {
#else
			CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {
#endif /* PATH_CHAIN_HLIST */

// Remove entry only when ip/port are matched ---------------------
//				if ((entry_path->protocol == ep->protocol) && (entry_path->course == 2)){
				if ((entry_path->protocol == protocol) &&
					(entry_path->course == 2)	&&		
					(entry_path->in_dIp == extIp) &&
					(entry_path->in_dPort == extPort) &&
					(entry_path->out_sIp == remIp)  &&
					(entry_path->out_sPort	== remPort) &&
					(entry_path->out_dIp== intIp) &&
					(entry_path->out_dPort	== intPort)) {		
					
//					if (entry_path->dst) { //Brad go back original 
//						dst_release(entry_path->dst);		 //original		
//						//entry_path->dst->dst_cache = NULL; 
//						entry_path->dst = NULL;
//					}
//-------------------------------------------- david+2007-05-28
					entry_path->vaild = 0x00;
#if defined(PATH_CHAIN_HLIST)
					hlist_del(&entry_path->path_link);
					hlist_add_head(&entry_path->path_link, &path_list_free);
#else
					CTAILQ_REMOVE(&table_path->list[hash], entry_path, path_link);
					CTAILQ_REMOVE(&path_list_inuse, entry_path, tqe_link);
					CTAILQ_INSERT_TAIL(&path_list_free, entry_path, tqe_link);
#endif /* PATH_CHAIN_HLIST */
					break;
				}
			}			
			return LR_SUCCESS;
		}
	}
	return LR_NONEXIST;
}

enum LR_RESULT
rtk_idleNaptConnection(enum NP_PROTOCOL protocol,
		ipaddr_t intIp, uint32 intPort,
		ipaddr_t extIp, uint32 extPort,
		ipaddr_t remIp, uint32 remPort,
		uint32 interval)
{
	uint16 ipprotocol;
	uint16 conn_timer_updated = 0;
	uint32 hash;
	unsigned long now, last_used;
	struct Path_List_Entry *entry_path;
#if defined(PATH_CHAIN_HLIST)
	struct hlist_node *node;
#endif
	
	now = jiffies;
	DEBUGP_API("rtk_idleNaptConnection: P=%s int=%u.%u.%u.%u:%u ext=%u.%u.%u.%u:%u rem=%u.%u.%u.%u:%u \n", 
		(protocol==NP_TCP)? "TCP" : "UDP", NIPQUAD(intIp), intPort, NIPQUAD(extIp), extPort, NIPQUAD(remIp), remPort);

	if (protocol == NP_TCP)
		ipprotocol = IPPROTO_TCP;
	else		
		ipprotocol = IPPROTO_UDP;

	/* course = 1 (Outbound) */
	hash = FastPath_Hash_PATH_Entry(intIp, intPort, remIp, remPort, ipprotocol);
#if defined(PATH_CHAIN_HLIST)
	hlist_for_each_entry(entry_path, node, &table_path[hash], path_link) {
#else
	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {
#endif /* PATH_CHAIN_HLIST */
		if ((entry_path->protocol == protocol) &&
			(entry_path->course == 1)	&&		
			(entry_path->in_sIp == intIp) &&
			(entry_path->in_sPort == intPort) &&
			(entry_path->out_sIp == extIp) &&
			(entry_path->out_sPort == extPort) &&
			(entry_path->in_dIp == remIp) &&
			(entry_path->in_dPort == remPort)) {
			last_used = entry_path->last_used;
			if (time_before((now - interval), last_used))
			{
#if defined(IMPROVE_QOS)
				extern rwlock_t ip_conntrack_lock;
				write_lock_bh(&ip_conntrack_lock);
				//entry_path->ct->timeout.expires = (last_used+entry_path->timeout*2);
				entry_path->ct->timeout.expires = last_used + interval;
				conn_timer_updated = 1;
				add_timer(&entry_path->ct->timeout);
				write_unlock_bh(&ip_conntrack_lock);
#endif
				return LR_FAILED;
			}
			break;
		}
	}
	
	/* course = 2 (Inbound) */
	hash = FastPath_Hash_PATH_Entry(remIp, remPort, extIp, extPort, ipprotocol);
#if defined(PATH_CHAIN_HLIST)
	hlist_for_each_entry(entry_path, node, &table_path[hash], path_link) {
#else
	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {
#endif /* PATH_CHAIN_HLIST */
		if ((entry_path->protocol == protocol) &&
			(entry_path->course == 2)	&&		
			(entry_path->in_dIp == extIp) &&
			(entry_path->in_dPort == extPort) &&
			(entry_path->out_sIp == remIp)  &&
			(entry_path->out_sPort	== remPort) &&
			(entry_path->out_dIp== intIp) &&
			(entry_path->out_dPort	== intPort)) {		
			last_used = entry_path->last_used;
			if (time_before((now - interval), last_used))
			{
#if defined(IMPROVE_QOS)
				extern rwlock_t ip_conntrack_lock;
				write_lock_bh(&ip_conntrack_lock);
				//entry_path->ct->timeout.expires = (last_used+entry_path->timeout*2);
				if(conn_timer_updated == 0)
					entry_path->ct->timeout.expires = last_used + interval;
				add_timer(&entry_path->ct->timeout);
				write_unlock_bh(&ip_conntrack_lock);
#endif
				return LR_FAILED;
			}
			break;
		}
	}			
	return LR_SUCCESS;
}

/* ==================================================================================================== */
uint8 *
FastPath_Route(ipaddr_t dIp)
{
	uint8 *ifname = NULL;
	uint32 mask_max = 0x0;
	struct Route_List_Entry *ep;
	/* Lookup */
	CTAILQ_FOREACH(ep, &route_list_inuse, tqe_link) {
		if ((ep->mask >= mask_max) && ((dIp & ep->mask) == ep->ip)) {
			ifname = &ep->ifname[0];
			mask_max = ep->mask;
		}
	}
	
	return ifname;
}


/* ==================================================================================================== */
#ifdef INVALID_PATH_BY_FIN
static void mark_path_invalid(uint32 sIp, uint16 sPort, uint32 dIp, uint16 dPort, uint16 iphProtocol)
{
	struct Path_List_Entry *entry_path;
	uint32 hash;
	uint32 extIp=0;
	uint16 extPort=0;
#if defined(PATH_CHAIN_HLIST)
	struct hlist_node *node;
#endif

	hash = FastPath_Hash_PATH_Entry(sIp, sPort, dIp, dPort, iphProtocol);	

#if defined(PATH_CHAIN_HLIST)
	hlist_for_each_entry(entry_path, node, &table_path[hash], path_link) {
#else
	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {					
#endif /* PATH_CHAIN_HLIST */
		if ((entry_path->in_sPort == sPort) && 
				(entry_path->in_dPort == dPort) && 
				(entry_path->in_sIp == sIp) &&
				(entry_path->in_dIp == dIp) &&
				(entry_path->vaild == 0xff)) {				
			entry_path->vaild = 0x00;
			if (entry_path->course == 1) {
				extIp = entry_path->out_sIp;
				extPort = entry_path->out_sPort;			
			}
			else {
				extIp = entry_path->out_dIp;
				extPort = entry_path->out_dPort;	
			}	
			break;
		}
	}
	if (extIp == 0)
		return;

	if (entry_path->course == 1)
		hash = FastPath_Hash_PATH_Entry(dIp, dPort, extIp, extPort, iphProtocol);
	else
		hash = FastPath_Hash_PATH_Entry(extIp, extPort, sIp, sPort, iphProtocol);
	
#if defined(PATH_CHAIN_HLIST)
	hlist_for_each_entry(entry_path, node, &table_path[hash], path_link) {
#else
	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {		
#endif /* PATH_CHAIN_HLIST */
		if ((entry_path->out_sIp == dIp) &&
				(entry_path->out_sPort == dPort) &&		
				(entry_path->out_dIp == sIp) &&
				(entry_path->out_dPort == sPort) &&
				(entry_path->vaild == 0xff)) 				
			entry_path->vaild = 0x00;					
	}
}
#endif // INVALID_PATH_BY_FIN

/* ==================================================================================================== */
        /* cached hardware header; allow for machine alignment needs.        */
#define HH_DATA_MOD     16
#define HH_DATA_ALIGN(__len) \
        (((__len)+(HH_DATA_MOD-1))&~(HH_DATA_MOD - 1))

#define UNCACHE_MASK            0x20000000
#define UNCACHE(addr)           ((UNCACHE_MASK)|(uint32)(addr))

static inline int ip_finish_output3(struct sk_buff *skb)
{
	struct dst_entry *dst;
	struct hh_cache *hh;

	dst = skb->dst;
	hh = dst->hh;

#if !defined(IMPROVE_QOS)
#if defined(CONFIG_NET_SCHED)
    if (gQosEnabled) {
		u_short proto = ntohs(skb->protocol);
		if(proto == ETH_P_IP){
			(list_empty(&nf_hooks[PF_INET][NF_IP_POST_ROUTING]))?: \
				ipt_do_table(skb, NF_IP_POST_ROUTING, skb->dev, NULL, \
				dev_net(skb->dev)->ipv4.iptable_mangle);
		}
    }        
#endif
#endif
	if (hh) {
// ------------------------------------------------
#if 1
		memcpy(skb->data - 16, hh->hh_data, 16);
#else
		memcpy((unsigned char*)UNCACHE(skb->data - 16), hh->hh_data, 16);
#endif
		skb_push(skb, hh->hh_len);

#ifdef FAST_L2TP		
		if (fast_l2tp_fw)
			l2tp_tx_id(skb);
#endif		

		if (skb->dev->flags & IFF_UP) {
#if defined(CONFIG_NET_SCHED)
			if (gQosEnabled) {
				// call dev_queue_xmit() instead of hard_start_xmit(), because I want the packets be sent through Traffic Control module
				dev_queue_xmit(skb);
				return 0;	
			} else            
#endif            
			{
			
		#if defined(CONFIG_BRIDGE)
				/*	In order to improve performance
				*	We'd like to directly xmit and bypass the bridge check
				*/
//				printk("[%s][%d]-[%s][0x%x][0x%x][0x%p]\n", __FUNCTION__, __LINE__, skb->dev->name, skb->dev->flags, skb->dev->priv_flags , skb->dev->netdev_ops->ndo_start_xmit);
				if (skb->dev->priv_flags == IFF_EBRIDGE)
				{
					/*	wan->lan	*/
					struct net_bridge *br = netdev_priv(skb->dev);
					const unsigned char *dest = skb->data;
					struct net_bridge_fdb_entry *dst;

					if ((dst = __br_fdb_get(br, dest)) != NULL)
					{
						skb->dev->stats.tx_packets++;
						skb->dev->stats.tx_bytes += skb->len;
						skb->dev = dst->dst->dev;
					}
				}
		#endif
				{
					//printk("[%s][%d]: src[0x%x]->dst[0x%x], -[%s][0x%x][0x%x][0x%p]\n", __FUNCTION__, __LINE__, ip_hdr(skb)->saddr, ip_hdr(skb)->daddr,skb->dev->name, skb->dev->flags, skb->dev->priv_flags , skb->dev->netdev_ops->ndo_start_xmit);
					if(!skb->dev->netdev_ops->ndo_start_xmit(skb,skb->dev))
						return 0;
				}
			}            
		}
//------------------------------- david+2007-05-25

	} else if (dst->neighbour) {
		//printk("[%s][%d]: src[0x%x]->dst[0x%x], -[%s][0x%x][0x%x][0x%p]\n", __FUNCTION__, __LINE__, ip_hdr(skb)->saddr, ip_hdr(skb)->daddr,skb->dev->name, skb->dev->flags, skb->dev->priv_flags , skb->dev->netdev_ops->ndo_start_xmit);
		return dst->neighbour->output(skb);
	}
//	else
//	{
//		printk("[%s][%d]: src[0x%x]->dst[0x%x], -[%s][0x%x][0x%x][0x%p]---------\n", __FUNCTION__, __LINE__, ip_hdr(skb)->saddr, ip_hdr(skb)->daddr,skb->dev->name, skb->dev->flags, skb->dev->priv_flags , skb->dev->netdev_ops->ndo_start_xmit);
//	}

#if 0	
	if (net_ratelimit())
		printk(KERN_DEBUG "ip_finish_output3: No header cache and no neighbour!\n");
#endif
	kfree_skb(skb);
	return -EINVAL;
}

__IRAM_GEN 
static int
enter_fast_path(struct sk_buff *skb)	/* Ethertype = 0x0800 (IP Packet) */
{
	
	struct iphdr *iph;	
	uint32 sIp,dIp;
	uint32 hash;
	struct tcphdr *tcphupuh;  //just keep one , don't care tcp or udp //
	struct Path_List_Entry *entry_path;
	uint16 sPort;
	uint16 dPort;
	uint16 iphProtocol;
	//u8 	protocol;
//	int has_inc_dst_ref_cnt;
	int need_l4cksm=1; //mark_add
#ifdef CONFIG_UDP_FRAG_CACHE
	int first_frag=0,last_frag=0; 
	int check_tcp_flag=0;
	struct Udp_FragCache_Entry *frag_entry =NULL; 
#endif

#ifdef FAST_L2TP
	struct net_device *l2tprx_dev;
	struct in_device *skbIn_dev;
	struct net_device *skbNetDevice;
#endif
#if defined(PATH_CHAIN_HLIST)
	struct hlist_node *node;
#endif

	iph = ip_hdr(skb);
	iphProtocol = iph->protocol;	

// check if skb len and protocol type in advance --
	if (iphProtocol != IPPROTO_TCP && iphProtocol != IPPROTO_UDP)
		return 0;	

#ifdef CONFIG_UDP_FRAG_CACHE 
#else	
	if (skb->len < sizeof(struct iphdr)+ sizeof(struct tcphdr))	
	{			
			return 0;
	}	
#endif		
			
//--------------------------------- david+2007-08-25

#ifdef FAST_L2TP
	if(fast_l2tp_fw){
		l2tprx_dev = skb->dev;
		skbIn_dev = (struct in_device *)skb->dev->ip_ptr;
		if(skbIn_dev == NULL){
			if ((skbNetDevice = __dev_get_by_name(&init_net,l2tprx_dev->name)) != NULL){
				//if((skbIn_dev= __in_dev_get_rtnl(skbNetDevice)) != NULL)
				if((skbIn_dev= (struct in_device*)skbNetDevice->ip_ptr) != NULL)
					skb->dev->ip_ptr = (void *)skbIn_dev;
			}
		}
	}
#endif	

	sIp = iph->saddr;
	dIp = iph->daddr;	
	

#if !defined(IMPROVE_QOS)
#if defined(CONFIG_NET_SCHED)
    if (gQosEnabled) {
		u_short proto = ntohs(skb->protocol);
		if(proto == ETH_P_IP){
			(list_empty(&nf_hooks[PF_INET][NF_IP_PRE_ROUTING]))?: \
				ipt_do_table(skb, NF_IP_PRE_ROUTING, skb->dev, NULL, \
				dev_net(skb->dev)->ipv4.iptable_mangle);
		}
    }
#endif
#endif

	//tcphupuh = tcp_hdr(skb);
	tcphupuh = (struct tcphdr*)((__u32 *)iph + iph->ihl);
	sPort = tcphupuh->source;
	dPort = tcphupuh->dest;
	
	//====
	switch (iphProtocol) {
		case IPPROTO_TCP: {		
			
			DEBUGP_PKT("==>> [%08X, %08X] SIP: %u.%u.%u.%u:%u  (%s) -> DIP: %u.%u.%u.%u:%u \n", 
				skb->csum, tcphupuh->check,
				NIPQUAD(iph->saddr), tcphupuh->source, skb->dev->name,
				NIPQUAD(iph->daddr), tcphupuh->dest);
			
			/* DONT care now! */
			if (!strcmp(skb->dev->name, "lo"))
			{
				//printk("###%s(%d)\n",__FUNCTION__,__LINE__);
				return 0;
			}
#ifdef CONFIG_UDP_FRAG_CACHE				
		if(iph->frag_off & 0x3fff){
			if(iph->frag_off == 0x2000)
				check_tcp_flag=1;
			else
				check_tcp_flag=0;
		}else
			check_tcp_flag=1;
		
		if(check_tcp_flag==1)
#endif			
		{
#ifdef INVALID_PATH_BY_FIN
			if (tcphupuh->fin) {
				mark_path_invalid(sIp, sPort, dIp, dPort, iphProtocol);
				return 0;	
			}
#endif			
			if (tcphupuh->fin || tcphupuh->rst || tcphupuh->syn) return 0;		
		}
#ifndef CONFIG_UDP_FRAG_CACHE			
			if (iph->frag_off & 0x3fff) return 0;	/* Ignore fragment */
#endif
			break;
		}
		case IPPROTO_UDP: {					
			DEBUGP_PKT("==>> [%08X, %08X] SIP: %u.%u.%u.%u:%u  (%s) -> DIP: %u.%u.%u.%u:%u <UDP> #0x%x\n", 
				skb->csum, tcphupuh->check,
				NIPQUAD(iph->saddr), tcphupuh->source, skb->dev->name,
				NIPQUAD(iph->daddr), tcphupuh->dest, iph->frag_off);
			
			/* DONT care now! */
			if (!strcmp(skb->dev->name, "lo")) return 0;
#ifndef CONFIG_UDP_FRAG_CACHE			
			if (iph->frag_off & 0x3fff) return 0;	/* Ignore fragment */		
#endif
			break;
		}
		default: {
			//printk("###%s(%d)\n",__FUNCTION__,__LINE__);
			return 0;
		}
	}

//================
	//it's a cache speed-up mechanism for UDP/TCP fragmentation 	
	//NOTE !!!! Because of no queuing , so we ignore those cases in mis-order UDP/TCP Frag packet process!!!
#ifdef CONFIG_UDP_FRAG_CACHE
			if (iph->frag_off & 0x3fff)
			{
				// Here it is commented because upNfmark and downNfmark is remembered at fastpath entry
				// So frag cache work for QoS here!
//#ifdef CONFIG_NET_SCHED	
//				if (gQosEnabled) //Frag cache is not work for QOS!!!!!
//					return 0;				
//#endif			
				if( iph->frag_off  == 0x2000 ) //more = 1, offset = 0 
					first_frag =1 ;
				else if( ( ( iph->frag_off & 0x2000 ) == 0 ) && (iph->frag_off & 0x1fff) ) //more =0 , offest !=0				
					last_frag = 1;	

				frag_entry = find_fragEntry(iph->id,iph->saddr,iph->daddr,iphProtocol);
				if(frag_entry) //if got information from cache ,then use it to do fastpath!!
				{						
					sPort = frag_entry->src_port;
					dPort = frag_entry->dst_port;
					if(!first_frag)
						need_l4cksm = 0; //important , dont modify L4 checksm besides first_frag !!!
				}
				else //if not cached ,all frag will go kenel besides first_frag.(to check if any chance to cache!!) 				
				{
					if(!first_frag)
					{
						//printk("###%s(%d)\n",__FUNCTION__,__LINE__);
						return 0;	
					}						
				}
			}
#endif


	//================
	hash = FastPath_Hash_PATH_Entry(sIp, sPort, dIp, dPort, iphProtocol);
#if defined(PATH_CHAIN_HLIST)
	hlist_for_each_entry(entry_path, node, &table_path[hash], path_link) {
#else
	CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link) {
#endif
			
		if ((entry_path->in_sPort == sPort) && 
			(entry_path->in_dPort == dPort) && 
			(entry_path->in_sIp == sIp) &&
			(entry_path->in_dIp == dIp) &&
			(entry_path->vaild == 0xff) && //david
			((entry_path->protocol==NP_TCP&&iphProtocol==IPPROTO_TCP)
			||(entry_path->protocol==NP_UDP&&iphProtocol==IPPROTO_UDP)))
		{
			__be16	*l4Check;
#ifndef NO_ARP_USED
			/* ARP Cache check */			
#ifndef FAST_L2TP
			if (entry_path->arp_entry && entry_path->arp_entry->vaild &&
				 (entry_path->arp_entry->ip == entry_path->out_dIp)) 
#else		
			int to_ppp0 = 0;
			if (fast_l2tp_fw && skb->dev && !memcmp(skb->dev->name, "br0", 3)) {				
//				if (entry_path->dst==NULL
//					|| atomic_read(&entry_path->dst->__refcnt)<2)
				{
					if (ip_route_input(skb, entry_path->out_dIp, iph->saddr, iph->tos, skb->dev))
					{
//						entry_path->dst = 0;
						//printk("###%s(%d)\n",__FUNCTION__,__LINE__);
						return 0;
					}
//					dst_release(skb->dst);
//					entry_path->dst = skb->dst;
//					has_inc_dst_ref_cnt = 1;					
				}
				if (skb->dst->input != &ip_local_deliver)
					to_ppp0 = 1;	
			}				
			if (to_ppp0 ||
				(entry_path->arp_entry && entry_path->arp_entry->vaild &&
					 (entry_path->arp_entry->ip == entry_path->out_dIp)))

#endif	
#endif
			{
//				rcu_read_lock_bh();
				/* ARP Cache valid */
//				if (entry_path->dst == NULL 
//					|| atomic_read(&entry_path->dst->__refcnt)<2)					
				{
					if(ip_route_input(skb, entry_path->out_dIp, iph->saddr, iph->tos, skb->dev))
					{
//						entry_path->dst = 0;
//						rcu_read_unlock_bh();
						//printk("###%s(%d)\n",__FUNCTION__,__LINE__);
						return 0;
					}
//					dst_release(skb->dst);
//					entry_path->dst = skb->dst;
//					dst_hold(skb->dst);  //brad go back original 
					//skb->dst->dst_cache = &entry_path->dst; //brad for debug
					
//					has_inc_dst_ref_cnt = 1;
				}
//				else 
//					skb->dst = entry_path->dst;				
				
// check if dst output is ok ----------------------------------------
				if ( !(skb->dst->hh || skb->dst->neighbour)  ||
							skb->len > dst_mtu(skb->dst))  {	
//					if (has_inc_dst_ref_cnt) //Brad go back original
//						dst_release(skb->dst);	//brad debug			
					
//					entry_path->dst = NULL;
//					printk("Frag pkt: %s(%d),skb->len(%d),mtu(%d)\n",__FUNCTION__,__LINE__,skb->len,dst_mtu(skb->dst));
					dst_release(skb->dst);
					skb->dst = NULL;
//					rcu_read_unlock_bh();	
				//printk("###%s(%d)\n",__FUNCTION__,__LINE__);
					return 0;				
				}				

//				if (!has_inc_dst_ref_cnt) {
//					dst_hold(skb->dst);		//Brad go back original 	
//					skb->dst->lastuse = jiffies;					
//				}
//---------------------------------------------- david+2007-05-18

				if (entry_path->protocol == NP_TCP)
				{
					/* tcp */
					l4Check = &(((struct tcphdr *)tcphupuh)->check);
				} 
				else
				{
					/* udp */
#if defined(UDP_ZERO_CHECKSUM)
					if ((((struct udphdr *)tcphupuh)->check))
						l4Check = &(((struct udphdr *)tcphupuh)->check);
					else
						l4Check = NULL;
#else
					l4Check = &(((struct udphdr *)tcphupuh)->check);
#endif
				}
				
#ifdef CONFIG_UDP_FRAG_CACHE
				if(first_frag)
				{
					if(!add_fragEntry(iph->id,sIp, sPort, dIp, dPort, iphProtocol))//add fail , return to kernel
						return 0;
				}	
				else if(last_frag)
				{				
					free_cache(frag_entry);
				}	
#endif				

				DEBUGP_PKT("Type[%d] FORWARD to [%s] [%s]\n", entry_path->type, entry_path->out_ifname, skb->dst->dev->name);
				switch(entry_path->type) {
				case 0:	{	/* Only Routing */
					break;
				}
				case 1:	{	/* SNAT */
									
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_sIp, iph->saddr, iph->check);					
					if(need_l4cksm)
					{ 
						if( entry_path->protocol == NP_UDP){
#if defined(UDP_ZERO_CHECKSUM)
							if (l4Check && (*l4Check) !=0)
#endif
							{
								FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_sIp, iph->saddr, *l4Check);
							}
						}
						else
						{
							FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_sIp, iph->saddr, *l4Check);
						}
					}
					iph->saddr = entry_path->out_sIp;
					break;
				}
				case 2:	/* SNPT */
				case 3:	{	/* SNAPT */
// Modify by Cathy suggestion,  david+2007-07-17								
//					FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_sIp, skb->nh.iph->saddr, entry_path->out_sPort, tcphupuh->source, iph->check);
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_sIp, iph->saddr, iph->check);
					if(need_l4cksm) 
					{
						if( entry_path->protocol == NP_UDP)
						{
#if defined(UDP_ZERO_CHECKSUM)
							if (l4Check && (*l4Check) !=0)
#endif
							{
								FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_sIp, iph->saddr, entry_path->out_sPort, tcphupuh->source, *l4Check);
							}
						}
						else
						{
							FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_sIp,iph->saddr, entry_path->out_sPort, tcphupuh->source, *l4Check);
						}
						tcphupuh->source		= entry_path->out_sPort;
					}
					iph->saddr	= entry_path->out_sIp;
					break;
				}
				case 4: {	/* DNAT */
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_dIp, iph->daddr, iph->check);
					if(need_l4cksm)
					{
						if( entry_path->protocol == NP_UDP)
						{
#if defined(UDP_ZERO_CHECKSUM)
							if (l4Check && (*l4Check) !=0)
#endif
							{
								FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_dIp, iph->daddr, *l4Check);
							}
						}
						else
						{
							FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_dIp, iph->daddr, *l4Check);
						}
					}
					iph->daddr	= entry_path->out_dIp;
					break;
				}
				case 8: /* DNPT */
				case 12: {	/* DNAPT */
// Modify by Cathy suggestion,  david+2007-07-17	
//					FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_dIp, skb->nh.iph->daddr, entry_path->out_dPort, tcphupuh->dest, iph->check);
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_dIp,iph->daddr, iph->check);
					if(need_l4cksm)
					{
						if( entry_path->protocol == NP_UDP)
						{
#if defined(UDP_ZERO_CHECKSUM)
							if (l4Check && (*l4Check) !=0)
#endif
							{
								FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_dIp,iph->daddr, entry_path->out_dPort, tcphupuh->dest, *l4Check);
							}
						}
						else
						{
							FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_dIp, iph->daddr, entry_path->out_dPort, tcphupuh->dest, *l4Check);
						}
						tcphupuh->dest		= entry_path->out_dPort;
					}
					iph->daddr	= entry_path->out_dIp;
					break;
				}
				default: {
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_sIp, iph->saddr, iph->check);
					FASTPATH_ADJUST_CHKSUM_NAT(entry_path->out_dIp, iph->daddr, iph->check);

					if(need_l4cksm) 
					{
						if( entry_path->protocol == NP_UDP)
						{
#if defined(UDP_ZERO_CHECKSUM)
							if (l4Check && (*l4Check) !=0)
#endif
							{
								FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_sIp, iph->saddr, entry_path->out_sPort, tcphupuh->source, *l4Check);
								FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_dIp, iph->daddr, entry_path->out_dPort, tcphupuh->dest, *l4Check);
							}
						}
						else
						{
								FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_sIp, iph->saddr, entry_path->out_sPort, tcphupuh->source, *l4Check);
								FASTPATH_ADJUST_CHKSUM_NAPT(entry_path->out_dIp, iph->daddr, entry_path->out_dPort, tcphupuh->dest, *l4Check);
						}
						tcphupuh->source	= entry_path->out_sPort;
						tcphupuh->dest		= entry_path->out_dPort;
					}
					
					iph->saddr	= entry_path->out_sIp;
					iph->daddr	= entry_path->out_dIp;
					break;
				}
				}

				skb->ip_summed = CHECKSUM_COMPLETE;				
				skb->dev = skb->dst->dev;
#if defined(IMPROVE_QOS)
#if defined(CONFIG_NET_SCHED)
				if(entry_path->course==1)
				{
					//Outbound
					if(ip_hdr(skb)->daddr==entry_path->out_dIp)
					{
						//LAN -> WAN
						skb->mark=entry_path->upNfmark;
					}
					else
					{
						//WAN->LAN
						skb->mark=entry_path->downNfmark;
					}
				}
				else
				{
					//Inbound
					if(iph->daddr==entry_path->out_sIp)
					{
						//LAN -> WAN
						skb->mark=entry_path->upNfmark;
					}
					else
					{
						//WAN->LAN
						skb->mark=entry_path->downNfmark;
					}
				}
#endif
#endif
				entry_path->last_used = jiffies;
#if 0 //defined(IMPROVE_QOS)
				{
					extern rwlock_t ip_conntrack_lock;
					write_lock_bh(&ip_conntrack_lock);
					if((entry_path)&&(entry_path->ct)&&(&entry_path->ct->timeout))
						mod_timer(&entry_path->ct->timeout,  (jiffies+entry_path->timeout));
					write_unlock_bh(&ip_conntrack_lock);
				}
#endif
#ifdef FAST_L2TP
				if (fast_l2tp_fw && skb->dev && (!memcmp(skb->dev->name, "ppp0", 4)) ) {
							if (fast_l2tp_to_wan(skb)) // success
							{
		//						rcu_read_unlock_bh();
								return NET_RX_DROP;
							}
		//					else
		//						rcu_read_unlock_bh();
				}
#endif		
				ip_finish_output3(skb);
//				rcu_read_unlock_bh();

				return NET_RX_DROP;
			}
#ifndef NO_ARP_USED
			else {
				/* Arp Cache update */
				struct Arp_List_Entry *ep;
				uint32 hash = FastPath_Hash_ARP_Entry(entry_path->out_dIp);				
				CTAILQ_FOREACH(ep, &table_arp->list[hash], arp_link) 
				{
					if (ep->ip == entry_path->out_dIp) {
						entry_path->arp_entry = ep;
						return 0;
					}
				}
			}
#endif
			break;
		}
	}			
	//===============================================================================	
	//===============================================================================
	//printk("###%s(%d)\n",__FUNCTION__,__LINE__);
	return 0;
}

int FastPath_Enter(struct sk_buff **pskb)
{
	int ret;
	struct sk_buff *skb;

	skb=*pskb;
	//skb->nh.raw = skb->data;
	skb->transport_header=skb->data;
	skb->network_header = skb->data;	
	//skb_reset_network_header(skb);
	
//hyking:
//bug fix:when port filter is enable,application will disable fast_nat_fw,at this moment,url filter is abnormal...
#if 1
#if defined (DOS_FILTER) || defined (URL_FILTER) 
		ret = filter_enter(skb);
		if (ret == NF_DROP) {		
			kfree_skb(skb);
			ret = 1;
			goto out;
		}
		if (ret != NF_ACCEPT)
		{
			ret = 0;
			goto out;
		}
#endif
#endif

	if (!fast_nat_fw)
	{
		ret = 0;
		goto out;
	}

#ifdef FILTER_UPNP_BR
		if (upnp_br_enabled && skb->dev && !memcmp(skb->dev->name, "eth1", 4) && filter_upnp_and_fw(skb)){
			ret = 1;
			goto out;
		}
#endif

#ifdef FAST_PPTP	
	if (fast_pptp_fw) {
#if	!defined(CONFIG_RTL865X_HW_PPTPL2TP)
		fast_pptp_filter(skb);
#endif
		ret = fast_pptp_to_lan(&skb);
		if (ret < 0)	// error, skb has been free
		{
			//ret = 1;
			return 1;
		}
		*pskb=skb;
	}	
#endif

#ifdef FAST_L2TP
	if (fast_l2tp_fw) 
		fast_l2tp_rx(skb);
#endif
//Brad disable
#if 0
	if (flush_table) {
		flush_all_table();
		flush_table = 0;
	}
#endif

	ret = enter_fast_path(skb);
#if 0
	if(ret != NET_RX_DROP)
	{
		struct tcphdr *tcpudph;
		printk("-------%s(%d),ret(%d), src(0x%x),dst(0x%x)\n",__FUNCTION__,__LINE__,ret,ip_hdr(skb)->saddr,ip_hdr(skb)->daddr);
		if(ip_hdr(skb)->protocol == IPPROTO_TCP)
		{
			tcpudph = (struct tcphdr*)((__u32 *)skb->data + ip_hdr(skb)->ihl);
			printk("===%s(%d),sport(%d),dport(%d),syn(%d),fin(%d),rst(%d)\n",__FUNCTION__,__LINE__,tcpudph->source,tcpudph->dest,tcpudph->syn,tcpudph->fin,tcpudph->rst);
		}
	}
#endif
#ifdef FAST_PPTP
	if (fast_pptp_fw && ret == 0 && ip_hdr(skb)->protocol == IPPROTO_GRE && skb->len > sizeof(struct iphdr)&& pptp_tcp_finished==1) 
		if(Check_GRE_rx_net_device(skb))
		{
			fast_pptp_sync_rx_seq(skb);
		}
#endif

out:
	return ret;
}

#ifdef	DEBUG_PROCFILE
/*
static int fastpath_forward_proc(char *buffer, char **start, off_t offset, int length)
{
	int len=0;
	len += sprnitf(buffer + len, "%d\n", fastpath_forward_flag);
	return len;
}
*/

#ifndef NO_ARP_USED
static int fastpath_table_arp(char *buffer, char **start, off_t offset, int length)
{
	struct Arp_List_Entry *ep;
	int len=0;
	
	CTAILQ_FOREACH(ep, &arp_list_inuse, tqe_link) {
		len += sprintf(buffer + len, "~Arp: ip=0x%08X mac=%02X:%02X:%02X:%02X:%02X:%02X flags=0x%08X \n", ep->ip, MAC2STR(ep->mac), ep->flags);
	}
	
	return len;
}
#endif

#ifndef DEL_ROUTE_TBL
static int fastpath_table_route(char *buffer, char **start, off_t offset, int length)
{
	struct Route_List_Entry *ep;
	int len=0;
	
	CTAILQ_FOREACH(ep, &route_list_inuse, tqe_link) {
		printk("~Route: ip=0x%08X mask=0x%08X gateway=0x%08X ifname=%-5s flags=0x%08X \n", 
			ep->ip, ep->mask, ep->gateway, ep->ifname, ep->flags);
	}
	
	return len;
}
#endif

#ifndef DEL_NAPT_TBL
static int fastpath_table_napt(char *buffer, char **start, off_t offset, int length)
{
	struct Napt_List_Entry *ep;
	int len=0;
#if defined(NAPT_CHAIN_HLIST)
	int i;
	struct hlist_node *node;
#endif
	
#if defined(NAPT_CHAIN_HLIST)
	for (i = 0; i < NAPT_TABLE_ENTRY_MAX; i++) {
		hlist_for_each_entry(ep, node, &table_napt[i], napt_link) {
#else
	CTAILQ_FOREACH(ep, &napt_list_inuse, tqe_link) {
#endif
		printk("~Napt: [%s] int=0x%08X:%-5u ext=0x%08X:%-5u rem=0x%08X:%-5u flags=0x%08X \n", 
			ep->protocol == NP_TCP ? "TCP" : "UDP",
			ep->intIp, ep->intPort, ep->extIp, ep->extPort, ep->remIp, ep->remPort,
			ep->flags);
#if defined(NAPT_CHAIN_HLIST)
		}
#endif
	}
	
	return len;
}
#endif

static int fastpath_table_path(char *buffer, char **start, off_t offset, int length)
{
	struct Path_List_Entry *ep;
	int len=0;
#if defined(PATH_CHAIN_HLIST)
	int i;
	struct hlist_node *node;
#endif
	//len+= sprintf(buffer,"entrys:\n");
	
#if defined(PATH_CHAIN_HLIST)
	for (i = 0; i < PATH_TABLE_LIST_MAX; i++) {
		hlist_for_each_entry(ep, node, &table_path[i], path_link) {
#else
	CTAILQ_FOREACH(ep, &path_list_inuse, tqe_link) {
#endif
		len += sprintf(buffer + len, "~Path: [%s] in-S=0x%08X:%-5u in-D=0x%08X:%-5u out-S=0x%08X:%-5u out-D=0x%08X:%-5u out-ifname=%-5s <%u> {%d}\n", 
		  //printk("Path: [%s] in-S=0x%08X:%-5u in-D=0x%08X:%-5u out-S=0x%08X:%-5u out-D=0x%08X:%-5u out-ifname=%-5s <%u> {%d}\n", 
			ep->protocol == NP_TCP ? "TCP" : "UDP",
			ep->in_sIp, ep->in_sPort, ep->in_dIp, ep->in_dPort,
			ep->out_sIp, ep->out_sPort, ep->out_dIp, ep->out_dPort,
			ep->out_ifname, ep->course, ep->type);
#if defined(PATH_CHAIN_HLIST)
		}
#endif
	}
	
	return len;
}

static int fastpath_hash_path(char *buffer, char **start, off_t offset, int length)
{
	int i, len=0;
#if defined(PATH_CHAIN_HLIST)
	int total;
	struct hlist_node *node;
#endif
	
	for (i=0; i<PATH_TABLE_LIST_MAX; i++) {
#if defined(PATH_CHAIN_HLIST)
		total = 0;
		hlist_for_each(node, &table_path[i]) total++;
		len += sprintf(buffer + len, "%5d ", total);
#else
		len += sprintf(buffer + len, "%5d ", CTAILQ_TOTAL(&table_path->list[i]));
#endif
		if (i%12 == 11) len += sprintf(buffer + len, "\n");
	}
	len += sprintf(buffer + len, "\n");	
	
	return len;
}

#endif	/* DEBUG_PROCFILE */

//======================================
// Flush napt and path table when re-init, david+2007-05-28
//((struct Path_List_Entry *)en)->dst->dst_cache = NULL;	\   //brad move here for debug
#define FLUSH_TBL(type, list_inuse, list_free, tbl, link, max, is_path) { \
	int i; \
	struct type *en;	\
	for (i=0; i<max; i++) { \
		CTAILQ_FOREACH(en, &tbl->list[i], link) { \
			if (is_path) { \
				if (((struct Path_List_Entry *)en)->dst) { \
					((struct Path_List_Entry *)en)->dst = NULL; \
				} \
				((struct Path_List_Entry *)en)->vaild = 0x00; \
			} \
			CTAILQ_REMOVE(&tbl->list[i], en, link); \
			CTAILQ_REMOVE(&list_inuse, en, tqe_link); \
			CTAILQ_INSERT_TAIL(&list_free, en, tqe_link); \
		} \
	} \
}

//Brad disable 
#if 0
static void flush_all_table(void)
{
	unsigned long flags;

	save_flags(flags); cli();	

#ifndef DEL_NAPT_TBL
	FLUSH_TBL(Napt_List_Entry, napt_list_inuse, napt_list_free, table_napt, napt_link, NAPT_TABLE_LIST_MAX, 0);
#endif
	FLUSH_TBL(Path_List_Entry, path_list_inuse, path_list_free, table_path, path_link, PATH_TABLE_LIST_MAX, 1);
	
  	restore_flags(flags);	
}
#endif
//======================================
#ifdef CONFIG_PROC_FS
static struct proc_dir_entry *res1=NULL;
static int read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
      int len = 0;

      len = sprintf(page, "%d\n", fast_nat_fw+10);
      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;

}
static int write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{      
	unsigned char tmpbuf[80];
	struct net *net;
	
	if (count < 2) 
		return -EFAULT;
	
	if (buffer && !copy_from_user(tmpbuf, buffer, 80))  {
#if 1
		if (tmpbuf[0] == '2'){ 
			for_each_net(net) {
				nf_conntrack_flush(net, 0, 0);		//clean conntrack table		
			}
		}else	 
#endif		
		{
			sscanf(tmpbuf, "%d", &fast_nat_fw);		
		}
		return count;     
	}
	  
	return -EFAULT;
}
#endif

//======================================
static int __init fastpath_init(void)
{
	int i;
#ifdef	DEBUG_PROCFILE
		struct proc_dir_entry *path;
		struct proc_dir_entry *fp_route;
		struct proc_dir_entry *fp_napt;
	struct proc_dir_entry *fp_route;
	struct proc_dir_entry *fp_napt;
#endif

#ifdef CONFIG_FAST_PATH_MODULE
	fast_path_hook=FastPath_Enter;
	FastPath_hook1=rtk_delRoute;
	FastPath_hook2=rtk_modifyRoute;
	FastPath_hook3=rtk_addRoute;
	FastPath_hook4=rtk_delNaptConnection;
	FastPath_hook5=rtk_addArp;
	FastPath_hook6=rtk_addNaptConnection;
	FastPath_hook7=rtk_delArp;
	FastPath_hook8=rtk_modifyArp;
	FastPath_hook9=Get_fast_pptp_fw;
	FastPath_hook10=fast_pptp_to_wan;
	FastPath_hook11=rtk_idleNaptConnection;
#endif

#ifdef	DEBUG_PROCFILE
	/* proc file for debug */
#ifndef NO_ARP_USED	
	proc_create("fp_arp", 0, NULL,fastpath_table_arp);
#endif
#ifndef DEL_ROUTE_TBL
	fp_route = create_proc_entry("fp_route",0,NULL);
	if(fp_route)
	{	
		fp_route->read_proc = fastpath_table_route;
	}
	//proc_create("fp_route", 0,NULL, fastpath_table_route);
#endif
#ifndef DEL_NAPT_TBL	
	fp_napt = create_proc_entry("fp_napt",0,NULL);
	if(fp_napt)
	{
		fp_napt ->read_proc = fastpath_table_napt;
	}
	//proc_create("fp_napt", 0, NULL,fastpath_table_napt);
#endif
	path = create_proc_entry("fp_path", 0, NULL);
	if(path)
	{
		path->read_proc = fastpath_table_path;
	}
	//proc_create("fp_hash_path", 0, NULL,fastpath_hash_path);
#endif	/* DEBUG_PROCFILE */
	
#ifndef NO_ARP_USED
	/* Arp-Table Init */
	table_arp = (struct Arp_Table *)kmalloc(sizeof(struct Arp_Table), GFP_ATOMIC);
	if (table_arp == NULL) {
		DEBUGP_SYS("MALLOC Failed! (Arp Table) \n");
		return -1;
	}
	CTAILQ_INIT(&arp_list_inuse);
	CTAILQ_INIT(&arp_list_free);
	for (i=0; i<ARP_TABLE_LIST_MAX; i++) {
		CTAILQ_INIT(&table_arp->list[i]);
	}
	/* Arp-List Init */
	for (i=0; i<ARP_TABLE_ENTRY_MAX; i++) {
		struct Arp_List_Entry *entry_arp = (struct Arp_List_Entry *)kmalloc(sizeof(struct Arp_List_Entry), GFP_ATOMIC);
		if (entry_arp == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Arp Table Entry) \n");
			return -2;
		}
		CTAILQ_INSERT_TAIL(&arp_list_free, entry_arp, tqe_link);
	}
#endif
	
#ifndef DEL_ROUTE_TBL
	/* Route-Table Init */
	table_route = (struct Route_Table *)kmalloc(sizeof(struct Route_Table), GFP_ATOMIC);
	if (table_route == NULL) {
		DEBUGP_SYS("MALLOC Failed! (Route Table) \n");
		return -1;
	}
	CTAILQ_INIT(&route_list_inuse);
	CTAILQ_INIT(&route_list_free);
	for (i=0; i<ROUTE_TABLE_LIST_MAX; i++) {
		CTAILQ_INIT(&table_route->list[i]);
	}
	/* Route-List Init */
	for (i=0; i<ROUTE_TABLE_ENTRY_MAX; i++) {
		struct Route_List_Entry *entry_route = (struct Route_List_Entry *)kmalloc(sizeof(struct Route_List_Entry), GFP_ATOMIC);
		if (entry_route == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Route Table Entry) \n");
			return -2;
		}
		CTAILQ_INSERT_TAIL(&route_list_free, entry_route, tqe_link);
	}
#endif

#ifndef DEL_NAPT_TBL
	/* Napt-Table Init */
#if defined(NAPT_CHAIN_HLIST)
	table_napt = (struct hlist_head *)kmalloc(
		sizeof(struct hlist_head) * NAPT_TABLE_LIST_MAX, GFP_ATOMIC);
#else
	table_napt = (struct Napt_Table *)kmalloc(sizeof(struct Napt_Table), GFP_ATOMIC);
#endif
	if (table_napt == NULL) {
		DEBUGP_SYS("MALLOC Failed! (Napt Table) \n");
		return -1;
	}
#if !defined(NAPT_CHAIN_HLIST)
	CTAILQ_INIT(&napt_list_inuse);
	CTAILQ_INIT(&napt_list_free);
	for (i=0; i<NAPT_TABLE_LIST_MAX; i++) {
		CTAILQ_INIT(&table_napt->list[i]);
	}
#else
	for (i=0; i<NAPT_TABLE_LIST_MAX; i++)
		INIT_HLIST_HEAD(&table_napt[i]);
#endif
	/* Napt-List Init */
	for (i=0; i<NAPT_TABLE_ENTRY_MAX; i++) {
		struct Napt_List_Entry *entry_napt = \
			(struct Napt_List_Entry *)kmalloc(sizeof(struct Napt_List_Entry), GFP_ATOMIC);
		if (entry_napt == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Napt Table Entry) \n");
			return -2;
		}
#if defined(NAPT_CHAIN_HLIST)
		hlist_add_head(&entry_napt->napt_link, &napt_list_free);
#else
		CTAILQ_INSERT_TAIL(&napt_list_free, entry_napt, tqe_link);
#endif
	}
#endif /* DEL_NAPT_TBL */
	
	/* Path-Table Init */
#if defined(PATH_CHAIN_HLIST)
	table_path = (struct hlist_head *)kmalloc(
		sizeof(struct hlist_head) * PATH_TABLE_LIST_MAX, GFP_ATOMIC);
#else
	table_path = (struct Path_Table *)kmalloc(sizeof(struct Path_Table), GFP_ATOMIC);
#endif
	if (table_path == NULL) {
		DEBUGP_SYS("MALLOC Failed! (Path Table) \n");
		return -1;
	}
#if !defined(PATH_CHAIN_HLIST)
	CTAILQ_INIT(&path_list_inuse);
	CTAILQ_INIT(&path_list_free);
	for (i=0; i<PATH_TABLE_LIST_MAX; i++) {
		CTAILQ_INIT(&table_path->list[i]);
	}
#else
	for (i=0; i<PATH_TABLE_LIST_MAX; i++)
		INIT_HLIST_HEAD(&table_path[i]);
#endif
	/* Path-List Init */
	for (i=0; i<PATH_TABLE_ENTRY_MAX; i++) {
		struct Path_List_Entry *entry_path = (struct Path_List_Entry *)kmalloc(sizeof(struct Path_List_Entry), GFP_ATOMIC);
		if (entry_path == NULL) {
			DEBUGP_SYS("MALLOC Failed! (Path Table Entry) \n");
			return -2;
		}
#if defined(PATH_CHAIN_HLIST)
		hlist_add_head(&entry_path->path_link, &path_list_free);
#else
		CTAILQ_INSERT_TAIL(&path_list_free, entry_path, tqe_link);
#endif
	}
#ifdef CONFIG_UDP_FRAG_CACHE
	if(!udp_fragCache_init())
		return -1;
#endif

/*David, 20100818*/
#if defined (DOS_FILTER) || defined (URL_FILTER) 
	filter_init();
#endif

#ifdef FAST_PPTP
	fast_pptp_init();
#endif

#ifdef FAST_L2TP
	fast_l2tp_init();
#endif

#ifdef CONFIG_PROC_FS
	res1=create_proc_entry("fast_nat",0,NULL);
	if (res1) {
	    res1->read_proc=read_proc;
	    res1->write_proc=write_proc;
	}
#endif

	//printk("%s %s\n",MODULE_NAME, MODULE_VERSION);
	
	return 0;
}

static void __exit fastpath_exit(void)
{
#ifdef CONFIG_FAST_PATH_MODULE
	fast_path_hook=NULL;
	FastPath_hook1=NULL;
	FastPath_hook2=NULL;
	FastPath_hook3=NULL;
	FastPath_hook4=NULL;
	FastPath_hook5=NULL;
	FastPath_hook6=NULL;
	FastPath_hook7=NULL;
	FastPath_hook8=NULL;
	FastPath_hook9=NULL;
	FastPath_hook10=NULL;
	FastPath_hook11=NULL;
#endif

/*David, 20100818*/
#if defined (DOS_FILTER) || defined (URL_FILTER) 
	filter_exit();
#endif

#ifdef FAST_PPTP
	fast_pptp_exit();
#endif

#ifdef CONFIG_PROC_FS
	if (res1) {
		remove_proc_entry("fast_nat", res1);		
		res1 = NULL;
	}
#endif

	//printk("%s %s removed!\n", MODULE_NAME, MODULE_VERSION);
}

module_init(fastpath_init);
module_exit(fastpath_exit);
MODULE_LICENSE("GPL");

/*
2006-08/29:
	! Ignore TCP packet with FIN/RST/SYN flag (OR).
	! Ignore fragment of UDP packet.
2006-08/28:
	! NAT/NAPT bug fixed(RNAT/RNAPT NOT Working).
*/

