#ifdef FASTPATH_FILTER
#include <linux/module.h>	
#include <linux/proc_fs.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/kernel_stat.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/slab.h>
#include <asm/uaccess.h>
#include <linux/net.h>
#include <linux/socket.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/string.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/sock.h>
#include <net/arp.h>
#include <net/raw.h>
#include <net/checksum.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netlink.h>
#include <linux/inetdevice.h>
#include <linux/icmp.h>
#include <net/udp.h>
#include <net/tcp.h>//brad
#include "fastpath_core.h"

#include <common/rtl865x_netif.h>
#include <common/rtl865x_netif_local.h>
#ifdef CONFIG_RTL_LAYERED_ASIC_DRIVER
#include <AsicDriver/rtl865x_asicCom.h>
#include <AsicDriver/rtl865x_asicL2.h>
#else
#include <AsicDriver/rtl865xC_tblAsicDrv.h>
#endif
//#endif

///////////////////////////////////////////////////////////////////////////
#ifdef URL_CONTENT_AUTHENTICATION
#include <asm/semaphore.h>
#include <linux/wait.h>
#endif

static char get_info_from_usr_space[1024];

/*
return value:
	0 don't need filter
	1 need filter
*/
int need_filter(struct sk_buff *skb)
{
	struct iphdr *iph;
	struct in_device *in_dev;
	struct in_ifaddr **ifap = NULL;
	struct in_ifaddr *ifa = NULL;
	struct net_device *landev;
	struct net_device *wandev;
	
	iph=ip_hdr(skb);
	
	if ((landev = __dev_get_by_name(&init_net,"br0")) != NULL)
	{
	     	ifa =NULL;		
		if ((in_dev=__in_dev_get_rcu(landev)) != NULL) 
		{
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) 
			{
				if (strcmp("br0", ifa->ifa_label) == 0)
				{
					break; 
				}
			}		
		//accept the http packet if the dest ip is our lan ip, always
			if(ifa != NULL)
			{
				if(iph->daddr == ifa->ifa_address)
				{					
					return 0;
				}
			}
		}
	}

	if ((wandev = __dev_get_by_name(&init_net,"ppp0")) != NULL){
      		ifa =NULL;
		if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) {
			for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
				if (strcmp("ppp0", ifa->ifa_label) == 0){
					break; 
				}
			}
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa !=NULL){
				if(iph->daddr == ifa->ifa_local){
					return 0;
				}
			}
		}
	}else if ((wandev = __dev_get_by_name(&init_net,"eth1")) != NULL){
			ifa =NULL;
			if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) {
				for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
					if (strcmp("eth1", ifa->ifa_label) == 0){
						break; 
					}
				}
			//accept the http packet if the dest ip is our wan ip, always
			if(ifa != NULL){
				if(iph->daddr == ifa->ifa_address){
					return 0;
				}
			}
		}
	}
	else if ((wandev = __dev_get_by_name(&init_net,"wlan0")) != NULL){
			ifa =NULL;
      			if ((in_dev=__in_dev_get_rcu(wandev)) != NULL) {
      				for (ifap=&in_dev->ifa_list; (ifa=*ifap) != NULL; ifap=&ifa->ifa_next) {
					if (strcmp("wlan0", ifa->ifa_label) == 0){
						break; 
					}
				}
				//accept the http packet if the dest ip is our wan ip, always
				if(ifa !=NULL){
					if(iph->daddr == ifa->ifa_address){
						return 0;
					}
				}
		}
	}
	return 1;
}
#if 0
#if 0
/**
*Ip range filter:
* flag 
*	0: src ipaddress
*	1: dst ipaddress
*/
static int rtl_isInipRange_fastpath(struct list_head *listhead, ipaddr_t ipAddr,uint32 flag)
{
	//printk("%s-----%d\n",__FUNCTION__,__LINE__);
	int ret = 0, match_action=0;	
 	rtl_ipRange_fastpath *entry=NULL;
	struct list_head *lh;	

	if(filter_table_cnt[0]==0) return 0;
	
	list_for_each(lh, &filter_table_entry[0].filter_items)
 	{
		entry=list_entry(lh, rtl_ipRange_fastpath, list);
		/*flag 0: src */
		if((flag == 0) )
		{
			if((entry->flag & 0x1 <<2)|| (!(entry->flag & 0x1 <<1)))
			{
				if(entry->addr_start<= ipAddr && entry->addr_end>= ipAddr)
				{
					ret = 1;
					match_action=entry->flag & 0x1;
					break;
				}
			}
		}	
		else
		{/*flag 1: dest */
			if((entry->flag & 0x1 <<2)|| (entry->flag & 0x1 <<1))
			{
				if(entry->addr_start<= ipAddr && entry->addr_end>= ipAddr)
				{
					ret = 1;
					match_action=entry->flag & 0x1;
					break;
				}
			}	
		}
		continue;
	}
	printk("ret=%d	match_actionr=%d\n",ret,match_action);
	#if 1
	if(ret)
	{
		return match_action?0:1;
	}
	else
	{
		return 0;
	}	
	#else
	return ret;
	#endif
}
#endif
/**
* mac address
*/
#endif
static int scan_sch_url_tbl(const char *data, size_t dlen, const char *pattern, size_t plen, char term)
{
	int i;
	if(pattern[plen] == '\0')
	{
		plen--;
	}
	if(plen > dlen)
	  	return 0;
	for(i=0; data[i+plen] !=term ;i++)
	{
	      if(memcmp(data + i, pattern, plen)!=0)
		      continue;
	      else
			return 1;
	}
  return 0;
}

unsigned long str2hexnum(unsigned char *p)
{
  unsigned long val=0;
  unsigned long c=0;
  for(val=0;*p!='\0';val=(val<< 4 ) + c, p++)
  {
     c=*p;
     if(c >= '0' && c <='9')
	   c=c-'0';
     else if(c >='a' && c <='f')
	   c=c-'a'+10;
     else if(c >='A' &&  c<='F')
	 	c=c-'A'+10;
     else
	   break;
  }
  return val;

}

static int find_pattern(const char *data, size_t dlen, const char *pattern, size_t plen, char term, unsigned int *numoff, unsigned int *numlen)
{
	size_t i,j,k;
	int state =0;
	*numoff = *numlen=0;
	for(i=0; i <= (dlen -plen);i++)
	{
	      if (*(data + i) == '\r')
	      {
            	  if (!(state % 2)) state++;  /* forwarding move */
              	  else state = 0;             /* reset */
              }
	      else if (*(data + i) == '\n')
	      {
	          if (state % 2) state++;
	          else state = 0;
              }
              else state = 0;

	      if (state >= 4)
	           break;
	      if(memcmp(data + i, pattern, plen)!=0)
		      continue;
	      *numoff=i + plen;
	      for (j = *numoff, k = 0; data[j] != term; j++, k++)
	        if (j > dlen) return 0 ;   /* no terminal char */
	      *numlen = k;
	      return 1;
		      
	}
 return 0;

}

/**
* url/keywords filter
*/
int rtl_url_filter_fastpath(struct sk_buff *skb, void *data1)
{
	if(strlen(data1) <=1) return 0;
	struct iphdr *iph;
 	struct tcphdr *tcph;
	iph=ip_hdr(skb);
	if(iph->protocol == IPPROTO_TCP)
		tcph = (struct tcphdr *)((void *)iph + iph->ihl*4);
	else
		return 0;

	unsigned char *data = (void *)tcph + tcph->doff*4;
	int found=0, offset,hostlen,pathlen;
	int datalen,i;
	char str[2048];
 	int ret;
	datalen= ntohs(iph->tot_len) -(iph->ihl*8);
	if(memcmp(data, "GET ",sizeof("GET ") -1)!=0)
	{
		return 0;
	}
	found = find_pattern(data,datalen,"Host: ",sizeof("Host: ")-1,'\r',&offset, &hostlen);
	if(!found)
		return 0;
	strncpy(str,data+offset,hostlen);
	*(str+hostlen)=0;
	found = find_pattern(data,datalen,"GET ",sizeof("GET ")-1,'\r',&offset, &pathlen);
        if (!found || (pathlen -= (sizeof(" HTTP/x.x") - 1)) <= 0)
		return 0;	
	strncpy(str+hostlen,data+offset,pathlen);
	*(str+hostlen+pathlen)='\0';
	//printk("data1=%d, str=%s\n",strlen(data1),str);
	ret=scan_sch_url_tbl(str,strlen(str),data1,strlen(data1),'\0');	
	//printk("[%d]-------ret=%d\n",__LINE__,ret);
	return ret?1:0;
}
#if 0
static int iprange_fastpast_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
	
	printk("filter_table_cnt[0]=%x\n",filter_table_cnt[0]);
	if(filter_table_cnt[0] <= 0) return 0;
	
	int i;
	rtl_ipRange_fastpath *entry=NULL;
	struct list_head *lh;
#if 1
	list_for_each(lh, &filter_table_entry[0].filter_items)
	{		
		entry=list_entry(lh, rtl_ipRange_fastpath, list);
		
		printk("flag=%x\n",entry->flag);
		printk("addr_start=%x\n",entry->addr_start);
		printk("addr_end=%x\n",entry->addr_end);
	
	}
#endif	
	return 0;
}
/*
Input format:
startip endip action flag
action: 0 block; 1 forwarding
flag: 
	bit 0: 0 src ip; 1 dest ip
	bit 1: 1 both direction; 0 refer bit 0
For example:
	echo "c0a80175 c0a80185 0 0" > /proc/iprange_filter_fastpast
*/
static int iprange_fastpast_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      	char tmpbuf[1024];
      	char *tokptr, *entryptr,*strptr=tmpbuf;
      	rtl_ipRange_fastpath *entry;
	int i,action;
		
	memset(get_info_from_usr_space,0,strlen(get_info_from_usr_space));
      	if (buffer && !copy_from_user(&get_info_from_usr_space, buffer, count))
 	{
	     	strncpy(tmpbuf,get_info_from_usr_space,count);
	      	tmpbuf[strlen(get_info_from_usr_space)]='\0';	
		//printk("tmpbuf=%s\n",tmpbuf);

		entry = NULL;
		entry = kmalloc(sizeof(rtl_ipRange_fastpath),GFP_KERNEL);		
		if(entry == NULL)
		{
			printk("Not enough memory for iprange filter...\n");
			return count;
		}	
		
		//init entry
		INIT_LIST_HEAD(&entry->list);
		entryptr = strsep(&strptr,";");

		if(filter_table_cnt[0] > RTL_TABLE_FILTER_ENTRY_COUNT) 
		{
			printk("entry is FULL\n");
			return RTL_TABLE_FILTER_ENTRY_COUNT;
		}
		
		//start ip
		tokptr = strsep(&entryptr," ");
		entry->addr_start=str2hexnum(tokptr);
		//printk("entry->addr_start=%x\n",entry->addr_start);
		//end ip
		tokptr = strsep(&entryptr," ");
		entry->addr_end=str2hexnum(tokptr);
		//printk("entry->addr_end=%x\n",entry->addr_end);
		//flag: action 1: pass;0: block
		tokptr = strsep(&entryptr," ");
		entry->flag =0;
		entry->flag |=(0x1 << 8);
		entry->flag |= str2hexnum(tokptr) ;
		//flag: 0 src ip;1 dest ip;2/3 both direction
		tokptr = strsep(&entryptr," ");
		entry->flag |=(str2hexnum(tokptr) & 0x3) << 1;
		//printk("entry->flag=%x\n",entry->flag);
			
		list_add(&entry->list,&filter_table_entry[0].filter_items);
		filter_table_cnt[0]++;
		
    		return count;
     	}
_err:		
      	return -EFAULT;
}
static int url_fastpast_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
	printk("filter_table_cnt[1]=%x\n",filter_table_cnt[1]);
	if(filter_table_cnt[1] <= 0) return 0;
	
	int i;
	rtl_url_entry_fastpath *entry=NULL;
	struct list_head *lh;
	list_for_each(lh, &filter_table_entry[1].filter_items)
	{		
		entry=list_entry(lh, rtl_url_entry_fastpath, list);
		
		printk("flag=%x\n",entry->flag);
		printk("url_content=%s\n",entry->url_content);	
	}
	return 0;
}
static int url_fastpast_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      	char tmpbuf[1024];
      	char *tokptr, *entryptr,*strptr=tmpbuf;
      	rtl_url_entry_fastpath *entry;
	int i,action;
		
	memset(get_info_from_usr_space,0,strlen(get_info_from_usr_space));
      	if (buffer && !copy_from_user(&get_info_from_usr_space, buffer, count))
 	{
	     	strncpy(tmpbuf,get_info_from_usr_space,count);
	      	tmpbuf[strlen(get_info_from_usr_space)]='\0';	
		printk("tmpbuf=%s\n",tmpbuf);
		
		do{
			entry = kmalloc(sizeof(rtl_url_entry_fastpath),GFP_KERNEL);		
			if(entry == NULL)
			{
				printk("Not enough memory for iprange filter...\n");
				return count;
			}	
			entryptr = strsep(&strptr,";");
			printk("entryptr=%s\n",entryptr);
			tokptr = strsep(&entryptr," ");
			entry->flag = str2hexnum(tokptr);
			printk("tokptr=%s\n",tokptr);
			tokptr = strsep(&entryptr," ");
			if(tokptr == NULL)
			{
				kfree(entry);
				break;
			}
			strncpy(entry->url_content,tokptr, strlen(tokptr)>RTL_URL_FILTER_CONTENT_MAXNUM_FASTPATH?RTL_URL_FILTER_CONTENT_MAXNUM_FASTPATH : strlen(tokptr));
			printk("tokptr=%s\n",tokptr);
			list_add(&entry->list,&filter_table_entry[1].filter_items);
			filter_table_cnt[1]++;
		}while(strptr!=NULL);
    		return count;
     	}
_err:		
      	return -EFAULT;
}		

typedef struct _rtl_mac_entry_fastpath
{
	struct list_head list;
	char mac[ETHER_ADDR_LEN];
	uint8 flag; 
}rtl_mac_entry_fastpath;

static int mac_fastpast_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
	printk("filter_table_cnt[1]=%x\n",filter_table_cnt[2]);
	if(filter_table_cnt[2] <= 0) return 0;
	
	int i;
	rtl_mac_entry_fastpath *entry=NULL;
	struct list_head *lh;
	list_for_each(lh, &filter_table_entry[2].filter_items)
	{		
		entry=list_entry(lh, rtl_mac_entry_fastpath, list);
		printk("flag=%x\n",entry->flag);
		printk("mac=%02x:%02x:%02x:%02x:%02x:%02x\n",entry->mac[0],entry->mac[1],entry->mac[2],entry->mac[3],entry->mac[4],entry->mac[5]);	
	}
	return 0;
}
static int mac_fastpast_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      	char tmpbuf[1024];
      	char *tokptr, *entryptr,*strptr=tmpbuf,*mac_ptr;
      	rtl_mac_entry_fastpath *entry;
	int i,action;
		
	memset(get_info_from_usr_space,0,strlen(get_info_from_usr_space));
      	if (buffer && !copy_from_user(&get_info_from_usr_space, buffer, count))
 	{
	     	strncpy(tmpbuf,get_info_from_usr_space,count);
	      	tmpbuf[strlen(get_info_from_usr_space)]='\0';	
		printk("tmpbuf=%s\n",tmpbuf);	

		do{
			entry = kmalloc(sizeof(rtl_mac_entry_fastpath),GFP_KERNEL);		
			if(entry == NULL)
			{
				printk("Not enough memory for iprange filter...\n");
				return count;
			}	
			entryptr = strsep(&strptr,";");
			printk("entryptr=%s\n",entryptr);
			
			tokptr = strsep(&entryptr," ");
			entry->flag = str2hexnum(tokptr);			
			printk("tokptr=%s\n",tokptr);
			
			tokptr = strsep(&entryptr," ");
			if(tokptr == NULL)
			{
				kfree(entry);
				break;
			}
			printk("tokptr=%s\n",tokptr);
			i=0;
			mac_ptr = strsep(&tokptr,"-");
			while(mac_ptr)
			{
				entry->mac[i]= str2hexnum(mac_ptr);
				printk("mac%d=%02x\n",i,entry->mac[i]);
				mac_ptr = strsep(&tokptr,"-");
				i++;
			}
			
			list_add(&entry->list,&filter_table_entry[2].filter_items);
			filter_table_cnt[2]++;
		}while(strptr!=NULL);
		
    		return count;
     	}
_err:		
      	return -EFAULT;
}

typedef struct _rtl_sch_entry_fastpath
{
	struct list_head list;
	uint32 	weekMask; /*bit0: sunday, bit 1: monday, .... bit 6 saturday, bit7: (1: all days, monday~sunday)*/
	uint32 	startTime; /*minutes, ex. 5:21 = 5*60+21 minutes*/
	uint32 	endTime; /*minutes*/
	uint8 	allTimeFlag;/*if alltime(00:00~23:59:59), please set this flag...*/
	uint8 	flag; /* bit0( 0: deny, 1: allow), bit1( 1:block all http packet), bit2(0:default deny; 1: default allow)*/
}rtl_sch_entry_fastpath;

static int schedule_fastpast_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
	printk("filter_table_cnt[3]=%x\n",filter_table_cnt[3]);
	if(filter_table_cnt[3] <= 0) return 0;
	
	int i;
	rtl_sch_entry_fastpath *entry=NULL;
	struct list_head *lh;
	list_for_each(lh, &filter_table_entry[3].filter_items)
	{		
		entry=list_entry(lh, rtl_sch_entry_fastpath, list);
		printk("flag=%x	all=%x	week=%x start=%d end=%d\n",entry->flag,entry->allTimeFlag,entry->weekMask,entry->startTime,entry->endTime);
	}
	return 0;
}
/**
* [flag all_flag week start end]
* [1 0 7 97 120]
*/
static int schedule_fastpast_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      	char tmpbuf[1024];
      	char *tokptr, *entryptr,*strptr=tmpbuf;
      	rtl_sch_entry_fastpath *entry;
	int i,action;
		
	memset(get_info_from_usr_space,0,strlen(get_info_from_usr_space));
      	if (buffer && !copy_from_user(&get_info_from_usr_space, buffer, count))
 	{
	     	strncpy(tmpbuf,get_info_from_usr_space,count);
	      	tmpbuf[strlen(get_info_from_usr_space)]='\0';	
		printk("tmpbuf=%s\n",tmpbuf);	
		do{
			entry = kmalloc(sizeof(rtl_sch_entry_fastpath),GFP_KERNEL);		
			if(entry == NULL)
			{
				printk("Not enough memory for iprange filter...\n");
				return count;
			}	
			entryptr = strsep(&strptr,";");
			printk("entryptr=%s\n",entryptr);
			
			tokptr = strsep(&entryptr," ");
			entry->flag = str2hexnum(tokptr);			
			printk("tokptr=%s\n",tokptr);
			
			tokptr = strsep(&entryptr," ");
			entry->allTimeFlag= str2hexnum(tokptr);			
			printk("tokptr=%s\n",tokptr);

			tokptr = strsep(&entryptr," ");
			entry->weekMask= str2hexnum(tokptr);			
			printk("tokptr=%s\n",tokptr);

			tokptr = strsep(&entryptr," ");
			entry->startTime= str2hexnum(tokptr);			
			printk("tokptr=%s\n",tokptr);

			tokptr = strsep(&entryptr," ");
			entry->endTime= str2hexnum(tokptr);			
			printk("tokptr=%s\n",tokptr);
			
			list_add(&entry->list,&filter_table_entry[3].filter_items);
			filter_table_cnt[3]++;
		}while(strptr!=NULL);
    		return count;
     	}
_err:		
      	return -EFAULT;
}


static struct proc_dir_entry *res8=NULL;
int iprange_filter_init_fastpath(void)
{
	res8 = create_proc_entry("iprange_filter_fastpath", 0, NULL);
	if (res8) {
	    res8->read_proc = iprange_fastpast_read_proc;
	    res8->write_proc = iprange_fastpast_write_proc;
      }
	filter_table_cnt[0]=0;
	INIT_LIST_HEAD(&filter_table_entry[0].filter_table);
	INIT_LIST_HEAD(&filter_table_entry[0].filter_items);
	return 0;
}


static struct proc_dir_entry *res9=NULL;
int url_filter_init_fastpath(void)
{
	res9 = create_proc_entry("url_filter_fastpath", 0, NULL);
       Add_Pattern_ACL_For_ContentFilter();
	if (res9) {
	    res9->read_proc = url_fastpast_read_proc;
	    res9->write_proc = url_fastpast_write_proc;
      }
	filter_table_cnt[1]=0;
	INIT_LIST_HEAD(&filter_table_entry[1].filter_table);	//add
	INIT_LIST_HEAD(&filter_table_entry[1].filter_items);
	INIT_LIST_HEAD(&url_table_head.list);	
	url_table_head.func=rtl_url_filter_fastpath;
	return 0;
}

static struct proc_dir_entry *res10=NULL;
int mac_filter_init_fastpath(void)
{
	res10 = create_proc_entry("mac_filter_fastpath", 0, NULL);
	if (res10) {
	    res10->read_proc = mac_fastpast_read_proc;
	    res10->write_proc = mac_fastpast_write_proc;
      }
	filter_table_cnt[2]=0;
	INIT_LIST_HEAD(&filter_table_entry[2].filter_table);
	INIT_LIST_HEAD(&filter_table_entry[2].filter_items);
	return 0;
}

int schedule_filter_init_fastpath(void)
{
	res10 = create_proc_entry("schedule_filter_fastpath", 0, NULL);
	if (res10) {
	    res10->read_proc = schedule_fastpast_read_proc;
	    res10->write_proc = schedule_fastpast_write_proc;
      }
	filter_table_cnt[3]=0;
	INIT_LIST_HEAD(&filter_table_entry[3].filter_table);
	INIT_LIST_HEAD(&filter_table_entry[3].filter_items);
	return 0;
}
#endif
//////////////////////////////////////////////
//
int rtl_mac_filter_fastpath(struct sk_buff *skb,void *data)
{	
	int i;
	char *smac = data;
	
	for(i = 0; i<ETHER_ADDR_LEN;i++)
	{
		if((smac[i] & 0xff) != skb_mac_header(skb)[ETHER_ADDR_LEN+i])
			break;		
	}
	//printk("%s---i=%d\n",__FUNCTION__,i);	
	if(i == ETHER_ADDR_LEN)
		return 1;
	else 
		return 0;
}

//////////////////////////////////////////////
//
static uint32 rtl_ip_range_filter_fastpath(struct sk_buff *skb,void *data)
{
	struct iphdr *iph;
	uint32 *start,*end;

	iph=ip_hdr(skb);
	start=(uint32 *)data;
	end=(uint32 *)(data+4);
//	printk("Source=%u.%u.%u.%u[%s]\n",NIPQUAD(iph->saddr),__FUNCTION__);
//	printk("Source=0x%x, start=0x%x, end=0x%x\n",iph->saddr,*start,*end);

	if(*start<= iph->saddr && *end>= iph->saddr)
	{
		return 1;
	}
	return 0;
}

//////////////////////////////////////////////
//
static uint32 rtl_schedule_filter_fastpath(struct sk_buff *skb,void *data)
{
	struct timeval tv;
	uint32 today, hour,minute;
	uint32 curtime;
	uint32 *start,*end,*day;

	start=(uint32 *)data;
	end=(uint32 *)(data+4);
	day=(uint32 *)(data+8);
	/*get system time*/
	do_gettimeofday(&tv);
	today = ((tv.tv_sec/86400) + 4)%7;
#if (defined(CONFIG_RTL8186_KB_N) ||defined(CONFIG_RTL8186_KB))	
	hour = ((tv.tv_sec/3600)+16)%24;
#else
	hour = (tv.tv_sec/3600)%24;
#endif
	minute = (tv.tv_sec/60)%60;
	curtime = hour * 60 + minute;
//	printk("start=0x%x, end=0x%x, day=%x\n",*start,*end,*day);
//	printk("hour=%d, today=0x%x\n",hour,today);
	
	if((*day & (0x1 << 7)) || (*day & (0x1 << today)))
	{//day		
		if( ((*start == 0 ) && (*end == 0)) || ((*start <= curtime) && (curtime <=*end)))
		{//sch
			//printk("%s---1--%d\n",__FUNCTION__,__LINE__);
			return 1;
		}
	}
	//printk("%s--0---%d\n",__FUNCTION__,__LINE__);
	return 0;
}

filter_table_info filter_tlb[]={
	{0,NULL},
	{IP_RANGE_TABLE, rtl_ip_range_filter_fastpath},
	{MAC_TABLE, rtl_mac_filter_fastpath},
	{URL_KEY_TABLE, rtl_url_filter_fastpath},
	{SCHEDULT_TABLE, rtl_schedule_filter_fastpath}
};

static uint32 filter_rule_num;
static filter_table_list table_list_head;

int filter_table_head_init(void)
{
	memset(&table_list_head,0,sizeof(filter_table_list));
	
	INIT_LIST_HEAD(&table_list_head.table_list);
	INIT_LIST_HEAD(&table_list_head.item_list);
	table_list_head.type=0;
	table_list_head.flag=0;
	table_list_head.func=NULL;
	table_list_head.num=1;
	
	return 0;
}

int filter_table_regist(int type, void * func)
{
	filter_table_list *entry;
	//printk("%s-----%d\n",__FUNCTION__,__LINE__);
	if(table_list_head.num==0)
	{
		filter_table_head_init();
	}
	
	if(type == URL_KEY_TABLE)
	{
		extern int  Add_Pattern_ACL_For_ContentFilter(void);
		Add_Pattern_ACL_For_ContentFilter();
	}
	
	entry = kmalloc(sizeof(filter_table_list),GFP_KERNEL);	

	entry->type=type;
	entry->flag=0;
	entry->num=1;
	entry->func=func;//need regist
	INIT_LIST_HEAD(&entry->table_list);
	INIT_LIST_HEAD(&entry->item_list);

	list_add(&entry->table_list,&table_list_head.table_list);
	table_list_head.num++;
	return 0;
}

int filter_table_flush(int flag)
{
	struct list_head *lh,*lh2,*lh2_next;
	filter_table_list *entry,*entry_next;
	filter_item_entry *entry_item,*entry_item_next;
	list_for_each_entry_safe(entry, entry_next,&table_list_head.table_list,table_list)
	{		
		list_for_each_entry_safe(entry_item, entry_item_next,&entry->item_list,item_list)
		{				
			list_del(&entry_item->item_list);
			kfree(entry_item);
			entry->num--;
		}
		list_del(&entry->table_list);
		kfree(entry);
		table_list_head.num--;
	}
	filter_rule_num=1;
	return 0;
}

//rtl_url_filter_fastpath
int filter_item_regist(int type, struct list_head * new_item)
{
	struct list_head *lh;
	filter_table_list *entry;
	
	list_for_each(lh, &table_list_head.table_list)
	{		
		entry=list_entry(lh, filter_table_list, table_list);
		if(entry->type == type)
		{
			list_add(new_item,&entry->item_list);
			entry->num++;
			return 0;
		}
	}
	//printk("%s-----%d\n",__FUNCTION__,__LINE__);
	filter_table_regist(type,NULL);	
	
	list_for_each(lh, &table_list_head.table_list)
	{		
		entry=list_entry(lh, filter_table_list, table_list);
		if(entry->type == type)
		{
			list_add(new_item,&entry->item_list);
			entry->num++;
			return 0;
		}
	}
	return -1;
}

//////////////////////////////////////////////
//
static int filter_table_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
	 int len;
	char buf[512],tmp[256];
	struct list_head *lh,*lh2;
	filter_table_list *entry;
	filter_item_entry *entry_item;
	list_for_each(lh, &table_list_head.table_list)
	{		
		entry=list_entry(lh, filter_table_list, table_list);
		//printk("type=%d num=%d\n",entry->type,entry->num-1);
		sprintf(buf,"type=%d num=%d\n",entry->type,entry->num-1);
		switch(entry->type)
		{
			case MAC_TABLE:
				list_for_each(lh2,&(entry->item_list))
				{
					entry_item=list_entry(lh2, filter_item_entry, item_list);
					sprintf(tmp,"index=%d	",entry_item->index);
					//printk("index=%d	",entry_item->index);
					strcat(buf,tmp);
					sprintf(tmp,"mac=%02x:%02x:%02x:%02x:%02x:%02x\n",entry_item->data[0]&0xff,entry_item->data[1]&0xff,entry_item->data[2]&0xff,entry_item->data[3]&0xff,entry_item->data[4]&0xff,entry_item->data[5]&0xff);	
					strcat(buf,tmp);
					//printk("mac=%02x:%02x:%02x:%02x:%02x:%02x\n",entry_item->data[0]&0xff,entry_item->data[1]&0xff,entry_item->data[2]&0xff,entry_item->data[3]&0xff,entry_item->data[4]&0xff,entry_item->data[5]&0xff);	
				}					
				break;
			case URL_KEY_TABLE:
				list_for_each(lh2,&(entry->item_list))
				{
					entry_item=list_entry(lh2, filter_item_entry, item_list);
					sprintf(tmp,"index=%d		",entry_item->index);
					strcat(buf,tmp);
					//printk("index=%d		",entry_item->index);
					sprintf(tmp,"url=%s\n",entry_item->data);	
					strcat(buf,tmp);
					//printk("url=%s\n",entry_item->data);	
				}					
				break;
			case SCHEDULT_TABLE:
			{
				uint32 *start, *end,*day;				
				list_for_each(lh2,&(entry->item_list))
				{
					entry_item=list_entry(lh2, filter_item_entry, item_list);
					sprintf(tmp,"index=%d	",entry_item->index);
					strcat(buf,tmp);
					//printk("index=%d	",entry_item->index);
					start=(uint32 *)entry_item->data;
					end=(uint32 *)(entry_item->data+4);
					day=(uint32 *)(entry_item->data+8);
					sprintf(tmp,"start=%x	",*start);	
					strcat(buf,tmp);
					//printk("start=%x	",*start);	
					sprintf(tmp,"end=%x	",*end);
					strcat(buf,tmp);
					//printk("end=%x	",*end);
					sprintf(tmp,"day=%x\n",*day);
					strcat(buf,tmp);
					//printk("day=%x\n",*day);
				}					
				break;
			}
			default:
				sprintf(tmp,"unknow table type\n" );
				strcat(buf,tmp);
				//printk("unknow table type\n" );
				break;
		}
	}
	len = sprintf(page, "%s\n", buf);
	
	if (len <= off+count) *eof = 1;
     	*start = page + off;
      	len -= off;
      	if (len>count) len = count;
      	if (len<0) len = 0;
      	return len;
}

#if 0
int parse_flag(int type,int flag)
{
	int ret;
	ret=(flag>>(4*(type-1))) & 0xf;
	if(flag & (0x1 << (16+type-1)))
	{
		ret|=0x100;
	}
	return ret;
	
}
#endif
/**
*7/1 00-11-22-33-44-55/2 baidu google
*flag/table_type data/table_type data;
*/
static int filter_table_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
      	char tmpbuf[1024];
      	char *tokptr, *entryptr,*strptr=tmpbuf,*tokptr2;
      	filter_item_entry *entry;
	int i,action;

	int flag,type,url_len;
	int flag_item;
		
	memset(get_info_from_usr_space,0,strlen(get_info_from_usr_space));
      	if (buffer && !copy_from_user(&get_info_from_usr_space, buffer, count))
 	{
	     	strncpy(tmpbuf,get_info_from_usr_space,count);
	      	tmpbuf[strlen(get_info_from_usr_space)-1]='\0';	
		if(memcmp(strptr,"init", strlen("init")) == 0)
		{
			//entryptr = strsep(&strptr,";");
			tokptr = strsep(&strptr," ");
			do{
				//printk("%s-----%d\n",__FUNCTION__,__LINE__);
				tokptr = strsep(&strptr," ");
				flag= str2hexnum(tokptr);	
				//printk("flag1=%x\n",flag);
				filter_table_regist(flag,filter_tlb[flag].func);				
			}while(strptr!=NULL);	
		}
		else if(memcmp(strptr,"flush", strlen("flush")) == 0)
		{
			//printk("2tmpbuf=%s\n",tmpbuf);	
			filter_table_flush(0);		
		}
		else if(memcmp(strptr,"add:", strlen("add:")) == 0)
		{
			entryptr = strsep(&strptr,":");
			//printk("entryptr=%s\n",entryptr);
			do{
				entryptr = strsep(&strptr,";");
				//printk("entryptr=%s\n",entryptr);

				if(entryptr == NULL) break;
				
				tokptr = strsep(&entryptr,"/");
				flag= str2hexnum(tokptr);			
				//printk("flag=%x\n",flag);
				
				do{
//					printk("%s-----%d\n",__FUNCTION__,__LINE__);
					tokptr = strsep(&entryptr,"/");
					tokptr2 = strsep(&tokptr," ");
					type = str2hexnum(tokptr2);			
					//printk("type=%x\n",type);
					tokptr2 = strsep(&tokptr," ");
					flag_item = str2hexnum(tokptr2);
					//printk("flag_item=%x\n",flag_item);
					switch(type)
					{
						case IP_RANGE_TABLE:
						{
							int ip_range;
							do{
								entry = kmalloc(sizeof(filter_item_entry),GFP_KERNEL);		
								if(entry == NULL)
								{
									printk("Not enough memory for filter table...\n");
									return count;
								}
								INIT_LIST_HEAD(&entry->item_list);
								INIT_LIST_HEAD(&entry->rule_list);
								entry->flag=0;
								entry->index=filter_rule_num;
								
								entry->relation_flag=flag_item;
								
								tokptr2 = strsep(&tokptr," ");
								ip_range=str2hexnum(tokptr2);
								memcpy(entry->data,&ip_range,sizeof(int));
								
								tokptr2 = strsep(&tokptr," ");
								ip_range=str2hexnum(tokptr2);
								memcpy(entry->data+4,&ip_range,sizeof(uint32));
								filter_item_regist(IP_RANGE_TABLE,&entry->item_list);
							}while(tokptr!=NULL);
							break;
						}
						case MAC_TABLE:
						{
							entry = kmalloc(sizeof(filter_item_entry),GFP_KERNEL);		
							if(entry == NULL)
							{
								printk("Not enough memory for filter table...\n");
								return count;
							}
							INIT_LIST_HEAD(&entry->item_list);
							INIT_LIST_HEAD(&entry->rule_list);
							entry->flag=0;
							entry->index=filter_rule_num;
							
							entry->relation_flag=flag_item;
							
							char *mac_ptr;
							tokptr2 = strsep(&tokptr," ");
							//printk("mac=%s\n",tokptr2);							
							
							i=0;
							do
							{
								mac_ptr = strsep(&tokptr2,"-");
								entry->data[i]=str2hexnum(mac_ptr) & 0xff;
								//printk("mac%d=%02x\n",i,entry->data[i]);							
								i++;
							}while(tokptr2 !=NULL );
							//printk("index=%d[%d]\n",entry->index,__LINE__);
							filter_item_regist(MAC_TABLE,&entry->item_list);
							break;
						}
						case URL_KEY_TABLE:
						{
							do{
								entry = kmalloc(sizeof(filter_item_entry),GFP_KERNEL);		
								if(entry == NULL)
								{
									printk("Not enough memory for filter table...\n");
									return count;
								}
								tokptr2 = strsep(&tokptr," ");
								//printk("tokptr2=%x\n",tokptr2[0]);
								if(tokptr2[0]==0) continue;
								
								INIT_LIST_HEAD(&entry->item_list);
								INIT_LIST_HEAD(&entry->rule_list);
								entry->flag=0;
								entry->index=filter_rule_num;
								
								entry->relation_flag=flag_item;
								
								
								url_len=strlen(tokptr2)>RTL_URL_FILTER_CONTENT_MAXNUM_FASTPATH?(RTL_URL_FILTER_CONTENT_MAXNUM_FASTPATH-1) : strlen(tokptr2);
								strncpy(entry->data,tokptr2, url_len);
								entry->data[url_len]='\0';
								filter_item_regist(URL_KEY_TABLE,&entry->item_list);
							}while(tokptr!=NULL);
							break;
						}
						case SCHEDULT_TABLE:
						{
							int i_sch;
							do{
								entry = kmalloc(sizeof(filter_item_entry),GFP_KERNEL);		
								if(entry == NULL)
								{
									printk("Not enough memory for filter table...\n");
									return count;
								}
								INIT_LIST_HEAD(&entry->item_list);
								INIT_LIST_HEAD(&entry->rule_list);
								entry->flag=0;
								entry->index=filter_rule_num;
								
								entry->relation_flag=flag_item;
								
								tokptr2 = strsep(&tokptr," ");
								i_sch=str2hexnum(tokptr2);
								memcpy(entry->data,&i_sch,sizeof(int));
								
								tokptr2 = strsep(&tokptr," ");

								if((i_sch==0) && (str2hexnum(tokptr2)==0))
								{
									i_sch=24*60;
								}
								else
								{
									i_sch=str2hexnum(tokptr2);
								}
								memcpy(entry->data+4,&i_sch,sizeof(uint32));
								
								//day
								tokptr2 = strsep(&tokptr," ");
								i_sch=str2hexnum(tokptr2);
								//printk("day=%d",i_sch);
								if(i_sch == 0) i_sch=0xff;
								memcpy(entry->data+8,&i_sch,sizeof(int));
								filter_item_regist(SCHEDULT_TABLE,&entry->item_list);
							}while(tokptr!=NULL);
							break;
						}
						default:
							break;
					}
				}while(entryptr!=NULL);		
				filter_rule_num++;
			}while(strptr!=NULL);
		}
    		return count;
     	}
_err:		
      	return -EFAULT;
}

int scan_table(struct sk_buff *skb,int index,filter_table_list *entry,struct list_head *_lh)
{
	struct list_head *lh;
	filter_item_entry *entry_item;
	filter_table_list *next_entry;
	int ret=0;
//	printk("type=%d[%d]\n",entry->type,__LINE__);
	if(entry->func == NULL) return -1;
	
	list_for_each(lh,&(entry->item_list))
	{
		entry_item=list_entry(lh, filter_item_entry, item_list);
		if((entry_item->relation_flag & 0x1) || ((!(entry_item->relation_flag & 0x1)) && (index == entry_item->index)))
		{
			if(entry_item->relation_flag & 0x200)
			{
				//printk("type=%d	",entry->type);
				next_entry=list_entry(_lh->next, filter_table_list, table_list);
				if(entry_item->relation_flag & 0x2)
				{
					ret=scan_table(skb,entry_item->index,next_entry,&(next_entry->table_list));
				}
				//printk("ret=%d[%d]\n",ret,__LINE__);
				if(ret != 0) 
				{
						//printk("%s-----%d\n",__FUNCTION__,__LINE__);
						return 1;
				}
			}
			else if((entry_item->relation_flag & 0x100)||(entry->func(skb,entry_item->data)) )
			{
				if(!(entry_item->relation_flag & 0x2)) 
				{
					if(entry_item->relation_flag & 0x1) 
					{
						//printk("%s-----ret=%d\n",__FUNCTION__,(entry_item->relation_flag & 0x8)?0:1);
						return (entry_item->relation_flag & 0x8)?0:1;
					}
					else
					{
						//printk("%s-----%d\n",__FUNCTION__,__LINE__);
						return 1;
					}
				}
				else
				{
					//printk("type=%d	",entry->type);
					next_entry=list_entry(_lh->next, filter_table_list, table_list);
					if(entry_item->relation_flag & 0x2)
					{
						ret=scan_table(skb,entry_item->index,next_entry,&(next_entry->table_list));
					}
					//printk("ret=%d[%d]\n",ret,__LINE__);
					if(ret != 0) 
					{
						if(entry_item->relation_flag & 0x1) 
						{
							//printk("%s-----%d\n",__FUNCTION__,__LINE__);
							return (entry_item->relation_flag & 0x8)?0:1;
						}
						else
						{
							//printk("%s-----%d\n",__FUNCTION__,__LINE__);
							return 1;
						}				
					}
				}
			}
		}
		continue;
	}
	if(entry_item->relation_flag & 0x1) 
	{
		//printk("%s-----%d\n",__FUNCTION__,__LINE__);
		return (entry_item->relation_flag & 0x8)?1:0;
	}
	else
	{
		//printk("%s-----%d\n",__FUNCTION__,__LINE__);
		return 0;
	}
}

int do_filter(struct sk_buff *skb)
{
	struct list_head *lh,*lh2;
	filter_table_list *entry;
	filter_item_entry *entry_item;
	int ret=0;
	//printk("%s-----%d\n",__FUNCTION__,__LINE__);
	list_for_each(lh, &table_list_head.table_list)
	{
		entry=list_entry(lh, filter_table_list, table_list);
		ret = scan_table(skb,0,entry,lh);
		if(ret == -1)
		{
			return 0;
		}
		else if(ret == 1)
		{
			return 1;
		}
	}
	return 0;
}


// url + mac
int  FilterWeb_v2(struct sk_buff *skb)
{
	struct iphdr *iph;
	int ret;
	
	iph=ip_hdr(skb);
		
	if(!(need_filter(skb))) return 0;
	
	ret = do_filter(skb);
//	printk("ret=%d\n",ret);
	
	return ret;
}

static struct proc_dir_entry *res12=NULL;
int filter_table_init(void)
{
	filter_table_head_init();		
	res12 = create_proc_entry("filter_table", 0, NULL);
	if (res12) {
	    res12->read_proc = filter_table_read_proc;
	    res12->write_proc = filter_table_write_proc;
      }

	return 0;
}
/////////////////////////////////////////////////////////
//

int filter_init_fastpath(void)
{
	filter_rule_num=1;
	filter_table_init();
	return 0;
}

int filter_exit_fastpath(void)
{
	if (res12) {
		remove_proc_entry("filter_table", res12);				
		res12 = NULL;
	}
}
#endif

