#ifndef _RTL8370_BASE_H_
#define _RTL8370_BASE_H_

#include <rtl8370_reg.h>

/* (16'h0000) port_reg */

#define    RTL8370_PORT_SPECIAL_CONGEST_MODE_TIMER_BASE    	RTL8370_REG_PORT0_MISC_CFG
#define    RTL8370_PORT_SPECIAL_CONGEST_MODE_TIMER_REG(port)	(RTL8370_PORT_SPECIAL_CONGEST_MODE_TIMER_BASE + (port << 5))
#define    RTL8370_PORT_SPECIAL_CONGEST_MODE_TIMER_OFFSET    	RTL8370_PORT0_MISC_CFG_TIMER_OFFSET
#define    RTL8370_PORT_SPECIAL_CONGEST_MODE_TIMER_MASK    	RTL8370_PORT0_MISC_CFG_TIMER_MASK

#define    RTL8370_PORT_MISC_CFG_BASE    					RTL8370_REG_PORT0_MISC_CFG
#define    RTL8370_PORT_MISC_CFG_REG(port)    				(RTL8370_PORT_MISC_CFG_BASE + (port << 5))
#define    RTL8370_INGRESSBW_PORT_FLOWCRTL_ENABLE_OFFSET 	RTL8370_INGRESSBW_PORT0_FLOWCRTL_OFFSET
#define    RTL8370_INGRESSBW_PORT_FLOWCRTL_ENABLE_MASK    	RTL8370_INGRESSBW_PORT0_FLOWCRTL_MASK
#define    RTL8370_INGRESSBW_PORT_IFG_OFFSET    			RTL8370_INGRESSBW_PORT0_IFG_OFFSET
#define    RTL8370_INGRESSBW_PORT_IFG_MASK    				RTL8370_INGRESSBW_PORT0_IFG_MASK
#define    RTL8370_VLAN_EGRESS_MDOE_OFFSET    				RTL8370_VLAN_PORT0_EGRESS_MODE_OFFSET
#define    RTL8370_VLAN_EGRESS_MDOE_MASK    				RTL8370_VLAN_PORT0_EGRESS_MODE_MASK
#define    RTL8370_SPECIALCONGEST_SUSTAIN_TIMER_OFFSET    	RTL8370_CONGESTION_PORT0_SUSTAIN_TIME_OFFSET
#define    RTL8370_SPECIALCONGEST_SUSTAIN_TIMER_MASK    	RTL8370_CONGESTION_PORT0_SUSTAIN_TIME_MASK

#define    RTL8370_INGRESSBW_PORT_RATE_LSB_BASE    	RTL8370_REG_INGRESSBW_PORT0_RATE_CRTL0
#define    RTL8370_INGRESSBW_PORT_RATE_LSB_REG(port)	(RTL8370_INGRESSBW_PORT_RATE_LSB_BASE + (port << 5))

#define    RTL8370_INGRESSBW_PORT_RATE_MSB_BASE    	RTL8370_REG_INGRESSBW_PORT0_RATE_CRTL1
#define    RTL8370_INGRESSBW_PORT_RATE_MSB_REG(port)   (RTL8370_INGRESSBW_PORT_RATE_MSB_BASE + (port << 5))

#define    RTL8370_PORT_EEE_CFG_BASE                        RTL8370_REG_PORT0_EEECFG
#define    RTL8370_PORT_EEE_CFG_REG(port)                   (RTL8370_REG_PORT0_EEECFG + (port << 5))
#define    RTL8370_PORT_EEE_TX_ENABLE_OFFSET                RTL8370_PORT0_EEECFG_EEE_TX_OFFSET
#define    RTL8370_PORT_EEE_TX_ENABLE_MASK                  RTL8370_PORT0_EEECFG_EEE_TX_MASK
#define    RTL8370_PORT_EEE_RX_ENABLE_OFFSET                RTL8370_PORT0_EEECFG_EEE_RX_OFFSET
#define    RTL8370_PORT_EEE_RX_ENABLE_MASK                  RTL8370_PORT0_EEECFG_EEE_RX_MASK
#define    RTL8370_PORT_EEE_FORCE_OFFSET                    RTL8370_PORT0_EEECFG_EEE_FORCE_OFFSET
#define    RTL8370_PORT_EEE_FORCE_MASK                      RTL8370_PORT0_EEECFG_EEE_FORCE_MASK
#define    RTL8370_PORT_EEE_100M_OFFSET                     RTL8370_PORT0_EEECFG_EEE_100M_OFFSET
#define    RTL8370_PORT_EEE_100M_MASK                       RTL8370_PORT0_EEECFG_EEE_100M_MASK 
#define    RTL8370_PORT_EEE_GIGA_OFFSET                     RTL8370_PORT0_EEECFG_EEE_GIGA_OFFSET 
#define    RTL8370_PORT_EEE_GIGA_MASK                       RTL8370_PORT0_EEECFG_EEE_GIGA_MASK 
#define    RTL8370_PORT_EEE_LPI_STATUS_OFFSET               RTL8370_PORT0_EEECFG_EEE_LPI_OFFSET
#define    RTL8370_PORT_EEE_LPI_STATUS_MASK                 RTL8370_PORT0_EEECFG_EEE_LPI_MASK
#define    RTL8370_PORT_EEE_TX_LPI_STATUS_OFFSET            RTL8370_PORT0_EEECFG_EEE_TX_LPI_OFFSET
#define    RTL8370_PORT_EEE_TX_LPI_STATUS_MASK              RTL8370_PORT0_EEECFG_EEE_TX_LPI_MASK
#define    RTL8370_PORT_EEE_RX_LPI_STATUS_OFFSET            RTL8370_PORT0_EEECFG_EEE_RX_LPI_OFFSET 
#define    RTL8370_PORT_EEE_RX_LPI_STATUS_MASK              RTL8370_PORT0_EEECFG_EEE_RX_LPI_MASK
#define    RTL8370_PORT_EEE_PAUSE_INDICATOR_OFFSET          RTL8370_PORT0_EEECFG_EEE_PAUSE_INDICATOR_OFFSET
#define    RTL8370_PORT_EEE_PAUSE_INDICATOR_MASK            RTL8370_PORT0_EEECFG_EEE_PAUSE_INDICATOR_MASK
#define    RTL8370_PORT_EEE_WAKE_REQ_OFFSET                 RTL8370_PORT0_EEECFG_EEE_WAKE_REQ_OFFSET         
#define    RTL8370_PORT_EEE_WAKE_REQ_MASK                   RTL8370_PORT0_EEECFG_EEE_WAKE_REQ_MASK           

#define    RTL8370_PORT_EEE_TX_METER_BASE                   RTL8370_REG_P0EEETXMTR
#define    RTL8370_PORT_EEE_TX_METER_REG(port)              (RTL8370_REG_P0EEETXMTR + (port << 5))
#define    RTL8370_PORT_EEE_RX_METER_BASE                   RTL8370_REG_P0EEERXMTR
#define    RTL8370_PORT_EEE_RX_METER_REG(port)              (RTL8370_REG_P0EEERXMTR + (port << 5))


#define    RTL8370_PORT_EEEP_TX_ENABLE_OFFSET                RTL8370_PORT0_EEECFG_EEEP_ENABLE_TX_OFFSET
#define    RTL8370_PORT_EEEP_TX_ENABLE_MASK                  RTL8370_PORT0_EEECFG_EEEP_ENABLE_TX_MASK
#define    RTL8370_PORT_EEEP_RX_ENABLE_OFFSET                RTL8370_PORT0_EEECFG_EEEP_ENABLE_RX_OFFSET
#define    RTL8370_PORT_EEEP_RX_ENABLE_MASK                  RTL8370_PORT0_EEECFG_EEEP_ENABLE_RX_MASK
#define    RTL8370_PORT_EEEP_SLEEP_REQ_OFFSET                RTL8370_PORT0_EEECFG_EEE_SLEEP_REQ_OFFSET             
#define    RTL8370_PORT_EEEP_SLEEP_REQ_MASK                  RTL8370_PORT0_EEECFG_EEE_SLEEP_REQ_MASK

/* (16'h0200) outq_reg */

#define    RTL8370_FLOWCTRL_QUEUE_DROP_ON_BASE    		RTL8370_REG_FLOWCTRL_QUEUE0_DROP_ON
#define    RTL8370_FLOWCTRL_QUEUE_DROP_ON_REG(queue)	(RTL8370_FLOWCTRL_QUEUE_DROP_ON_BASE + queue)
#define    RTL8370_FLOWCTRL_QUEUE_DROP_ON_OFFSET    	RTL8370_FLOWCTRL_QUEUE0_DROP_ON_OFFSET
#define    RTL8370_FLOWCTRL_QUEUE_DROP_ON_MASK    		RTL8370_FLOWCTRL_QUEUE0_DROP_ON_MASK

#define    RTL8370_FLOWCTRL_PORT_DROP_ON_BASE    		RTL8370_REG_FLOWCTRL_PORT0_DROP_ON
#define    RTL8370_FLOWCTRL_PORT_DROP_ON_REG(PORT)    (RTL8370_FLOWCTRL_PORT_DROP_ON_BASE + PORT)
#define    RTL8370_FLOWCTRL_PORT_DROP_ON_OFFSET    	RTL8370_FLOWCTRL_PORT0_DROP_ON_OFFSET
#define    RTL8370_FLOWCTRL_PORT_DROP_ON_MASK    		RTL8370_FLOWCTRL_PORT0_DROP_ON_MASK

#define    RTL8370_FLOWCTRL_PORT_GAP_REG    	RTL8370_REG_FLOWCTRL_PORT_GAP
#define    RTL8370_FLOWCTRL_QUEUE_GAP_REG    	RTL8370_REG_FLOWCTRL_QUEUE_GAP
#define    RTL8370_FLOWCTRL_PORT_QEMPTY_REG    RTL8370_REG_PORT_QEMPTY

/* (16'h0300) sch_reg */

#define    RTL8370_SCHEDULE_WFQ_BURST_SIZE_REG    RTL8370_REG_SCHEDULE_WFQ_BURST_SIZE

#define    RTL8370_SCHEDULE_QUEUE_TYPE_BASE    			RTL8370_REG_SCHEDULE_QUEUE_TYPE_CTRL0
#define    RTL8370_SCHEDULE_QUEUE_TYPE_REG(port)    		(RTL8370_SCHEDULE_QUEUE_TYPE_BASE + (port >> 1))
#define    RTL8370_SCHEDULE_QUEUE_TYPE_OFFSET(port, queue)	(((port & 0x1) << 3) + queue)
#define    RTL8370_SCHEDULE_QUEUE_TYPE_MASK(port, queue) 	RTL8370_SCHEDULE_QUEUE_TYPE_OFFSET(port, queue)

#define    RTL8370_SCHEDULE_PORT_QUEUE_WFQ_WEIGHT_BASE    				RTL8370_REG_SCHEDULE_PORT0_QUEUE0_WFQ_WEIGHT
#define    RTL8370_SCHEDULE_PORT_QUEUE_WFQ_WEIGHT_REG(port, queue)    (RTL8370_SCHEDULE_PORT_QUEUE_WFQ_WEIGHT_BASE + (port << 3) + queue)
#define    RTL8370_SCHEDULE_PORT_QUEUE_WFQ_WEIGHT_OFFSET    			RTL8370_SCHEDULE_PORT0_QUEUE0_WFQ_WEIGHT_OFFSET
#define    RTL8370_SCHEDULE_PORT_QUEUE_WFQ_WEIGHT_MASK    				RTL8370_SCHEDULE_PORT0_QUEUE0_WFQ_WEIGHT_MASK

#define    RTL8370_SCHEDULE_APR_CRTL_REG               RTL8370_REG_SCHEDULE_APR_CRTL0
#define    RTL8370_SCHEDULE_APR_CRTL_OFFSET(port)    	(port)
#define    RTL8370_SCHEDULE_APR_CRTL_MASK(port)    	(1 << RTL8370_SCHEDULE_APR_CRTL_OFFSET(port))

#define    RTL8370_SCHEDULE_PORT_APR_METER_BASE    			RTL8370_REG_SCHEDULE_PORT0_APR_METER_CTRL0
#define    RTL8370_SCHEDULE_PORT_APR_METER_REG(port, queue)    (RTL8370_SCHEDULE_PORT_APR_METER_BASE + (port << 2) + (queue / 5))
#define    RTL8370_SCHEDULE_PORT_APR_METER_OFFSET(queue)    	(3 * (queue % 5))
#define    RTL8370_SCHEDULE_PORT_APR_METER_MASK(queue)    		(RTL8370_PORT0_QUEUE0_APR_METER_MASK << RTL8370_SCHEDULE_PORT_APR_METER_OFFSET(queue))

#define    RTL8370_PORT_EGRESSBW_LSB_BASE    RTL8370_REG_PORT0_EGRESSBW_CTRL0
#define    RTL8370_PORT_EGRESSBW_LSB_REG(port)    (RTL8370_PORT_EGRESSBW_LSB_BASE + (port << 1))

#define    RTL8370_PORT_EGRESSBW_MSB_BASE    RTL8370_REG_PORT0_EGRESSBW_CTRL1
#define    RTL8370_PORT_EGRESSBW_MSB_REG(port)    (RTL8370_PORT_EGRESSBW_MSB_BASE + (port << 1))
#define    RTL8370_PORT_EGRESSBW_MSB_OFFSET    RTL8370_PORT0_EGRESSBW_CTRL1_OFFSET
#define    RTL8370_PORT_EGRESSBW_MSB_MASK    RTL8370_PORT0_EGRESSBW_CTRL1_MASK

/* (16'h0500) table_reg */

#define    RTL8370_TABLE_ACCESS_CTRL_REG    RTL8370_REG_TABLE_ACCESS_CTRL

#define    RTL8370_TABLE_ACCESS_ADDR_REG    RTL8370_REG_TABLE_ACCESS_ADDR

#define    RTL8370_TABLE_ACCESS_DATA_BASE    		RTL8370_REG_TABLE_ACCESS_DATA0
#define    RTL8370_TABLE_ACCESS_DATA_REG(index)    (RTL8370_TABLE_ACCESS_DATA_BASE + index)

/* (16'h0600) acl_reg */

#define    RTL8370_ACL_RULE_TEMPLATE_CRTL_BASE    					RTL8370_REG_ACL_RULE_TEMPLATE0_CRTL0
#define    RTL8370_ACL_RULE_TEMPLATE_CTRL_REG(template, field)    (RTL8370_ACL_RULE_TEMPLATE_CRTL_BASE + template * 0x4 + (field >> 1))
#define    RTL8370_ACL_TEMPLATE_FIELD_OFFSET(field)    			((field & 0x01) <<3)
#define    RTL8370_ACL_TEMPLATE_FIELD_MASK(field)    				(0x3F << RTL8370_ACL_TEMPLATE_FIELD_OFFSET(field))

#define    RTL8370_ACL_ACTION_CTRL_BASE    	RTL8370_REG_ACL_ACTION_CTRL0
#define    RTL8370_ACL_ACTION_CTRL_REG(rule)   (RTL8370_ACL_ACTION_CTRL_BASE + (rule >> 1))
#define    RTL8370_ACL_OP_NOT_OFFSET(rule)    	(5 + ((rule & 0x1) << 3))
#define    RTL8370_ACL_OP_NOT_MASK(rule)    	(1 << RTL8370_ACL_OP_NOT_OFFSET(rule))
#define    RTL8370_ACL_OP_ACTION_OFFSET(rule)	((rule & 0x1) << 3)
#define    RTL8370_ACL_OP_ACTION_MASK(rule)    (0x1F << RTL8370_ACL_OP_ACTION_OFFSET(rule))

#define    RTL8370_ACL_ENABLE_REG    		RTL8370_REG_ACL_ENABLE
#define    RTL8370_ACL_UNMATCH_PERMIT_REG	RTL8370_REG_ACL_UNMATCH_PERMIT

/* (16'h0700) cvlan_reg */

#define    RTL8370_VLAN_PVID_CTRL_BASE    		RTL8370_REG_VLAN_PVID_CTRL0
#define    RTL8370_VLAN_PVID_CTRL_REG(port)    (RTL8370_VLAN_PVID_CTRL_BASE + (port >> 1))
#define    RTL8370_PORT_VIDX_OFFSET(port)    	((port &1)<<3)
#define    RTL8370_PORT_VIDX_MASK(port)    	(RTL8370_PORT0_VIDX_MASK << RTL8370_PORT_VIDX_OFFSET(port))

#define    RTL8370_VLAN_PPB_VALID_BASE    		RTL8370_REG_VLAN_PPB0_VALID
#define    RTL8370_VLAN_PPB_VALID_REG(item)    (RTL8370_VLAN_PPB_VALID_BASE + (item << 3))

#define    RTL8370_VLAN_PPB_CTRL_BASE    			RTL8370_REG_VLAN_PPB0_CTRL0
#define    RTL8370_VLAN_PPB_CTRL_REG(item, port)   (RTL8370_VLAN_PPB_CTRL_BASE + (item << 3) + (port / 3) )
#define    RTL8370_VLAN_PPB_CTRL_OFFSET(port)    	((port % 3) * 5)
#define    RTL8370_VLAN_PPB_CTRL_MASK(port)    	(RTL8370_PPB0_PORT0_INDEX_MASK << RTL8370_VLAN_PPB_CTRL_OFFSET(port))

#define    RTL8370SG_VLAN_PPB_FRAMETYPE_BASE    	RTL8370_REG_VLAN_PPB0_CTRL5
#define    RTL8370SG_VLAN_PPB_FRAMETYPE_REG(item)   (RTL8370SG_VLAN_PPB_FRAMETYPE_BASE + (item << 3))
#define    RTL8370SG_VLAN_PPB_FRAMETYPE_OFFSET    	RTL8370_PPB0_FRAME_TYPE_OFFSET
#define    RTL8370SG_VLAN_PPB_FRAMETYPE_MASK    	RTL8370_PPB0_FRAME_TYPE_MASK

#define    RTL8370_VLAN_PPB_ETHERTYPR_BASE    		RTL8370_REG_VLAN_PPB0_CTRL6
#define    RTL8370_VLAN_PPB_ETHERTYPR_REG(item)    (RTL8370_VLAN_PPB_ETHERTYPR_BASE + (item << 3))

#define    RTL8370_VLAN_MEMBER_CONFIGURATION_BASE	RTL8370_REG_VLAN_MEMBER_CONFIGURATION0_CTRL0

#define    RTL8370_VLAN_FILTERING_REG    	RTL8370_REG_VLAN_CTRL
#define    RTL8370_VLAN_FILTERING_OFFSET   RTL8370_VLAN_CTRL_OFFSET
#define    RTL8370_VLAN_FILTERING_MASK    	RTL8370_VLAN_CTRL_MASK

#define    RTL8370_VLAN_CTRL_REG    		RTL8370_REG_VLAN_CTRL

#define    RTL8370SG_VLAN_INGRESS_REG    	RTL8370_REG_VLAN_INGRESS

#define    RTL8370_VLAN_ACCEPT_FRAME_TYPE_BASE    		RTL8370_REG_VLAN_ACCEPT_FRAME_TYPE_CTRL0
#define    RTL8370_VLAN_ACCEPT_FRAME_TYPE_REG(port)    (RTL8370_VLAN_ACCEPT_FRAME_TYPE_BASE + (port >> 3))
#define    RTL8370_VLAN_ACCEPT_FRAME_TYPE_MASK(port)   (RTL8370_VLAN_PORT0_FRAME_TYPE_MASK << ((port & 0x7) << 1))

#define    RTL8370_PORT_EFID_BASE    		RTL8370_REG_PORT_EFID_CTRL0
#define    RTL8370_PORT_EFID_REG(port)    	(RTL8370_PORT_EFID_BASE + (port >> 2))
#define    RTL8370_PORT_EFID_OFFSET(port) 	((port & 0x3) << 2)
#define    RTL8370_PORT_EFID_MASK(port)    (RTL8370_PORT0_EFID_MASK << RTL8370_PORT_EFID_OFFSET(port))

#define    RTL8370_PORT_PBFIDEN_REG    	RTL8370_REG_PORT_PBFIDEN

#define    RTL8370_PORT_PBFID_BASE         RTL8370_REG_PORT0_PBFID
#define    RTL8370_PORT_PBFID_REG(port)    (RTL8370_PORT_PBFID_BASE + port)

/* (16'h0800) dpm_reg */

#define    RTL8370_RMA_CTRL_BASE    RTL8370_REG_RMA_CTRL00

#define    RTL8370_IGMP_CTRL_REG    RTL8370_REG_IGMP_CTRL

#define    RTL8370_VLAN_PORTBASED_PRIORITY_BASE    RTL8370_REG_VLAN_PORTBASED_PRIORITY_CTRL0
#define    RTL8370_VLAN_PORTBASED_PRIORITY_REG(port)    (RTL8370_VLAN_PORTBASED_PRIORITY_BASE + (port >> 2))
#define    RTL8370_VLAN_PORTBASED_PRIORITY_OFFSET(port)    ((port & 0x3) << 2)
#define    RTL8370_VLAN_PORTBASED_PRIORITY_MASK(port)    (0x7 << RTL8370_VLAN_PORTBASED_PRIORITY_OFFSET(port))

#define    RTL8370_VLAN_PPB_PRIORITY_ITEM_BASE    RTL8370_REG_VLAN_PPB_PRIORITY_ITEM0_CTRL0
#define    RTL8370_VLAN_PPB_PRIORITY_ITEM_REG(port, item)    (RTL8370_VLAN_PPB_PRIORITY_ITEM_BASE + (item << 2)+ (port>>2))
#define    RTL8370_VLAN_PPB_PRIORITY_ITEM_OFFSET(port)    ((port & 0x3) <<2)
#define    RTL8370_VLAN_PPB_PRIORITY_ITEM_MASK(port)    (RTL8370_VLAN_PPB_PRIORITY_ITEM0_CTRL0_PORT0_PRIORITY_MASK << RTL8370_VLAN_PPB_PRIORITY_ITEM_OFFSET(port))

#define    RTL8370_QOS_1Q_PRIORITY_REMAPPING_BASE    RTL8370_REG_QOS_1Q_PRIORITY_REMAPPING_CTRL0
#define    RTL8370_QOS_1Q_PRIORITY_REMAPPING_REG(pri)    (RTL8370_QOS_1Q_PRIORITY_REMAPPING_BASE + (pri >> 2))
#define    RTL8370_QOS_1Q_PRIORITY_REMAPPING_OFFSET(pri)    ((pri & 0x3) << 2)
#define    RTL8370_QOS_1Q_PRIORITY_REMAPPING_MASK(pri)    (0x7 << RTL8370_QOS_1Q_PRIORITY_REMAPPING_OFFSET(pri))

#define    RTL8370_QOS_DSCP_TO_PRIORITY_BASE    RTL8370_REG_QOS_DSCP_TO_PRIORITY_CTRL0
#define    RTL8370_QOS_DSCP_TO_PRIORITY_REG(dscp)    (RTL8370_QOS_DSCP_TO_PRIORITY_BASE + (dscp >> 2))
#define    RTL8370_QOS_DSCP_TO_PRIORITY_OFFSET(dscp)    ((dscp & 0x3) << 2)
#define    RTL8370_QOS_DSCP_TO_PRIORITY_MASK(dscp)    (0x7 << RTL8370_QOS_DSCP_TO_PRIORITY_OFFSET(dscp))

#define    RTL8370_QOS_PORTBASED_PRIORITY_BASE    RTL8370_REG_QOS_PORTBASED_PRIORITY_CTRL0
#define    RTL8370_QOS_PORTBASED_PRIORITY_REG(port)    (RTL8370_QOS_PORTBASED_PRIORITY_BASE + (port >> 2))
#define    RTL8370_QOS_PORTBASED_PRIORITY_OFFSET(port)    ((port & 0x3) << 2)
#define    RTL8370_QOS_PORTBASED_PRIORITY_MASK(port)    (0x7 << RTL8370_QOS_PORTBASED_PRIORITY_OFFSET(port))

#define    RTL8370_QOS_INTERNAL_PRIORITY_DECISION_BASE    RTL8370_REG_QOS_INTERNAL_PRIORITY_DECISION_CTRL0
#define    RTL8370_QOS_INTERNAL_PRIORITY_DECISION_REG(src)    (RTL8370_QOS_INTERNAL_PRIORITY_DECISION_BASE + (src >> 1))
#define    RTL8370_QOS_INTERNAL_PRIORITY_DECISION_OFFSET(src)    ((src & 1) << 3)
#define    RTL8370_QOS_INTERNAL_PRIORITY_DECISION_MASK(src)    (RTL8370_QOS_PORT_WEIGHT_MASK << RTL8370_QOS_INTERNAL_PRIORITY_DECISION_OFFSET(src))

#define    RTL8370_QOS_PRIPORITY_REMAPPING_IN_CPU_BASE    RTL8370_REG_QOS_PRIORITY_REMAPPING_IN_CPU_CTRL0
#define    RTL8370_QOS_PRIPORITY_REMAPPING_IN_CPU_REG(pri)    (RTL8370_QOS_PRIPORITY_REMAPPING_IN_CPU_BASE + (pri >> 2))
#define    RTL8370_QOS_PRIPORITY_REMAPPING_IN_CPU_OFFSET(pri)    ((pri & 0x3) << 2)
#define    RTL8370_QOS_PRIPORITY_REMAPPING_IN_CPU_MASK(pri)    (RTL8370_QOS_PRIORITY_REMAPPING_IN_CPU_CTRL0_PRIORITY0_MASK << RTL8370_QOS_PRIPORITY_REMAPPING_IN_CPU_OFFSET(pri))

#define    RTL8370SG_QOS_TRAP_PRIORITY_CTRL0_REG    RTL8370_REG_QOS_TRAP_PRIORITY0

#define    RTL8370SG_QOS_TRAP_PRIORITY_CTRL1_REG    RTL8370_REG_QOS_TRAP_PRIORITY1

#define    RTL8370_UNUCAST_FLOADING_PMSK_REG    RTL8370_REG_UNUCAST_FLOADING_PMSK

#define    RTL8370_UNMCAST_FLOADING_PMSK_REG    RTL8370_REG_UNMCAST_FLOADING_PMSK

#define    RTL8370_BCAST_FLOADING_PMSK_REG    RTL8370_REG_BCAST_FLOADING_PMSK

#define    RTL8370_PORT_ISOLATION_PORT_MASK_BASE    RTL8370_REG_PORT_ISOLATION_PORT0_MASK
#define    RTL8370_PORT_ISOLATION_PORT_MASK_REG(port)    (RTL8370_PORT_ISOLATION_PORT_MASK_BASE + port)

#define    RTL8370_FORCE_CTRL_REG    RTL8370_REG_FORCE_CTRL

#define    RTL8370_SOURCE_PORT_BLOCK_REG    RTL8370_REG_SOURCE_PORT_BLOCK

#define    RTL8370_IPMCAST_VLAN_LEAKY_REG    RTL8370_REG_IPMCAST_VLAN_LEAKY

#define    RTL8370_IPMCAST_PORTISO_LEAKY_REG    RTL8370_REG_IPMCAST_PORTISO_LEAKY

#define    RTL8370_PORT_SECURIT_CTRL_REG    RTL8370_REG_PORT_SECURITY_CTRL

#define    RTL8370_UNKNOWN_IPV4_MULTICAST_BASE    RTL8370_REG_UNKNOWN_IPV4_MULTICAST_CRTL0
#define    RTL8370_UNKNOWN_IPV4_MULTICAST_REG(port)    (RTL8370_UNKNOWN_IPV4_MULTICAST_BASE + (port >> 3))
#define    RTL8370_UNKNOWN_IPV4_MULTICAST_OFFSET(port)    ((port & 0x7) << 1)
#define    RTL8370_UNKNOWN_IPV4_MULTICAST_MASK(port)    (RTL8370_PORT0_UNKNOWN_IP4_MCAST_MASK << RTL8370_UNKNOWN_IPV4_MULTICAST_OFFSET(port))

#define    RTL8370_UNKNOWN_IPV6_MULTICAST_BASE    RTL8370_REG_UNKNOWN_IPV6_MULTICAST_CRTL0
#define    RTL8370_UNKNOWN_IPV6_MULTICAST_REG(port)    (RTL8370_UNKNOWN_IPV6_MULTICAST_BASE + (port >> 3))
#define    RTL8370_UNKNOWN_IPV6_MULTICAST_OFFSET(port)    ((port & 0x7) << 1)
#define    RTL8370_UNKNOWN_IPV6_MULTICAST_MASK(port)    (RTL8370_PORT0_UNKNOWN_IP4_MCAST_MASK << RTL8370_UNKNOWN_IPV6_MULTICAST_OFFSET(port))

#define    RTL8370_UNKNOWN_L2_MULTICAST_BASE    RTL8370_REG_UNKNOWN_L2_MULTICAST_CRTL0
#define    RTL8370_UNKNOWN_L2_MULTICAST_REG(port)    (RTL8370_UNKNOWN_L2_MULTICAST_BASE + (port >> 3))
#define    RTL8370_UNKNOWN_L2_MULTICAST_OFFSET(port)    ((port & 0x7) << 1)
#define    RTL8370_UNKNOWN_L2_MULTICAST_MASK(port)    (RTL8370_PORT0_UNKNOWN_IP4_MCAST_MASK << RTL8370_UNKNOWN_L2_MULTICAST_OFFSET(port))

#define    RTL8370_PORT_TRUNK_CTRL_REG    RTL8370_REG_PORT_TRUNK_CTRL
#define    RTL8370_PORT_TRUNK_HASH_MASK   0x007F

#define    RTL8370_PORT_TRUNK_GROUP_MASK_REG    RTL8370_REG_PORT_TRUNK_GROUP_MASK
#define    RTL8370_PORT_TRUNK_GROUP_MASK_OFFSET(group)    (group << 2)
#define    RTL8370_PORT_TRUNK_GROUP_MASK_MASK(group)    (RTL8370_PORT_TRUNK_GROUP0_MASK_MASK << RTL8370_PORT_TRUNK_GROUP_MASK_OFFSET(group))

#define    RTL8370_PORT_TRUNK_FLOWCTRL_REG    RTL8370_REG_PORT_TRUNK_FLOWCTRL

#define    RTL8370_QOS_PORT_QUEUE_NUMBER_BASE    RTL8370_REG_QOS_PORT_QUEUE_NUMBER_CTRL0
#define    RTL8370_QOS_PORT_QUEUE_NUMBER_REG(port)    (RTL8370_QOS_PORT_QUEUE_NUMBER_BASE + (port >> 2))
#define    RTL8370_QOS_PORT_QUEUE_NUMBER_OFFSET(port)    ((port & 0x3) << 2)
#define    RTL8370_QOS_PORT_QUEUE_NUMBER_MASK(port)    (0x7 << RTL8370_QOS_PORT_QUEUE_NUMBER_OFFSET(port))

#define    RTL8370_QOS_1Q_PRIORITY_TO_QID_BASE    RTL8370_REG_QOS_1Q_PRIORITY_TO_QID_CRTL0
#define    RTL8370_QOS_1Q_PRIORITY_TO_QID_REG(index, pri)    (RTL8370_QOS_1Q_PRIORITY_TO_QID_BASE + (index << 1) + (pri >> 2))
#define    RTL8370_QOS_1Q_PRIORITY_TO_QID_OFFSET(pri)    ((pri & 0x3) << 2)
#define    RTL8370_QOS_1Q_PRIORITY_TO_QID_MASK(pri)    (RTL8370_QOS_1Q_PRIORITY_TO_QID_CRTL0_PRIORITY0_TO_QID_MASK << RTL8370_QOS_1Q_PRIORITY_TO_QID_OFFSET(pri))

#define    RTL8370_DEBUG_INFO_BASE    RTL8370_REG_PORT_DEBUG_INFO_CTRL0
#define    RTL8370_DEBUG_INFO_REG(port)    (RTL8370_DEBUG_INFO_BASE + (port >>1))
#define    RTL8370_DEBUG_INFO_OFFSET(port)    ((port&1)<<3)
#define    RTL8370_DEBUG_INFO_MASK(port)    (RTL8370_PORT0_DEBUG_INFO_MASK << RTL8370_DEBUG_INFO_OFFSET(port))

/* (16'h0a00) l2_reg */

#define    RTL8370_VLAN_MSTI_BASE    RTL8370_REG_VLAN_MSTI0_CTRL0
#define    RTL8370_VLAN_MSTI_REG(tree, port)    (RTL8370_VLAN_MSTI_BASE + (tree << 1) + (port >> 3))
#define    RTL8370_VLAN_MSTI_OFFSET(port)    ((port & 0x7) << 1)
#define    RTL8370_VLAN_MSTI_MASK(port)    (RTL8370_VLAN_MSTI0_CTRL0_PORT0_STATE_MASK << RTL8370_VLAN_MSTI_OFFSET(port))

#define    RTL8370_LUT_PORT_LEARN_LIMITNO_BASE    RTL8370_REG_LUT_PORT0_LEARN_LIMITNO
#define    RTL8370_LUT_PORT_LEARN_LIMITNO_REG(port)    (RTL8370_LUT_PORT_LEARN_LIMITNO_BASE + port)
#define    RTL8370_LUT_PORT_LEARN_LIMITNO_OFFSET    RTL8370_LUT_PORT0_LEARN_LIMITNO_OFFSET
#define    RTL8370_LUT_PORT_LEARN_LIMITNO_MASK    RTL8370_LUT_PORT0_LEARN_LIMITNO_MASK

#define    RTL8370_LUT_CFG_REG    RTL8370_REG_LUT_CFG

#define    RTL8370_LUT_AGEOUT_CRTL_REG    RTL8370_REG_LUT_AGEOUT_CRTL

#define    RTL8370_FORCE_FLUSH_REG    RTL8370_REG_FORCE_FLUSH

#define    RTL8370_STORM_BCAST_REG    RTL8370_REG_STORM_BCAST

#define    RTL8370_STORM_MCAST_REG    RTL8370_REG_STORM_MCAST

#define    RTL8370_STORM_UNKNOWN_UCAST_REG    RTL8370_REG_STORM_UNKOWN_UCAST

#define    RTL8370_STORM_UNKNOWN_MCAST_REG    RTL8370_REG_STORM_UNKOWN_MCAST

#define    RTL8370_STORM_BCAST_METER_CRTL_BASE    RTL8370_REG_STORM_BCAST_METER_CRTL0
#define    RTL8370_STORM_BCAST_METER_CRTL_REG(port)    (RTL8370_STORM_BCAST_METER_CRTL_BASE + (port >> 1))
#define    RTL8370_STORM_BCAST_METER_CRTL_OFFSET(port)    ((port & 0x1) << 3)
#define    RTL8370_STORM_BCAST_METER_CRTL_MASK(port)    (0xFF << RTL8370_STORM_BCAST_METER_CRTL_OFFSET(port))

#define    RTL8370_STORM_MCAST_METER_CRTL_BASE    RTL8370_REG_STORM_MCAST_METER_CRTL0
#define    RTL8370_STORM_MCAST_METER_CRTL_REG(port)    (RTL8370_STORM_MCAST_METER_CRTL_BASE + (port >> 1))
#define    RTL8370_STORM_MCAST_METER_CRTL_OFFSET(port)    ((port & 0x1) << 3)
#define    RTL8370_STORM_MCAST_METER_CRTL_MASK(port)    (0xFF << RTL8370_STORM_MCAST_METER_CRTL_OFFSET(port))

#define    RTL8370_STORM_UNDA_METER_CRTL_BASE    RTL8370_REG_STORM_UNDA_METER_CRTL0
#define    RTL8370_STORM_UNDA_METER_CRTL_REG(port)    (RTL8370_STORM_UNDA_METER_CRTL_BASE + (port >> 1))
#define    RTL8370_STORM_UNDA_METER_CRTL_OFFSET(port)    ((port & 0x1) << 3)
#define    RTL8370_STORM_UNDA_METER_CRTL_MASK(port)    (0xFF << RTL8370_STORM_UNDA_METER_CRTL_OFFSET(port))

#define    RTL8370_STORM_UNMC_METER_CRTL_BASE    RTL8370_REG_STORM_UNMC_METER_CRTL0
#define    RTL8370_STORM_UNMC_METER_CRTL_REG(port)    (RTL8370_STORM_UNMC_METER_CRTL_BASE + (port >> 1))
#define    RTL8370_STORM_UNMC_METER_CRTL_OFFSET(port)    ((port & 0x1) << 3)
#define    RTL8370_STORM_UNMC_METER_CRTL_MASK(port)    (0xFF << RTL8370_STORM_UNMC_METER_CRTL_OFFSET(port))

#define    RTL8370_OAM_PARSER_BASE    RTL8370_REG_OAM_PARSER_CTRL0
#define    RTL8370_OAM_PARSER_REG(port)    (RTL8370_OAM_PARSER_BASE + (port >> 3))
#define    RTL8370_OAM_PARSER_OFFSET(port)    ((port & 0x7) *2)
#define    RTL8370_OAM_PARSER_MASK(port)    (RTL8370_PORT0_PARACT_MASK << RTL8370_OAM_PARSER_OFFSET(port))

#define    RTL8370_OAM_MULTIPLEXER_BASE    RTL8370_REG_OAM_MULTIPLEXER_CTRL0
#define    RTL8370_OAM_MULTIPLEXER_REG(port)    (RTL8370_OAM_MULTIPLEXER_BASE + (port >> 3))
#define    RTL8370_OAM_MULTIPLEXER_OFFSET(port)    ((port & 0x7) * 2)
#define    RTL8370_OAM_MULTIPLEXER_MASK(port)    (RTL8370_PORT0_PARACT_MASK << RTL8370_OAM_MULTIPLEXER_OFFSET(port))

#define    RTL8370_OAM_CTRL_REG    RTL8370_REG_OAM_CTRL

#define    RTL8370_DOT1X_PORT_ENABLE_REG    RTL8370_REG_DOT1X_PORT_ENABLE

#define    RTL8370_DOT1X_MAC_ENABLE_REG    RTL8370_REG_DOT1X_MAC_ENABLE

#define    RTL8370_DOT1X_PORT_AUTH_REG    RTL8370_REG_DOT1X_PORT_AUTH

#define    RTL8370_DOT1X_PORT_OPDIR_REG    RTL8370_REG_DOT1X_PORT_OPDIR

#define    RTL8370_DOT1X_UNAUTH_ACT_BASE    RTL8370_REG_DOT1X_UNAUTH_ACT_W0
#define    RTL8370_DOT1X_UNAUTH_ACT_REG(port)    (RTL8370_DOT1X_UNAUTH_ACT_BASE + (port >> 3))
#define    RTL8370_DOT1X_UNAUTH_ACT_OFFSET(port)    ((port & 0x7) << 1)
#define    RTL8370_DOT1X_UNAUTH_ACT_MASK(port)    (RTL8370_DOT1X_PORT0_UNAUTHBH_MASK << RTL8370_DOT1X_UNAUTH_ACT_OFFSET(port))

#define    RTL8370_DOT1X_CFG_REG    RTL8370_REG_DOT1X_CFG

#define    RTL8370_REG_L2_LRN_CNT_BASE    RTL8370_REG_L2_LRN_CNT_CTRL0
#define    RTL8370_REG_L2_LRN_CNT_REG(port)    (RTL8370_REG_L2_LRN_CNT_BASE + port)

/* (16'h0b00) mltvlan_reg */

#define    RTL8370SG_SVLAN_MCAST2S_ENTRY_BASE_REG    RTL8370_REG_SVLAN_MCAST2S_ENTRY0_CTRL0

/* (16'h0c00) svlan_reg */

#define    RTL8370_SVLAN_MEMBERCFG_BASE_REG    RTL8370_REG_SVLAN_MEMBERCFG0_CTRL0
#define    RTL8370SG_SVLAN_C2SCFG_BASE_REG    RTL8370_REG_SVLAN_C2SCFG0_CTRL0
#define    RTL8370_SVLAN_CFG_REG    RTL8370_REG_SVLAN_CFG

/* (16'h0f00) hsactrl_reg */

#define    RTL8370_SVLAN_S2C_ENTRY_BASE_REG    RTL8370_REG_SVLAN_SP2C_ENTRY0_CTRL0

/* (16'h1000) mib_reg */

#define    RTL8370_MIB_COUNTER_BASE_REG    RTL8370_REG_MIB_COUNTER0

#define    RTL8370_MIB_ADDRESS_REG    RTL8370_REG_MIB_ADDRESS

#define    RTL8370_MIB_CTRL_REG    RTL8370_REG_MIB_CTRL0
#define    RTL8370_MIB_PORT07_MASK    (0xFF<<RTL8370_PORT0_RESET_OFFSET)	
#define    RTL8370_MIB_PORT815_MASK    (0xFF<<RTL8370_PORT8_RESET_OFFSET)	

/* (16'h1100) intrpt_reg */

#define    RTL8370_INTR_CTRL_REG    RTL8370_REG_INTR_CTRL

#define    RTL8370_INTR_IMR_REG    RTL8370_REG_INTR_IMR

#define    RTL8370_INTR_IMS_REG    RTL8370_REG_INTR_IMS

#define    RTL8370_INTR_INDICATOR_BASED    RTL8370_REG_LEARN_OVER_INDICATOR	
#define    RTL8370_LEARN_OVER_INDICATOR_REG    RTL8370_REG_LEARN_OVER_INDICATOR

#define    RTL8370_SPEED_CHANGE_INDICATOR_REG    RTL8370_REG_SPEED_CHANGE_INDICATOR

#define    RTL8370_PORT_LINKDOWN_INDICATOR_REG    RTL8370_REG_PORT_LINKDOWN_INDICATOR

#define    RTL8370_PORT_LINKUP_INDICATOR_REG    RTL8370_REG_PORT_LINKUP_INDICATOR

#define    RTL8370_REG_METER_EXCEED_INDICATOR_BASE    RTL8370_REG_METER_EXCEED_INDICATOR0
#define    RTL8370_REG_METER_EXCEED_INDICATOR_REG(meter)    (RTL8370_REG_METER_EXCEED_INDICATOR_BASE + (meter >> 4))
#define    RTL8370_REG_METER_EXCEED_INDICATOR_OFFSET(meter)    (meter & 0xF)
#define    RTL8370_REG_METER_EXCEED_INDICATOR_MASK(meter)    (RTL8370_METER0_MASK << RTL8370_REG_METER_EXCEED_INDICATOR_OFFSET(meter))

/* (16'h1200) swcore_reg */

#define    RTL8370_VS_TPID_REG    RTL8370_REG_VS_TPID

#define    RTL8370_SWITCH_MAC_BASE    RTL8370_REG_SWITCH_MAC2

#define    RTL8370_REMARKING_CTRL_REG    RTL8370_REG_SWITCH_CTRL0

#define    RTL8370_QOS_DSCP_REMARK_BASE    RTL8370_REG_QOS_DSCP_REMARK_CTRL0
#define    RTL8370_QOS_DSCP_REMARK_REG(pri)    (RTL8370_QOS_DSCP_REMARK_BASE + (pri >> 1))
#define    RTL8370_QOS_DSCP_REMARK_OFFSET(pri)    (((pri) & 0x1) << 3)
#define    RTL8370_QOS_DSCP_REMARK_MASK(pri)    (0x3F << RTL8370_QOS_DSCP_REMARK_OFFSET(pri))

#define    RTL8370_QOS_1Q_REMARK_BASE    RTL8370_REG_QOS_1Q_REMARK_CTRL0
#define    RTL8370_QOS_1Q_REMARK_REG(pri)    (RTL8370_QOS_1Q_REMARK_BASE + (pri >> 2))
#define    RTL8370_QOS_1Q_REMARK_OFFSET(pri)    ((pri & 0x3) << 2)
#define    RTL8370_QOS_1Q_REMARK_MASK(pri)    (0x7 << RTL8370_QOS_1Q_REMARK_OFFSET(pri))

#define    RTL8370_PTKGEN_PAYLOAD_CTRL0_REG    RTL8370_REG_PTKGEN_PAYLOAD_CTRL0

#define    RTL8370_PTKGEN_PAYLOAD_CTRL1_REG    RTL8370_REG_PTKGEN_PAYLOAD_CTRL1

#define    RTL8370_PTKGEN_PAUSE_TIME_REG    RTL8370_REG_PTKGEN_PAUSE_TIME

#define    RTL8370_TX_STOP_REG    RTL8370_REG_TX_STOP

#define    RTL8370_SVLAN_UPLINK_PORTMASK_REG    RTL8370_REG_SVLAN_UPLINK_PORTMASK

#define    RTL8370_CPU_PORT_MASK_REG    RTL8370_REG_CPU_PORT_MASK

#define    RTL8370_CPU_CTRL_REG    RTL8370_REG_CPU_CTRL

#define    RTL8370_MIRROR_CTRL_REG    RTL8370_REG_MIRROR_CTRL

#define    RTL8370_FLOWCTRL_CTRL_REG    RTL8370_REG_FLOWCTRL_CTRL0

#define    RTL8370_FLOWCTRL_ALL_ON_REG    RTL8370_REG_FLOWCTRL_ALL_ON

#define    RTL8370_FLOWCTRL_SYS_ON_REG    RTL8370_REG_FLOWCTRL_SYS_ON

#define    RTL8370_FLOWCTRL_SYS_OFF_REG    RTL8370_REG_FLOWCTRL_SYS_OFF

#define    RTL8370_FLOWCTRL_SHARE_ON_REG    RTL8370_REG_FLOWCTRL_SHARE_ON

#define    RTL8370_FLOWCTRL_SHARE_OFF_REG    RTL8370_REG_FLOWCTRL_SHARE_OFF

#define    RTL8370_FLOWCTRL_FCOFF_SYS_ON_REG    RTL8370_REG_FLOWCTRL_FCOFF_SYS_ON

#define    RTL8370_FLOWCTRL_FCOFF_SYS_OFF_REG    RTL8370_REG_FLOWCTRL_FCOFF_SYS_OFF

#define    RTL8370_FLOWCTRL_FCOFF_SHARE_ON_REG    RTL8370_REG_FLOWCTRL_FCOFF_SHARE_ON

#define    RTL8370_FLOWCTRL_FCOFF_SHARE_OFF_REG    RTL8370_REG_FLOWCTRL_FCOFF_SHARE_OFF

#define    RTL8370_FLOWCTRL_PORT_ON_REG    RTL8370_REG_FLOWCTRL_PORT_ON

#define    RTL8370_FLOWCTRL_PORT_OFF_REG    RTL8370_REG_FLOWCTRL_PORT_OFF

#define    RTL8370_FLOWCTRL_PORT_PRIVATE_ON_REG    RTL8370_REG_FLOWCTRL_PORT_PRIVATE_ON

#define    RTL8370_FLOWCTRL_PORT_PRIVATE_OFF_REG    RTL8370_REG_FLOWCTRL_PORT_PRIVATE_OFF

#define    RTL8370_RRCP_CTRL0_REG    RTL8370_REG_RRCP_CTRL0

#define    RTL8370_RRCP_PRIVATE_KEY_REG    RTL8370_REG_RRCP_CTRL1

#define    RTL8370_RRCP_AUTH_KEY_REG    RTL8370_REG_RRCP_CTRL2

#define    RTL8370_RRCP_TRUST_PORTMASK_REG    RTL8370_REG_RRCP_CTRL3

#define    RTL8370_FLOWCTRL_FCOFF_PORT_ON_REG    RTL8370_REG_FLOWCTRL_FCOFF_PORT_ON

#define    RTL8370_FLOWCTRL_FCOFF_PORT_OFF_REG    RTL8370_REG_FLOWCTRL_FCOFF_PORT_OFF

#define    RTL8370_FLOWCTRL_FCOFF_PORT_PRIVATE_ON_REG    RTL8370_REG_FLOWCTRL_FCOFF_PORT_PRIVATE_ON

#define    RTL8370_FLOWCTRL_FCOFF_PORT_PRIVATE_OFF_REG    RTL8370_REG_FLOWCTRL_FCOFF_PORT_PRIVATE_OFF

#define    RTL8370_FLOWCRTL_EGRESS_QUEUE_ENABLE_BASE    RTL8370_REG_FLOWCRTL_EGRESS_QUEUE_ENABLE_CTRL0
#define    RTL8370_FLOWCRTL_EGRESS_QUEUE_ENABLE_REG(port)    (RTL8370_FLOWCRTL_EGRESS_QUEUE_ENABLE_BASE + (port >> 1))
#define    RTL8370_FLOWCRTL_EGRESS_QUEUE_ENABLE_REG_OFFSET(port)    ((port & 0x1) << 3)
#define    RTL8370_FLOWCRTL_EGRESS_QUEUE_ENABLE_REG_MASK(port)    (RTL8370_PORT0_QUEUE_MASK_MASK << RTL8370_FLOWCRTL_EGRESS_QUEUE_ENABLE_REG_OFFSET(port))

#define    RTL8370_FLOWCRTL_EGRESS_PORT_ENABLE_REG    RTL8370_REG_FLOWCRTL_EGRESS_PORT_ENABLE

#define    RTL8370_FLOWCTRL_TOTAL_PAGE_COUNTER_REG    RTL8370_REG_FLOWCTRL_TOTAL_PAGE_COUNTER

#define    RTL8370_FLOWCTRL_PUBLIC_PAGE_COUNTER_REG    RTL8370_REG_FLOWCTRL_PUBLIC_PAGE_COUNTER

#define    RTL8370_FLOWCTRL_TOTAL_PAGE_MAX_REG    RTL8370_REG_FLOWCTRL_TOTAL_PAGE_MAX

#define    RTL8370_FLOWCTRL_PUBLIC_PAGE_MAX_REG    RTL8370_REG_FLOWCTRL_PUBLIC_PAGE_MAX

#define    RTL8370_FLOWCTRL_PORT_PAGE_COUNTER_BASE    RTL8370_REG_FLOWCTRL_PORT0_PAGE_COUNTER
#define    RTL8370_FLOWCTRL_PORT_PAGE_COUNTER_REG(port)    (RTL8370_FLOWCTRL_PORT_PAGE_COUNTER_BASE + port)
#define    RTL8370_FLOWCTRL_PORT_PAGE_COUNTER_MASK    RTL8370_FLOWCTRL_PORT0_PAGE_COUNTER_MASK

#define    RTL8370_FLOWCTRL_PORT_PAGE_MAX_BASE    RTL8370_REG_FLOWCTRL_PORT0_PAGE_MAX
#define    RTL8370_FLOWCTRL_PORT_PAGE_MAX_REG(port)    (RTL8370_FLOWCTRL_PORT_PAGE_MAX_BASE + port)
#define    RTL8370_FLOWCTRL_PORT_PAGE_MAX_MASK    RTL8370_FLOWCTRL_PORT0_PAGE_MAX_MASK

/* (16'h1300) chip_reg*/

/* (16'h1400) mtrpool_reg */
#define    RTL8370_METER_RATE_BASE    RTL8370_REG_METER0_RATE_CTRL0
#define    RTL8370_METER_RATE_REG(meter)    ((meter << 1) + RTL8370_METER_RATE_BASE)

#define    RTL8370_METER_BUCKET_SIZE_BASE    RTL8370_REG_METER0_BUCKET_SIZE
#define    RTL8370_METER_BUCKET_SIZE_REG(meter)    (RTL8370_METER_BUCKET_SIZE_BASE + meter)

#define    RTL8370_LEAKY_BUCKET_TICK_REG    RTL8370_REG_METER_CTRL0
#define    RTL8370_LEAKY_BUCKET_TICK_OFFSET    0
#define    RTL8370_LEAKY_BUCKET_TICK_MASK    0xFF

#define    RTL8370_LEAKY_BUCKET_TOKEN_REG    RTL8370_REG_METER_CTRL1
#define    RTL8370_LEAKY_BUCKET_TOKEN_OFFSET    0
#define    RTL8370_LEAKY_BUCKET_TOKEN_MASK    0xFF

#define    RTL8370_METER_OVERRATE_INDICATOR_BASE    RTL8370_REG_METER_OVERRATE_INDICATOR0
#define    RTL8370_METER_OVERRATE_INDICATOR_REG(meter)    (RTL8370_METER_OVERRATE_INDICATOR_BASE + (meter >> 4))
#define    RTL8370_METER_EXCEED_OFFSET(meter)    (meter & 0xF)
#define    RTL8370_METER_EXCEED_MASK(meter)    (1 << RTL8370_METER_EXCEED_OFFSET(meter))

#define    RTL8370_METER_IFG_CTRL_BASE    RTL8370_REG_METER_IFG_CTRL0
#define    RTL8370_METER_IFG_CTRL_REG(meter)    (RTL8370_METER_IFG_CTRL_BASE + (meter >> 4))
#define    RTL8370_METER_IFG_OFFSET(meter)    (meter & 0xF)
#define    RTL8370_METER_IFG_MASK(meter)    (1 << RTL8370_METER_IFG_OFFSET(meter))

#define    RTL8370_FLOWCTRL_CTRL_REG    RTL8370_REG_FLOWCTRL_CTRL0

/* (16'h1800)8051_RLDP_EEE_reg */

#define    RTL8370_DW8051_IMR_REG    RTL8370_REG_DW8051_IMR

#define    RTL8370_DW8051_IMS_REG    RTL8370_REG_DW8051_IMS

#define    RTL8370_DW8051_PROP_REG_BASE    RTL8370_REG_DW8051_CTRL0

#define    RTL8370_EEELLDP_CTRL0_REG    RTL8370_REG_EEELLDP_CTRL0

#define    RTL8370_EEELLDP_CTRL1_REG    RTL8370_REG_EEELLDP_CTRL1

#define    RTL8370_EEELLDP_PMSK_REG    RTL8370_REG_EEELLDP_PMSK

#define    RTL8370_EEELLDP_TX_FRAMEU_REG_BASE    RTL8370_REG_EEELLDP_FRAMEU00

#define    RTL8370_EEELLDP_TX_CAP_FRAMEL_REG_BASE    RTL8370_REG_EEELLDP_CAP_FRAMEL00

#define    RTL8370_EEELLDP_TX_ACK_FRAMEL_REG_BASE    RTL8370_REG_EEELLDP_ACK_FRAMEL00

#define    RTL8370_EEELLDP_RX_VALUE_PORT_BASE    RTL8370_REG_EEELLDP_RX_VALUE_P00_00
#define    RTL8370_EEELLDP_RX_VALUE_PORT_REG(port)    (RTL8370_EEELLDP_RX_VALUE_PORT_BASE + (port * 9))

#define    RTL8370_RLDP_CTRL0_REG    RTL8370_REG_RLDP_CTRL0

/* data writen to [15:8] will be writen to writen to [7:0] */
/* However, the read operation is normal */
#define    RTL8370_RLDP_RETRY_COUNT_LOOPSTATE_READ_OFFSET 0
#define    RTL8370_RLDP_RETRY_COUNT_LOOPSTATE_READ_MASK   0xFF
#define    RTL8370_RLDP_RETRY_COUNT_CHKSTATE_READ_OFFSET  8
#define    RTL8370_RLDP_RETRY_COUNT_CHKSTATE_READ_MASK    0xFF00
#define    RTL8370_RLDP_RETRY_COUNT_LOOPSTATE_WRITE_OFFSET 0
#define    RTL8370_RLDP_RETRY_COUNT_LOOPSTATE_WRITE_MASK   0xFF
#define    RTL8370_RLDP_RETRY_COUNT_CHKSTATE_WRITE_OFFSET  8
#define    RTL8370_RLDP_RETRY_COUNT_CHKSTATE_WRITE_MASK    0xFF00

#define    RTL8370_RLDP_RETRY_COUNT_REG    RTL8370_REG_RLDP_CTRL1

#define    RTL8370_RLDP_RETRY_PERIOD_LOOPSTATE_REG    RTL8370_REG_RLDP_CTRL2

#define    RTL8370_RLDP_RETRY_PERIOD_CHKSTATE_REG    RTL8370_REG_RLDP_CTRL3

#define    RTL8370_RLDP_TX_PMSK_REG    RTL8370_REG_RLDP_CTRL4

#define    RTL8370_RLDP_RAND_NUM_REG_BASE    RTL8370_REG_RLDP_RAND_NUM0

#define    RTL8370_RLDP_SEED_NUM_REG_BASE    RTL8370_REG_RLDP_SEED_NUM0

#define    RTL8370_RLDP_LOOP_PMSK_REG    RTL8370_REG_RLDP_LOOP_PMSK

#define    RTL8370_RLDP_LOOP_PORT_BASE    RTL8370_REG_RLDP_LOOP_PORT_REG0
#define    RTL8370_RLDP_LOOP_PORT_REG(port)    (RTL8370_RLDP_LOOP_PORT_BASE + (port >> 1))
#define    RTL8370_RLDP_LOOP_PORT_OFFSET(port)    ((port & 0x1) << 3)
#define    RTL8370_RLDP_LOOP_PORT_MASK(port)    (RTL8370_RLDP_LOOP_PORT_00_MASK << RTL8370_RLDP_LOOP_PORT_OFFSET(port))

#define    RTL8370_PAGEMETER_PORT_BASE    RTL8370_REG_PAGEMETER_PORT0_CTRL0
#define    RTL8370_PAGEMETER_PORT_REG(port)    (RTL8370_PAGEMETER_PORT_BASE + 0x20*port)

#define    RTL8370_HIGHPRI_INDICATOR_REG    RTL8370_REG_HIGHPRI_INDICATOR
#define    RTL8370_PORT_INDICATOR_OFFSET(port)    (port)
#define    RTL8370_PORT_INDICATOR_MASK(port)    (RTL8370_PORT0_INDICATOR_MASK << RTL8370_PORT_INDICATOR_OFFSET(port))

#define    RTL8370_HIGHPRI_CFG_REG    RTL8370_REG_HIGHPRI_CFG

#define    RTL8370_PKG_CFG_BASE    							RTL8370_REG_PKTGEN_PORT0_CTRL
#define    RTL8370_PKG_CFG_REG(port)    						(RTL8370_PKG_CFG_BASE + (port*0x20))

#define    RTL8370_PKG_DA_BASE    								RTL8370_REG_PKTGEN_PORT0_DA0
#define    RTL8370_PKG_DA_REG(port)    						(RTL8370_PKG_DA_BASE + (port*0x20))

#define    RTL8370_PKG_SA_BASE    								RTL8370_REG_PKTGEN_PORT0_SA0
#define    RTL8370_PKG_SA_REG(port)    						(RTL8370_PKG_SA_BASE + (port*0x20))

#define    RTL8370_PKG_NUM_BASE    							RTL8370_REG_PKTGEN_PORT0_COUNTER0
#define    RTL8370_PKG_NUM_REG(port)    						(RTL8370_PKG_NUM_BASE + (port*0x20))

#define    RTL8370_PKG_LENGTH_BASE    							RTL8370_REG_PKTGEN_PORT0_TX_LENGTH
#define    RTL8370_PKG_LENGTH_REG(port)    					(RTL8370_PKG_LENGTH_BASE + (port*0x20))

#define    RTL8370_PKG_MAXLENTH_BASE    						RTL8370_REG_PKTGEN_PORT0_MAX_LENGTH
#define    RTL8370_PKG_MAXLENGTH_REG(port)    					(RTL8370_PKG_MAXLENTH_BASE + (port*0x20))

#endif /*#ifndef _RTL8370_BASE_H_*/

