/*****************************************************************************
 * ;
 * ;   (C) Unpublished Work of SENAO Networks Incorporated.  All Rights Reserved.
 * ;
 * ;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
 * ;       PROPRIETARY AND TRADESECRET INFORMATION OF SENAO INCORPORATED.
 * ;       ACCESS TO THIS WORK IS RESTRICTED TO (I) SENAO EMPLOYEES WHO HAVE A
 * ;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
 * ;       AND (II) ENTITIES OTHER THAN SENAO WHO HAVE ENTERED INTO APPROPRIATE
 * ;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
 * ;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
 * ;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
 * ;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF SENAO.
 * ;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
 * ;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
 * ;
 * ;------------------------------------------------------------------------------
 * ;
 * ;    Project : ESR1221N, N2, NH. RF: RTL8188, 8192
 * ;    Creator : David Chang
 * ;    File    : rtl819x_senao.h
 * ;    Abstract:
 * ;
 * ;       Modification History:
 * ;       By              Date     Ver.   Modification Description
 * ;       --------------- -------- -----  --------------------------------------
 * ;       David           20100629        Newly Create
 * ;*****************************************************************************/

#ifndef	__WPS_LED_H__
#define	__WPS_LED_H__

/*-----------------------------------------------------------------------------
 *                     include files
 *----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 *                     macros, defines, typedefs, enums
 *----------------------------------------------------------------------------*/
#define WPS_LED_TIME1		HZ/10 //100ms
#define WPS_LED_TIME2		HZ/5  //200ms
#define WPS_LED_TIME3		HZ/2  //500ms
#define WPS_LED_TIME4		HZ	  //1s
#define WPS_LED_TIME5		HZ*120 //120s
#define WPS_LED_TIME6		HZ*300 //300s
#define WPS_LED_CK_TIME		HZ/20 //50ms
/*-----------------------------------------------------------------------------
 *                     description
 *----------------------------------------------------------------------------*/
/*
	1. in progress: 	on:0.2s, off:0.1s, period: 120s
	2. Error:			on:0.1s, off:0.1s, period: 300s
	3. Session Overlop: on:0.1s off:0.1s, after 1s--> off 0.5s, period 300s
	4. Success:			on:300s	
*/
/*-----------------------------------------------------------------------------
 *                     data declarations, extern, static, const
 *----------------------------------------------------------------------------*/
typedef enum
{
	WPS_NORMAL_OPERATION = 0,
	WPS_INPROGRESS,
	WPS_ERROR,
	WPS_SESSION_OVERLAP_DETECTED,
	WPS_SUCCESS,
} WPS_LED_TYPE;

typedef struct _wps_led_action_t
{
    int 			on_time;
    int 			off_time;
    int 			cycle_time;
} wps_led_action_t;

/*-----------------------------------------------------------------------------
 *                     functions declarations
 *----------------------------------------------------------------------------*/
extern void wps_led_control(int i_rtl_wps_action);
extern void wps_led_init(void);

#endif /*__WPS_LED_H__*/
