/*****************************************************************************
;
;   (C) Unpublished Work of Senao Networks, Inc.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF SENAO INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) SENAO EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN SENAO WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF SENAO.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : 
;    Creator : 
;    File    : 
;    Abstract: 
;
;       Modification History:
;       By              Date     Ver.   Modification Description
;       --------------- -------- -----  --------------------------------------
;       
;*****************************************************************************/

/*-----------------------------------------------------------------------------
 *                     include files
 *----------------------------------------------------------------------------*/
#include <linux/sched.h>
#include <linux/proc_fs.h>
#include <asm/uaccess.h> /*copy_from_user*/

/*Engenius specific header*/
#include "wps_led_sn.h"
#include "sysgpio.h"
// #include <net/rtl/rtl819x_senao.h>
#if defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)
	#include "drivers/net/rtl819x/AsicDriver/rtl865xc_asicregs.h"
#endif
#ifdef GPIO_DEBUG
/* note: prints function name for you */
    #define DPRINTK(fmt, args...) printk("%s: " fmt, __FUNCTION__ , ## args)
#else
    //#define DPRINTK(fmt, args...) panic_printk("%s: " fmt, __FUNCTION__ , ## args)
    #define DPRINTK(fmt, args...)
#endif
#if defined(CONFIG_RTL_8196C)
    	#define RTL_GPIO_IOBASE         PABCD_CNR       //RTL_GPIO_PABCD_CNR
    	#define RTL_GPIO_DIRBASE        PABCD_DIR       //RTL_GPIO_PABCD_DIR 
    	#define RTL_GPIO_DATABASE       PABCD_DAT       //RTL_GPIO_PABCD_DATA
		#define GET_SN_WPS_LED          (RTL_R32(RTL_GPIO_DATABASE)&((1 << SENAO_GPIO_LED_WPS)))
		#define SET_SN_WPS_LED_ON       {RTL_W32(RTL_GPIO_DATABASE, (RTL_R32(RTL_GPIO_DATABASE) & (~(1 << SENAO_GPIO_LED_WPS))));}
		#define SET_SN_WPS_LED_OFF      {RTL_W32(RTL_GPIO_DATABASE, (RTL_R32(RTL_GPIO_DATABASE) | ((1 << SENAO_GPIO_LED_WPS))));}
#elif defined(CONFIG_RTL_8198)
		#define GET_SN_WPS_LED          (RTL_R32(PEFGH_DAT)&((1 << SENAO_GPIO_LED_WPS)))
		#define SET_SN_WPS_LED_ON       {RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(1 << SENAO_GPIO_LED_WPS))));}
		#define SET_SN_WPS_LED_OFF      {RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | ((1 << SENAO_GPIO_LED_WPS))));}
#endif 
/*-----------------------------------------------------------------------------
 *                     macros, defines, typedefs, enums
 *----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 *                     data declarations, extern, static, const
 *----------------------------------------------------------------------------*/
typedef struct _rtl_wps_led_t
{
	int				i_rtl_wps_action;/*refer to gpio.h*/
	WPS_LED_TYPE	e_rtl_wps_led_type;
	
} rtl_wps_led_t;

static rtl_wps_led_t g_rtl_wps_led;
static struct timer_list wps_led_timer;
#if WLAN_WPS_LED_NO_GPIO
int g_rtl_wps_action;
#endif
#ifdef WLAN_WPS_USE_SAME_LED
int rtl_wps_using = 0;
#endif 
// /*global wps timer and status*/
// wps_led_action_t wps_led_action[]=
// {
// #if defined (HAS_SITECOM_STYLE_WPS)
//     [WPS_NORMAL_OPERATION]	= {0,0,0},
//     [WPS_INPROGRESS]	={WPS_LED_TIME2,WPS_LED_TIME1,WPS_LED_TIME5},
//     [WPS_ERROR]			={0,0,0},
//     [WPS_SESSION_OVERLAP_DETECTED]={0,0,0},
//     [WPS_SUCCESS]		={0,0,0},
// #endif
// };

/*-----------------------------------------------------------------------------
 *                     functions declarations
 *----------------------------------------------------------------------------*/
static int counter=0;
static int overlap_counter=0;
/*control wps led behaviour*/
#ifdef SENAO_GPIO_LED_WPS
void wps_led_control(int i_rtl_wps_action)
{
	/*one counter=50ms*/
#ifdef WLAN_WPS_USE_SAME_LED
    if(WPS_LED_GPIO_NOP_NUM == i_rtl_wps_action)
        rtl_wps_using = 0;
    else
        rtl_wps_using = 1;
    if(rtl_wps_using == 1)
#endif
    {
        switch(i_rtl_wps_action)
        {
            case WPS_START_LED_GPIO_NUM:/*on 0.2, 0ff 0.1*/
                if(++counter<=4)/*4*50ms=0.2s*/
                    SET_SN_WPS_LED_ON
                else if(++counter<=6)/*2*50ms=0.1s*/
                    SET_SN_WPS_LED_OFF
                else
                    counter=0;
                break;
            case WPS_PBC_OVERLAPPING_GPIO_NUM:/*on 0.1, off 0.1, after 1s, off 0.5s*/
                if(++overlap_counter<=20) /*1s*/
                {
                    if(++counter<=2)
                        SET_SN_WPS_LED_ON
                    else if(++counter<=4)
                        SET_SN_WPS_LED_OFF
                    else
                        counter=0;
                }
                else if(++overlap_counter<=30) /*0.5s*/
                    SET_SN_WPS_LED_OFF
                else
                    overlap_counter=0;
    
                break;
            case WPS_ERROR_LED_GPIO_NUM: /*on 0.1, 0ff 0.1*/
                #ifndef HAS_SITECOM_STYLE_WPS
		if(++counter<=2)
                    SET_SN_WPS_LED_ON
                else if(++counter<=4)
                    SET_SN_WPS_LED_OFF
                else
                    counter=0;
                break;
		#else	
		break;
		#endif
            case WPS_SUCCESS_LED_GPIO_NUM: /*always on */
                #ifndef HAS_SITECOM_STYLE_WPS
		counter=0;
                SET_SN_WPS_LED_ON
                break;
		#else
		SET_SN_WPS_LED_OFF
		break;
		#endif
            case WPS_LED_GPIO_NOP_NUM: /*always off*/
                counter=0;
                SET_SN_WPS_LED_OFF
                break;
            default:
                break;		
        }
    }
	return;
}
#endif

static int sn_wps_led_read_proc(char *page, char **start, off_t off, int count, int *eof, void *data)
{
	int len;

	len = sprintf(page, "%d\n", g_rtl_wps_led.i_rtl_wps_action);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}
#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif 
static int sn_wps_led_write_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
    int num, state;
	char flag[20];
// 
 	if (count < 1)
 		return -EFAULT;
 
 	if (buffer && !copy_from_user(&flag, buffer, 20)) 
 	{
 	    num = sscanf(flag, "%d", &state);
 		
 		if (num != 1) 
 		{
 			printk("invalid gpio parameter!\n");
 		}

		g_rtl_wps_led.i_rtl_wps_action=state;
	#if WLAN_WPS_LED_NO_GPIO
		g_rtl_wps_action = state;
	#endif
 		return count;
 	}
 	else
 	{
 		return -EFAULT;
 	}
}
/* update the timer*/
void rtl_wps_led_timer(unsigned long data)
{
#ifdef SENAO_GPIO_LED_WPS
	wps_led_control(g_rtl_wps_led.i_rtl_wps_action);
#endif
	mod_timer(&wps_led_timer, jiffies + WPS_LED_CK_TIME);
    return;
}

/*init the timer*/
void wps_led_init(void)
{
 	struct proc_dir_entry *res=NULL;
	DPRINTK("Init wps_led\n");
    memset(&g_rtl_wps_led, 0, sizeof(g_rtl_wps_led));
	/*create proc*/
 	res = create_proc_entry("wps", 0, NULL);
 	if (res)
 	{
  		res->read_proc = sn_wps_led_read_proc;
  		res->write_proc = sn_wps_led_write_proc;
 	}
 	else
 	{
 		printk("Realtek GPIO Driver, create proc failed!\n");
 	}
	/*init timer*/
	init_timer(&wps_led_timer);
	wps_led_timer.expires = jiffies + WPS_LED_CK_TIME;
	wps_led_timer.data = (unsigned long)NULL;
	wps_led_timer.function = &rtl_wps_led_timer;
	mod_timer(&wps_led_timer, jiffies + WPS_LED_CK_TIME);
	return;
}
