/*
 * FILE NAME rtl_gpio.c
 *
 * BRIEF MODULE DESCRIPTION
 *  GPIO For Flash Reload Default
 *
 *  Author: jimmylin@realtek.com.tw
 *
 * Copyright 2005 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE	LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*-----------------------------------------------------------------------------
 *                     include files
 *----------------------------------------------------------------------------*/

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/interrupt.h>
#include <asm/errno.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/pid_namespace.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/reboot.h>
#include <linux/kmod.h>
#include <linux/proc_fs.h>

/*Engenius specific header*/
#include "sysgpio.h"
#include "wps_led_sn.h"
#include <net/rtl/rtl819x_senao.h>
#if defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)
	#include "drivers/net/rtl819x/AsicDriver/rtl865xc_asicregs.h"
#endif

/*-----------------------------------------------------------------------------
 *                     macros, defines, typedefs, enums
 *----------------------------------------------------------------------------*/
#if defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)
	/*jaykung we don't use rf_switch so far*/
//	#define READ_RF_SWITCH_GPIO
#endif

#if defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)
/*define the GPIO physical address to customer_gpio.h*/
#if defined(CONFIG_RTL_8196C)	
	#define RESET_PIN_IOBASE PABCD_CNR 	//RTL_GPIO_PABCD_CNR
	#define RESET_PIN_DIRBASE PABCD_DIR	//RTL_GPIO_PABCD_DIR 
	#define RESET_PIN_DATABASE PABCD_DAT //RTL_GPIO_PABCD_DATA
	#define RESET_PIN_NO 0 /*number of the ABCD*/

	#define RESET_LED_IOBASE PABCD_CNR 	//RTL_GPIO_PABCD_CNR
	#define RESET_LED_DIRBASE PABCD_DIR	//RTL_GPIO_PABCD_DIR 
	#define RESET_LED_DATABASE PABCD_DAT //RTL_GPIO_PABCD_DATA
	#define RESET_LED_NO 18 /*number of the ABCD*/

	#define AUTOCFG_LED_IOBASE PABCD_CNR 	//RTL_GPIO_PABCD_CNR
	#define AUTOCFG_LED_DIRBASE PABCD_DIR	//RTL_GPIO_PABCD_DIR 
	#define AUTOCFG_LED_DATABASE PABCD_DAT //RTL_GPIO_PABCD_DATA
	#define AUTOCFG_LED_NO 20 /*number of the ABCD*/

	#define AUTOCFG_PIN_IOBASE PABCD_CNR 	//RTL_GPIO_PABCD_CNR
	#define AUTOCFG_PIN_DIRBASE PABCD_DIR	//RTL_GPIO_PABCD_DIR 
	#define AUTOCFG_PIN_DATABASE PABCD_DAT //RTL_GPIO_PABCD_DATA
	#define AUTOCFG_PIN_NO 1 /*number of the ABCD)*/
	#define AUTOCFG_PIN_IMR PAB_IMR
#elif defined(CONFIG_RTL_8198)
	#define RESET_PIN_IOBASE PEFGH_CNR 	//RTL_GPIO_PABCD_CNR
	#define RESET_PIN_DIRBASE PEFGH_DIR	//RTL_GPIO_PABCD_DIR 
	#define RESET_PIN_DATABASE PEFGH_DAT //RTL_GPIO_PABCD_DATA
	#define RESET_PIN_NO 25 /*number of the ABCD*/

	#define RESET_LED_IOBASE PEFGH_CNR 	//RTL_GPIO_PABCD_CNR
	#define RESET_LED_DIRBASE PEFGH_DIR	//RTL_GPIO_PABCD_DIR 
	#define RESET_LED_DATABASE PEFGH_DAT //RTL_GPIO_PABCD_DATA
	#define RESET_LED_NO 27 /*number of the ABCD*/

	#define AUTOCFG_LED_IOBASE PEFGH_CNR 	//RTL_GPIO_PABCD_CNR
	#define AUTOCFG_LED_DIRBASE PEFGH_DIR	//RTL_GPIO_PABCD_DIR 
	#define AUTOCFG_LED_DATABASE PEFGH_DAT //RTL_GPIO_PABCD_DATA
	#define AUTOCFG_LED_NO 20 /*number of the ABCD*/

	#define AUTOCFG_PIN_IOBASE PEFGH_CNR 	//RTL_GPIO_PABCD_CNR
	#define AUTOCFG_PIN_DIRBASE PEFGH_DIR	//RTL_GPIO_PABCD_DIR 
	#define AUTOCFG_PIN_DATABASE PEFGH_DAT //RTL_GPIO_PABCD_DATA
	#define AUTOCFG_PIN_NO 1 /*number of the ABCD)*/
	#define AUTOCFG_PIN_IMR PGH_IMR
	
#endif /*CONFIG_RTL_8196C*/

#if defined(READ_RF_SWITCH_GPIO)
	#define WIFI_ONOFF_PIN_IOBASE PABCD_CNR 	//RTL_GPIO_PABCD_CNR
	#define WIFI_ONOFF_PIN_DIRBASE PABCD_DIR	//RTL_GPIO_PABCD_DIR 
	#define WIFI_ONOFF_PIN_DATABASE PABCD_DAT //RTL_GPIO_PABCD_DATA
	#define WIFI_ONOFF_PIN_NO 19/*umber of the ABCD)*/
	#define WIFI_ONOFF_PIN_IMR PAB_IMR
#endif

	#define RTL_GPIO_MUX 0xB8000040
	#define RTL_GPIO_MUX_2 0xB8000044

#ifdef CONFIG_8198_PORT5_GMII
	#define RTL_GPIO_MUX_DATA 0x00340000
#else 
	#define RTL_GPIO_MUX_DATA 0x00340C00//for WIFI ON/OFF and GPIO
#endif 

	#define RTL_GPIO_WIFI_ONOFF     19

#if 0/*jaykung useless in our platform*/
#if defined(CONFIG_RTL_8196C)	 
	 #define AUTOCFG_BTN_PIN         3
	 #define AUTOCFG_LED_PIN         4
	 #define RESET_LED_PIN           6
	 #define RESET_BTN_PIN           5
#elif defined(CONFIG_RTL_8198)
	 #define AUTOCFG_BTN_PIN         24
	 #define AUTOCFG_LED_PIN         26
	 #define RESET_LED_PIN           27
	 #define RESET_BTN_PIN           25
#endif	 
#endif /*if 0*/

#endif /*defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)*/

#ifdef USE_ENGENIUS_GPIO_LED
    /*wps btn state*/
    #define WPS_BTN_RELEASED            0
    #define WPS_BTN_PRESSED             1

    #if defined(CONFIG_RTL_8196C)
      	#define RTL_GPIO_IOBASE         PABCD_CNR       //RTL_GPIO_PABCD_CNR
    	#define RTL_GPIO_DIRBASE        PABCD_DIR       //RTL_GPIO_PABCD_DIR 
    	#define RTL_GPIO_DATABASE       PABCD_DAT       //RTL_GPIO_PABCD_DATA
    #elif defined(CONFIG_RTL_8198)
      	#define RTL_GPIO_IOBASE         PEFGH_CNR       //RTL_GPIO_PABCD_CNR
    	#define RTL_GPIO_DIRBASE        PEFGH_DIR       //RTL_GPIO_PABCD_DIR 
    	#define RTL_GPIO_DATABASE       PEFGH_DAT       //RTL_GPIO_PABCD_DATA    
    #endif /*defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)*/

  #ifdef SENAO_GPIO_BUTTON_RESET
    #define GET_SN_RESET_BTN        (RTL_R32(RTL_GPIO_DATABASE)&((1 << SENAO_GPIO_BUTTON_RESET)))
  #endif

  #ifdef SENAO_GPIO_BUTTON_WPS
    #define GET_SN_WPS_BTN          (RTL_R32(RTL_GPIO_DATABASE)&((1 << SENAO_GPIO_BUTTON_WPS)))
  #endif

  #ifdef SENAO_GPIO_LED_WLAN
    #define GET_SN_WLAN_LED         (RTL_R32(RTL_GPIO_DATABASE)&((1 << SENAO_GPIO_LED_WLAN)))
    #define SET_SN_WLAN_LED_ON      {RTL_W32(RTL_GPIO_DATABASE, (RTL_R32(RTL_GPIO_DATABASE) & (~(1 << SENAO_GPIO_LED_WLAN))));}
    #define SET_SN_WLAN_LED_OFF     {RTL_W32(RTL_GPIO_DATABASE, (RTL_R32(RTL_GPIO_DATABASE) | ((1 << SENAO_GPIO_LED_WLAN))));}
  #else
    #define GET_SN_WLAN_LED         0    
    #define SET_SN_WLAN_LED_ON
    #define SET_SN_WLAN_LED_OFF
  #endif

  #ifdef SENAO_GPIO_LED_WPS
    #define GET_SN_WPS_LED          (RTL_R32(RTL_GPIO_DATABASE)&((1 << SENAO_GPIO_LED_WPS)))
    #define SET_SN_WPS_LED_ON       {RTL_W32(RTL_GPIO_DATABASE, (RTL_R32(RTL_GPIO_DATABASE) & (~(1 << SENAO_GPIO_LED_WPS))));}
    #define SET_SN_WPS_LED_OFF      {RTL_W32(RTL_GPIO_DATABASE, (RTL_R32(RTL_GPIO_DATABASE) | ((1 << SENAO_GPIO_LED_WPS))));}    
  #else
    #define GET_SN_WPS_LED          0
    #define SET_SN_WPS_LED_ON
    #define SET_SN_WPS_LED_OFF
  #endif

  #ifdef SENAO_GPIO_SWITCH_BUTTON_3_LEVEL
  #if (SENAO_GPIO_PART_SWITCH_BUTTON_3_LEVEL==0)
    #define GET_SN_SWITCH_BTN      (RTL_R32(PABCD_DAT)&((1<<SENAO_GPIO_SWITCH_BUTTON_LEVEL_L)|(1<<SENAO_GPIO_SWITCH_BUTTON_LEVEL_M)|(1<<SENAO_GPIO_SWITCH_BUTTON_LEVEL_R)))
  #else
    #define GET_SN_SWITCH_BTN      (RTL_R32(PEFGH_DAT)&((1<<SENAO_GPIO_SWITCH_BUTTON_LEVEL_L)|(1<<SENAO_GPIO_SWITCH_BUTTON_LEVEL_M)|(1<<SENAO_GPIO_SWITCH_BUTTON_LEVEL_R)))
  #endif
  #endif

    /* Normally, RTL_8196C use PABCD, RTL_8198 use PEFGH */
	#define SET_SN_CNR_GPIO(x) 	   (RTL_W32(RTL_GPIO_IOBASE, (RTL_R32(RTL_GPIO_IOBASE) & (~(1 << x)))))  
    #define SET_SN_DIR_OUT(x)      (RTL_W32(RTL_GPIO_DIRBASE, (RTL_R32(RTL_GPIO_DIRBASE) | ((1 << x)))))
    #define SET_SN_DIR_IN(x)       (RTL_W32(RTL_GPIO_DIRBASE, (RTL_R32(RTL_GPIO_DIRBASE) & (~(1 << x)))))  
    #define GET_SN_DATA(x)         (RTL_R32(RTL_GPIO_DATABASE)&((1 << x)))
    #define SET_SN_LED_ON(x)       (RTL_W32(RTL_GPIO_DATABASE, (RTL_R32(RTL_GPIO_DATABASE) & (~(1 << x)))))
    #define SET_SN_LED_OFF(x)      (RTL_W32(RTL_GPIO_DATABASE, (RTL_R32(RTL_GPIO_DATABASE) | ((1 << x)))))

    /* GPIO Part ABCD */
	#define SET_SN_CNR_GPIO_A(x)   (RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~(1 << x)))))  
    #define SET_SN_DIR_OUT_A(x)    (RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | ((1 << x)))))
    #define SET_SN_DIR_IN_A(x)     (RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) & (~(1 << x)))))  
    #define GET_SN_DATA_A(x)       (RTL_R32(PABCD_DAT)&((1 << x)))
    #define SET_SN_LED_ON_A(x)     (RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << x)))))
    #define SET_SN_LED_OFF_A(x)    (RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | ((1 << x)))))

    /* GPIO Part EFGH */
	#define SET_SN_CNR_GPIO_E(x)   (RTL_W32(PEFGH_CNR, (RTL_R32(PEFGH_CNR) & (~(1 << x)))))  
    #define SET_SN_DIR_OUT_E(x)    (RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) | ((1 << x)))))
    #define SET_SN_DIR_IN_E(x)     (RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) & (~(1 << x)))))  
    #define GET_SN_DATA_E(x)       (RTL_R32(PEFGH_DAT)&((1 << x)))
    #define SET_SN_LED_ON_E(x)     (RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(1 << x)))))
    #define SET_SN_LED_OFF_E(x)    (RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | ((1 << x)))))

    /* y decide GPIO Part */
	#define SET_SN_CNR_GPIO_X(x,y)   do {if(y==0) SET_SN_CNR_GPIO_A(x);else SET_SN_CNR_GPIO_E(x);} while(0)
    #define SET_SN_DIR_OUT_X(x,y)    do {if(y==0) SET_SN_DIR_OUT_A(x);else SET_SN_DIR_OUT_E(x);} while(0)
    #define SET_SN_DIR_IN_X(x,y)     do {if(y==0) SET_SN_DIR_IN_A(x);else SET_SN_DIR_IN_E(x);} while(0)
    #define SET_SN_LED_ON_X(x,y)     do {if(y==0) SET_SN_LED_ON_A(x);else SET_SN_LED_ON_E(x);} while(0)
    #define SET_SN_LED_OFF_X(x,y)    do {if(y==0) SET_SN_LED_OFF_A(x);else SET_SN_LED_OFF_E(x);} while(0)

#else
    #define PROBE_TIME	    5
    #define PROBE_NULL		0
    #define PROBE_ACTIVE	1
    #define PROBE_RESET		2
    #define PROBE_RELOAD	3
#endif /*USE_ENGENIUS_GPIO_LED*/

#define RTL_R32(addr)		(*(volatile unsigned long *)(addr))
#define RTL_W32(addr, l)	((*(volatile unsigned long*)(addr)) = (l))
#define RTL_R8(addr)		(*(volatile unsigned char*)(addr))
#define RTL_W8(addr, l)		((*(volatile unsigned char*)(addr)) = (l))

//#define  GPIO_DEBUG
#ifdef GPIO_DEBUG
/* note: prints function name for you */
    #define DPRINTK(fmt, args...) printk("%s: " fmt, __FUNCTION__ , ## args)
#else
    #define DPRINTK(fmt, args...) //panic_printk("%s: " fmt, __FUNCTION__ , ## args)
#endif

/*-----------------------------------------------------------------------------
 *                     data declarations, extern, static, const
 *----------------------------------------------------------------------------*/

static struct timer_list probe_timer;
#if HAS_DUAL_BAND_WPS_LED_INDICATOR/*WLR5000 WPS behavior*/
int is_5g_triggered;
int is_24g_triggered;
#endif
#ifdef USE_ENGENIUS_GPIO_LED
static unsigned int     gpio_timer_interval=50;   /*500 ms*/
static unsigned int     wlan_led_blink=0;
static unsigned int     wlan_led_toggle=0;
#ifdef SENAO_GPIO_LED_PWR 
static unsigned int 	pwr_led_toggle=0;
static struct timer_list rtl_pwrled_timer;
#endif
#ifdef WLAN_WPS_USE_SAME_LED
extern int rtl_wps_using;
#endif

typedef struct _rtl_wps_t
{
    unsigned int    wps_btn_counter;
    unsigned int    wps_btn_state;
    pid_t           pid;
    SN_RTL819X_BTN  e_rtl819x_wps_state;
	SN_RTL819X_BUTTON_TYPE	e_rtl819x_button_type;
} rtl_wps_t;

static rtl_wps_t g_rtl_wps;

#ifdef WLAN_LED_CONTROL
static unsigned int     force_wlan_led_off = 0;
#endif

#else
static unsigned int     probe_counter;
static unsigned int     probe_state;
static unsigned int     gpio_timer_interval=100;
#endif /*USE_ENGENIUS_GPIO_LED*/


#ifdef SENAO_GPIO_SWITCH_BUTTON_3_LEVEL
static unsigned int sn_switch_btn = 0;
#endif
/*-----------------------------------------------------------------------------
 *                     functions declarations
 *----------------------------------------------------------------------------*/
static int sn_gpio_read_proc(char *page, char **start, off_t off, int count, int *eof, void *data);
static int sn_gpio_write_proc(struct file *file, const char *buffer, unsigned long count, void *data);
static void rtl_gpio_init_sn_board(void);
static void rtl_gpio_notify_user(rtl_wps_t *ptr_rtl_wps);
static int sn_gpio_led_control_write_proc(struct file *file, const char *buffer, unsigned long count, void *data);
/*-----------------------------------------------------------------------------
 *                     functions implmentation
 *----------------------------------------------------------------------------*/
#if 0/*def CONFIG_RTL_8196C_GW_MP*/
void all_led_on(void)
{
	//printk("Into MP GPIO");
	RTL_W32(0xB8000030, (RTL_R32(0xB8000030) | 0x00F00F80 ));
	RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~(1 << PS_LED_GREEN_PIN))));
	RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~(1 << PS_LED_ORANGE_PIN))));

	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (1 << PS_LED_GREEN_PIN)));
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (1 << PS_LED_ORANGE_PIN)));
	
	RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (1 << PS_LED_GREEN_PIN)));
	RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << PS_LED_ORANGE_PIN))));

	/* inet_led init setting */
	RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~(1 << INET_LED_GREEN_PIN))));
	RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~(1 << INET_LED_ORANGE_PIN))));

	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (1 << INET_LED_GREEN_PIN)));
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (1 << INET_LED_ORANGE_PIN)));
	
	RTL_W32(AUTOCFG_LED_DIRBASE, (RTL_R32(AUTOCFG_LED_DIRBASE) & (~(1 << AUTOCFG_LED_PIN_MP))));

	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (1 << AUTOCFG_LED_PIN_MP)));

	//RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << INET_LED_GREEN_PIN))));
	//RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (1 << INET_LED_ORANGE_PIN)));
	RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << PS_LED_GREEN_PIN))));	
	RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << PS_LED_ORANGE_PIN))));
	RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << INET_LED_GREEN_PIN))));
	RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << INET_LED_ORANGE_PIN))));
	RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << AUTOCFG_LED_PIN_MP))));
	RTL_W32(RESET_LED_DATABASE, (RTL_R32(RESET_LED_DATABASE) & (~(1 << RESET_LED_PIN_MP))));
}
#endif /*CONFIG_RTL_8196C_GW_MP*/
#ifdef USE_ENGENIUS_GPIO_LED
#ifdef SENAO_GPIO_LED_PWR
static void rtl_pwrled_blink(unsigned long data)
{
		/*jaykung blink pwr led in factory mode*/
		if (pwr_led_toggle)
		{
#if SENAO_GPIO_STATUS_PWR
			SET_SN_LED_ON_X(SENAO_GPIO_STATUS_LED, SENAO_GPIO_PART_STATUS_LED);
#else
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << SENAO_GPIO_LED_PWR))));
#endif
		}
		else
		{
#if SENAO_GPIO_STATUS_PWR
			SET_SN_LED_OFF_X(SENAO_GPIO_STATUS_LED, SENAO_GPIO_PART_STATUS_LED);
#else
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (1 << SENAO_GPIO_LED_PWR)));
#endif
		}
		
		pwr_led_toggle = pwr_led_toggle? 0 : 1;

		mod_timer(&rtl_pwrled_timer, jiffies + gpio_timer_interval);
}
#endif
static void rtl_gpio_timer(unsigned long data)
{
    unsigned int pressed=1;
    SN_RTL819X_BUTTON_TYPE button_type=SN_RTL819X_BUTTON_TYPE_INIT;
	unsigned int i;
#ifdef SENAO_GPIO_SWITCH_BUTTON_3_LEVEL
	unsigned int tmp_switch_btn = GET_SN_SWITCH_BTN;
#endif

#ifdef USE_ENGENIUS_GPIO_LED
    /*make wlan led blinking*/
	if (wlan_led_blink==1
#ifdef WLAN_WPS_USE_SAME_LED
		&& rtl_wps_using == 0
#endif
#ifdef WLAN_LED_CONTROL
		&& force_wlan_led_off != 1
#endif
		)
	{
		if (wlan_led_toggle)
		{
			SET_SN_WLAN_LED_OFF
		}
		else 
		{
			SET_SN_WLAN_LED_ON
		}
		wlan_led_toggle = wlan_led_toggle? 0 : 1;
	}
	if(g_rtl_wps.e_rtl819x_wps_state==SN_RTL819X_BTN_FACTORY_MODE)
	{
        DPRINTK("you are in factory mode, button will be disabled\n");
		return ;
	}

#ifdef SENAO_GPIO_SWITCH_BUTTON_3_LEVEL
    /* Check switch button */
	if(sn_switch_btn != tmp_switch_btn)
	{
		g_rtl_wps.e_rtl819x_button_type=SN_RTL819X_BUTTON_TYPE_RESET;
		sn_switch_btn = tmp_switch_btn;
	}
	else
#endif
    /*check button behaviour*/
#ifdef SENAO_GPIO_BUTTON_RESET
 	if(!GET_SN_RESET_BTN)
	{
        DPRINTK("reset btn pressed!\n");
		g_rtl_wps.e_rtl819x_button_type=SN_RTL819X_BUTTON_TYPE_RESET;
	}
	else
#endif
#ifdef SENAO_GPIO_BUTTON_WPS 
	if(!GET_SN_WPS_BTN)
	{
        DPRINTK("wps btn pressed!\n");
		g_rtl_wps.e_rtl819x_button_type=SN_RTL819X_BUTTON_TYPE_WPS;
	}
	else
#endif
	{
        pressed = 0;
	}

    if (g_rtl_wps.wps_btn_state==WPS_BTN_RELEASED)
    {
		if (pressed)    /*released -> press*/
		{
		    g_rtl_wps.wps_btn_state = WPS_BTN_PRESSED;
		    g_rtl_wps.wps_btn_counter++;
		}
		else            /*no operation*/
		{
		    g_rtl_wps.e_rtl819x_wps_state = SN_RTL819X_BTN_INIT;
			g_rtl_wps.wps_btn_counter = 0;
			g_rtl_wps.e_rtl819x_button_type=SN_RTL819X_BUTTON_TYPE_INIT;
		}
    }
    else /*BTN_PRESSED*/
    {
		if (pressed)    /*pressed*/
		{
		    g_rtl_wps.wps_btn_counter++;
#ifdef SENAO_GPIO_LED_PWR
			/*jaykung if we have PWR_LED_GPIO, we need to use this led to indicate status*/
			if (g_rtl_wps.wps_btn_counter >= RESET_TO_DEFAULT_TIME)
			{
			    if (g_rtl_wps.wps_btn_counter & 1)
				{
#if SENAO_GPIO_STATUS_PWR
						SET_SN_LED_OFF_X(SENAO_GPIO_STATUS_LED, SENAO_GPIO_PART_STATUS_LED);
#else
						RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | ((1 << SENAO_GPIO_LED_PWR))));
#endif
				}
				else
				{
#if SENAO_GPIO_STATUS_PWR
						SET_SN_LED_ON_X(SENAO_GPIO_STATUS_LED, SENAO_GPIO_PART_STATUS_LED);
#else
						RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(1 << SENAO_GPIO_LED_PWR))));
#endif
				}
			}
#endif
#if HAS_DUAL_BAND_WPS_LED_INDICATOR/*WLR5000 WPS behavior*/
		if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_WPS_TIME_0) && 
			(g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_WPS_TIME_1) )
		{
			DPRINTK("2.4G\n");
			is_5g_triggered=0;
			is_24g_triggered=1;
		}
		else if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_WPS_TIME_1) && 
			(g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_WPS_TIME_2) )
		{
			DPRINTK("5G\n");
			is_5g_triggered=1;
			is_24g_triggered=0;
		}
		else
		{
			is_5g_triggered=0;
			is_24g_triggered=0;
		}
#endif
		}
		else            /*pressed -> release*/
		{

#ifdef SENAO_GPIO_BUTTON_RESET
			if (g_rtl_wps.e_rtl819x_button_type==SN_RTL819X_BUTTON_TYPE_RESET) /*Reset button*/
			{
				if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_RESET_TIME_0) && 
				     (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_RESET_TIME_1) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_RESET_ACTION_1;
				}
				else if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_RESET_TIME_1) && 
				          (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_RESET_TIME_2) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_RESET_ACTION_2;
				}
				else if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_RESET_TIME_2) && 
				          (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_RESET_TIME_3) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_RESET_ACTION_3;
				}
				else if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_RESET_TIME_3) && 
				          (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_RESET_TIME_4) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_RESET_ACTION_4;
				}
				else if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_RESET_TIME_4) && 
				          (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_RESET_TIME_5) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_RESET_ACTION_5;	
				}
			}
#endif
#ifdef SENAO_GPIO_BUTTON_WPS
			if(g_rtl_wps.e_rtl819x_button_type==SN_RTL819X_BUTTON_TYPE_WPS) /*WPS button*/
			{
				if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_WPS_TIME_0) && 
				     (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_WPS_TIME_1) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_WPS_ACTION_1;
				}
				else if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_WPS_TIME_1) && 
				          (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_WPS_TIME_2) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_WPS_ACTION_2;
				}
				else if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_WPS_TIME_2) && 
				          (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_WPS_TIME_3) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_WPS_ACTION_3;
				}
				else if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_WPS_TIME_3) && 
				          (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_WPS_TIME_4) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_WPS_ACTION_4;
				}
				else if ( (g_rtl_wps.wps_btn_counter>BUTTON_PROBE_WPS_TIME_4) && 
				          (g_rtl_wps.wps_btn_counter<=BUTTON_PROBE_WPS_TIME_5) )
				{
					g_rtl_wps.e_rtl819x_wps_state = BUTTON_PROBE_WPS_ACTION_5;	
				}
#if HAS_DUAL_BAND_WPS_LED_INDICATOR/*WLR5000 WPS behavior*/
			if ( g_rtl_wps.e_rtl819x_wps_state==SN_RTL819X_BTN_TRIGGER_5G ||g_rtl_wps.e_rtl819x_wps_state==SN_RTL819X_BTN_TRIGGER_24G)
			{
				DPRINTK("reset trigger\n");
				is_5g_triggered=0;
				is_24g_triggered=0;
			}
#endif
			}
#endif

#ifdef SENAO_GPIO_LED_PWR
			/*do pwr_led blinking while doing reset to default*/
			if(g_rtl_wps.e_rtl819x_wps_state==SN_RTL819X_BTN_RESET_2_DEF)
			{
				del_timer_sync(&rtl_pwrled_timer);
				init_timer(&rtl_pwrled_timer);
				rtl_pwrled_timer.expires = jiffies + gpio_timer_interval;
				rtl_pwrled_timer.data = (unsigned long)NULL;
				rtl_pwrled_timer.function = &rtl_pwrled_blink;
				mod_timer(&rtl_pwrled_timer, jiffies + gpio_timer_interval);
			}
#endif
            /*notify this event*/
            if (g_rtl_wps.e_rtl819x_wps_state!=SN_RTL819X_BTN_INIT)
            {
                DPRINTK("rtl_wps, wps_btn_counter=%d, wps_btn_state=%d, pid=%d, e_rtl819x_wps_state=%d, e_rtl819x_button_type=%d\n", 
                         g_rtl_wps.wps_btn_counter, g_rtl_wps.wps_btn_state, g_rtl_wps.pid, g_rtl_wps.e_rtl819x_wps_state,g_rtl_wps.e_rtl819x_button_type);
                rtl_gpio_notify_user(&g_rtl_wps);
            }

		    /*reset counter*/
			g_rtl_wps.wps_btn_counter = 0;
			g_rtl_wps.wps_btn_state = WPS_BTN_RELEASED;
		}
    }

#else /*this part is original RTL codes*/

#if  defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)
	if (RTL_R32(RESET_PIN_DATABASE) & (1 << RESET_BTN_PIN))
#endif
	{
		pressed = 0;

		//turn off LED0
	#ifndef CONFIG_RTL_8196C_GW_MP
	  #ifdef RTL819x_DISABLE_RESET_LED
	    /*do nothing*/
	  #else
		RTL_W32(RESET_LED_DATABASE, (RTL_R32(RESET_LED_DATABASE) | ((1 << RESET_LED_PIN))));
	  #endif
	#endif  /*CONFIG_RTL_8196C_GW_MP*/
	}
	else
	{
		DPRINTK("Key pressed %d!\n", probe_counter+1);
	}

	if (probe_state == PROBE_NULL)
	{
		if (pressed)
		{
			probe_state = PROBE_ACTIVE;
			probe_counter++;
		}
		else
			probe_counter = 0;
	}
	else if (probe_state == PROBE_ACTIVE)
	{
		if (pressed)
		{
			probe_counter++;

			if ((probe_counter >=2 ) && (probe_counter <=PROBE_TIME))
			{
				DPRINTK("2-5 turn on led\n");
				//turn on LED0
			#ifdef RTL819x_DISABLE_RESET_LED
			    /*do nothing*/
			#else
				RTL_W32(RESET_LED_DATABASE, (RTL_R32(RESET_LED_DATABASE) & (~(1 << RESET_LED_PIN))));
			#endif
			}
			else if (probe_counter >= PROBE_TIME)
			{
				// sparkling LED0
				DPRINTK(">5 \n");
			#ifdef RTL819x_DISABLE_RESET_LED
			    /*do nothing*/
			#else
			    if (probe_counter & 1)
					RTL_W32(RESET_LED_DATABASE, (RTL_R32(RESET_LED_DATABASE) | ((1 << RESET_LED_PIN))));
				else
					RTL_W32(RESET_LED_DATABASE, (RTL_R32(RESET_LED_DATABASE) & (~(1 << RESET_LED_PIN))));
		    #endif
			}
		}
		else
		{
			if (probe_counter < 2)
			{
				probe_state = PROBE_NULL;
				probe_counter = 0;
				DPRINTK("<2 \n");				
			}
			else if (probe_counter >= PROBE_TIME)
			{
				//reload default
				//kernel_thread(reset_flash_default, (void *)1, SIGCHLD);
				return;
			}
			else
			{
				DPRINTK("2-5 reset\n");
			#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,27)
				kill_proc(1,SIGTERM,1);
			#else
				kill_pid(1,SIGTERM,1);
			#endif
				//kernel_thread(reset_flash_default, 0, SIGCHLD);
				return;
			}
		}
	}

#endif /*USE_ENGENIUS_GPIO_LED*/

	mod_timer(&probe_timer, jiffies + gpio_timer_interval);
}

#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
#define SYSTEM_CONTRL_DUMMY_REG 0xb8000068

int is_bank2_root()
{
	//boot code will steal System's dummy register bit0 (set to 1 ---> bank2 booting
	//for 8198 formal chip 
	if ((RTL_R32(SYSTEM_CONTRL_DUMMY_REG)) & (0x00000001))  // steal for boot bank idenfy
		return 1;

	return 0;
}
static int read_bootbank_proc(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	int len;
	char flag='1';

	if (is_bank2_root())  // steal for boot bank idenfy
		flag='2';
		
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}
#endif

#ifdef READ_RF_SWITCH_GPIO
static int rf_switch_read_proc(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	int len;
	char flag;

	if (RTL_R32(WIFI_ONOFF_PIN_DATABASE) & (1<<WIFI_ONOFF_PIN_NO)){
		flag = '1';
	}else{
		flag = '0';
	}
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}
#endif


static int
gpio_proc_info_read (char *buf, char **start, off_t offset,
		     int len, int *eof, void *data)
{
	int buflen = 0;

	*eof = 1;

    buflen = sprintf(buf, "GPIO_MUX   %#08X \nGPIO_CNR   %#08X \nGPIO_DATA  %#08X \nGPIO_DIR   %#08X \n",
				  RTL_R32(RTL_GPIO_MUX), RTL_R32(RTL_GPIO_IOBASE), RTL_R32(RTL_GPIO_DATABASE),RTL_R32(RTL_GPIO_DIRBASE));
#if 0 // more information
    buflen = sprintf(buf, "GPIO_MUX   %#08X \n", RTL_R32(RTL_GPIO_MUX));
    buflen += sprintf(buf+buflen, "=== GPIO Port ABCD ===\n");
    buflen += sprintf(buf+buflen, "GPIO_CNR   %#08X \nGPIO_DATA  %#08X \nGPIO_DIR   %#08X \n", 
					  RTL_R32(PABCD_CNR), RTL_R32(PABCD_DAT),RTL_R32(PABCD_DIR));
    buflen += sprintf(buf+buflen, "=== GPIO Port EFGH ===\n");
    buflen += sprintf(buf+buflen, "GPIO_CNR   %#08X \nGPIO_DATA  %#08X \nGPIO_DIR   %#08X \n", 
					  RTL_R32(PEFGH_CNR), RTL_R32(PEFGH_DAT),RTL_R32(PEFGH_DIR));
#endif

#ifdef GPIO_INFO_SHOW_BUTTON_STATUS

#ifdef SENAO_GPIO_SWITCH_BUTTON_3_LEVEL
    buflen += sprintf(buf+buflen, "'Converter' 'AP' 'Auto' ");
#endif
#ifdef SENAO_GPIO_BUTTON_RESET
    buflen += sprintf(buf+buflen, "'Reset' ");
#endif
#ifdef SENAO_GPIO_BUTTON_WPS	
    buflen += sprintf(buf+buflen, "'WPS' ");
#endif
    buflen += sprintf(buf+buflen, "\nButton Status = ");
#ifdef SENAO_GPIO_SWITCH_BUTTON_3_LEVEL
    /* 'Converter' 'AP' 'Auto' */
#if (SENAO_GPIO_PART_SWITCH_BUTTON_3_LEVEL == 0)
	buflen += sprintf(buf+buflen, "%d", GET_SN_DATA_A(SENAO_GPIO_SWITCH_BUTTON_LEVEL_L) ? 0: 1);
	buflen += sprintf(buf+buflen, "%d", GET_SN_DATA_A(SENAO_GPIO_SWITCH_BUTTON_LEVEL_M) ? 0: 1);
	buflen += sprintf(buf+buflen, "%d", GET_SN_DATA_A(SENAO_GPIO_SWITCH_BUTTON_LEVEL_R) ? 0: 1);
#else
	buflen += sprintf(buf+buflen, "%d", GET_SN_DATA_E(SENAO_GPIO_SWITCH_BUTTON_LEVEL_L) ? 0: 1);
	buflen += sprintf(buf+buflen, "%d", GET_SN_DATA_E(SENAO_GPIO_SWITCH_BUTTON_LEVEL_M) ? 0: 1);
	buflen += sprintf(buf+buflen, "%d", GET_SN_DATA_E(SENAO_GPIO_SWITCH_BUTTON_LEVEL_R) ? 0: 1);
#endif
#endif
#ifdef SENAO_GPIO_BUTTON_RESET
	/* 'Reset' */
    buflen += sprintf(buf+buflen, "%d", GET_SN_DATA(SENAO_GPIO_BUTTON_RESET) ? 0: 1);
#endif
#ifdef SENAO_GPIO_BUTTON_WPS	
	/* 'WPS' */
    buflen += sprintf(buf+buflen, "%d", GET_SN_DATA(SENAO_GPIO_BUTTON_WPS) ? 0: 1);
#endif
    buflen += sprintf(buf+buflen, "\n");
#endif

	return buflen;
}
static int sn_gpio_read_proc(char *page, char **start, off_t off, int count, int *eof, void *data)
{
	int len;

	len = sprintf(page, "%d\n", g_rtl_wps.e_rtl819x_wps_state);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}

#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif 
static int sn_gpio_write_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
    int num, state, pid;
	char flag[20];

	if (count < 2)
		return -EFAULT;

	if (buffer && !copy_from_user(&flag, buffer, 20)) 
	{
	    num = sscanf(flag, "%d %d", &state, &pid);
		
		if (num != 2) 
		{
			printk("invalid gpio parameter!\n");
		}

        if (state==SN_RTL819X_BTN_INIT)
        {
	        g_rtl_wps.e_rtl819x_wps_state=SN_RTL819X_BTN_INIT;
	        g_rtl_wps.pid = pid;
		}
		else if(state ==SN_RTL819X_BTN_FACTORY_MODE) /*in factory mode, button should be disabled*/
		{
	        g_rtl_wps.e_rtl819x_wps_state=SN_RTL819X_BTN_FACTORY_MODE;
#ifdef SENAO_GPIO_LED_PWR
			del_timer_sync(&rtl_pwrled_timer);
			init_timer(&rtl_pwrled_timer);
			rtl_pwrled_timer.expires = jiffies + gpio_timer_interval;
			rtl_pwrled_timer.data = (unsigned long)NULL;
			rtl_pwrled_timer.function = &rtl_pwrled_blink;
			mod_timer(&rtl_pwrled_timer, jiffies + gpio_timer_interval);
#endif
		}
		return count;
	}
	else
	{
		return -EFAULT;
	}
}

static int sn_gpio_led_control_write_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
    int num, gpio_num, state;
	int gpioGrp;
	int hasGpioGrp = 0;
	char flag[20];

	if (count < 2)
		return -EFAULT;

	if (buffer && !copy_from_user(&flag, buffer, 20)) 
	{
	    //num = sscanf(flag, "%d %d", &gpio_num, &state);
	    num = sscanf(flag, "%d %d %d", &gpio_num, &state, &gpioGrp);

		if(num == 3)
		{
			/* gpioGrp */
			hasGpioGrp = 1;
            /* Original check */
			num = 2;
		}

		if(num != 2)
		{
			printk("invalid gpio parameter!\n");
		}
		else
		{
#ifdef WLAN_LED_CONTROL
			if(gpio_num == SENAO_GPIO_LED_WLAN)
			{
				if (state==0)
				{
					force_wlan_led_off = 1;
				}
				else
				{
					force_wlan_led_off = 0;
				}
			}
#endif

#ifdef SENAO_GPIO_MUX_GPIO
			/*GPIOB2~7, GPIOC0*/
			/**/
			if(gpio_num >= 10 || gpio_num <= 16)
			{
				//printk("\r\n 0x%x__[%s-%u]\n",RTL_R32(RTL_GPIO_MUX),__FILE__,__LINE__);	
#if  defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)
				RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | (SENAO_GPIO_MUX_SEL_DATA)));
#if defined(CONFIG_RTL_8198)
				/*TODO check gpio defination in 8198 platform*/
				RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | 0xf));
#endif
#endif
				//printk("\r\n 0x%x__[%s-%u]\n",RTL_R32(RTL_GPIO_MUX),__FILE__,__LINE__);	
			}
#endif
			if (state==0)
			{
				if(hasGpioGrp)
				{
					SET_SN_LED_OFF_X(gpio_num, gpioGrp);
				}
				else
				{
					SET_SN_LED_OFF(gpio_num);
				}
			}
			else
			{
				if(hasGpioGrp)
				{
					SET_SN_LED_ON_X(gpio_num, gpioGrp);
				}
				else
				{
					SET_SN_LED_ON(gpio_num);
				}
			}
		}
		return count;
	}
	else
	{
		return -EFAULT;
	}
}
/*init gpio*/
static void rtl_gpio_init_sn_board(void)
{
	// 1. MUX : init GPIO shared pin
#ifdef SENAO_GPIO_MUX_GPIO
#if  defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)
	RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | (RTL_GPIO_MUX_DATA | SENAO_GPIO_MUX_SEL_DATA)));
#if defined(CONFIG_RTL_8198)
	/*TODO check gpio defination in 8198 platform*/
	RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | 0xf));
#endif
#endif
#else
#if  defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)
	RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | (RTL_GPIO_MUX_DATA)));
#if defined(CONFIG_RTL_8198)
	/*TODO check gpio defination in 8198 platform*/
	RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | 0xf));
#endif
#endif
#endif

	//2. setup button gpio
#ifdef SENAO_GPIO_BUTTON_RESET
		/*0: gpio pin, 1 dedicated peripheral pin*/
	SET_SN_CNR_GPIO(SENAO_GPIO_BUTTON_RESET);
	/*config as input*/
	SET_SN_DIR_IN(SENAO_GPIO_BUTTON_RESET);
#endif

#ifdef SENAO_GPIO_BUTTON_WPS
	/*0: gpio pin, 1 dedicated peripheral pin*/
	SET_SN_CNR_GPIO(SENAO_GPIO_BUTTON_WPS);
	/*config as input*/
	SET_SN_DIR_IN(SENAO_GPIO_BUTTON_WPS);
#endif

#ifdef SENAO_GPIO_LED_WLAN
	//3. setup WLAN LED
	/*0: gpio pin, 1 dedicated peripheral pin*/
	SET_SN_CNR_GPIO(SENAO_GPIO_LED_WLAN);
	// Set SENAO_GPIO_LED_WLAN as output pin for wlan led
	SET_SN_DIR_OUT(SENAO_GPIO_LED_WLAN);
    /*turn off WLAN LED*/
    SET_SN_WLAN_LED_OFF
#endif

#ifdef SENAO_GPIO_LED_WPS
    /*Setting WPS LED*/
	/*0: gpio pin, 1 dedicated peripheral pin*/
	SET_SN_CNR_GPIO(SENAO_GPIO_LED_WPS);
	// Set SENAO_GPIO_LED_WPS as output pin for wps led
	SET_SN_DIR_OUT(SENAO_GPIO_LED_WPS);
	// turn off auto config led in the beginning
	SET_SN_WPS_LED_OFF
#endif

#ifdef SENAO_GPIO_LED_PWR
	// Set SENAO_GPIO_LED_PWR as output pin for power led
	SET_SN_DIR_OUT_A(SENAO_GPIO_LED_PWR);
	/*jaykung if we have PWR_LED_GPIO, we need to use this led to indicate status*/
	SET_SN_LED_ON_A(SENAO_GPIO_LED_PWR);
#endif

#ifdef SENAO_GPIO_LED_WLAN_SS_G
	// Set SENAO_GPIO_LED_WLAN_SS_G as output pin for wlan signal strength led
	SET_SN_DIR_OUT_A(SENAO_GPIO_LED_WLAN_SS_G);
	SET_SN_LED_ON_A(SENAO_GPIO_LED_WLAN_SS_G);
	SET_SN_LED_OFF(SENAO_GPIO_LED_WLAN_SS_G);
#endif

#ifdef SENAO_GPIO_LED_WLAN_SS_O
	// Set SENAO_GPIO_LED_WLAN_SS_G as output pin for wlan signal strength led
	SET_SN_CNR_GPIO(SENAO_GPIO_LED_WLAN_SS_O);
	SET_SN_DIR_OUT(SENAO_GPIO_LED_WLAN_SS_O);
	SET_SN_LED_OFF(SENAO_GPIO_LED_WLAN_SS_O);
#endif

#ifdef SENAO_GPIO_LED_WLAN_SS_R
	// Set SENAO_GPIO_LED_WLAN_SS_G as output pin for wlan signal strength led
	SET_SN_CNR_GPIO(SENAO_GPIO_LED_WLAN_SS_R);
	SET_SN_DIR_OUT(SENAO_GPIO_LED_WLAN_SS_R);
	SET_SN_LED_OFF(SENAO_GPIO_LED_WLAN_SS_R);
#endif

#ifdef SENAO_GPIO_LAN_LED_OFF
    /*Setting LAN LED OFF*/
	/*0: gpio pin, 1 dedicated peripheral pin*/
	SET_SN_CNR_GPIO(SENAO_GPIO_LAN_LED_OFF);
	// Set SENAO_GPIO_LAN_LED_OFF as output pin
	SET_SN_DIR_OUT(SENAO_GPIO_LAN_LED_OFF);
	// turn off auto config led in the beginning
	SET_SN_LED_ON(SENAO_GPIO_LAN_LED_OFF);
#endif

#ifdef SENAO_GPIO_MANUAL_RESET
    /*Setting SENAO_GPIO_MANUAL_RESET*/
	/*0: gpio pin, 1 dedicated peripheral pin*/
	SET_SN_CNR_GPIO(SENAO_GPIO_MANUAL_RESET);
	// Set SENAO_GPIO_MANUAL_RESET as output pin
	SET_SN_DIR_OUT(SENAO_GPIO_MANUAL_RESET);
	// pull high in the beginning
	SET_SN_LED_ON(SENAO_GPIO_MANUAL_RESET);
#endif

#ifdef SENAO_GPIO_RESET_SYS
	SET_SN_CNR_GPIO(SENAO_GPIO_RESET_SYS);
	// Set SENAO_GPIO_MANUAL_RESET as output pin
	SET_SN_DIR_IN(SENAO_GPIO_RESET_SYS);
#endif

#ifdef SENAO_GPIO_STATUS_LED
	/*0: gpio pin, 1 dedicated peripheral pin*/
	SET_SN_CNR_GPIO_X(SENAO_GPIO_STATUS_LED, SENAO_GPIO_PART_STATUS_LED);
	// Set SENAO_GPIO_LED_WPS as output pin for status led
	SET_SN_DIR_OUT_X(SENAO_GPIO_STATUS_LED, SENAO_GPIO_PART_STATUS_LED);
	// turn on 
	SET_SN_LED_ON_X(SENAO_GPIO_STATUS_LED, SENAO_GPIO_PART_STATUS_LED);
#endif

#ifdef SENAO_GPIO_SWITCH_BUTTON_3_LEVEL
    /* 0: ABCD, 1:EFGH */
	SET_SN_CNR_GPIO_X(SENAO_GPIO_SWITCH_BUTTON_LEVEL_L, SENAO_GPIO_PART_SWITCH_BUTTON_3_LEVEL);
	SET_SN_DIR_IN_X(SENAO_GPIO_SWITCH_BUTTON_LEVEL_L,   SENAO_GPIO_PART_SWITCH_BUTTON_3_LEVEL);
	SET_SN_CNR_GPIO_X(SENAO_GPIO_SWITCH_BUTTON_LEVEL_M, SENAO_GPIO_PART_SWITCH_BUTTON_3_LEVEL);
	SET_SN_DIR_IN_X(SENAO_GPIO_SWITCH_BUTTON_LEVEL_M,   SENAO_GPIO_PART_SWITCH_BUTTON_3_LEVEL);
	SET_SN_CNR_GPIO_X(SENAO_GPIO_SWITCH_BUTTON_LEVEL_R, SENAO_GPIO_PART_SWITCH_BUTTON_3_LEVEL);
	SET_SN_DIR_IN_X(SENAO_GPIO_SWITCH_BUTTON_LEVEL_R,   SENAO_GPIO_PART_SWITCH_BUTTON_3_LEVEL);

	/* Get init value */
	sn_switch_btn = GET_SN_SWITCH_BTN;
#endif
}

/*notify wps event to user space*/
static void rtl_gpio_notify_user(rtl_wps_t *ptr_rtl_wps)
{
    struct task_struct *task_ptr = NULL;
    struct pid *pid;

    //don't send any signal if pid is 0 or 1
	if ((int)(ptr_rtl_wps->pid) < 2)
	{
		return;
	}

DPRINTK("=====================, pid=%d\n", ptr_rtl_wps->pid);

    pid = find_get_pid(ptr_rtl_wps->pid);

DPRINTK("---------------------, pid=%x\n", pid);
    /*here is a trick that we use init_pid_ns*/
	task_ptr = get_pid_task(pid, PIDTYPE_PID);

	if (NULL == task_ptr) 
	{
		printk(": no registered process to notify\n");
		return;
	}

DPRINTK("=====================, task=%x\n", task_ptr);
    send_sig(SIGUSR1, task_ptr, 0);
}

/*set wlan led on/off/blink*/
void rtl_gpio_set_sn_board(SN_RTL819X_LED e_sn_rtl819x_led)
{

#ifdef WLAN_LED_CONTROL
	if(force_wlan_led_off == 1)
		return;
#endif
#ifdef WLAN_WPS_USE_SAME_LED
	if(rtl_wps_using == 1)
		return;
#endif

    switch (e_sn_rtl819x_led)
    {
        case SN_RTL819X_LED_ON:
            if (GET_SN_WLAN_LED==SN_RTL819X_LED_ON)
            {
                /*do nothing*/
            }
            else
            {
                wlan_led_blink = 0;
                SET_SN_WLAN_LED_ON
            }
    		break;
        case SN_RTL819X_LED_OFF:
            if (GET_SN_WLAN_LED==SN_RTL819X_LED_OFF)
            {
                /*do nothing*/
            }
            else
            {
                wlan_led_blink = 0;
                SET_SN_WLAN_LED_OFF
            }
            break;
        case SN_RTL819X_LED_BLINK:
            /*turn on blink feature*/
            wlan_led_blink = 1;
            break;
        default:
            printk("%s error\r\n", __FUNCTION__);
            break;
    }

    return;
}
#endif /*USE_ENGENIUS_GPIO_LED*/

int __init rtl_gpio_init(void)
{
	struct proc_dir_entry *res=NULL;

	printk("Realtek GPIO Driver for Flash Reload Default\n");

	// Set GPIOA pin 10(8181)/0(8186) as input pin for reset button

    /*init the board gpio setting*/
    rtl_gpio_init_sn_board();
#if 0 /*Realtek setting, we don't need to do it*/
#if  defined(CONFIG_RTL_8196C) || defined(CONFIG_RTL_8198)
	RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | (RTL_GPIO_MUX_DATA)));
#if defined(CONFIG_RTL_8198)
	RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | 0xf));
#endif

	RTL_W32(RESET_PIN_IOBASE, (RTL_R32(RESET_PIN_IOBASE) & (~(1 << RESET_BTN_PIN))));
	RTL_W32(RESET_PIN_DIRBASE, (RTL_R32(RESET_PIN_DIRBASE) & (~(1 << RESET_BTN_PIN))));
#if defined(READ_RF_SWITCH_GPIO)
	RTL_W32(WIFI_ONOFF_PIN_IOBASE, (RTL_R32(WIFI_ONOFF_PIN_DIRBASE) & ( ~(1<<RTL_GPIO_WIFI_ONOFF))));
	RTL_W32(WIFI_ONOFF_PIN_DIRBASE, (RTL_R32(WIFI_ONOFF_PIN_DIRBASE) & (~(1<<RTL_GPIO_WIFI_ONOFF))));
	RTL_W32(WIFI_ONOFF_PIN_DATABASE, (RTL_R32(WIFI_ONOFF_PIN_DATABASE) & (~(1<<RTL_GPIO_WIFI_ONOFF))));

#endif // #if defined(READ_RF_SWITCH_GPIO)
#endif // #if defined(CONFIG_RTL865X)

	// Set GPIOA ping 2 as output pin for reset led
	RTL_W32(RESET_LED_DIRBASE, (RTL_R32(RESET_LED_DIRBASE) | ((1 << RESET_LED_PIN))));
#endif
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE	
	res = create_proc_entry("bootbank", 0, NULL);
	if (res) {
		res->read_proc = read_bootbank_proc;
		//res->write_proc = write_bootbank_proc;
	}
	else {
		printk("read bootbank, create proc failed!\n");
	}
#endif /*CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE*/

#ifdef READ_RF_SWITCH_GPIO
	res = create_proc_entry("rf_switch", 0, NULL);
	if (res) {
		res->read_proc = rf_switch_read_proc;
		res->write_proc = NULL;
	}
#endif

	init_timer(&probe_timer);
	probe_timer.expires = jiffies + gpio_timer_interval;
	probe_timer.data = (unsigned long)NULL;
	probe_timer.function = &rtl_gpio_timer;
	mod_timer(&probe_timer, jiffies + gpio_timer_interval);

#ifdef USE_ENGENIUS_GPIO_LED
    memset(&g_rtl_wps, 0, sizeof(g_rtl_wps));

	res = create_proc_entry("gpio", 0, NULL);
	if (res)
	{
		res->read_proc = sn_gpio_read_proc;
		res->write_proc = sn_gpio_write_proc;
	}
	else
	{
		printk("Realtek GPIO Driver, create proc failed!\n");
	}

	/*read gpio info*/
	res = create_proc_entry ("gpio_info", 0, NULL);
	if (res)
	{
		res->read_proc = gpio_proc_info_read;
		res->write_proc = NULL;
	}
	else
	{
		printk("Realtek GPIO Info Driver, create proc failed!\n");
	}

	res = create_proc_entry("gpio_control", 0, NULL);
	if (res)
	{
		res->read_proc = NULL;
		res->write_proc = sn_gpio_led_control_write_proc;
	}
	else
	{
		printk("Realtek GPIO Driver, create proc failed!\n");
	}

	/*init wps_led*/
 	wps_led_init();


#else
	probe_counter = 0;
	probe_state = PROBE_NULL;
#endif /*USE_ENGENIUS_GPIO_LED*/

	return 0;
}

static void __exit rtl_gpio_exit(void)
{
	printk("Unload Realtek GPIO Driver \n");
	del_timer_sync(&probe_timer);
#ifdef SENAO_GPIO_LED_PWR
	del_timer_sync(&rtl_pwrled_timer);
#endif
}

module_exit(rtl_gpio_exit);
module_init(rtl_gpio_init);

EXPORT_SYMBOL(rtl_gpio_set_sn_board);

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("GPIO driver for Reload default");
