/*
 * Export MIPS-specific functions needed for loadable modules.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1996, 97, 98, 99, 2000, 01, 03, 04, 05 by Ralf Baechle
 * Copyright (C) 1999, 2000, 01 Silicon Graphics, Inc.
 */
#include <linux/interrupt.h>
#include <linux/module.h>
#include <asm/checksum.h>
#include <asm/pgtable.h>
#include <asm/uaccess.h>
#include <linux/skbuff.h>

#include "gconfig.h"

extern void *__bzero(void *__s, size_t __count);
extern long __strncpy_from_user_nocheck_asm(char *__to,
                                            const char *__from, long __len);
extern long __strncpy_from_user_asm(char *__to, const char *__from,
                                    long __len);
extern long __strlen_user_nocheck_asm(const char *s);
extern long __strlen_user_asm(const char *s);
extern long __strnlen_user_nocheck_asm(const char *s);
extern long __strnlen_user_asm(const char *s);

/*
 * String functions
 */
EXPORT_SYMBOL(memset);
EXPORT_SYMBOL(memcpy);
EXPORT_SYMBOL(memmove);

EXPORT_SYMBOL(kernel_thread);

/*
 * Userspace access stuff.
 */
EXPORT_SYMBOL(__copy_user);
EXPORT_SYMBOL(__copy_user_inatomic);
EXPORT_SYMBOL(__bzero);
EXPORT_SYMBOL(__strncpy_from_user_nocheck_asm);
EXPORT_SYMBOL(__strncpy_from_user_asm);
EXPORT_SYMBOL(__strlen_user_nocheck_asm);
EXPORT_SYMBOL(__strlen_user_asm);
EXPORT_SYMBOL(__strnlen_user_nocheck_asm);
EXPORT_SYMBOL(__strnlen_user_asm);

EXPORT_SYMBOL(csum_partial);
EXPORT_SYMBOL(csum_partial_copy_nocheck);
EXPORT_SYMBOL(__csum_partial_copy_user);

EXPORT_SYMBOL(invalid_pte_table);

#ifdef CONFIG_PACKET_HANDLER

extern int (*netpkthandler_handle_driver)(struct sk_buff *skb);
EXPORT_SYMBOL(netpkthandler_handle_driver);

extern int (*netpkthandler_handle_tx_driver)(struct sk_buff *skb);
EXPORT_SYMBOL(netpkthandler_handle_tx_driver);

#if 0 /* cfho 2011-0308, need to add to the NIC driver */
extern int wanVlanId;
EXPORT_SYMBOL(wanVlanId);
extern char wanMacAddress[20];;
EXPORT_SYMBOL(wanMacAddress);
#endif

extern unsigned char wanMacAddress[20];
EXPORT_SYMBOL(wanMacAddress);

#ifdef CONFIG_PACKET_HANDLER_PASSTHROUGH
extern int (*addInterface_Ptr)(struct ifreq *ifr);
EXPORT_SYMBOL(addInterface_Ptr);
#endif /* CONFIG_PACKET_HANDLER_PASSTHROUGH */

#endif /* CONFIG_PACKET_HANDLER */

#ifdef CONFIG_SENAO_IP_CONNTRACK
extern int (*dropWhenNatTableFull_Ptr)(struct sk_buff *skb, int natSession, int natSessionMax );
extern int (*newConntrackDropSelect_Ptr)(u_int8_t protonum, u_int16_t tcp_port, u_int16_t udp_port);
EXPORT_SYMBOL(dropWhenNatTableFull_Ptr);
EXPORT_SYMBOL(newConntrackDropSelect_Ptr);
#endif


#ifndef CONFIG_RTL8192CD /** cfho 2010-0608*/
extern int (*__is_rtl8190_priv_buf)(unsigned char *head);
EXPORT_SYMBOL(__is_rtl8190_priv_buf);
extern void (*__free_rtl8190_priv_buf)(unsigned char *head);
EXPORT_SYMBOL(__free_rtl8190_priv_buf);
#endif

#ifndef CONFIG_RTL8192CD /** cfho 2010-0608, export for the WLAN driver ko file*/
//#include </ISD2/MIPS32/linux-2.6.30/drivers/net/wireless/rtl8192cd/8192cd.h>
#include "../drivers/net/wireless/rtl8192cd/8192cd.h"
#ifdef CONFIG_RTK_VLAN_SUPPORT
//extern int  rx_vlan_process(struct net_device *dev, struct vlan_info *info, struct sk_buff *skb);
EXPORT_SYMBOL (rx_vlan_process);
//extern int  tx_vlan_process(struct net_device *dev, struct VlanConfig *info, struct sk_buff *skb,
//int wlan_pri);
EXPORT_SYMBOL (tx_vlan_process);


#if defined(CONFIG_RTL_ETH_PRIV_SKB)
extern int eth_skb_free_num;
EXPORT_SYMBOL (eth_skb_free_num);
#endif

//#include <linux/netdevice.h>
//extern struct net_device *cached_dev;
#if defined(CONFIG_RTK_VLAN_SUPPORT)
extern int rtk_vlan_support_enable;
EXPORT_SYMBOL (rtk_vlan_support_enable);
#endif



#ifdef BR_SHORTCUT
#include <linux/netdevice.h>
#include <net/rtl/rtl_types.h>

#define ETHER_ADDR_LEN 6
__DRAM_FWD unsigned char cached_eth_addr[ETHER_ADDR_LEN];
__DRAM_FWD struct net_device *cached_dev;
EXPORT_SYMBOL (cached_eth_addr);
EXPORT_SYMBOL (cached_dev);
#endif /* BR_SHORTCUT */

#if defined(CONFIG_RTL_ETH_PRIV_SKB) || defined(CONFIG_NET_WIRELESS_AGN) || defined(CONFIG_NET_WIRELESS_AG)
extern struct sk_buff *priv_skb_copy(struct sk_buff *skb);
EXPORT_SYMBOL (priv_skb_copy);
#endif
//#include <linux/pid.h>
EXPORT_SYMBOL (find_vpid);

#if defined(CONFIG_RTL8190_PRIV_SKB) || defined(CONFIG_RTL_ETH_PRIV_SKB)
extern struct sk_buff *dev_alloc_8190_skb(unsigned char *data, int size);
EXPORT_SYMBOL (dev_alloc_8190_skb);
#endif

#endif /** cfho */ 

#endif
