/* vi: set sw=4 ts=4: */
/* dhcpd.h */
#ifndef _DHCPD_H
#define _DHCPD_H

/************************************/
/* Defaults _you_ may want to tweak */
/************************************/

/* the period of time the client is allowed to use that address */
#define LEASE_TIME              (60*60*24*10) /* 10 days of seconds */
#define LEASES_FILE		"/var/lib/misc/udhcpd.leases"

#define MAX_CLIENTS		65535

/* where to find the DHCP server configuration file */
#define DHCPD_CONF_FILE         "/etc/udhcpd.conf"

struct option_set {
	uint8_t *data;
	struct option_set *next;
};

struct static_lease {
	struct static_lease *next;
	uint8_t *mac;
	uint32_t *ip;
};

struct server_config_t {
	uint32_t server;                /* Our IP, in network order */
	/* start,end are in host order: we need to compare start <= ip <= end */
	uint32_t start_ip;              /* Start address of leases, in host order */
	uint32_t end_ip;                /* End of leases, in host order */
	struct option_set *options;     /* List of DHCP options loaded from the config file */
	char *interface;                /* The name of the interface to use */
	int ifindex;                    /* Index number of the interface to use */
	uint8_t arp[6];                 /* Our arp address */
	char remaining;                 /* should the lease file be interpreted as lease time remaining, or
	                                 * as the time the lease expires */
	uint32_t lease;	                /* lease time in seconds (host order) */
	uint32_t max_leases;            /* maximum number of leases (including reserved address) */
	uint32_t auto_time;             /* how long should udhcpd wait before writing a config file.
	                                 * if this is zero, it will only write one on SIGUSR1 */
	uint32_t decline_time;          /* how long an address is reserved if a client returns a
	                                 * decline message */
	uint32_t conflict_time;         /* how long an arp conflict offender is leased for */
	uint32_t offer_time;            /* how long an offered address is reserved */
	uint32_t min_lease;             /* minimum lease a client can request */
	char *lease_file;
	char *pidfile;
	char *notify_file;              /* What to run whenever leases are written */
	uint32_t siaddr;                /* next server bootp option */
	char *sname;                    /* bootp server name */
	char *boot_file;                /* bootp boot file option */
	struct static_lease *static_leases; /* List of ip/mac pairs to assign static leases */
#if HAS_USER_MANUAL_BOOTPFLAG	
	uint32_t bootp_type;			/* bootp flag type: unicast or broadcast */
#endif	
};

extern struct server_config_t server_config;
extern struct dhcpOfferedAddr *leases;


/*** leases.h ***/
#define HOSTNAME_LEN 40
#define DEVNAME_LEN  20
struct dhcpOfferedAddr {
	uint8_t chaddr[16];
	uint32_t yiaddr;	/* network order */
	uint32_t expires;	/* host order */
	uint8_t hostname[HOSTNAME_LEN];
#if HAS_DHCPD_IF_INFOMATION_FUNCTION
	uint8_t ifName[DEVNAME_LEN];
#endif
};

struct dhcpOfferedAddr *add_lease(const uint8_t *chaddr, uint32_t yiaddr, unsigned long lease, const char * hostname);
int lease_expired(struct dhcpOfferedAddr *lease);
struct dhcpOfferedAddr *find_lease_by_chaddr(const uint8_t *chaddr);
struct dhcpOfferedAddr *find_lease_by_yiaddr(uint32_t yiaddr);
uint32_t find_address(int check_expired);


/*** static_leases.h ***/

/* Config file will pass static lease info to this function which will add it
 * to a data structure that can be searched later */
int addStaticLease(struct static_lease **lease_struct, uint8_t *mac, uint32_t *ip);
/* Check to see if a mac has an associated static lease */
uint32_t getIpByMac(struct static_lease *lease_struct, void *arg);
/* Check to see if an ip is reserved as a static ip */
uint32_t reservedIp(struct static_lease *lease_struct, uint32_t ip);
/* Print out static leases just to check what's going on (debug code) */
void printStaticLeases(struct static_lease **lease_struct);


/*** serverpacket.h ***/

int sendOffer(struct dhcpMessage *oldpacket);
int sendNAK(struct dhcpMessage *oldpacket);
int sendACK(struct dhcpMessage *oldpacket, uint32_t yiaddr, char * hostname);
int send_inform(struct dhcpMessage *oldpacket);


/*** files.h ***/

int read_config(const char *file);
void write_leases(void);
void read_leases(const char *file);
struct option_set *find_option(struct option_set *opt_list, char code);


#endif
